/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!2Aa\u0001\u0003\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/\tAB+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0016;jYN$Vm\u001d;\u000b\u0005\u00151\u0011!B:u_J,'BA\u0004\t\u0003\u0011!\u0018.\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0011\u0005U\u0001Q\"\u0001\u0003\u0002+Q,7\u000f^&fsB\u000bG\u000f[$f]\u0016\u0014\u0018\r^5p]R\t\u0001\u0004\u0005\u0002\u000e3%\u0011!D\u0004\u0002\u0005+:LG\u000f\u000b\u0002\u00039A\u0011QDJ\u0007\u0002=)\u0011q\u0004I\u0001\u0004CBL'BA\u0011#\u0003\u001dQW\u000f]5uKJT!a\t\u0013\u0002\u000b),h.\u001b;\u000b\u0003\u0015\n1a\u001c:h\u0013\t9cD\u0001\u0003UKN$\b")
public class TierObjectStoreUtilsTest {
    @Test
    public void testKeyPathGeneration() {
        UUID topicId = UUID.fromString("43aeca7f-a684-4b60-bff8-9b3b783691bb");
        String objectIdBase64 = "X01VqsZfTgK0OOTmQrur6g";
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID objectId = CoreUtils$.MODULE$.uuidFromBase64(objectIdBase64);
        SegmentState metadata = new SegmentState(0, objectId, 50L, 50L, 100L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierObjectStore.OpaqueData.ZEROED, 99999L);
        Assertions.assertEquals((Object)"0/X01VqsZfTgK0OOTmQrur6g/Q67Kf6aES2C_-Js7eDaRuw/0/00000000000000000050_0_v0.segment", (Object)new TierObjectStore.ObjectMetadata(topicIdPartition, metadata).toPath("", TierObjectStore.FileType.SEGMENT));
        Assertions.assertEquals((Object)"0/X01VqsZfTgK0OOTmQrur6g/Q67Kf6aES2C_-Js7eDaRuw/0/00000000000000000040_0_v0.epoch-state", (Object)new TierObjectStore.ObjectMetadata(topicIdPartition, new SegmentState(0, objectId, 50L, 40L, 100L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierObjectStore.OpaqueData.ZEROED, 99999L)).toPath("", TierObjectStore.FileType.EPOCH_STATE), (String)"overlapping segment with differing virtual offset to key offset should use correct object store key");
    }
}

