/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogOffsetsListener;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.SegmentDeletion$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t5e\u0001\u0002\u00180\u0001aBQa\u0010\u0001\u0005\u0002\u0001C\u0011b\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001#\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0006\"\u0003,\u0001\u0001\u0004\u0005\t\u0015)\u0003F\u0011\u001d9\u0006\u00011A\u0005\u0004aCqA\u0018\u0001A\u0002\u0013\u0005q\f\u0003\u0004b\u0001\u0001\u0006K!\u0017\u0005\nE\u0002\u0001\r\u00111A\u0005\u0002\rD\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011A5\t\u0013-\u0004\u0001\u0019!A!B\u0013!\u0007b\u00027\u0001\u0005\u0004%\t!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000fU\u0004\u0001\u0019!C\u0001m\"9Q\u0010\u0001a\u0001\n\u0003q\bbBA\u0001\u0001\u0001\u0006Ka\u001e\u0005\n\u0003\u0007\u0001!\u0019!C\u0001\u0003\u000bA\u0001\"!\u0004\u0001A\u0003%\u0011q\u0001\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0003\t\t\u0002C\u0006\u0002 \u0001\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0002bCA\u0013\u0001\u0001\u0007\t\u0011)Q\u0005\u0003'A1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0012!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0016\u0011-\ty\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0005\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0002\u0002CA!\u0001\u0001\u0006I!!\u000e\t\u0013\u0005\r\u0003A1A\u0005\u0002\u0005\u0015\u0003\u0002CA*\u0001\u0001\u0006I!a\u0012\t\u0013\u0005U\u0003A1A\u0005\u0002\u0005]\u0003\u0002CA3\u0001\u0001\u0006I!!\u0017\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005%\u0004\u0002CA<\u0001\u0001\u0006I!a\u001b\t\u0013\u0005e\u0004A1A\u0005\u0002\u0005m\u0004\u0002CAE\u0001\u0001\u0006I!! \t\u000f\u0005-\u0005\u0001\"\u0001\u0002\u000e\"9\u0011\u0011\u0016\u0001\u0005\u0002\u00055\u0005bBAZ\u0001\u0011%\u0011Q\u0017\u0005\b\u0003\u0013\u0004A\u0011BAf\r\u0019\t\u0019\u000f\u0001\u0001\u0002f\"1qH\nC\u0001\u0003\u007fDqA!\u0002'\t\u0003\u00129\u0001C\u0004\u0003.\u0019\"\tEa\f\t\u000f\tE\u0002\u0001\"\u0001\u00034!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B4\u0001\u0011\u0005!\u0011\u000e\u0005\b\u0005g\u0002A\u0011\u0001B;\u0005i\t%o\u00195jm\u0016$\u0016m]6J]R,wM]1uS>tG+Z:u\u0015\t\u0001\u0014'A\u0004be\u000eD\u0017N^3\u000b\u0005I\u001a\u0014!\u0002;bg.\u001c(B\u0001\u001b6\u0003\u0011!\u0018.\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A!\u0011\u0005\t\u0003Q\"A\u0018\u0002\u0011\u0015DXmY;u_J,\u0012!\u0012\t\u0003\r6k\u0011a\u0012\u0006\u0003\u0011&\u000b!bY8oGV\u0014(/\u001a8u\u0015\tQ5*\u0001\u0003vi&d'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d\u001e\u0013q\"\u0012=fGV$xN]*feZL7-Z\u0001\rKb,7-\u001e;pe~#S-\u001d\u000b\u0003#R\u0003\"A\u000f*\n\u0005M[$\u0001B+oSRDq!V\u0002\u0002\u0002\u0003\u0007Q)A\u0002yIE\n\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\u0005\u0015\u001cW#A-\u0011\u0005icV\"A.\u000b\u0005![\u0014BA/\\\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004fG~#S-\u001d\u000b\u0003#\u0002Dq!\u0016\u0004\u0002\u0002\u0003\u0007\u0011,A\u0002fG\u0002\n\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0003\u0011\u0004\"!\u001a4\u000e\u0003MJ!aZ\u001a\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0006;pa&\u001c\u0017\n\u001a)beRLG/[8o?\u0012*\u0017\u000f\u0006\u0002RU\"9Q+CA\u0001\u0002\u0004!\u0017!\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002]B\u0011qN]\u0007\u0002a*\u0011\u0011/N\u0001\bG2,8\u000f^3s\u0013\t\u0019\bOA\u0005QCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\r\r|gNZ5h+\u00059\bC\u0001=|\u001b\u0005I(B\u0001>6\u0003\u0019\u0019XM\u001d<fe&\u0011A0\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$\"!U@\t\u000fUs\u0011\u0011!a\u0001o\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t+\t\t9\u0001E\u0002y\u0003\u0013I1!a\u0003z\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/A\tce>\\WM\u001d+pa&\u001c7\u000b^1ug\u0002\na\u0001^7q\t&\u0014XCAA\n!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\u0017\u0006\u0011\u0011n\\\u0005\u0005\u0003;\t9B\u0001\u0003GS2,\u0017A\u0003;na\u0012K'o\u0018\u0013fcR\u0019\u0011+a\t\t\u0011U\u001b\u0012\u0011!a\u0001\u0003'\tq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\u000bY><G)\u001b:`I\u0015\fHcA)\u0002.!AQKFA\u0001\u0002\u0004\t\u0019\"A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u00115|7m\u001b+j[\u0016,\"!!\u000e\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f6\u0003\u0015)H/\u001b7t\u0013\u0011\ty$!\u000f\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u00023QLWM\u001d)beRLG/[8o'R\fG/\u001a$bGR|'/_\u000b\u0003\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\u001a\u0014!B:uCR,\u0017\u0002BA)\u0003\u0017\u0012\u0011\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ss\u0006QB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r\u0006\u001cGo\u001c:zA\u0005\tB/[3s\u0019><7i\\7q_:,g\u000e^:\u0016\u0005\u0005e\u0003\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}S'A\u0002m_\u001eLA!a\u0019\u0002^\t\tB+[3s\u0019><7i\\7q_:,g\u000e^:\u0002%QLWM\u001d'pO\u000e{W\u000e]8oK:$8\u000fI\u0001\u0013iJ\fgn]5uS>tw+Y5u)&lW-\u0006\u0002\u0002lA!\u0011QNA:\u001b\t\tyGC\u0002\u0002rm\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003k\nyG\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002'Q\u0014\u0018M\\:ji&|gnV1jiRKW.\u001a\u0011\u0002'QLWM\u001d)beRLG/[8o'R\fG/Z:\u0016\u0005\u0005u\u0004C\u0002$\u0002\u0000\u0011\f\u0019)C\u0002\u0002\u0002\u001e\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\tI%!\"\n\t\u0005\u001d\u00151\n\u0002\u0013)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-\u0001\u000buS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002#\"\u001a!%!%\u0011\t\u0005M\u0015QU\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006\u0019\u0011\r]5\u000b\t\u0005m\u0015QT\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\ty*!)\u0002\u000b),h.\u001b;\u000b\u0005\u0005\r\u0016aA8sO&!\u0011qUAK\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001a1%!,\u0011\t\u0005M\u0015qV\u0005\u0005\u0003c\u000b)JA\u0005BMR,'/R1dQ\u0006QBn\\4Qe>4\u0018\u000eZ5oOJ+\u0007\u000f\\5dC6\u000bg.Y4feR1\u0011qWA_\u0003\u007f\u00032\u0001_A]\u0013\r\tY,\u001f\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u0015\u0011G\u00051\u0001e\u0011\u001d\t\t\r\na\u0001\u0003\u0007\f1\"\u00192tiJ\f7\r\u001e'pOB!\u00111LAc\u0013\u0011\t9-!\u0018\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0019GJ,\u0017\r^3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,G\u0003CAB\u0003\u001b\fy-!7\t\u000b\t,\u0003\u0019\u00013\t\u000f\u0005EW\u00051\u0001\u0002T\u0006!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u00042\u0001_Ak\u0013\r\t9.\u001f\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u000f\u0005mW\u00051\u0001\u0002^\u0006y1\r[3dWN,X.\u00128bE2,G\rE\u0002;\u0003?L1!!9<\u0005\u001d\u0011un\u001c7fC:\u0014A#T8dWRKWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148#\u0002\u0014\u0002h\u0006M\b\u0003BAu\u0003_l!!a;\u000b\u0007\u000558*\u0001\u0003mC:<\u0017\u0002BAy\u0003W\u0014aa\u00142kK\u000e$\b\u0003BA{\u0003wl!!a>\u000b\u0007\u0005e8'A\u0003u_BL7-\u0003\u0003\u0002~\u0006](!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3feR\u0011!\u0011\u0001\t\u0004\u0005\u00071S\"\u0001\u0001\u0002\u0017\u0005$G-T3uC\u0012\fG/\u0019\u000b\u0005\u0005\u0013\u0011i\u0002E\u0003G\u0005\u0017\u0011y!C\u0002\u0003\u000e\u001d\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\u0011\tBa\u0006\u000f\t\u0005%#1C\u0005\u0005\u0005+\tY%\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017\u0002\u0002B\r\u00057\u0011A\"\u00119qK:$'+Z:vYRTAA!\u0006\u0002L!9!q\u0004\u0015A\u0002\t\u0005\u0012!B3oiJL\b\u0003\u0002B\u0012\u0005Si!A!\n\u000b\u0007\t\u001d2'\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005W\u0011)C\u0001\u000bBEN$(/Y2u)&,'/T3uC\u0012\fG/Y\u0001\bSN\u0014V-\u00193z)\t\ti.A\fuKN$\u0018I]2iSZ,G+Y:l\u000b6\u0004H/\u001f'pOR\u0019\u0011K!\u000e\t\u000f\u0005m'\u00061\u0001\u0002^\":!F!\u000f\u0003J\t-\u0003\u0003\u0002B\u001e\u0005\u000bj!A!\u0010\u000b\t\t}\"\u0011I\u0001\taJ|g/\u001b3fe*!!1IAM\u0003\u0019\u0001\u0018M]1ng&!!q\tB\u001f\u0005-1\u0016\r\\;f'>,(oY3\u0002\u0011\t|w\u000e\\3b]NdCA!\u0014\u0003Pe\t\u0011!G\u0001\u0001Q\rQ#1\u000b\t\u0005\u0005+\u00129&\u0004\u0002\u0003B%!!\u0011\fB!\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001$i\u0016\u001cH/\u0011:dQ&4X\rV1tWV\u0003Hn\\1egB\u0013x\u000eZ;dKJ\u001cF/\u0019;f)\r\t&q\f\u0005\b\u00037\\\u0003\u0019AAoQ\u001dY#\u0011\bB%\u0005GbCA!\u0014\u0003P!\u001a1Fa\u0015\u0002YQ,7\u000f^!sG\"Lg/\u001a:SKR\u0014\u0018.Z:P]\u000e{gnY;se\u0016tG\u000fR3mKR,'+Z2pe\u0012\u001cHcA)\u0003l!9\u00111\u001c\u0017A\u0002\u0005u\u0007f\u0002\u0017\u0003:\t%#q\u000e\u0017\u0005\u0005\u001b\u0012y\u0005K\u0002-\u0005'\n\u0001\u0006^3ti\u0006\u00138\r[5wKJ,\u0005pY3qi&|gn\u00148QCJ$\u0018\u000e^5p]\u0012+G.\u001a;j_:$2!\u0015B<\u0011\u001d\tY.\fa\u0001\u0003;Ds!\fB\u001d\u0005\u0013\u0012Y\b\f\u0003\u0003N\t=\u0003fA\u0017\u0003T!:\u0001A!!\u0003\b\n%\u0005\u0003BAJ\u0005\u0007KAA!\"\u0002\u0016\n\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\t-\u0015aC5oi\u0016<'/\u0019;j_:\u0004")
public class ArchiveTaskIntegrationTest {
    private ExecutorService executor;
    private ExecutionContext ec = ExecutionContext$.MODULE$.fromExecutorService(this.executor());
    private TopicIdPartition topicIdPartition;
    private final Partition partition = (Partition)Mockito.mock(Partition.class);
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private File tmpDir;
    private File logDir;
    private final MockTime mockTime = new MockTime();
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, this.tierPartitionStateFactory());
    private final FiniteDuration transitionWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private final ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates = new ConcurrentHashMap();

    public ExecutorService executor() {
        return this.executor;
    }

    public void executor_$eq(ExecutorService x$1) {
        this.executor = x$1;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public void ec_$eq(ExecutionContext x$1) {
        this.ec = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public void topicIdPartition_$eq(TopicIdPartition x$1) {
        this.topicIdPartition = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public FiniteDuration transitionWaitTime() {
        return this.transitionWaitTime;
    }

    public ConcurrentHashMap<TopicIdPartition, TierPartitionState> tierPartitionStates() {
        return this.tierPartitionStates;
    }

    @BeforeEach
    public void setup() {
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.executor_$eq(Executors.newFixedThreadPool(1));
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());
        this.topicIdPartition_$eq(new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.executor().shutdownNow();
        this.brokerTopicStats().close();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.tierPartitionStates().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            ArchiveTaskIntegrationTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        this.tierPartitionStates().clear();
        Utils.delete((File)this.tmpDir());
        Utils.delete((File)this.logDir());
    }

    private ReplicaManager logProvidingReplicaManager(TopicIdPartition topicIdPartition, AbstractLog abstractLog) {
        return (ReplicaManager)Mockito.when((Object)((ReplicaManager)Mockito.mock(ReplicaManager.class)).getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)abstractLog)).getMock();
    }

    private TierPartitionState createTierPartitionState(TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean checksumEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(TestUtils$.MODULE$.tempDir(), logDirFailureChannel, topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates().put(topicIdPartition, (TierPartitionState)tierPartitionState);
        return tierPartitionState;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveTaskEmptyLog(boolean checksumEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        int x$1 = 0x500000;
        boolean x$2 = true;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$2, x$13, x$14, x$15, x$16);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        File x$17 = this.logDir();
        BrokerTopicStats x$19 = this.brokerTopicStats();
        MockScheduler x$20 = this.mockTime().scheduler();
        MockTime x$21 = this.mockTime();
        TierLogComponents x$22 = this.tierLogComponents();
        long x$24 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$26 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$9();
        LogOffsetsListener x$28 = LogTestUtils$.MODULE$.createLog$default$12();
        boolean x$29 = LogTestUtils$.MODULE$.createLog$default$13();
        Option<Uuid> x$30 = LogTestUtils$.MODULE$.createLog$default$14();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$15();
        AbstractLog log = LogTestUtils$.MODULE$.createLog(x$17, logConfig, x$19, x$20, (Time)x$21, x$24, x$25, x$26, x$27, x$22, logDirFailureChannel, x$28, x$29, x$30, x$31);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        ArchiveTask nextState = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertTrue((boolean)(nextState.state() instanceof BeforeUpload), (String)"expected to be in BeforeUpload");
        Assertions.assertFalse((boolean)nextState.ctx().isCancelled(), (String)"expected task to not be cancelled");
        Assertions.assertEquals((Integer)tierObjectStore.getObjectCounts().getOrDefault(TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0)), (int)0, (String)"expected zero segments to be uploaded");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiveTaskUploadsProducerState(boolean checksumEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        int x$12 = 1024;
        long x$22 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$122 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$22, x$12, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        File x$17 = this.logDir();
        BrokerTopicStats x$19 = this.brokerTopicStats();
        MockScheduler x$20 = this.mockTime().scheduler();
        MockTime x$21 = this.mockTime();
        TierLogComponents x$222 = this.tierLogComponents();
        long x$24 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$26 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$9();
        LogOffsetsListener x$28 = LogTestUtils$.MODULE$.createLog$default$12();
        boolean x$29 = LogTestUtils$.MODULE$.createLog$default$13();
        Option<Uuid> x$30 = LogTestUtils$.MODULE$.createLog$default$14();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$15();
        AbstractLog log = LogTestUtils$.MODULE$.createLog(x$17, logConfig, x$19, x$20, (Time)x$21, x$24, x$25, x$26, x$27, x$222, logDirFailureChannel, x$28, x$29, x$30, x$31);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        long pid1 = 1L;
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$32 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$34 = 0;
            byte x$36 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$37 = TestUtils$.MODULE$.records$default$3();
            long x$38 = TestUtils$.MODULE$.records$default$7();
            int x$39 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$32, x$36, x$37, pid1, x$34, i, x$38, x$39), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$1.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size(), (String)"expected 5 local log segments");
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size(), (String)"expected 4 tierable segments");
        List snapshotFiles = (List)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toList().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(log.producerStateManager().snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)x$2))), List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)4, (int)snapshotFiles.size(), (String)"expected to be able to use segment base offset to get snapshot files for 4 segments");
        ArchiveTask maybeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload.state().getClass(), (String)"expected successful transition to Upload");
        ArchiveTask maybeAfterUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(AfterUpload.class, maybeAfterUpload.state().getClass(), (String)"expected successful transition to afterUpload");
        ConcurrentHashMap objectCounts = tierObjectStore.getObjectCounts();
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.SEGMENT)), (String)"expected 1 segment file");
        Assertions.assertEquals((int)1, (Integer)((Integer)objectCounts.get(TierObjectStore.FileType.PRODUCER_STATE)), (String)"expected 1 producer state");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)maybeAfterUpload.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, maybeAfterUpload.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime())).state() instanceof BeforeUpload), (String)"expected successful transition to beforeUpload");
        Assertions.assertEquals((int)tierPartitionState.numSegments(), (int)1, (String)"expected 1 segment to be materialized");
        Assertions.assertTrue((boolean)((TierLogSegment)tierPartitionState.metadata(0L).get()).metadata().hasProducerState(), (String)"expected hasProducerState metadata flag to be set");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiverRetriesOnConcurrentDeleteRecords(boolean checksumEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        int x$1 = 1024;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$17 = this.logDir();
        BrokerTopicStats x$19 = this.brokerTopicStats();
        MockScheduler x$20 = this.mockTime().scheduler();
        MockTime x$21 = this.mockTime();
        TierLogComponents x$22 = this.tierLogComponents();
        long x$24 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$26 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$9();
        LogOffsetsListener x$28 = LogTestUtils$.MODULE$.createLog$default$12();
        boolean x$29 = LogTestUtils$.MODULE$.createLog$default$13();
        Option<Uuid> x$30 = LogTestUtils$.MODULE$.createLog$default$14();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$15();
        AbstractLog log = LogTestUtils$.MODULE$.createLog(x$17, logConfig, x$19, x$20, (Time)x$21, x$24, x$25, x$26, x$27, x$22, logDirFailureChannel, x$28, x$29, x$30, x$31);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log);
        Mockito.when((Object)mockReplicaManager.getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)this.partition()));
        Mockito.when((Object)this.partition().log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$32 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$34 = 0;
            byte x$36 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$37 = TestUtils$.MODULE$.records$default$3();
            long x$38 = TestUtils$.MODULE$.records$default$7();
            int x$39 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$32, x$36, x$37, pid1, x$34, i, x$38, x$39), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$2.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        ArchiveTask maybeUpload_1 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        File segmentFileBeingUploaded = ((Upload)maybeUpload_1.state()).uploadableSegment().logSegmentFile();
        Assertions.assertEquals(Upload.class, maybeUpload_1.state().getClass());
        Assertions.assertEquals((Object)segmentFileBeingUploaded, (Object)((LogSegment)log.localLogSegments().head()).log().file());
        LogSegment newFirstSegment = (LogSegment)log.localLogSegments().toList().apply(3);
        File newFirstSegmentFile = newFirstSegment.log().file();
        log.maybeIncrementLogStartOffset(newFirstSegment.baseOffset() + 3L, (LogStartOffsetIncrementReason)SegmentDeletion$.MODULE$);
        log.deleteOldSegments();
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        ArchiveTask maybeUpload_2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(Upload.class, maybeUpload_2.state().getClass());
        Assertions.assertEquals((Object)newFirstSegmentFile, (Object)((Upload)maybeUpload_2.state()).uploadableSegment().logSegmentFile());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testArchiverExceptionOnPartitionDeletion(boolean checksumEnabled) {
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        CancellationContext ctx = CancellationContext.newContext();
        ArchiveTask task = new ArchiveTask(ctx, this.topicIdPartition(), (ArchiveTaskState)new BeforeUpload(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        int leaderEpoch = 0;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        int x$1 = 1024;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        TierPartitionState tierPartitionState = this.createTierPartitionState(this.topicIdPartition(), logDirFailureChannel, checksumEnabled);
        Mockito.when((Object)this.tierPartitionStateFactory().initState(this.logDir(), this.topicIdPartition().topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        MockTierTopicManager tierTopicManager = new MockTierTopicManager();
        File x$17 = this.logDir();
        BrokerTopicStats x$19 = this.brokerTopicStats();
        MockScheduler x$20 = this.mockTime().scheduler();
        MockTime x$21 = this.mockTime();
        TierLogComponents x$22 = this.tierLogComponents();
        long x$24 = LogTestUtils$.MODULE$.createLog$default$6();
        long x$25 = LogTestUtils$.MODULE$.createLog$default$7();
        int x$26 = LogTestUtils$.MODULE$.createLog$default$8();
        int x$27 = LogTestUtils$.MODULE$.createLog$default$9();
        LogOffsetsListener x$28 = LogTestUtils$.MODULE$.createLog$default$12();
        boolean x$29 = LogTestUtils$.MODULE$.createLog$default$13();
        Option<Uuid> x$30 = LogTestUtils$.MODULE$.createLog$default$14();
        boolean x$31 = LogTestUtils$.MODULE$.createLog$default$15();
        AbstractLog log = LogTestUtils$.MODULE$.createLog(x$17, logConfig, x$19, x$20, (Time)x$21, x$24, x$25, x$26, x$27, x$22, logDirFailureChannel, x$28, x$29, x$30, x$31);
        ReplicaManager mockReplicaManager = this.logProvidingReplicaManager(this.topicIdPartition(), log);
        long pid1 = 1L;
        tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), 1));
        LongRef lastOffset = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            .colon.colon x$32 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), new byte[128]), (List)Nil$.MODULE$);
            short x$34 = 0;
            byte x$36 = TestUtils$.MODULE$.records$default$2();
            CompressionType x$37 = TestUtils$.MODULE$.records$default$3();
            long x$38 = TestUtils$.MODULE$.records$default$7();
            int x$39 = TestUtils$.MODULE$.records$default$8();
            LogAppendInfo appendInfo = log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$32, x$36, x$37, pid1, x$34, i, x$38, x$39), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            lastOffset$3.elem = appendInfo.lastOffset();
        });
        log.updateHighWatermark(lastOffset.elem);
        Assertions.assertEquals((int)5, (int)log.localLogSegments().size());
        Assertions.assertEquals((int)4, (int)log.tierableLogSegments().size());
        log.renameDir(Log$.MODULE$.logDeleteDirName(this.topicIdPartition().topicPartition()));
        ArchiveTask maybeBeforeUpload = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition((Time)this.mockTime(), (TierTopicAppender)tierTopicManager, (TierObjectStore)tierObjectStore, mockReplicaManager, task.transition$default$5(), this.ec()), (Duration)this.transitionWaitTime());
        Assertions.assertEquals(BeforeUpload.class, maybeBeforeUpload.state().getClass());
        Predef$.MODULE$.assert(ctx.isCancelled());
        tierPartitionState.delete();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(TierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public class MockTierTopicManager
    implements TierTopicAppender {
        public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
            TierPartitionState tierPartitionState = this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().tierPartitionStates().get(this.kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer().topicIdPartition());
            return FutureConverters.FutureOps$.MODULE$.toJava$extension(FutureConverters$.MODULE$.FutureOps(Future$.MODULE$.successful((Object)tierPartitionState.append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch())))).toCompletableFuture();
        }

        public boolean isReady() {
            return true;
        }

        public /* synthetic */ ArchiveTaskIntegrationTest kafka$tier$tasks$archive$ArchiveTaskIntegrationTest$MockTierTopicManager$$$outer() {
            return ArchiveTaskIntegrationTest.this;
        }

        public MockTierTopicManager() {
            if (ArchiveTaskIntegrationTest.this == null) {
                throw null;
            }
        }
    }
}

