/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.time.Instant;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.log.OffsetIndex;
import kafka.log.ProducerStateManager;
import kafka.log.TimeIndex;
import kafka.log.TransactionIndex;
import kafka.log.UploadableSegment;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001\u0002\u001b6\u0001yBQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004V\u0001\u0001\u0006I!\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0011\u0019\u0001\u0007\u0001)A\u00051\"9\u0011\r\u0001a\u0001\n\u0003\u0011\u0007bB5\u0001\u0001\u0004%\tA\u001b\u0005\u0007a\u0002\u0001\u000b\u0015B2\t\u000fE\u0004\u0001\u0019!C\u0001e\"9\u0011\u0010\u0001a\u0001\n\u0003Q\bB\u0002?\u0001A\u0003&1\u000fC\u0004~\u0001\u0001\u0007I\u0011\u0001@\t\u0013\u0005-\u0001\u00011A\u0005\u0002\u00055\u0001bBA\t\u0001\u0001\u0006Ka \u0005\n\u0003'\u0001\u0001\u0019!C\u0001\u0003+A\u0011\"a\t\u0001\u0001\u0004%\t!!\n\t\u0011\u0005%\u0002\u0001)Q\u0005\u0003/A\u0011\"a\u000b\u0001\u0001\u0004%\t!!\f\t\u0013\u0005%\u0003\u00011A\u0005\u0002\u0005-\u0003\u0002CA(\u0001\u0001\u0006K!a\f\t\u0013\u0005E\u0003\u00011A\u0005\u0002\u0005M\u0003\"CA3\u0001\u0001\u0007I\u0011AA4\u0011!\tY\u0007\u0001Q!\n\u0005U\u0003bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u000f\u0003A\u0011AA8\u0011\u001d\t\t\n\u0001C\u0001\u0003_Bq!a'\u0001\t\u0003\ty\u0007C\u0004\u0002 \u0002!\t!a\u001c\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002p!9\u0011q\u0015\u0001\u0005\u0002\u0005=\u0004bBAV\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003_\u0003A\u0011AA8\u0011\u001d\t\u0019\f\u0001C\u0001\u0003_Bq!a.\u0001\t\u0003\ty\u0007C\u0004\u0002<\u0002!\t!a\u001c\t\u000f\u0005}\u0006\u0001\"\u0001\u0002p!9\u00111\u0019\u0001\u0005\u0002\u0005=\u0004bBAd\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u0017\u0004A\u0011AA8\u0011\u001d\ty\r\u0001C\u0001\u0003_Bq!a5\u0001\t\u0003\ty\u0007C\u0004\u0002X\u0002!\t!a\u001c\t\u000f\u0005m\u0007\u0001\"\u0001\u0002p!9\u0011q\u001c\u0001\u0005\u0002\u0005=\u0004bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u0003<\u0001!IA!\u0010\t\u000f\tU\u0003\u0001\"\u0003\u0003X!9!1\r\u0001\u0005\n\t\u0015$aD!sG\"Lg/\u001a+bg.$Vm\u001d;\u000b\u0005Y:\u0014aB1sG\"Lg/\u001a\u0006\u0003qe\nQ\u0001^1tWNT!AO\u001e\u0002\tQLWM\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\u0004\"AR%\u000e\u0003\u001dS!\u0001S\u001e\u0002\u000f5,GO]5dg&\u0011!j\u0012\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018A\u0002\u001fj]&$h\bF\u0001N!\tq\u0005!D\u00016\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.F\u0001R!\t\u00116+D\u0001:\u0013\t!\u0016H\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006\tBo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0011\u0002!\u0011,g-Y;mi\u0006;\u0018-\u001b;US6,W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005u\u000b\u0015AC2p]\u000e,(O]3oi&\u0011qL\u0017\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003E!WMZ1vYR\fu/Y5u)&lW\rI\u0001\u0004GRDX#A2\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019L\u0014a\u00024fi\u000eDWM]\u0005\u0003Q\u0016\u00141cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqR\fqa\u0019;y?\u0012*\u0017\u000f\u0006\u0002l]B\u0011\u0001\t\\\u0005\u0003[\u0006\u0013A!\u00168ji\"9qnBA\u0001\u0002\u0004\u0019\u0017a\u0001=%c\u0005!1\r\u001e=!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'/F\u0001t!\t!x/D\u0001v\u0015\t1\u0018(A\u0003u_BL7-\u0003\u0002yk\n\u0001B+[3s)>\u0004\u0018nY'b]\u0006<WM]\u0001\u0015i&,'\u000fV8qS\u000el\u0015M\\1hKJ|F%Z9\u0015\u0005-\\\bbB8\u000b\u0003\u0003\u0005\ra]\u0001\u0012i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u0004\u0013a\u0004;jKJ|%M[3diN#xN]3\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bI\u0014!B:u_J,\u0017\u0002BA\u0005\u0003\u0007\u0011q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0014i&,'o\u00142kK\u000e$8\u000b^8sK~#S-\u001d\u000b\u0004W\u0006=\u0001bB8\u000e\u0003\u0003\u0005\ra`\u0001\u0011i&,'o\u00142kK\u000e$8\u000b^8sK\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001em\naa]3sm\u0016\u0014\u0018\u0002BA\u0011\u00037\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fHcA6\u0002(!Aq\u000eEA\u0001\u0002\u0004\t9\"A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003\u000bj!!a\r\u000b\t\u0005U\u0012qG\u0001\u0006kRLGn\u001d\u0006\u0005\u0003s\tY$\u0001\u0004d_6lwN\u001c\u0006\u0004y\u0005u\"\u0002BA \u0003\u0003\na!\u00199bG\",'BAA\"\u0003\ry'oZ\u0005\u0005\u0003\u000f\n\u0019D\u0001\u0003US6,\u0017\u0001\u0003;j[\u0016|F%Z9\u0015\u0007-\fi\u0005\u0003\u0005p'\u0005\u0005\t\u0019AA\u0018\u0003\u0015!\u0018.\\3!\u0003\u001d!X\u000e\u001d$jY\u0016,\"!!\u0016\u0011\t\u0005]\u0013\u0011M\u0007\u0003\u00033RA!a\u0017\u0002^\u0005\u0011\u0011n\u001c\u0006\u0003\u0003?\nAA[1wC&!\u00111MA-\u0005\u00111\u0015\u000e\\3\u0002\u0017Ql\u0007OR5mK~#S-\u001d\u000b\u0004W\u0006%\u0004\u0002C8\u0017\u0003\u0003\u0005\r!!\u0016\u0002\u0011Ql\u0007OR5mK\u0002\nQa]3ukB$\u0012a\u001b\u0015\u00041\u0005M\u0004\u0003BA;\u0003\u0007k!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0004CBL'\u0002BA?\u0003\u007f\nqA[;qSR,'O\u0003\u0003\u0002\u0002\u0006\u0005\u0013!\u00026v]&$\u0018\u0002BAC\u0003o\u0012!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\r\u0002\fB!\u0011QOAG\u0013\u0011\ty)a\u001e\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0007;fgR,5\u000f^1cY&\u001c\b.\u001b8h\u0019\u0016\fG-\u001a:tQ&\u0004\bf\u0001\u000e\u0002\u0016B!\u0011QOAL\u0013\u0011\tI*a\u001e\u0003\tQ+7\u000f^\u0001\u001ci\u0016\u001cH\u000fV5feN+w-\\3oi&sg/\u00197jI\u0016\u0003xn\u00195)\u0007m\t)*\u0001\u000fuKN$X*\u001a;bI\u0006$\u0018mU5{K\u0012+(/\u001b8h+Bdw.\u00193)\u0007q\t)*A\nuKN$(+\u001a;ssB+HoU3h[\u0016tG\u000fK\u0002\u001e\u0003+\u000b1\u0004^3ti6+G/\u00193bi\u0006\u001c\u0016N_3BMR,'/\u00169m_\u0006$\u0007f\u0001\u0010\u0002\u0016\u0006\tC/Z:u\u000bb\u001cW\r\u001d;j_:$UO]5oO&s\u0017\u000e^5bi\u0016,\u0006\u000f\\8bI\"\u001aq$!&\u0002oQ,7\u000f^#yG\u0016\u0004H/[8o\tV\u0014\u0018N\\4J]&$\u0018.\u0019;f+Bdw.\u00193XQ\u0016t\u0007+\u0019:uSRLwN\\%t+:\u001cG.Z1oQ\r\u0001\u0013QS\u00015i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8EkJLgnZ%oSRL\u0017\r^3Va2|\u0017\rZ,iK:$\u0016.\u001a:j]\u001e$\u0015n]1cY\u0016$\u0007fA\u0011\u0002\u0016\u0006qB/Z:u'\u0016<W.\u001a8u\t\u0016dW\r^3e\tV\u0014\u0018N\\4Va2|\u0017\r\u001a\u0015\u0004E\u0005U\u0015\u0001\n;fgR\f%o\u00195jm\u0016$\u0016m]6DC:\u001cW\r\u001c7fI\n+gm\u001c:f+Bdw.\u00193)\u0007\r\n)*\u0001\u0011uKN$XK\\6o_^tW\t_2faRLwN\u001c#ve&tw-\u00169m_\u0006$\u0007f\u0001\u0013\u0002\u0016\u0006IB/Z:u)&,'oU3h[\u0016tGOT8TK\u001elWM\u001c;tQ\r)\u0013QS\u0001'i\u0016\u001cH\u000fV5feN+w-\\3oi^KG\u000f[8vi2+\u0017\rZ3s\u000bB|7\r[*uCR,\u0007f\u0001\u0014\u0002\u0016\u0006\u0019C/Z:u)&,'oU3h[\u0016tGoV5uQ2+\u0017\rZ3s\u000bB|7\r[*uCR,\u0007fA\u0014\u0002\u0016\u0006\u0001C/Z:u\u0003J\u001c\u0007.\u001b<feR\u000b7o[*fiN\u0004\u0016-^:f\u001f:\u0014V\r\u001e:zQ\rA\u0013QS\u0001(i\u0016\u001cHoQ1oG\u0016dG.\u001a3Be\u000eD\u0017N^3UCN\\Gi\\3t\u001d>$\bK]8he\u0016\u001c8\u000fK\u0002*\u0003+\u000b\u0011\u0005^3ti\"\u000bg\u000e\u001a7f'\u0016<W.\u001a8u\t\u0016dW\r^3e\u000bb\u001cW\r\u001d;j_:D3AKAK\u0003Y\"Xm\u001d;IC:$G.\u001b8h\r>\u00148+Z4nK:$H)\u001a7fi\u0016$W\t_2faRLwN\u001c#ve&tw\r\u0016:b]NLG/[8oQ\rY\u0013QS\u0001)i\u0016\u001cHOU3ue&\f'\r\\3Fq\u000e,\u0007\u000f^5p]\u001a+Go\u00195j]\u001e|\u0005/Y9vK\u0012\u000bG/\u0019\u0015\u0004Y\u0005U\u0015a\t;fgRLe.\u001b;jCR,W\u000b\u001d7pC\u0012<\u0016\u000e\u001e5V]\u000edW-\u00198MK\u0006$WM\u001d\u000b\u0005\u0003O\f)\u0010\u0005\u0004\u0002j\u0006-\u0018q^\u0007\u00029&\u0019\u0011Q\u001e/\u0003\r\u0019+H/\u001e:f!\rq\u0015\u0011_\u0005\u0004\u0003g,$\u0001E!sG\"Lg/\u001a+bg.\u001cF/\u0019;f\u0011\u001d\t90\fa\u0001\u0003s\fQ\"\u001e8dY\u0016\fg\u000eT3bI\u0016\u0014\bc\u0001!\u0002|&\u0019\u0011Q`!\u0003\u000f\t{w\u000e\\3b]\u0006IC/Z:u\u000bb\u001cW\r\u001d;j_:D\u0015M\u001c3mS:<G)\u001e:j]\u001eLe.\u001b;jCR,W\u000b\u001d7pC\u0012$B!a:\u0003\u0004!9!Q\u0001\u0018A\u0002\t\u001d\u0011!A3\u0011\t\t%!\u0011\u0004\b\u0005\u0005\u0017\u0011)B\u0004\u0003\u0003\u000e\tMQB\u0001B\b\u0015\r\u0011\t\"P\u0001\u0007yI|w\u000e\u001e \n\u0003\tK1Aa\u0006B\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0007\u0003\u001e\tIQ\t_2faRLwN\u001c\u0006\u0004\u0005/\t\u0015!\t;fgR,\u0005pY3qi&|g\u000eS1oI2Lgn\u001a#ve&tw-\u00169m_\u0006$GCBAt\u0005G\u0011)\u0003C\u0004\u0003\u0006=\u0002\rAa\u0002\t\u000f\t\u001dr\u00061\u0001\u0002z\u0006iA-\u001a7fi\u0016\u001cVmZ7f]R\fa\"\\8dW2{wmU3h[\u0016tG\u000f\u0006\u0003\u0003.\te\u0002\u0003\u0002B\u0018\u0005ki!A!\r\u000b\u0007\tM2(A\u0002m_\u001eLAAa\u000e\u00032\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005E\u0003\u00071\u0001\u0002V\u00051Rn\\2l)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0003@\t-\u0003\u0003\u0002B!\u0005\u000fj!Aa\u0011\u000b\u0007\t\u0015\u0013(A\u0003ti\u0006$X-\u0003\u0003\u0003J\t\r#A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016DqA!\u00142\u0001\u0004\u0011y%A\u0006mK\u0006$WM]#q_\u000eD\u0007c\u0001!\u0003R%\u0019!1K!\u0003\u0007%sG/A\bn_\u000e\\\u0017IY:ue\u0006\u001cG\u000fT8h)\u0011\u0011IFa\u0018\u0011\t\t=\"1L\u0005\u0005\u0005;\u0012\tDA\u0006BEN$(/Y2u\u0019><\u0007b\u0002B1e\u0001\u0007!QF\u0001\u000bY><7+Z4nK:$\u0018a\u0003;jKJ\u001cVmZ7f]R$bAa\u001a\u0003t\tU\u0004\u0003\u0002B5\u0005_j!Aa\u001b\u000b\u0007\t5\u0014(\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0005c\u0012YG\u0001\nUS\u0016\u0014xJ\u00196fGRlU\r^1eCR\f\u0007b\u0002B\u001ag\u0001\u0007!\u0011\f\u0005\b\u0005\u001b\u001a\u0004\u0019\u0001B(\u0001")
public class ArchiveTaskTest
implements KafkaMetricsGroup {
    private final TopicIdPartition topicIdPartition;
    private final FiniteDuration defaultAwaitTime;
    private CancellationContext ctx;
    private TierTopicManager tierTopicManager;
    private TierObjectStore tierObjectStore;
    private ReplicaManager replicaManager;
    private Time time;
    private File tmpFile;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public FiniteDuration defaultAwaitTime() {
        return this.defaultAwaitTime;
    }

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public TierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(TierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public Time time() {
        return this.time;
    }

    public void time_$eq(Time x$1) {
        this.time = x$1;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    public void tmpFile_$eq(File x$1) {
        this.tmpFile = x$1;
    }

    @BeforeEach
    public void setup() {
        this.tmpFile_$eq(TestUtils$.MODULE$.tempFile());
    }

    @AfterEach
    public void tearDown() {
        this.tmpFile().delete();
        this.ctx().cancel();
        Mockito.reset((Object[])new Object[]{this.tierTopicManager(), this.tierObjectStore(), this.replicaManager()});
    }

    @Test
    public void testEstablishingLeadership() {
        int leaderEpoch = 0;
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        BeforeUpload nextState = (BeforeUpload)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)new BeforeUpload(leaderEpoch), (Object)nextState, (String)"Expected task to establish leadership");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.NOT_TIERABLE));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed(new Object()));
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), this.topicIdPartition(), (TierTopicAppender)this.tierTopicManager(), 1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected establishing leadership to fail");
    }

    @Test
    public void testTierSegmentInvalidEpoch() {
        int leaderEpoch = 0;
        TierPartitionState tps = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch + 1))).getMock();
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tps);
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((Try)((Future)Await$.MODULE$.ready((Awaitable)nextState, (Duration)this.defaultAwaitTime())).value().get()).isFailure(), (String)"Expected segment tiering to fail due to fencing");
    }

    @Test
    public void testMetadataSizeDuringUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), true, true, true, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        int epochStateSize = 100;
        long producerStateSize = 2000000000L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = (File)Mockito.mock(File.class);
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)producerState.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)producerState.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)producerStateSize));
        ((TierObjectStore)Mockito.doNothing().when((Object)this.tierObjectStore())).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
    }

    @Test
    public void testRetryPutSegment() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), true, true, true, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        MockInMemoryTierObjectStore inMemoryTierObjectStore = new MockInMemoryTierObjectStore(this.time(), null);
        int epochStateSize = 100;
        long producerStateSize = 0L;
        int abortedTxnsLimit = 150;
        int abortedTxnsPos = 50;
        long expectedSize = (long)(logSegment.size() + epochStateSize) + producerStateSize + (long)(abortedTxnsLimit - abortedTxnsPos);
        ByteBuffer epochState = ByteBuffer.wrap(new byte[epochStateSize]);
        File producerState = this.tmpFile();
        ByteBuffer abortedTxns = ByteBuffer.wrap(new byte[abortedTxnsLimit]);
        abortedTxns.limit(abortedTxnsLimit);
        abortedTxns.position(abortedTxnsPos);
        Some epochStateOpt = new Some((Object)epochState);
        Some producerStateOpt = new Some((Object)producerState);
        Some abortedTxnsOpt = new Some((Object)abortedTxns);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value");
        Assertions.assertTrue((afterUpload.uploadedSize() > 0L ? 1 : 0) != 0, (String)"metadata size of AfterUpload object is negative and overflowed");
        Assertions.assertEquals((int)abortedTxnsPos, (int)abortedTxns.position());
        Assertions.assertEquals((int)0, (int)epochState.position());
        UploadableSegment uploadableSegment2 = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)producerStateOpt, (Option)epochStateOpt, (Option)abortedTxnsOpt);
        Upload upload2 = new Upload(leaderEpoch, uploadInitiate, uploadableSegment2);
        Future uploadResult2 = ArchiveTask$.MODULE$.upload(upload2, this.topicIdPartition(), this.time(), this.ctx(), (TierObjectStore)inMemoryTierObjectStore, ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload2 = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult2, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)expectedSize, (long)afterUpload2.uploadedSize(), (String)"metadata size of AfterUpload object is incorrect value after second retried upload");
    }

    @Test
    public void testMetadataSizeAfterUpload() {
        int testUploadSize = 400;
        String metricName = "BytesPerSec";
        this.removeMetric(metricName, this.removeMetric$default$2());
        Meter byteRate = this.newMeter(metricName, "bytes per second", TimeUnit.SECONDS, this.newMeter$default$4());
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), true, true, true, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        AfterUpload afterUpload = new AfterUpload(0, uploadInitiate, (long)testUploadSize);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)new Some((Object)byteRate), ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((long)testUploadSize, (long)byteRate.count(), (String)"tier archiver mean rate shows no data uploaded to tiered storage");
    }

    @Test
    public void testExceptionDuringInitiateUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringInitiateUpload(new IllegalStateException("illegal state"));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenPartitionIsUnclean() {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(true), (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(66).append("Unexpected transition to next state ").append(state.toString()).append(" when partition needs recovery").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        }
        if (!(try_ instanceof Failure)) {
            throw new MatchError((Object)try_);
        }
        Throwable ex = ((Failure)try_).exception();
        Assertions.assertEquals(TierMetadataRetriableException.class, ex.getClass(), (String)"Unexpected exception");
        Assertions.assertTrue((boolean)ex.getMessage().contains("is undergoing unclean leader recovery"), (String)"Unexpected cause for exception");
        Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result(this.testInitiateUploadWithUncleanLeader(false), (Duration)this.defaultAwaitTime()));
        if (try_2 instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_2).value();
            Assertions.assertEquals(Upload.class, state.getClass(), (String)"Unexpected next state");
            return;
        }
        if (try_2 instanceof Failure) {
            Throwable ex2 = ((Failure)try_2).exception();
            throw Assertions$.MODULE$.fail(new StringBuilder(21).append("Unexpected exception ").append(ex2).toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
        }
        throw new MatchError((Object)try_2);
    }

    @Test
    public void testExceptionDuringInitiateUploadWhenTieringDisabled() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Future maybeInitUploadState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)maybeInitUploadState, (Duration)this.defaultAwaitTime()));
        if (try_ instanceof Success) {
            ArchiveTaskState state = (ArchiveTaskState)((Success)try_).value();
            throw Assertions$.MODULE$.fail(new StringBuilder(72).append("Unexpected transition to next state ").append(state.toString()).append(" when partition has tiering disabled").toString(), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            Assertions.assertEquals(NotTierablePartitionException.class, ex.getClass(), (String)"Unexpected exception");
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Test
    public void testSegmentDeletedDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new NoSuchFileException("segment deleted"), true);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
    }

    @Test
    public void testArchiveTaskCancelledBeforeUpload() {
        int leaderEpoch = 0;
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), false, false, false, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.ctx().cancel();
        Future nextState = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (AfterUpload)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(TierArchiverFencedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
    }

    @Test
    public void testUnknownExceptionDuringUpload() {
        Future<ArchiveTaskState> nextState = this.testExceptionHandlingDuringUpload(new IllegalStateException("illegal state"), false);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
    }

    @Test
    public void testTierSegmentNoSegments() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AbstractLog emptyLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)emptyLog.tierableLogSegments()).thenReturn(CollectionConverters$.MODULE$.asScalaBufferConverter(Collections.emptyList()).asScala()).getMock();
        Partition partition = (Partition)Mockito.when((Object)((Partition)Mockito.mock(Partition.class)).log()).thenReturn((Object)new Some((Object)emptyLog)).getMock();
        Mockito.when((Object)emptyLog.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)emptyLog));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Future nextState = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)nextState, (Duration)this.defaultAwaitTime()) instanceof BeforeUpload), (String)"Expected segment tiering to complete successfully, but not progress to AfterUpload");
    }

    @Test
    public void testTierSegmentWithoutLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)None$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        TierObjectMetadata metadata = this.tierSegment(log, leaderEpoch);
        Assertions.assertEquals((long)metadata.baseOffset(), (long)0L, (String)"expected start offset to be 0");
        Assertions.assertEquals((long)metadata.endOffset(), (long)9L, (String)"expected end offset to be 9");
    }

    @Test
    public void testTierSegmentWithLeaderEpochState() {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = this.mockTierPartitionState(leaderEpoch);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(0L, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        byte[] epochArray = new byte[100];
        LeaderEpochFileCache mockLeaderEpochCache = (LeaderEpochFileCache)Mockito.mock(LeaderEpochFileCache.class);
        Mockito.when((Object)mockLeaderEpochCache.snapshotForSegment(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)epochArray);
        long nextOffset = logSegment.readNextOffset();
        ((LeaderEpochFileCache)Mockito.doNothing().when((Object)mockLeaderEpochCache)).truncateFromEnd(nextOffset);
        AbstractLog log = this.mockAbstractLog(logSegment);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)new Some((Object)mockLeaderEpochCache));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)Nil$.MODULE$);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadComplete.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)new Some((Object)ByteBuffer.wrap(epochArray)), (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Assertions.assertTrue((boolean)this.tierSegment(log, leaderEpoch).hasEpochState(), (String)"expected metadata to claim to have epoch state");
        ((TierObjectStore)Mockito.verify((Object)this.tierObjectStore(), (VerificationMode)Mockito.times((int)1))).putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (File)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull(), (Optional)ArgumentMatchers.notNull());
    }

    @Test
    public void testArchiverTaskSetsPauseOnRetry() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenThrow(new Throwable[]{new TierMetadataRetriableException("something"), new TierObjectStoreRetriableException("foo", (Throwable)new RuntimeException("foo"))});
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Instant pauseTime = (Instant)result.pausedUntil().get();
        this.time().sleep(100L);
        ArchiveTask result2 = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertTrue((boolean)result2.pausedUntil().isDefined(), (String)"expected the task to be paused");
        Assertions.assertFalse((boolean)this.ctx().isCancelled(), (String)"expected the task to not be canceled");
        Assertions.assertTrue((boolean)((Instant)result2.pausedUntil().get()).isAfter(pauseTime), (String)"expected the second pause time to be larger than the first");
    }

    @Test
    public void testCancelledArchiveTaskDoesNotProgress() {
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)new BeforeLeader(0), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        this.ctx().cancel();
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime())).state() instanceof BeforeLeader), (String)"expected task to remain in BeforeLeader");
    }

    @Test
    public void testHandleSegmentDeletedException() {
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        BeforeLeader beforeLeader = new BeforeLeader(0);
        BeforeUpload beforeUpload = new BeforeUpload(0);
        Upload upload = new Upload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), (UploadableSegment)Mockito.mock(UploadableSegment.class));
        AfterUpload afterUpload = new AfterUpload(0, (TierSegmentUploadInitiate)Mockito.mock(TierSegmentUploadInitiate.class), 0L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> beforeLeader.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        Assertions.assertEquals(BeforeUpload.class, (Object)beforeUpload.handleSegmentDeletedException(exception).getClass());
        Assertions.assertEquals(BeforeUpload.class, (Object)upload.handleSegmentDeletedException(exception).getClass());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> afterUpload.handleSegmentDeletedException(exception), ClassTag$.MODULE$.apply(ArchiveTask.SegmentDeletedException.class), new Position("ArchiveTaskTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
    }

    @Test
    public void testHandlingForSegmentDeletedExceptionDuringTransition() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        ArchiveTask.SegmentDeletedException exception = new ArchiveTask.SegmentDeletedException("segment deleted", (Throwable)new Exception());
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenThrow(new Throwable[]{exception});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.defaultAwaitTime());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    @Test
    public void testRetriableExceptionFetchingOpaqueData() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierPartitionState tierPartitionState = this.mockTierPartitionState(42);
        TierObjectStore throwingTierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)throwingTierObjectStore.prepPutSegment()).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("key fetch error")});
        BeforeUpload beforeUpload = new BeforeUpload(42);
        ArchiveTask task = new ArchiveTask(this.ctx(), this.topicIdPartition(), (ArchiveTaskState)beforeUpload, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        ArchiveTask result = (ArchiveTask)Await$.MODULE$.result((Awaitable)task.transition(this.time(), (TierTopicAppender)this.tierTopicManager(), throwingTierObjectStore, this.replicaManager(), task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second());
        Assertions.assertEquals((Object)result.state(), (Object)beforeUpload);
        Assertions.assertEquals((int)result.retryCount(), (int)1);
    }

    private Future<ArchiveTaskState> testInitiateUploadWithUncleanLeader(boolean uncleanLeader) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeader));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)Nil$.MODULE$);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, 100L, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenReturn((Object)uploadableSegment);
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any(TierSegmentUploadInitiate.class))).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringInitiateUpload(Exception e) {
        int leaderEpoch = 0;
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        LogSegment logSegment = this.mockLogSegment(this.tmpFile());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = this.mockAbstractLog(logSegment);
        ProducerStateManager mockProducerStateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
        Mockito.when((Object)this.replicaManager().getLog(this.topicIdPartition().topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.topicIdPartition().topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        Mockito.when((Object)log.collectAbortedTransactions(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenThrow(new Throwable[]{e});
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.producerStateManager()).thenReturn((Object)mockProducerStateManager);
        Mockito.when((Object)mockProducerStateManager.snapshotFileForOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.createUploadableSegment(logSegment)).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<ArchiveTaskState> testExceptionHandlingDuringUpload(Exception e, boolean deleteSegment) {
        int leaderEpoch = 0;
        File fileToUse = this.tmpFile();
        if (deleteSegment) {
            fileToUse = (File)Mockito.mock(File.class);
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fileToUse.exists())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        LogSegment logSegment = this.mockLogSegment(fileToUse);
        AbstractLog log = this.mockAbstractLog(logSegment);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(this.topicIdPartition(), leaderEpoch, UUID.randomUUID(), logSegment.baseOffset(), logSegment.readNextOffset() - 1L, logSegment.maxTimestampSoFar(), logSegment.size(), false, false, false, new OffsetAndEpoch(0L, Optional.empty()), TierObjectStore.OpaqueData.fromByteArray((byte[])"test".getBytes()));
        UploadableSegment uploadableSegment = new UploadableSegment(log, logSegment, logSegment.readNextOffset(), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
        Upload upload = new Upload(leaderEpoch, uploadInitiate, uploadableSegment);
        this.tierObjectStore().putSegment((TierObjectStore.ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{e});
        return ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
    }

    private LogSegment mockLogSegment(File tmpFile) {
        OffsetIndex offsetIndex = (OffsetIndex)Mockito.mock(OffsetIndex.class);
        Mockito.when((Object)offsetIndex.file()).thenReturn((Object)tmpFile);
        TimeIndex timeIndex = (TimeIndex)Mockito.mock(TimeIndex.class);
        Mockito.when((Object)timeIndex.file()).thenReturn((Object)tmpFile);
        TransactionIndex txnIndex = (TransactionIndex)Mockito.mock(TransactionIndex.class);
        Mockito.when((Object)txnIndex.file()).thenReturn((Object)tmpFile);
        FileRecords fileRecords = (FileRecords)Mockito.mock(FileRecords.class);
        Mockito.when((Object)fileRecords.file()).thenReturn((Object)tmpFile);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.readNextOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)10L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.baseOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)logSegment.largestTimestamp())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1000));
        Mockito.when((Object)logSegment.log()).thenReturn((Object)fileRecords);
        Mockito.when((Object)logSegment.offsetIndex()).thenReturn((Object)offsetIndex);
        Mockito.when((Object)logSegment.timeIndex()).thenReturn((Object)timeIndex);
        Mockito.when((Object)logSegment.txnIndex()).thenReturn((Object)txnIndex);
        return logSegment;
    }

    private TierPartitionState mockTierPartitionState(int leaderEpoch) {
        return (TierPartitionState)Mockito.when((Object)BoxesRunTime.boxToInteger((int)((TierPartitionState)Mockito.mock(TierPartitionState.class)).tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)).getMock();
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockAbstractLog(LogSegment logSegment) {
        void var2_2;
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$));
        return var2_2;
    }

    private TierObjectMetadata tierSegment(AbstractLog log, int leaderEpoch) {
        Future beforeUploadResult = ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(leaderEpoch), this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), this.tierObjectStore(), this.replicaManager(), ExecutionContext.Implicits$.MODULE$.global());
        Upload upload = (Upload)Await$.MODULE$.result((Awaitable)beforeUploadResult, (Duration)this.defaultAwaitTime());
        Future uploadResult = ArchiveTask$.MODULE$.upload(upload, this.topicIdPartition(), this.time(), this.ctx(), this.tierObjectStore(), ExecutionContext.Implicits$.MODULE$.global());
        AfterUpload afterUpload = (AfterUpload)Await$.MODULE$.result((Awaitable)uploadResult, (Duration)this.defaultAwaitTime());
        Future afterUploadResult = ArchiveTask$.MODULE$.finalizeUpload(afterUpload, this.topicIdPartition(), this.time(), (TierTopicAppender)this.tierTopicManager(), (Option)None$.MODULE$, ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)afterUploadResult, (Duration)this.defaultAwaitTime());
        TierSegmentUploadInitiate uploadInitiate = upload.uploadInitiate();
        return new TierObjectMetadata(uploadInitiate.topicIdPartition(), uploadInitiate.tierEpoch(), uploadInitiate.objectId(), uploadInitiate.baseOffset(), uploadInitiate.endOffset(), uploadInitiate.maxTimestamp(), uploadInitiate.size(), TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, uploadInitiate.hasEpochState(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), TierObjectStore.OpaqueData.ZEROED);
    }

    public ArchiveTaskTest() {
        Logging.$init$((Logging)this);
        KafkaMetricsGroup.$init$((KafkaMetricsGroup)this);
        this.topicIdPartition = new TopicIdPartition("foo", UUID.fromString("cbf4eaed-cc00-47dc-b08c-f1f5685f085d"), 0);
        this.defaultAwaitTime = new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds();
        this.ctx = CancellationContext.newContext();
        this.tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        this.tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        this.replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.time = new MockTime();
        this.tmpFile = TestUtils$.MODULE$.tempFile();
    }
}

