/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import java.io.Serializable;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\f\u0018\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019a\u0004\u0001)A\u0005m!9Q\b\u0001b\u0001\n\u0013q\u0004BB)\u0001A\u0003%q\bC\u0004S\u0001\t\u0007I\u0011B*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003y\u0006\"\u00029\u0001\t\u0003y\u0006\"\u0002:\u0001\t\u0003y\u0006\"\u0002;\u0001\t\u0003y\u0006\"\u0002<\u0001\t\u0003y\u0006\"\u0002=\u0001\t\u0013I\bBB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\f\u0001!I!!\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\"!F!sG\"Lg/\u001a:UCN\\\u0017+^3vKR+7\u000f\u001e\u0006\u00031e\tq!\u0019:dQ&4XM\u0003\u0002\u001b7\u0005)A/Y:lg*\u0011A$H\u0001\u0005i&,'OC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\tq#A\u0002dib,\u0012!\f\t\u0003]Ej\u0011a\f\u0006\u0003am\tqAZ3uG\",'/\u0003\u00023_\t\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u0006!1\r\u001e=!\u0003\u0011!\u0018.\\3\u0016\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR!!O\u000f\u0002\u000bU$\u0018\u000e\\:\n\u0005mB$\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\r1\fw-T1q+\u0005y\u0004\u0003\u0002!F\u000f.k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bq!\\;uC\ndWM\u0003\u0002EG\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0019\u000b%aA'baB\u0011\u0001*S\u0007\u00027%\u0011!j\u0007\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042A\t'O\u0013\ti5E\u0001\u0004PaRLwN\u001c\t\u0003E=K!\u0001U\u0012\u0003\t1{gnZ\u0001\bY\u0006<W*\u00199!\u0003!i\u0017\r\u001f+bg.\u001cX#\u0001+\u0011\u0005\t*\u0016B\u0001,$\u0005\rIe\u000e^\u0001\n[\u0006DH+Y:lg\u0002\n\u0011#\u0019:dQ&4XM\u001d+bg.\fV/Z;f+\u0005Q\u0006C\u0001\u0016\\\u0013\tavCA\tBe\u000eD\u0017N^3s)\u0006\u001c8.U;fk\u0016\f!#\u0019:dQ&4XM\u001d+bg.\fV/Z;fA\u0005qA/Z:u%\u0016lwN^3UCN\\G#\u00011\u0011\u0005\t\n\u0017B\u00012$\u0005\u0011)f.\u001b;)\u00051!\u0007CA3o\u001b\u00051'BA4i\u0003\r\t\u0007/\u001b\u0006\u0003S*\fqA[;qSR,'O\u0003\u0002lY\u0006)!.\u001e8ji*\tQ.A\u0002pe\u001eL!a\u001c4\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cH\u000fU8mYR\u000b7o[(sI\u0016\u0014\u0018N\\4)\u00055!\u0017\u0001\u0007;fgR\u0004v\u000e\u001c7UCN\\7\u000fT3tgRC\u0017M\\'bq\"\u0012a\u0002Z\u0001\fi\u0016\u001cHOW3s_2\u000bw\r\u000b\u0002\u0010I\u0006YB/Z:u\u0003\u0012$'+\u001a9mC\u000e,7/\u0012=jgRLgn\u001a+bg.D#\u0001\u00053\u0002\u000b1\fwM\u00128\u0015\u0005-S\b\"B>\u0012\u0001\u0004a\u0018\u0001\u0002;bg.\u0004\"AK?\n\u0005y<\"aC!sG\"Lg/\u001a+bg.\f\u0011\"\u001e9eCR,G*Y4\u0015\u000b\u0001\f\u0019!a\u0002\t\r\u0005\u0015!\u00031\u0001H\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002\nI\u0001\rAT\u0001\u0004Y\u0006<\u0017A\u00067bON{'\u000f^3e\u000b2Lw-\u001b2mKR\u000b7o[:\u0016\u0005\u0005=\u0001#BA\t\u0003C9e\u0002BA\n\u0003;qA!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033y\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\r\tybI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019#!\n\u0003\t1K7\u000f\u001e\u0006\u0004\u0003?\u0019\u0013aB1eIR\u000b7o\u001b\u000b\u0006A\u0006-\u0012Q\u0006\u0005\u0007\u0003\u000b!\u0002\u0019A$\t\r\u0005=B\u00031\u0001U\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0002\u0015I,Wn\u001c<f)\u0006\u001c8\u000eF\u0002a\u0003kAa!!\u0002\u0016\u0001\u00049\u0005")
public class ArchiverTaskQueueTest {
    private final CancellationContext ctx = CancellationContext.newContext();
    private final MockTime time = new MockTime();
    private final Map<TopicIdPartition, Option<Object>> lagMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int maxTasks;
    private final ArchiverTaskQueue archiverTaskQueue = new ArchiverTaskQueue(this.ctx(), this.maxTasks(), (Time)this.time(), (Function1 & Serializable & scala.Serializable)task -> this.lagFn((ArchiveTask)task), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);

    private CancellationContext ctx() {
        return this.ctx;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<TopicIdPartition, Option<Object>> lagMap() {
        return this.lagMap;
    }

    private int maxTasks() {
        return this.maxTasks;
    }

    private ArchiverTaskQueue archiverTaskQueue() {
        return this.archiverTaskQueue;
    }

    @Test
    public void testRemoveTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.removeTask(partition_1);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveTask$1(partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
        this.removeTask(partition_3);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testRemoveTask$3(partition_2, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPollTaskOrdering() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 10L);
        this.updateLag(partition_3, 1L);
        this.updateLag(partition_4, 15L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        List tasks = (List)this.archiverTaskQueue().poll().get();
        Assertions.assertEquals((Object)this.lagSortedEligibleTasks().take(this.maxTasks()), (Object)((List)tasks.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.topicIdPartition(), List$.MODULE$.canBuildFrom())).toList());
    }

    @Test
    public void testPollTasksLessThanMax() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 5L);
        this.updateLag(partition_2, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_1})), (Object)((TraversableOnce)((List)this.archiverTaskQueue().poll().get()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.topicIdPartition(), List$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testZeroLag() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.updateLag(partition_1, 0L);
        this.updateLag(partition_2, 0L);
        this.updateLag(partition_3, 0L);
        this.updateLag(partition_4, 0L);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.archiverTaskQueue().poll());
    }

    @Test
    public void testAddReplacesExistingTask() {
        TopicIdPartition partition_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition partition_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TopicIdPartition partition_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TopicIdPartition partition_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        this.addTask(partition_1, 0);
        this.addTask(partition_2, 0);
        this.addTask(partition_3, 0);
        this.addTask(partition_4, 0);
        this.addTask(partition_1, 1);
        this.addTask(partition_3, 2);
        this.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> {
            ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$1(partition_1, partition_2, partition_3, partition_4, tasks);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Object> lagFn(ArchiveTask task) {
        return (Option)this.lagMap().apply((Object)task.topicIdPartition());
    }

    private void updateLag(TopicIdPartition topicIdPartition, long lag) {
        this.lagMap().update((Object)topicIdPartition, (Object)new Some((Object)BoxesRunTime.boxToLong((long)lag)));
    }

    private List<TopicIdPartition> lagSortedEligibleTasks() {
        return (List)((List)((TraversableLike)((SeqLike)this.lagMap().toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
            Option lag = (Option)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, lag.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)ArchiverTaskQueueTest.$anonfun$lagSortedEligibleTasks$3(x0$2)), (Ordering)Ordering.Long$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$lagSortedEligibleTasks$4(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            void var1_1;
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$4._1();
            return var1_1;
        }, List$.MODULE$.canBuildFrom());
    }

    private void addTask(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.archiverTaskQueue().maybeAddTask((StartChangeMetadata)new StartLeadership(topicIdPartition, leaderEpoch));
    }

    private void removeTask(TopicIdPartition topicIdPartition) {
        this.archiverTaskQueue().maybeRemoveTask((StopChangeMetadata)new StopLeadership(topicIdPartition));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$1(TopicIdPartition partition_2$1, TopicIdPartition partition_3$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$1, partition_3$1, partition_4$1})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ void $anonfun$testRemoveTask$3(TopicIdPartition partition_2$1, TopicIdPartition partition_4$1, Set tasks) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{partition_2$1, partition_4$1})), (Object)tasks.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicIdPartition(), Set$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$2(TopicIdPartition partition_1$1, ArchiveTask x$5) {
        TopicIdPartition topicIdPartition = x$5.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_1$1) : partition_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$3(TopicIdPartition partition_2$2, ArchiveTask x$6) {
        TopicIdPartition topicIdPartition = x$6.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_2$2) : partition_2$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$4(TopicIdPartition partition_3$2, ArchiveTask x$7) {
        TopicIdPartition topicIdPartition = x$7.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_3$2) : partition_3$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAddReplacesExistingTask$5(TopicIdPartition partition_4$2, ArchiveTask x$8) {
        TopicIdPartition topicIdPartition = x$8.topicIdPartition();
        return !(topicIdPartition != null ? !topicIdPartition.equals(partition_4$2) : partition_4$2 != null);
    }

    public static final /* synthetic */ void $anonfun$testAddReplacesExistingTask$1(TopicIdPartition partition_1$1, TopicIdPartition partition_2$2, TopicIdPartition partition_3$2, TopicIdPartition partition_4$2, Set tasks) {
        Assertions.assertEquals((int)1, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$2(partition_1$1, x$5))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$3(partition_2$2, x$6))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)2, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$4(partition_3$2, x$7))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)0, (int)((ArchiveTask)tasks.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchiverTaskQueueTest.$anonfun$testAddReplacesExistingTask$5(partition_4$2, x$8))).get()).state().leaderEpoch());
        Assertions.assertEquals((int)4, (int)tasks.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$lagSortedEligibleTasks$3(Tuple2 x0$2) {
        void var1_1;
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        long lag = x0$2._2$mcJ$sp();
        return (long)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$lagSortedEligibleTasks$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$3._2$mcJ$sp() != 0L;
        return bl;
    }

    public ArchiverTaskQueueTest() {
        this.maxTasks = 3;
    }
}

