/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.exceptions.TierArchiverRestoreFencedException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tasks.CompletableFutureUtil$;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTask$;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u001a5\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015C\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011A%\t\u0013A\u0003\u0001\u0019!a\u0001\n\u0003\t\u0006\"C,\u0001\u0001\u0004\u0005\t\u0015)\u0003K\u0011\u001dA\u0006A1A\u0005\u0002eCa\u0001\u0019\u0001!\u0002\u0013Q\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007W\u0002\u0001\u000b\u0011B2\t\u000f1\u0004!\u0019!C\u0001[\"1\u0011\u000f\u0001Q\u0001\n9DqA\u001d\u0001C\u0002\u0013\u00051\u000f\u0003\u0004{\u0001\u0001\u0006I\u0001\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t9\u0001\u0001Q\u0001\nuD\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u001bA\u0011\"!\u0006\u0001\u0005\u0004%\t!a\u0006\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u00033A\u0011\"a\n\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005]\u0002\u0001)A\u0005\u0003WA\u0011\"!\u000f\u0001\u0001\u0004%\t!a\u000f\t\u0013\u0005%\u0003\u00011A\u0005\u0002\u0005-\u0003\u0002CA(\u0001\u0001\u0006K!!\u0010\t\u0013\u0005E\u0003A1A\u0005\u0002\u0005M\u0003\u0002CA1\u0001\u0001\u0006I!!\u0016\t\u0013\u0005\r\u0004A1A\u0005\u0002\u0005\u0015\u0004\u0002CA8\u0001\u0001\u0006I!a\u001a\t\u0013\u0005E\u0004A1A\u0005\u0002\u0005M\u0004\u0002CAA\u0001\u0001\u0006I!!\u001e\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAP\u0001\u0001\u0006I!a\"\t\u0013\u0005\u0005\u0006A1A\u0005\u0002\u0005\r\u0006\u0002CAZ\u0001\u0001\u0006I!!*\t\u0017\u0005U\u0006\u00011AA\u0002\u0013\u0005\u0011q\u0017\u0005\f\u0003#\u0004\u0001\u0019!a\u0001\n\u0003\t\u0019\u000eC\u0006\u0002X\u0002\u0001\r\u0011!Q!\n\u0005e\u0006bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003g\u0004A\u0011AAn\u0011\u001d\ti\u0010\u0001C\u0001\u00037DqAa\u0002\u0001\t\u0003\tY\u000eC\u0004\u0003\f\u0001!\t!a7\t\u000f\t=\u0001\u0001\"\u0001\u0002\\\"9!1\u0003\u0001\u0005\u0002\u0005m\u0007b\u0002B\f\u0001\u0011\u0005\u00111\u001c\u0005\b\u00057\u0001A\u0011AAn\u0011\u001d\u0011y\u0002\u0001C\u0001\u00037DqAa\t\u0001\t\u0003\tY\u000eC\u0004\u0003(\u0001!\t!a7\t\u000f\t-\u0002\u0001\"\u0001\u0002\\\"9!q\u0006\u0001\u0005\n\tE\"!\u0006+jKJ\f%o\u00195jm\u0016\u00148\u000b^1uKR+7\u000f\u001e\u0006\u0003kY\nq!\u0019:dQ&4XM\u0003\u00028q\u0005)A/Y:lg*\u0011\u0011HO\u0001\u0005i&,'OC\u0001<\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\t\u0005\u0002H\u00015\tA'A\u0002dib,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bb\nqAZ3uG\",'/\u0003\u0002P\u0019\n\u00192)\u00198dK2d\u0017\r^5p]\u000e{g\u000e^3yi\u000691\r\u001e=`I\u0015\fHC\u0001*V!\ty4+\u0003\u0002U\u0001\n!QK\\5u\u0011\u001d16!!AA\u0002)\u000b1\u0001\u001f\u00132\u0003\u0011\u0019G\u000f\u001f\u0011\u0002\u00115|7m\u001b+j[\u0016,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;j\nQ!\u001e;jYNL!a\u0018/\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u001bQLWM\u001d+pa&\u001cg*Y7f+\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\u0011a\u0017M\\4\u000b\u0003!\fAA[1wC&\u0011!.\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u001dQLWM\u001d+pa&\u001cg*Y7fA\u00051B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7/F\u0001o!\tyt.\u0003\u0002q\u0001\n)1\u000b[8si\u00069B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7\u000fI\u0001\bY><G)\u001b:t+\u0005!\bcA;yG6\taO\u0003\u0002xO\u0006!Q\u000f^5m\u0013\tIhOA\u0005BeJ\f\u0017\u0010T5ti\u0006AAn\\4ESJ\u001c\b%A\tpE*,7\r^*u_J,7i\u001c8gS\u001e,\u0012! \t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001(A\u0003ti>\u0014X-C\u0002\u0002\u0006}\u0014Q\u0003V5fe>\u0013'.Z2u'R|'/Z\"p]\u001aLw-\u0001\npE*,7\r^*u_J,7i\u001c8gS\u001e\u0004\u0013a\u0004;jKJ|%M[3diN#xN]3\u0016\u0005\u00055\u0001c\u0001@\u0002\u0010%\u0019\u0011\u0011C@\u000375{7m[%o\u001b\u0016lwN]=US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007%A\tuS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b9\u0003\u0015!x\u000e]5d\u0013\u0011\t\u0019#!\b\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'/\u0001\nuS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\u0004\u0013!\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pef,\"!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\r9\u0003\u0015\u0019H/\u0019;f\u0013\u0011\t)$a\f\u00033QKWM\u001d)beRLG/[8o'R\fG/\u001a$bGR|'/_\u0001\u001bi&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u0018\u0010I\u0001\u0014i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm]\u000b\u0003\u0003{\u0001RaPA \u0003\u0007J1!!\u0011A\u0005\u0015\t%O]1z!\u0011\ti#!\u0012\n\t\u0005\u001d\u0013q\u0006\u0002\u0013)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-A\fuS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,7o\u0018\u0013fcR\u0019!+!\u0014\t\u0011Y3\u0012\u0011!a\u0001\u0003{\tA\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKN\u0004\u0013!\u0005;jKJdunZ\"p[B|g.\u001a8ugV\u0011\u0011Q\u000b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f\u001e\u0002\u00071|w-\u0003\u0003\u0002`\u0005e#!\u0005+jKJdunZ\"p[B|g.\u001a8ug\u0006\u0011B/[3s\u0019><7i\\7q_:,g\u000e^:!\u0003I!\u0018.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003Wj\u0011\u0001O\u0005\u0004\u0003[B$A\u0005+jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\f1\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\nAC\u00197pG.Lgn\u001a+bg.,\u00050Z2vi>\u0014XCAA;!\u0011\t9(! \u000e\u0005\u0005e$bAA>m\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005}\u0014\u0011\u0010\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!\u00062m_\u000e\\\u0017N\\4UCN\\W\t_3dkR|'\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002\bB!\u0011\u0011RAN\u001b\t\tYIC\u0002^\u0003\u001bSA!a$\u0002\u0012\u000611m\\7n_:T1aOAJ\u0015\u0011\t)*a&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI*A\u0002pe\u001eLA!!(\u0002\f\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003-i\u0017\r_,bSR$\u0016.\\3\u0016\u0005\u0005\u0015\u0006\u0003BAT\u0003_k!!!+\u000b\t\u0005-\u0016QV\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111\u0010!\n\t\u0005E\u0016\u0011\u0016\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u00031i\u0017\r_,bSR$\u0016.\\3!\u0003!\u0011\u0017\u0010^3SCR,WCAA]!\u0011\tY,!4\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fAaY8sK*!\u00111YAc\u0003\u001diW\r\u001e:jGNTA!a2\u0002J\u00061\u00110Y7nKJT!!a3\u0002\u0007\r|W.\u0003\u0003\u0002P\u0006u&!B'fi\u0016\u0014\u0018\u0001\u00042zi\u0016\u0014\u0016\r^3`I\u0015\fHc\u0001*\u0002V\"AakIA\u0001\u0002\u0004\tI,A\u0005csR,'+\u0019;fA\u0005)1/\u001a;VaR\t!\u000bK\u0002&\u0003?\u0004B!!9\u0002p6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0002ba&TA!!;\u0002l\u00069!.\u001e9ji\u0016\u0014(\u0002BAw\u0003/\u000bQA[;oSRLA!!=\u0002d\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3AJA|!\u0011\t\t/!?\n\t\u0005m\u00181\u001d\u0002\n\u0003\u001a$XM]#bG\"\f\u0001\u0004^3ti\u0006;\u0018-\u001b;j]\u001edU-\u00193feJ+7/\u001e7uQ\r9#\u0011\u0001\t\u0005\u0003C\u0014\u0019!\u0003\u0003\u0003\u0006\u0005\r(\u0001\u0002+fgR\f!\b^3ti\u001a\u000b\u0017\u000e\\3e\u0013:LG\u000fT3bI\u0016\u0014(+\u001a;ssRCWM\u001c*fgR|'/\u001a+sS\u001e<WM]5oO\n+gm\u001c:f\u0019\u0016\fG-\u001a:)\u0007!\u0012\t!A\u0017uKN$h)Y5mK\u0012dU-\u00193feJ+7/\u001e7u\r\u0006LG.\u001a3SKN$xN]3OK^,'/\u00129pG\"D3!\u000bB\u0001\u00035\"Xm\u001d;GC&dW\r\u001a'fC\u0012,'OU3tk2$h)Y5mK\u0012\u0014Vm\u001d;pe\u0016,\u0015/^1m\u000bB|7\r\u001b\u0015\u0004U\t\u0005\u0011!\f;fgR4\u0015-\u001b7fI2+\u0017\rZ3s%\u0016\u001cX\u000f\u001c;GC&dW\r\u001a*fgR|'/\u001a'po\u0016\u0014X\t]8dQ\"\u001a1F!\u0001\u0002=Q,7\u000f^!xC&$\u0018N\\4MK\u0006$WM\u001d*fgVdGOR3oG\u0016$\u0007f\u0001\u0017\u0003\u0002\u0005QB/Z:u%\u0016\u001cHo\u001c:f\r\u0016t7-\u001a3Fq\u000e,\u0007\u000f^5p]\"\u001aQF!\u0001\u0002-Q,7\u000f\u001e\"fM>\u0014X-\u00169m_\u0006$g)\u001a8dK\u0012D3A\fB\u0001\u0003\t\"Xm\u001d;CK\u001a|'/Z+qY>\fGMU3uef<\u0006.\u001a8O_N+w-\\3oi\"\u001aqF!\u0001\u0002GQ,7\u000f\u001e\"fM>\u0014X-\u00169m_\u0006$\u0017\t\u001a<b]\u000e,7\u000fV8OKb$8\u000b^1uK\"\u001a\u0001G!\u0001\u0002EQ,7\u000f\u001e\"fM>\u0014X-\u00169m_\u0006$wJ^3sY\u0006\u0004\b/\u001b8h'\u0016<W.\u001a8uQ\r\t$\u0011A\u0001\u0019GJ,\u0017\r^3US\u0016\u0014\b+\u0019:uSRLwN\\*uCR,GCCA\"\u0005g\u0011\u0019E!\u0014\u0003^!9!Q\u0007\u001aA\u0002\t]\u0012a\u00013jeB!!\u0011\bB \u001b\t\u0011YDC\u0002\u0003>\u001d\f!![8\n\t\t\u0005#1\b\u0002\u0005\r&dW\rC\u0004\u0003FI\u0002\rAa\u0012\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007\u0003BA5\u0005\u0013J1Aa\u00139\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003PI\u0002\rA!\u0015\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\u0011\u0011\u0019F!\u0017\u000e\u0005\tU#b\u0001B,u\u000511/\u001a:wKJLAAa\u0017\u0003V\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2DqAa\u00183\u0001\u0004\u0011\t'\u0001\buS\u0016\u0014\u0018N\\4F]\u0006\u0014G.\u001a3\u0011\u0007}\u0012\u0019'C\u0002\u0003f\u0001\u0013qAQ8pY\u0016\fg\u000e")
public class TierArchiverStateTest {
    private CancellationContext ctx;
    private final MockTime mockTime = new MockTime();
    private final String tierTopicName;
    private final short tierTopicNumPartitions;
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(System.getProperty("java.io.tmpdir")));
    private final TierObjectStoreConfig objectStoreConfig = new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1));
    private final MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime(), this.objectStoreConfig());
    private final TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final TierPartitionStateFactory tierPartitionStateFactory = (TierPartitionStateFactory)Mockito.mock(TierPartitionStateFactory.class);
    private TierPartitionState[] tierPartitionStates = (TierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(TierPartitionState.class));
    private final TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), this.tierPartitionStateFactory());
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final ScheduledExecutorService blockingTaskExecutor = Executors.newSingleThreadScheduledExecutor();
    private final Time time = Time.SYSTEM;
    private final FiniteDuration maxWaitTime = new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds();
    private Meter byteRate;

    public CancellationContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(CancellationContext x$1) {
        this.ctx = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public String tierTopicName() {
        return this.tierTopicName;
    }

    public short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierObjectStoreConfig objectStoreConfig() {
        return this.objectStoreConfig;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public TierPartitionStateFactory tierPartitionStateFactory() {
        return this.tierPartitionStateFactory;
    }

    public TierPartitionState[] tierPartitionStates() {
        return this.tierPartitionStates;
    }

    public void tierPartitionStates_$eq(TierPartitionState[] x$1) {
        this.tierPartitionStates = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public ScheduledExecutorService blockingTaskExecutor() {
        return this.blockingTaskExecutor;
    }

    public Time time() {
        return this.time;
    }

    public FiniteDuration maxWaitTime() {
        return this.maxWaitTime;
    }

    public Meter byteRate() {
        return this.byteRate;
    }

    public void byteRate_$eq(Meter x$1) {
        this.byteRate = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.ctx_$eq(CancellationContext.newContext());
        KafkaMetricsGroup$.MODULE$.removeMetric("TierArchiver.UploadRate", KafkaMetricsGroup$.MODULE$.removeMetric$default$2());
        this.byteRate_$eq(KafkaMetricsGroup$.MODULE$.newMeter("TierArchiver.UploadRate", "bytes", TimeUnit.SECONDS, KafkaMetricsGroup$.MODULE$.newMeter$default$4()));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void tearDown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.delete();
            return BoxedUnit.UNIT;
        });
        this.ctx().cancel();
    }

    @Test
    public void testAwaitingLeaderResult() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        new Properties().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = this.createTierPartitionState(new File(this.logDirs().get(0)), topicIdPartition, logDirFailureChannel, true);
        this.tierReplicaManager().becomeLeader(tierPartitionState, 1);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        ArchiveTask task = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 0, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Future nextStage = task.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global());
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testFailedInitLeaderRetryThenRestoreTriggeringBeforeLeader() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ERROR).thenReturn((Object)TierPartitionStatus.ONLINE);
        ArchiveTask task = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Future nextStage = task.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Future failedResultNextStage = failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, failedResult.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResultAgain = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultNextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResultAgain.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED as status is still ERROR");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, failedResultAgain.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeLeader as correct epoch was never established in initial BeforeLeader");
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.ACCEPTED));
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResultAgain.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, failedResultAgain.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should correctly transition into BeforeUpload");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreNewerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)2));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        ArchiveTask task = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Future nextStage = task.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        ArchiveTask resultCancelled = (ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, failedResult.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)resultCancelled.ctx().isCancelled(), (String)"We are the stale leader and the task should be cancelled");
        Assertions.assertTrue((boolean)(resultCancelled.state() instanceof FailedState), (String)"We are the stale leader and the task should remain in FailedState");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreEqualEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        ArchiveTask task = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Future nextStage = task.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, failedResult.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeUpload), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testFailedLeaderResultFailedRestoreLowerEpoch() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FAILED));
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        ArchiveTask task = ArchiveTask$.MODULE$.apply(this.ctx(), topicIdPartition, 1, new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$), 1);
        Future nextStage = task.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, task.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global());
        ArchiveTask failedResult = (ArchiveTask)Await$.MODULE$.result((Awaitable)nextStage, (Duration)this.maxWaitTime());
        Assertions.assertTrue((boolean)(failedResult.state() instanceof FailedState), (String)"Should advance to FailedState due to AppendResult.FAILED");
        Assertions.assertTrue((boolean)(((ArchiveTask)Await$.MODULE$.result((Awaitable)failedResult.transition(this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, failedResult.transition$default$5(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime())).state() instanceof BeforeLeader), (String)"Should advance back to BeforeUpload as epoch is correct");
    }

    @Test
    public void testAwaitingLeaderResultFenced() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn((Object)CompletableFutureUtil$.MODULE$.completed((Object)TierPartitionState.AppendResult.FENCED));
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.establishLeadership(new BeforeLeader(0), topicIdPartition, (TierTopicAppender)tierTopicManager, 1, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testRestoreFencedException() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.RESTORE_FENCED));
        int x$1 = 150;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16);
        File logDir = Paths.get(TestUtils$.MODULE$.tempDir().getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        AbstractLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), this.tierLogComponents(), logDirFailureChannel, LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertThrows(TierArchiverRestoreFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadFenced() {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)1));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertThrows(TierArchiverFencedException.class, () -> Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()));
    }

    @Test
    public void testBeforeUploadRetryWhenNoSegment() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.tierableLogSegments()).thenReturn((Object)List$.MODULE$.empty());
        Mockito.when((Object)log.activeSegment()).thenReturn(null);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicIdPartition.topicPartition())).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)log.tierPartitionState()).thenReturn((Object)tierPartitionState);
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof BeforeUpload), (String)"Should advance to BeforeUpload");
    }

    @Test
    public void testBeforeUploadAdvancesToNextState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.fromString("9808a113-1876-42fb-9396-6bc9baa0526b"), 0);
        TopicPartition topicPartition = topicIdPartition.topicPartition();
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.committedEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)-1L));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)tierPartitionState.tierEpoch())).thenReturn((Object)BoxesRunTime.boxToInteger((int)0));
        Mockito.when((Object)tierPartitionState.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)tierPartitionState.endOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)tierPartitionState.segments(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(new ArrayList().iterator());
        Mockito.when((Object)tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch()).thenReturn((Object)new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(TierPartitionState.AppendResult.ACCEPTED));
        int x$1 = 150;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16);
        File logDir = Paths.get(TestUtils$.MODULE$.tempDir().getPath(), topicIdPartition.topicPartition().toString()).toFile();
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicPartition, logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        AbstractLog log = LogTestUtils$.MODULE$.createLog(logDir, logConfig, new BrokerTopicStats(), this.mockTime().scheduler(), (Time)this.mockTime(), 0L, 0L, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), this.tierLogComponents(), logDirFailureChannel, LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15());
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicPartition)).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(5, topicPartition, log.logEndOffset(), 0));
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(0), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to AfterUpload");
    }

    @Test
    public void testBeforeUploadOverlappingSegment() {
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16);
        File logDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(logDir);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        TierPartitionState tierPartitionState = this.createTierPartitionState(logDir, topicIdPartition, logDirFailureChannel, true);
        tierPartitionState.beginCatchup();
        tierPartitionState.onCatchUpComplete();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierPartitionStateFactory().mayEnableTiering(topicPartition, logConfig))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierPartitionStateFactory().initState(logDir, topicIdPartition.topicPartition(), logConfig, logDirFailureChannel, (Scheduler)this.mockTime().scheduler())).thenReturn((Object)tierPartitionState);
        long x$19 = 0L;
        long x$20 = 0L;
        MockScheduler x$21 = this.mockTime().scheduler();
        BrokerTopicStats x$22 = new BrokerTopicStats();
        Metrics x$23 = new Metrics();
        MockTime x$24 = this.mockTime();
        int x$25 = 3600000;
        int x$26 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        Some x$28 = new Some((Object)this.tierLogComponents());
        boolean x$29 = true;
        boolean x$30 = true;
        None$ x$31 = None$.MODULE$;
        LogOffsetsListener x$32 = Log$.MODULE$.apply$default$16();
        Option x$33 = Log$.MODULE$.apply$default$17();
        MergedLog log = Log$.MODULE$.apply(logDir, logConfig, x$19, x$20, (Scheduler)x$21, x$22, x$23, (Time)x$24, x$25, x$26, logDirFailureChannel, (Option)x$28, x$29, (Option)x$31, x$30, x$32, x$33);
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        log.appendAsFollower(TierTestUtils$.MODULE$.createRecords(50, topicIdPartition.topicPartition(), log.logEndOffset(), 0));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        TierTestUtils$.MODULE$.uploadWithMetadata(tierPartitionState, topicIdPartition, 0, UUID.randomUUID(), 0L, 60L, 15000L, 15000L, 1000, TierTestUtils$.MODULE$.uploadWithMetadata$default$10(), TierTestUtils$.MODULE$.uploadWithMetadata$default$11(), TierTestUtils$.MODULE$.uploadWithMetadata$default$12(), TierTestUtils$.MODULE$.uploadWithMetadata$default$13(), TierTestUtils$.MODULE$.uploadWithMetadata$default$14());
        int newTierEpoch = 1;
        tierPartitionState.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, newTierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        log.updateHighWatermark(log.logEndOffset());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(topicIdPartition.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.getPartitionOrError(topicPartition)).thenReturn((Object)scala.package$.MODULE$.Right().apply((Object)partition));
        Mockito.when((Object)tierTopicManager.addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<CompletableFuture<TierPartitionState.AppendResult>>(null, tierPartitionState){
            private final TierPartitionState tierPartitionState$1;

            public CompletableFuture<TierPartitionState.AppendResult> answer(InvocationOnMock invocation) {
                AbstractTierMetadata metadata = (AbstractTierMetadata)invocation.getArgument(0);
                return CompletableFuture.completedFuture(this.tierPartitionState$1.append(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
        Assertions.assertTrue((boolean)((ArchiveTaskState)Await$.MODULE$.result((Awaitable)ArchiveTask$.MODULE$.maybeInitiateUpload(new BeforeUpload(newTierEpoch), topicIdPartition, this.time(), (TierTopicAppender)tierTopicManager, (TierObjectStore)this.tierObjectStore(), replicaManager, ExecutionContext.Implicits$.MODULE$.global()), (Duration)this.maxWaitTime()) instanceof Upload), (String)"Should advance to Upload");
    }

    private TierPartitionState createTierPartitionState(File dir, TopicIdPartition topicIdPartition, LogDirFailureChannel logDirFailureChannel, boolean tieringEnabled) {
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, logDirFailureChannel, topicIdPartition.topicPartition(), tieringEnabled, (Scheduler)this.mockTime().scheduler(), false);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStates_$eq((TierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStates())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(TierPartitionState.class)));
        return tierPartitionState;
    }

    public TierArchiverStateTest() {
        this.tierTopicName = "_confluent-tier-state";
        this.tierTopicNumPartitions = 1;
    }
}

