/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAdmin$;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0004\b\u0001+!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C)C!)\u0001\u0006\u0001C\u0001S!)\u0011\b\u0001C\u0001S!)1\b\u0001C\u0001S!)Q\b\u0001C\u0001S!)q\b\u0001C\u0001S!)\u0011\t\u0001C\u0001S!)1\t\u0001C\u0001S!)Q\t\u0001C\u0001S!)q\t\u0001C\u0001S!)\u0011\n\u0001C\u0001S\t\t\"+Z2pm\u0016\u0014\u00180\u0016;jYN$Vm\u001d;\u000b\u0005=\u0001\u0012!\u0002;p_2\u001c(BA\t\u0013\u0003\u0011!\u0018.\u001a:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011DE\u0001\u0004CBL\u0017BA\u000e\u0019\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u000f\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0003\u001d\"Xm\u001d;J]*,7\r\u001e+jKJ$v\u000e]5d\u000bZ,g\u000e^(o\u000bbL7\u000f^5oOR{\u0007/[2\u0015\u0003)\u0002\"aI\u0016\n\u00051\"#\u0001B+oSRD#a\u0001\u0018\u0011\u0005=:T\"\u0001\u0019\u000b\u0005e\t$B\u0001\u001a4\u0003\u001dQW\u000f]5uKJT!\u0001N\u001b\u0002\u000b),h.\u001b;\u000b\u0003Y\n1a\u001c:h\u0013\tA\u0004G\u0001\u0003UKN$\u0018A\u000b;fgRLeN[3diRKWM\u001d+pa&\u001cWI^3oi>sgj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018n\u0019\u0015\u0003\t9\n\u0011\u0006^3tiR{Gk\u001c9jG&#\u0007+\u0019:uSRLwN\\:XSRDW)\u001c9usR{\u0007/[2OC6,\u0007FA\u0003/\u0003\u0015\"Xm\u001d;U_R{\u0007/[2JIB\u000b'\u000f^5uS>t7oV5uQ\n\u000bG\rV8qS\u000eLE\r\u000b\u0002\u0007]\u0005iC/Z:u)>$v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gn],ji\"\u0014\u0015\r\u001a)beRLG/[8o\u001dVl'-\u001a:)\u0005\u001dq\u0013a\t;fgR$v\u000eV8qS\u000eLE\rU1si&$\u0018n\u001c8t/&$\bnR8pI\u0006\u0013xm\u001d\u0015\u0003\u00119\nA\u0005^3tiZ\u000bG.\u001b3bi\u0016\u0004\u0016M\u001d;ji&|gn],ji\"4\u0016\r\\5e)>\u0004\u0018n\u0019\u0015\u0003\u00139\na\u0005^3tiZ\u000bG.\u001b3bi\u0016\u0004\u0016M\u001d;ji&|gn],ji\"LeN^1mS\u0012$v\u000e]5dQ\tQa&A\u0014uKN$h+\u00197jI\u0006$X\rU1si&$\u0018n\u001c8t/&$\b.\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007FA\u0006/\u0003)\"Xm\u001d;WC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:D#\u0001\u0004\u0018")
public class RecoveryUtilsTest
extends IntegrationTestHarness {
    @Override
    public int brokerCount() {
        return 3;
    }

    @Test
    public void testInjectTierTopicEventOnExistingTopic() {
        Some mayBeMetadata;
        String tierTopicName = TierTopic.topicName((String)"");
        int numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("dummy", UUID.fromString("021516db-7a5f-40ef-adda-b6e2b21a3e83"), 123);
        this.createTopic(tierTopicName, numTierTopicPartitions, tierTopicReplicationFactor, TierTopicAdmin$.MODULE$.topicConfig());
        int leaderEpoch = 1000;
        UUID messageId = UUID.randomUUID();
        int brokerId = 1;
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(tieredTopicIdPartition, leaderEpoch, messageId, brokerId);
        None$ mayBeProducer = None$.MODULE$;
        try {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.brokerList());
            mayBeProducer = new Some((Object)RecoveryUtils.createTierTopicProducer((Properties)properties, (String)"test"));
            Assertions.assertEquals((int)numTierTopicPartitions, (int)RecoveryUtils.getNumPartitions((Producer)((Producer)mayBeProducer.get()), (String)tierTopicName));
            mayBeMetadata = new Some((Object)RecoveryUtils.injectTierTopicEvent((Producer)((Producer)mayBeProducer.get()), (AbstractTierMetadata)initLeaderEvent, (String)tierTopicName, (int)numTierTopicPartitions));
        }
        finally {
            mayBeProducer.map((Function1 & Serializable & scala.Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
        mayBeMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> {
            RecoveryUtilsTest.$anonfun$testInjectTierTopicEventOnExistingTopic$2(metadata);
            return BoxedUnit.UNIT;
        });
        ObjectRef consumer = ObjectRef.create(null);
        try {
            Properties consumerProps = new Properties();
            consumerProps.put("auto.offset.reset", "earliest");
            consumerProps.put("enable.auto.commit", "false");
            consumerProps.put("bootstrap.servers", this.brokerList());
            consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
            consumer.elem = new KafkaConsumer(consumerProps);
            Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopicName, (int)numTierTopicPartitions);
            ((KafkaConsumer)consumer.elem).assign((Collection)tierTopicPartitions);
            tierTopicPartitions.forEach(tp -> ((KafkaConsumer)consumer$1.elem).seekToBeginning(Collections.singletonList(tp)));
            ConsumerRecords records = ((KafkaConsumer)consumer.elem).poll(Duration.ofMillis(100L));
            Assertions.assertEquals((int)1, (int)records.count());
            ConsumerRecord record = (ConsumerRecord)records.iterator().next();
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()));
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            TierTopicInitLeader retrievedEvent = (TierTopicInitLeader)eventOpt.get();
            Assertions.assertEquals((Object)initLeaderEvent, (Object)retrievedEvent);
        }
        finally {
            ((KafkaConsumer)consumer.elem).close();
        }
    }

    @Test
    public void testInjectTierTopicEventOnNonExistingTopic() {
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(new TopicIdPartition("dummy", UUID.fromString("021516db-7a5f-40ef-adda-b6e2b21a3e83"), 123), 1000, UUID.randomUUID(), 1);
        short numTierTopicPartitions = 1;
        ObjectRef mayBeProducer = ObjectRef.create((Object)None$.MODULE$);
        try {
            Properties properties = new Properties();
            properties.put("bootstrap.servers", this.brokerList());
            mayBeProducer.elem = new Some((Object)RecoveryUtils.createTierTopicProducer((Properties)properties, (String)"test"));
            boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.injectTierTopicEvent((Producer)((Producer)((Option)mayBeProducer$1.elem).get()), (AbstractTierMetadata)initLeaderEvent, (String)"", (int)numTierTopicPartitions), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139))).getCause() instanceof UnknownTopicOrPartitionException;
        }
        finally {
            ((Option)mayBeProducer.elem).map((Function1 & Serializable & scala.Serializable)producer -> {
                producer.close();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testToTopicIdPartitionsWithEmptyTopicName() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "", "23", "false"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "   ", "23", "false"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    @Test
    public void testToTopicIdPartitionsWithBadTopicId() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"", "foo", "23", "true"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"  ", "foo", "23", "true"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        String badUuid = "badUuid";
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{badUuid, "foo", "23", "true"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
    }

    @Test
    public void testToTopicIdPartitionsWithBadPartitionNumber() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "", "true"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "  ", "true"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%s %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.generateUuidAsBase64(), "foo", "abc", "true"}))})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
    }

    @Test
    public void testToTopicIdPartitionsWithGoodArgs() {
        TopicIdPartition topicIdPartition1 = new TopicIdPartition("foo", UUID.randomUUID(), 23);
        TopicIdPartition topicIdPartition2 = new TopicIdPartition("bar", UUID.randomUUID(), 97);
        Map result = RecoveryUtils.parseFencingInformation(Arrays.asList((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("%s:%s-%d %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.uuidToBase64(topicIdPartition1.topicId()), topicIdPartition1.topic(), BoxesRunTime.boxToInteger((int)topicIdPartition1.partition()), "true"})), new StringOps(Predef$.MODULE$.augmentString("%s:%s-%d %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CoreUtils$.MODULE$.uuidToBase64(topicIdPartition2.topicId()), topicIdPartition2.topic(), BoxesRunTime.boxToInteger((int)topicIdPartition2.partition()), "true"}))}));
        HashMap<TopicIdPartition, Boolean> expected = new HashMap<TopicIdPartition, Boolean>();
        expected.put(topicIdPartition1, BoxesRunTime.boxToBoolean((boolean)true));
        expected.put(topicIdPartition2, BoxesRunTime.boxToBoolean((boolean)true));
        Assertions.assertEquals(expected, (Object)result);
    }

    @Test
    public void testValidatePartitionsWithValidTopic() {
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 3);
        this.createTopic(tieredTopicIdPartition.topic(), 5, 1, TierTopicAdmin$.MODULE$.topicConfig());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.brokerList());
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition(tieredTopicIdPartition.topic(), tieredTopicIdPartition.partition()));
        RecoveryUtils.validatePartitions((Properties)properties, inputPartitions);
    }

    @Test
    public void testValidatePartitionsWithInvalidTopic() {
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 3);
        this.createTopic(tieredTopicIdPartition.topic(), 5, 1, TierTopicAdmin$.MODULE$.topicConfig());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.brokerList());
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition("dummy", 13));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, (Set)inputPartitions), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
    }

    @Test
    public void testValidatePartitionsWithInternalTopic() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.brokerList());
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition("__consumer_offsets", 0));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, (Set)inputPartitions), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
    }

    @Test
    public void testValidatePartitionsWithInvalidPartition() {
        TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 3);
        this.createTopic(tieredTopicIdPartition.topic(), 5, 1, TierTopicAdmin$.MODULE$.topicConfig());
        Properties properties = new Properties();
        properties.put("bootstrap.servers", this.brokerList());
        HashSet<TopicPartition> inputPartitions = new HashSet<TopicPartition>();
        inputPartitions.add(new TopicPartition(tieredTopicIdPartition.topic(), 13));
        Matchers$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RecoveryUtils.validatePartitions((Properties)properties, (Set)inputPartitions), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RecoveryUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
    }

    public static final /* synthetic */ void $anonfun$testInjectTierTopicEventOnExistingTopic$2(RecordMetadata metadata) {
        Assertions.assertTrue((boolean)metadata.hasOffset());
        Assertions.assertEquals((long)0L, (long)metadata.offset());
        Assertions.assertTrue((metadata.serializedKeySize() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((metadata.serializedValueSize() > 0 ? 1 : 0) != 0);
    }
}

