/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.api.IntegrationTestHarness;
import kafka.log.Log$;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierRecordType;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAdmin$;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005R1Bqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u00191\u0005\u0001)A\u0005}!9q\t\u0001a\u0001\n\u0013A\u0005b\u0002*\u0001\u0001\u0004%Ia\u0015\u0005\u00073\u0002\u0001\u000b\u0015B%\t\u000fi\u0003!\u0019!C\u00057\"11\u000e\u0001Q\u0001\nqC\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011B7\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0013)\b\"C<\u0001\u0001\u0004\u0005\t\u0015)\u0003o\u0011%A\b\u00011AA\u0002\u0013%Q\u000eC\u0005z\u0001\u0001\u0007\t\u0019!C\u0005u\"IA\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001c\u0005\b{\u0002\u0011\r\u0011\"\u0003\u007f\u0011\u001d\tY\u0001\u0001Q\u0001\n}Dq!!\u0004\u0001\t\u0013\ty\u0001C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002,!9\u0011q\n\u0001\u0005\u0002\u0005E#a\f+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164UM\\2j]\u001eLe\u000e^3he\u0006$\u0018n\u001c8Ue&<w-\u001a:UKN$(B\u0001\u000e\u001c\u0003\u0015!xn\u001c7t\u0015\taR$\u0001\u0003uS\u0016\u0014(\"\u0001\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0003Iu\t1!\u00199j\u0013\t13E\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t\u0011$A\u0006ce>\\WM]\"pk:$X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u0007%sG/\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001(H\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005i:$\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\r1|w\rR5s+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u0003\u0011a\u0017M\\4\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002\u000f1|w\rR5sA\u00059B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dWm]\u000b\u0002\u0013B\u0019aF\u0013'\n\u0005-{#!B!se\u0006L\bCA'Q\u001b\u0005q%BA(\u001c\u0003\u0015\u0019H/\u0019;f\u0013\t\tfJ\u0001\fGS2,G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003m!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3GS2,7o\u0018\u0013fcR\u0011Ak\u0016\t\u0003]UK!AV\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b1\"\t\t\u00111\u0001J\u0003\rAH%M\u0001\u0019i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR5mKN\u0004\u0013a\u0004;qS\u0012\u001cHk\u001c\"f\r\u0016t7-\u001a3\u0016\u0003q\u0003B!\u00182eQ6\taL\u0003\u0002`A\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003C>\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0019gLA\u0002NCB\u0004\"!\u001a4\u000e\u0003mI!aZ\u000e\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007C\u0001\u0018j\u0013\tQwFA\u0004C_>dW-\u00198\u0002!Q\u0004\u0018\u000eZ:U_\n+g)\u001a8dK\u0012\u0004\u0013!\u0006;pa&\u001c\u0017\n\u001a)beRLG/[8og\u001aKG.Z\u000b\u0002]B\u0011qN]\u0007\u0002a*\u0011\u0011OQ\u0001\u0003S>L!a\u001d9\u0003\t\u0019KG.Z\u0001\u001ai>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u001ch)\u001b7f?\u0012*\u0017\u000f\u0006\u0002Um\"9\u0001,DA\u0001\u0002\u0004q\u0017A\u0006;pa&\u001c\u0017\n\u001a)beRLG/[8og\u001aKG.\u001a\u0011\u0002%A\u0014x\u000e]3si&,7oQ8oM\u001aKG.Z\u0001\u0017aJ|\u0007/\u001a:uS\u0016\u001c8i\u001c8g\r&dWm\u0018\u0013fcR\u0011Ak\u001f\u0005\b1B\t\t\u00111\u0001o\u0003M\u0001(o\u001c9feRLWm]\"p]\u001a4\u0015\u000e\\3!\u0003!iwnY6US6,W#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u001e\u0003\u0015)H/\u001b7t\u0013\u0011\tI!a\u0001\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u0015\u0005$GMU3qY&\u001c\u0017\rF\u0004U\u0003#\t)\"!\n\t\r\u0005MA\u00031\u0001e\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0018Q\u0001\r!!\u0007\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tybG\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003G\tiBA\tUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJDa!a\n\u0015\u0001\u0004A\u0017aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0002\u000bM,G/\u00169\u0015\u0003QC3!FA\u0018!\u0011\t\t$!\u0011\u000e\u0005\u0005M\"b\u0001\u0013\u00026)!\u0011qGA\u001d\u0003\u001dQW\u000f]5uKJTA!a\u000f\u0002>\u0005)!.\u001e8ji*\u0011\u0011qH\u0001\u0004_J<\u0017\u0002BA\"\u0003g\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\f\u0002JA!\u0011\u0011GA&\u0013\u0011\ti%a\r\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u000b;fgR\u0004\u0016M\u001d;ji&|gNR3oG\u0016,e/\u001a8u\u0013:TWm\u0019;j_:\fe\u000e\u001a$f]\u000eLgn\u001a\u000b\u0004)\u0006M\u0003BBA\u0014/\u0001\u0007\u0001\u000eK\u0004\u0018\u0003/\n9'!\u001b\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005A\u0001O]8wS\u0012,'O\u0003\u0003\u0002b\u0005U\u0012A\u00029be\u0006l7/\u0003\u0003\u0002f\u0005m#a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003W\ni'G\u0001\u00023\u0005\u0001\u0001fA\f\u0002rA!\u00111OA;\u001b\t\ty&\u0003\u0003\u0002x\u0005}#!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0002")
public class TierPartitionStateFencingIntegrationTriggerTest
extends IntegrationTestHarness {
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final String logDir = TestUtils$.MODULE$.tempDir().getAbsolutePath();
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final scala.collection.immutable.Map<TopicIdPartition, Object> tpidsToBeFenced = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("the_dark_knight", UUID.randomUUID(), 2)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mummy_returns", UUID.randomUUID(), 3)), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition("mission_impossible", UUID.randomUUID(), 5)), (Object)BoxesRunTime.boxToBoolean((boolean)true))}));
    private File topicIdPartitionsFile;
    private File propertiesConfFile;
    private final kafka.utils.MockTime mockTime = new kafka.utils.MockTime();

    @Override
    public int brokerCount() {
        return 3;
    }

    private LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    private String logDir() {
        return this.logDir;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private scala.collection.immutable.Map<TopicIdPartition, Object> tpidsToBeFenced() {
        return this.tpidsToBeFenced;
    }

    private File topicIdPartitionsFile() {
        return this.topicIdPartitionsFile;
    }

    private void topicIdPartitionsFile_$eq(File x$1) {
        this.topicIdPartitionsFile = x$1;
    }

    private File propertiesConfFile() {
        return this.propertiesConfFile;
    }

    private void propertiesConfFile_$eq(File x$1) {
        this.propertiesConfFile = x$1;
    }

    private kafka.utils.MockTime mockTime() {
        return this.mockTime;
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, boolean checksumEnabled) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(Log$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, this.logDirFailureChannel(), topicIdPartition.topicPartition(), true, (Scheduler)this.mockTime().scheduler(), checksumEnabled);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        tierPartitionState.setTieredPartitionRecoveryWorkflowCb(op -> System.out.println(new StringBuilder(14).append("Received ").append(op.toString()).append(" for ").append(topicIdPartition).toString()));
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, tierPartitionState){
            private final FileTierPartitionState tierPartitionState$1;

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus targetStatus, OffsetAndEpoch sourceOffsetAndEpoch, Optional<ByteBuffer> targetStateOpt) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, targetStateOpt, targetStatus, sourceOffsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.topicIdPartitionsFile_$eq(TestUtils$.MODULE$.tempFile());
        this.tpidsToBeFenced().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            if (x$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tpid = (TopicIdPartition)x$1._1();
            scala.collection.immutable.Map<Object, Object> map = this.createTopic(tpid.topic(), 10, 1, TierTopicAdmin$.MODULE$.topicConfig());
            return map;
        });
        RecoveryTestUtils$.MODULE$.writeFencingFile(this.topicIdPartitionsFile(), this.tpidsToBeFenced());
        this.propertiesConfFile_$eq(TestUtils$.MODULE$.tempFile());
    }

    @Override
    @AfterEach
    public void tearDown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$tearDown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPartitionFenceEventInjectionAndFencing(boolean checksumEnabled) {
        String tierTopicNamespace = "";
        short numTierTopicPartitions = 19;
        int tierTopicReplicationFactor = 3;
        this.createTopic(TierTopic.topicName((String)tierTopicNamespace), numTierTopicPartitions, tierTopicReplicationFactor, TierTopicAdmin$.MODULE$.topicConfig());
        AdminZkClient adminZkClient = (AdminZkClient)Mockito.mock(AdminZkClient.class);
        TierTopic tierTopic = new TierTopic(tierTopicNamespace);
        adminZkClient.createTopic(tierTopic.topicName(), (int)numTierTopicPartitions, (int)Defaults$.MODULE$.TierMetadataReplicationFactor(), TierTopicAdmin$.MODULE$.topicConfig(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6(), adminZkClient.createTopic$default$7(), adminZkClient.createTopic$default$8());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TopicExistsException("topic exists")});
        Mockito.when((Object)adminZkClient.numPartitions(tierTopic.topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)numTierTopicPartitions)));
        tierTopic.initialize(adminZkClient, (int)numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor());
        File workingDir = TestUtils$.MODULE$.tempDir();
        Utils.mkProperties((Map)new HashMap<String, String>(this, workingDir){
            {
                this.put("bootstrap.servers", $outer.brokerList());
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
            }
        }).store(new PrintWriter(this.propertiesConfFile()), "");
        String tempFileName = "working-file";
        Path tempFilePath = Paths.get(workingDir.getAbsolutePath(), tempFileName);
        Files.createFile(tempFilePath, new FileAttribute[0]);
        File tempFile = new File(tempFilePath.toFile().getAbsolutePath());
        Assertions.assertTrue((tempFile.exists() && tempFile.isFile() ? 1 : 0) != 0);
        File outputDir = TestUtils$.MODULE$.tempDir();
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), this.propertiesConfFile().getPath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), this.topicIdPartitionsFile().getPath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile})));
        Assertions.assertTrue((!tempFile.exists() ? 1 : 0) != 0);
        Buffer fenceEvents = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]))).asScala();
        Assertions.assertEquals((int)this.tpidsToBeFenced().size(), (int)fenceEvents.size());
        scala.collection.mutable.Map partitionToFenceEventInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        fenceEvents.foreach((Function1 & Serializable & scala.Serializable)output -> {
            TopicIdPartition outputTpid = new TopicIdPartition(output.topic, CoreUtils$.MODULE$.uuidFromBase64(output.topicIdBase64), output.partition);
            Assertions.assertTrue((boolean)this.tpidsToBeFenced().contains((Object)outputTpid));
            Assertions.assertTrue((BoxesRunTime.equals((Object)this.tpidsToBeFenced().apply((Object)outputTpid), (Object)output.freezeMergedLogStartOffset) ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordOffset >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordTimestamp >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((output.recordPartition >= 0 ? 1 : 0) != 0);
            CoreUtils$.MODULE$.uuidFromBase64(output.recordMessageIdBase64);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)output.partition)), output));
        });
        TierTopicManagerConfig config = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", this.brokerList()), tierTopicNamespace, numTierTopicPartitions, Defaults$.MODULE$.TierMetadataReplicationFactor(), -1, "unknown", Predef$.MODULE$.long2Long(Defaults$.MODULE$.TierMetadataMaxPollMs()), Predef$.MODULE$.int2Integer(Defaults$.MODULE$.TierMetadataRequestTimeoutMs()), Defaults$.MODULE$.TierPartitionStateCommitInterval(), Collections.singletonList(this.logDir()));
        TierTopicConsumerSupplier primaryConsumerSupplier = new TierTopicConsumerSupplier(config, "primary");
        Consumer verificationConsumer = primaryConsumerSupplier.get();
        Set tierTopicPartitions = TierTopicManager.partitions((String)tierTopic.topicName(), (int)tierTopic.numPartitions().getAsInt());
        verificationConsumer.assign((Collection)tierTopicPartitions);
        tierTopicPartitions.forEach(tp -> verificationConsumer.seekToBeginning(Collections.singletonList(tp)));
        ListBuffer records = new ListBuffer();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$4(this, verificationConsumer, config, records)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.mutable.Set allFencedTpids = ((SetLike)Set$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.tpidsToBeFenced().keySet());
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()));
            Assertions.assertTrue((boolean)eventOpt.isPresent());
            Assertions.assertEquals((Object)TierRecordType.PartitionFence, (Object)((AbstractTierMetadata)eventOpt.get()).type());
            TierPartitionFence fenceEvent = (TierPartitionFence)eventOpt.get();
            Assertions.assertTrue((boolean)allFencedTpids.contains((Object)fenceEvent.topicIdPartition()));
            Assertions.assertTrue((fenceEvent.freezeLogStartOffset() == BoxesRunTime.unboxToBoolean((Object)this.tpidsToBeFenced().apply((Object)fenceEvent.topicIdPartition())) ? 1 : 0) != 0);
            allFencedTpids.remove((Object)fenceEvent.topicIdPartition());
            int userPartition = fenceEvent.topicIdPartition().partition();
            Assertions.assertTrue((boolean)partitionToFenceEventInfoMap.contains((Object)BoxesRunTime.boxToInteger((int)userPartition)));
            FenceEventInfo fenceEventInfo = (FenceEventInfo)partitionToFenceEventInfoMap.apply((Object)BoxesRunTime.boxToInteger((int)userPartition));
            Assertions.assertEquals((Object)fenceEvent.messageId(), (Object)CoreUtils$.MODULE$.uuidFromBase64(fenceEventInfo.recordMessageIdBase64));
            Assertions.assertEquals((long)record.offset(), (long)fenceEventInfo.recordOffset);
            return (scala.collection.mutable.Map)partitionToFenceEventInfoMap.$minus$eq((Object)BoxesRunTime.boxToInteger((int)userPartition));
        });
        Assertions.assertTrue((boolean)allFencedTpids.isEmpty());
        verificationConsumer.close();
        TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(config, (Supplier)primaryConsumerSupplier, (Supplier)new TierTopicConsumerSupplier(config, "catchup"), new TierTopicManagerCommitter(config, this.logDirFailureChannel()), tierStateFetcher, Optional.empty(), (Time)new MockTime());
        this.tpidsToBeFenced().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$7(this, tierTopicConsumer, checksumEnabled, x0$1);
            return BoxedUnit.UNIT;
        });
        tierTopicConsumer.initialize((InitializedTierTopic)tierTopic);
        tierTopicConsumer.start();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$8(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        tierTopicConsumer.shutdown();
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$4(TierPartitionStateFencingIntegrationTriggerTest $this, Consumer verificationConsumer$1, TierTopicManagerConfig config$1, ListBuffer records$1) {
        Iterator batchIterator = verificationConsumer$1.poll(config$1.pollDuration).iterator();
        while (batchIterator.hasNext()) {
            records$1.$plus$eq(batchIterator.next());
        }
        return records$1.size() == $this.tpidsToBeFenced().size();
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$5() {
        return "Timed out trying to fetch TierTopic records";
    }

    public static final /* synthetic */ void $anonfun$testPartitionFenceEventInjectionAndFencing$7(TierPartitionStateFencingIntegrationTriggerTest $this, TierTopicConsumer tierTopicConsumer$1, boolean checksumEnabled$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition tpid = (TopicIdPartition)x0$1._1();
            $this.addReplica(tpid, tierTopicConsumer$1, checksumEnabled$1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$9(TierPartitionStateFencingIntegrationTriggerTest $this, FileTierPartitionState state) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.tpidsToBeFenced().apply(state.topicIdPartition().get()))) {
            TierPartitionStatus tierPartitionStatus = state.status();
            TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
            return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
        }
        TierPartitionStatus tierPartitionStatus = state.status();
        TierPartitionStatus tierPartitionStatus3 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus3) : tierPartitionStatus3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionFenceEventInjectionAndFencing$8(TierPartitionStateFencingIntegrationTriggerTest $this) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.tierPartitionStateFiles())).forall((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateFencingIntegrationTriggerTest.$anonfun$testPartitionFenceEventInjectionAndFencing$9($this, state)));
    }

    public static final /* synthetic */ String $anonfun$testPartitionFenceEventInjectionAndFencing$10() {
        return "Timed out waiting for fencing";
    }
}

