/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.Properties;
import java.util.UUID;
import kafka.tier.tools.TierMetadataDebugger;
import kafka.tier.tools.TierTopicMaterializationToolConfig;
import kafka.tier.tools.TierTopicMaterializationUtils;
import kafka.utils.CoreUtils;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TierTopicMaterializationUtilsTest {
    private Scheduler scheduler;

    @BeforeEach
    public void setup() {
        this.scheduler = new KafkaScheduler(1, "test-scheduler-", true);
        this.scheduler.startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler.shutdown();
    }

    @Test
    public void TierTopicMaterializationToolTest() {
        UUID uuid = UUID.randomUUID();
        Properties props = new Properties();
        props.put("bootstrap-server", "localhost:9092");
        props.put("source-topic-id", CoreUtils.uuidToBase64((UUID)uuid));
        props.put("source-partition", "10");
        props.put("start-offset", "4");
        props.put("working-dir", "/tmp/path");
        TierTopicMaterializationToolConfig config = new TierTopicMaterializationToolConfig(props);
        TierTopicMaterializationUtils tool = new TierTopicMaterializationUtils(config, new Properties(), this.scheduler);
        Assertions.assertEquals((Object)tool.config.materializationPath, (Object)"/tmp/path");
        Assertions.assertEquals((Integer)tool.config.userPartition, (Integer)new Integer(10));
        Assertions.assertEquals((Object)tool.config.userTopicId, (Object)uuid);
        Assertions.assertEquals((Integer)tool.config.endOffset, (Integer)new Integer(-1));
        Assertions.assertEquals((Object)tool.config.dumpHeader, (Object)false);
    }

    @Test
    public void TierTopicMaterializationToolSetupTest() {
        String[] args = new String[]{"--source-partition", "10", "--start-offset", "5"};
        Properties props = TierMetadataDebugger.fetchPropertiesFromArgs((String[])args);
        System.out.println(props);
        System.out.println("source-partition");
        TierTopicMaterializationUtils consumer = new TierTopicMaterializationUtils(new TierTopicMaterializationToolConfig(props), new Properties(), this.scheduler);
        Assertions.assertEquals((Integer)consumer.config.startOffset, (Integer)new Integer(0));
        Assertions.assertEquals((Integer)consumer.config.userPartition, (Integer)new Integer(10));
        Assertions.assertEquals((Object)consumer.config.userTopicId, (Object)TierTopicMaterializationToolConfig.EMPTY_UUID);
    }
}

