/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.topic.TierCatchupConsumer;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicManager;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001\u0002\f\u0018\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u0004;\u0001\u0001\u0006Ia\u000b\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005B\u0002$\u0001A\u0003%1\tC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Da!\u001d\u0001!\u0002\u0013)\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\t\u000fa\u0004!\u0019!C\u0005s\"1Q\u0010\u0001Q\u0001\niDQA \u0001\u0005\u0002}Da!!\t\u0001\t\u0003y\bBBA\u0016\u0001\u0011\u0005q\u0010\u0003\u0004\u00020\u0001!\ta \u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\u0012q\u0003V5fe\u000e\u000bGo\u00195va\u000e{gn];nKJ$Vm\u001d;\u000b\u0005aI\u0012!\u0002;pa&\u001c'B\u0001\u000e\u001c\u0003\u0011!\u0018.\u001a:\u000b\u0003q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0014\u0011\u0005!\u0002Q\"A\f\u0002#Q|\u0007/[2JIB\u000b'\u000f^5uS>t7/F\u0001,!\ra3G\u000e\b\u0003[E\u0002\"AL\u0011\u000e\u0003=R!\u0001M\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u00121aU3u\u0015\t\u0011\u0014\u0005\u0005\u00028q5\t\u0011$\u0003\u0002:3\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0001\u0013i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002{A\u0011\u0001EP\u0005\u0003\u007f\u0005\u0012Qa\u00155peR\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%A\u000bbI6LgNW6DY&,g\u000e^*vaBd\u0017.\u001a:\u0016\u0003\r\u00132\u0001R$P\r\u0011)u\u0001A\"\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0002-\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u'V\u0004\b\u000f\\5fe\u0002\u0002\"\u0001S'\u000e\u0003%S!AS&\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tq\u0015J\u0001\u0004PE*,7\r\u001e\t\u0004!V;V\"A)\u000b\u0005I\u001b\u0016\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005Q[\u0015\u0001B;uS2L!AV)\u0003\u0011M+\b\u000f\u001d7jKJ\u0004\"\u0001W.\u000e\u0003eS!AW\u000e\u0002\u0005i\\\u0017B\u0001/Z\u00055\tE-\\5o5.\u001cE.[3oi\u0006IA/[3s)>\u0004\u0018nY\u000b\u0002?B\u0011\u0001\u0006Y\u0005\u0003C^\u0011\u0011\u0002V5feR{\u0007/[2\u0002\u0015QLWM\u001d+pa&\u001c\u0007%\u0001\tqe>$WoY3s'V\u0004\b\u000f\\5feV\tQ\r\u0005\u0003gS.\\W\"A4\u000b\u0005!L\u0012AB2mS\u0016tG/\u0003\u0002kO\n!Rj\\2l!J|G-^2feN+\b\u000f\u001d7jKJ\u00042\u0001\t7o\u0013\ti\u0017EA\u0003BeJ\f\u0017\u0010\u0005\u0002!_&\u0011\u0001/\t\u0002\u0005\u0005f$X-A\tqe>$WoY3s'V\u0004\b\u000f\\5fe\u0002\n\u0001cY8ogVlWM]*vaBd\u0017.\u001a:\u0016\u0003Q\u0004BAZ;lW&\u0011ao\u001a\u0002\u0015\u001b>\u001c7nQ8ogVlWM]*vaBd\u0017.\u001a:\u0002#\r|gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\bdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s+\u0005Q\bC\u0001\u0015|\u0013\taxCA\nUS\u0016\u00148)\u0019;dQV\u00048i\u001c8tk6,'/\u0001\tdCR\u001c\u0007.\u001e9D_:\u001cX/\\3sA\u0005)1/\u001a;vaR\u0011\u0011\u0011\u0001\t\u0004A\u0005\r\u0011bAA\u0003C\t!QK\\5uQ\r\u0001\u0012\u0011\u0002\t\u0005\u0003\u0017\ti\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\r\t\u0007/\u001b\u0006\u0005\u0003'\t)\"A\u0004kkBLG/\u001a:\u000b\t\u0005]\u0011\u0011D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u00037\t1a\u001c:h\u0013\u0011\ty\"!\u0004\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\tuKN$8\u000b^1si\u000e{gn];nKJD3!EA\u0013!\u0011\tY!a\n\n\t\u0005%\u0012Q\u0002\u0002\u0005)\u0016\u001cH/A\buKN$HK]=D_6\u0004H.\u001a;fQ\r\u0011\u0012QE\u0001\ti\u0016\u001cH\u000fU8mY\"\u001a1#!\n\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000f\u0006\u0003\u00028\u0005=\u0003CBA\u001d\u0003w\ti$D\u0001T\u0013\t!4\u000b\u0005\u0003\u0002@\u0005-SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\r\r|W.\\8o\u0015\ra\u0012q\t\u0006\u0005\u0003\u0013\nI\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u001b\n\tE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b%\"\u0002\u0019A\u0016\u00023UtG-\u001a:ms&twmQ1uG\",\boQ8ogVlWM]\u000b\u0003\u0003+\u0002b!a\u0016\u0002b-\\WBAA-\u0015\u0011\tY&!\u0018\u0002\u0011\r|gn];nKJTA!a\u0018\u0002F\u000591\r\\5f]R\u001c\u0018\u0002BA2\u00033\u0012\u0001bQ8ogVlWM\u001d")
public class TierCatchupConsumerTest {
    private final scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions = TierTestUtils$.MODULE$.randomTopicIdPartitions(3, 5);
    private final short numPartitions = (short)5;
    private final Supplier<AdminZkClient> adminZkClientSupplier = new Supplier<AdminZkClient>(null){

        public AdminZkClient get() {
            return (AdminZkClient)Mockito.mock(AdminZkClient.class);
        }
    };
    private final TierTopic tierTopic = new TierTopic("namespace");
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> consumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", TierTopicManager.partitions((String)this.tierTopic().topicName(), (int)this.numPartitions()), this.producerSupplier().producer());
    private final TierCatchupConsumer catchupConsumer = new TierCatchupConsumer(this.consumerSupplier());

    private scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions() {
        return this.topicIdPartitions;
    }

    private short numPartitions() {
        return this.numPartitions;
    }

    private Supplier<AdminZkClient> adminZkClientSupplier() {
        return this.adminZkClientSupplier;
    }

    private TierTopic tierTopic() {
        return this.tierTopic;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    private TierCatchupConsumer catchupConsumer() {
        return this.catchupConsumer;
    }

    @BeforeEach
    public void setup() {
        this.tierTopic().initialize(this.adminZkClientSupplier().get(), (int)this.numPartitions(), (short)1);
    }

    @Test
    public void testStartConsumer() {
        Set<TopicPartition> tierTopicPartitions = this.assignment(this.topicIdPartitions());
        this.catchupConsumer().doStart(tierTopicPartitions);
        Assertions.assertTrue((boolean)this.catchupConsumer().active());
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        scala.collection.immutable.Set<TopicIdPartition> newTopicPartitions = TierTestUtils$.MODULE$.randomTopicIdPartitions(3, 2);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.catchupConsumer().doStart(this.assignment(newTopicPartitions)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierCatchupConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        Assertions.assertEquals((Object)this.underlyingCatchupConsumer().assignment(), tierTopicPartitions);
        Assertions.assertTrue((boolean)this.catchupConsumer().active());
    }

    @Test
    public void testTryComplete() {
        Set<TopicPartition> currentAssignment = this.assignment(this.topicIdPartitions());
        Consumer primaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        this.catchupConsumer().doStart(currentAssignment);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(currentAssignment).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 10L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertFalse((boolean)this.catchupConsumer().tryComplete(primaryConsumer));
        Assertions.assertTrue((boolean)this.catchupConsumer().active());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(currentAssignment).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 20L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertTrue((boolean)this.catchupConsumer().tryComplete(primaryConsumer));
        Assertions.assertFalse((boolean)this.catchupConsumer().active());
    }

    @Test
    public void testPoll() {
        Set<TopicPartition> currentAssignment = this.assignment(this.topicIdPartitions());
        Consumer primaryConsumer = (Consumer)Mockito.mock(Consumer.class);
        Assertions.assertEquals(null, (Object)this.catchupConsumer().poll(Duration.ZERO));
        this.catchupConsumer().doStart(currentAssignment);
        ConsumerRecords records = this.catchupConsumer().poll(Duration.ZERO);
        Assertions.assertEquals((int)0, (int)records.count());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(currentAssignment).asScala()).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.underlyingCatchupConsumer().seek(topicPartition, 20L);
            return Mockito.when((Object)BoxesRunTime.boxToLong((long)primaryConsumer.position(topicPartition))).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        });
        Assertions.assertTrue((boolean)this.catchupConsumer().tryComplete(primaryConsumer));
        Assertions.assertEquals(null, (Object)this.catchupConsumer().poll(Duration.ZERO));
    }

    private Set<TopicPartition> assignment(scala.collection.immutable.Set<TopicIdPartition> topicIdPartitions) {
        return this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(topicIdPartitions).asJava());
    }

    private Consumer<byte[], byte[]> underlyingCatchupConsumer() {
        return this.catchupConsumer().consumer();
    }
}

