/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.tier.topic.TierTopicAdmin$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.errors.TopicExistsException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E3A\u0001D\u0007\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0014\u0001A\u0003%\u0011\u0005C\u0004)\u0001\t\u0007I\u0011B\u0015\t\rI\u0002\u0001\u0015!\u0003+\u0011\u001d\u0019\u0004A1A\u0005\nQBa\u0001\u000f\u0001!\u0002\u0013)\u0004\"B\u001d\u0001\t\u0003Q\u0004\"B&\u0001\t\u0003Q\u0004\"B'\u0001\t\u0003Q\u0004\"B(\u0001\t\u0003Q$A\u0005+jKJ$v\u000e]5d\u0003\u0012l\u0017N\u001c+fgRT!AD\b\u0002\u000bQ|\u0007/[2\u000b\u0005A\t\u0012\u0001\u0002;jKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u00035\tQ\"\u00193nS:T6n\u00117jK:$X#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\n\u0012A\u0001>l\u0013\t13EA\u0007BI6LgNW6DY&,g\u000e^\u0001\u000fC\u0012l\u0017N\u001c.l\u00072LWM\u001c;!\u0003%!x\u000e]5d\u001d\u0006lW-F\u0001+!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0003mC:<'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012aa\u0015;sS:<\u0017A\u0003;pa&\u001cg*Y7fA\u0005Y2m\u001c8gS\u001e,(/\u001a3SKBd\u0017nY1uS>tg)Y2u_J,\u0012!\u000e\t\u0003-YJ!aN\f\u0003\u000bMCwN\u001d;\u00029\r|gNZ5hkJ,GMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005)C/Z:u\t>tu\u000e^\"bY2\u001c%/Z1uKR{\u0007/[2JMR{\u0007/[2Fq&\u001cHo\u001d\u000b\u0002wA\u0011a\u0003P\u0005\u0003{]\u0011A!\u00168ji\"\u0012\u0001b\u0010\t\u0003\u0001&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b1!\u00199j\u0015\t!U)A\u0004kkBLG/\u001a:\u000b\u0005\u0019;\u0015!\u00026v]&$(\"\u0001%\u0002\u0007=\u0014x-\u0003\u0002K\u0003\n!A+Z:u\u0003=!Xm\u001d;U_BL7m\u0011:fCR,\u0007FA\u0005@\u0003=!Xm\u001d;U_BL7-\u0012=jgR\u001c\bF\u0001\u0006@\u0003Q!Xm\u001d;V].twn\u001e8Fq\u000e,\u0007\u000f^5p]\"\u00121b\u0010")
public class TierTopicAdminTest {
    private final AdminZkClient adminZkClient = (AdminZkClient)Mockito.mock(AdminZkClient.class);
    private final String topicName;
    private final short configuredReplicationFactor = (short)3;

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private String topicName() {
        return this.topicName;
    }

    private short configuredReplicationFactor() {
        return this.configuredReplicationFactor;
    }

    @Test
    public void testDoNotCallCreateTopicIfTopicExists() {
        int configuredNumPartitions = 10;
        int actualNumPartitions = 5;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.adminZkClient().numPartitions(this.topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)actualNumPartitions)));
        int createdPartitions = TierTopicAdmin$.MODULE$.ensureTopic(this.adminZkClient(), this.topicName(), configuredNumPartitions, this.configuredReplicationFactor());
        ((AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1))).topicExists(this.topicName());
        AdminZkClient qual$1 = (AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)0));
        String x$1 = this.topicName();
        short x$3 = this.configuredReplicationFactor();
        Properties x$4 = TierTopicAdmin$.MODULE$.topicConfig();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(x$1, configuredNumPartitions, (int)x$3, x$4, x$5, x$6, x$7, x$8);
        Assertions.assertEquals((int)createdPartitions, (int)actualNumPartitions);
    }

    @Test
    public void testTopicCreate() {
        int configuredNumPartitions = 5;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        int createdPartitions = TierTopicAdmin$.MODULE$.ensureTopic(this.adminZkClient(), this.topicName(), configuredNumPartitions, this.configuredReplicationFactor());
        Assertions.assertEquals((int)configuredNumPartitions, (int)createdPartitions);
        AdminZkClient qual$1 = (AdminZkClient)Mockito.verify((Object)this.adminZkClient(), (VerificationMode)Mockito.times((int)1));
        String x$1 = this.topicName();
        short x$3 = this.configuredReplicationFactor();
        Properties x$4 = TierTopicAdmin$.MODULE$.topicConfig();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(x$1, configuredNumPartitions, (int)x$3, x$4, x$5, x$6, x$7, x$8);
    }

    @Test
    public void testTopicExists() {
        int numPartitionsConfigured = 10;
        int numPartitionsExist = 5;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.adminZkClient().createTopic(this.topicName(), numPartitionsConfigured, (int)this.configuredReplicationFactor(), TierTopicAdmin$.MODULE$.topicConfig(), this.adminZkClient().createTopic$default$5(), this.adminZkClient().createTopic$default$6(), this.adminZkClient().createTopic$default$7(), this.adminZkClient().createTopic$default$8());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TopicExistsException("topic exists")});
        Mockito.when((Object)this.adminZkClient().numPartitions(this.topicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitionsExist)));
        int numPartitions = TierTopicAdmin$.MODULE$.ensureTopic(this.adminZkClient(), this.topicName(), numPartitionsConfigured, this.configuredReplicationFactor());
        Assertions.assertEquals((int)numPartitionsExist, (int)numPartitions);
    }

    @Test
    public void testUnknownException() {
        int numPartitionsConfigured = 10;
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.adminZkClient().topicExists(this.topicName()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.adminZkClient().createTopic(this.topicName(), numPartitionsConfigured, (int)this.configuredReplicationFactor(), TierTopicAdmin$.MODULE$.topicConfig(), this.adminZkClient().createTopic$default$5(), this.adminZkClient().createTopic$default$6(), this.adminZkClient().createTopic$default$7(), this.adminZkClient().createTopic$default$8());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new AdminOperationException("admin exception")});
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> TierTopicAdmin$.MODULE$.ensureTopic(this.adminZkClient(), this.topicName(), numPartitionsConfigured, this.configuredReplicationFactor()), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TierTopicAdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }

    public TierTopicAdminTest() {
        this.topicName = "testTopic";
    }
}

