/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.log.Log$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.TierMetadataDeserializationException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001\u0002\u00192\u0001aBQa\u0010\u0001\u0005\u0002\u0001+Aa\u0011\u0001\u0001\t\u0016!\u0001\u000b\u0001\u0001R\u0011\u001d!\u0006A1A\u0005\nUCaA\u0018\u0001!\u0002\u00131\u0006bB0\u0001\u0005\u0004%I\u0001\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000f!\u0004!\u0019!C\u0005+\"1\u0011\u000e\u0001Q\u0001\nYCqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004s\u0001\u0001\u0006I\u0001\u001c\u0005\bg\u0002\u0011\r\u0011\"\u0003u\u0011\u0019A\b\u0001)A\u0005k\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\tI\u0001\u0001Q\u0001\n\u0005\r\u0001\u0002CA\u0006\u0001\t\u0007I\u0011B+\t\u000f\u00055\u0001\u0001)A\u0005-\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0014!I\u0011\u0011\u0007\u0001C\u0002\u0013%\u00111\u0007\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00026!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002B!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\b\u0003'\u0002\u0001\u0015!\u0003R\u0011%\t)\u0006\u0001b\u0001\n\u0013\t9\u0006C\u0004\u0002Z\u0001\u0001\u000b\u0011\u0002#\t\u0013\u0005m\u0003A1A\u0005\n\u0005]\u0003bBA/\u0001\u0001\u0006I\u0001\u0012\u0005\n\u0003?\u0002!\u0019!C\u0005\u0003CB\u0001\"a\u001b\u0001A\u0003%\u00111\r\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"a\u001f\u0001A\u0003%\u0011\u0011\u000f\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003\u007fB\u0001\"a\"\u0001A\u0003%\u0011\u0011\u0011\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\tI\u000b\u0001C\u0001\u0003\u0017Cq!a-\u0001\t\u0003\tY\tC\u0004\u00028\u0002!\t!a#\t\u000f\u0005m\u0006\u0001\"\u0001\u0002\f\"9\u0011q\u0018\u0001\u0005\u0002\u0005-\u0005bBAb\u0001\u0011\u0005\u00111\u0012\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\tI\u0010\u0001C\u0001\u0003\u0017Cq!!@\u0001\t\u0013\tyPA\u000bUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ$Vm\u001d;\u000b\u0005I\u001a\u0014!\u0002;pa&\u001c'B\u0001\u001b6\u0003\u0011!\u0018.\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A!\u0011\u0005\t\u0003Q\"A\u0019\u0003!\r{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003B#I\u0015*k\u0011A\u0012\u0006\u0003\u000fN\naa\u00197jK:$\u0018BA%G\u0005QiunY6D_:\u001cX/\\3s'V\u0004\b\u000f\\5feB\u0019!hS'\n\u00051[$!B!se\u0006L\bC\u0001\u001eO\u0013\ty5H\u0001\u0003CsR,'\u0001\u0005)s_\u0012,8-\u001a:TkB\u0004H.[3s!\u0011)%K\u0013&\n\u0005M3%\u0001F'pG.\u0004&o\u001c3vG\u0016\u00148+\u001e9qY&,'/A\u0005dYV\u001cH/\u001a:JIV\ta\u000b\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006!A.\u00198h\u0015\u0005Y\u0016\u0001\u00026bm\u0006L!!\u0018-\u0003\rM#(/\u001b8h\u0003)\u0019G.^:uKJLE\rI\u0001\bi\u0016l\u0007\u000fR5s+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013[\u0003\tIw.\u0003\u0002gG\n!a)\u001b7f\u0003!!X-\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000f1|w\rR5sgV\tA\u000eE\u0002naZk\u0011A\u001c\u0006\u0003_j\u000bA!\u001e;jY&\u0011\u0011O\u001c\u0002\n\u0003J\u0014\u0018-\u001f'jgR\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0017i&,'\u000fV8qS\u000etU/\u001c)beRLG/[8ogV\tQ\u000f\u0005\u0002;m&\u0011qo\u000f\u0002\u0006'\"|'\u000f^\u0001\u0018i&,'\u000fV8qS\u000etU/\u001c)beRLG/[8og\u0002\nA\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0016\u0014X#A>\u0011\u0005\tc\u0018BA?2\u0005Q!\u0016.\u001a:U_BL7\rU1si&$\u0018n\u001c8fe\u0006)B/[3s)>\u0004\u0018n\u0019)beRLG/[8oKJ\u0004\u0013A\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0016\u0005\u0005\r\u0001c\u0001\"\u0002\u0006%\u0019\u0011qA\u0019\u0003-QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e\fq\u0003^5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017n\u001a\u0011\u0002\u001bQLWM\u001d+pa&\u001cg*Y7f\u00039!\u0018.\u001a:U_BL7MT1nK\u0002\n1\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]N,\"!a\u0005\u0011\u000b5\f)\"!\u0007\n\u0007\u0005]aNA\u0002TKR\u0004B!a\u0007\u0002,5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0004d_6lwN\u001c\u0006\u0004m\u0005\r\"\u0002BA\u0013\u0003O\ta!\u00199bG\",'BAA\u0015\u0003\ry'oZ\u0005\u0005\u0003[\tiB\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002)QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003%!\u0018.\u001a:U_BL7-\u0006\u0002\u00026A\u0019!)a\u000e\n\u0007\u0005e\u0012G\u0001\u000bJ]&$\u0018.\u00197ju\u0016$G+[3s)>\u0004\u0018nY\u0001\u000bi&,'\u000fV8qS\u000e\u0004\u0013\u0001\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3s+\t\t\t\u0005\u0005\u0003\u0002D\u0005%SBAA#\u0015\r\t9eM\u0001\bM\u0016$8\r[3s\u0013\u0011\tY%!\u0012\u0003!QKWM]*uCR,g)\u001a;dQ\u0016\u0014\u0018!\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3sA\u0005\u0001\u0002O]8ek\u000e,'oU;qa2LWM]\u000b\u0002#\u0006\t\u0002O]8ek\u000e,'oU;qa2LWM\u001d\u0011\u0002/A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014X#\u0001#\u00021A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\fdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006A2-\u0019;dQV\u00048i\u001c8tk6,'oU;qa2LWM\u001d\u0011\u00023QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\\7nSR$XM]\u000b\u0003\u0003G\u0002B!!\u001a\u0002h5\t1'C\u0002\u0002jM\u0012\u0011\u0004V5feR{\u0007/[2NC:\fw-\u001a:D_6l\u0017\u000e\u001e;fe\u0006QB/[3s)>\u0004\u0018nY'b]\u0006<WM]\"p[6LG\u000f^3sA\u00059Q.\u001a;sS\u000e\u001cXCAA9!\u0011\t\u0019(a\u001e\u000e\u0005\u0005U$\u0002BA7\u0003;IA!!\u001f\u0002v\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'/\u0006\u0002\u0002\u0002B\u0019!)a!\n\u0007\u0005\u0015\u0015GA\tUS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\f!\u0003^5feR{\u0007/[2D_:\u001cX/\\3sA\u0005)1/\u001a;vaR\u0011\u0011Q\u0012\t\u0004u\u0005=\u0015bAAIw\t!QK\\5uQ\r1\u0013Q\u0013\t\u0005\u0003/\u000b)+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\r\t\u0007/\u001b\u0006\u0005\u0003?\u000b\t+A\u0004kkBLG/\u001a:\u000b\t\u0005\r\u0016qE\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003O\u000bIJ\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011\u0003^3tiB{G\u000e\u001c#ve\u0006$\u0018n\u001c8tQ\r9\u0013Q\u0016\t\u0005\u0003/\u000by+\u0003\u0003\u00022\u0006e%\u0001\u0002+fgR\fa\u0003^3tiJ+w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004Q\u00055\u0016a\b;fgR$U\u000f\u001d7jG\u0006$XMU3hSN$XM\u001d)beRLG/[8og\"\u001a\u0011&!,\u0002mQ,7\u000f\u001e)sS6\f'/_\"p]N,X.\u001a:TK\u0016\\7\u000fV8MCN$8i\\7nSR$X\rZ(gMN,Go\u00148Ti\u0006\u0014H/\u001e9)\u0007)\ni+\u0001\fuKN$X*\u0019;fe&\fG.\u001b>bi&|g\u000eT1hQ\rY\u0013QV\u0001\u0014i\u0016\u001cHoQ1uG\",\boQ8na2,G/\u001a\u0015\u0004Y\u00055\u0016!\u0006;fgRl\u0015\r_'bi\u0016\u0014\u0018.\u00197ju\u0016d\u0015m\u001a\u000b\u0005\u0003\u001b\u000bY\rC\u0004\u0002N6\u0002\r!a4\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012\u00042AOAi\u0013\r\t\u0019n\u000f\u0002\b\u0005>|G.Z1oQ\u001di\u0013q[At\u0003S\u0004B!!7\u0002d6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\t\t/!(\u0002\rA\f'/Y7t\u0013\u0011\t)/a7\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u00111^Aw3\u0005\t\u0011$\u0001\u0001)\u00075\n\t\u0010\u0005\u0003\u0002t\u0006UXBAAp\u0013\u0011\t90a8\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/A\nuKN$x)\u0019:cC\u001e,\u0007*\u00198eY&tw\rK\u0002/\u0003[\u000b\u0001bZ3u'R\fG/\u001a\u000b\r\u0005\u0003\u0011iAa\u0006\u0003\u001a\t\r\"1\u0007\t\u0005\u0005\u0007\u0011I!\u0004\u0002\u0003\u0006)\u0019!qA\u001a\u0002\u000bM$\u0018\r^3\n\t\t-!Q\u0001\u0002\u0017\r&dW\rV5feB\u000b'\u000f^5uS>t7\u000b^1uK\"9!qB\u0018A\u0002\tE\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o!\u0011\t)Ga\u0005\n\u0007\tU1G\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011QP\u0018A\u0002\u0005\u0005\u0005b\u0002B\u000e_\u0001\u0007!QD\u0001\nGRD8\u000b^1ukN\u0004BAa\u0001\u0003 %!!\u0011\u0005B\u0003\u0005M!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^;t\u0011\u001d\u0011)c\fa\u0001\u0005O\t\u0011b]2iK\u0012,H.\u001a:\u0011\t\t%\"qF\u0007\u0003\u0005WQ1A!\f6\u0003\u0015)H/\u001b7t\u0013\u0011\u0011\tDa\u000b\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\bbBAg_\u0001\u0007\u0011q\u001a")
public class TierTopicConsumerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final short tierTopicNumPartitions = (short)10;
    private final TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner = new TierTopicPartitioner((int)this.tierTopicNumPartitions());
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName = TierTopic.topicName((String)"");
    private final java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (int)this.tierTopicNumPartitions());
    private final InitializedTierTopic tierTopic = (InitializedTierTopic)Mockito.mock(InitializedTierTopic.class);
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final TierTopicManagerCommitter tierTopicManagerCommitter = (TierTopicManagerCommitter)Mockito.mock(TierTopicManagerCommitter.class);
    private final Metrics metrics = new Metrics();
    private final TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.of(this.metrics()), (Time)new MockTime());

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName;
    }

    private java.util.Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private InitializedTierTopic tierTopic() {
        return this.tierTopic;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    private TierTopicManagerCommitter tierTopicManagerCommitter() {
        return this.tierTopicManagerCommitter;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.tierTopic().numPartitions()).thenReturn((Object)OptionalInt.of(this.tierTopicNumPartitions()));
        Mockito.when((Object)this.tierTopic().topicName()).thenReturn((Object)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName());
        Mockito.when((Object)this.tierTopic().toTierTopicPartition((TopicIdPartition)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TopicPartition>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public TopicPartition answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartition((TopicIdPartition)((TopicIdPartition)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopic().toTierTopicPartitions((Collection)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<java.util.Set<TopicPartition>>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public java.util.Set<TopicPartition> answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartitions((Collection)((Collection)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn(null);
    }

    @Test
    public void testPollDurations() {
        Consumer primary = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)primary.poll(Duration.ofMillis(0L))).thenReturn((Object)new ConsumerRecords(new HashMap()));
        TierTopicConsumer tierTopicConsumerWithMock = new TierTopicConsumer(this.tierTopicManagerConfig(), (Supplier)new Supplier<Consumer<byte[], byte[]>>(null, primary){
            private final Consumer primary$1;

            public Consumer<byte[], byte[]> get() {
                return this.primary$1;
            }
            {
                this.primary$1 = primary$1;
            }
        }, this.catchupConsumerSupplier(), this.tierTopicManagerCommitter(), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        tierTopicConsumerWithMock.register(tp_1, ctx_1);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.INIT);
        tierTopicConsumerWithMock.register(tp_2, ctx_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.immigratingPartitions().keySet()).asScala());
        tierTopicConsumerWithMock.initialize(this.tierTopic());
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.atLeastOnce())).assign((Collection)ArgumentMatchers.any());
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.atLeastOnce())).seekToBeginning((Collection)ArgumentMatchers.any());
        ((Consumer)Mockito.verify((Object)primary)).poll(Duration.ofMillis(0L));
        tierTopicConsumerWithMock.doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumerWithMock.primaryConsumerPartitions().keySet()).asScala());
        tierTopicConsumerWithMock.doWork();
        ((Consumer)Mockito.verify((Object)primary, (VerificationMode)Mockito.times((int)2))).poll(Duration.ofMillis(5L));
    }

    @Test
    public void testRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_4 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_4.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        TopicIdPartition tp_5 = new TopicIdPartition("foo-5", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_5 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_5.status()).thenReturn((Object)TierPartitionStatus.ERROR);
        TopicIdPartition tp_6 = new TopicIdPartition("foo-6", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_6 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_6.status()).thenReturn((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        this.tierTopicConsumer().register(tp_4, ctx_4);
        this.tierTopicConsumer().register(tp_5, ctx_5);
        this.tierTopicConsumer().register(tp_6, ctx_6);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2, tp_3, tp_4, tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4, tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_5, tp_6})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)0, (int)this.tierTopicConsumer().primaryConsumerErrorPartitions().size());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_5, (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_6, (VerificationMode)Mockito.times((int)0))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)3))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)4))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_5, (VerificationMode)Mockito.times((int)5))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_6, (VerificationMode)Mockito.times((int)5))).status();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_3});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_4});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_5});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_6});
        Assertions.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4, tp_5, tp_6}))).asJava()), (Object)this.catchupConsumerSupplier().consumers().get(0).assignment());
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)this.primaryConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testDuplicateRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TierTopicConsumer.ClientCtx ctx_new = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_new.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(tp_1));
        Assertions.assertTrue((boolean)this.tierTopicConsumer().isPartitionRegistered(tp_2));
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_3, ctx_3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierTopicConsumer().register(tp_1, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierTopicConsumer().register(tp_2, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierTopicConsumer().register(tp_3, ctx_new), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
    }

    @Test
    public void testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup() {
        scala.collection.mutable.Set committedOffsetMap = (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch((long)tierTopicPartition.partition() + 100L, Optional.of(Predef$.MODULE$.int2Integer(3)))), Set$.MODULE$.canBuildFrom());
        committedOffsetMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            return ongoingStubbing;
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assertions.assertNotNull((Object)this.tierTopicConsumer().tierTopic());
        Consumer<byte[], byte[]> primaryConsumer = this.primaryConsumerSupplier().consumers().get(0);
        Assertions.assertEquals(this.tierTopicPartitions(), (Object)primaryConsumer.assignment());
        committedOffsetMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TierTopicConsumerTest.$anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(primaryConsumer, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMaterializationLag() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)ctx_1.materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)30L));
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)ctx_2.materializationLag())).thenReturn((Object)BoxesRunTime.boxToLong((long)50L));
        ((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            return ongoingStubbing;
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)50.0), (Object)this.metrics().metric(this.tierTopicConsumer().maxTierLagMetricName).metricValue());
    }

    @Test
    public void testCatchupComplete() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        ((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tierTopicPartition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierTopicPartition), (Object)new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)))), Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            OffsetAndEpoch offset = (OffsetAndEpoch)x0$1._2();
            OngoingStubbing ongoingStubbing = Mockito.when((Object)this.tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)offset);
            return ongoingStubbing;
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Consumer<byte[], byte[]> catchupConsumer = this.catchupConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.asScalaSetConverter(catchupConsumer.assignment()).asScala();
        Assertions.assertEquals((int)2, (int)assignment.size());
        assignment.foreach((Function1 & Serializable & scala.Serializable)assignedPartition -> {
            catchupConsumer.seek(assignedPartition, 50L);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        catchupConsumer.seek((TopicPartition)assignment.head(), 100L);
        catchupConsumer.seek((TopicPartition)assignment.last(), 150L);
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchUpConsumerPartitions().keySet()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().primaryConsumerPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).completeCatchup();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMaxMaterializeLag(boolean checksumEnabled) {
        kafka.utils.MockTime time = new kafka.utils.MockTime();
        TopicIdPartition tp_1 = new TopicIdPartition("lag_test", UUID.randomUUID(), 0);
        FileTierPartitionState state_1 = this.getState(tp_1, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, time.scheduler(), checksumEnabled);
        TopicIdPartition tp_2 = new TopicIdPartition("lag_test2", UUID.randomUUID(), 0);
        FileTierPartitionState state_2 = this.getState(tp_2, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, time.scheduler(), checksumEnabled);
        TopicIdPartition tp_3 = new TopicIdPartition("lag_test3", UUID.randomUUID(), 0);
        FileTierPartitionState state_3 = this.getState(tp_3, this.tierTopicConsumer(), TierPartitionStatus.ONLINE, time.scheduler(), checksumEnabled);
        TopicIdPartition tp_4 = new TopicIdPartition("lag_test4", UUID.randomUUID(), 0);
        FileTierPartitionState state_4 = this.getState(tp_4, this.tierTopicConsumer(), TierPartitionStatus.CATCHUP, time.scheduler(), checksumEnabled);
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assertions.assertEquals((long)0L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.materializeUptoOffset(100L);
        state_2.materializeUptoOffset(101L);
        state_3.materializeUptoOffset(102L);
        state_4.materializeUptoOffset(103L);
        Assertions.assertEquals((long)103L, (long)this.tierTopicConsumer().maxMaterializationLag());
        state_1.close();
        state_2.close();
        state_3.close();
        state_4.close();
    }

    @Test
    public void testGarbageHandling() {
        ConsumerRecord garbageRecord = new ConsumerRecord("foo-1", 0, 1L, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> AbstractTierMetadata.deserialize((byte[])((byte[])garbageRecord.key()), (byte[])((byte[])garbageRecord.value())), ClassTag$.MODULE$.apply(TierMetadataDeserializationException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 417));
    }

    private FileTierPartitionState getState(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer, TierPartitionStatus ctxStatus, Scheduler scheduler, boolean checksumEnabled) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(Log$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, scheduler, checksumEnabled);
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        TierTopicConsumer.ClientCtx clientCtx = new TierTopicConsumer.ClientCtx(null, tierPartitionState, ctxStatus){
            private final FileTierPartitionState tierPartitionState$1;
            private final TierPartitionStatus ctxStatus$1;

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.ctxStatus$1;
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
                this.ctxStatus$1 = ctxStatus$1;
            }
        };
        tierTopicConsumer.register(topicIdPartition, clientCtx);
        return tierPartitionState;
    }

    public static final /* synthetic */ void $anonfun$testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup$3(Consumer primaryConsumer$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tierTopicPartition = (TopicPartition)x0$2._1();
            Assertions.assertEquals((long)((OffsetAndEpoch)x0$2._2()).offset(), (long)primaryConsumer$1.position(tierTopicPartition));
            return;
        }
        throw new MatchError(null);
    }

    public TierTopicConsumerTest() {
        this.clusterId = "mycluster";
    }
}

