/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.log.Log$;
import kafka.log.TierLogSegment;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u001d;\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%+A\u0001\u0014\u0001\u0001\u001b\u0016!\u0011\f\u0001\u0001[\u0011\u001di\u0006A1A\u0005\nyCaa\u001a\u0001!\u0002\u0013y\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007a\u0002\u0001\u000b\u0011\u00026\t\u000fE\u0004!\u0019!C\u0005=\"1!\u000f\u0001Q\u0001\n}Cqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004|\u0001\u0001\u0006I!\u001e\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\tI\u0001\u0001Q\u0001\nyD\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0001\"a\t\u0001\u0005\u0004%IA\u0018\u0005\b\u0003K\u0001\u0001\u0015!\u0003`\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u0016\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY\u0005C\u0004\u0002N\u0001\u0001\u000b\u0011\u0002.\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003bBA*\u0001\u0001\u0006I!\u0014\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003#Bq!a\u0016\u0001A\u0003%Q\nC\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u0011\u0011\u000e\u0001!\u0002\u0013\ti\u0006C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002n!A\u0011Q\u000f\u0001!\u0002\u0013\ty\u0007C\u0005\u0002\n\u0002\u0001\r\u0011\"\u0003\u0002\f\"I\u00111\u0014\u0001A\u0002\u0013%\u0011Q\u0014\u0005\t\u0003S\u0003\u0001\u0015)\u0003\u0002\u000e\"I\u00111\u0016\u0001C\u0002\u0013%\u0011Q\u0016\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u00020\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003C\u0004A\u0011AAe\u0011\u001d\tY\u000f\u0001C\u0001\u0003\u0013Dq!a<\u0001\t\u0003\tI\rC\u0004\u0002t\u0002!\t!!3\t\u000f\u0005]\b\u0001\"\u0001\u0002J\"9\u00111 \u0001\u0005\u0002\u0005%\u0007bBA\u0000\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005\u0007\u0001A\u0011AAe\u0011\u001d\u00119\u0001\u0001C\u0001\u0003\u0013DqAa\u0003\u0001\t\u0003\tI\rC\u0004\u0003\u0010\u0001!\t!!3\t\u000f\tM\u0001\u0001\"\u0001\u0002J\"9!q\u0003\u0001\u0005\n\te\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\n\u0005\u001b\u0002\u0011\u0013!C\u0005\u0005\u001fBqA!\u001a\u0001\t\u0013\tI\rC\u0004\u0003h\u0001!I!!3\t\u000f\t%\u0004\u0001\"\u0003\u0003l\t!B+[3s)>\u0004\u0018nY'b]\u0006<WM\u001d+fgRT!a\u000f\u001f\u0002\u000bQ|\u0007/[2\u000b\u0005ur\u0014\u0001\u0002;jKJT\u0011aP\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0003\"a\u0013\u0001\u000e\u0003i\u0012\u0001cQ8ogVlWM]*vaBd\u0017.\u001a:\u0011\t9\u000b6kU\u0007\u0002\u001f*\u0011\u0001\u000bP\u0001\u0007G2LWM\u001c;\n\u0005I{%\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0002D)ZK!!\u0016#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\r;\u0016B\u0001-E\u0005\u0011\u0011\u0015\u0010^3\u0003!A\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003\u0002(\\'NK!\u0001X(\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s\u0003%\u0019G.^:uKJLE-F\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014aa\u0015;sS:<\u0017AC2mkN$XM]%eA\u00059A/Z7q\t&\u0014X#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055\u001c\u0017AA5p\u0013\tyGN\u0001\u0003GS2,\u0017\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\u0001\\8h\t&\u00148/F\u0001v!\r1\u0018pX\u0007\u0002o*\u0011\u0001pY\u0001\u0005kRLG.\u0003\u0002{o\nI\u0011I\u001d:bs2K7\u000f^\u0001\tY><G)\u001b:tA\u0005\u0001B/[3s'R\fG/\u001a$fi\u000eDWM]\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002y\u00059a-\u001a;dQ\u0016\u0014\u0018\u0002BA\u0004\u0003\u0003\u0011\u0001\u0003V5feN#\u0018\r^3GKR\u001c\u0007.\u001a:\u0002#QLWM]*uCR,g)\u001a;dQ\u0016\u0014\b%\u0001\fuS\u0016\u0014Hk\u001c9jG:+X\u000eU1si&$\u0018n\u001c8t+\t\ty\u0001E\u0002D\u0003#I1!a\u0005E\u0005\u0015\u0019\u0006n\u001c:u\u0003]!\u0018.\u001a:U_BL7MT;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\fuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h+\t\tY\u0002E\u0002L\u0003;I1!a\b;\u0005Y!\u0016.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0017a\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4!\u00035!\u0018.\u001a:U_BL7MT1nK\u0006qA/[3s)>\u0004\u0018n\u0019(b[\u0016\u0004\u0013a\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA\u0016!\u00151\u0018QFA\u0019\u0013\r\tyc\u001e\u0002\u0004'\u0016$\b\u0003BA\u001a\u0003\u0007j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0007G>lWn\u001c8\u000b\u0007}\nYD\u0003\u0003\u0002>\u0005}\u0012AB1qC\u000eDWM\u0003\u0002\u0002B\u0005\u0019qN]4\n\t\u0005\u0015\u0013Q\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003Q!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8tA\u0005\u0001\u0002O]8ek\u000e,'oU;qa2LWM]\u000b\u00025\u0006\t\u0002O]8ek\u000e,'oU;qa2LWM\u001d\u0011\u0002/A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A'\u00021A\u0014\u0018.\\1ss\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b%A\fdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0006A2-\u0019;dQV\u00048i\u001c8tk6,'oU;qa2LWM\u001d\u0011\u0002\u001b\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019GP\u0001\u0003u.LA!a\u001a\u0002b\ti\u0011\tZ7j]j[7\t\\5f]R\fa\"\u00193nS:T6n\u00117jK:$\b%A\nbI6Lgn\u00117jK:$8+\u001e9qY&,'/\u0006\u0002\u0002pI1\u0011\u0011OA<\u0003{2a!a\u001d \u0001\u0005=$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014\u0001F1e[&t7\t\\5f]R\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005E\u0002a\u0003sJ1!a\u001fb\u0005\u0019y%M[3diB1\u0011qPAC\u0003;j!!!!\u000b\u0007\u0005\ru/\u0001\u0005gk:\u001cG/[8o\u0013\u0011\t9)!!\u0003\u0011M+\b\u000f\u001d7jKJ\fq\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001aKG.Z:\u0016\u0005\u00055\u0005\u0003B\"U\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+c\u0014!B:uCR,\u0017\u0002BAM\u0003'\u0013aCR5mKRKWM\u001d)beRLG/[8o'R\fG/Z\u0001\u001ci&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR5mKN|F%Z9\u0015\t\u0005}\u0015Q\u0015\t\u0004\u0007\u0006\u0005\u0016bAAR\t\n!QK\\5u\u0011%\t9+IA\u0001\u0002\u0004\ti)A\u0002yIE\n\u0001\u0004^5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001aKG.Z:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005=\u0006\u0003BAY\u0003ok!!a-\u000b\u0007\u0005Uf(A\u0003vi&d7/\u0003\u0003\u0002:\u0006M&\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\"!!1\u0011\u0007\r\u000b\u0019-C\u0002\u0002F\u0012\u0013qAQ8pY\u0016\fg.\u0001\u0005uK\u0006\u0014Hm\\<o)\t\ty\nK\u0002'\u0003\u001b\u0004B!a4\u0002^6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0002ba&TA!a6\u0002Z\u00069!.\u001e9ji\u0016\u0014(\u0002BAn\u0003\u007f\tQA[;oSRLA!a8\u0002R\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001bi\u0016\u001cH/\u00113e\u001b\u0016$\u0018\rZ1uC\n+gm\u001c:f%\u0016\fG-\u001f\u0015\u0004O\u0005\u0015\b\u0003BAh\u0003OLA!!;\u0002R\n!A+Z:u\u0003}!Xm\u001d;EkBd\u0017nY1uKJ+\u0017/^3ti\n+gm\u001c:f%\u0016\fG-\u001f\u0015\u0004Q\u0005\u0015\u0018A\f;fgR\u0014V\r\u001e:z\u001f:,fn\u001b8po:,\u0005pY3qi&|g\u000eR;sS:<Gk\u001c9jG\u000e\u0013X-\u0019;j_:D3!KAs\u0003\r\"Xm\u001d;QCJ$\u0018\u000e^5p]\u0016\u00148+\u001a;va^CWM\u001c+pa&\u001cW\t_5tiND3AKAs\u0003M!Xm\u001d;SKR\u0014\u0018.\u001a3NKN\u001c\u0018mZ3tQ\rY\u0013Q]\u0001;i\u0016\u001cHOR3oG&twMV5b!\u0006\u0014H/\u001b;j_:4UM\\2f\u000bZ,g\u000e^(o\u000b6\u0004H/\u001f+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D3\u0001LAs\u0003u\"Xm\u001d;GK:\u001c\u0017N\\4WS\u0006\u0004\u0016M\u001d;ji&|gNR3oG\u0016,e/\u001a8u\u001f:tuN\\#naRLH+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fQ\ri\u0013Q]\u0001$i\u0016\u001cHoU3u\u000bJ\u0014xN\u001d)beRLG/[8og\u0012+(/\u001b8h\r\u0016t7-\u001b8hQ\rq\u0013Q]\u0001 i\u0016\u001cHOU3d_Z,'o\u00165jY\u0016\u001c\u0015\r^2ikB\u001cuN\\:v[\u0016\u0014\bfA\u0018\u0002f\u00061C/Z:u\u0011\u0006tG\r\\5oO\u001a{'OU3ti>\u0014Xm\u00148O_:,%O]8s'R\fG/^:)\u0007A\n)/\u0001\u001buKN$\bK]8dKN\u001cX*Z:tC\u001e,7\u000fU8tiN#\u0018\r^3GK:\u001c\u0017N\\4EkJLgnZ(oY&tWm\u0015;bi\u0016D3!MAs\u0003)#Xm\u001d;Ue\u0006t7/\u001b;j_:4%o\\7DCR\u001c\u0007.\u001e9D_:\u001cX/\\3s)>\u0004&/[7bef\u001cuN\\:v[\u0016\u0014\u0018J\\#se>\u00148\u000b^1uKRCWM\u001c*fG>4XM]=)\u0007I\n)/\u0001\u0006bI\u0012\u0014V\r\u001d7jG\u0006$b!a(\u0003\u001c\t\u001d\u0002b\u0002B\u000fg\u0001\u0007!qD\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004BA!\t\u0003$5\tA(C\u0002\u0003&q\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000f\t%2\u00071\u0001\u0003,\u0005\tB/[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0011\u0007-\u0013i#C\u0002\u00030i\u0012\u0011\u0003V5feR{\u0007/[2D_:\u001cX/\\3s\u0003M\u0019X\r^;q)&,'oQ8na>tWM\u001c;t)\u0019\u0011)Da\u0012\u0003JAI1Ia\u000e\u0003,\tm\"\u0011I\u0005\u0004\u0005s!%A\u0002+va2,7\u0007\u0005\u0003\u0003\"\tu\u0012b\u0001B y\t\u0011B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\rY%1I\u0005\u0004\u0005\u000bR$\u0001\u0005+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0011%\t9\u0002\u000eI\u0001\u0002\u0004\tY\u0002C\u0004\u0003LQ\u0002\r!!1\u0002\u0017\t,7m\\7f%\u0016\fG-_\u0001\u001eg\u0016$X\u000f\u001d+jKJ\u001cu.\u001c9p]\u0016tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u000b\u0016\u0005\u00037\u0011\u0019f\u000b\u0002\u0003VA!!q\u000bB1\u001b\t\u0011IF\u0003\u0003\u0003\\\tu\u0013!C;oG\",7m[3e\u0015\r\u0011y\u0006R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B2\u00053\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003eiwN^3SK\u000e|'\u000fZ:U_\u0006cGnQ8ogVlWM]:\u00029I,7/\u001a8e!J,g/[8vgB\u0013x\u000eZ;dKJ+\u0017/^3ti\u0006q!-Z2p[\u0016\f%o\u00195jm\u0016\u0014HCCAP\u0005[\u0012yG!\u001f\u0003~!9!Q\u0004\u001dA\u0002\t}\u0001b\u0002B9q\u0001\u0007!1O\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eE\u0002D\u0005kJ1Aa\u001eE\u0005\rIe\u000e\u001e\u0005\b\u0005wB\u0004\u0019\u0001B!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'\u000fC\u0004\u0003*a\u0002\rAa\u000b")
public class TierTopicManagerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private final short tierTopicNumPartitions = (short)7;
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final AdminZkClient kafka$tier$topic$TierTopicManagerTest$$adminZkClient = (AdminZkClient)Mockito.mock(AdminZkClient.class);
    private final Supplier<AdminZkClient> adminClientSupplier = new Supplier<AdminZkClient>(this){
        private final /* synthetic */ TierTopicManagerTest $outer;

        public AdminZkClient get() {
            return this.$outer.kafka$tier$topic$TierTopicManagerTest$$adminZkClient();
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    };
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));
    private final kafka.utils.MockTime time = new kafka.utils.MockTime();

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    public AdminZkClient kafka$tier$topic$TierTopicManagerTest$$adminZkClient() {
        return this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient;
    }

    private Supplier<AdminZkClient> adminClientSupplier() {
        return this.adminClientSupplier;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    private kafka.utils.MockTime time() {
        return this.time;
    }

    public boolean checksumEnabled() {
        return false;
    }

    @AfterEach
    public void teardown() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).foreach((Function1 & Serializable & scala.Serializable)tierPartitionState -> {
            TierTopicManagerTest.$anonfun$teardown$1(tierPartitionState);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)new File(this.logDir()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddMetadataBeforeReady() {
        void var6_6;
        void var5_5;
        int epoch = 0;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo_1", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(topicIdPartition_1, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_1.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_1), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        tierTopicConsumer2.register(topicIdPartition_1, clientCtx_1);
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.immigratingPartitions().size());
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("foo_2", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(topicIdPartition_2, epoch, UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx clientCtx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)clientCtx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        Mockito.when((Object)clientCtx_2.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_2), (OffsetAndEpoch)ArgumentMatchers.any())).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
        tierTopicConsumer2.register(topicIdPartition_2, clientCtx_2);
        Assertions.assertEquals((int)2, (int)tierTopicConsumer2.immigratingPartitions().size());
        CompletableFuture future_1 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_1);
        CompletableFuture future_2 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_2);
        Assertions.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$1(this, (TierTopicConsumer)tierTopicConsumer2, future_1, future_2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testAddMetadataBeforeReady$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_1.get());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_2.get());
        Assertions.assertEquals((int)2, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateRequestBeforeReady() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int epoch = 0;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        UUID objectId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, epoch, objectId, 0);
        CompletableFuture oldInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
        CompletableFuture newInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (TierPartitionState.AppendResult)oldInitLeaderResult.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierTopicManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148))).getCause() instanceof TierMetadataFatalException));
        Assertions.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$2(this, (TierTopicConsumer)tierTopicConsumer2, newInitLeaderResult)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testDuplicateRequestBeforeReady$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, newInitLeaderResult.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetryOnUnknownExceptionDuringTopicCreation() {
        void var5_5;
        void var4_4;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var4_4;
        void tierTopicManager2 = var5_5;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((AdminZkClient)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException("timeout when creating topic")}).doThrow(new Throwable[]{new AdminOperationException("admin operation exception")}).doNothing().when((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient())).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((AdminZkClient)Mockito.verify((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient(), (VerificationMode)Mockito.times((int)1))).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        ((AdminZkClient)Mockito.verify((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient(), (VerificationMode)Mockito.times((int)2))).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertTrue((boolean)tierTopicManager2.isReady());
        ((AdminZkClient)Mockito.verify((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient(), (VerificationMode)Mockito.times((int)3))).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((int)this.tierTopicNumPartitions(), (int)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionerSetupWhenTopicExists() {
        void var6_6;
        void var5_5;
        int existingPartitions = this.tierTopicNumPartitions() - 2;
        boolean x$1 = false;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        Assertions.assertFalse((boolean)tierTopicManager2.isReady());
        this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient().createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TopicExistsException("topic exists")});
        Mockito.when((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient().numPartitions(this.tierTopicName())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)existingPartitions)));
        tierTopicManager2.tryBecomeReady(false);
        Assertions.assertTrue((boolean)tierTopicManager2.isReady());
        Assertions.assertEquals((int)existingPartitions, (int)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetriedMessages() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100, true, false, false, new OffsetAndEpoch(Long.MAX_VALUE, Optional.empty()), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, initiateResult.get());
        this.resendPreviousProduceRequest();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        CompletableFuture completeResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        tierTopicConsumer2.doWork();
        Assertions.assertFalse((boolean)completeResult.isDone(), (String)"Upload complete result should not have been completed by materialization of UploadInitiate");
        Assertions.assertEquals((long)1L, (long)tierTopicConsumer2.numListeners());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnEmptyTierPartitionState() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        CompletableFuture partitionFenceFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionFence);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(this, (TierTopicConsumer)tierTopicConsumer2, partitionFenceFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingViaPartitionFenceEventOnNonEmptyTierPartitionState() {
        void var8_8;
        void var7_7;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierPartitionFence partitionFence = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), false);
        int leaderEpoch = 31;
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var7_7;
        void tierTopicManager2 = var8_8;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((int)leaderEpoch, (int)this.tierPartitionStateFiles()[0].tierEpoch());
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, UUID.randomUUID(), 0L, 100L, 100L, 100, true, false, false, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierSegmentUploadComplete(uploadInitiate));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, uploadCompleteFuture.get());
        Assertions.assertEquals((Object)uploadInitiate.objectId(), (Object)((TierLogSegment)this.tierPartitionStateFiles()[0].metadata(100L).get()).objectId());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        CompletableFuture partitionFenceFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)partitionFence);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)partitionFenceFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, partitionFenceFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSetErrorPartitionsDuringFencing() {
        void var6_6;
        void var5_5;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var5_5;
        void tierTopicManager2 = var6_6;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100, true, false, false, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture initiateResultFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$1(this, (TierTopicConsumer)tierTopicConsumer2, initiateResultFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testSetErrorPartitionsDuringFencing$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, initiateResultFuture.get());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.catchUpConsumerErrorPartitions()).asScala());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverWhileCatchupConsumer() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, state.lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100, true, false, false, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenThrow(new Throwable[]{new IOException("couldn't fetch")}).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.catchUpConsumerPartitions().size());
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$1(this, (TierTopicConsumer)tierTopicConsumer2, uploadCompleteFuture, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testRecoverWhileCatchupConsumer$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)2))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHandlingForRestoreOnNonErrorStatus() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        state.flush();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
        ByteBuffer restoreBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)restoreBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$1(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testHandlingForRestoreOnNonErrorStatus$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessMessagesPostStateFencingDuringOnlineState() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)this.tierPartitionStateFiles()[0].status());
        this.becomeArchiver(topicIdPartition, leaderEpoch, (TierTopicManager)tierTopicManager2, (TierTopicConsumer)tierTopicConsumer2);
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)this.tierPartitionStateFiles()[0].status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        UUID objectId = UUID.randomUUID();
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(topicIdPartition, 0, objectId, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch());
        CompletableFuture uploadCompleteFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadCompleteFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadCompleteFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100, true, false, false, this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), this.tierPartitionStateFiles()[0].lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        TierObjectStore.TierStateRestoreSnapshotMetadata recoverSnapshotMetadata = new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata);
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(recoverSnapshotMetadata)).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
        ((TierStateFetcher)Mockito.verify((Object)this.tierStateFetcher(), (VerificationMode)Mockito.times((int)1))).fetchRecoverSnapshot(recoverSnapshotMetadata);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery() {
        void var7_7;
        void var6_6;
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        boolean x$1 = true;
        TierTopicManagerConfig x$2 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$2, x$1);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
        TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
        void tierTopicConsumer2 = var6_6;
        void tierTopicManager2 = var7_7;
        this.addReplica(topicIdPartition, (TierTopicConsumer)tierTopicConsumer2);
        FileTierPartitionState state = this.tierPartitionStateFiles()[0];
        Assertions.assertEquals((Object)TierPartitionStatus.INIT, (Object)state.status());
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertEquals((Object)TierPartitionStatus.CATCHUP, (Object)state.status());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        state.flush();
        ByteBuffer beforeFenceBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 100L, 100L, 100, true, false, false, state.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        CompletableFuture uploadInitiateFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(this, (TierTopicConsumer)tierTopicConsumer2, uploadInitiateFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)uploadInitiateFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.tierPartitionStateFiles()[0].status());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, uploadInitiateFuture.get());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerPartitions().size());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerPartitions().size());
        CompletableFuture becomeArchiverFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, becomeArchiverFuture.get());
        Assertions.assertEquals((int)0, (int)tierTopicConsumer2.catchUpConsumerErrorPartitions().size());
        Assertions.assertEquals((int)1, (int)tierTopicConsumer2.primaryConsumerErrorPartitions().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{topicIdPartition})), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(tierTopicConsumer2.primaryConsumerErrorPartitions()).asScala());
        TierPartitionForceRestore recoverMetadata = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), Predef$.MODULE$.Long2long(state.startOffset().orElse(Predef$.MODULE$.long2Long(-1L))), state.endOffset(), state.lastLocalMaterializedSrcOffsetAndEpoch(), "myhash", Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.tierStateFetcher().fetchRecoverSnapshot(new TierObjectStore.TierStateRestoreSnapshotMetadata(recoverMetadata))).thenReturn((Object)beforeFenceBuffer);
        TierTopic tierTopic = new TierTopic("");
        tierTopic.initialize((int)this.tierTopicNumPartitions());
        this.producerSupplier().producer().send(new ProducerRecord(tierTopic.topicName(), Predef$.MODULE$.int2Integer(tierTopic.toTierTopicPartition(topicIdPartition).partition()), (Object)recoverMetadata.serializeKey(), (Object)recoverMetadata.serializeValue()));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(this, (TierTopicConsumer)tierTopicConsumer2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)tierTopicConsumer2.primaryConsumerErrorPartitions().isEmpty());
        Assertions.assertTrue((boolean)tierTopicConsumer2.catchUpConsumerErrorPartitions().isEmpty());
        CompletableFuture becomeArchiverFinalFuture = tierTopicManager2.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch + 1, UUID.randomUUID(), 1));
        this.moveRecordsToAllConsumers();
        tierTopicConsumer2.doWork();
        Assertions.assertTrue((boolean)becomeArchiverFinalFuture.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFinalFuture.get());
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer) {
        File dir = new File(new StringBuilder(1).append(this.logDir()).append("/").append(Log$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState = new FileTierPartitionState(dir, new LogDirFailureChannel(5), topicIdPartition.topicPartition(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        tierPartitionState.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles())).$colon$plus((Object)tierPartitionState, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(null, tierPartitionState){
            private final FileTierPartitionState tierPartitionState$1;

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, OffsetAndEpoch offsetAndEpoch) {
                return this.tierPartitionState$1.append(metadata, offsetAndEpoch);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public long materializationLag() {
                return this.tierPartitionState$1.materializationLag();
            }

            public TierPartitionState.RestoreResult processRestoreEvents(AbstractTierMetadata metadata, TierPartitionStatus status, OffsetAndEpoch offsetAndEpoch, Optional<ByteBuffer> buffer) {
                return this.tierPartitionState$1.processRestoreEvents(metadata, buffer, status, offsetAndEpoch);
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    private Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> setupTierComponents(TierTopicManagerConfig tierTopicManagerConfig, boolean becomeReady) {
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(tierTopicManagerConfig, this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), new TierTopicManagerCommitter(tierTopicManagerConfig, new LogDirFailureChannel(1)), this.tierStateFetcher(), Optional.empty(), (Time)new MockTime());
        TierReplicaManager tierReplicaManager = new TierReplicaManager();
        TierTopicManager tierTopicManager = new TierTopicManager(tierTopicManagerConfig, tierTopicConsumer, this.producerSupplier(), this.adminClientSupplier());
        if (becomeReady) {
            Assertions.assertTrue((boolean)tierTopicManager.tryBecomeReady(false));
        }
        return new Tuple3((Object)tierTopicConsumer, (Object)tierReplicaManager, (Object)tierTopicManager);
    }

    private TierTopicManagerConfig setupTierComponents$default$1() {
        return this.tierTopicManagerConfig();
    }

    private void moveRecordsToAllConsumers() {
        this.primaryConsumerSupplier().moveRecordsFromProducer();
        this.catchupConsumerSupplier().moveRecordsFromProducer();
    }

    private void resendPreviousProduceRequest() {
        MockProducer<byte[], byte[]> mockProducer = this.producerSupplier().producer();
        ProducerRecord lastSentRecord = (ProducerRecord)mockProducer.history().get(mockProducer.history().size() - 1);
        this.producerSupplier().producer().send(lastSentRecord);
        this.moveRecordsToAllConsumers();
    }

    /*
     * WARNING - void declaration
     */
    private void becomeArchiver(TopicIdPartition topicIdPartition, int leaderEpoch, TierTopicManager tierTopicManager, TierTopicConsumer tierTopicConsumer) {
        CompletableFuture becomeArchiverFuture = tierTopicManager.addMetadata((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, leaderEpoch, UUID.randomUUID(), 1));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerTest.$anonfun$becomeArchiver$1(this, tierTopicConsumer, becomeArchiverFuture)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerTest.$anonfun$becomeArchiver$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFuture.get());
    }

    public static final /* synthetic */ void $anonfun$teardown$1(FileTierPartitionState tierPartitionState) {
        tierPartitionState.close();
        tierPartitionState.delete();
    }

    public static final /* synthetic */ boolean $anonfun$testAddMetadataBeforeReady$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$1, CompletableFuture future_1$1, CompletableFuture future_2$1) {
        $this.primaryConsumerSupplier().moveRecordsFromProducer();
        tierTopicConsumer$1.doWork();
        return future_1$1.isDone() && future_2$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testAddMetadataBeforeReady$2() {
        return "Timed out waiting for futures to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testDuplicateRequestBeforeReady$2(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$2, CompletableFuture newInitLeaderResult$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$2.doWork();
        return newInitLeaderResult$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testDuplicateRequestBeforeReady$3() {
        return "Timed out waiting to become archiver";
    }

    public static final /* synthetic */ boolean $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$3, CompletableFuture partitionFenceFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$3.doWork();
        return partitionFenceFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testFencingViaPartitionFenceEventOnEmptyTierPartitionState$2() {
        return "Timed out trying to finish TierPartitionFence";
    }

    public static final /* synthetic */ boolean $anonfun$testSetErrorPartitionsDuringFencing$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$4, CompletableFuture initiateResultFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$4.doWork();
        return initiateResultFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testSetErrorPartitionsDuringFencing$2() {
        return "Timed out trying to finish TierSegmentUploadInitiate";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoverWhileCatchupConsumer$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$5, CompletableFuture uploadCompleteFuture$1, CompletableFuture uploadInitiateFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$5.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            if (uploadCompleteFuture$1.isDone() && uploadInitiateFuture$1.isDone()) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testRecoverWhileCatchupConsumer$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testHandlingForRestoreOnNonErrorStatus$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$6) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$6.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testHandlingForRestoreOnNonErrorStatus$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$7) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$7.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testProcessMessagesPostStateFencingDuringOnlineState$2() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8, CompletableFuture uploadInitiateFuture$2) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        return uploadInitiateFuture$2.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$2() {
        return "Timed out waiting for upload initiate future";
    }

    public static final /* synthetic */ boolean $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$3(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$8) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$8.doWork();
        TierPartitionStatus tierPartitionStatus = $this.tierPartitionStateFiles()[0].status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTransitionFromCatchupConsumerToPrimaryConsumerInErrorStateThenRecovery$4() {
        return "Timed out waiting for recover metadata future";
    }

    public static final /* synthetic */ boolean $anonfun$becomeArchiver$1(TierTopicManagerTest $this, TierTopicConsumer tierTopicConsumer$9, CompletableFuture becomeArchiverFuture$1) {
        $this.moveRecordsToAllConsumers();
        tierTopicConsumer$9.doWork();
        return becomeArchiverFuture$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$becomeArchiver$2() {
        return "Timed out waiting to become archiver";
    }

    public TierTopicManagerTest() {
        this.clusterId = "mycluster";
    }
}

