/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.api.ApiVersion;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0013'\u0001-BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004A\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0003\u0002\u0011\r\u0011\"\u00018\u0011\u0019\u0011\u0005\u0001)A\u0005q!91\t\u0001b\u0001\n\u0003!\u0005BB&\u0001A\u0003%Q\tC\u0004M\u0001\t\u0007I\u0011A'\t\ra\u0003\u0001\u0015!\u0003O\u0011\u001dI\u0006A1A\u0005\u00025CaA\u0017\u0001!\u0002\u0013q\u0005bB.\u0001\u0005\u0004%\t!\u0014\u0005\u00079\u0002\u0001\u000b\u0011\u0002(\t\u000fu\u0003!\u0019!C\u0001=\"1Q\r\u0001Q\u0001\n}CqA\u001a\u0001C\u0002\u0013\u0005q\r\u0003\u0004t\u0001\u0001\u0006I\u0001\u001b\u0005\ni\u0002\u0001\r\u00111A\u0005\u0002UD\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0001?\t\u0015\u0005\u0015\u0001\u00011A\u0001B\u0003&a\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\u0006\u0001\u0005\u0002\u0005M\u0001bBA\u0019\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003w\u0001A\u0011AA\n\u0011\u001d\t)\u0005\u0001C\u0001\u0003'Aq!!\u0013\u0001\t\u0003\t\u0019\u0002C\u0004\u0002N\u0001!\t!a\u0005\t\u000f\u0005E\u0003\u0001\"\u0001\u0002\u0014!9\u0011Q\u000b\u0001\u0005\u0002\u0005M\u0001bBA-\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002\u0014\t\u0019B)^7q\u0019><7+Z4nK:$8\u000fV3ti*\u0011q\u0005K\u0001\u0006i>|Gn\u001d\u0006\u0002S\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000e\t\u0003k\u0001i\u0011AJ\u0001\u0007i6\u0004H)\u001b:\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\u0005%|'\"A\u001f\u0002\t)\fg/Y\u0005\u0003\u007fi\u0012AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u0017M,w-\\3oi:\u000bW.Z\u000b\u0002\u000bB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nP\u0001\u0005Y\u0006tw-\u0003\u0002K\u000f\n11\u000b\u001e:j]\u001e\fAb]3h[\u0016tGOT1nK\u0002\n1\u0002\\8h\r&dW\rU1uQV\ta\n\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#:j\u0011A\u0015\u0006\u0003'*\na\u0001\u0010:p_Rt\u0014BA+/\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0016\u0006\u0003+:\nA\u0002\\8h\r&dW\rU1uQ\u0002\nQ\"\u001b8eKb4\u0015\u000e\\3QCRD\u0017AD5oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0012i&lW-\u00138eKb4\u0015\u000e\\3QCRD\u0017A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002\nA\u0001^5nKV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002cQ\u0005)Q\u000f^5mg&\u0011A-\u0019\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059!-\u0019;dQ\u0016\u001cX#\u00015\u0011\u0007%t\u0007/D\u0001k\u0015\tYG.A\u0004nkR\f'\r\\3\u000b\u00055t\u0013AC2pY2,7\r^5p]&\u0011qN\u001b\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u00026c&\u0011!O\n\u0002\n\u0005\u0006$8\r[%oM>\f\u0001BY1uG\",7\u000fI\u0001\u0004Y><W#\u0001<\u0011\u0005]LX\"\u0001=\u000b\u0005QD\u0013B\u0001>y\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u000f1|wm\u0018\u0013fcR\u0019Q0!\u0001\u0011\u00055r\u0018BA@/\u0005\u0011)f.\u001b;\t\u0011\u0005\r1#!AA\u0002Y\f1\u0001\u001f\u00132\u0003\u0011awn\u001a\u0011\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\"!a\u0003\u0011\u00075\ni!C\u0002\u0002\u00109\u0012qAQ8pY\u0016\fg.A\u0003tKR,\u0006\u000fF\u0001~Q\r1\u0012q\u0003\t\u0005\u00033\tY#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\r\t\u0007/\u001b\u0006\u0005\u0003C\t\u0019#A\u0004kkBLG/\u001a:\u000b\t\u0005\u0015\u0012qE\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003S\t1a\u001c:h\u0013\u0011\ti#a\u0007\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\tbI\u0012\u001c\u0016.\u001c9mKJ+7m\u001c:eg\u0006AA/Z1s\t><h\u000eK\u0002\u0019\u0003k\u0001B!!\u0007\u00028%!\u0011\u0011HA\u000e\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0011uKN$()\u0019;dQ\u0006sGMU3d_J$W*\u001a;bI\u0006$\u0018mT;uaV$\bfA\r\u0002@A!\u0011\u0011DA!\u0013\u0011\t\u0019%a\u0007\u0003\tQ+7\u000f^\u0001\u0011i\u0016\u001cH\u000f\u0015:j]R$\u0015\r^1M_\u001eD3AGA \u0003]!Xm\u001d;Ek6\u0004\u0018J\u001c3fq6K7/\\1uG\",7\u000fK\u0002\u001c\u0003\u007f\tq\u0003^3ti\u0012+X\u000e\u001d+j[\u0016Le\u000eZ3y\u000bJ\u0014xN]:)\u0007q\ty$\u0001\u000euKN$H)^7q)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rK\u0002\u001e\u0003\u007f\tq\u0003^3ti\u0012+X\u000e]'fi\u0006$\u0017\r^1SK\u000e|'\u000fZ:)\u0007y\ty$\u0001\nuKN$H)^7q\u000b6\u0004H/_%oI\u0016D\bfA\u0010\u0002@\u0005\u0011\"/\u001e8Ek6\u0004Hj\\4TK\u001elWM\u001c;t)\rq\u0015\u0011\r\u0005\b\u0003G\u0002\u0003\u0019AA3\u0003\u0011\t'oZ:\u0011\t5\n9GT\u0005\u0004\u0003Sr#!B!se\u0006L\u0018!\u0005:fC\u0012\u0014\u0015\r^2i\u001b\u0016$\u0018\rZ1uCR!\u0011qNA;!\u0011i\u0013\u0011\u000f(\n\u0007\u0005MdF\u0001\u0004PaRLwN\u001c\u0005\b\u0003o\n\u0003\u0019AA=\u0003\u0015a\u0017N\\3t!\u0015\tY(!!O\u001b\t\tiHC\u0002\u0002\u0000q\nA!\u001e;jY&!\u00111QA?\u00051a\u0015n\u001d;Ji\u0016\u0014\u0018\r^8s\u0003A\u0011X-\u00193CCR\u001c\u0007NU3d_J$7\u000f\u0006\u0003\u0002\n\u0006E\u0005#BAF\u0003\u001bsU\"\u00017\n\u0007\u0005=ENA\u0002TKFDq!a\u001e#\u0001\u0004\tI(A\nqCJ\u001cX-T3uC\u0012\fG/\u0019$jK2$7\u000f\u0006\u0003\u0002\u0018\u0006u\u0005#B(\u0002\u001a:s\u0015bAAN/\n\u0019Q*\u00199\t\r\u0005}5\u00051\u0001O\u0003\u0011a\u0017N\\3\u00027\u0005\u001c8/\u001a:u\tVl\u0007\u000fT8h%\u0016\u001cwN\u001d3NKR\fG-\u0019;b\u0001")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public boolean checksumEnabled() {
        return false;
    }

    @BeforeEach
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        props.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some(Mockito.mock(TierTopicConsumer.class)), (Option)new Some(Mockito.mock(TierObjectStore.class)), new TierPartitionStateFactory(true, this.checksumEnabled()));
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = new Metrics();
        MockTime x$8 = this.time();
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        boolean x$15 = true;
        None$ x$16 = None$.MODULE$;
        LogOffsetsListener x$17 = MergedLog$.MODULE$.apply$default$16();
        this.log_$eq((AbstractLog)MergedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$6, x$7, (Time)x$8, x$9, x$10, x$11, tierLogComponents, x$14, (Option)x$12, x$15, x$17, (Option)x$16));
    }

    public void addSimpleRecords() {
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$addSimpleRecords$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable & scala.Serializable)batchInfo -> {
            AbstractLog qual$1 = this.log();
            MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toSeq().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            int x$2 = 0;
            AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
            ApiVersion x$4 = qual$1.appendAsLeader$default$4();
            RequestLocal x$5 = qual$1.appendAsLeader$default$5();
            return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        });
        this.log().flush();
    }

    @AfterEach
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testBatchAndRecordMetadataOutput() {
        AbstractLog qual$1 = this.log();
        MemoryRecords x$1 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())});
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        AbstractLog qual$2 = this.log();
        MemoryRecords x$6 = MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "c".getBytes(), "1".getBytes()), new SimpleRecord("d".getBytes())});
        int x$7 = 3;
        AppendOrigin x$8 = qual$2.appendAsLeader$default$3();
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, x$8, x$9, x$10);
        AbstractLog qual$3 = this.log();
        MemoryRecords x$11 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("e".getBytes(), null), new SimpleRecord(null, "f".getBytes()), new SimpleRecord("g".getBytes())});
        int x$12 = 3;
        AppendOrigin x$13 = qual$3.appendAsLeader$default$3();
        ApiVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
        AbstractLog qual$4 = this.log();
        MemoryRecords x$16 = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)29342342L, (short)((short)15), (int)234123, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("h".getBytes())});
        int x$17 = 3;
        AppendOrigin x$18 = qual$4.appendAsLeader$default$3();
        ApiVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
        AbstractLog qual$5 = this.log();
        MemoryRecords x$21 = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.GZIP, (long)98323L, (short)((short)99), (int)266, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("i".getBytes()), new SimpleRecord("j".getBytes())});
        int x$22 = 5;
        AppendOrigin x$23 = qual$5.appendAsLeader$default$3();
        ApiVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, x$22, x$23, x$24, x$25);
        AbstractLog qual$6 = this.log();
        MemoryRecords x$26 = MemoryRecords.withEndTransactionMarker((long)98323L, (short)((short)99), (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.COMMIT, 100));
        AppendOrigin.Coordinator$ x$27 = AppendOrigin.Coordinator$.MODULE$;
        int x$28 = 7;
        ApiVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, x$28, (AppendOrigin)x$27, x$29, x$30);
        this.assertDumpLogRecordMetadata();
    }

    @Test
    public void testPrintDataLog() {
        this.addSimpleRecords();
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        this.addSimpleRecords();
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        this.addSimpleRecords();
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    @Test
    public void testDumpTierPartitionState() {
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.log().topicPartition().topic(), UUID.randomUUID(), this.log().topicPartition().partition());
        AbstractLog qual$1 = this.log();
        Uuid x$1 = topicIdPartition.kafkaTopicId();
        int x$2 = qual$1.assignTopicId$default$2();
        qual$1.assignTopicId(x$1, x$2);
        this.log().tierPartitionState().beginCatchup();
        this.log().tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.empty()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.log().tierPartitionState().append((AbstractTierMetadata)new TierSegmentUploadInitiate(topicIdPartition, 0, UUID.randomUUID(), 0L, 1L, 1500L, 100, true, false, true, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED), new OffsetAndEpoch(1L, Optional.empty())));
        this.log().tierPartitionState().flush();
        String suffix = this.checksumEnabled() ? Algorithm.ADLER.suffix : Algorithm.NO_CHECKSUM.suffix;
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments((String[])((Object[])new String[]{"--files", new StringBuilder(0).append(Log$.MODULE$.tierStateFile(this.log().dir(), 0L, Log$.MODULE$.tierStateFile$default$3()).getAbsolutePath()).append(suffix).toString()})), topicIdPartition);
        DumpLogSegmentsTest.validate$1(this.runDumpLogSegments((String[])((Object[])new String[]{"--files", new StringBuilder(8).append(Log$.MODULE$.tierStateFile(this.log().dir(), 0L, Log$.MODULE$.tierStateFile$default$3()).getAbsolutePath()).append(".mutable").append(suffix).toString()})), topicIdPartition);
    }

    @Test
    public void testDumpMetadataRecords() {
        MockTime mockTime = new MockTime();
        int x$1 = 0x100000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$11 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        boolean x$12 = LogTestUtils$.MODULE$.createLogConfig$default$12();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        AbstractLog log = LogTestUtils$.MODULE$.createLog(this.logDir(), logConfig, new BrokerTopicStats(), mockTime.scheduler(), (Time)mockTime, LogTestUtils$.MODULE$.createLog$default$6(), LogTestUtils$.MODULE$.createLog$default$7(), LogTestUtils$.MODULE$.createLog$default$8(), LogTestUtils$.MODULE$.createLog$default$9(), LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15());
        SimpleRecord[] records = (SimpleRecord[])((TraversableOnce)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(20L), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("test-topic").setTopicId(Uuid.randomUuid()), (short)0), (List)new .colon.colon((Object)new ApiMessageAndVersion((ApiMessage)new PartitionChangeRecord().setTopicId(Uuid.randomUuid()).setLeader(1).setPartitionId(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)})), (short)0), (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)message -> {
            MetadataRecordSerde serde = new MetadataRecordSerde();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ByteBuffer buf = ByteBuffer.allocate(serde.recordSize(message, cache));
            ByteBufferAccessor writer = new ByteBufferAccessor(buf);
            serde.write(message, cache, (Writable)writer);
            buf.flip();
            return new SimpleRecord(null, buf.array());
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.flush();
        String output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "false", "--files", this.logFilePath()}));
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()}));
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        ByteBuffer buf = ByteBuffer.allocate(4);
        ByteBufferAccessor writer = new ByteBufferAccessor(buf);
        writer.writeUnsignedVarint(10000);
        writer.writeUnsignedVarint(10000);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(null, buf.array())}), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records), 2, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        output = this.runDumpLogSegments((String[])((Object[])new String[]{"--cluster-metadata-decoder", "--skip-record-metadata", "false", "--files", this.logFilePath()}));
        Predef$.MODULE$.assert(output.contains("TOPIC_RECORD"));
        Predef$.MODULE$.assert(output.contains("BROKER_RECORD"));
        Predef$.MODULE$.assert(output.contains("skipping"));
    }

    @Test
    public void testDumpEmptyIndex() {
        File indexFile = new File(this.indexFilePath());
        new PrintWriter(indexFile).close();
        String expectOutput = new StringBuilder(11).append(indexFile).append(" is empty.\n").toString();
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.dumpIndex(indexFile, false, true, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), Integer.MAX_VALUE));
        Assertions.assertEquals((Object)expectOutput, (Object)outContent.toString());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outContent));
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        System.setOut(System.out);
        return outContent.toString();
    }

    private Option<String> readBatchMetadata(ListIterator<String> lines) {
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                throw new IllegalStateException("Read unexpected record entry");
            }
            if (!line.startsWith("baseOffset")) continue;
            return new Some((Object)line);
        }
        return None$.MODULE$;
    }

    private Seq<String> readBatchRecords(ListIterator<String> lines) {
        ArrayBuffer records = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (lines.hasNext()) {
            String line = lines.next();
            if (line.startsWith("|")) {
                records.$plus$eq((Object)line.substring(1));
                continue;
            }
            lines.previous();
            return records.toSeq();
        }
        return records.toSeq();
    }

    private scala.collection.immutable.Map<String, String> parseMetadataFields(String line) {
        scala.collection.mutable.Map fields = Map$.MODULE$.empty();
        Iterator tokens = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$parseMetadataFields$2(x$5))))).iterator();
        while (tokens.hasNext()) {
            String token = (String)tokens.next();
            if (!token.endsWith(":")) {
                throw new IllegalStateException(new StringBuilder(27).append("Unexpected non-field token ").append(token).toString());
            }
            String field = token.substring(0, token.length() - 1);
            if (!tokens.hasNext()) {
                throw new IllegalStateException(new StringBuilder(26).append("Failed to parse value for ").append(field).toString());
            }
            String value = (String)tokens.next();
            fields.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)value));
        }
        return fields.toMap(Predef$.MODULE$.$conforms());
    }

    private void assertDumpLogRecordMetadata() {
        FetchDataInfo logReadInfo = (FetchDataInfo)this.log().read(0L, Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
        ListIterator<Object> lines = Arrays.asList((Object[])this.runDumpLogSegments((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()})).split("\n")).listIterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(logReadInfo.records().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$1(this, lines, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$addSimpleRecords$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            batch.records().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)recordIndex -> {
                if (i$1.elem == index$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                ++i$1.elem;
            });
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new AssertionError((Object)new StringBuilder(19).append("No match for index ").append(index).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$1) {
        return x$1.records().size();
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 2 ? 1 : 0) != 0, (String)new StringBuilder(18).append("Data not printed: ").append(output).toString());
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$1)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()), (String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString());
                batch$1.elem = (BatchInfo)batchIterator.next();
                return;
            }
            Assertions.assertTrue((boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()), (String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString());
            if (checkKeysAndValues) {
                String suffix = "headerKeys: []";
                if (((BatchInfo)batch$1.elem).hasKeys()) {
                    suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
                }
                if (((BatchInfo)batch$1.elem).hasValues()) {
                    suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
                }
                Assertions.assertTrue((boolean)line.endsWith(suffix), (String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString());
            }
            ++offset$1.elem;
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assertions.assertFalse((boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"), (String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString());
    }

    private static final void validate$1(String output, TopicIdPartition topicIdPartition$1) {
        String[] lines = output.split("\n");
        Assertions.assertTrue((lines.length > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("Header"))).get()).contains(topicIdPartition$1.topicIdAsBase64()));
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("SEGMENT_UPLOAD_INITIATE"))));
    }

    public static final /* synthetic */ boolean $anonfun$parseMetadataFields$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$3(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$5(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$6(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$assertDumpLogRecordMetadata$7(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$8(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toLong();
    }

    public static final /* synthetic */ short $anonfun$assertDumpLogRecordMetadata$9(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toShort();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$10(String x$14) {
        return new StringOps(Predef$.MODULE$.augmentString(x$14)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$12(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$13(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toInt();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$14(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
    }

    public static final /* synthetic */ long $anonfun$assertDumpLogRecordMetadata$15(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toLong();
    }

    public static final /* synthetic */ int $anonfun$assertDumpLogRecordMetadata$16(String x$19) {
        return new StringOps(Predef$.MODULE$.augmentString(x$19)).toInt();
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$11(DumpLogSegmentsTest $this, Iterator parsedRecordIter$1, RecordBatch batch$2, Record record) {
        Assertions.assertTrue((boolean)parsedRecordIter$1.hasNext());
        scala.collection.immutable.Map<String, String> parsedRecord = $this.parseMetadataFields((String)parsedRecordIter$1.next());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.offset())), (Object)parsedRecord.get((Object)"offset").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$12(x$15))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.keySize())), (Object)parsedRecord.get((Object)"keySize").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$13(x$16))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.valueSize())), (Object)parsedRecord.get((Object)"valueSize").map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$14(x$17))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)record.timestamp())), (Object)parsedRecord.get((Object)batch$2.timestampType().name).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$15(x$18))));
        if (batch$2.magic() >= RecordVersion.V2.value) {
            Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)record.sequence())), (Object)parsedRecord.get((Object)"sequence").map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$16(x$19))));
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"lastOffset"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"partitionLeaderEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerId"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"producerEpoch"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"baseSequence"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isTransactional"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"isControl"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)parsedRecord.get((Object)"compresscodec"));
    }

    public static final /* synthetic */ void $anonfun$assertDumpLogRecordMetadata$1(DumpLogSegmentsTest $this, ListIterator lines$2, RecordBatch batch) {
        Option<String> parsedBatchOpt = $this.readBatchMetadata(lines$2);
        Assertions.assertTrue((boolean)parsedBatchOpt.isDefined());
        scala.collection.immutable.Map<String, String> parsedBatch = $this.parseMetadataFields((String)parsedBatchOpt.get());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.baseOffset())), (Object)parsedBatch.get((Object)"baseOffset").map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$2(x$6))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.lastOffset())), (Object)parsedBatch.get((Object)"lastOffset").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$3(x$7))));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)batch.countOrNull()), (Object)parsedBatch.get((Object)"count").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$4(x$8))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.partitionLeaderEpoch())), (Object)parsedBatch.get((Object)"partitionLeaderEpoch").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$5(x$9))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional())), (Object)parsedBatch.get((Object)"isTransactional").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$6(x$10))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())), (Object)parsedBatch.get((Object)"isControl").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$7(x$11))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)parsedBatch.get((Object)"producerId").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$8(x$12))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)batch.producerEpoch())), (Object)parsedBatch.get((Object)"producerEpoch").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToShort((short)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$9(x$13))));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)batch.baseSequence())), (Object)parsedBatch.get((Object)"baseSequence").map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$10(x$14))));
        Assertions.assertEquals((Object)new Some((Object)batch.compressionType().name), (Object)parsedBatch.get((Object)"compresscodec"));
        Iterator parsedRecordIter = $this.readBatchRecords(lines$2).iterator();
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            DumpLogSegmentsTest.$anonfun$assertDumpLogRecordMetadata$11($this, parsedRecordIter, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

