/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tools.GetOffsetShell$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u000f\u001f\u0001\rBQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00036\u0011\u0019q\u0004\u0001)A\u0005m!)q\b\u0001C!\u0001\")Q\n\u0001C\u0001\u001d\")q\f\u0001C\u0001\u001d\")A\r\u0001C\u0001\u001d\")a\r\u0001C\u0001\u001d\")\u0001\u000e\u0001C\u0001\u001d\")!\u000e\u0001C\u0001\u001d\")A\u000e\u0001C\u0001\u001d\")a\u000e\u0001C\u0001\u001d\")\u0001\u000f\u0001C\u0001\u001d\")!\u000f\u0001C\u0001\u001d\")A\u000f\u0001C\u0001\u001d\")a\u000f\u0001C\u0001\u001d\")\u0001\u0010\u0001C\u0001\u001d\")!\u0010\u0001C\u0001\u001d\")A\u0010\u0001C\u0005{\"1\u0011q\u0007\u0001\u0005\nuDq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003C\u0002A\u0011BA2\u0005I9U\r^(gMN,Go\u00155fY2$Vm\u001d;\u000b\u0005}\u0001\u0013!\u0002;p_2\u001c(\"A\u0011\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d\u0002\u0013aC5oi\u0016<'/\u0019;j_:L!!\u000b\u0014\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003y\t!\u0002^8qS\u000e\u001cu.\u001e8u+\u00051\u0004CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$aA%oi\u0006YAo\u001c9jG\u000e{WO\u001c;!\u0003eygMZ:fiR{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u00025=4gm]3u)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012!\u0011\t\u0004\u0005\u0016;U\"A\"\u000b\u0005\u0011C\u0014AC2pY2,7\r^5p]&\u0011ai\u0011\u0002\u0004'\u0016\f\bC\u0001%L\u001b\u0005I%B\u0001&!\u0003\u0019\u0019XM\u001d<fe&\u0011A*\u0013\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u000ede\u0016\fG/\u001a+fgR\fe\u000eZ%oi\u0016\u0014h.\u00197U_BL7m\u001d\u000b\u0002\u001fB\u0011q\u0007U\u0005\u0003#b\u0012A!\u00168ji\"\u0012qa\u0015\t\u0003)vk\u0011!\u0016\u0006\u0003-^\u000b1!\u00199j\u0015\tA\u0016,A\u0004kkBLG/\u001a:\u000b\u0005i[\u0016!\u00026v]&$(\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_+\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002'Q,7\u000f\u001e(p\r&dG/\u001a:PaRLwN\\:)\u0005!\t\u0007C\u0001+c\u0013\t\u0019WK\u0001\u0003UKN$\u0018\u0001\u0006;fgRLe\u000e^3s]\u0006dW\t_2mk\u0012,G\r\u000b\u0002\nC\u0006\u0001B/Z:u)>\u0004\u0018n\u0019(b[\u0016\f%o\u001a\u0015\u0003\u0015\u0005\f1\u0003^3tiR{\u0007/[2QCR$XM\u001d8Be\u001eD#aC1\u0002#Q,7\u000f\u001e)beRLG/[8og\u0006\u0013x\r\u000b\u0002\rC\u0006!C/Z:u)>\u0004\u0018n\u0019)biR,'O\\!sO^KG\u000f\u001b)beRLG/[8og\u0006\u0013x\r\u000b\u0002\u000eC\u00061B/Z:u)>\u0004\u0018n\u0019)beRLG/[8og\u0006\u0013x\r\u000b\u0002\u000fC\u0006QC/Z:u)>\u0004\u0018n\u0019)beRLG/[8og\u0006\u0013xmV5uQ&sG/\u001a:oC2,\u0005p\u00197vI\u0016$\u0007FA\bb\u00039\"Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8t\u001d>$hi\\;oI\u001a{'OT8o\u000bbL7\u000f^3oiR{\u0007/[2)\u0005A\t\u0017a\r;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001chj\u001c;G_VtGMR8s\u000bb\u001cG.\u001e3fI&sG/\u001a:oC2$v\u000e]5dQ\t\t\u0012-\u0001 uKN$Hk\u001c9jGB\u000b'\u000f^5uS>t7OT8u\r>,h\u000e\u001a$pe:{g.T1uG\"Lgn\u001a+pa&\u001c\u0007+\u0019:uSRLwN\u001c)biR,'O\u001c\u0015\u0003%\u0005\fQ\u0006^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]N4E.Y4XSRDGk\u001c9jG\u001ac\u0017mZ\"bkN,W\t_5uQ\t\u0019\u0012-\u0001\u001auKN$Hk\u001c9jGB\u000b'\u000f^5uS>t7O\u00127bO^KG\u000f\u001b)beRLG/[8og\u001ac\u0017mZ\"bkN,W\t_5uQ\t!\u0012-A\u000efqB,7\r^3e\u001f\u001a47/\u001a;t/&$\b.\u00138uKJt\u0017\r\u001c\u000b\u0002}B)q0a\u0004\u0002\u00169!\u0011\u0011AA\u0006\u001d\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004E\u00051AH]8pizJ\u0011!O\u0005\u0004\u0003\u001bA\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\t\u0019B\u0001\u0003MSN$(bAA\u0007qAAq'a\u0006\u0002\u001cY\nY#C\u0002\u0002\u001aa\u0012a\u0001V;qY\u0016\u001c\u0004\u0003BA\u000f\u0003KqA!a\b\u0002\"A\u0019\u00111\u0001\u001d\n\u0007\u0005\r\u0002(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003GA\u0004#B\u001c\u0002.\u0005E\u0012bAA\u0018q\t1q\n\u001d;j_:\u00042aNA\u001a\u0013\r\t)\u0004\u000f\u0002\u0005\u0019>tw-\u0001\rfqB,7\r^3e)\u0016\u001cH\u000fV8qS\u000e|eMZ:fiN\fq#\u001a=qK\u000e$X\rZ(gMN,Go\u001d$peR{\u0007/[2\u0015\u0007y\fi\u0004\u0003\u0004\u0002@]\u0001\rAN\u0001\u0002S\u0006IAo\u001c9jG:\u000bW.\u001a\u000b\u0005\u00037\t)\u0005\u0003\u0004\u0002@a\u0001\rAN\u0001\u0014CN\u001cXM\u001d;Fq&$8i\u001c3f\u0013N|e.\u001a\u000b\u0004\u001f\u0006-\u0003bBA'3\u0001\u0007\u0011qJ\u0001\u0005CJ<7\u000fE\u00038\u0003#\nY\"C\u0002\u0002Ta\u0012Q!\u0011:sCf\fq\"\u001a=fGV$X-\u00118e!\u0006\u00148/\u001a\u000b\u0004}\u0006e\u0003bBA'5\u0001\u0007\u0011qJ\u0001\u0015Kb,7-\u001e;f\u0003:$wI]1c\u001fV$\b/\u001e;\u0015\t\u0005m\u0011q\f\u0005\b\u0003\u001bZ\u0002\u0019AA(\u0003I\tG\r\u001a\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:\u0015\t\u0005=\u0013Q\r\u0005\b\u0003\u001bb\u0002\u0019AA(\u0001")
public class GetOffsetShellTest
extends KafkaServerTestHarness {
    private final int topicCount;
    private final int offsetTopicPartitionCount;

    private int topicCount() {
        return this.topicCount;
    }

    private int offsetTopicPartitionCount() {
        return this.offsetTopicPartitionCount;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)p -> {
            p.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), BoxesRunTime.boxToInteger((int)this.offsetTopicPartitionCount()));
            return p;
        }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @BeforeEach
    public void createTestAndInternalTopics() {
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach((Function1 & Serializable & scala.Serializable)i -> this.createTopic(this.topicName(BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.unboxToInt((Object)i), this.createTopic$default$3(), this.createTopic$default$4()));
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        KafkaProducer producer = new KafkaProducer(props);
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> package$.MODULE$.Range().apply(0, i * i).foreach((Function1 & Serializable & scala.Serializable)msgCount -> producer.send(new ProducerRecord(this.topicName(i), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)msgCount) % i), null, (Object)new StringBuilder(3).append("val").append(BoxesRunTime.unboxToInt((Object)msgCount)).toString()))));
        producer.close();
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testNoFilterOptions() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Assertions.assertEquals(this.expectedOffsetsWithInternal(), offsets);
    }

    @Test
    public void testInternalExcluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--exclude-internal-topics"}));
        Assertions.assertEquals(this.expectedTestTopicOffsets(), offsets);
    }

    @Test
    public void testTopicNameArg() {
        package$.MODULE$.Range().apply(1, this.topicCount() + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic", this.topicName(i)}));
            Assertions.assertEquals(this.expectedOffsetsForTopic(i), offsets, () -> new StringBuilder(32).append("Offset output did not match for ").append(this.topicName(i)).toString());
        });
    }

    @Test
    public void testTopicPatternArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic", "topic.*"}));
        Assertions.assertEquals(this.expectedTestTopicOffsets(), offsets);
    }

    @Test
    public void testPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--partitions", "0,1"}));
        Assertions.assertEquals((Object)this.expectedOffsetsWithInternal().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$testPartitionsArg$1(x0$1))), offsets);
    }

    @Test
    public void testTopicPatternArgWithPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic", "topic.*", "--partitions", "0,1"}));
        Assertions.assertEquals((Object)this.expectedTestTopicOffsets().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$testTopicPatternArgWithPartitionsArg$1(x0$1))), offsets);
    }

    @Test
    public void testTopicPartitionsArg() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic-partitions", "topic1:0,topic2:1,topic(3|4):2,__.*:3"}));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))), (List)new .colon.colon((Object)new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), (List)new .colon.colon((Object)new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), (List)new .colon.colon((Object)new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (List)new .colon.colon((Object)new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4))), (List)Nil$.MODULE$))))), offsets);
    }

    @Test
    public void testTopicPartitionsArgWithInternalExcluded() {
        List<Tuple3<String, Object, Option<Object>>> offsets = this.executeAndParse((String[])((Object[])new String[]{"--topic-partitions", "topic1:0,topic2:1,topic(3|4):2,__.*:3", "--exclude-internal-topics"}));
        Assertions.assertEquals((Object)new .colon.colon((Object)new Tuple3((Object)"topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), (List)new .colon.colon((Object)new Tuple3((Object)"topic2", (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), (List)new .colon.colon((Object)new Tuple3((Object)"topic3", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)3))), (List)new .colon.colon((Object)new Tuple3((Object)"topic4", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)4))), (List)Nil$.MODULE$)))), offsets);
    }

    @Test
    public void testTopicPartitionsNotFoundForNonExistentTopic() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic", "some_nonexistent_topic"}));
    }

    @Test
    public void testTopicPartitionsNotFoundForExcludedInternalTopic() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic", "some_nonexistent_topic:*"}));
    }

    @Test
    public void testTopicPartitionsNotFoundForNonMatchingTopicPartitionPattern() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic-partitions", "__consumer_offsets", "--exclude-internal-topics"}));
    }

    @Test
    public void testTopicPartitionsFlagWithTopicFlagCauseExit() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic-partitions", "__consumer_offsets", "--topic", "topic1"}));
    }

    @Test
    public void testTopicPartitionsFlagWithPartitionsFlagCauseExit() {
        this.assertExitCodeIsOne((String[])((Object[])new String[]{"--topic-partitions", "__consumer_offsets", "--partitions", "0"}));
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedOffsetsWithInternal() {
        return (List)((TraversableOnce)package$.MODULE$.Range().apply(0, this.offsetTopicPartitionCount()).map((Function1 & Serializable & scala.Serializable)i -> GetOffsetShellTest.$anonfun$expectedOffsetsWithInternal$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList().$plus$plus(this.expectedTestTopicOffsets(), List$.MODULE$.canBuildFrom());
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedTestTopicOffsets() {
        return ((TraversableOnce)package$.MODULE$.Range().apply(1, this.topicCount() + 1).flatMap((Function1 & Serializable & scala.Serializable)i -> this.expectedOffsetsForTopic(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
    }

    private List<Tuple3<String, Object, Option<Object>>> expectedOffsetsForTopic(int i) {
        String name = this.topicName(i);
        return ((TraversableOnce)package$.MODULE$.Range().apply(0, i).map((Function1 & Serializable & scala.Serializable)p -> GetOffsetShellTest.$anonfun$expectedOffsetsForTopic$1(name, i, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
    }

    private String topicName(int i) {
        return new StringBuilder(5).append("topic").append(i).toString();
    }

    /*
     * WARNING - void declaration
     */
    private void assertExitCodeIsOne(String[] args) {
        void setExitProcedure_exitProcedure;
        ObjectRef exitStatus = ObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> GetOffsetShellTest.$anonfun$assertExitCodeIsOne$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            try {
                GetOffsetShell$.MODULE$.main(this.addBootstrapServer(args));
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)((Option)exitStatus.elem));
    }

    private List<Tuple3<String, Object, Option<Object>>> executeAndParse(String[] args) {
        String output = this.executeAndGrabOutput(args);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])output.split(System.lineSeparator()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShellTest.$anonfun$executeAndParse$2(x$3))))).map((Function1 & Serializable & scala.Serializable)line -> {
            String topic = line[0];
            int partition = new StringOps(Predef$.MODULE$.augmentString(line[1])).toInt();
            None$ timestamp = ((String[])line).length == 2 || line[2].isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(line[2])).toLong()));
            return new Tuple3((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partition), (Object)timestamp);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class))))).toList();
    }

    /*
     * WARNING - void declaration
     */
    private String executeAndGrabOutput(String[] args) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> GetOffsetShell$.MODULE$.main(this.addBootstrapServer(args));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private String[] addBootstrapServer(String[] args) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.brokerList()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionsArg$1(Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToInt((Object)x0$1._2()) <= 1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicPatternArgWithPartitionsArg$1(Tuple3 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = BoxesRunTime.unboxToInt((Object)x0$1._2()) <= 1;
        return bl;
    }

    public static final /* synthetic */ Tuple3 $anonfun$expectedOffsetsWithInternal$1(int i) {
        return new Tuple3((Object)"__consumer_offsets", (Object)BoxesRunTime.boxToInteger((int)i), (Object)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
    }

    public static final /* synthetic */ Tuple3 $anonfun$expectedOffsetsForTopic$1(String name$1, int i$3, int p) {
        return new Tuple3((Object)name$1, (Object)BoxesRunTime.boxToInteger((int)p), (Object)new Some((Object)BoxesRunTime.boxToLong((long)i$3)));
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertExitCodeIsOne$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)status));
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$executeAndParse$2(String[] x$3) {
        return x$3.length >= 2;
    }

    public GetOffsetShellTest() {
        this.topicCount = 4;
        this.offsetTopicPartitionCount = 4;
    }
}

