/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.admin.balancer;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.balancer.BrokerRemovalCommand$;
import kafka.admin.balancer.BrokerRemovalCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeBrokerRemovalsResult;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.clients.admin.RemoveBrokersResult;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u000f\u001f\u0005\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u00048\u0001\u0001\u0006I\u0001\u000e\u0005\bq\u0001\u0011\r\u0011\"\u00014\u0011\u0019I\u0004\u0001)A\u0005i!9!\b\u0001b\u0001\n\u0003\u0019\u0004BB\u001e\u0001A\u0003%A\u0007C\u0004=\u0001\t\u0007I\u0011A\u001a\t\ru\u0002\u0001\u0015!\u00035\u0011\u001dq\u0004A1A\u0005\u0002}Ba\u0001\u0013\u0001!\u0002\u0013\u0001\u0005bB%\u0001\u0005\u0004%\tA\u0013\u0005\u0007)\u0002\u0001\u000b\u0011B&\t\u000bU\u0003A\u0011\u0002,\t\u000b9\u0004A\u0011A8\t\u000by\u0004A\u0011A8\t\r\u0005\u0005\u0001\u0001\"\u0001p\u0011\u0019\t)\u0001\u0001C\u0001_\"1\u0011\u0011\u0002\u0001\u0005\u0002=Da!!\u0004\u0001\t\u0003y\u0007BBA\t\u0001\u0011\u0005q\u000e\u0003\u0004\u0002\u0016\u0001!\ta\u001c\u0005\u0007\u00033\u0001A\u0011A8\t\r\u0005u\u0001\u0001\"\u0001p\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u0014\u0001\t\u0013\ty\u0005C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\tA\"I]8lKJ\u0014V-\\8wC2\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005}\u0001\u0013\u0001\u00032bY\u0006t7-\u001a:\u000b\u0005\u0005\u0012\u0013!B1e[&t'BA\u0012%\u0003\u0015Y\u0017MZ6b\u0015\u0005)\u0013\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u0010\u0002\u0015\t\u0014xn[3s\u0013\u0012|\u0016'F\u00015!\tIS'\u0003\u00027U\t\u0019\u0011J\u001c;\u0002\u0017\t\u0014xn[3s\u0013\u0012|\u0016\u0007I\u0001\u000bEJ|7.\u001a:JI~\u0013\u0014a\u00032s_.,'/\u00133`e\u0001\n1b\u001d;beR$\u0016.\\3Ng\u0006a1\u000f^1siRKW.Z'tA\u0005\u0001B.Y:u+B$\u0017\r^3US6,Wj]\u0001\u0012Y\u0006\u001cH/\u00169eCR,G+[7f\u001bN\u0004\u0013a\u00042p_R\u001cHO]1q'\u0016\u0014h/\u001a:\u0016\u0003\u0001\u0003\"!\u0011$\u000e\u0003\tS!a\u0011#\u0002\t1\fgn\u001a\u0006\u0002\u000b\u0006!!.\u0019<b\u0013\t9%I\u0001\u0004TiJLgnZ\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<fe\u0002\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0016\u0003-\u00032\u0001T(R\u001b\u0005i%B\u0001(E\u0003\u0011)H/\u001b7\n\u0005Ak%\u0001\u0002'jgR\u0004\"!\u0011*\n\u0005M\u0013%aB%oi\u0016<WM]\u0001\u000bEJ|7.\u001a:JIN\u0004\u0013!\b:f[>4\u0018\r\\(qi&|gn]!sOVlWM\u001c;NCR\u001c\u0007.\u001a:\u0015\u0005]K\u0007c\u0001-^?6\t\u0011L\u0003\u0002[7\u00069Qn\\2lSR|'\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_3\ny\u0011I]4v[\u0016tG/T1uG\",'\u000f\u0005\u0002aO6\t\u0011M\u0003\u0002\"E*\u00111\rZ\u0001\bG2LWM\u001c;t\u0015\t\u0019SM\u0003\u0002g7\u00061\u0011\r]1dQ\u0016L!\u0001[1\u0003)I+Wn\u001c<f\u0005J|7.\u001a:t\u001fB$\u0018n\u001c8t\u0011\u0015Qg\u00021\u0001l\u0003Y)\u0007\u0010]3di\u0016$7\u000b[8vY\u0012\u001c\u0006.\u001e;e_^t\u0007CA\u0015m\u0013\ti'FA\u0004C_>dW-\u00198\u00029Q,7\u000f\u001e#fY\u0016$XM\u0011:pW\u0016\u0014\u0018j]*vG\u000e,7o\u001d4vYR\t\u0001\u000f\u0005\u0002*c&\u0011!O\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0010iB\u0011Q\u000f`\u0007\u0002m*\u0011q\u000f_\u0001\u0004CBL'BA={\u0003\u001dQW\u000f]5uKJT!a_.\u0002\u000b),h.\u001b;\n\u0005u4(\u0001\u0002+fgR\fQ\u0005^3ti\u0012+G.\u001a;f\u001bVdG/\u001b9mK\n\u0013xn[3sg&\u001b8+^2dKN\u001ch-\u001e7)\u0005A!\u0018a\u000e;fgR$U\r\\3uK6+H\u000e^5qY\u0016\u0014%o\\6feN<\u0016\u000e\u001e5O_NCW\u000f\u001e3po:4E.Y4JgN+8mY3tg\u001a,H\u000e\u000b\u0002\u0012i\u0006\u0001C/Z:u\t\u0016dW\r^3Ce>\\WM]0uQJ|wo]#yG\u0016\u0004H/[8oQ\t\u0011B/A\ruKN$H)Z:de&\u0014WM\u0011:pW\u0016\u0014(+Z7pm\u0006d\u0007FA\nu\u0003Y\"Xm\u001d;EKN\u001c'/\u001b2f\u0005J|7.\u001a:SK6|g/\u00197P]2L8\u000b[8xgRCWm\u00159fG&4\u0017.\u001a3Ce>\\WM]%eQ\t!B/A\u0019uKN$H)Z:de&\u0014WM\u0011:pW\u0016\u0014(+Z7pm\u0006d7o\u00155poN\u001c\u0006/Z2jM&,GM\u0011:pW\u0016\u0014\u0018\nZ:)\u0005U!\u0018a\u000e;fgR$Um]2sS\n,'I]8lKJ\u0014V-\\8wC2\u001c\u0006n\\<og\u0016k\u0007\u000f^=NKN\u001c\u0018mZ3P]:{'/Z7pm\u0006d7\u000f\u000b\u0002\u0017i\u0006yA/Z:u\u0005\u0006$7i\\7nC:$7\u000f\u000b\u0002\u0018i\u00069B/Z:u\u001b&\u001c8/\u001b8h%\u0016\fX/\u001b:fI\u0006\u0013xm\u001d\u0015\u00031Q\f!B];o\u0007>lW.\u00198e)\u0019\t)#!\u000f\u0002DA!\u0011qEA\u001b\u001d\u0011\tI#!\r\u0011\u0007\u0005-\"&\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019DK\u0001\u0007!J,G-\u001a4\n\u0007\u001d\u000b9DC\u0002\u00024)Bq!a\u000f\u001a\u0001\u0004\ti$\u0001\u0003be\u001e\u001c\b#B\u0015\u0002@\u0005\u0015\u0012bAA!U\t)\u0011I\u001d:bs\"9\u0011QI\rA\u0002\u0005\u001d\u0013aD7pG.\fE-\\5o\u00072LWM\u001c;\u0011\u0007\u0001\fI%C\u0002\u0002L\u0005\u0014abQ8oM2,XM\u001c;BI6Lg.A\bce>\\WM]*vEN$(/\u001b8h)\u0011\t)#!\u0015\t\r\u0005M#\u00041\u00015\u0003!\u0011'o\\6fe&#\u0017AG:ikR$wn\u001e8TG\",G-\u001e7fIN+(m\u0015;sS:<G\u0003BA\u0013\u00033Ba!a\u0017\u001c\u0001\u0004Y\u0017!E:ikR$wn\u001e8TG\",G-\u001e7fI\u0006q1m\\;oiN+(m\u001d;sS:<G#\u0002\u001b\u0002b\u0005\u0015\u0004bBA29\u0001\u0007\u0011QE\u0001\u0004gR\u0014\bbBA49\u0001\u0007\u0011QE\u0001\u0007gV\u00147\u000b\u001e:")
public final class BrokerRemovalCommandTest {
    private final int brokerId_1;
    private final int brokerId_2;
    private final int startTimeMs;
    private final int lastUpdateTimeMs;
    private final String bootstrapServer;
    private final java.util.List<Integer> brokerIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)this.brokerId_1()), (List)Nil$.MODULE$)).asJava();

    public int brokerId_1() {
        return this.brokerId_1;
    }

    public int brokerId_2() {
        return this.brokerId_2;
    }

    public int startTimeMs() {
        return this.startTimeMs;
    }

    public int lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public String bootstrapServer() {
        return this.bootstrapServer;
    }

    public java.util.List<Integer> brokerIds() {
        return this.brokerIds;
    }

    private ArgumentMatcher<RemoveBrokersOptions> removalOptionsArgumentMatcher(boolean expectedShouldShutdown) {
        return new ArgumentMatcher<RemoveBrokersOptions>(null, expectedShouldShutdown){
            private final boolean expectedShouldShutdown$1;

            public boolean matches(RemoveBrokersOptions options) {
                return options.shouldShutdownBrokers() == this.expectedShouldShutdown$1;
            }
            {
                this.expectedShouldShutdown$1 = expectedShouldShutdown$1;
            }
        };
    }

    @Test
    public void testDeleteBrokerIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        boolean expectedShouldShutdown = true;
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn(this.brokerIds());
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)))).thenReturn((Object)removeBrokersResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-id", Integer.toString(this.brokerId_1())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq(this.brokerIds()), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(10).append("brokers [").append(this.brokerId_1()).append("]").toString()), (String)new StringBuilder(40).append("Output should contain broker ").append(this.brokerId_1()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteMultipleBrokersIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        boolean expectedShouldShutdown = true;
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        java.util.List brokerIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId_1(), this.brokerId_2()})).map((Function1 & Serializable & scala.Serializable)x -> BrokerRemovalCommandTest.$anonfun$testDeleteMultipleBrokersIsSuccessful$1(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava();
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn((Object)brokerIds);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)))).thenReturn((Object)removeBrokersResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-ids", "0 , 1"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq((Object)brokerIds), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(12).append("brokers [").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append("]").toString()), (String)new StringBuilder(43).append("Output should contain brokers ").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        boolean expectedShouldShutdown = false;
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)))).thenReturn((Object)removeBrokersResult);
        java.util.List brokerIds = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId_1(), this.brokerId_2()})).map((Function1 & Serializable & scala.Serializable)x -> BrokerRemovalCommandTest.$anonfun$testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful$1(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava();
        Mockito.when((Object)deleteBrokerResult.get()).thenReturn((Object)brokerIds);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-ids", "0 , 1", "--no-shutdown"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).removeBrokers((java.util.List)ArgumentMatchers.eq((Object)brokerIds), (RemoveBrokersOptions)ArgumentMatchers.argThat(this.removalOptionsArgumentMatcher(expectedShouldShutdown)));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(12).append("brokers [").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append("]").toString()), (String)new StringBuilder(43).append("Output should contain brokers ").append(this.brokerId_1()).append(", ").append(this.brokerId_2()).append(". Output - ").append(output).toString());
    }

    @Test
    public void testDeleteBroker_throwsException() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        RemoveBrokersResult removeBrokersResult = (RemoveBrokersResult)Mockito.mock(RemoveBrokersResult.class);
        KafkaFutureImpl deleteBrokerResult = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)deleteBrokerResult.get()).thenThrow(BrokerRemovalInProgressException.class);
        Mockito.when((Object)removeBrokersResult.all()).thenReturn((Object)deleteBrokerResult);
        Mockito.when((Object)admin.removeBrokers(ArgumentMatchers.anyList(), (RemoveBrokersOptions)ArgumentMatchers.any(RemoveBrokersOptions.class))).thenReturn((Object)removeBrokersResult);
        Assertions.assertThrows(AdminCommandFailedException.class, () -> this.runCommand((String[])((Object[])new String[]{"--delete", "--broker-id", Integer.toString(this.brokerId_1())}), admin), () -> new StringBuilder(32).append("Broker ").append(this.brokerId_1()).append(" is already being removed").toString());
    }

    @Test
    public void testDescribeBrokerRemoval() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.INSUFFICIENT_REBALANCE_PLAN_METRICS, "Cannot compute plan!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerReplicaExclusionStatus.ERROR, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.IN_PROGRESS, BrokerReplicaExclusionStatus.ERROR, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(33).append("Output should contain ").append(this.brokerSubstring(this.brokerId_1())).append(". Output - ").append(output).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(33).append("Output should contain ").append(this.brokerSubstring(this.brokerId_2())).append(". Output - ").append(output).toString());
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BrokerShutdownStatus.COMPLETED.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, PartitionReassignmentsStatus.IN_PROGRESS.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, BrokerReplicaExclusionStatus.ERROR.toString()));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.startTimeMs())));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, ClientUtils.utcDateFor((long)this.lastUpdateTimeMs())));
        Assertions.assertEquals((int)2, (int)this.countSubstring(output, opError.errorMessage()), (String)output);
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the correct general operation status");
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(true)), (String)"Output should contain the shutdown scheduled flag");
    }

    @Test
    public void testDescribeBrokerRemovalOnlyShowsTheSpecifiedBrokerId() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, Optional.empty(), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-id", Integer.toString(this.brokerId_1())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(22).append("Output should contain ").append(this.brokerId_1()).toString());
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(25).append("Output shouldn't contain ").append(this.brokerSubstring(this.brokerId_2())).toString());
        Assertions.assertFalse((boolean)output.contains(opError.errorMessage()), (String)"Output shouldn't contain the operation error for other brokers");
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.COMPLETED.toString()), (String)"Output should contain the shutdown sub task status");
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the general status SUCCESS");
    }

    @Test
    public void testDescribeBrokerRemovalsShowsSpecifiedBrokerIds() {
        BrokerRemovalError opError = new BrokerRemovalError(Errors.BALANCER_OPERATION_OVERRIDDEN, "Removal request came in!");
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_1()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_1()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, Optional.empty(), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.FAILED, BrokerShutdownStatus.ERROR, PartitionReassignmentsStatus.ERROR, BrokerReplicaExclusionStatus.CANCELED, true, Optional.of(opError), (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-ids", "0 , 1"}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_1())), (String)new StringBuilder(22).append("Output should contain ").append(this.brokerId_1()).toString());
        Assertions.assertTrue((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(22).append("Output should contain ").append(this.brokerId_2()).toString());
        Assertions.assertTrue((boolean)output.contains(opError.errorMessage()), (String)"Output should contain the operation error for specified brokers");
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.COMPLETED.toString()), (String)"Output should contain the shutdown sub task status COMPLETED");
        Assertions.assertTrue((boolean)output.contains(PartitionReassignmentsStatus.COMPLETED.toString()), (String)"Output should contain the partition reassignment sub task status COMPLETED");
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.SUCCESS.toString()), (String)"Output should contain the general status SUCCESS");
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(false)), (String)"Output should contain the shutdown scheduled flag");
        Assertions.assertTrue((boolean)output.contains(BrokerShutdownStatus.ERROR.toString()), (String)"Output should contain the shutdown sub task status ERROR");
        Assertions.assertTrue((boolean)output.contains(PartitionReassignmentsStatus.ERROR.toString()), (String)"Output should contain the partition reassignment sub task status ERROR");
        Assertions.assertTrue((boolean)output.contains(BalancerOperationStatus.FAILED.toString()), (String)"Output should contain the general status FAILED");
        Assertions.assertTrue((boolean)output.contains(this.shutdownScheduledSubString(true)), (String)"Output should contain the shutdown scheduled flag");
    }

    @Test
    public void testDescribeBrokerRemovalShownsEmptyMessageOnNoremovals() {
        ConfluentAdmin admin = (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
        DescribeBrokerRemovalsResult describeBrokerRemovalsResult = (DescribeBrokerRemovalsResult)Mockito.mock(DescribeBrokerRemovalsResult.class);
        KafkaFutureImpl brokerRemovalResults = (KafkaFutureImpl)Mockito.mock(KafkaFutureImpl.class);
        Mockito.when((Object)describeBrokerRemovalsResult.descriptions()).thenReturn((Object)brokerRemovalResults);
        HashMap<Integer, BrokerRemovalDescription> removalResult = new HashMap<Integer, BrokerRemovalDescription>();
        removalResult.put(Predef$.MODULE$.int2Integer(this.brokerId_2()), new BrokerRemovalDescription(Predef$.MODULE$.int2Integer(this.brokerId_2()), BalancerOperationStatus.SUCCESS, BrokerShutdownStatus.COMPLETED, PartitionReassignmentsStatus.COMPLETED, BrokerReplicaExclusionStatus.COMPLETED, false, null, (long)this.startTimeMs(), (long)this.lastUpdateTimeMs()));
        Mockito.when((Object)brokerRemovalResults.get()).thenReturn(removalResult);
        Mockito.when((Object)admin.describeBrokerRemovals()).thenReturn((Object)describeBrokerRemovalsResult);
        String output = this.runCommand((String[])((Object[])new String[]{"--describe", "--broker-id", Integer.toString(this.brokerId_1())}), admin);
        ((ConfluentAdmin)Mockito.verify((Object)admin)).describeBrokerRemovals();
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(42).append("No broker removals in progress for broker ").append(this.brokerId_1()).toString()), (String)"Error message should be shown");
        Assertions.assertFalse((boolean)output.contains(this.brokerSubstring(this.brokerId_2())), (String)new StringBuilder(25).append("Output shouldn't contain ").append(this.brokerSubstring(this.brokerId_2())).toString());
    }

    @Test
    public void testBadCommands() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--not-a-command"})).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--describe"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--broker-id", "1", "--broker-ids", "1, 2, 3"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--broker-id", "1", "--broker-ids", "1, 2, 3"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--describe"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new BrokerRemovalCommandOptions((String[])((Object[])new String[]{"--broker-id", Integer.toString(this.brokerId_1()), "--delete"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BrokerRemovalCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
    }

    /*
     * WARNING - void declaration
     */
    public String runCommand(String[] args, ConfluentAdmin mockAdminClient) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> BrokerRemovalCommand$.MODULE$.run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServer()})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), (Option)new Some((Object)mockAdminClient));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private String brokerSubstring(int brokerId) {
        return new StringBuilder(7).append("Broker ").append(brokerId).toString();
    }

    private String shutdownScheduledSubString(boolean shutdownScheduled) {
        return new StringBuilder(20).append("Shutdown Scheduled: ").append(shutdownScheduled).toString();
    }

    private int countSubstring(String str, String subStr) {
        return new StringOps(Predef$.MODULE$.augmentString(subStr)).r().findAllMatchIn((CharSequence)str).length();
    }

    public static final /* synthetic */ Integer $anonfun$testDeleteMultipleBrokersIsSuccessful$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testDeleteMultipleBrokersWithNoShutdownFlagIsSuccessful$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public BrokerRemovalCommandTest() {
        this.brokerId_1 = 0;
        this.brokerId_2 = 1;
        this.startTimeMs = 1000101;
        this.lastUpdateTimeMs = 11313215;
        this.bootstrapServer = "localhost:9092";
    }
}

