/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.controller;

import integration.kafka.server.TestDataBalancer;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.common.AliveBrokersSnapshot;
import kafka.common.BrokerRemovalRequest;
import kafka.controller.DataBalanceManager;
import kafka.controller.DataBalanceManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i2Aa\u0002\u0005\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u00017!)a\u0006\u0001C\u00017!)\u0001\u0007\u0001C\u00017!)!\u0007\u0001C\u0005g\t1B)\u0019;b\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\n\u0015\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005-a\u0011!B6bM.\f'\"A\u0007\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003!\tq\u0004^3ti\u0012\u000bG/\u0019\"bY\u0006t7-\u001a:De\u0016\fG/[8o'V\u001c7-Z:t)\u0005a\u0002CA\t\u001e\u0013\tq\"C\u0001\u0003V]&$\bF\u0001\u0002!!\t\t#&D\u0001#\u0015\t\u0019C%A\u0002ba&T!!\n\u0014\u0002\u000f),\b/\u001b;fe*\u0011q\u0005K\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002S\u0005\u0019qN]4\n\u0005-\u0012#\u0001\u0002+fgR\fQ\b^3ti\u0012\u000bG/\u0019\"bY\u0006t7-\u001a:DY\u0006\u001c8\u000fT8bI\u001a\u000b\u0017\u000e\\;sKJ+G/\u001e:og\u0016C\b/Z2uK\u0012\u0014\u0015\r\\1oG\u0016\u00148\u000b^1ukND#a\u0001\u0011\u0002'R,7\u000f\u001e#bi\u0006\u0014\u0015\r\\1oG\u0016\u00148\t\\1tg2{\u0017\r\u001a$bS2,(/\u001a*fiV\u0014hn]#ya\u0016\u001cG/\u001a3Fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\'fi\"|Gm]\"bY2,GMQ=LC\u001a\\\u0017-\u00119jQ\t!\u0001%A%uKN$H)\u0019;b\u0005\u0006d\u0017M\\2fe\u000ec\u0017m]:M_\u0006$g)Y5mkJ,'+Z:vYR\u001c\u0018J\u001c(p\u001fB4%o\\7D_:$(o\u001c7mKJLeN^8lK\u0012lU\r\u001e5pIND#!\u0002\u0011\u0002=%tg/\u00197jI\u0012\u000bG/\u0019\"bY\u0006t7-Z'b]\u0006<WM]\"mCN\u001cH#\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005%9$\"A\u0006\n\u0005e2$A\u0005#bi\u0006\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\u0004")
public class DataBalanceManagerTest {
    @Test
    public void testDataBalancerCreationSuccess() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2081", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("confluent.balancer.class", TestDataBalancer.class.getCanonicalName());
        DataBalanceManager dataBalanceManager = DataBalanceManager$.MODULE$.apply(KafkaConfig$.MODULE$.fromProps(config));
        Assertions.assertEquals((Object)new TestDataBalancer().balancerStatus(), (Object)dataBalanceManager.balancerStatus());
    }

    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedBalancerStatus() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManagerClass();
        Assertions.assertEquals((Object)BalancerStatus.LOAD_FAILURE, (Object)dataBalanceManager.balancerStatus().balancerStatus());
    }

    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManagerClass();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataBalanceManager.scheduleBrokerRemoval(new BrokerRemovalRequest((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})).map((Function1 & Serializable & scala.Serializable)x -> DataBalanceManagerTest.$anonfun$testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi$2(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava(), Collections.emptyList(), Predef$.MODULE$.boolean2Boolean(true)), AliveBrokersSnapshot.EMPTY_SNAPSHOT), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> dataBalanceManager.brokerRemovals(), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> dataBalanceManager.brokerAdditions(), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> dataBalanceManager.evenClusterLoadStatus(), ClassTag$.MODULE$.apply(BalancerLoadError.class), new Position("DataBalanceManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
    }

    @Test
    public void testDataBalancerClassLoadFailureResultsInNoOpFromControllerInvokedMethods() {
        DataBalanceManager dataBalanceManager = this.invalidDataBalanceManagerClass();
        dataBalanceManager.onElection(new AliveBrokersSnapshot((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)2L))}))).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)1)}))).asJava()));
        dataBalanceManager.onResignation();
        dataBalanceManager.shutdown();
        dataBalanceManager.updateConfig((KafkaConfig)Mockito.mock(KafkaConfig.class), (KafkaConfig)Mockito.mock(KafkaConfig.class));
        dataBalanceManager.onBrokersStartup((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava(), AliveBrokersSnapshot.EMPTY_SNAPSHOT);
        dataBalanceManager.onBrokersFailure((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)1), (List)Nil$.MODULE$).toSet()).asJava());
    }

    private DataBalanceManager invalidDataBalanceManagerClass() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2081", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("confluent.balancer.class", "InvalidClassName -- This will throw an error on instantiation");
        return DataBalanceManager$.MODULE$.apply(KafkaConfig$.MODULE$.fromProps(config));
    }

    public static final /* synthetic */ Integer $anonfun$testDataBalancerClassLoadFailureReturnsExpectedExceptionFromMethodsCalledByKafkaApi$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

