/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.durability.topic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Optional;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.OffsetChangeEvent;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.topic.DurabilityTopicMessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u000e\u001d\u0001\u0015BQ\u0001\f\u0001\u0005\u00025B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011A\u0019\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"\u0003!\u0001\u0001\u0004\u0005\t\u0015)\u00033\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!\tC\u0005O\u0001\u0001\u0007\t\u0019!C\u0001\u001f\"I\u0011\u000b\u0001a\u0001\u0002\u0003\u0006Ka\u0011\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002MC\u0011b\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001-\t\u0013i\u0003\u0001\u0019!A!B\u0013!\u0006\"C.\u0001\u0001\u0004\u0005\r\u0011\"\u0001T\u0011%a\u0006\u00011AA\u0002\u0013\u0005Q\fC\u0005`\u0001\u0001\u0007\t\u0011)Q\u0005)\"I\u0001\r\u0001a\u0001\u0002\u0004%\t!\u0019\u0005\nU\u0002\u0001\r\u00111A\u0005\u0002-D\u0011\"\u001c\u0001A\u0002\u0003\u0005\u000b\u0015\u00022\t\u00139\u0004\u0001\u0019!a\u0001\n\u0003y\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0001u\u0011%1\b\u00011A\u0001B\u0003&\u0001\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0002\n\u0001!\t\u0001\u001f\u0005\u0007\u0003'\u0001A\u0011\u0001=\t\r\u0005]\u0001\u0001\"\u0001y\u0011\u0019\tY\u0002\u0001C\u0001q\"1\u0011q\u0004\u0001\u0005\u0002aDa!a\t\u0001\t\u0003A(a\t#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;feR+7\u000f\u001e\u0006\u0003;y\tQ\u0001^8qS\u000eT!a\b\u0011\u0002\u0015\u0011,(/\u00192jY&$\u0018P\u0003\u0002\"E\u0005)1.\u00194lC*\t1%\u0001\u0003v]&$8\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001\u001d\u0003%1wN]7biR,'/F\u00013!\t\u0019t'D\u00015\u0015\tiRG\u0003\u0002 m)\t\u0011%\u0003\u00029i\tyB)\u001e:bE&d\u0017\u000e^=U_BL7-T3tg\u0006<WMR8s[\u0006$H/\u001a:\u0002\u001b\u0019|'/\\1ui\u0016\u0014x\fJ3r)\tYd\b\u0005\u0002(y%\u0011Q\b\u000b\u0002\u0005+:LG\u000fC\u0004@\u0007\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013'\u0001\u0006g_Jl\u0017\r\u001e;fe\u0002\nA\u0001\u001e9jIV\t1\t\u0005\u0002E\u00196\tQI\u0003\u0002G\u000f\u000611m\\7n_:T!!\t%\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u0016\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0005ua&$w\fJ3r)\tY\u0004\u000bC\u0004@\r\u0005\u0005\t\u0019A\"\u0002\u000bQ\u0004\u0018\u000e\u001a\u0011\u0002\u000b\u0015\u0004xn\u00195\u0016\u0003Q\u0003\"aJ+\n\u0005YC#aA%oi\u0006IQ\r]8dQ~#S-\u001d\u000b\u0003weCqaP\u0005\u0002\u0002\u0003\u0007A+\u0001\u0004fa>\u001c\u0007\u000eI\u0001\bm\u0016\u00148/[8o\u0003-1XM]:j_:|F%Z9\u0015\u0005mr\u0006bB \r\u0003\u0003\u0005\r\u0001V\u0001\tm\u0016\u00148/[8oA\u0005!!-Y8t+\u0005\u0011\u0007CA2i\u001b\u0005!'BA3g\u0003\tIwNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\tE\u0006|7o\u0018\u0013fcR\u00111\b\u001c\u0005\b\u007f=\t\t\u00111\u0001c\u0003\u0015\u0011\u0017m\\:!\u0003\t\u00018/F\u0001q!\t\u0019\u0017/\u0003\u0002sI\nY\u0001K]5oiN#(/Z1n\u0003\u0019\u00018o\u0018\u0013fcR\u00111(\u001e\u0005\b\u007fI\t\t\u00111\u0001q\u0003\r\u00018\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002w!\u0012AC\u001f\t\u0004w\u0006\u0015Q\"\u0001?\u000b\u0005ut\u0018aA1qS*\u0019q0!\u0001\u0002\u000f),\b/\u001b;fe*\u0019\u00111\u0001&\u0002\u000b),h.\u001b;\n\u0007\u0005\u001dAP\u0001\u0006CK\u001a|'/Z#bG\"\f1DZ8s[\u0006$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;UKN$\bfA\u000b\u0002\u000eA\u001910a\u0004\n\u0007\u0005EAP\u0001\u0003UKN$\u0018\u0001\b4pe6\fG\u000fR3mKR,'+Z2pe\u0012\u001cXI^3oiR+7\u000f\u001e\u0015\u0004-\u00055\u0011A\u00074pe6\fG/\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;UKN$\bfA\f\u0002\u000e\u0005Abm\u001c:nCRL5O]#ya\u0006tG-\u0012<f]R$Vm\u001d;)\u0007a\ti!\u0001\u0010g_Jl\u0017\r\u001e*fi\u0016tG/[8o\u0007\"\fgnZ3Fm\u0016tG\u000fV3ti\"\u001a\u0011$!\u0004\u0002A\u0019|'/\\1u'R\f'\u000f^(gMN,Go\u00115b]\u001e,WI^3oiR+7\u000f\u001e\u0015\u00045\u00055\u0001")
public class DurabilityTopicMessageFormatterTest {
    private DurabilityTopicMessageFormatter formatter;
    private TopicPartition tpid;
    private int epoch;
    private int version;
    private ByteArrayOutputStream baos;
    private PrintStream ps;

    public DurabilityTopicMessageFormatter formatter() {
        return this.formatter;
    }

    public void formatter_$eq(DurabilityTopicMessageFormatter x$1) {
        this.formatter = x$1;
    }

    public TopicPartition tpid() {
        return this.tpid;
    }

    public void tpid_$eq(TopicPartition x$1) {
        this.tpid = x$1;
    }

    public int epoch() {
        return this.epoch;
    }

    public void epoch_$eq(int x$1) {
        this.epoch = x$1;
    }

    public int version() {
        return this.version;
    }

    public void version_$eq(int x$1) {
        this.version = x$1;
    }

    public ByteArrayOutputStream baos() {
        return this.baos;
    }

    public void baos_$eq(ByteArrayOutputStream x$1) {
        this.baos = x$1;
    }

    public PrintStream ps() {
        return this.ps;
    }

    public void ps_$eq(PrintStream x$1) {
        this.ps = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.formatter_$eq(new DurabilityTopicMessageFormatter());
        this.tpid_$eq(new TopicPartition("test", 0));
        this.epoch_$eq(0);
        this.version_$eq(1);
        this.baos_$eq(new ByteArrayOutputStream());
        this.ps_$eq(new PrintStream(this.baos()));
    }

    @Test
    public void formatOffsetChangeEventTest() {
        OffsetChangeEvent obj = OffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 0L);
        ConsumerRecord record = new ConsumerRecord(this.tpid().topic(), this.tpid().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = this.formatter().getConsumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(20).append("OffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    @Test
    public void formatDeleteRecordsEventTest() {
        DeleteRecordsEvent obj = DeleteRecordsEvent$.MODULE$.apply(this.tpid(), 100L, this.epoch(), 100L, 0L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        ConsumerRecord record = new ConsumerRecord(this.tpid().topic(), this.tpid().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = this.formatter().getConsumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(21).append("DeleteRecordsEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    @Test
    public void formatEpochChangeEventTest() {
        EpochChangeEvent obj = EpochChangeEvent$.MODULE$.apply(this.tpid(), 50L, this.epoch(), 100L, 0L, EpochChangeEvent$.MODULE$.apply$default$6());
        ConsumerRecord record = new ConsumerRecord(this.tpid().topic(), this.tpid().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = this.formatter().getConsumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(19).append("EpochChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    @Test
    public void formatIsrExpandEventTest() {
        IsrExpandEvent obj = IsrExpandEvent$.MODULE$.apply(this.tpid(), 5, this.epoch(), 100L, 0L);
        ConsumerRecord record = new ConsumerRecord(this.tpid().topic(), this.tpid().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = this.formatter().getConsumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(17).append("IsrExpandEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    @Test
    public void formatRetentionChangeEventTest() {
        RetentionChangeEvent obj = RetentionChangeEvent$.MODULE$.apply(this.tpid(), 50L, 1000L, this.version(), this.epoch(), 100L, 0L);
        ConsumerRecord record = new ConsumerRecord(this.tpid().topic(), this.tpid().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = this.formatter().getConsumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(23).append("RetentionChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }

    @Test
    public void formatStartOffsetChangeEventTest() {
        StartOffsetChangeEvent obj = StartOffsetChangeEvent$.MODULE$.apply(this.tpid(), this.epoch(), 100L, 21L, (byte)RetentionType$.MODULE$.SizeBasedRetention().id(), 0L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        ConsumerRecord record = new ConsumerRecord(this.tpid().topic(), this.tpid().partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1, -1, (Object)obj.serializeKey(), (Object)obj.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        this.formatter().writeTo(record, this.ps());
        String metadata = this.formatter().getConsumerRecordMetadata(record);
        Assertions.assertEquals((Object)new StringBuilder(25).append("StartOffsetChangeEvent ").append(obj.toString()).append(" ").append(metadata).append("\n").toString(), (Object)this.baos().toString());
    }
}

