/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitiateShutdownRequest;
import org.apache.kafka.common.requests.InitiateShutdownResponse;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001-4A\u0001E\t\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003\"\u0003BB\u0016\u0001A\u0003%Q\u0005C\u0005\u0013\u0001\u0001\u0007\t\u0019!C\u0001Y!I\u0001\u0007\u0001a\u0001\u0002\u0004%\t!\r\u0005\no\u0001\u0001\r\u0011!Q!\n5B\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001d\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0003q\u0004\"\u0003!\u0001\u0001\u0004\u0005\t\u0015)\u0003;\u0011\u001d\t\u0005A1A\u0005\u0002\tCaa\u0014\u0001!\u0002\u0013\u0019\u0005\"\u0002)\u0001\t\u0003\n\u0006\"B0\u0001\t\u0003\n\u0006\"\u00023\u0001\t\u0003\t\u0006\"B5\u0001\t\u0003\t&AJ%oSRL\u0017\r^3TQV$Hm\\<o%\u0016\fX/Z:u\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011!cE\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005Q)\u0012!B6bM.\f'\"\u0001\f\u0002\tUt\u0017\u000e^\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1D\u0003\u0002\u00139)\tA#\u0003\u0002\u001f7\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002#\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uAU\tQ\u0006\u0005\u0002\u001b]%\u0011qf\u0007\u0002\f\u0017\u000647.Y*feZ,'/\u0001\u0006tKJ4XM]0%KF$\"AM\u001b\u0011\u0005\u0019\u001a\u0014B\u0001\u001b(\u0005\u0011)f.\u001b;\t\u000fY*\u0011\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\u0002\u000fM,'O^3sA\u0005Y!M]8lKJ,\u0005o\\2i+\u0005Q\u0004C\u0001\u0014<\u0013\tatE\u0001\u0003M_:<\u0017a\u00042s_.,'/\u00129pG\"|F%Z9\u0015\u0005Iz\u0004b\u0002\u001c\t\u0003\u0003\u0005\rAO\u0001\rEJ|7.\u001a:Fa>\u001c\u0007\u000eI\u0001\u0007KbLG/\u001a3\u0016\u0003\r\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\r\u0005$x.\\5d\u0015\tA\u0015*\u0001\u0006d_:\u001cWO\u001d:f]RT!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0019\u0006!!.\u0019<b\u0013\tqUIA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\bKbLG/\u001a3!\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0004F\u0001\u0007T!\t!V,D\u0001V\u0015\t1v+A\u0002ba&T!\u0001W-\u0002\u000f),\b/\u001b;fe*\u0011!lW\u0001\u0006UVt\u0017\u000e\u001e\u0006\u00029\u0006\u0019qN]4\n\u0005y+&A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000e\u000b\u0002\u000eCB\u0011AKY\u0005\u0003GV\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00027Q,7\u000f^%oSRL\u0017\r^3TQV$Hm\\<o%\u0016\fX/Z:uQ\tqa\r\u0005\u0002UO&\u0011\u0001.\u0016\u0002\u0005)\u0016\u001cH/A(uKN$\u0018J\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c*fcV,7\u000f\u001e*fiV\u0014hn]*uC2,'I]8lKJ,\u0005o\\2i\u000bb\u001cW\r\u001d;j_:LeM\u0011:pW\u0016\u0014X\t]8dQ&\u001b8\u000b^1mK\"\u0012qB\u001a")
public class InitiateShutdownRequestIntegrationTest
extends BaseRequestTest {
    private final int brokerCount;
    private KafkaServer server;
    private long brokerEpoch;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public void brokerEpoch_$eq(long x$1) {
        this.brokerEpoch = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((x$1, x$2) -> {
            this.exited().set(true);
            throw new Exception();
        });
        super.setUp();
        this.server_$eq((KafkaServer)this.servers().head());
        this.brokerEpoch_$eq(this.server().kafkaController().brokerEpoch());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitiateShutdownRequest() {
        InitiateShutdownRequest shutdownReq = (InitiateShutdownRequest)new InitiateShutdownRequest.Builder(this.brokerEpoch()).build();
        InitiateShutdownResponse shutdownResponse = (InitiateShutdownResponse)this.connectAndReceive((AbstractRequest)shutdownReq, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitiateShutdownResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)shutdownResponse.data().errorCode());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!InitiateShutdownRequestIntegrationTest.$anonfun$testInitiateShutdownRequest$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)InitiateShutdownRequestIntegrationTest.$anonfun$testInitiateShutdownRequest$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testInitiateShutdownRequestReturnsStaleBrokerEpochExceptionIfBrokerEpochIsStale() {
        InitiateShutdownRequest shutdownReq = (InitiateShutdownRequest)new InitiateShutdownRequest.Builder(this.brokerEpoch() - 1L).build();
        InitiateShutdownResponse shutdownResponse = (InitiateShutdownResponse)this.connectAndReceive((AbstractRequest)shutdownReq, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(InitiateShutdownResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.STALE_BROKER_EPOCH.code(), (short)shutdownResponse.data().errorCode());
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Shutdown should not have been initiated");
    }

    public static final /* synthetic */ boolean $anonfun$testInitiateShutdownRequest$1(InitiateShutdownRequestIntegrationTest $this) {
        return $this.exited().get();
    }

    public static final /* synthetic */ String $anonfun$testInitiateShutdownRequest$2() {
        return "Shutdown should have been initiated";
    }

    public InitiateShutdownRequestIntegrationTest() {
        this.brokerCount = 1;
    }
}

