/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server.link;

import kafka.server.link.AclFilter;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0005\n\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0001O!)\u0001\b\u0001C\u0001O!)!\b\u0001C\u0001O!)A\b\u0001C\u0001O!)a\b\u0001C\u0001O!)\u0001\t\u0001C\u0001O!)!\t\u0001C\u0001O!)A\t\u0001C\u0001O!)a\t\u0001C\u0001O!)\u0001\n\u0001C\u0001O!)!\n\u0001C\u0001O!)A\n\u0001C\u0001O!)a\n\u0001C\u0001O!)\u0001\u000b\u0001C\u0001O!)!\u000b\u0001C\u0001O\tY\u0011i\u00197Kg>tG+Z:u\u0015\t\u0019B#\u0001\u0003mS:\\'BA\u000b\u0017\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0003G\u0001\u0006W\u000647.\u0019\u0006\u00023\u0005!QO\\5u\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t!#\u0001\u0016uKN$X)\u001c9usN#(/\u001b8h!\u0006\u00148/Z:U_\u0016k\u0007\u000f^=BG24\u0015\u000e\u001c;feNT5o\u001c8\u0015\u0003!\u0002\"!H\u0015\n\u0005)r\"\u0001B+oSRD#A\u0001\u0017\u0011\u000552T\"\u0001\u0018\u000b\u0005=\u0002\u0014aA1qS*\u0011\u0011GM\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019D'A\u0003kk:LGOC\u00016\u0003\ry'oZ\u0005\u0003o9\u0012A\u0001V3ti\u0006)C/Z:u-\u0006d\u0017\u000eZ*ue&tw\rU1sg\u0016\u001cHk\\!dY\u001aKG\u000e^3sg*\u001bxN\u001c\u0015\u0003\u00071\nA\u0003^3ti:+H\u000e\u001c&t_:\f%oZ;nK:$\bF\u0001\u0003-\u0003]!Xm\u001d;NSN\u001c\u0018N\\4SKN|WO]2f)f\u0004X\r\u000b\u0002\u0006Y\u0005aB/Z:u\u001b&\u001c8/\u001b8h%\u0016\u001cx.\u001e:dKRK\b/\u001a,bYV,\u0007F\u0001\u0004-\u0003]!Xm\u001d;J]Z\fG.\u001b3SKN|WO]2f)f\u0004X\r\u000b\u0002\bY\u00051B/Z:u\u001b&\u001c8/\u001b8h!\u0006$H/\u001a:o)f\u0004X\r\u000b\u0002\tY\u0005YB/Z:u\u001b&\u001c8/\u001b8h!\u0006$H/\u001a:o)f\u0004XMV1mk\u0016D#!\u0003\u0017\u0002-Q,7\u000f^%om\u0006d\u0017\u000e\u001a)biR,'O\u001c+za\u0016D#A\u0003\u0017\u0002)Q,7\u000f^'jgNLgnZ(qKJ\fG/[8oQ\tYA&A\ruKN$X*[:tS:<w\n]3sCRLwN\u001c,bYV,\u0007F\u0001\u0007-\u0003Q!Xm\u001d;J]Z\fG.\u001b3Pa\u0016\u0014\u0018\r^5p]\"\u0012Q\u0002L\u0001\u001ai\u0016\u001cH/T5tg&tw\rU3s[&\u001c8/[8o)f\u0004X\r\u000b\u0002\u000fY\u0005qB/Z:u\u001b&\u001c8/\u001b8h!\u0016\u0014X.[:tS>tG+\u001f9f-\u0006dW/\u001a\u0015\u0003\u001f1\n\u0011\u0004^3ti&sg/\u00197jIB+'/\\5tg&|g\u000eV=qK\"\u0012\u0001\u0003\f")
public class AclJsonTest {
    @Test
    public void testEmptyStringParsesToEmptyAclFiltersJson() {
        Assertions.assertTrue((boolean)AclJson$.MODULE$.parse("").isEmpty());
    }

    @Test
    public void testValidStringParsesToAclFiltersJson() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        Option aclJson = AclJson$.MODULE$.parse(aclFiltersJson);
        Assertions.assertTrue((boolean)aclJson.isDefined());
        AclFilter aclFilter = (AclFilter)((AclFiltersJson)aclJson.get()).aclFilters().head();
        Assertions.assertEquals((Object)"any", (Object)aclFilter.resourceFilter().resourceType());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.resourceFilter().patternType());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.accessFilter().operation());
        Assertions.assertEquals((Object)"any", (Object)aclFilter.accessFilter().permissionType());
        Assertions.assertNull((Object)aclFilter.resourceFilter().name());
        Assertions.assertNull((Object)aclFilter.accessFilter().host());
        Assertions.assertNull((Object)aclFilter.accessFilter().principal());
    }

    @Test
    public void testNullJsonArgument() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse("{}"));
        Assertions.assertEquals((Object)"acl.filters cannot be the JSON null", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingResourceType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": { \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"resourceType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingResourceTypeValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"resourceType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidResourceType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"foo\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown resourceType: foo", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPatternType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPatternTypeValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"patternType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidPatternType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"foo\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown patternType: foo", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingOperation() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": { \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"operation field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingOperationValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"operation field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidOperation() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"foo\", \"permissionType\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown operation: foo", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPermissionType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"permissionType field may not be null.", (Object)thrown.getMessage());
    }

    @Test
    public void testMissingPermissionTypeValue() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"permissionType field may not be empty.", (Object)thrown.getMessage());
    }

    @Test
    public void testInvalidPermissionType() {
        String aclFiltersJson = "{\"aclFilters\": [{\"resourceFilter\": {\"resourceType\": \"any\", \"patternType\": \"any\"}, \"accessFilter\": {\"operation\": \"any\", \"permissionType\": \"foo\"}}]}";
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AclJson$.MODULE$.parse(aclFiltersJson));
        Assertions.assertEquals((Object)"Unknown permissionType: foo", (Object)thrown.getMessage());
    }
}

