/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import kafka.log.AbstractLog;
import kafka.server.metadata.BrokerMetadataPublisher$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4Aa\u0002\u0005\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u0006\u0001C\u0001;!)\u0001\u0007\u0001C\u0005c!)\u0011\n\u0001C\u0005\u0015\")\u0001\u000f\u0001C\u0005c\nY\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d+fgRT!!\u0003\u0006\u0002\u00115,G/\u00193bi\u0006T!a\u0003\u0007\u0002\rM,'O^3s\u0015\tia\"A\u0003lC\u001a\\\u0017MC\u0001\u0010\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005A\u0011!\u0005;fgR<U\r\u001e+pa&\u001cG)\u001a7uCR\ta\u0004\u0005\u0002\u0014?%\u0011\u0001\u0005\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0003EA\u00111\u0005L\u0007\u0002I)\u0011QEJ\u0001\u0004CBL'BA\u0014)\u0003\u001dQW\u000f]5uKJT!!\u000b\u0016\u0002\u000b),h.\u001b;\u000b\u0003-\n1a\u001c:h\u0013\tiCE\u0001\u0003UKN$\u0018!\u0006;fgR4\u0015N\u001c3TiJ\f\u0017PU3qY&\u001c\u0017m\u001d\u0015\u0003\u0007\t\nq!\\8dW2{w\rF\u00023s\u0011\u0003\"aM\u001c\u000e\u0003QR!!\u000e\u001c\u0002\u00071|wMC\u0001\u000e\u0013\tADGA\u0006BEN$(/Y2u\u0019><\u0007\"\u0002\u001e\u0005\u0001\u0004Y\u0014a\u0002;pa&\u001c\u0017\n\u001a\t\u0003y\tk\u0011!\u0010\u0006\u0003}}\naaY8n[>t'BA\u0007A\u0015\t\t%&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0007v\u0012A!V;jI\")Q\t\u0002a\u0001\r\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001\u001fH\u0013\tAUH\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0015Q|\u0007/[2J[\u0006<W\r\u0006\u0003L#J{\u0006C\u0001'P\u001b\u0005i%B\u0001(@\u0003\u0015IW.Y4f\u0013\t\u0001VJ\u0001\u0006U_BL7-S7bO\u0016DQAO\u0003A\u0002mBQaU\u0003A\u0002Q\u000bQ\u0001^8qS\u000e\u0004\"!\u0016/\u000f\u0005YS\u0006CA,\u0015\u001b\u0005A&BA-\u0011\u0003\u0019a$o\\8u}%\u00111\fF\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\)!)\u0001-\u0002a\u0001C\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\tU\u0013GmZ\u0005\u0003Gz\u00131!T1q!\t\u0019R-\u0003\u0002g)\t\u0019\u0011J\u001c;\u0011\u0007!lGM\u0004\u0002jW:\u0011qK[\u0005\u0002+%\u0011A\u000eF\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0002TKFT!\u0001\u001c\u000b\u0002\u0017Q|\u0007/[2t\u00136\fw-\u001a\u000b\u0003eV\u0004\"\u0001T:\n\u0005Ql%a\u0003+pa&\u001c7/S7bO\u0016DQA\u001e\u0004A\u0002]\fa\u0001^8qS\u000e\u001c\bc\u00015n\u0017\u0002")
public class BrokerMetadataPublisherTest {
    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        AbstractLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        AbstractLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        AbstractLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        AbstractLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        AbstractLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        AbstractLog log = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), 0, 0));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        return new TopicImage(topic, topicId, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRegistrations).asJava());
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map namesMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new TopicsImage((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)idsMap).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)namesMap).asJava(), Collections.emptyMap());
    }
}

