/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.restore.RestorePartitionOperator;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0011#\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005\u0002UBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004E\u0001\u0001\u0006Ia\u000f\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019Q\u0005\u0001)A\u0005\u000f\"91\n\u0001b\u0001\n\u0003a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011A,\t\r\u0001\u0004\u0001\u0015!\u0003Y\u0011\u001d\t\u0007A1A\u0005\u0002]CaA\u0019\u0001!\u0002\u0013A\u0006bB2\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007a\u0002\u0001\u000b\u0011B3\t\u000fE\u0004!\u0019!C\u0001e\"1q\u000f\u0001Q\u0001\nMDq\u0001\u001f\u0001C\u0002\u0013\u0005\u0011\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002>\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0001\u0002CA\b\u0001\u0001\u0006I!a\u0002\t\u0011A\u0003!\u0019!C\u0001\u0003#A\u0001\"!\u0007\u0001A\u0003%\u00111\u0003\u0005\n\u00037\u0001!\u0019!C\u0001\u0003;A\u0001\"a\u000b\u0001A\u0003%\u0011q\u0004\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\ti\u0005\u0001C\u0001\u0003_Aq!a\u0016\u0001\t\u0003\ty\u0003C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005\"CAR\u0001\t\u0007I\u0011BAS\u0011!\t9\u000b\u0001Q\u0001\n\u0005\r%!\b*fgR|'/\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$Vm\u001d;\u000b\u0005\r\"\u0013!\u0002;p_2\u001c(BA\u0013'\u0003\u0015Y\u0017MZ6b\u0015\u00059\u0013\u0001B;oSR\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001a\u0011\u0005M\u0002Q\"\u0001\u0012\u0002\u001f\rDWmY6tk6,e.\u00192mK\u0012,\u0012A\u000e\t\u0003W]J!\u0001\u000f\u0017\u0003\u000f\t{w\u000e\\3b]\u0006\t2\r[3dWN,X.\u00117h_JLG\u000f[7\u0016\u0003m\u0002\"\u0001\u0010\"\u000e\u0003uR!AP \u0002\u0011\rDWmY6tk6T!\u0001Q!\u0002\u000bU$\u0018\u000e\\:\u000b\u0003\u0015J!aQ\u001f\u0003\u0013\u0005cwm\u001c:ji\"l\u0017AE2iK\u000e\\7/^7BY\u001e|'/\u001b;i[\u0002\n\u0001c];qKJ\u0014En\\2l\u0019\u0016tw\r\u001e5\u0016\u0003\u001d\u0003\"a\u000b%\n\u0005%c#!B*i_J$\u0018!E:va\u0016\u0014(\t\\8dW2+gn\u001a;iA\u00059a-Y2u_JLX#A'\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016!B:uCR,'B\u0001*B\u0003\u0011!\u0018.\u001a:\n\u0005Q{%!\u0007+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015m\u0019;pef\f\u0001BZ1di>\u0014\u0018\u0010I\u0001\na\u0006\u0014XM\u001c;ESJ,\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000b!![8\u000b\u0003u\u000bAA[1wC&\u0011qL\u0017\u0002\u0005\r&dW-\u0001\u0006qCJ,g\u000e\u001e#je\u0002\n1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\u0005Q\u0004X#A3\u0011\u0005\u0019tW\"A4\u000b\u0005!L\u0017AB2p[6|gN\u0003\u0002&U*\u00111\u000e\\\u0001\u0007CB\f7\r[3\u000b\u00035\f1a\u001c:h\u0013\tywM\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%\u0001\u0003ua&$W#A:\u0011\u0005Q,X\"A)\n\u0005Y\f&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003\u0015!\b/\u001b3!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\t!\u0010\u0005\u0002|}6\tAP\u0003\u0002~\u0003\u000611/\u001a:wKJL!a ?\u0003)1{w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m\u0003Uawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0002\nA\u0001^5nKV\u0011\u0011q\u0001\t\u0005\u0003\u0013\tY!D\u0001@\u0013\r\tia\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fAU\u0011\u00111\u0003\t\u0004\u001d\u0006U\u0011bAA\f\u001f\n1b)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-\u0001\u0004ti\u0006$X\rI\u0001\nY><7i\u001c8gS\u001e,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nB\u0003\rawnZ\u0005\u0005\u0003S\t\u0019CA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u0005E\u0002cA\u0016\u00024%\u0019\u0011Q\u0007\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u00043\u0005e\u0002\u0003BA\u001e\u0003\u0013j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0004CBL'\u0002BA\"\u0003\u000b\nqA[;qSR,'OC\u0002\u0002H1\fQA[;oSRLA!a\u0013\u0002>\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d3po:D3AGA)!\u0011\tY$a\u0015\n\t\u0005U\u0013Q\b\u0002\n\u0003\u001a$XM]#bG\"\fa\u0003^3tiV\u0003H-\u0019;f'\u0016<W.\u001a8u'R\fG/\u001a\u0015\u00047\u0005m\u0003\u0003BA\u001e\u0003;JA!a\u0018\u0002>\t!A+Z:u\u0003a)\b\u000f\\8bI&s\u0017\u000e^1uK\u0006sGmQ8na2,G/\u001a\u000b\u000f\u0003c\t)'a\u001c\u0002\u0000\u0005%\u0015QRAI\u0011\u001d\t9\u0007\ba\u0001\u0003S\nQ!\u001a9pG\"\u00042aKA6\u0013\r\ti\u0007\f\u0002\u0004\u0013:$\bbBA99\u0001\u0007\u00111O\u0001\t_\nTWm\u0019;JIB!\u0011QOA>\u001b\t\t9HC\u0002\u0002zq\u000bA!\u001e;jY&!\u0011QPA<\u0005\u0011)V+\u0013#\t\u000f\u0005\u0005E\u00041\u0001\u0002\u0004\u0006Y1\u000f^1si>3gm]3u!\rY\u0013QQ\u0005\u0004\u0003\u000fc#\u0001\u0002'p]\u001eDq!a#\u001d\u0001\u0004\t\u0019)A\u0005f]\u0012|eMZ:fi\"9\u0011q\u0012\u000fA\u0002\u0005%\u0014\u0001B:ju\u0016Dq!a%\u001d\u0001\u0004\t\u0019)\u0001\u0007nCb$\u0016.\\3ti\u0006l\u0007/A\reK2,G/Z%oSRL\u0017\r^3B]\u0012\u001cu.\u001c9mKR,GCBA\u0019\u00033\u000bY\nC\u0004\u0002hu\u0001\r!!\u001b\t\u000f\u0005ET\u00041\u0001\u0002t\u0005\u0001r-\u001a;US\u0016\u00148\u000b^1uK\u001aKG.\u001a\u000b\u00041\u0006\u0005\u0006\"B1\u001f\u0001\u0004A\u0016!E8oK6Kg.\u001e;f\u0013:l\u0015\u000e\u001c7jgV\u0011\u00111Q\u0001\u0013_:,W*\u001b8vi\u0016Le.T5mY&\u001c\b\u0005")
public class RestoreTierPartitionStateTest {
    private final Algorithm checksumAlgorithm = this.checksumEnabled() ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    private final short superBlockLength = (short)(this.checksumEnabled() ? 512 : 0);
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled());
    private final File parentDir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final TopicPartition tp = Log$.MODULE$.parseTopicPartitionName(this.dir());
    private final TopicIdPartition tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
    private final MockTime time = new MockTime();
    private final FileTierPartitionState state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
    private final LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);
    private final long oneMinuteInMillis;

    public boolean checksumEnabled() {
        return false;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(RestoreTierPartitionStateTest.$anonfun$setup$2(this, op)));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().tierEnable()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void testUpdateSegmentState() {
        int epoch = 3;
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        long start = System.currentTimeMillis();
        LongRef timestamp = LongRef.create((long)start);
        ArrayBuffer objectIds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int endOffset = baseOffset$1.elem + numOffsetsInSegment;
            UUID objectId = UUID.randomUUID();
            objectIds.$plus$eq((Object)objectId);
            this.uploadInitateAndComplete(epoch, objectId, baseOffset$1.elem, endOffset, 100, timestamp$1.elem);
            timestamp$1.elem += this.oneMinuteInMillis();
            baseOffset$1.elem = endOffset + 1;
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.deleteInitiateAndComplete(epoch, (UUID)objectIds.apply(i)));
        this.state().close();
        RestorePartitionOperator restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis(), "");
        Assertions.assertEquals((int)4, (int)restoreOperator.totalSegments());
        Assertions.assertEquals((long)150L, (long)restoreOperator.header().startOffset());
        Assertions.assertEquals((int)2, (int)restoreOperator.segmentNumberWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)1, (int)restoreOperator.segmentNumberWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
        int updateCount = restoreOperator.restore();
        Assertions.assertEquals((int)2, (int)updateCount);
        Assertions.assertEquals((long)50L, (long)restoreOperator.header().startOffset());
        Map pathmap = (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(restoreOperator.getSegmentPathMap()).asScala();
        Assertions.assertEquals((int)2, (int)pathmap.size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)index -> pathmap.keySet().contains(objectIds.apply(index)));
        restoreOperator = new RestorePartitionOperator(this.tp(), this.getTierStateFile(this.dir()), start + this.oneMinuteInMillis(), "");
        Assertions.assertEquals((long)50L, (long)restoreOperator.header().startOffset());
        Assertions.assertEquals((int)4, (int)restoreOperator.totalSegments());
        Assertions.assertEquals((int)0, (int)restoreOperator.segmentNumberWithState(TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE));
        Assertions.assertEquals((int)3, (int)restoreOperator.segmentNumberWithState(TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE));
    }

    private void uploadInitateAndComplete(int epoch, UUID objectId, long startOffset, long endOffset, int size, long maxTimestamp) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, startOffset, endOffset, maxTimestamp, size, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void deleteInitiateAndComplete(int epoch, UUID objectId) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private File getTierStateFile(File dir) {
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                RestoreTierPartitionStateTest.$anonfun$getTierStateFile$1(object, file);
                return BoxedUnit.UNIT;
            });
            return null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (File)ex.value();
            }
            throw ex;
        }
    }

    private long oneMinuteInMillis() {
        return this.oneMinuteInMillis;
    }

    public static final /* synthetic */ String $anonfun$setup$2(RestoreTierPartitionStateTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$getTierStateFile$1(Object nonLocalReturnKey1$1, File file) {
        if (file.isFile() && Log$.MODULE$.isTierStateFile(file)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)file);
        }
    }

    public RestoreTierPartitionStateTest() {
        this.oneMinuteInMillis = 60000L;
    }
}

