/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.AdminUtils$;
import kafka.admin.ConfigCommand;
import kafka.admin.ZkSecurityMigrator$;
import kafka.common.TopicPlacement;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$QuotaConfigs$;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeUserScramCredentialsResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ScramCredentialInfo;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.clients.admin.UserScramCredentialDeletion;
import org.apache.kafka.clients.admin.UserScramCredentialUpsertion;
import org.apache.kafka.clients.admin.UserScramCredentialsDescription;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ConfigCommand$
implements kafka.common.Config {
    public static ConfigCommand$ MODULE$;
    private final String BrokerDefaultEntityName;
    private final String BrokerLoggerConfigType;
    private final Seq<String> BrokerSupportedConfigTypes;
    private final Seq<String> ZkSupportedConfigTypes;
    private final int DefaultScramIterations;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value) {
        kafka.common.Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String BrokerDefaultEntityName() {
        return this.BrokerDefaultEntityName;
    }

    public String BrokerLoggerConfigType() {
        return this.BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return this.BrokerSupportedConfigTypes;
    }

    public Seq<String> ZkSupportedConfigTypes() {
        return this.ZkSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user, broker, ip, or cluster link.");
            opts.checkArgs();
            if (!opts.options().has(opts.zkConnectOpt())) {
                this.processCommand(opts);
                return;
            }
            Predef$.MODULE$.println((Object)"Warning: --zookeeper is deprecated and will be removed in a future version of Kafka.");
            Predef$.MODULE$.println((Object)"Use --bootstrap-server instead to specify a broker to connect to.");
            this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException);
            if (bl) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw null;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        ZKClientConfig zkClientConfig = (ZKClientConfig)ZkSecurityMigrator$.MODULE$.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ZKClientConfig());
        boolean x$2 = JaasUtils.isZkSaslEnabled() || KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
        int x$3 = 30000;
        int x$4 = 30000;
        int x$5 = Integer.MAX_VALUE;
        Time x$6 = Time.SYSTEM;
        String x$8 = "ConfigCommand";
        String x$9 = KafkaZkClient$.MODULE$.apply$default$9();
        String x$10 = KafkaZkClient$.MODULE$.apply$default$10();
        boolean x$11 = KafkaZkClient$.MODULE$.apply$default$11();
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, x$2, x$3, x$4, x$5, x$6, x$8, zkClientConfig, x$9, x$10, x$11);
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfigWithZk(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfigWithZk(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    public void alterConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String errorMessage = new StringBuilder(81).append("--bootstrap-server option must be specified to update ").append(entityType).append(" configs: {add: ").append(configsToBeAdded).append(", delete: ").append(configsToBeDeleted).append("}").toString();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (!configsToBeAdded.isEmpty() || !configsToBeDeleted.isEmpty()) {
                String info = "User configuration updates using ZooKeeper are only supported for SCRAM credential updates.";
                String[] scramMechanismNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.apache.kafka.common.security.scram.internals.ScramMechanism.values())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.mechanismName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                Predef$.MODULE$.require(((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(configsToBeAdded.stringPropertyNames()).asScala()).forall(arg_0 -> ConfigCommand$.$anonfun$alterConfigWithZk$2$adapted(Predef$.MODULE$.refArrayOps((Object[])scramMechanismNames), arg_0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(". ").append(info).toString());
                Predef$.MODULE$.require(configsToBeDeleted.forall(arg_0 -> ConfigCommand$.$anonfun$alterConfigWithZk$4$adapted(Predef$.MODULE$.refArrayOps((Object[])scramMechanismNames), arg_0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(". ").append(info).toString());
            }
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                if (!configsToBeAdded.isEmpty() || !configsToBeDeleted.isEmpty()) {
                    this.validateBrokersNotRunning(entityName, adminZkClient, zkClient, errorMessage);
                    String string5 = entityName;
                    String string6 = ConfigEntityName$.MODULE$.Default();
                    boolean perBrokerConfig = string5 == null ? string6 != null : !string5.equals(string6);
                    this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
                }
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$2)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$3 -> configs.remove(x$3));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed updating config for entity: ").append(entity).append(".").toString());
    }

    private void validateBrokersNotRunning(String entityName, AdminZkClient adminZkClient, KafkaZkClient zkClient, String errorMessage) {
        String string = entityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        boolean perBrokerConfig = string == null ? string2 != null : !string.equals(string2);
        String info = "Broker configuration operations using ZooKeeper are only supported if the affected broker(s) are not running.";
        if (perBrokerConfig) {
            adminZkClient.parseBroker(entityName).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Predef$.MODULE$.require(zkClient.getBroker(brokerId).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append(errorMessage).append(" - broker ").append(brokerId).append(" is running. ").append(info).toString()));
            return;
        }
        int runningBrokersCount = zkClient.getAllBrokersInCluster().size();
        Predef$.MODULE$.require(runningBrokersCount == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append(errorMessage).append(" - ").append(runningBrokersCount).append(" brokers are running. ").append(info).toString());
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.apache.kafka.common.security.scram.internals.ScramMechanism.values())).foreach((Function1 & Serializable & scala.Serializable)mechanism -> {
            String string = configsToBeAdded.getProperty(mechanism.mechanismName());
            Object object = string == null ? BoxedUnit.UNIT : configsToBeAdded.setProperty(mechanism.mechanismName(), this.scramCredential$1((org.apache.kafka.common.security.scram.internals.ScramMechanism)mechanism, string));
            return object;
        });
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Password encoder secret not specified");
        });
        return new PasswordEncoder(new Password(encoderSecret), (Option<String>)None$.MODULE$, (String)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Defaults$.MODULE$.PasswordEncoderCipherAlgorithm()), BoxesRunTime.unboxToInt((Object)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Defaults$.MODULE$.PasswordEncoderKeyLength())), BoxesRunTime.unboxToInt((Object)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Defaults$.MODULE$.PasswordEncoderIterations())));
    }

    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        Implicits$.MODULE$.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
        if (!passwordEncoderConfigs.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ConfigCommand$.$anonfun$preProcessBrokerConfigs$2(passwordEncoderConfigs)));
            }
            ((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> configsToBeAdded.remove(x$1));
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
        if (passwordConfigs.nonEmpty()) {
            Predef$.MODULE$.require(passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(226).append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append(" must be specified to update ").append(passwordConfigs).append(".").append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString());
            PasswordEncoder passwordEncoder = this.createPasswordEncoder((Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()));
            passwordConfigs.foreach((Function1 & Serializable & scala.Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    public void describeConfigWithZk(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = entityType = configEntity.root().entityType();
        var7_6 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var7_6) == false : var7_6 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entityName = configEntity.fullSanitizedName();
        errorMessage = new StringBuilder(56).append("--bootstrap-server option must be specified to describe ").append(entityType).toString();
        v2 = entityType;
        var10_10 = ConfigType$.MODULE$.Broker();
        if (!(v2 != null ? v2.equals(var10_10) == false : var10_10 != null)) {
            this.validateBrokersNotRunning(entityName, adminZkClient, zkClient, errorMessage);
        }
        configEntity.getAllEntities(zkClient).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfigWithZk$1$adapted(kafka.zk.AdminZkClient boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = new Properties();
        if (opts.options().has(opts.addConfigFile())) {
            String file = (String)opts.options().valueOf(opts.addConfigFile());
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(Utils.loadProps((String)file));
        }
        if (opts.options().has(opts.addConfig())) {
            Properties parsedProps = AdminUtils$.MODULE$.parseConfigs((String)opts.options().valueOf(opts.addConfig()));
            ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(parsedProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                Object object = props.setProperty(k, v);
                return object;
            });
        }
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder(298).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker or ").append("if the inter.broker.protocol.version is 3.0 or newer. This configuration is deprecated and it will be removed in Apache Kafka 4.0.").toString());
        }
        return this.parseReplicaPlacementConfig(props, opts);
    }

    private Properties parseReplicaPlacementConfig(Properties props, ConfigCommand.ConfigCommandOptions opts) {
        if (props.containsKey("confluent.placement.constraints")) {
            throw new IllegalArgumentException(new StringBuilder(101).append("When adding the ").append("confluent.placement.constraints").append(" configuration please use the --replica-placement flag").toString());
        }
        if (opts.options().has(opts.replicaPlacementOpt())) {
            String jsonString = Utils.readFileAsString((String)((String)opts.options().valueOf(opts.replicaPlacementOpt())));
            OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse(jsonString))).foreach((Function1 & Serializable & scala.Serializable)replicaPlacement -> props.setProperty("confluent.placement.constraints", replicaPlacement.toJson()));
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.trim(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            return var2_2;
        }
        return Nil$.MODULE$;
    }

    private void processCommand(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        AdminClient adminClient = AdminClient.create((Properties)props);
        if (opts.options().has((OptionSpec)opts.alterOpt()) && opts.entityTypes().size() != opts.entityNames().size()) {
            throw new IllegalArgumentException("An entity name must be specified for every entity type");
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig((Admin)adminClient, opts);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig((Admin)adminClient, opts);
            }
        }
        finally {
            adminClient.close();
        }
    }

    public void alterConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        String entityTypeHead = (String)entityTypes.head();
        String entityNameHead = (String)entityNames.head();
        scala.collection.immutable.Map configsToBeAddedMap = ((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map configsToBeAdded = (scala.collection.immutable.Map)configsToBeAddedMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityTypeHead) : entityTypeHead != null)) {
            bl = true;
        } else {
            String string2 = ConfigType$.MODULE$.ClusterLink();
            bl = !(string2 != null ? !string2.equals(entityTypeHead) : entityTypeHead != null);
        }
        if (bl) {
            scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            String string3 = entityTypeHead;
            String string4 = ConfigType$.MODULE$.Topic();
            ConfigResource.Type resourceType = !(string3 != null ? !string3.equals(string4) : string4 != null) ? ConfigResource.Type.TOPIC : ConfigResource.Type.CLUSTER_LINK;
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
            }
            ConfigResource configResource = new ConfigResource(resourceType, entityNameHead);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
            Collection alterEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$9 -> new AlterConfigOp(x$9, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
            Void cfr_ignored_0 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string5 = ConfigType$.MODULE$.Broker();
            if (!(string5 != null ? !string5.equals(entityTypeHead) : entityTypeHead != null)) {
                scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, false, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
                if (invalidConfigs.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
                }
                scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
                scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$8(x$10)));
                if (sensitiveEntries.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
                }
                Config newConfig = new Config(((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityNameHead);
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Void cfr_ignored_1 = (Void)adminClient.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)newConfig)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                String string6 = this.BrokerLoggerConfigType();
                if (!(string6 != null ? !string6.equals(entityTypeHead) : entityTypeHead != null)) {
                    Seq validLoggers = (Seq)this.getResourceConfig(adminClient, entityTypeHead, entityNameHead, true, false).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Seq$.MODULE$.canBuildFrom());
                    Seq invalidBrokerLoggers = (Seq)((TraversableLike)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)))).$plus$plus((GenTraversableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem))), Seq$.MODULE$.canBuildFrom());
                    if (invalidBrokerLoggers.nonEmpty()) {
                        throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString(",")).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityNameHead);
                    AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                    Collection alterLogLevelEntries = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$12 -> new AlterConfigOp(x$12, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                    Void cfr_ignored_2 = (Void)adminClient.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterLogLevelEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
                } else {
                    boolean bl2;
                    String string7 = ConfigType$.MODULE$.User();
                    if (!(string7 != null ? !string7.equals(entityTypeHead) : entityTypeHead != null)) {
                        bl2 = true;
                    } else {
                        String string8 = ConfigType$.MODULE$.Client();
                        bl2 = !(string8 != null ? !string8.equals(entityTypeHead) : entityTypeHead != null);
                    }
                    if (bl2) {
                        boolean hasQuotaConfigsToAdd = configsToBeAdded.keys().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicConfig$QuotaConfigs$.MODULE$.isClientOrUserQuotaConfig(name)));
                        scala.collection.immutable.Map scramConfigsToAddMap = (scala.collection.immutable.Map)configsToBeAdded.filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$15(entry)));
                        Iterable unknownConfigsToAdd = (Iterable)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$16(key)));
                        boolean hasQuotaConfigsToDelete = configsToBeDeleted.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicConfig$QuotaConfigs$.MODULE$.isClientOrUserQuotaConfig(name)));
                        Seq scramConfigsToDelete = (Seq)configsToBeDeleted.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$18(x$1)));
                        Seq unknownConfigsToDelete = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$19(key)));
                        String string9 = entityTypeHead;
                        String string10 = ConfigType$.MODULE$.Client();
                        if (!(string9 == null ? string10 != null : !string9.equals(string10)) || entityTypes.size() == 2) {
                            if (unknownConfigsToAdd.nonEmpty() || scramConfigsToAddMap.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(90).append("Only quota configs can be added for '").append(ConfigType$.MODULE$.Client()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToAdd.$plus$plus((GenTraversableOnce)scramConfigsToAddMap.keys(), Iterable$.MODULE$.canBuildFrom())).toString());
                            }
                            if (unknownConfigsToDelete.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(92).append("Only quota configs can be deleted for '").append(ConfigType$.MODULE$.Client()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToDelete.$plus$plus((GenTraversableOnce)scramConfigsToDelete, Seq$.MODULE$.canBuildFrom())).toString());
                            }
                        } else {
                            if (unknownConfigsToAdd.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(111).append("Only quota and SCRAM credential configs can be added for '").append(ConfigType$.MODULE$.User()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToAdd).toString());
                            }
                            if (unknownConfigsToDelete.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(113).append("Only quota and SCRAM credential configs can be deleted for '").append(ConfigType$.MODULE$.User()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigsToDelete).toString());
                            }
                            if (scramConfigsToAddMap.nonEmpty() || scramConfigsToDelete.nonEmpty()) {
                                if (entityNames.exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isEmpty()))) {
                                    throw new IllegalArgumentException("The use of --entity-default or --user-defaults is not allowed with User SCRAM Credentials using --bootstrap-server.");
                                }
                                if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                                    throw new IllegalArgumentException(new StringBuilder(100).append("Cannot alter both quota and SCRAM credential configs simultaneously for '").append(ConfigType$.MODULE$.User()).append("' using --bootstrap-server.").toString());
                                }
                            }
                        }
                        if (hasQuotaConfigsToAdd || hasQuotaConfigsToDelete) {
                            this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
                        } else {
                            if (entityNames.size() != 1) {
                                throw new IllegalStateException(new StringBuilder(84).append("Altering user SCRAM credentials should never occur for more zero or multiple users: ").append(entityNames).toString());
                            }
                            this.alterUserScramCredentialConfigs(adminClient, (String)entityNames.head(), (Map<String, ConfigEntry>)scramConfigsToAddMap, (Seq<String>)scramConfigsToDelete);
                        }
                    } else {
                        String string11 = ConfigType$.MODULE$.Ip();
                        if (!(string11 != null ? !string11.equals(entityTypeHead) : entityTypeHead != null)) {
                            Iterable unknownConfigs = (Iterable)((TraversableLike)configsToBeAdded.keys().$plus$plus(configsToBeDeleted, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$21(key)));
                            if (unknownConfigs.nonEmpty()) {
                                throw new IllegalArgumentException(new StringBuilder(101).append("Only connection quota configs can be added for '").append(ConfigType$.MODULE$.Ip()).append("' using --bootstrap-server. Unexpected config names: ").append(unknownConfigs.mkString(",")).toString());
                            }
                            this.alterQuotaConfigs(adminClient, entityTypes, entityNames, (Map<String, String>)configsToBeAddedMap, configsToBeDeleted);
                        } else {
                            throw new IllegalArgumentException(new StringBuilder(25).append("Unsupported entity type: ").append(entityTypeHead).toString());
                        }
                    }
                }
            }
        }
        if (new StringOps(Predef$.MODULE$.augmentString(entityNameHead)).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(32).append("Completed updating config for ").append(new StringOps(Predef$.MODULE$.augmentString(entityTypeHead)).dropRight(1)).append(" ").append(entityNameHead).append(".").toString());
            return;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(54).append("Completed updating default config for ").append(entityTypeHead).append(" in the cluster.").toString());
    }

    private Void alterUserScramCredentialConfigs(Admin adminClient, String user, Map<String, ConfigEntry> scramConfigsToAddMap, Seq<String> scramConfigsToDelete) {
        Seq deletions = (Seq)scramConfigsToDelete.map((Function1 & Serializable & scala.Serializable)mechanismName -> new UserScramCredentialDeletion(user, ScramMechanism.fromMechanismName((String)mechanismName)), Seq$.MODULE$.canBuildFrom());
        Iterable upsertions = (Iterable)scramConfigsToAddMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var8_7;
            void var7_6;
            String mechanismName;
            if (x0$1 != null) {
                mechanismName = (String)x0$1._1();
                ConfigEntry configEntry = (ConfigEntry)x0$1._2();
                Tuple2 tuple2 = this.iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism.forMechanismName((String)mechanismName), configEntry.value());
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Integer iterations = (Integer)tuple2._1();
                byte[] passwordBytes = (byte[])tuple2._2();
            } else {
                throw new MatchError(null);
            }
            void iterations = var7_6;
            void passwordBytes = var8_7;
            UserScramCredentialUpsertion userScramCredentialUpsertion = new UserScramCredentialUpsertion(user, new ScramCredentialInfo(ScramMechanism.fromMechanismName((String)mechanismName), Predef$.MODULE$.Integer2int((Integer)iterations)), (byte[])passwordBytes);
            return userScramCredentialUpsertion;
        }, Iterable$.MODULE$.canBuildFrom());
        return (Void)adminClient.alterUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)deletions.$plus$plus((GenTraversableOnce)upsertions, Seq$.MODULE$.canBuildFrom())).toList()).asJava()).all().get(60L, TimeUnit.SECONDS);
    }

    private Void alterQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames, Map<String, String> configsToBeAddedMap, Seq<String> configsToBeDeleted) {
        Map<String, Double> oldConfig = this.getClientQuotasConfig(adminClient, entityTypes, entityNames);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        List alterEntityTypes = (List)entityTypes.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            String string2 = ConfigType$.MODULE$.User();
            if (!(string2 != null ? !string2.equals(x0$1) : x0$1 != null)) {
                string = "user";
            } else {
                String string3 = ConfigType$.MODULE$.Client();
                if (!(string3 != null ? !string3.equals(x0$1) : x0$1 != null)) {
                    string = "client-id";
                } else {
                    String string4 = ConfigType$.MODULE$.Ip();
                    if (!(string4 != null ? !string4.equals(x0$1) : x0$1 != null)) {
                        string = "ip";
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(24).append("Unexpected entity type: ").append((String)x0$1).toString());
                    }
                }
            }
            return string;
        }, List$.MODULE$.canBuildFrom());
        List alterEntityNames = (List)entityNames.map((Function1 & Serializable & scala.Serializable)en -> {
            if (new StringOps(Predef$.MODULE$.augmentString(en)).nonEmpty()) {
                return en;
            }
            return null;
        }, List$.MODULE$.canBuildFrom());
        HashMap alterEntityMap = new HashMap();
        ((List)alterEntityTypes.zip((GenIterable)alterEntityNames, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            String string = alterEntityMap.put(k, v);
            return string;
        });
        ClientQuotaEntity entity = new ClientQuotaEntity(alterEntityMap);
        AlterClientQuotasOptions alterOptions = new AlterClientQuotasOptions().validateOnly(false);
        Collection alterOps = CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAddedMap.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            double d;
            String key;
            if (x0$3 != null) {
                key = (String)x0$3._1();
                String value = (String)x0$3._2();
                try {
                    d = new StringOps(Predef$.MODULE$.augmentString(value)).toDouble();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(new StringBuilder(45).append("Cannot parse quota configuration value for ").append(key).append(": ").append(value).toString());
                }
            } else {
                throw new MatchError(null);
            }
            double doubleValue = d;
            ClientQuotaAlteration.Op op = new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(doubleValue));
            return op;
        }, Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)key -> new ClientQuotaAlteration.Op(key, null), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
        return (Void)adminClient.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(entity, alterOps)), alterOptions).all().get(60L, TimeUnit.SECONDS);
    }

    public void describeConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts) {
        boolean bl;
        boolean bl2;
        List<String> entityTypes = opts.entityTypes();
        List<String> entityNames = opts.entityNames();
        boolean describeAll = opts.options().has((OptionSpec)opts.allOpt());
        String string = (String)entityTypes.head();
        String string2 = ConfigType$.MODULE$.Topic();
        if (!(string2 != null ? !string2.equals(string) : string != null)) {
            bl2 = true;
        } else {
            String string3 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string) : string != null)) {
                bl2 = true;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(string) : string != null)) {
                    bl2 = true;
                } else {
                    String string5 = ConfigType$.MODULE$.ClusterLink();
                    bl2 = !(string5 != null ? !string5.equals(string) : string != null);
                }
            }
        }
        if (bl2) {
            this.describeResourceConfig(adminClient, (String)entityTypes.head(), (Option<String>)entityNames.headOption(), describeAll);
            return;
        }
        String string6 = ConfigType$.MODULE$.User();
        if (!(string6 != null ? !string6.equals(string) : string != null)) {
            bl = true;
        } else {
            String string7 = ConfigType$.MODULE$.Client();
            bl = !(string7 != null ? !string7.equals(string) : string != null);
        }
        if (bl) {
            this.describeClientQuotaAndUserScramCredentialConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        String string8 = ConfigType$.MODULE$.Ip();
        if (!(string8 != null ? !string8.equals(string) : string != null)) {
            this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(21).append("Invalid entity type: ").append(string).toString());
    }

    private void describeResourceConfig(Admin adminClient, String entityType, Option<String> entityName, boolean describeAll) {
        ((Seq)entityName.map((Function1 & Serializable & scala.Serializable)name -> new .colon.colon(name, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            String string = ConfigType$.MODULE$.Topic();
            if (!(string != null ? !string.equals(entityType) : entityType != null)) {
                seq = ((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)adminClient.listTopics(new ListTopicsOptions().listInternal(true)).names().get()).asScala()).toSeq();
            } else {
                boolean bl;
                String string2 = ConfigType$.MODULE$.Broker();
                if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                    bl = true;
                } else {
                    String string3 = MODULE$.BrokerLoggerConfigType();
                    bl = !(string3 != null ? !string3.equals(entityType) : entityType != null);
                }
                if (bl) {
                    seq = (Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster(new DescribeClusterOptions()).nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.idString(), Iterable$.MODULE$.canBuildFrom())).toSeq().$colon$plus((Object)MODULE$.BrokerDefaultEntityName(), Seq$.MODULE$.canBuildFrom());
                } else {
                    String string4 = ConfigType$.MODULE$.ClusterLink();
                    if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                        ConfluentAdmin confluentAdminClient = (ConfluentAdmin)adminClient;
                        seq = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)confluentAdminClient.listClusterLinks(new ListClusterLinksOptions()).result().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.linkName(), Iterable$.MODULE$.canBuildFrom())).toSeq();
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(21).append("Invalid entity type: ").append(entityType).toString());
                    }
                }
            }
            return seq;
        })).foreach((Function1 & Serializable & scala.Serializable)entity -> {
            ConfigCommand$.$anonfun$describeResourceConfig$5(entityType, describeAll, adminClient, entity);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ConfigEntry> getResourceConfig(Admin adminClient, String entityType, String entityName, boolean includeSynonyms, boolean describeAll) {
        void var7_11;
        void var6_10;
        ConfigResource.Type type;
        Some some;
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            if (!entityName.isEmpty()) {
                Topic.validate((String)entityName);
            }
            some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG);
            type = ConfigResource.Type.TOPIC;
        } else {
            String string2 = ConfigType$.MODULE$.Broker();
            if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
                ConfigResource.Type type2;
                Some some2;
                String string3 = this.BrokerDefaultEntityName();
                if (!(string3 != null ? !string3.equals(entityName) : entityName != null)) {
                    some2 = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG);
                    type2 = ConfigResource.Type.BROKER;
                } else {
                    ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    some2 = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG);
                    type2 = ConfigResource.Type.BROKER;
                }
                some = some2;
                type = type2;
            } else {
                String string4 = this.BrokerLoggerConfigType();
                if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
                    if (!entityName.isEmpty()) {
                        ConfigCommand$.validateBrokerId$1(entityName, entityType);
                    }
                    some = None$.MODULE$;
                    type = ConfigResource.Type.BROKER_LOGGER;
                } else {
                    String string5 = ConfigType$.MODULE$.ClusterLink();
                    if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
                        ClusterLinkUtils$.MODULE$.validateLinkName(entityName);
                        some = new Some((Object)ConfigEntry.ConfigSource.DYNAMIC_CLUSTER_LINK_CONFIG);
                        type = ConfigResource.Type.CLUSTER_LINK;
                    } else {
                        throw new IllegalArgumentException(new StringBuilder(21).append("Invalid entity type: ").append(entityType).toString());
                    }
                }
            }
        }
        ConfigResource.Type configResourceType = type;
        Option dynamicConfigSource = (Option)some;
        void configResourceType2 = var6_10;
        void dynamicConfigSource2 = var7_11;
        None$ configSourceFilter = describeAll ? None$.MODULE$ : dynamicConfigSource2;
        ConfigResource configResource = new ConfigResource((ConfigResource.Type)configResourceType2, entityName);
        DescribeConfigsOptions describeOptions = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOptions).all().get(30L, TimeUnit.SECONDS);
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter(arg_0 -> ConfigCommand$.$anonfun$getResourceConfig$1$adapted((Option)configSourceFilter, arg_0))).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void describeQuotaConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> quotaConfigs = this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(entity, entries) -> {
            ConfigCommand$.$anonfun$describeQuotaConfigs$1(entity, entries);
            return BoxedUnit.UNIT;
        };
        Map<ClientQuotaEntity, java.util.Map<String, Double>> map = Implicits$.MODULE$.MapExtensionMethods(quotaConfigs);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    private void describeClientQuotaAndUserScramCredentialConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        this.describeQuotaConfigs(adminClient, entityTypes, entityNames);
        if (!entityTypes.contains((Object)ConfigType$.MODULE$.Client()) && !entityNames.contains((Object)"")) {
            DescribeUserScramCredentialsResult result = adminClient.describeUserScramCredentials((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(entityNames).asJava());
            ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)result.users().get(30L, TimeUnit.SECONDS)).asScala()).foreach((Function1 & Serializable & scala.Serializable)user -> {
                ConfigCommand$.$anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(result, user);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Map<String, Double> getClientQuotasConfig(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        if (entityTypes.size() != entityNames.size()) {
            throw new IllegalArgumentException("Exactly one entity name must be specified for every entity type");
        }
        return (Map)this.getAllClientQuotasConfigs(adminClient, entityTypes, entityNames).headOption().map((Function1 & Serializable & scala.Serializable)x$19 -> (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)x$19._2()).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
    }

    private scala.collection.mutable.Map<ClientQuotaEntity, java.util.Map<String, Double>> getAllClientQuotasConfigs(Admin adminClient, List<String> entityTypes, List<String> entityNames) {
        List components = (List)((List)((IterableLike)entityTypes.map((Function1 & Serializable & scala.Serializable)x$20 -> new Some(x$20), List$.MODULE$.canBuildFrom())).zipAll((GenIterable)entityNames.map((Function1 & Serializable & scala.Serializable)x$21 -> new Some(x$21), List$.MODULE$.canBuildFrom()), (Object)None$.MODULE$, (Object)None$.MODULE$, List$.MODULE$.canBuildFrom())).map(ConfigCommand$::$anonfun$getAllClientQuotasConfigs$3, List$.MODULE$.canBuildFrom());
        return (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeClientQuotas(ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)components).asJava()))).entities().get(30L, TimeUnit.SECONDS)).asScala();
    }

    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        String string;
        List<String> entityNames;
        List<String> entityTypes;
        block3: {
            block2: {
                entityTypes = opts.entityTypes();
                entityNames = opts.entityNames();
                Object object = entityTypes.head();
                String string2 = ConfigType$.MODULE$.User();
                if (!(object == null ? string2 != null : !object.equals(string2))) break block2;
                Object object2 = entityTypes.head();
                String string3 = ConfigType$.MODULE$.Client();
                if (object2 != null ? !object2.equals(string3) : string3 != null) break block3;
            }
            return this.parseClientQuotaEntity(opts, entityTypes, entityNames);
        }
        Option option = entityNames.headOption();
        Object object = option instanceof Some && "".equals(string = (String)((Some)option).value()) ? new Some((Object)ConfigEntityName$.MODULE$.Default()) : option;
        return new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)object), (Option<ConfigCommand.Entity>)None$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseClientQuotaEntity(ConfigCommand.ConfigCommandOptions opts, List<String> types, List<String> names) {
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? types.reverse() : types;
        sortedNames = (reverse != false && names.length() == 2 ? names.reverse() : names).iterator();
        entities = (List)entityTypes.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseClientQuotaEntity$1(scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lkafka/admin/ConfigCommand$Entity;)((Iterator)sortedNames), List$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$2(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfigWithZk$4(Object[] eta$0$2$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$2$1).contains(elem);
    }

    /*
     * WARNING - void declaration
     */
    private final String scramCredential$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        void var5_5;
        Option option = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)")).r().unapplySeq((CharSequence)credentialStr);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
        String password = (String)((LinearSeqOptimized)option.get()).apply(1);
        int n = iterations != null ? new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt() : this.DefaultScramIterations();
        if (n < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(n).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        return ScramCredentialUtils.credentialToString((ScramCredential)new ScramFormatter(mechanism).generateCredential((String)var5_5, n));
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$3(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$5(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((String)x0$1._1()).startsWith("password.encoder.");
        return bl;
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$2(Properties passwordEncoderConfigs$1) {
        return new StringBuilder(101).append("Password encoder configs ").append(passwordEncoderConfigs$1.keySet()).append(" will be used for encrypting").append(" passwords, but will not be stored in ZooKeeper.").toString();
    }

    public static final /* synthetic */ void $anonfun$describeConfigWithZk$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
        if (!configs.isEmpty() || !describeAllUsers$1) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Configs for %s are %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$8(Tuple2 x$10) {
        return ((ConfigEntry)x$10._2()).value() == null;
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$15(Tuple2 entry) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)((String)entry._1()));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$16(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || DynamicConfig$QuotaConfigs$.MODULE$.isClientOrUserQuotaConfig(key);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$18(String x$1) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$19(String key) {
        return org.apache.kafka.common.security.scram.internals.ScramMechanism.isScram((String)key) || DynamicConfig$QuotaConfigs$.MODULE$.isClientOrUserQuotaConfig(key);
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$21(String key) {
        return DynamicConfig$Ip$.MODULE$.names().contains(key);
    }

    /*
     * WARNING - void declaration
     */
    private final Tuple2 iterationsAndPasswordBytes$1(org.apache.kafka.common.security.scram.internals.ScramMechanism mechanism, String credentialStr) {
        void var5_5;
        Option option = new StringOps(Predef$.MODULE$.augmentString("(?:iterations=(\\-?[0-9]*),)?password=(.*)")).r().unapplySeq((CharSequence)credentialStr);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
        String password = (String)((LinearSeqOptimized)option.get()).apply(1);
        int n = iterations != null && !iterations.equals("-1") ? new StringOps(Predef$.MODULE$.augmentString(iterations)).toInt() : this.DefaultScramIterations();
        if (n < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(n).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism.mechanismName()).toString());
        }
        return new Tuple2((Object)Predef$.MODULE$.int2Integer(n), (Object)var5_5.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$6(ConfigEntry entry) {
        String synonyms = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(entry.synonyms()).asScala()).map((Function1 & Serializable & scala.Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("  ").append(entry.name()).append("=").append(entry.value()).append(" sensitive=").append(entry.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString());
    }

    public static final /* synthetic */ void $anonfun$describeResourceConfig$5(String entityType$1, boolean describeAll$1, Admin adminClient$1, String entity) {
        String string = MODULE$.BrokerDefaultEntityName();
        if (!(string != null ? !string.equals(entity) : entity != null)) {
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("Default configs for ").append(entityType$1).append(" in the cluster are:").toString());
        } else {
            String configSourceStr = describeAll$1 ? "All" : "Dynamic";
            Predef$.MODULE$.println((Object)new StringBuilder(19).append(configSourceStr).append(" configs for ").append(new StringOps(Predef$.MODULE$.augmentString(entityType$1)).dropRight(1)).append(" ").append(entity).append(" are:").toString());
        }
        MODULE$.getResourceConfig(adminClient$1, entityType$1, entity, true, describeAll$1).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ConfigCommand$.$anonfun$describeResourceConfig$6(entry);
            return BoxedUnit.UNIT;
        });
    }

    private static final void validateBrokerId$1(String entityName$1, String entityType$2) {
        try {
            new StringOps(Predef$.MODULE$.augmentString(entityName$1)).toInt();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(63).append("The entity name for ").append(entityType$2).append(" must be a valid integer broker id, found: ").append(entityName$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getResourceConfig$1(Option configSourceFilter$1, ConfigEntry entry) {
        boolean bl;
        if (configSourceFilter$1 instanceof Some) {
            ConfigEntry.ConfigSource configSource = (ConfigEntry.ConfigSource)((Some)configSourceFilter$1).value();
            ConfigEntry.ConfigSource configSource2 = entry.source();
            bl = !(configSource2 != null ? !configSource2.equals(configSource) : configSource != null);
        } else if (None$.MODULE$.equals(configSourceFilter$1)) {
            bl = true;
        } else {
            throw new MatchError((Object)configSourceFilter$1);
        }
        return bl;
    }

    private static final Option entitySubstr$1(String entityType, scala.collection.mutable.Map entityEntries$1) {
        return entityEntries$1.get((Object)entityType).map((Function1 & Serializable & scala.Serializable)name -> {
            String string;
            if ("user".equals(entityType)) {
                string = "user-principal";
            } else if ("client-id".equals(entityType)) {
                string = "client-id";
            } else if ("ip".equals(entityType)) {
                string = "ip";
            } else {
                throw new MatchError((Object)entityType);
            }
            if (name != null) {
                return new StringBuilder(3).append(string).append(" '").append((String)name).append("'").toString();
            }
            return new StringBuilder(12).append("the default ").append(string).toString();
        });
    }

    public static final /* synthetic */ void $anonfun$describeQuotaConfigs$1(ClientQuotaEntity entity, java.util.Map entries) {
        scala.collection.mutable.Map entityEntries = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entity.entries()).asScala();
        String entityStr = ((TraversableOnce)((TraversableLike)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("user", entityEntries)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("client-id", entityEntries)), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(ConfigCommand$.entitySubstr$1("ip", entityEntries)), Iterable$.MODULE$.canBuildFrom())).mkString(", ");
        String entriesStr = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(entries).asScala()).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(1).append(e._1()).append("=").append(e._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Quota configs for ").append(entityStr).append(" are ").append(entriesStr).toString());
    }

    public static final /* synthetic */ void $anonfun$describeClientQuotaAndUserScramCredentialConfigs$1(DescribeUserScramCredentialsResult result$1, String user) {
        try {
            UserScramCredentialsDescription description = (UserScramCredentialsDescription)result$1.description(user).get(30L, TimeUnit.SECONDS);
            String descriptionText = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(description.credentialInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)info -> new StringBuilder(12).append(info.mechanism().mechanismName()).append("=iterations=").append(info.iterations()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(51).append("SCRAM credential configs for user-principal '").append(user).append("' are ").append(descriptionText).toString());
            return;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(67).append("Error retrieving SCRAM credential configs for user-principal '").append(user).append("': ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).toString());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ ClientQuotaFilterComponent $anonfun$getAllClientQuotasConfigs$3(Tuple2 x0$1) {
        block11: {
            block12: {
                block10: {
                    if (x0$1 == null) ** GOTO lbl51
                    entityTypeOpt = (Option)x0$1._1();
                    entityNameOpt = (Option)x0$1._2();
                    var5_3 = false;
                    var6_4 = null;
                    if (!(entityTypeOpt instanceof Some)) break block10;
                    var5_3 = true;
                    var6_4 = (Some)entityTypeOpt;
                    var7_5 = (String)var6_4.value();
                    v0 = ConfigType$.MODULE$.User();
                    if (v0 != null ? v0.equals(var7_5) == false : var7_5 != null) break block10;
                    var2_6 = "user";
                    break block11;
                }
                if (!var5_3) break block12;
                var8_7 = (String)var6_4.value();
                v1 = ConfigType$.MODULE$.Client();
                if (v1 != null ? v1.equals(var8_7) == false : var8_7 != null) break block12;
                var2_6 = "client-id";
                break block11;
            }
            if (!var5_3) ** GOTO lbl-1000
            var9_8 = (String)var6_4.value();
            v2 = ConfigType$.MODULE$.Ip();
            if (!(v2 != null ? v2.equals(var9_8) == false : var9_8 != null)) {
                var2_6 = "ip";
            } else lbl-1000:
            // 2 sources

            {
                if (var5_3) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected entity type ").append(entityTypeOpt.get()).toString());
                }
                if (None$.MODULE$.equals(entityTypeOpt)) {
                    throw new IllegalArgumentException("More entity names specified than entity types");
                }
                throw new MatchError((Object)entityTypeOpt);
            }
        }
        var10_9 = false;
        var11_10 = null;
        if (!(entityNameOpt instanceof Some)) ** GOTO lbl-1000
        var10_9 = true;
        var11_10 = (Some)entityNameOpt;
        var12_11 = (String)var11_10.value();
        if ("".equals(var12_11)) {
            var1_12 = ClientQuotaFilterComponent.ofDefaultEntity((String)var2_6);
        } else if (var10_9) {
            name = (String)var11_10.value();
            var1_12 = ClientQuotaFilterComponent.ofEntity((String)var2_6, (String)name);
        } else if (None$.MODULE$.equals(entityNameOpt)) {
            var1_12 = ClientQuotaFilterComponent.ofEntityType((String)var2_6);
        } else {
            throw new MatchError((Object)entityNameOpt);
lbl51:
            // 1 sources

            throw new MatchError(null);
        }
        return var1_12;
    }

    private static final String sanitizeName$1(String entityType, String name) {
        boolean bl;
        if (name.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        String string = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            bl = true;
        } else {
            String string2 = ConfigType$.MODULE$.Client();
            bl = !(string2 != null ? !string2.equals(entityType) : entityType != null);
        }
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
        }
        String string3 = Sanitizer.sanitize((String)name);
        return string3;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseClientQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        kafka.common.Config.$init$(this);
        this.BrokerDefaultEntityName = "";
        this.BrokerLoggerConfigType = "broker-loggers";
        this.BrokerSupportedConfigTypes = (Seq)ConfigType$.MODULE$.all().$colon$plus((Object)this.BrokerLoggerConfigType(), Seq$.MODULE$.canBuildFrom());
        this.ZkSupportedConfigTypes = new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$));
        this.DefaultScramIterations = 4096;
    }

    public static final /* synthetic */ Object $anonfun$alterConfigWithZk$2$adapted(Object[] eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$2(eta$0$1$1, elem));
    }

    public static final /* synthetic */ Object $anonfun$alterConfigWithZk$4$adapted(Object[] eta$0$2$1, Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfigWithZk$4(eta$0$2$1, elem));
    }

    public static final /* synthetic */ Object $anonfun$describeConfigWithZk$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfigWithZk$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getResourceConfig$1$adapted(Option configSourceFilter$1, ConfigEntry entry) {
        return BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$getResourceConfig$1(configSourceFilter$1, entry));
    }
}

