/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import kafka.admin.ReplicaStatusCommand;
import kafka.admin.ReplicaStatusCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.SetLike;
import scala.collection.mutable.WrappedArray;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class ReplicaStatusCommand$
implements Logging {
    public static ReplicaStatusCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReplicaStatusCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public List<String> headers(boolean includeClusterLink, boolean includeMirrorInfo) {
        .colon.colon clusterLink = includeClusterLink ? new .colon.colon((Object)"ClusterLink", (List)Nil$.MODULE$) : List$.MODULE$.empty();
        .colon.colon mirror = includeMirrorInfo ? new .colon.colon((Object)"MirrorState", (List)new .colon.colon((Object)"MirrorLastFetchTimeMs", (List)new .colon.colon((Object)"MirrorLastFetchHighWatermark", (List)Nil$.MODULE$))) : List$.MODULE$.empty();
        return (List)((List)((List)new .colon.colon((Object)"Topic", (List)new .colon.colon((Object)"Partition", (List)new .colon.colon((Object)"Replica", (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)clusterLink, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"IsLeader", "IsObserver", "IsIsrEligible", "IsInIsr", "IsCaughtUp", "LastCaughtUpLagMs", "LastFetchLagMs", "LogStartOffset", "LogEndOffset", "LeaderEpoch"})), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)mirror, List$.MODULE$.canBuildFrom());
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).second());
    }

    public void run(String[] args, Duration timeout) {
        ReplicaStatusCommandOptions commandOptions = new ReplicaStatusCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool prints out the replica status of partitions.");
        ReplicaStatusCommand.Args initializedArgs = this.validateAndInitializeArgs(commandOptions);
        try (ConfluentAdmin adminClient = this.createAdminClient(commandOptions, timeout);){
            this.replicaStatus(initializedArgs, adminClient);
        }
    }

    private ConfluentAdmin createAdminClient(ReplicaStatusCommandOptions commandOptions, Duration timeout) {
        Properties props = commandOptions.options().has(commandOptions.adminClientConfigOpt()) ? Utils.loadProps((String)((String)commandOptions.options().valueOf(commandOptions.adminClientConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("request.timeout.ms", Long.toString(timeout.toMillis()));
        return (KafkaAdminClient)AdminClient.create((Properties)props);
    }

    private void replicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        try {
            this.doReplicaStatus(args, client);
            return;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while issuing request");
            throw e;
        }
    }

    private void doReplicaStatus(ReplicaStatusCommand.Args args, ConfluentAdmin client) {
        Iterable topicPartitions;
        Iterable iterable;
        Seq topics;
        Seq seq;
        if (args.topics() != null) {
            seq = (Seq)args.topics().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$1(args, x$1)));
        } else {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(ReplicaStatusCommand$.$anonfun$doReplicaStatus$2()));
            }
            seq = topics = ((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)client.listTopics(new ListTopicsOptions().listInternal(!args.excludeInternalTopics())).names().get()).asScala()).toSeq();
        }
        if (args.partitions() != null) {
            iterable = (Iterable)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (Seq)args.partitions().map((Function1 & Serializable & scala.Serializable)x$2 -> ReplicaStatusCommand$.$anonfun$doReplicaStatus$4(topic, BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        } else {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(ReplicaStatusCommand$.$anonfun$doReplicaStatus$5(topics)));
            }
            iterable = topicPartitions = (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Map)client.describeTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)topics).asJavaCollection()).all().get()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)td -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(td.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)pi -> new TopicPartition(td.name(), pi.partition()), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ReplicaStatusCommand$.$anonfun$doReplicaStatus$8(topicPartitions)));
        }
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(args.includeLinkedReplicas());
        ReplicaStatusResult result = client.replicaStatus((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)topicPartitions.toSet()).asJava(), options);
        ListBuffer entries = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((List)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.partitionResults()).asScala()).toList().sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition key = (TopicPartition)x0$1._1();
            Tuple2 tuple2 = new Tuple2((Object)key.topic(), (Object)BoxesRunTime.boxToInteger((int)key.partition()));
            return tuple2;
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition partition = (TopicPartition)x0$2._1();
            PartitionResult result = (PartitionResult)((KafkaFuture)x0$2._2()).get();
            Buffer status = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(result.replicas()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)rs -> new Tuple2((Object)rs.linkName().orElse(""), (Object)BoxesRunTime.boxToInteger((int)rs.brokerId())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
            long leaderTimeMs = BoxesRunTime.unboxToLong((Object)((TraversableLike)((TraversableLike)status.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isLeader()))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.lastCaughtUpTimeMs()), Buffer$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            Buffer buffer = (Buffer)((TraversableLike)status.filterNot((Function1 & Serializable & scala.Serializable)st -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$15(args, st)))).map((Function1 & Serializable & scala.Serializable)x$7 -> entries.$plus$eq(MODULE$.toEntries(args, partition, (ReplicaStatus)x$7, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)result.leaderEpoch().orElse(-1))), leaderTimeMs)), Buffer$.MODULE$.canBuildFrom());
            return buffer;
        });
        List<String> hdrs = this.headers(args.includeLinkedReplicas(), args.includeMirrorInfo());
        if (args.jsonOutput()) {
            this.printJson(hdrs, (List<List<String>>)entries.toList());
            return;
        }
        if (args.verboseOutput()) {
            this.printVerbose(hdrs, (List<List<String>>)entries.toList());
            return;
        }
        this.printCompact(hdrs, (List<List<String>>)entries.toList());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<String> toEntries(ReplicaStatusCommand.Args args, TopicPartition partition, ReplicaStatus status, Option<Object> leaderEpoch, long leaderTimeMs) {
        v0 /* !! */  = clusterLink = args.includeLinkedReplicas() != false ? new .colon.colon((Object)ReplicaStatusCommand$.fromString$1(status.linkName(), args), (List)Nil$.MODULE$) : List$.MODULE$.empty();
        if (!args.includeMirrorInfo()) {
            v1 = List$.MODULE$.empty();
        } else if (!status.mirrorInfo().isPresent()) {
            v1 = new .colon.colon((Object)ReplicaStatusCommand$.fromString$1(Optional.empty(), args), (List)new .colon.colon((Object)ReplicaStatusCommand$.fromLong$1(-1L, ReplicaStatusCommand$.fromLong$default$2$1()), (List)new .colon.colon((Object)ReplicaStatusCommand$.fromLong$1(-1L, ReplicaStatusCommand$.fromLong$default$2$1()), (List)Nil$.MODULE$)));
        } else {
            mi = (ReplicaStatus.MirrorInfo)status.mirrorInfo().get();
            v1 = mirror = new .colon.colon((Object)mi.state().toString(), (List)new .colon.colon((Object)ReplicaStatusCommand$.fromLong$1(mi.lastFetchTimeMs(), ReplicaStatusCommand$.fromLong$default$2$1()), (List)new .colon.colon((Object)ReplicaStatusCommand$.fromLong$1(mi.lastFetchSourceHighWatermark(), ReplicaStatusCommand$.fromLong$default$2$1()), (List)Nil$.MODULE$)));
        }
        if (!(leaderEpoch instanceof Some)) ** GOTO lbl-1000
        epoch = BoxesRunTime.unboxToInt((Object)((Some)leaderEpoch).value());
        if (status.isLeader()) {
            var7_10 = epoch;
        } else lbl-1000:
        // 2 sources

        {
            var7_10 = -1;
        }
        return (List)((List)((List)new .colon.colon((Object)partition.topic(), (List)new .colon.colon((Object)Integer.toString(partition.partition()), (List)new .colon.colon((Object)Integer.toString(status.brokerId()), (List)Nil$.MODULE$))).$plus$plus((GenTraversableOnce)clusterLink, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Boolean.toString(status.isLeader()), Boolean.toString(status.isObserver()), Boolean.toString(status.isIsrEligible()), Boolean.toString(status.isInIsr()), Boolean.toString(status.isCaughtUp()), ReplicaStatusCommand$.fromLagMs$1(status.lastCaughtUpTimeMs(), leaderTimeMs), ReplicaStatusCommand$.fromLagMs$1(status.lastFetchTimeMs(), leaderTimeMs), ReplicaStatusCommand$.fromLong$1(status.logStartOffset(), ReplicaStatusCommand$.fromLong$default$2$1()), ReplicaStatusCommand$.fromLong$1(status.logEndOffset(), ReplicaStatusCommand$.fromLong$default$2$1()), ReplicaStatusCommand$.fromLong$1(var7_10, "\"N/A\"")})), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)mirror, List$.MODULE$.canBuildFrom());
    }

    private void printJson(List<String> headers, List<List<String>> entries) {
        if (entries.isEmpty()) {
            Predef$.MODULE$.println((Object)"[]");
            return;
        }
        ObjectRef lastTopic = ObjectRef.create((Object)"");
        ObjectRef lastPartition = ObjectRef.create((Object)"");
        Predef$.MODULE$.println((Object)"[");
        ((List)entries.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReplicaStatusCommand$.$anonfun$printJson$1(lastTopic, lastPartition, headers, x0$1);
            return BoxedUnit.UNIT;
        });
        ReplicaStatusCommand$.closePartition$1();
        ReplicaStatusCommand$.closeTopic$1();
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"]");
    }

    private void printVerbose(List<String> headers, List<List<String>> entries) {
        ((List)entries.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReplicaStatusCommand$.$anonfun$printVerbose$1(headers, entries, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void printCompact(List<String> headers, List<List<String>> entries) {
        ArrayBuffer maxWidth = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((List)headers.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            ArrayBuffer arrayBuffer = maxWidth.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(name)).size()));
            return arrayBuffer;
        });
        entries.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ReplicaStatusCommand$.$anonfun$printCompact$2(maxWidth, entry);
            return BoxedUnit.UNIT;
        });
        ReplicaStatusCommand$.printEntries$1(headers, maxWidth);
        entries.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            ReplicaStatusCommand$.printEntries$1(x$8, maxWidth);
            return BoxedUnit.UNIT;
        });
    }

    private ReplicaStatusCommand.Args validateAndInitializeArgs(ReplicaStatusCommandOptions commandOptions) {
        List missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString(", ")).toString());
        }
        WrappedArray topicsArg = null;
        if (commandOptions.options().has(commandOptions.topicsOpt())) {
            topicsArg = Predef$.MODULE$.wrapRefArray((Object[])((String)commandOptions.options().valueOf(commandOptions.topicsOpt())).split(","));
            topicsArg.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                ReplicaStatusCommand$.$anonfun$validateAndInitializeArgs$1(x$10);
                return BoxedUnit.UNIT;
            });
        }
        ListBuffer partitionsArg = null;
        if (commandOptions.options().has(commandOptions.partitionsOpt())) {
            ListBuffer tmpPartitions = new ListBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)commandOptions.options().valueOf(commandOptions.partitionsOpt())).split(","))).foreach((Function1 & Serializable & scala.Serializable)partitionStr -> {
                ListBuffer listBuffer;
                String[] divPartitions = partitionStr.split("-");
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])divPartitions)).isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])divPartitions)).size() > 2) {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid partition range: ").append((String)partitionStr).toString());
                }
                try {
                    int first = new StringOps(Predef$.MODULE$.augmentString(divPartitions[0])).toInt();
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])divPartitions)).size() != 1) {
                        int second = new StringOps(Predef$.MODULE$.augmentString(divPartitions[1])).toInt();
                        if (first > second) {
                            throw new IllegalArgumentException(new StringBuilder(25).append("Invalid partition range: ").append((String)partitionStr).toString());
                        }
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(first), second + 1).foreach((Function1 & Serializable & scala.Serializable)i -> tmpPartitions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))));
                        return BoxedUnit.UNIT;
                    }
                    listBuffer = tmpPartitions.$plus$eq((Object)BoxesRunTime.boxToInteger((int)first));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(new StringBuilder(27).append("Failed to parse partition: ").append((String)partitionStr).toString());
                }
                return listBuffer;
            });
            partitionsArg = tmpPartitions;
        }
        boolean verboseOutputArg = commandOptions.options().has((OptionSpec)commandOptions.verboseOutputOpt());
        boolean jsonOutputArg = commandOptions.options().has((OptionSpec)commandOptions.jsonOutputOpt());
        boolean excludeInternalTopicsArg = commandOptions.options().has((OptionSpec)commandOptions.excludeInternalTopicsOpt());
        boolean includeLinkedReplicasArg = commandOptions.options().has((OptionSpec)commandOptions.includeLinkedReplicasOpt());
        boolean includeMirrorInfoArg = commandOptions.options().has((OptionSpec)commandOptions.includeMirrorInfoOpt());
        Option leadersArg = ReplicaStatusCommand$.parseBoolOpt$1(commandOptions.leadersOpt(), commandOptions);
        Option observersArg = ReplicaStatusCommand$.parseBoolOpt$1(commandOptions.observersOpt(), commandOptions);
        return new ReplicaStatusCommand.Args((Seq<String>)topicsArg, (Seq<Object>)partitionsArg, (Option<Object>)leadersArg, (Option<Object>)observersArg, verboseOutputArg, jsonOutputArg, excludeInternalTopicsArg, includeLinkedReplicasArg, includeMirrorInfoArg);
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$1(ReplicaStatusCommand.Args args$1, String x$1) {
        return Topic.isInternal((String)x$1) && args$1.excludeInternalTopics();
    }

    public static final /* synthetic */ String $anonfun$doReplicaStatus$2() {
        return "Calling AdminClient.listTopics()";
    }

    public static final /* synthetic */ TopicPartition $anonfun$doReplicaStatus$4(String topic$1, int x$2) {
        return new TopicPartition(topic$1, x$2);
    }

    public static final /* synthetic */ String $anonfun$doReplicaStatus$5(Seq topics$1) {
        return new StringBuilder(35).append("Calling AdminClient.describeTopics(").append(topics$1).toString();
    }

    public static final /* synthetic */ String $anonfun$doReplicaStatus$8(Iterable topicPartitions$1) {
        return new StringBuilder(35).append("Calling AdminClient.replicaStatus(").append(topicPartitions$1).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$16(ReplicaStatus st$1, boolean x$5) {
        return x$5 != st$1.isLeader();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$17(ReplicaStatus st$1, boolean x$6) {
        return x$6 != st$1.isObserver();
    }

    public static final /* synthetic */ boolean $anonfun$doReplicaStatus$15(ReplicaStatusCommand.Args args$1, ReplicaStatus st) {
        return args$1.leaders().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$16(st, BoxesRunTime.unboxToBoolean((Object)x$5)))) || args$1.observers().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommand$.$anonfun$doReplicaStatus$17(st, BoxesRunTime.unboxToBoolean((Object)x$6))));
    }

    private static final String fromLagMs$1(long timeMs, long leaderTimeMs$2) {
        if (timeMs > 0L) {
            return Long.toString(leaderTimeMs$2 - timeMs);
        }
        return "-1";
    }

    private static final String fromLong$1(long value, String defaultValue) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return defaultValue;
    }

    private static final String fromLong$default$2$1() {
        return "-1";
    }

    private static final String fromString$1(Optional value, ReplicaStatusCommand.Args args$2) {
        if (value.isPresent()) {
            return (String)value.get();
        }
        if (args$2.jsonOutput()) {
            return "\"\"";
        }
        return "-";
    }

    private static final String addQuotes$1(String string) {
        return new StringBuilder(2).append("\"").append(string).append("\"").toString();
    }

    private static final void closeTopic$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"    ]");
        Predef$.MODULE$.print((Object)"  }");
    }

    private static final void closePartition$1() {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)"        ]");
        Predef$.MODULE$.print((Object)"      }");
    }

    public static final /* synthetic */ void $anonfun$printJson$2(List headers$1, List entry$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String subEntry = (String)x0$2._1();
            int subIndex = x0$2._2$mcI$sp();
            if (subIndex >= 2) {
                Predef$.MODULE$.print((Object)new StringBuilder(14).append("            ").append(ReplicaStatusCommand$.addQuotes$1((String)headers$1.apply(subIndex))).append(": ").append(subEntry).toString());
                if (subIndex < entry$1.size() - 1) {
                    Predef$.MODULE$.println((Object)",");
                    return;
                }
                Predef$.MODULE$.println();
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$printJson$1(ObjectRef lastTopic$1, ObjectRef lastPartition$1, List headers$1, Tuple2 x0$1) {
        block10: {
            if (x0$1 == null) break block10;
            entry = (List)x0$1._1();
            index = x0$1._2$mcI$sp();
            v0 = (String)lastTopic$1.elem;
            var7_6 = entry.apply(0);
            v1 = (v0 == null ? var7_6 != null : v0.equals(var7_6) == false) ? true : (newTopic = false);
            if (newTopic) ** GOTO lbl-1000
            v2 = (String)lastPartition$1.elem;
            var9_8 = entry.apply(1);
            if (v2 == null ? var9_8 != null : v2.equals(var9_8) == false) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = newPartition = false;
            }
            if (index > 0) {
                if (newPartition) {
                    ReplicaStatusCommand$.closePartition$1();
                }
                if (newTopic) {
                    ReplicaStatusCommand$.closeTopic$1();
                }
            }
            if (newTopic) {
                if (index > 0) {
                    Predef$.MODULE$.println((Object)",");
                }
                Predef$.MODULE$.println((Object)"  {");
                Predef$.MODULE$.println((Object)new StringBuilder(14).append("    \"Topic\": ").append(ReplicaStatusCommand$.addQuotes$1((String)entry.apply(0))).append(",").toString());
                Predef$.MODULE$.println((Object)"    \"Partitions\": [");
            }
            if (newPartition) {
                if (!newTopic) {
                    Predef$.MODULE$.println((Object)",");
                }
                Predef$.MODULE$.println((Object)"      {");
                Predef$.MODULE$.println((Object)new StringBuilder(22).append("        \"Partition\": ").append(entry.apply(1)).append(",").toString());
                Predef$.MODULE$.println((Object)"        \"Replicas\": [");
            }
            lastTopic$1.elem = (String)entry.apply(0);
            lastPartition$1.elem = (String)entry.apply(1);
            if (!newPartition) {
                Predef$.MODULE$.println((Object)",");
            }
            Predef$.MODULE$.println((Object)"          {");
            ((List)entry.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$printJson$2$adapted(scala.collection.immutable.List scala.collection.immutable.List scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((List)headers$1, (List)entry));
            Predef$.MODULE$.print((Object)"          }");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printVerbose$1(List headers$2, List entries$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            List entry = (List)x0$1._1();
            int index = x0$1._2$mcI$sp();
            ((List)headers$2.zip((GenIterable)entry, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)subEntry -> {
                Predef$.MODULE$.println((Object)new StringBuilder(2).append(subEntry._1()).append(": ").append(subEntry._2()).toString());
                return BoxedUnit.UNIT;
            });
            if (index < entries$2.size() - 1) {
                Predef$.MODULE$.println();
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$printCompact$3(ArrayBuffer maxWidth$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String subEntry = (String)x0$2._1();
            int index = x0$2._2$mcI$sp();
            maxWidth$1.update(index, (Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)maxWidth$1.apply(index))), new StringOps(Predef$.MODULE$.augmentString(subEntry)).size())));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$printCompact$2(ArrayBuffer maxWidth$1, List entry) {
        ((List)entry.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ReplicaStatusCommand$.$anonfun$printCompact$3(maxWidth$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final void printEntry$1(String string, int index, ArrayBuffer maxWidth$1) {
        Predef$.MODULE$.print((Object)string);
        Predef$.MODULE$.print((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(BoxesRunTime.unboxToInt((Object)maxWidth$1.apply(index)) - new StringOps(Predef$.MODULE$.augmentString(string)).size() + 1));
    }

    private static final void printEntries$1(List entries, ArrayBuffer maxWidth$1) {
        ((List)entries.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)e -> {
            ReplicaStatusCommand$.printEntry$1((String)e._1(), e._2$mcI$sp(), maxWidth$1);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$validateAndInitializeArgs$1(String x$10) {
        Topic.validate((String)x$10);
    }

    private static final Option parseBoolOpt$1(ArgumentAcceptingOptionSpec spec, ReplicaStatusCommandOptions commandOptions$1) {
        Some some;
        if (!commandOptions$1.options().has((OptionSpec)spec)) {
            return None$.MODULE$;
        }
        if (commandOptions$1.options().valueOf((OptionSpec)spec) == null) {
            return new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        String string = ((String)commandOptions$1.options().valueOf((OptionSpec)spec)).toLowerCase();
        if ("only".equals(string)) {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if ("exclude".equals(string)) {
            some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new IllegalArgumentException(new StringBuilder(18).append("Unexpected value: ").append(string).toString());
        }
        return some;
    }

    private ReplicaStatusCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$printJson$2$adapted(List headers$1, List entry$1, Tuple2 x0$2) {
        ReplicaStatusCommand$.$anonfun$printJson$2(headers$1, entry$1, x0$2);
        return BoxedUnit.UNIT;
    }
}

