/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin.balancer;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionSpec;
import kafka.admin.balancer.BrokerRemovalCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BrokerRemovalDescription;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.RemoveBrokersOptions;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.BrokerRemovalInProgressException;
import org.apache.kafka.common.errors.BrokerRemovedException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BrokerRemovalCommand$
implements Logging {
    public static BrokerRemovalCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new BrokerRemovalCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ConfluentAdmin createAdminClient(BrokerRemovalCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options().valueOf(opts.bootstrapServer()));
        return ConfluentAdmin.create((Properties)props);
    }

    public String flagName(OptionSpec<?> option) {
        return new StringBuilder(2).append("--").append(option.options().get(0)).toString();
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, this.run$default$2());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("Error while executing broker removal: ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(BrokerRemovalCommand$.$anonfun$main$1(e)));
                }
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    public void run(String[] args, Option<ConfluentAdmin> clientOpt) {
        BrokerRemovalCommandOptions opts = new BrokerRemovalCommandOptions(args);
        opts.checkArgs();
        try (ConfluentAdmin client = (ConfluentAdmin)clientOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    this.removeBroker(opts, client);
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeBrokerRemoval(opts, client);
                }
            }
            catch (ApiException e) {
                if (e instanceof TimeoutException) {
                    throw new AdminCommandFailedException("Timed out waiting for results", e);
                }
                if (e instanceof ClusterAuthorizationException) {
                    ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)e;
                    throw new AdminCommandFailedException(clusterAuthorizationException.getMessage(), e);
                }
                if (e instanceof InvalidRequestException) {
                    InvalidRequestException invalidRequestException = (InvalidRequestException)e;
                    throw new AdminCommandFailedException(invalidRequestException.getMessage(), e);
                }
                if (e instanceof BrokerNotAvailableException) {
                    BrokerNotAvailableException brokerNotAvailableException = (BrokerNotAvailableException)e;
                    throw new AdminCommandFailedException(brokerNotAvailableException.getMessage(), e);
                }
                if (e instanceof BrokerRemovalInProgressException) {
                    throw new AdminCommandFailedException(new StringBuilder(40).append("One of brokers ").append((Object)opts.valueOf(opts.brokerIdsOpt())).append(" ").append("is already being removed").toString(), e);
                }
                if (e instanceof BrokerRemovedException) {
                    throw new AdminCommandFailedException(new StringBuilder(40).append("One of brokers ").append((Object)opts.valueOf(opts.brokerIdsOpt())).append(" ").append("has already been removed").toString(), e);
                }
                throw e;
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)"Error while issuing request");
                throw e;
            }
        }
    }

    public Option<ConfluentAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void removeBroker(BrokerRemovalCommandOptions opts, ConfluentAdmin client) {
        ArrayList<Integer> brokerIds = new ArrayList<Integer>();
        if (opts.options().has(opts.brokerIdOpt())) {
            String brokerId = opts.valueOf(opts.brokerIdOpt());
            brokerIds.add(Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString(brokerId)).toInt()));
        } else if (opts.options().has(opts.brokerIdsOpt())) {
            ((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(opts.valueOf(opts.brokerIdsOpt()))).split(','))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRemovalCommand$.$anonfun$removeBroker$1(x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)BrokerRemovalCommand$.$anonfun$removeBroker$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toList()).asJava()).forEach(id -> brokerIds.add(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id))));
        }
        Predef$.MODULE$.println((Object)"Initiating remove brokers call...");
        boolean shouldShutdown = !opts.options().has((OptionSpec)opts.noShutdownOpt());
        RemoveBrokersOptions options = new RemoveBrokersOptions().shouldShutdownBrokers(shouldShutdown);
        client.removeBrokers(brokerIds, options).all().get();
        Predef$.MODULE$.println((Object)new StringBuilder(40).append("Started remove broker task for brokers ").append(brokerIds).append(".").toString());
        Predef$.MODULE$.println((Object)"You can check its status by calling this command again with the `--describe` option.");
    }

    private void describeBrokerRemoval(BrokerRemovalCommandOptions opts, ConfluentAdmin client) {
        Iterable filterResult = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Map)client.describeBrokerRemovals().descriptions().get()).values()).asScala();
        String msgAnnex = "";
        if (opts.options().has(opts.brokerIdOpt())) {
            int brokerId = new StringOps(Predef$.MODULE$.augmentString(opts.valueOf(opts.brokerIdOpt()))).toInt();
            msgAnnex = new StringBuilder(12).append(" for broker ").append(brokerId).toString();
            filterResult = (Iterable)filterResult.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerRemovalCommand$.$anonfun$describeBrokerRemoval$1(brokerId, e)));
        } else if (opts.options().has(opts.brokerIdsOpt())) {
            int[] brokerIds = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)opts.options().valueOf(opts.brokerIdsOpt()))).split(','))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BrokerRemovalCommand$.$anonfun$describeBrokerRemoval$2(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BrokerRemovalCommand$.$anonfun$describeBrokerRemoval$3(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            msgAnnex = new StringBuilder(13).append(" for brokers ").append(brokerIds).toString();
            filterResult = (Iterable)filterResult.filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerRemovalCommand$.$anonfun$describeBrokerRemoval$4(brokerIds, e)));
        }
        if (filterResult.isEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(30).append("No broker removals in progress").append(msgAnnex).toString());
            return;
        }
        filterResult.foreach((Function1 & Serializable & scala.Serializable)desc -> {
            Predef$.MODULE$.println((Object)BrokerRemovalCommand$.MODULE$.brokerRemovalDescriptionString(desc));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private String brokerRemovalDescriptionString(BrokerRemovalDescription desc) {
        void var3_3;
        String lineSeparator = new StringBuilder(2).append(System.lineSeparator()).append("  ").toString();
        String baseStringDescription = new StringBuilder(132).append("Broker ").append(desc.brokerId()).append(" removal status - ").append(desc.generalOperationStatus()).append(". Sub-task statuses:").append(lineSeparator).append("Broker Replica Exclusion: ").append(desc.brokerReplicaExclusionStatus()).append(lineSeparator).append("Partition Reassignment: ").append(desc.reassignmentsStatus()).append(lineSeparator).append("Broker Shutdown: ").append(desc.shutdownStatus()).append(lineSeparator).append("Shutdown Scheduled: ").append(desc.isShutdownScheduled()).toString();
        if (desc.removalError().isPresent()) {
            BrokerRemovalError balancerOpError = (BrokerRemovalError)desc.removalError().get();
            baseStringDescription = new StringBuilder(2).append(baseStringDescription).append(lineSeparator).append(balancerOpError.exception().getClass().getName()).append(": ").append(balancerOpError.errorMessage()).toString();
        }
        baseStringDescription = new StringBuilder(25).append(baseStringDescription).append(lineSeparator).append("Operation Creation Time: ").append(ClientUtils.utcDateFor((long)desc.createTimeMs())).toString();
        baseStringDescription = new StringBuilder(28).append(baseStringDescription).append(lineSeparator).append("Operation Last Update Time: ").append(ClientUtils.utcDateFor((long)desc.lastUpdateTimeMs())).toString();
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ boolean $anonfun$removeBroker$1(String x$1) {
        return !x$1.isEmpty();
    }

    public static final /* synthetic */ int $anonfun$removeBroker$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$describeBrokerRemoval$1(int brokerId$1, BrokerRemovalDescription e) {
        return BoxesRunTime.equalsNumObject((Number)e.brokerId(), (Object)BoxesRunTime.boxToInteger((int)brokerId$1));
    }

    public static final /* synthetic */ boolean $anonfun$describeBrokerRemoval$2(String x$3) {
        return !x$3.isEmpty();
    }

    public static final /* synthetic */ int $anonfun$describeBrokerRemoval$3(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4.trim())).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$describeBrokerRemoval$4(int[] brokerIds$2, BrokerRemovalDescription e) {
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerIds$2)).contains((Object)e.brokerId());
    }

    private BrokerRemovalCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

