/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import kafka.cluster.Broker$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.EndPoint;
import kafka.common.BrokerEndPointNotAvailableException;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.audit.NoOpAuditLogProvider;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\ruv!\u0002+V\u0011\u0003Qf!\u0002/V\u0011\u0003i\u0006\"B4\u0002\t\u0003Ag!B5\u0002\u0001^S\u0007BCA\u0006\u0007\tU\r\u0011\"\u0001\u0002\u000e!Q\u00111D\u0002\u0003\u0012\u0003\u0006I!a\u0004\t\u0015\u0005u1A!f\u0001\n\u0003\ty\u0002\u0003\u0006\u0002(\r\u0011\t\u0012)A\u0005\u0003CA!\"!\u000b\u0004\u0005+\u0007I\u0011AA\u0016\u0011)\tyd\u0001B\tB\u0003%\u0011Q\u0006\u0005\u000b\u0003\u0003\u001a!Q3A\u0005\u0002\u0005\r\u0003BCA#\u0007\tE\t\u0015!\u0003\u0002:!Q\u0011qI\u0002\u0003\u0016\u0004%\t%!\u0013\t\u0015\u0005\r4A!E!\u0002\u0013\tY\u0005\u0003\u0006\u0002f\r\u0011)\u001a!C!\u0003OB!\"!\u001e\u0004\u0005#\u0005\u000b\u0011BA5\u0011)\t9h\u0001BK\u0002\u0013\u0005\u0013\u0011\u0010\u0005\u000b\u0003\u000b\u001b!\u0011#Q\u0001\n\u0005m\u0004BB4\u0004\t\u0003\t9\tC\u0005\u0002\u001c\u000e\t\t\u0011\"\u0001\u0002\u001e\"I\u0011QV\u0002\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003\u000b\u001c\u0011\u0013!C\u0001\u0003\u000fD\u0011\"a3\u0004#\u0003%\t!!4\t\u0013\u0005E7!%A\u0005\u0002\u0005M\u0007\"CAl\u0007E\u0005I\u0011AAm\u0011%\tinAI\u0001\n\u0003\ty\u000eC\u0005\u0002d\u000e\t\n\u0011\"\u0001\u0002f\"I\u0011\u0011^\u0002\u0002\u0002\u0013\u0005\u00131\u001e\u0005\n\u0003g\u001c\u0011\u0011!C\u0001\u0003?A\u0011\"!>\u0004\u0003\u0003%\t!a>\t\u0013\t\r1!!A\u0005B\t\u0015\u0001\"\u0003B\n\u0007\u0005\u0005I\u0011\u0001B\u000b\u0011%\u0011ybAA\u0001\n\u0003\u0012\t\u0003C\u0005\u0003$\r\t\t\u0011\"\u0011\u0003&!I!qE\u0002\u0002\u0002\u0013\u0005#\u0011F\u0004\u000b\u0005[\t\u0011\u0011!E\u0001/\n=b!C5\u0002\u0003\u0003E\ta\u0016B\u0019\u0011\u00199G\u0005\"\u0001\u0003@!I!1\u0005\u0013\u0002\u0002\u0013\u0015#Q\u0005\u0005\n\u0005\u0003\"\u0013\u0011!CA\u0005\u0007B\u0011Ba\u0015%\u0003\u0003%\tI!\u0016\t\u0013\t\u001dD%!A\u0005\n\t%\u0004b\u0002B!\u0003\u0011\u0005!1\u000e\u0005\b\u0005\u0003\nA\u0011ABI\u0011\u001d\u0011\t%\u0001C\u0001\u00077C\u0011B!\u0011\u0002\u0003\u0003%\ti!*\t\u0013\tM\u0013!!A\u0005\u0002\u000eE\u0006\"\u0003B4\u0003\u0005\u0005I\u0011\u0002B5\r\u0015aV\u000b\u0011B8\u0011)\u0011\t\b\rBK\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0005g\u0002$\u0011#Q\u0001\n\u0005\u0005\u0002B\u0003B;a\tU\r\u0011\"\u0001\u0003x!Q!Q\u0011\u0019\u0003\u0012\u0003\u0006IA!\u001f\t\u0015\t\u001d\u0005G!f\u0001\n\u0003\u0011I\t\u0003\u0006\u0003\"B\u0012\t\u0012)A\u0005\u0005\u0017C!Ba)1\u0005+\u0007I\u0011\u0001BS\u0011)\u0011I\f\rB\tB\u0003%!q\u0015\u0005\u000b\u0005w\u0003$Q3A\u0005\u0002\tu\u0006B\u0003Bca\tE\t\u0015!\u0003\u0003@\"1q\r\rC\u0001\u0005\u000fD\u0011Ba51\u0005\u0004%IA!6\t\u0011\t5\b\u0007)A\u0005\u0005/DqAa\t1\t\u0003\u0012y\u000f\u0003\u0004ha\u0011\u0005!\u0011\u001f\u0005\u0007OB\"\ta!\u0006\t\u000f\r\u0015\u0002\u0007\"\u0001\u0004(!91\u0011\u0007\u0019\u0005\u0002\rM\u0002bBB\u001da\u0011\u000511\b\u0005\b\u0007\u007f\u0001D\u0011AB!\u0011\u001d\u0019)\u0005\rC\u0001\u0007\u000fB\u0011b!\u00191#\u0003%\t!a8\t\u0013\u0005m\u0005'!A\u0005\u0002\r\r\u0004\"CAWaE\u0005I\u0011AAd\u0011%\t)\rMI\u0001\n\u0003\u0019y\u0007C\u0005\u0002LB\n\n\u0011\"\u0001\u0004t!I\u0011\u0011\u001b\u0019\u0012\u0002\u0013\u00051q\u000f\u0005\n\u0003/\u0004\u0014\u0013!C\u0001\u0007wB\u0011\"!;1\u0003\u0003%\t%a;\t\u0013\u0005M\b'!A\u0005\u0002\u0005}\u0001\"CA{a\u0005\u0005I\u0011AB@\u0011%\u0011\u0019\u0001MA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\u0014A\n\t\u0011\"\u0001\u0004\u0004\"I!q\u0004\u0019\u0002\u0002\u0013\u0005#\u0011\u0005\u0005\n\u0005O\u0001\u0014\u0011!C!\u0007\u000f\u000baA\u0011:pW\u0016\u0014(B\u0001,X\u0003\u001d\u0019G.^:uKJT\u0011\u0001W\u0001\u0006W\u000647.Y\u0002\u0001!\tY\u0016!D\u0001V\u0005\u0019\u0011%o\\6feN\u0019\u0011A\u00183\u0011\u0005}\u0013W\"\u00011\u000b\u0003\u0005\fQa]2bY\u0006L!a\u00191\u0003\r\u0005s\u0017PU3g!\tyV-\u0003\u0002gA\na1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012A\u0017\u0002\u000b'\u0016\u0014h/\u001a:J]\u001a|7CB\u0002lg\u0006\u0015A\r\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!A.\u00198h\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\r=\u0013'.Z2u!\r!\u0018\u0011A\u0007\u0002k*\u0011ao^\u0001\nS:$XM\u001d8bYNT!\u0001_=\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002{w\u000611/\u001a:wKJT!\u0001\u0017?\u000b\u0005ut\u0018AB1qC\u000eDWMC\u0001\u0000\u0003\ry'oZ\u0005\u0004\u0003\u0007)(!H\"p]\u001adW/\u001a8u\u0003V$\bn\u001c:ju\u0016\u00148+\u001a:wKJLeNZ8\u0011\u0007}\u000b9!C\u0002\u0002\n\u0001\u0014q\u0001\u0015:pIV\u001cG/A\bdYV\u001cH/\u001a:SKN|WO]2f+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)b_\u0001\u0007G>lWn\u001c8\n\t\u0005e\u00111\u0003\u0002\u0010\u00072,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0006\u00012\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\rI\u0001\tEJ|7.\u001a:JIV\u0011\u0011\u0011\u0005\t\u0004?\u0006\r\u0012bAA\u0013A\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013!C3oIB|\u0017N\u001c;t+\t\ti\u0003\u0005\u0004\u00020\u0005U\u0012\u0011H\u0007\u0003\u0003cQ1!a\rp\u0003\u0011)H/\u001b7\n\t\u0005]\u0012\u0011\u0007\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\u0012\u0005m\u0012\u0002BA\u001f\u0003'\u0011\u0001\"\u00128ea>Lg\u000e^\u0001\u000bK:$\u0007o\\5oiN\u0004\u0013aE5oi\u0016\u0014(I]8lKJ,e\u000e\u001a9pS:$XCAA\u001d\u0003QIg\u000e^3s\u0005J|7.\u001a:F]\u0012\u0004x.\u001b8uA\u0005\u0001\u0002\u000e\u001e;q'\u0016\u0014h/\u001a:CS:$WM]\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002`5\u0011\u0011q\n\u0006\u0004u\u0006E#\u0002BA*\u0003+\nA\u0001\u001b;ua*\u0019\u0001,a\u0016\u000b\t\u0005e\u00131L\u0001\nG>tg\r\\;f]RT!!!\u0018\u0002\u0005%|\u0017\u0002BA1\u0003\u001f\u0012QcS1gW\u0006DE\u000f\u001e9TKJ4XM\u001d\"j]\u0012,'/A\tiiR\u00048+\u001a:wKJ\u0014\u0015N\u001c3fe\u0002\n\u0001#Y;eSRdun\u001a)s_ZLG-\u001a:\u0016\u0005\u0005%\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=\u00140A\u0003bk\u0012LG/\u0003\u0003\u0002t\u00055$\u0001E!vI&$Hj\\4Qe>4\u0018\u000eZ3s\u0003E\tW\u000fZ5u\u0019><\u0007K]8wS\u0012,'\u000fI\u0001\b[\u0016$(/[2t+\t\tY\b\u0005\u0003\u0002~\u0005\u0005UBAA@\u0015\u0011\t9(a\u0005\n\t\u0005\r\u0015q\u0010\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004C\u0003EAE\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015qSAM!\r\tYiA\u0007\u0002\u0003!9\u00111\u0002\nA\u0002\u0005=\u0001bBA\u000f%\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003S\u0011\u0002\u0019AA\u0017\u0011\u001d\t\tE\u0005a\u0001\u0003sAq!a\u0012\u0013\u0001\u0004\tY\u0005C\u0004\u0002fI\u0001\r!!\u001b\t\u000f\u0005]$\u00031\u0001\u0002|\u0005!1m\u001c9z)A\tI)a(\u0002\"\u0006\r\u0016QUAT\u0003S\u000bY\u000bC\u0005\u0002\fM\u0001\n\u00111\u0001\u0002\u0010!I\u0011QD\n\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0003S\u0019\u0002\u0013!a\u0001\u0003[A\u0011\"!\u0011\u0014!\u0003\u0005\r!!\u000f\t\u0013\u0005\u001d3\u0003%AA\u0002\u0005-\u0003\"CA3'A\u0005\t\u0019AA5\u0011%\t9h\u0005I\u0001\u0002\u0004\tY(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E&\u0006BA\b\u0003g[#!!.\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f\u0003\u0017AC1o]>$\u0018\r^5p]&!\u00111YA]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIM\u000b\u0003\u0002\"\u0005M\u0016AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fTC!!\f\u00024\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAAkU\u0011\tI$a-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u00111\u001c\u0016\u0005\u0003\u0017\n\u0019,\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005\u0005(\u0006BA5\u0003g\u000babY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0002h*\"\u00111PAZ\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001e\t\u0004Y\u0006=\u0018bAAy[\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002z\u0006}\bcA0\u0002|&\u0019\u0011Q 1\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u0002u\t\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0002\u0011\r\t%!qBA}\u001b\t\u0011YAC\u0002\u0003\u000e\u0001\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tBa\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005/\u0011i\u0002E\u0002`\u00053I1Aa\u0007a\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u0001 \u0003\u0003\u0005\r!!?\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\t\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!<\u0002\r\u0015\fX/\u00197t)\u0011\u00119Ba\u000b\t\u0013\t\u0005!%!AA\u0002\u0005e\u0018AC*feZ,'/\u00138g_B\u0019\u00111\u0012\u0013\u0014\t\u0011\u0012\u0019\u0004\u001a\t\u0015\u0005k\u0011Y$a\u0004\u0002\"\u00055\u0012\u0011HA&\u0003S\nY(!#\u000e\u0005\t]\"b\u0001B\u001dA\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u001f\u0005o\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c88)\t\u0011y#A\u0003baBd\u0017\u0010\u0006\t\u0002\n\n\u0015#q\tB%\u0005\u0017\u0012iEa\u0014\u0003R!9\u00111B\u0014A\u0002\u0005=\u0001bBA\u000fO\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003S9\u0003\u0019AA\u0017\u0011\u001d\t\te\na\u0001\u0003sAq!a\u0012(\u0001\u0004\tY\u0005C\u0004\u0002f\u001d\u0002\r!!\u001b\t\u000f\u0005]t\u00051\u0001\u0002|\u00059QO\\1qa2LH\u0003\u0002B,\u0005G\u0002Ra\u0018B-\u0005;J1Aa\u0017a\u0005\u0019y\u0005\u000f^5p]B\trLa\u0018\u0002\u0010\u0005\u0005\u0012QFA\u001d\u0003\u0017\nI'a\u001f\n\u0007\t\u0005\u0004M\u0001\u0004UkBdWm\u000e\u0005\n\u0005KB\u0013\u0011!a\u0001\u0003\u0013\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003-$\u0002B!\u001c\u0004\f\u000e55q\u0012\t\u00037B\u001aR\u0001\r0\u0002\u0006\u0011\f!!\u001b3\u0002\u0007%$\u0007%A\u0005f]\u0012\u0004v.\u001b8ugV\u0011!\u0011\u0010\t\u0007\u0005\u0013\u0011YHa \n\t\tu$1\u0002\u0002\u0004'\u0016\f\bcA.\u0003\u0002&\u0019!1Q+\u0003\u0011\u0015sG\rU8j]R\f!\"\u001a8e!>Lg\u000e^:!\u0003\u0011\u0011\u0018mY6\u0016\u0005\t-\u0005#B0\u0003Z\t5\u0005\u0003\u0002BH\u0005;sAA!%\u0003\u001aB\u0019!1\u00131\u000e\u0005\tU%b\u0001BL3\u00061AH]8pizJ1Aa'a\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\u001fBP\u0015\r\u0011Y\nY\u0001\u0006e\u0006\u001c7\u000eI\u0001\tM\u0016\fG/\u001e:fgV\u0011!q\u0015\t\u0007\u0005S\u0013yKa-\u000e\u0005\t-&\u0002\u0002BW\u0003'\tqAZ3biV\u0014X-\u0003\u0003\u00032\n-&\u0001\u0003$fCR,(/Z:\u0011\t\t%&QW\u0005\u0005\u0005o\u0013YKA\u000bTkB\u0004xN\u001d;fIZ+'o]5p]J\u000bgnZ3\u0002\u0013\u0019,\u0017\r^;sKN\u0004\u0013\u0001\u0002;bON,\"Aa0\u0011\u0011\t=%\u0011\u0019BG\u0005\u001bKAAa1\u0003 \n\u0019Q*\u00199\u0002\u000bQ\fwm\u001d\u0011\u0015\u0019\t5$\u0011\u001aBf\u0005\u001b\u0014yM!5\t\u000f\tE4\b1\u0001\u0002\"!9!QO\u001eA\u0002\te\u0004b\u0002BDw\u0001\u0007!1\u0012\u0005\b\u0005G[\u0004\u0019\u0001BT\u0011\u001d\u0011Yl\u000fa\u0001\u0005\u007f\u000bA\"\u001a8e!>Lg\u000e^:NCB,\"Aa6\u0011\u0011\te'q\u001cBq\u0005\u007fj!Aa7\u000b\t\tu'1B\u0001\nS6lW\u000f^1cY\u0016LAAa1\u0003\\B!!1\u001dBu\u001b\t\u0011)O\u0003\u0003\u0003h\u0006M\u0011a\u00028fi^|'o[\u0005\u0005\u0005W\u0014)O\u0001\u0007MSN$XM\\3s\u001d\u0006lW-A\u0007f]\u0012\u0004v.\u001b8ug6\u000b\u0007\u000f\t\u000b\u0003\u0005\u001b#BB!\u001c\u0003t\nU(\u0011 B\u007f\u0007\u0003AqA!\u001d@\u0001\u0004\t\t\u0003C\u0004\u0003x~\u0002\rA!$\u0002\t!|7\u000f\u001e\u0005\b\u0005w|\u0004\u0019AA\u0011\u0003\u0011\u0001xN\u001d;\t\u000f\t}x\b1\u0001\u0003b\u0006aA.[:uK:,'OT1nK\"911A A\u0002\r\u0015\u0011\u0001\u00039s_R|7m\u001c7\u0011\t\r\u001d1\u0011C\u0007\u0003\u0007\u0013QAaa\u0003\u0004\u000e\u0005!\u0011-\u001e;i\u0015\u0011\u0019y!a\u0005\u0002\u0011M,7-\u001e:jifLAaa\u0005\u0004\n\t\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u000b\t\u0005[\u001a9b!\t\u0004$!91\u0011\u0004!A\u0002\rm\u0011a\u00012faB\u00191l!\b\n\u0007\r}QK\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\t\u000f\t}\b\t1\u0001\u0003b\"911\u0001!A\u0002\r\u0015\u0011\u0001\u00028pI\u0016$Ba!\u000b\u00040A!\u0011\u0011CB\u0016\u0013\u0011\u0019i#a\u0005\u0003\t9{G-\u001a\u0005\b\u0005\u007f\f\u0005\u0019\u0001Bq\u0003\u001d9W\r\u001e(pI\u0016$Ba!\u000e\u00048A)qL!\u0017\u0004*!9!q \"A\u0002\t\u0005\u0018A\u00042s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0005\u00077\u0019i\u0004C\u0004\u0003\u0000\u000e\u0003\rA!9\u0002\u0011\u0015tG\rU8j]R$BAa \u0004D!9!q #A\u0002\t\u0005\u0018\u0001\u0004;p'\u0016\u0014h/\u001a:J]\u001a|GcC:\u0004J\r531LB/\u0007?Bqaa\u0013F\u0001\u0004\u0011i)A\u0005dYV\u001cH/\u001a:JI\"91qJ#A\u0002\rE\u0013AB2p]\u001aLw\r\u0005\u0003\u0004T\r]SBAB+\u0015\tQx+\u0003\u0003\u0004Z\rU#aC&bM.\f7i\u001c8gS\u001eDq!a\u0012F\u0001\u0004\tY\u0005C\u0005\u0002f\u0015\u0003\n\u00111\u0001\u0002j!9\u0011qO#A\u0002\u0005m\u0014A\u0006;p'\u0016\u0014h/\u001a:J]\u001a|G\u0005Z3gCVdG\u000f\n\u001b\u0015\u0019\t54QMB4\u0007S\u001aYg!\u001c\t\u0013\tEt\t%AA\u0002\u0005\u0005\u0002\"\u0003B;\u000fB\u0005\t\u0019\u0001B=\u0011%\u00119i\u0012I\u0001\u0002\u0004\u0011Y\tC\u0005\u0003$\u001e\u0003\n\u00111\u0001\u0003(\"I!1X$\u0011\u0002\u0003\u0007!qX\u000b\u0003\u0007cRCA!\u001f\u00024V\u00111Q\u000f\u0016\u0005\u0005\u0017\u000b\u0019,\u0006\u0002\u0004z)\"!qUAZ+\t\u0019iH\u000b\u0003\u0003@\u0006MF\u0003BA}\u0007\u0003C\u0011B!\u0001P\u0003\u0003\u0005\r!!\t\u0015\t\t]1Q\u0011\u0005\n\u0005\u0003\t\u0016\u0011!a\u0001\u0003s$BAa\u0006\u0004\n\"I!\u0011A*\u0002\u0002\u0003\u0007\u0011\u0011 \u0005\b\u0005cR\u0003\u0019AA\u0011\u0011\u001d\u0011)H\u000ba\u0001\u0005sBqAa\"+\u0001\u0004\u0011Y\t\u0006\u0006\u0003n\rM5QSBL\u00073CqA!\u001d,\u0001\u0004\t\t\u0003C\u0004\u0003v-\u0002\rA!\u001f\t\u000f\t\u001d5\u00061\u0001\u0003\f\"9!1U\u0016A\u0002\t\u001dFC\u0003B7\u0007;\u001byj!)\u0004$\"9!\u0011\u000f\u0017A\u0002\u0005\u0005\u0002b\u0002B;Y\u0001\u0007!\u0011\u0010\u0005\b\u0005\u000fc\u0003\u0019\u0001BF\u0011\u001d\u0011Y\f\fa\u0001\u0005\u007f#BB!\u001c\u0004(\u000e%61VBW\u0007_CqA!\u001d.\u0001\u0004\t\t\u0003C\u0004\u0003v5\u0002\rA!\u001f\t\u000f\t\u001dU\u00061\u0001\u0003\f\"9!1U\u0017A\u0002\t\u001d\u0006b\u0002B^[\u0001\u0007!q\u0018\u000b\u0005\u0007g\u001bY\fE\u0003`\u00053\u001a)\fE\u0007`\u0007o\u000b\tC!\u001f\u0003\f\n\u001d&qX\u0005\u0004\u0007s\u0003'A\u0002+va2,W\u0007C\u0005\u0003f9\n\t\u00111\u0001\u0003n\u0001")
public class Broker
implements Product,
scala.Serializable {
    private final int id;
    private final Seq<EndPoint> endPoints;
    private final Option<String> rack;
    private final Features<SupportedVersionRange> features;
    private final scala.collection.immutable.Map<String, String> tags;
    private final scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap;

    public static Option<Tuple5<Object, Seq<EndPoint>, Option<String>, Features<SupportedVersionRange>, scala.collection.immutable.Map<String, String>>> unapply(Broker broker) {
        return Broker$.MODULE$.unapply(broker);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, features, map);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, scala.collection.immutable.Map<String, String> map) {
        return Broker$.MODULE$.apply(n, seq, option, map);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option, Features<SupportedVersionRange> features) {
        return Broker$.MODULE$.apply(n, seq, option, features);
    }

    public static Broker apply(int n, Seq<EndPoint> seq, Option<String> option) {
        return Broker$.MODULE$.apply(n, seq, option);
    }

    public int id() {
        return this.id;
    }

    public Seq<EndPoint> endPoints() {
        return this.endPoints;
    }

    public Option<String> rack() {
        return this.rack;
    }

    public Features<SupportedVersionRange> features() {
        return this.features;
    }

    public scala.collection.immutable.Map<String, String> tags() {
        return this.tags;
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endPointsMap() {
        return this.endPointsMap;
    }

    public String toString() {
        return new StringBuilder(9).append(this.id()).append(" : ").append(this.endPointsMap().values().mkString("(", ",", ")")).append(" : ").append(this.rack().orNull(Predef$.MODULE$.$conforms())).append(" : ").append(this.features()).toString();
    }

    public Node node(ListenerName listenerName) {
        return (Node)this.getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found ").append("for broker ").append(this.id()).toString());
        });
    }

    public Option<Node> getNode(ListenerName listenerName) {
        return this.endPointsMap().get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)endpoint -> new ConfluentNode(this.id(), endpoint.host(), endpoint.port(), (String)this.rack().orNull(Predef$.MODULE$.$conforms()), (Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava()));
    }

    public BrokerEndPoint brokerEndPoint(ListenerName listenerName) {
        EndPoint endpoint = this.endPoint(listenerName);
        return new BrokerEndPoint(this.id(), endpoint.host(), endpoint.port());
    }

    public EndPoint endPoint(ListenerName listenerName) {
        return (EndPoint)this.endPointsMap().getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> {
            throw new BrokerEndPointNotAvailableException(new StringBuilder(51).append("End point with listener name ").append(listenerName.value()).append(" not found for broker ").append(this.id()).toString());
        });
    }

    public ConfluentAuthorizerServerInfo toServerInfo(String clusterId, KafkaConfig config, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
        ClusterResource clusterResource = new ClusterResource(clusterId);
        Endpoint interBrokerEndpoint = this.endPoint(config.interBrokerListenerName()).toJava();
        java.util.List brokerEndpoints = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.endPoints().toList().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), List$.MODULE$.canBuildFrom())).asJava();
        return new ServerInfo(clusterResource, this.id(), brokerEndpoints, interBrokerEndpoint, httpServerBinder, auditLogProvider, metrics);
    }

    public AuditLogProvider toServerInfo$default$4() {
        return NoOpAuditLogProvider.INSTANCE;
    }

    public Broker copy(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        return new Broker(id, endPoints, rack, features, tags);
    }

    public int copy$default$1() {
        return this.id();
    }

    public Seq<EndPoint> copy$default$2() {
        return this.endPoints();
    }

    public Option<String> copy$default$3() {
        return this.rack();
    }

    public Features<SupportedVersionRange> copy$default$4() {
        return this.features();
    }

    public scala.collection.immutable.Map<String, String> copy$default$5() {
        return this.tags();
    }

    public String productPrefix() {
        return "Broker";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        switch (x$1) {
            case 0: {
                return BoxesRunTime.boxToInteger((int)this.id());
            }
            case 1: {
                return this.endPoints();
            }
            case 2: {
                return this.rack();
            }
            case 3: {
                return this.features();
            }
            case 4: {
                return this.tags();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Broker;
    }

    public int hashCode() {
        return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.id()), (int)Statics.anyHash(this.endPoints())), (int)Statics.anyHash(this.rack())), (int)Statics.anyHash(this.features())), (int)Statics.anyHash(this.tags())), (int)5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        if (!(x$1 instanceof Broker)) return false;
        boolean bl = true;
        if (!bl) return false;
        Broker broker = (Broker)x$1;
        if (this.id() != broker.id()) return false;
        Seq<EndPoint> seq = this.endPoints();
        Seq<EndPoint> seq2 = broker.endPoints();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<String> option = this.rack();
        Option<String> option2 = broker.rack();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Features<SupportedVersionRange> features = this.features();
        Features<SupportedVersionRange> features2 = broker.features();
        if (features == null) {
            if (features2 != null) {
                return false;
            }
        } else if (!features.equals(features2)) return false;
        scala.collection.immutable.Map<String, String> map = this.tags();
        scala.collection.immutable.Map<String, String> map2 = broker.tags();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!broker.canEqual(this)) return false;
        return true;
    }

    public Broker(int id, Seq<EndPoint> endPoints, Option<String> rack, Features<SupportedVersionRange> features, scala.collection.immutable.Map<String, String> tags) {
        this.id = id;
        this.endPoints = endPoints;
        this.rack = rack;
        this.features = features;
        this.tags = tags;
        Product.$init$((Product)this);
        this.endPointsMap = ((TraversableOnce)endPoints.map((Function1 & Serializable & scala.Serializable)endPoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endPoint.listenerName()), endPoint), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (this.endPointsMap().size() != endPoints.size()) {
            throw new IllegalArgumentException(new StringBuilder(62).append("There is more than one end point with the same listener name: ").append(endPoints.mkString(",")).toString());
        }
    }

    public Broker(int id, String host, int port, ListenerName listenerName, SecurityProtocol protocol) {
        this(id, (Seq<EndPoint>)new .colon.colon((Object)new EndPoint(host, port, listenerName, protocol), (List)Nil$.MODULE$), (Option<String>)None$.MODULE$, (Features<SupportedVersionRange>)Features.emptySupportedFeatures(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Broker(BrokerEndPoint bep, ListenerName listenerName, SecurityProtocol protocol) {
        this(bep.id(), bep.host(), bep.port(), listenerName, protocol);
    }

    public static class ServerInfo
    implements ConfluentAuthorizerServerInfo,
    Product,
    scala.Serializable {
        private final ClusterResource clusterResource;
        private final int brokerId;
        private final java.util.List<Endpoint> endpoints;
        private final Endpoint interBrokerEndpoint;
        private final KafkaHttpServerBinder httpServerBinder;
        private final AuditLogProvider auditLogProvider;
        private final Metrics metrics;

        public ClusterResource clusterResource() {
            return this.clusterResource;
        }

        public int brokerId() {
            return this.brokerId;
        }

        public java.util.List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Endpoint interBrokerEndpoint() {
            return this.interBrokerEndpoint;
        }

        public KafkaHttpServerBinder httpServerBinder() {
            return this.httpServerBinder;
        }

        public AuditLogProvider auditLogProvider() {
            return this.auditLogProvider;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public ServerInfo copy(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
            return new ServerInfo(clusterResource, brokerId, endpoints, interBrokerEndpoint, httpServerBinder, auditLogProvider, metrics);
        }

        public ClusterResource copy$default$1() {
            return this.clusterResource();
        }

        public int copy$default$2() {
            return this.brokerId();
        }

        public java.util.List<Endpoint> copy$default$3() {
            return this.endpoints();
        }

        public Endpoint copy$default$4() {
            return this.interBrokerEndpoint();
        }

        public KafkaHttpServerBinder copy$default$5() {
            return this.httpServerBinder();
        }

        public AuditLogProvider copy$default$6() {
            return this.auditLogProvider();
        }

        public Metrics copy$default$7() {
            return this.metrics();
        }

        public String productPrefix() {
            return "ServerInfo";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.clusterResource();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokerId());
                }
                case 2: {
                    return this.endpoints();
                }
                case 3: {
                    return this.interBrokerEndpoint();
                }
                case 4: {
                    return this.httpServerBinder();
                }
                case 5: {
                    return this.auditLogProvider();
                }
                case 6: {
                    return this.metrics();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServerInfo;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.clusterResource())), (int)this.brokerId()), (int)Statics.anyHash((Object)this.endpoints())), (int)Statics.anyHash((Object)this.interBrokerEndpoint())), (int)Statics.anyHash((Object)this.httpServerBinder())), (int)Statics.anyHash((Object)this.auditLogProvider())), (int)Statics.anyHash((Object)this.metrics())), (int)7);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ServerInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            ServerInfo serverInfo = (ServerInfo)x$1;
            ClusterResource clusterResource = this.clusterResource();
            ClusterResource clusterResource2 = serverInfo.clusterResource();
            if (clusterResource == null) {
                if (clusterResource2 != null) {
                    return false;
                }
            } else if (!clusterResource.equals(clusterResource2)) return false;
            if (this.brokerId() != serverInfo.brokerId()) return false;
            Collection collection = this.endpoints();
            Collection collection2 = serverInfo.endpoints();
            if (collection == null) {
                if (collection2 != null) {
                    return false;
                }
            } else if (!((Object)collection).equals(collection2)) return false;
            Endpoint endpoint = this.interBrokerEndpoint();
            Endpoint endpoint2 = serverInfo.interBrokerEndpoint();
            if (endpoint == null) {
                if (endpoint2 != null) {
                    return false;
                }
            } else if (!endpoint.equals(endpoint2)) return false;
            KafkaHttpServerBinder kafkaHttpServerBinder = this.httpServerBinder();
            KafkaHttpServerBinder kafkaHttpServerBinder2 = serverInfo.httpServerBinder();
            if (kafkaHttpServerBinder == null) {
                if (kafkaHttpServerBinder2 != null) {
                    return false;
                }
            } else if (!kafkaHttpServerBinder.equals(kafkaHttpServerBinder2)) return false;
            AuditLogProvider auditLogProvider = this.auditLogProvider();
            AuditLogProvider auditLogProvider2 = serverInfo.auditLogProvider();
            if (auditLogProvider == null) {
                if (auditLogProvider2 != null) {
                    return false;
                }
            } else if (!auditLogProvider.equals(auditLogProvider2)) return false;
            Metrics metrics = this.metrics();
            Metrics metrics2 = serverInfo.metrics();
            if (metrics == null) {
                if (metrics2 != null) {
                    return false;
                }
            } else if (!metrics.equals(metrics2)) return false;
            if (!serverInfo.canEqual(this)) return false;
            return true;
        }

        public ServerInfo(ClusterResource clusterResource, int brokerId, java.util.List<Endpoint> endpoints, Endpoint interBrokerEndpoint, KafkaHttpServerBinder httpServerBinder, AuditLogProvider auditLogProvider, Metrics metrics) {
            this.clusterResource = clusterResource;
            this.brokerId = brokerId;
            this.endpoints = endpoints;
            this.interBrokerEndpoint = interBrokerEndpoint;
            this.httpServerBinder = httpServerBinder;
            this.auditLogProvider = auditLogProvider;
            this.metrics = metrics;
            Product.$init$((Product)this);
        }
    }
}

