/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.util.Optional;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class Observer$ {
    public static Observer$ MODULE$;

    static {
        new Observer$();
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> getReplicaAssignment(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement2, int numPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        void var9_9;
        void var8_8;
        Tuple2 tuple2 = (Tuple2)topicPlacement2.map((Function1 & Serializable & scala.Serializable)topicPlacement -> new Tuple2(MODULE$.partitionBrokersByConstraint(brokers, (Seq<TopicPlacement.ConstraintCount>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala())), MODULE$.partitionBrokersByConstraint(brokers, (Seq<TopicPlacement.ConstraintCount>)((Seq)CollectionConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicationFactor)), (Object)brokers), (List)Nil$.MODULE$), (Object)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq replicationAndSyncEligible = (Seq)tuple2._1();
        Seq replicationAndObserverEligible = (Seq)tuple2._2();
        void replicationAndSyncEligible2 = var8_8;
        void replicationAndObserverEligible2 = var9_9;
        this.validatePartitioning((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)((Seq)replicationAndSyncEligible2.$plus$plus((GenTraversableOnce)replicationAndObserverEligible2, Seq$.MODULE$.canBuildFrom())));
        return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndSyncEligible2, numPartitions, fixedStartIndex, startPartitionId), (Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndObserverEligible2, numPartitions, fixedStartIndex, startPartitionId));
    }

    public int getReplicaAssignment$default$5() {
        return -1;
    }

    public int getReplicaAssignment$default$6() {
        return -1;
    }

    private scala.collection.mutable.Map<Object, Seq<Object>> assignReplicasToPartitions(Seq<Tuple2<Object, Seq<BrokerMetadata>>> replicationAndBrokers, int partitions, int fixedStartIndex, int startPartitionId) {
        return (scala.collection.mutable.Map)((TraversableOnce)replicationAndBrokers.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int replication = x0$1._1$mcI$sp();
            Seq brokerList = (Seq)x0$1._2();
            Map<Object, Seq<Object>> map = AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerList, partitions, replication, fixedStartIndex, startPartitionId);
            return map;
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Map$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(mergedAssignment, currentAssignment) -> MODULE$.mergeAssignmentMap((scala.collection.mutable.Map<Object, Seq<Object>>)mergedAssignment, (Map<Object, Seq<Object>>)currentAssignment));
    }

    private Map<Object, ReplicaAssignment> partitionReplicaAssignment(Map<Object, Seq<Object>> syncReplicas, Map<Object, Seq<Object>> observerReplicas) {
        if (observerReplicas.nonEmpty()) {
            Set set = syncReplicas.keySet();
            Set set2 = observerReplicas.keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                int syncSize = syncReplicas.keySet().size();
                int observerSize = observerReplicas.keySet().size();
                throw new InvalidConfigurationException(new StringBuilder(115).append("Must assign observers to all or none of the partitions. ").append(syncSize).append(" partitions with sync replicas. ").append(observerSize).append(" partitions with observers.").toString());
            }
        }
        return (Map)syncReplicas.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Seq observerAssignment = (Seq)observerReplicas.getOrElse((Object)BoxesRunTime.boxToInteger((int)partition), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)((Seq)replicas.$plus$plus((GenTraversableOnce)observerAssignment, Seq$.MODULE$.canBuildFrom())), (Seq<Object>)observerAssignment));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionBrokersByConstraint(Seq<BrokerMetadata> brokers, Seq<TopicPlacement.ConstraintCount> constraints) {
        return (Seq)constraints.map((Function1 & Serializable & scala.Serializable)constraint -> {
            Seq matchedBrokers = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, constraint)));
            if (matchedBrokers.size() < constraint.count()) {
                throw new InvalidConfigurationException(new StringBuilder(75).append("Number of broker found (").append(matchedBrokers.size()).append(") matching ").append("constraint ").append(constraint).append(" is less than required count ").append(constraint.count()).toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)constraint.count()), (Object)matchedBrokers);
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public void validatePartitioning(Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionedBrokers) {
        void var4_4;
        void var3_3;
        Tuple2 tuple2 = (Tuple2)partitionedBrokers.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable & scala.Serializable)(acc, current) -> {
            void var3_3;
            void var2_2;
            void var4_4;
            if (acc == null) {
                throw new MatchError(null);
            }
            int count = acc._1$mcI$sp();
            scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)acc._2();
            if (current == null) {
                throw new MatchError(null);
            }
            Seq brokers = (Seq)current._2();
            if (var4_4.toSet().size() != var4_4.size()) {
                throw new InvalidConfigurationException(new StringBuilder(58).append("Duplicate eligible brokers ").append(var4_4).append(" match a placement constraints.").toString());
            }
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(var2_2 + var4_4.size())), (Object)var3_3.$plus$plus((GenTraversableOnce)var4_4));
        });
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int count = tuple2._1$mcI$sp();
        scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
        if (var3_3 != var4_4.size()) {
            throw new InvalidConfigurationException(new StringBuilder(58).append("Some brokers satisfy more than one placement constraints: ").append(partitionedBrokers).toString());
        }
    }

    public scala.collection.mutable.Map<Object, Seq<Object>> mergeAssignmentMap(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
        return mergedAssignment.$plus$plus((GenTraversableOnce)currentAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicaIds = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), MODULE$.mergeReplicaLists((Seq<Object>)((Seq)mergedAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)), (Seq<Object>)replicaIds));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
    }

    public Seq<Object> mergeReplicaLists(Seq<Object> brokerList1, Seq<Object> brokerList2) {
        Seq commonReplicas = (Seq)brokerList1.intersect(brokerList2);
        if (commonReplicas.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(64).append("Replica with ids (").append(commonReplicas).append(") satisfy more than one placement constraints.").toString());
        }
        return (Seq)brokerList1.$plus$plus(brokerList2, Seq$.MODULE$.canBuildFrom());
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, TopicPlacement.ConstraintCount constraint) {
        scala.collection.immutable.Map properties = Option$.MODULE$.option2Iterable(broker.rack().map((Function1 & Serializable & scala.Serializable)rack -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack"), rack))).toMap(Predef$.MODULE$.$conforms());
        return constraint.matches((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)properties).asJava());
    }

    public Option<ApiError> validateAssignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment.Assignment assignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return this.validateAssignmentStructure(assignment).orElse((Function0 & Serializable & scala.Serializable)() -> topicPlacement.flatMap((Function1 & Serializable & scala.Serializable)placementConstraint -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.syncReplicas().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateAssignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.observers().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateAssignment$5(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava()))).map((Function1 & Serializable & scala.Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message))));
    }

    public Option<ApiError> validateAssignmentStructure(ReplicaAssignment.Assignment assignment) {
        Seq<Object> replicas = assignment.replicas();
        scala.collection.immutable.Set replicaSet = replicas.toSet();
        if (replicas.isEmpty() || replicas.size() != replicaSet.size()) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(57).append("Duplicate replicas not allowed in partition assignment: ").append(replicas.mkString(", ")).append(".").toString()));
        }
        if (replicas.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 < 0)) {
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(44).append("Invalid replica id in partition assignment: ").append(replicas.mkString(", ")).toString()));
        }
        if (!assignment.replicas().endsWith(assignment.observers())) {
            String observerMsg = assignment.observers().mkString(", ");
            return new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder(85).append("Assignment contains observers (").append(observerMsg).append(") and the replicas' (").append(replicas.mkString(", ")).append(") ").append("suffix doesn't match observers.").toString()));
        }
        return None$.MODULE$;
    }

    public Option<ApiError> validateReassignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment reassignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return reassignment.targetAssignment().flatMap((Function1 & Serializable & scala.Serializable)assignment -> topicPlacement.flatMap((Function1 & Serializable & scala.Serializable)placementConstraint -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.syncReplicas().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateReassignment$3(liveBrokerAttributes, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment.observers().map((Function1 & Serializable & scala.Serializable)id -> Observer$.$anonfun$validateReassignment$5(liveBrokerAttributes, reassignment, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).asJava()))).map((Function1 & Serializable & scala.Serializable)message -> new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message))));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$3(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateAssignment$5(Map liveBrokerAttributes$1, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$3(Map liveBrokerAttributes$2, int id) {
        return TopicPlacement.Replica.of(id, Optional.of(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)liveBrokerAttributes$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0 & Serializable & scala.Serializable)() -> scala.collection.Map$.MODULE$.empty())).asJava()));
    }

    public static final /* synthetic */ TopicPlacement.Replica $anonfun$validateReassignment$5(Map liveBrokerAttributes$2, ReplicaAssignment reassignment$1, int id) {
        Option attributes = liveBrokerAttributes$2.get((Object)BoxesRunTime.boxToInteger((int)id));
        Option attributes2 = reassignment$1.originAssignment().replicas().contains((Object)BoxesRunTime.boxToInteger((int)id)) ? attributes : attributes.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)scala.collection.Map$.MODULE$.empty()));
        return TopicPlacement.Replica.of(id, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(attributes2.map((Function1 & Serializable & scala.Serializable)x$5 -> (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(x$5).asJava()))));
    }

    private Observer$() {
        MODULE$ = this;
    }
}

