/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kafka.api.PartitionLinkState;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ReplicaManager;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class Partition$
implements KafkaMetricsGroup {
    public static Partition$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Partition$();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<Executor> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public Partition apply(TopicPartition topicPartition, Time time, ReplicaManager replicaManager) {
        IsrChangeListener isrChangeListener = new IsrChangeListener(replicaManager){
            private final ReplicaManager replicaManager$1;

            public void markExpand() {
                this.replicaManager$1.isrExpandRate().mark();
            }

            public void markShrink() {
                this.replicaManager$1.isrShrinkRate().mark();
            }

            public void markFailed() {
                this.replicaManager$1.failedIsrUpdatesRate().mark();
            }
            {
                this.replicaManager$1 = replicaManager$1;
            }
        };
        DelayedOperations delayedOperations = new DelayedOperations(topicPartition, replicaManager.delayedProducePurgatory(), replicaManager.delayedFetchPurgatory(), replicaManager.delayedDeleteRecordsPurgatory());
        return new Partition(topicPartition, Predef$.MODULE$.Long2long(replicaManager.config().replicaLagTimeMaxMs()), replicaManager.config().interBrokerProtocolVersion(), replicaManager.config().brokerId(), time, isrChangeListener, delayedOperations, replicaManager.metadataCache(), replicaManager.logManager(), replicaManager.tierReplicaComponents().replicaManagerOpt(), replicaManager.tierReplicaComponents().stateFetcherOpt(), (Option<Executor>)new Some((Object)replicaManager.executor()), replicaManager.alterIsrManager());
    }

    public void removeMetrics(TopicPartition topicPartition) {
        Map tags = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topicPartition.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)Integer.toString(topicPartition.partition()))}));
        this.removeMetric("UnderReplicated", (Map<String, String>)tags);
        this.removeMetric("UnderMinIsr", (Map<String, String>)tags);
        this.removeMetric("InSyncReplicasCount", (Map<String, String>)tags);
        this.removeMetric("CaughtUpReplicasCount", (Map<String, String>)tags);
        this.removeMetric("ReplicasCount", (Map<String, String>)tags);
        this.removeMetric("LastStableOffsetLag", (Map<String, String>)tags);
        this.removeMetric("AtMinIsr", (Map<String, String>)tags);
        this.removeMetric("IsNotCaughtUp", (Map<String, String>)tags);
        this.removeMetric("ObserverReplicasCount", (Map<String, String>)tags);
        this.removeMetric("ObserversInIsrCount", (Map<String, String>)tags);
        this.removeMetric("MirrorReplicasCount", (Map<String, String>)tags);
        this.removeMetric("UnderReplicatedMirror", (Map<String, String>)tags);
        this.removeMetric("UnderMinIsrMirror", (Map<String, String>)tags);
        this.removeMetric("AtMinIsrMirror", (Map<String, String>)tags);
        this.removeMetric("BlockedOnMirrorSource", (Map<String, String>)tags);
    }

    public Option<ClusterLinkState> clusterLinkState(LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState) {
        return Option$.MODULE$.apply((Object)partitionState.clusterLinkId()).map((Function1 & Serializable & scala.Serializable)x$1 -> UUID.fromString(x$1)).flatMap((Function1 & Serializable & scala.Serializable)linkId -> Option$.MODULE$.apply((Object)partitionState.clusterLinkTopicState()).map((Function1 & Serializable & scala.Serializable)state -> {
            TopicLinkState topicLinkState;
            try {
                topicLinkState = TopicLinkState$.MODULE$.fromString((String)state);
            }
            catch (IllegalArgumentException e) {
                Partition$ partition$ = MODULE$;
                if (partition$ == null) {
                    throw null;
                }
                Partition$ error_this = partition$;
                if (error_this.logger().underlying().isErrorEnabled()) {
                    error_this.logger().underlying().error(error_this.msgWithLogIdent(Partition$.$anonfun$clusterLinkState$4(state)), (Throwable)e);
                }
                topicLinkState = TopicLinkFailedMirror$.MODULE$;
            }
            TopicLinkState topicState = topicLinkState;
            TopicLinkState topicLinkState2 = topicState;
            TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
            PartitionLinkState linkedPartitionState = new PartitionLinkState(partitionState.linkedLeaderEpoch(), !(topicLinkState2 != null ? !topicLinkState2.equals(topicLinkFailedMirror$) : topicLinkFailedMirror$ != null));
            return new ClusterLinkState((UUID)linkId, topicState, linkedPartitionState);
        }));
    }

    public boolean isActiveLinkDestination(LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState) {
        return this.clusterLinkState(partitionState).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isActiveLinkDestination()));
    }

    public static final /* synthetic */ String $anonfun$clusterLinkState$4(String state$1) {
        return new StringBuilder(46).append("Unknown cluster link state ").append(state$1).append(", disable mirroring").toString();
    }

    private Partition$() {
        MODULE$ = this;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
    }
}

