/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\rerA\u0002#F\u0011\u0003)5J\u0002\u0004N\u000b\"\u0005QI\u0014\u0005\u0006+\u0006!\ta\u0016\u0005\u00061\u0006!\t!\u0017\u0005\u00071\u0006!\tAa?\t\ra\u000bA\u0011AB\u0005\u0011\u001d\u0019Y\"\u0001C\u0001\u0007;A\u0011b!\t\u0002#\u0003%\taa\t\u0007\u000b5+\u0005!R.\t\u0011\tD!Q1A\u0005\u0002\rD\u0001b\u001c\u0005\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\ta\"\u0011\t\u0019!C\u0001c\"AQ\u000f\u0003BA\u0002\u0013\u0005a\u000f\u0003\u0005}\u0011\t\u0005\t\u0015)\u0003s\u0011!i\bB!a\u0001\n\u0003\t\b\u0002\u0003@\t\u0005\u0003\u0007I\u0011A@\t\u0013\u0005\r\u0001B!A!B\u0013\u0011\bBCA\u0003\u0011\t\u0005\r\u0011\"\u0001\u0002\b!Q\u0011q\u0002\u0005\u0003\u0002\u0004%\t!!\u0005\t\u0015\u0005U\u0001B!A!B\u0013\tI\u0001\u0003\u0006\u0002\u0018!\u0011\t\u0019!C\u0001\u0003\u000fA!\"!\u0007\t\u0005\u0003\u0007I\u0011AA\u000e\u0011)\ty\u0002\u0003B\u0001B\u0003&\u0011\u0011\u0002\u0005\u000b\u0003CA!\u00111A\u0005\u0002\u0005\r\u0002BCA\u0016\u0011\t\u0005\r\u0011\"\u0001\u0002.!Q\u0011\u0011\u0007\u0005\u0003\u0002\u0003\u0006K!!\n\t\u0015\u0005M\u0002B!a\u0001\n\u0003\t)\u0004\u0003\u0006\u0002>!\u0011\t\u0019!C\u0001\u0003\u007fA!\"a\u0011\t\u0005\u0003\u0005\u000b\u0015BA\u001c\u0011)\ti\u0005\u0003BC\u0002\u0013\u0005\u0011q\n\u0005\u000b\u0003oB!\u0011!Q\u0001\n\u0005E\u0003\"CA=\u0011\t\u0005\r\u0011\"\u0001r\u0011)\tY\b\u0003BA\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003\u0003C!\u0011!Q!\nID\u0011\"!\"\t\u0005\u0003\u0007I\u0011A9\t\u0015\u0005\u001d\u0005B!a\u0001\n\u0003\tI\tC\u0005\u0002\u000e\"\u0011\t\u0011)Q\u0005e\"1Q\u000b\u0003C\u0001\u0003#C\u0011\"a*\t\u0001\u0004%\t!!+\t\u0013\u0005E\u0006\u00021A\u0005\u0002\u0005M\u0006\u0002CA\\\u0011\u0001\u0006K!a+\t\u0013\u0005m\u0006\u00021A\u0005\u0002\u0005u\u0006\"CAc\u0011\u0001\u0007I\u0011AAd\u0011!\tY\r\u0003Q!\n\u0005}\u0006BCAg\u0011\t\u0007I\u0011A#\u0002P\"A\u0011\u0011\u001e\u0005!\u0002\u0013\t\t\u000eC\u0004\u0002l\"!\t!!<\t\u000f\tE\u0001\u0002\"\u0001\u0003\u0014!9!q\u0004\u0005\u0005\u0002\t\u0005\u0002b\u0002B\u0014\u0011\u0011\u0005!\u0011\u0006\u0005\b\u0005cAA\u0011\u0001B\u0015\u0011\u001d\u0011\u0019\u0004\u0003C\u0001\u0005kAqAa\u0019\t\t\u0003\u0011)\u0007C\u0004\u0003t!!\tA!\u001e\t\u000f\t\u001d\u0005\u0002\"\u0001\u0003\n\"9!\u0011\u0013\u0005\u0005\u0002\tM\u0005b\u0002BL\u0011\u0011\u0005!\u0011\u0006\u0005\b\u00053CA\u0011AA_\u0011\u001d\u0011Y\n\u0003C\u0005\u0003{CqA!(\t\t\u0013\u0011y\nC\u0004\u0003:\"!\tAa/\t\u000f\t\u0005\u0007\u0002\"\u0003\u0003D\"9!q\u0019\u0005\u0005\n\t%\u0007b\u0002Bg\u0011\u0011%!q\u001a\u0005\b\u0005+DA\u0011AA_\u0011\u001d\u00119\u000e\u0003C!\u00053DqAa7\t\t\u0003\u0012i\u000eC\u0004\u0003d\"!\tE!:\u0002'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u000b\u0005\u0019;\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T!\u0001S%\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u0015\u0006)1.\u00194lCB\u0011A*A\u0007\u0002\u000b\n\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCN\u0011\u0011a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0002%\u0006)1oY1mC&\u0011A+\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aS\u0001\u0006CB\u0004H.\u001f\u000b\f5\n=(\u0011\u001fBz\u0005k\u00149\u0010\u0005\u0002M\u0011M\u0019\u0001b\u0014/\u0011\u0005u\u0003W\"\u00010\u000b\u0005}K\u0015!B;uS2\u001c\u0018BA1_\u0005\u001daunZ4j]\u001e\fq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u000b\u0002IB\u0011Q\r\u001c\b\u0003M*\u0004\"aZ)\u000e\u0003!T!!\u001b,\u0002\rq\u0012xn\u001c;?\u0013\tY\u0017+\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6R\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012A\u001d\t\u0003!NL!\u0001^)\u0003\t1{gnZ\u0001\u000faJ|G-^2fe&#w\fJ3r)\t9(\u0010\u0005\u0002Qq&\u0011\u00110\u0015\u0002\u0005+:LG\u000fC\u0004|\u0019\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0013'A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013A\u00047bgR\u0004&o\u001c3vG\u0016\u0014\u0018\nZ\u0001\u0013Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]%e?\u0012*\u0017\u000fF\u0002x\u0003\u0003Aqa_\b\u0002\u0002\u0003\u0007!/A\bmCN$\bK]8ek\u000e,'/\u00133!\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQV\u0011\u0011\u0011\u0002\t\u0004!\u0006-\u0011bAA\u0007#\n)1\u000b[8si\u0006\t\u0002O]8ek\u000e,'/\u00129pG\"|F%Z9\u0015\u0007]\f\u0019\u0002\u0003\u0005|%\u0005\u0005\t\u0019AA\u0005\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002\n\u0011\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0003Ua\u0017m\u001d;Qe>$WoY3s\u000bB|7\r[0%KF$2a^A\u000f\u0011!YX#!AA\u0002\u0005%\u0011A\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0002\nA\u0002\u001e=o)&lWm\\;u\u001bN,\"!!\n\u0011\u0007A\u000b9#C\u0002\u0002*E\u00131!\u00138u\u0003A!\bP\u001c+j[\u0016|W\u000f^'t?\u0012*\u0017\u000fF\u0002x\u0003_A\u0001b\u001f\r\u0002\u0002\u0003\u0007\u0011QE\u0001\u000eibtG+[7f_V$Xj\u001d\u0011\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005]\u0002c\u0001'\u0002:%\u0019\u00111H#\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0017!C:uCR,w\fJ3r)\r9\u0018\u0011\t\u0005\twn\t\t\u00111\u0001\u00028\u000511\u000f^1uK\u0002B3\u0001HA$!\r\u0001\u0016\u0011J\u0005\u0004\u0003\u0017\n&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\"!!\u0015\u0011\r\u0005M\u0013QLA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u00037\n\u0016AC2pY2,7\r^5p]&!\u0011qLA+\u0005\r\u0019V\r\u001e\t\u0005\u0003G\n\u0019(\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0019\u0019w.\\7p]*\u0019!*a\u001b\u000b\t\u00055\u0014qN\u0001\u0007CB\f7\r[3\u000b\u0005\u0005E\u0014aA8sO&!\u0011QOA3\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002#QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007/A\u000buq:\u001cF/\u0019:u)&lWm\u001d;b[B|F%Z9\u0015\u0007]\fy\bC\u0004|A\u0005\u0005\t\u0019\u0001:\u0002%QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000f\t\u0015\u0004C\u0005\u001d\u0013A\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9\u00025QDh\u000eT1tiV\u0003H-\u0019;f)&lWm\u001d;b[B|F%Z9\u0015\u0007]\fY\tC\u0004|G\u0005\u0005\t\u0019\u0001:\u0002/QDh\u000eT1tiV\u0003H-\u0019;f)&lWm\u001d;b[B\u0004\u0003f\u0001\u0013\u0002HQ)\",a%\u0002\u0016\u0006]\u0015\u0011TAN\u0003;\u000by*!)\u0002$\u0006\u0015\u0006\"\u00022&\u0001\u0004!\u0007\"\u00029&\u0001\u0004\u0011\b\"B?&\u0001\u0004\u0011\bbBA\u0003K\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003/)\u0003\u0019AA\u0005\u0011\u001d\t\t#\na\u0001\u0003KAq!a\r&\u0001\u0004\t9\u0004C\u0004\u0002N\u0015\u0002\r!!\u0015\t\u0011\u0005eT\u0005%AA\u0002IDa!!\"&\u0001\u0004\u0011\u0018\u0001\u00049f]\u0012LgnZ*uCR,WCAAV!\u0015\u0001\u0016QVA\u001c\u0013\r\ty+\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0002!A,g\u000eZ5oON#\u0018\r^3`I\u0015\fHcA<\u00026\"A1pJA\u0001\u0002\u0004\tY+A\u0007qK:$\u0017N\\4Ti\u0006$X\r\t\u0015\u0004Q\u0005\u001d\u0013a\u00055bg\u001a\u000b\u0017\u000e\\3e\u000bB|7\r\u001b$f]\u000e,WCAA`!\r\u0001\u0016\u0011Y\u0005\u0004\u0003\u0007\f&a\u0002\"p_2,\u0017M\\\u0001\u0018Q\u0006\u001ch)Y5mK\u0012,\u0005o\\2i\r\u0016t7-Z0%KF$2a^Ae\u0011!Y(&!AA\u0002\u0005}\u0016\u0001\u00065bg\u001a\u000b\u0017\u000e\\3e\u000bB|7\r\u001b$f]\u000e,\u0007%\u0001\u0003m_\u000e\\WCAAi!\u0011\t\u0019.!:\u000e\u0005\u0005U'\u0002BAl\u00033\fQ\u0001\\8dWNTA!a7\u0002^\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005}\u0017\u0011]\u0001\u0005kRLGN\u0003\u0002\u0002d\u0006!!.\u0019<b\u0013\u0011\t9/!6\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003\u0019Ig\u000eT8dWV!\u0011q^A{)\u0011\t\tPa\u0002\u0011\t\u0005M\u0018Q\u001f\u0007\u0001\t\u001d\t9P\fb\u0001\u0003s\u0014\u0011\u0001V\t\u0005\u0003w\u0014\t\u0001E\u0002Q\u0003{L1!a@R\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001\u0015B\u0002\u0013\r\u0011)!\u0015\u0002\u0004\u0003:L\b\u0002\u0003B\u0005]\u0011\u0005\rAa\u0003\u0002\u0007\u0019,h\u000eE\u0003Q\u0005\u001b\t\t0C\u0002\u0003\u0010E\u0013\u0001\u0002\u00102z]\u0006lWMP\u0001\u000eC\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u0007]\u0014)\u0002C\u0004\u0003\u0018=\u0002\rA!\u0007\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0003\u001c\tu\u0011\u0011M\u0007\u0003\u00033JA!a\u0018\u0002Z\u0005y!/Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000eF\u0002x\u0005GAqA!\n1\u0001\u0004\t\t'\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002!A\u0014X\r]1sK:{GK]1og&$HC\u0001B\u0016!\ra%QF\u0005\u0004\u0005_)%A\u0005+y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\f\u0011\u0004\u001d:fa\u0006\u0014XMR3oG\u0016\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0006i\u0002O]3qCJ,\u0017J\\2sK6,g\u000e\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0006\u0005\u00038\tU#\u0011\fB0!!\u0011IDa\u0011\u0003J\t-b\u0002\u0002B\u001e\u0005\u007fq1a\u001aB\u001f\u0013\u0005\u0011\u0016b\u0001B!#\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B#\u0005\u000f\u0012a!R5uQ\u0016\u0014(b\u0001B!#B!!1\nB)\u001b\t\u0011iE\u0003\u0003\u0003P\u0005\u0015\u0014\u0001\u00039s_R|7m\u001c7\n\t\tM#Q\n\u0002\u0007\u000bJ\u0014xN]:\t\u000f\t]3\u00071\u0001\u0002&\u0005ya.Z<Uq:$\u0016.\\3pkRl5\u000fC\u0004\u0003\\M\u0002\rA!\u0018\u0002+\u0015D\b/Z2uK\u0012\u0004&o\u001c3vG\u0016\u0014X\t]8dQB)\u0001+!,\u0002\n!1!\u0011M\u001aA\u0002I\fq\"\u001e9eCR,G+[7fgR\fW\u000e]\u0001\u001aaJ,\u0007/\u0019:f!J|G-^2fe&#'k\u001c;bi&|g\u000e\u0006\u0006\u0003,\t\u001d$1\u000eB7\u0005_BaA!\u001b5\u0001\u0004\u0011\u0018!\u00048foB\u0013x\u000eZ;dKJLE\rC\u0004\u0003XQ\u0002\r!!\n\t\r\t\u0005D\u00071\u0001s\u0011\u001d\u0011\t\b\u000ea\u0001\u0003\u007f\u000bqB]3d_J$G*Y:u\u000bB|7\r[\u0001\u0015aJ,\u0007/\u0019:f\u0003\u0012$\u0007+\u0019:uSRLwN\\:\u0015\r\t-\"q\u000fBC\u0011\u001d\u0011I(\u000ea\u0001\u0005w\nA#\u00193eK\u0012$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B?\u0005\u0007\u000b\t'\u0004\u0002\u0003\u0000)!!\u0011QA-\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002`\t}\u0004B\u0002B1k\u0001\u0007!/\u0001\u000bqe\u0016\u0004\u0018M]3BE>\u0014Ho\u0014:D_6l\u0017\u000e\u001e\u000b\u0007\u0005W\u0011YIa$\t\u000f\t5e\u00071\u0001\u00028\u0005Aa.Z<Ti\u0006$X\r\u0003\u0004\u0003bY\u0002\rA]\u0001\u0010aJ,\u0007/\u0019:f\u0007>l\u0007\u000f\\3uKR!!1\u0006BK\u0011\u0019\u0011\tg\u000ea\u0001e\u0006Y\u0001O]3qCJ,G)Z1e\u0003aI7\u000f\u0015:pIV\u001cWM]#q_\u000eDW\t\u001f5bkN$X\rZ\u0001\u0016Q\u0006\u001c\b+\u001a8eS:<GK]1og\u0006\u001cG/[8o\u0003M\u0001(/\u001a9be\u0016$&/\u00198tSRLwN\u001c+p)I\u0011YC!)\u0003$\n\u0015&\u0011\u0016BW\u0005_\u0013\u0019La.\t\u000f\t55\b1\u0001\u00028!1!\u0011N\u001eA\u0002IDqAa*<\u0001\u0004\tI!\u0001\u0005oK^,\u0005o\\2i\u0011\u001d\u0011Yk\u000fa\u0001\u0003\u0013\tAB\\3x\u0019\u0006\u001cH/\u00129pG\"DqAa\u0016<\u0001\u0004\t)\u0003C\u0004\u00032n\u0002\rAa\u001f\u0002%9,w\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0005k[\u0004\u0019\u0001:\u0002)9,w\u000f\u0016=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u0019\u0011\tg\u000fa\u0001e\u0006!2m\\7qY\u0016$X\r\u0016:b]NLG/[8o)>$2a\u001eB_\u0011\u001d\u0011y\f\u0010a\u0001\u0005W\tq\u0002\u001e:b]NLG/T3uC\u0012\fG/Y\u0001\u0013m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0006\u0003\u0002@\n\u0015\u0007b\u0002B`{\u0001\u0007!1F\u0001\u0017m\u0006d\u0017\u000e\u001a)s_\u0012,8-\u001a:Fa>\u001c\u0007NQ;naR!\u0011q\u0018Bf\u0011\u001d\u0011yL\u0010a\u0001\u0005W\t1\u0004\u001e5s_^\u001cF/\u0019;f)J\fgn]5uS>tg)Y5mkJ,GcA<\u0003R\"9!1[ A\u0002\t-\u0012A\u0005;y]R\u0013\u0018M\\:ji6+G/\u00193bi\u0006\f1\u0004]3oI&tw\r\u0016:b]NLG/[8o\u0013:\u0004&o\\4sKN\u001c\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0011\fa!Z9vC2\u001cH\u0003BA`\u0005?DqA!9C\u0001\u0004\u0011\t!\u0001\u0003uQ\u0006$\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0015\u0002f\u0001\u0005\u0003jB\u0019QLa;\n\u0007\t5hLA\u0007o_:$\bN]3bIN\fg-\u001a\u0005\u0006E\u000e\u0001\r\u0001\u001a\u0005\u0006a\u000e\u0001\rA\u001d\u0005\b\u0003\u000b\u0019\u0001\u0019AA\u0005\u0011\u001d\t\tc\u0001a\u0001\u0003KAaA!?\u0004\u0001\u0004\u0011\u0018!\u0003;j[\u0016\u001cH/Y7q)5Q&Q B\u0000\u0007\u0003\u0019\u0019a!\u0002\u0004\b!)!\r\u0002a\u0001I\")\u0001\u000f\u0002a\u0001e\"9\u0011Q\u0001\u0003A\u0002\u0005%\u0001bBA\u0011\t\u0001\u0007\u0011Q\u0005\u0005\b\u0003g!\u0001\u0019AA\u001c\u0011\u0019\u0011I\u0010\u0002a\u0001eR\t\"la\u0003\u0004\u000e\r=1\u0011CB\n\u0007+\u00199b!\u0007\t\u000b\t,\u0001\u0019\u00013\t\u000bA,\u0001\u0019\u0001:\t\u000bu,\u0001\u0019\u0001:\t\u000f\u0005\u0015Q\u00011\u0001\u0002\n!9\u0011qC\u0003A\u0002\u0005%\u0001bBA\u0011\u000b\u0001\u0007\u0011Q\u0005\u0005\b\u0003g)\u0001\u0019AA\u001c\u0011\u0019\u0011I0\u0002a\u0001e\u0006\u0001\u0012n]#q_\u000eDW\t\u001f5bkN$X\r\u001a\u000b\u0005\u0003\u007f\u001by\u0002C\u0004\u0002\u0006\u0019\u0001\r!!\u0003\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0019)CK\u0002s\u0007OY#a!\u000b\u0011\t\r-2QG\u0007\u0003\u0007[QAaa\f\u00042\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007g\t\u0016AC1o]>$\u0018\r^5p]&!1qGB\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long lastProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private volatile TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private volatile Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$9() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
    }

    public static boolean isEpochExhausted(short s) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(s);
    }

    public static TransactionMetadata apply(String string, long l, long l2, short s, short s2, int n, TransactionState transactionState, long l3) {
        return TransactionMetadata$.MODULE$.apply(string, l, l2, s, s2, n, transactionState, l3);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long lastProducerId() {
        return this.lastProducerId;
    }

    public void lastProducerId_$eq(long x$1) {
        this.lastProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T inLock(Function0<T> fun) {
        Object object;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringBuilder(154).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.lastProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Left left;
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            Right right2;
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Expected producer epoch ").append(expectedEpoch).append(" does not match current ").append("producer epoch ").append(this.producerEpoch()).append(" or previous producer epoch ").append(this.lastProducerEpoch()).toString());
                right2 = package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
            }
            right = right2;
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        if (right instanceof Right && (tuple2 = (Tuple2)right.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            left = package$.MODULE$.Right().apply((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp));
        } else if (right instanceof Left) {
            Errors err = (Errors)((Left)right).value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)right);
        }
        return left;
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, short newLastEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder(78).append("Preparing transaction state transition to ").append(newState).append(" ").append("while it already has pending state ").append(this.pendingState().get()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (newState.validPreviousStates().contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, this.producerId(), newEpoch, newLastEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder(125).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append(this).append("'s transition to ").append(transitMetadata).append(" failed since pendingState is not defined: this should not happen").toString());
            throw new IllegalStateException(new StringBuilder(95).append("TransactionalId ").append(this.transactionalId()).append(" ").append("completing transaction state transition while it does not have a pending state").toString());
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
                this.lastProducerId_$eq(transitMetadata.lastProducerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new StringBuilder(250).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(71).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder(167).append("TransactionMetadata(").append("transactionalId=").append(this.transactionalId()).append(", ").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("txnTimeoutMs=").append(this.txnTimeoutMs()).append(", ").append("state=").append(this.state()).append(", ").append("pendingState=").append(this.pendingState()).append(", ").append("topicPartitions=").append(this.topicPartitions()).append(", ").append("txnStartTimestamp=").append(this.txnStartTimestamp()).append(", ").append("txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.lastProducerEpoch() != transactionMetadata.lastProducerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public TransactionMetadata(String transactionalId, long producerId, long lastProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.lastProducerId = lastProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

