/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.durability.Utils;
import kafka.log.AbstractLog;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.state.SegmentState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public Option<Tuple4<Object, Object, Object, Set<Object>>> getLiveOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        None$ none$;
        Option<AbstractLog> log = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (log instanceof Some) {
            None$ none$2;
            AbstractLog l = (AbstractLog)((Some)log).value();
            Option<Set<Object>> option = this.getIsrIfLeaderPartition(replicaManager, topicPartition);
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                none$2 = new Some((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)l.highWatermark()), (Object)BoxesRunTime.boxToLong((long)l.logStartOffset()), l.latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1), (Object)isr));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (None$.MODULE$.equals(log)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(log);
        }
        return none$;
    }

    public Option<Set<Object>> getIsrIfLeaderPartition(ReplicaManager replicaManager, TopicPartition topicPartition) {
        None$ none$;
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Partition partition = ((HostedPartition.Online)hostedPartition).partition();
            Object object = partition.leaderLogIfLocal() instanceof Some ? Option$.MODULE$.apply(partition.inSyncReplicaIds()) : None$.MODULE$;
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int getLocalReplicaEpochIfLeader(ReplicaManager replicaManager, TopicPartition topicPartition) {
        int n;
        HostedPartition hostedPartition = replicaManager.getPartition(topicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            Option<AbstractLog> option = ((HostedPartition.Online)hostedPartition).partition().leaderLogIfLocal();
            int n2 = option instanceof Some ? BoxesRunTime.unboxToInt((Object)((AbstractLog)((Some)option).value()).latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)) : -1;
            n = n2;
        } else {
            n = -1;
        }
        return n;
    }

    public Option<Object> getLogEndOffset(ReplicaManager replicaManager, TopicPartition topicPartition) {
        return replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset()));
    }

    public Option<Object> getLatestEpoch(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Option<Object> option2 = option instanceof Some ? ((AbstractLog)((Some)option).value()).latestEpoch() : None$.MODULE$;
        return option2;
    }

    public boolean isTieredLog(AbstractLog log) {
        return Predef$.MODULE$.Boolean2boolean(log.config().tierEnable()) && !log.config().compact() && !Topic.isInternal((String)log.topicPartition().topic());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Option<Utils.MaxTimestampWithSize> getPreviousTierSegmentInfo(ReplicaManager replicaManager, TopicPartition topicPartition, long offset) {
        void var5_11;
        boolean bl = false;
        Some some = null;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            AbstractLog log = (AbstractLog)some.value();
            if (!this.isTieredLog(log)) {
                None$ none$ = None$.MODULE$;
                return var5_11;
            }
        }
        if (!bl) {
            None$ none$ = None$.MODULE$;
            return var5_11;
        }
        Optional<SegmentState> state = ((AbstractLog)some.value()).tierPartitionState().previousMetadataBeforeOffset(offset);
        None$ none$ = state.isPresent() ? new Some((Object)new Utils.MaxTimestampWithSize(state.get().maxTimestamp(), state.get().size())) : None$.MODULE$;
        return var5_11;
    }

    public Option<Utils.MaxTimestampWithSize> getTierSegmentInfoForRange(ReplicaManager replicaManager, TopicPartition topicPartition, long start, long end) {
        Buffer states;
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Object object = option instanceof Some && this.isTieredLog(log = (AbstractLog)((Some)option).value()) ? ((states = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(log.tierPartitionState().segmentInMemoryMetadataRange(start, end)).asScala()).isEmpty() ? None$.MODULE$ : new Some((Object)new Utils.MaxTimestampWithSize(BoxesRunTime.unboxToLong((Object)((TraversableOnce)states.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp()), Buffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.unboxToInt((Object)((TraversableOnce)states.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$))))) : None$.MODULE$;
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> getEstimatedLogRangeSize(ReplicaManager replicaManager, TopicPartition topicPartition, long startOffset) {
        Option<Utils.MaxTimestampWithSize> extraSize;
        Option<Utils.MaxTimestampWithSize> gapSize;
        Option<Utils.MaxTimestampWithSize> option = this.getPreviousTierSegmentInfo(replicaManager, topicPartition, startOffset);
        Option<AbstractLog> option2 = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Option<Utils.MaxTimestampWithSize> option3 = option;
        if (!(option2 instanceof Some)) return None$.MODULE$;
        AbstractLog log = (AbstractLog)((Some)option2).value();
        if (!(option3 instanceof Some)) return None$.MODULE$;
        Utils.MaxTimestampWithSize prev = (Utils.MaxTimestampWithSize)((Some)option3).value();
        Object object = log.logStartOffset() == startOffset ? new Some((Object)BoxesRunTime.boxToLong((long)(log.size() + prev.size()))) : (log.logStartOffset() > startOffset ? ((gapSize = this.getTierSegmentInfoForRange(replicaManager, topicPartition, startOffset, log.logStartOffset() - 1L)).isDefined() ? new Some((Object)BoxesRunTime.boxToLong((long)(log.size() + prev.size() + ((Utils.MaxTimestampWithSize)gapSize.get()).size()))) : None$.MODULE$) : ((extraSize = this.getTierSegmentInfoForRange(replicaManager, topicPartition, log.logStartOffset(), startOffset - 1L)).isDefined() ? new Some((Object)BoxesRunTime.boxToLong((long)(log.size() - ((Utils.MaxTimestampWithSize)extraSize.get()).size() + prev.size()))) : None$.MODULE$));
        return object;
    }

    public int getBrokerId(ReplicaManager replicaManager) {
        return replicaManager.config().brokerId();
    }

    public Option<Object> getLocalLogRetentionSize(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Object object = option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null ? new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(log.config().retentionSize()))) : None$.MODULE$;
        return object;
    }

    public Option<Object> getLocalLogRetentionMs(ReplicaManager replicaManager, TopicPartition topicPartition) {
        AbstractLog log;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        Object object = option instanceof Some && (log = (AbstractLog)((Some)option).value()) != null ? new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(log.config().retentionMs()))) : None$.MODULE$;
        return object;
    }

    public Option<Object> getLocalStartOffsetForEpoch(ReplicaManager replicaManager, TopicPartition topicPartition, int epoch) {
        None$ none$;
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        if (option instanceof Some) {
            None$ none$2;
            Option<LeaderEpochFileCache> option2 = ((AbstractLog)((Some)option).value()).leaderEpochCache();
            if (option2 instanceof Some) {
                LeaderEpochFileCache cache = (LeaderEpochFileCache)((Some)option2).value();
                none$2 = new Some((Object)BoxesRunTime.boxToLong((long)cache.offsetForEpoch(epoch)));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean isNonCompacted(ReplicaManager replicaManager, TopicPartition topicPartition) {
        Option<AbstractLog> option = replicaManager.logManager().getLog(topicPartition, replicaManager.logManager().getLog$default$2());
        boolean bl = option instanceof Some ? !((AbstractLog)((Some)option).value()).config().compact() : false;
        return bl;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

