/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import com.amazonaws.AmazonServiceException;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import kafka.durability.audit.AuditJob$;
import kafka.durability.audit.AuditJobResult;
import kafka.durability.audit.AuditJobResult$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.PartialAuditJobResult;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierUtils;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.TierMetadataValidator;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=f\u0001\u0002\u0016,\u0001IB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"IQ\r\u0001BC\u0002\u0013\u00051F\u001a\u0005\t_\u0002\u0011\t\u0011)A\u0005O\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003w\u0011!Q\bA!A!\u0002\u0013Y\bBCA\u0007\u0001\t\u0005\t\u0015!\u0003\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001\"CA\u0017\u0001\u0001\u0007I\u0011BA\u0018\u0011%\t\t\u0004\u0001a\u0001\n\u0013\t\u0019\u0004C\u0004\u0002@\u0001\u0001\u000b\u0015\u0002<\t\u0013\u0005%\u0003\u00011A\u0005\n\u0005-\u0003\"CA*\u0001\u0001\u0007I\u0011BA+\u0011!\tI\u0006\u0001Q!\n\u00055\u0003\"CA.\u0001\u0001\u0007I\u0011BA&\u0011%\ti\u0006\u0001a\u0001\n\u0013\ty\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0015BA'\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!a\u001d\u0001\t\u0003\n)\b\u0003\u0005\u0002x\u0001!\t!LA=\u0011!\t\u0019\t\u0001C\u0001[\u0005\u0015\u0005\"CAQ\u0001\t\u0007I\u0011BAR\u0011!\tY\f\u0001Q\u0001\n\u0005\u0015\u0006\u0002CA_\u0001\u0011E1&a0\t\u0011\u0005}\u0007\u0001\"\u0001.\u0003CD\u0001\"!@\u0001\t\u0003i\u0013q \u0005\t\u0005\u0003\u0001A\u0011A\u0017\u0003\u0004!A!\u0011\u0005\u0001\u0005\u00025\u0012\u0019\u0003\u0003\u0005\u0003*\u0001!\ta\u000bB\u0016\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{9qA!\u001c,\u0011\u0003\u0011yG\u0002\u0004+W!\u0005!\u0011\u000f\u0005\b\u00033\tC\u0011\u0001B=\u0011\u001d\u0011Y(\tC\u0001\u0005{BqA!!\"\t\u0003\u0011\u0019\t\u0003\u0006\u0003\u0014\u0006\u0012\r\u0011\"\u0001,\u0003\u0017B\u0001B!&\"A\u0003%\u0011Q\n\u0005\u000b\u0005/\u000b#\u0019!C\u0001W\u0005=\u0002b\u0002BMC\u0001\u0006IA\u001e\u0005\n\u00057\u000b\u0013\u0013!C\u0001\u0005;\u0013\u0001\"Q;eSRTuN\u0019\u0006\u0003Y5\nQ!Y;eSRT!AL\u0018\u0002\u0015\u0011,(/\u00192jY&$\u0018PC\u00011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u001a<}A\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0005Y\u0006twMC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$AB(cU\u0016\u001cG\u000f\u0005\u00025y%\u0011Q(\u000e\u0002\t%Vtg.\u00192mKB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iL\u0001\u0006kRLGn]\u0005\u0003\u0007\u0002\u0013q\u0001T8hO&tw-A\bu_BL7\rU1si&$\u0018n\u001c8t!\r1\u0005k\u0015\b\u0003\u000f6s!\u0001S&\u000e\u0003%S!AS\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0015!B:dC2\f\u0017B\u0001(P\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001T\u0005\u0003#J\u00131aU3r\u0015\tqu\n\u0005\u0002U96\tQK\u0003\u0002W/\u000611m\\7n_:T!\u0001\r-\u000b\u0005eS\u0016AB1qC\u000eDWMC\u0001\\\u0003\ry'oZ\u0005\u0003;V\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0006m_\u001el\u0015M\\1hKJ\u0004\"\u0001Y2\u000e\u0003\u0005T!AY\u0018\u0002\u00071|w-\u0003\u0002eC\nQAj\\4NC:\fw-\u001a:\u0002'=t7i\\7qY\u0016$XmU5h]\u0006dG.\u001a:\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002mo\u0005!Q\u000f^5m\u0013\tq\u0017N\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u0002)=t7i\\7qY\u0016$XmU5h]\u0006dG.\u001a:!\u00035\tW\u000fZ5u%\u0016\u0004xN\u001d;feB\u0011!o]\u0007\u0002W%\u0011Ao\u000b\u0002\u000e\u0003V$\u0017\u000e\u001e*fa>\u0014H/\u001a:\u0002\u000b)|'-\u00133\u0011\u0005]DX\"A(\n\u0005e|%aA%oi\u0006yA/[3s\u001f\nT7\u000b^8sK>\u0003H\u000fE\u0002xyzL!!`(\u0003\r=\u0003H/[8o!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005)1\u000f^8sK*\u0019\u0011qA\u0018\u0002\tQLWM]\u0005\u0005\u0003\u0017\t\tAA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003\u0011!\u0018.\\3\u0011\t\u0005E\u0011QC\u0007\u0003\u0003'Q!!Q+\n\t\u0005]\u00111\u0003\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003;\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\u0001\"A\u001d\u0001\t\u000b\u0011K\u0001\u0019A#\t\u000byK\u0001\u0019A0\t\u000b\u0015L\u0001\u0019A4\t\u000bAL\u0001\u0019A9\t\u000bUL\u0001\u0019\u0001<\t\u000biL\u0001\u0019A>\t\u0013\u00055\u0011\u0002%AA\u0002\u0005=\u0011a\u0006:f[\u0006Lg.\u001b8h!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\u00051\u0018a\u0007:f[\u0006Lg.\u001b8h!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005m\u0002cA<\u00028%\u0019\u0011\u0011H(\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003{Y\u0011\u0011!a\u0001m\u0006\u0019\u0001\u0010J\u0019\u00021I,W.Y5oS:<\u0007+\u0019:uSRLwN\\\"pk:$\b\u0005K\u0002\r\u0003\u0007\u00022a^A#\u0013\r\t9e\u0014\u0002\tm>d\u0017\r^5mK\u0006\u0001Co\u001c;bY>3gm]3u\u0007>,h\u000e^!de>\u001c8\u000fU1si&$\u0018n\u001c8t+\t\ti\u0005E\u0002x\u0003\u001fJ1!!\u0015P\u0005\u0011auN\\4\u0002IQ|G/\u00197PM\u001a\u001cX\r^\"pk:$\u0018i\u0019:pgN\u0004\u0016M\u001d;ji&|gn]0%KF$B!!\u000e\u0002X!I\u0011Q\b\b\u0002\u0002\u0003\u0007\u0011QJ\u0001\"i>$\u0018\r\\(gMN,GoQ8v]R\f5M]8tgB\u000b'\u000f^5uS>t7\u000fI\u0001\u001ei>$\u0018\r\\$ba\u000e{WO\u001c;BGJ|7o\u001d)beRLG/[8og\u0006\tCo\u001c;bY\u001e\u000b\u0007oQ8v]R\f5M]8tgB\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011QGA1\u0011%\ti$EA\u0001\u0002\u0004\ti%\u0001\u0010u_R\fGnR1q\u0007>,h\u000e^!de>\u001c8\u000fU1si&$\u0018n\u001c8tA\u0005)R\u000f\u001d3bi\u0016Le\u000e^3s]\u0006dW*\u001a;sS\u000e\u001cH\u0003BA\u001b\u0003SBq!a\u001b\u0014\u0001\u0004\ti'\u0001\u0004sKN,H\u000e\u001e\t\u0004e\u0006=\u0014bAA9W\tq\u0011)\u001e3ji*{'MU3tk2$\u0018a\u0001:v]R\u0011\u0011QG\u0001\u000eI>\fU\u000fZ5u'\u00064W\r\\=\u0015\t\u00055\u00141\u0010\u0005\u0007EV\u0001\r!! \u0011\u0007\u0001\fy(C\u0002\u0002\u0002\u0006\u00141\"\u00112tiJ\f7\r\u001e'pO\u0006)b/\u001a:jMfdunY1m\u0019><7+Z4nK:$H\u0003CAD\u0003\u001b\u000b\t*a'\u0011\u0007I\fI)C\u0002\u0002\f.\u0012Q\u0003U1si&\fG.Q;eSRTuN\u0019*fgVdG\u000f\u0003\u0004\u0002\u0010Z\u0001\raU\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\u0019J\u0006a\u0001\u0003+\u000bqa]3h[\u0016tG\u000fE\u0002a\u0003/K1!!'b\u0005)aunZ*fO6,g\u000e\u001e\u0005\b\u0003;3\u0002\u0019AAP\u0003Q\u0001(/\u001a<j_V\u001cXI\u001c3PM\u001a\u001cX\r^(qiB!q\u000f`A'\u00031\u00198'\u0012:s_J\u001cu\u000eZ3t+\t\t)\u000b\u0005\u0004\u0002(\u0006E\u0016QW\u0007\u0003\u0003SSA!a+\u0002.\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_{\u0015AC2pY2,7\r^5p]&!\u00111WAU\u0005\r\u0019V\r\u001e\t\u0004i\u0005]\u0016bAA]k\t11\u000b\u001e:j]\u001e\fQb]\u001aFeJ|'oQ8eKN\u0004\u0013\u0001E:i_VdGmQ8v]Rd\u0015\r]:f)\u0011\t\t-a2\u0011\u0007]\f\u0019-C\u0002\u0002F>\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002Jf\u0001\r!a3\u0002)QLWM\u001d,bY&$\u0017\r^5p]J+7/\u001e7u!\u0011\ti-!7\u000f\t\u0005=\u0017Q[\u0007\u0003\u0003#TA!a5\u0002\u0006\u0005)Ao\\8mg&!\u0011q[Ai\u0003U!\u0016.\u001a:NKR\fG-\u0019;b-\u0006d\u0017\u000eZ1u_JLA!a7\u0002^\n1rJ\u001a4tKR4\u0016\r\\5eCRLwN\u001c*fgVdGO\u0003\u0003\u0002X\u0006E\u0017A\u0006<fe&4\u0017\u0010V5fe\u0016$Gj\\4TK\u001elWM\u001c;\u0015\u0019\u0005\u001d\u00151]As\u0003[\fy/a=\t\r\u0005=%\u00041\u0001T\u0011\u001d\t\u0019J\u0007a\u0001\u0003O\u00042\u0001YAu\u0013\r\tY/\u0019\u0002\u000f)&,'\u000fT8h'\u0016<W.\u001a8u\u0011\u001d\tiJ\u0007a\u0001\u0003?Ca!!=\u001b\u0001\u0004Y\u0018aC8cUN#xN]3PaRDq!!>\u001b\u0001\u0004\t90A\ngSJ\u001cHOV1mS\u0012|eMZ:fi\u001e+g\u000e\u0005\u0004x\u0003s\u001c\u0016QJ\u0005\u0004\u0003w|%!\u0003$v]\u000e$\u0018n\u001c82\u0003)I7oQ8na2,G/Z\u000b\u0003\u0003\u0003\fa\u0004];cY&\u001c\b.\u00138uKJlW\rZ5bi\u0016d\u0015\r]:f'\u00064W\r\\=\u0015\u0015\u0005U\"Q\u0001B\u0004\u0005\u0017\u0011y\u0001\u0003\u0004\u0002\u0010r\u0001\ra\u0015\u0005\b\u0005\u0013a\u0002\u0019AA'\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t5A\u00041\u0001\u0002N\u0005Aq-\u00199D_VtG\u000fC\u0004\u0003\u0012q\u0001\rAa\u0005\u0002\u00075\u001cx\r\u0005\u0003\u0003\u0016\tua\u0002\u0002B\f\u00053\u0001\"\u0001S(\n\u0007\tmq*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\u0013yBC\u0002\u0003\u001c=\u000b1\u0003];cY&\u001c\bNU3tk2$8+\u00194fYf$B!!\u000e\u0003&!9!qE\u000fA\u0002\u00055\u0014AD1vI&$(j\u001c2SKN,H\u000e^\u0001\u001bm\u0016\u0014\u0018NZ=US\u0016\u0014X\rZ*fO6,g\u000e^:TC\u001a,G.\u001f\u000b\t\u0003\u000f\u0013iCa\f\u0003:!1\u0011q\u0012\u0010A\u0002MCqA!\r\u001f\u0001\u0004\u0011\u0019$A\tuS\u0016\u0014X\r\u001a'pON+w-\\3oiN\u0004RA\u0012B\u001b\u0003OL1Aa\u000eS\u0005!IE/\u001a:bi>\u0014\bbBA{=\u0001\u0007\u0011q_\u0001\u0018G\u0006$8\r[+q\u001f:$\u0016.\u001a:fIN+w-\\3oiN$\"\"a\"\u0003@\t=#\u0011\fB/\u0011\u001d\u0011\te\ba\u0001\u0005\u0007\n!\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKB!!Q\tB&\u001b\t\u00119E\u0003\u0003\u0003J\u0005\u0015\u0011!B:uCR,\u0017\u0002\u0002B'\u0005\u000f\u0012!\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1uK\"9!\u0011K\u0010A\u0002\tM\u0013a\u00057pG\u0006d7\u000b^1si>3gm]3u\u000f\u0016t\u0007#B<\u0003V\u00055\u0013b\u0001B,\u001f\nIa)\u001e8di&|g\u000e\r\u0005\b\u00057z\u0002\u0019AAD\u00039\u0001(/\u001a<j_V\u001c(+Z:vYRDq!!> \u0001\u0004\t9\u0010K\u0002 \u0005C\u0002BAa\u0019\u0003j5\u0011!Q\r\u0006\u0004\u0005Oz\u0015AC1o]>$\u0018\r^5p]&!!1\u000eB3\u0005\u001d!\u0018-\u001b7sK\u000e\f\u0001\"Q;eSRTuN\u0019\t\u0003e\u0006\u001a2!\tB:!\r9(QO\u0005\u0004\u0005oz%AB!osJ+g\r\u0006\u0002\u0003p\u0005q1\u000f[8vY\u0012\fU\u000fZ5u\u0019><G\u0003BAa\u0005\u007fBaAY\u0012A\u0002\u0005u\u0014!F4fiRKWM](cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u000b\u0005\u0005\u000b\u0013\t\n\u0005\u0003\u0003\b\n5UB\u0001BE\u0015\u0011\u0011Y)!\u0002\u0002\r\u0011|W.Y5o\u0013\u0011\u0011yI!#\u0003%QKWM](cU\u0016\u001cG/T3uC\u0012\fG/\u0019\u0005\b\u0003'#\u0003\u0019AAt\u00035\u0019F*R#Q?RKU*R0N'\u0006q1\u000bT#F!~#\u0016*T#`\u001bN\u0003\u0013a\u0006+J\u000bJ{6+R$N\u000b:#vLQ!U\u0007\"{6+\u0013.F\u0003a!\u0016*\u0012*`'\u0016;U*\u0012(U?\n\u000bEk\u0011%`'&SV\tI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t}%\u0006BA\b\u0005C[#Aa)\u0011\t\t\u0015&1V\u0007\u0003\u0005OSAA!+\u0003f\u0005IQO\\2iK\u000e\\W\rZ\u0005\u0005\u0005[\u00139KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class AuditJob
implements Runnable,
Logging {
    private final Seq<TopicPartition> topicPartitions;
    private final LogManager logManager;
    private final CountDownLatch onCompleteSignaller;
    private final AuditReporter auditReporter;
    private final int jobId;
    private final Option<TierObjectStore> tierObjStoreOpt;
    private final Time time;
    private volatile int remainingPartitionCount;
    private long totalOffsetCountAcrossPartitions;
    private long totalGapCountAcrossPartitions;
    private final Set<String> s3ErrorCodes;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return AuditJob$.MODULE$.$lessinit$greater$default$7();
    }

    public static TierObjectMetadata getTierObjectMetadata(TierLogSegment tierLogSegment) {
        return AuditJob$.MODULE$.getTierObjectMetadata(tierLogSegment);
    }

    public static boolean shouldAuditLog(AbstractLog abstractLog) {
        return AuditJob$.MODULE$.shouldAuditLog(abstractLog);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CountDownLatch onCompleteSignaller() {
        return this.onCompleteSignaller;
    }

    private int remainingPartitionCount() {
        return this.remainingPartitionCount;
    }

    private void remainingPartitionCount_$eq(int x$1) {
        this.remainingPartitionCount = x$1;
    }

    private long totalOffsetCountAcrossPartitions() {
        return this.totalOffsetCountAcrossPartitions;
    }

    private void totalOffsetCountAcrossPartitions_$eq(long x$1) {
        this.totalOffsetCountAcrossPartitions = x$1;
    }

    private long totalGapCountAcrossPartitions() {
        return this.totalGapCountAcrossPartitions;
    }

    private void totalGapCountAcrossPartitions_$eq(long x$1) {
        this.totalGapCountAcrossPartitions = x$1;
    }

    private void updateInternalMetrics(AuditJobResult result) {
        this.totalOffsetCountAcrossPartitions_$eq(this.totalOffsetCountAcrossPartitions() + result.totalOffsetCount());
        this.totalGapCountAcrossPartitions_$eq(this.totalGapCountAcrossPartitions() + result.totalGapCount());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Finished topicPartition: ").append(result.topicPartition()).append(", error: ").append(result.errorOpt().isDefined()).append(" ").append("totalOffsetCount: ").append(this.totalOffsetCountAcrossPartitions()).append(", totalGapCount: ").append(this.totalGapCountAcrossPartitions()).append(", ").append("remainingPartitionCount: ").append(this.remainingPartitionCount()).toString());
    }

    @Override
    public void run() {
        Object object = new Object();
        try {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Going to start execution for the audit run with topicPartition count: ").append($this.topicPartitions.size()).append("!").toString());
            try {
                try {
                    this.topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                        AuditJob.$anonfun$run$2(this, object, topicPartition);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (InterruptedException interruptedException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append(this.logIdent()).append(" received interrupted exception, will shutdown").toString());
                }
                catch (Exception e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append(this.logIdent()).append(" received error while executing, will exit!").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            finally {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Completed execution for audit run with totalOffsetCount: ").append(this.totalOffsetCountAcrossPartitions()).append(" ").append("and totalGapCount: ").append(this.totalGapCountAcrossPartitions()).toString());
                this.onCompleteSignaller().countDown();
            }
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    public AuditJobResult doAuditSafely(AbstractLog log) {
        AuditJobResult auditJobResult;
        block18: {
            AuditJobResult auditJobResult2;
            block17: {
                String localLogIdent = new StringBuilder(2).append("[").append(log.topicIdPartition().getOrElse((Function0 & Serializable & scala.Serializable)() -> log.topicPartition())).append("]").toString();
                TopicPartition topicPartition = log.topicPartition();
                ObjectRef previousEndOffsetOpt = ObjectRef.create((Object)None$.MODULE$);
                LongRef totalOffsetCount = LongRef.create((long)0L);
                LongRef totalGapCount = LongRef.create((long)0L);
                try {
                    try {
                        Iterator<TierLogSegment> tieredLogs;
                        if (!AuditJob$.MODULE$.shouldAuditLog(log)) {
                            UnsupportedOperationException err = new UnsupportedOperationException(new StringBuilder(39).append(log).append(" shouldn't be audited as its compacted!").toString());
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(localLogIdent).append(": Avoiding audit for log: ").append(log).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> err);
                            auditJobResult2 = new AuditJobResult(log.topicPartition(), 0L, 0L, this.jobId, (Option<Exception>)new Some((Object)err));
                            break block17;
                        }
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append(localLogIdent).append(": Going to start durability audit").toString());
                        if (log.tierPartitionState().mayContainTieredData()) {
                            boolean isValidChecksum = log.tierPartitionState().validateChecksum();
                            if (!isValidChecksum) {
                                String msg = new StringBuilder(73).append("Durability lapse on checksum validation of tier state file for partition ").append(topicPartition).toString();
                                this.auditReporter.reportDurabilityLapse(topicPartition, 0L, 1L, DurabilityLapseType$.MODULE$.ChecksumValidation(), msg, false);
                            }
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append(localLogIdent).append(": ").append("Checksum validation of tier state file: ").append(isValidChecksum).toString());
                        }
                        if ((tieredLogs = log.tieredLogSegments()).nonEmpty()) {
                            AbstractLog log2;
                            Option<AbstractLog> option;
                            long l;
                            ObjectRef tieredPartialResult = ObjectRef.create((Object)this.verifyTieredSegmentsSafely(topicPartition, tieredLogs, (Function1<TopicPartition, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)log.logStartOffset())));
                            Option option2 = log.localLogSegments().headOption();
                            if (option2 instanceof Some) {
                                LogSegment localSegment2 = (LogSegment)((Some)option2).value();
                                l = package$.MODULE$.max(0L, localSegment2.baseOffset() - ((PartialAuditJobResult)tieredPartialResult.elem).currentEndOffset() - 1L);
                            } else if (None$.MODULE$.equals(option2)) {
                                l = 0L;
                            } else {
                                throw new MatchError((Object)option2);
                            }
                            long offsetGap = l;
                            if (l > 0L) {
                                tieredPartialResult.elem = this.catchUpOnTieredSegments(log.tierPartitionState(), (Function0<Object>)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((LogSegment)log.localLogSegments().head()).baseOffset(), (PartialAuditJobResult)tieredPartialResult.elem, (Function1<TopicPartition, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)log.logStartOffset()));
                                offsetGap = package$.MODULE$.max(0L, ((LogSegment)log.localLogSegments().head()).baseOffset() - ((PartialAuditJobResult)tieredPartialResult.elem).currentEndOffset() - 1L);
                            }
                            if (offsetGap > 0L && (option = this.logManager.getLog(topicPartition, this.logManager.getLog$default$2())) instanceof Some && (log2 = (AbstractLog)((Some)option).value()).logStartOffset() >= log2.localLogStartOffset()) {
                                offsetGap = 0L;
                            }
                            if (offsetGap > 0L) {
                                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(108).append("Durability lapse. ").append(localLogIdent).append(": offsetGap found between tiered and local segments, tier endOffset: ").append(((PartialAuditJobResult)tieredPartialResult$1.elem).currentEndOffset()).append(", local startOffset: ").append(((LogSegment)log.localLogSegments().head()).baseOffset()).toString());
                            }
                            totalOffsetCount.elem += ((PartialAuditJobResult)tieredPartialResult.elem).offsetCount();
                            totalGapCount.elem += ((PartialAuditJobResult)tieredPartialResult.elem).gapCount();
                            totalGapCount.elem += offsetGap;
                        }
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append(localLogIdent).append(": Completed tier portion with totalOffsetCount: ").append(totalOffsetCount$1.elem).append(" ").append("and totalGapCount: ").append(totalGapCount$1.elem).toString());
                        previousEndOffsetOpt.elem = None$.MODULE$;
                        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)localSegment -> {
                            AuditJob.$anonfun$doAuditSafely$11(this, localLogIdent, topicPartition, previousEndOffsetOpt, totalOffsetCount, totalGapCount, localSegment);
                            return BoxedUnit.UNIT;
                        });
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append(localLogIdent).append(": Completed entire audit with totalOffsetCount: ").append(totalOffsetCount$1.elem).append(" ").append("and totalGapCount: ").append(totalGapCount$1.elem).toString());
                        auditJobResult = new AuditJobResult(topicPartition, totalOffsetCount.elem, totalGapCount.elem, this.jobId, AuditJobResult$.MODULE$.apply$default$5());
                        break block18;
                    }
                    catch (InterruptedException interruptedException) {
                        throw interruptedException;
                    }
                    catch (Exception e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append(localLogIdent).append(": Received exception, will continue with other partition").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        auditJobResult = new AuditJobResult(log.topicPartition(), 0L, 0L, this.jobId, (Option<Exception>)new Some((Object)e));
                        break block18;
                    }
                }
                finally {
                    this.remainingPartitionCount_$eq(this.remainingPartitionCount() - 1);
                }
            }
            return auditJobResult2;
        }
        return auditJobResult;
    }

    public PartialAuditJobResult verifyLocalLogSegment(TopicPartition topicPartition, LogSegment segment, Option<Object> previousEndOffsetOpt) {
        long l;
        long currentEndOffset = segment.readNextOffset() - 1L;
        long totalNumMsgs = currentEndOffset - segment.baseOffset() + 1L;
        if (previousEndOffsetOpt instanceof Some) {
            long prev = BoxesRunTime.unboxToLong((Object)((Some)previousEndOffsetOpt).value());
            l = package$.MODULE$.max(0L, segment.baseOffset() - prev - 1L);
        } else if (None$.MODULE$.equals(previousEndOffsetOpt)) {
            l = 0L;
        } else {
            throw new MatchError(previousEndOffsetOpt);
        }
        if (l > 0L) {
            String msg = new StringBuilder(87).append("Durability lapse. [").append(topicPartition).append("] Received offset gap for topicPartition: ").append(topicPartition).append(" in local ").append("segment: ").append(segment).append(", gap: ").append(l).toString();
            this.publishIntermediateLapseSafely(topicPartition, segment.baseOffset(), l, msg);
        }
        return new PartialAuditJobResult(totalNumMsgs, l, currentEndOffset);
    }

    private Set<String> s3ErrorCodes() {
        return this.s3ErrorCodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldCountLapse(TierMetadataValidator.OffsetValidationResult tierValidationResult) {
        boolean bl = false;
        Some some = null;
        Option option = Option$.MODULE$.apply((Object)tierValidationResult.exception);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Exception retriableException = (Exception)some.value();
            if (retriableException instanceof TierObjectStoreRetriableException) {
                Throwable throwable = ((TierObjectStoreRetriableException)((Object)retriableException)).getCause();
                if (!(throwable instanceof AmazonServiceException)) return false;
                AmazonServiceException amazonServiceException = (AmazonServiceException)throwable;
                if (!this.s3ErrorCodes().contains((Object)amazonServiceException.getErrorCode())) return false;
                return true;
            }
        }
        if (!bl) return false;
        Exception intr = (Exception)some.value();
        if (!(intr instanceof InterruptedException)) return false;
        throw (InterruptedException)intr;
    }

    /*
     * Unable to fully structure code
     */
    public PartialAuditJobResult verifyTieredLogSegment(TopicPartition topicPartition, TierLogSegment segment, Option<Object> previousEndOffsetOpt, Option<TierObjectStore> objStoreOpt, Function1<TopicPartition, Object> firstValidOffsetGen) {
        block16: {
            block13: {
                block15: {
                    block14: {
                        totalNumMsgs = segment.endOffset() - segment.baseOffset() + 1L;
                        if (previousEndOffsetOpt instanceof Some) {
                            prev = BoxesRunTime.unboxToLong((Object)((Some)previousEndOffsetOpt).value());
                            var10_8 = package$.MODULE$.max(0L, segment.baseOffset() - prev - 1L);
                        } else if (None$.MODULE$.equals(previousEndOffsetOpt)) {
                            var10_8 = 0L;
                        } else {
                            throw new MatchError(previousEndOffsetOpt);
                        }
                        totalGapMsgs = var10_8;
                        if (var10_8 > 0L && (var18_10 = this.logManager.getLog(topicPartition, this.logManager.getLog$default$2())) instanceof Some && ((AbstractLog)((Some)var18_10).value()).logStartOffset() >= segment.baseOffset()) {
                            totalGapMsgs = 0L;
                        }
                        if (!(objStoreOpt instanceof Some)) break block13;
                        objStore = (TierObjectStore)((Some)objStoreOpt).value();
                        tierValidationResult = TierMetadataValidator.verifyObjectInBackend(AuditJob$.MODULE$.getTierObjectMetadata(segment), BoxesRunTime.unboxToLong((Object)firstValidOffsetGen.apply((Object)topicPartition)), objStore, false, CancellationContext.newContext(), (Function<TopicPartition, Long>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$1(scala.Function1 org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Long;)(firstValidOffsetGen));
                        var21_13 = false;
                        var22_14 = tierValidationResult.result;
                        if (!var22_14) break block14;
                        var8_15 = 0L;
                        break block15;
                    }
                    if (var22_14) ** GOTO lbl-1000
                    var21_13 = true;
                    if (this.onCompleteSignaller().getCount() > 0L && this.shouldCountLapse(tierValidationResult)) {
                        var8_15 = totalNumMsgs;
                    } else if (var21_13 && this.onCompleteSignaller().getCount() > 0L) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$2(), ()Ljava/lang/String;)(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$verifyTieredLogSegment$3(kafka.tier.tools.TierMetadataValidator$OffsetValidationResult ), ()Ljava/lang/Exception;)((TierMetadataValidator.OffsetValidationResult)tierValidationResult));
                        var8_15 = 0L;
                    } else {
                        if (var21_13) {
                            throw new InterruptedException("AuditJob has received onCompleteSignaller signal, will shutdown!");
                        }
                        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)var22_14));
                    }
                }
                var6_16 = var8_15;
                break block16;
            }
            if (None$.MODULE$.equals(objStoreOpt)) {
                var6_16 = 0L;
            } else {
                throw new MatchError(objStoreOpt);
            }
        }
        gapCount = totalGapMsgs + var6_16;
        if (gapCount > 0L) {
            msg = new StringBuilder(109).append("Durability lapse. Received offset gap in tiered part of topicPartition: ").append(topicPartition).append(", segment: ").append(segment).append(", ").append("gapMsgs: ").append(totalGapMsgs).append(", objStoreGap: ").append(var6_16).toString();
            this.publishIntermediateLapseSafely(topicPartition, segment.baseOffset(), gapCount, msg);
        }
        return new PartialAuditJobResult(totalNumMsgs, gapCount, segment.endOffset());
    }

    public boolean isComplete() {
        return this.remainingPartitionCount() == 0;
    }

    public void publishIntermediateLapseSafely(TopicPartition topicPartition, long startOffset, long gapCount, String msg) {
        try {
            this.auditReporter.reportDurabilityLapse(topicPartition, startOffset, gapCount, msg, this.auditReporter.reportDurabilityLapse$default$5());
            return;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("publishIntermediateLapseSafely received error for: ").append(topicPartition).append(", at ").append(startOffset).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void publishResultSafely(AuditJobResult auditJobResult) {
        try {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Going to publish results: ").append(auditJobResult).toString());
            this.auditReporter.reportDurabilityAudit(this.jobId, auditJobResult.topicPartition(), auditJobResult.totalOffsetCount(), this.auditReporter.reportDurabilityAudit$default$4());
            return;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Received error while publishing result: ").append(auditJobResult).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public PartialAuditJobResult verifyTieredSegmentsSafely(TopicPartition topicPartition, Iterator<TierLogSegment> tieredLogSegments, Function1<TopicPartition, Object> firstValidOffsetGen) {
        ObjectRef previousEndOffsetOpt = ObjectRef.create((Object)None$.MODULE$);
        LongRef totalOffsetCount = LongRef.create((long)0L);
        LongRef totalGapCount = LongRef.create((long)0L);
        tieredLogSegments.grouped(AuditJob$.MODULE$.TIER_SEGMENT_BATCH_SIZE()).foreach((Function1 & Serializable & scala.Serializable)tieredLogBatch -> {
            tieredLogBatch.foreach((Function1 & Serializable & scala.Serializable)tieredSegment -> {
                PartialAuditJobResult $anonfun$verifyTieredSegmentsSafely$2_partialResult = this.verifyTieredLogSegment(topicPartition, (TierLogSegment)tieredSegment, (Option<Object>)((Option)previousEndOffsetOpt$2.elem), $this.tierObjStoreOpt, firstValidOffsetGen);
                previousEndOffsetOpt$2.elem = new Some((Object)BoxesRunTime.boxToLong((long)$anonfun$verifyTieredSegmentsSafely$2_partialResult.currentEndOffset()));
                totalOffsetCount$2.elem += $anonfun$verifyTieredSegmentsSafely$2_partialResult.offsetCount();
                totalGapCount$2.elem += $anonfun$verifyTieredSegmentsSafely$2_partialResult.gapCount();
                return BoxedUnit.UNIT;
            });
            $this.time.sleep(AuditJob$.MODULE$.SLEEP_TIME_MS());
            if (this.onCompleteSignaller().getCount() == 0L) {
                throw new InterruptedException(new StringBuilder(60).append(this.logIdent()).append(" onCompleteSignaller has been signalled, will stop verifying").toString());
            }
            return BoxedUnit.UNIT;
        });
        return new PartialAuditJobResult(totalOffsetCount.elem, totalGapCount.elem, BoxesRunTime.unboxToLong((Object)((Option)previousEndOffsetOpt.elem).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    private PartialAuditJobResult catchUpOnTieredSegments(TierPartitionState tierPartitionState, Function0<Object> localStartOffsetGen, PartialAuditJobResult previousResult, Function1<TopicPartition, Object> firstValidOffsetGen) {
        PartialAuditJobResult partialAuditJobResult;
        block2: {
            Option option;
            block3: {
                PartialAuditJobResult cumulativePartialResult;
                while (true) {
                    long prevEndOffset;
                    if (None$.MODULE$.equals(option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TierUtils.tierLogSegmentForOffset(tierPartitionState, (prevEndOffset = previousResult.currentEndOffset()) + 1L))))) {
                        partialAuditJobResult = previousResult;
                        break block2;
                    }
                    if (!(option instanceof Some)) break block3;
                    TierLogSegment tierLogSegment = (TierLogSegment)((Some)option).value();
                    PartialAuditJobResult partialResult = this.verifyTieredLogSegment(tierPartitionState.topicPartition(), tierLogSegment, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)prevEndOffset)), this.tierObjStoreOpt, firstValidOffsetGen);
                    cumulativePartialResult = previousResult.add(partialResult);
                    if (cumulativePartialResult.currentEndOffset() >= localStartOffsetGen.apply$mcJ$sp() - 1L) break;
                    previousResult = cumulativePartialResult;
                }
                partialAuditJobResult = cumulativePartialResult;
                break block2;
            }
            throw new MatchError((Object)option);
        }
        return partialAuditJobResult;
    }

    public static final /* synthetic */ void $anonfun$run$2(AuditJob $this, Object nonLocalReturnKey1$1, TopicPartition topicPartition) {
        if ($this.onCompleteSignaller().getCount() == 0L) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
        Option<AbstractLog> option = $this.logManager.getLog(topicPartition, $this.logManager.getLog$default$2());
        if (option instanceof Some) {
            AbstractLog log = (AbstractLog)((Some)option).value();
            Instant startTime = Instant.ofEpochMilli($this.time.milliseconds());
            AuditJobResult result = $this.doAuditSafely(log);
            if (!result.errorOpt().isDefined()) {
                $this.updateInternalMetrics(result);
                $this.publishResultSafely(result);
                long timeElapsedMinutes = Duration.between(startTime, Instant.ofEpochMilli($this.time.milliseconds())).toMinutes();
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Completed audit for ").append(topicPartition).append(" in ").append(timeElapsedMinutes).append(" minutes").toString());
                return;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("AbstractLog not found for: ").append(topicPartition).toString());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$doAuditSafely$11(AuditJob $this, String localLogIdent$1, TopicPartition topicPartition$2, ObjectRef previousEndOffsetOpt$1, LongRef totalOffsetCount$1, LongRef totalGapCount$1, LogSegment localSegment) {
        if ($this.onCompleteSignaller().getCount() == 0L) {
            throw new InterruptedException(new StringBuilder(42).append(localLogIdent$1).append(": onCompleteSignaller signalled, will quit").toString());
        }
        PartialAuditJobResult partialResult = $this.verifyLocalLogSegment(topicPartition$2, localSegment, (Option<Object>)((Option)previousEndOffsetOpt$1.elem));
        previousEndOffsetOpt$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)partialResult.currentEndOffset()));
        totalOffsetCount$1.elem += partialResult.offsetCount();
        totalGapCount$1.elem += partialResult.gapCount();
    }

    public static final /* synthetic */ Long $anonfun$verifyTieredLogSegment$1(Function1 firstValidOffsetGen$1, TopicPartition topicPartition) {
        return Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)firstValidOffsetGen$1.apply((Object)topicPartition)));
    }

    public static final /* synthetic */ String $anonfun$verifyTieredLogSegment$2() {
        return "Going to ignore false result with underlying cause";
    }

    public static final /* synthetic */ Exception $anonfun$verifyTieredLogSegment$3(TierMetadataValidator.OffsetValidationResult tierValidationResult$1) {
        return tierValidationResult$1.exception;
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsSafely$2(AuditJob $this, TopicPartition topicPartition$4, ObjectRef previousEndOffsetOpt$2, Function1 firstValidOffsetGen$2, LongRef totalOffsetCount$2, LongRef totalGapCount$2, TierLogSegment tieredSegment) {
        PartialAuditJobResult partialResult = $this.verifyTieredLogSegment(topicPartition$4, tieredSegment, (Option<Object>)((Option)previousEndOffsetOpt$2.elem), $this.tierObjStoreOpt, (Function1<TopicPartition, Object>)firstValidOffsetGen$2);
        previousEndOffsetOpt$2.elem = new Some((Object)BoxesRunTime.boxToLong((long)partialResult.currentEndOffset()));
        totalOffsetCount$2.elem += partialResult.offsetCount();
        totalGapCount$2.elem += partialResult.gapCount();
    }

    public static final /* synthetic */ void $anonfun$verifyTieredSegmentsSafely$1(AuditJob $this, TopicPartition topicPartition$4, ObjectRef previousEndOffsetOpt$2, Function1 firstValidOffsetGen$2, LongRef totalOffsetCount$2, LongRef totalGapCount$2, Seq tieredLogBatch) {
        tieredLogBatch.foreach((Function1 & Serializable & scala.Serializable)tieredSegment -> {
            PartialAuditJobResult $anonfun$verifyTieredSegmentsSafely$2_partialResult = this.verifyTieredLogSegment(topicPartition, (TierLogSegment)tieredSegment, (Option<Object>)((Option)previousEndOffsetOpt$2.elem), $this.tierObjStoreOpt, firstValidOffsetGen);
            previousEndOffsetOpt$2.elem = new Some((Object)BoxesRunTime.boxToLong((long)$anonfun$verifyTieredSegmentsSafely$2_partialResult.currentEndOffset()));
            totalOffsetCount$2.elem += $anonfun$verifyTieredSegmentsSafely$2_partialResult.offsetCount();
            totalGapCount$2.elem += $anonfun$verifyTieredSegmentsSafely$2_partialResult.gapCount();
            return BoxedUnit.UNIT;
        });
        $this.time.sleep(AuditJob$.MODULE$.SLEEP_TIME_MS());
        if ($this.onCompleteSignaller().getCount() == 0L) {
            throw new InterruptedException(new StringBuilder(60).append($this.logIdent()).append(" onCompleteSignaller has been signalled, will stop verifying").toString());
        }
    }

    public AuditJob(Seq<TopicPartition> topicPartitions, LogManager logManager, CountDownLatch onCompleteSignaller, AuditReporter auditReporter, int jobId, Option<TierObjectStore> tierObjStoreOpt, Time time) {
        this.topicPartitions = topicPartitions;
        this.logManager = logManager;
        this.onCompleteSignaller = onCompleteSignaller;
        this.auditReporter = auditReporter;
        this.jobId = jobId;
        this.tierObjStoreOpt = tierObjStoreOpt;
        this.time = time;
        Logging.$init$(this);
        this.remainingPartitionCount = topicPartitions.size();
        this.totalOffsetCountAcrossPartitions = 0L;
        this.totalGapCountAcrossPartitions = 0L;
        this.logIdent_$eq(new StringBuilder(14).append("[AuditJob:(").append(jobId).append(")] ").toString());
        this.s3ErrorCodes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AccessDenied", "AccountProblem", "AllAccessDisabled", "InvalidAccessKeyId", "MethodNotAllowed", "NoSuchBucket", "NoSuchKey", "NoSuchUpload", "NoSuchVersion"}));
    }
}

