/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditJob;
import kafka.durability.audit.AuditManager$;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DeleteMessagesRequest;
import kafka.durability.audit.DeletePartitionRequest;
import kafka.durability.audit.DurabilityAuditConfig;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.EpochChangeRequest;
import kafka.durability.audit.HealthCheckRequest;
import kafka.durability.audit.HighWatermarkUpdateRequest;
import kafka.durability.audit.ISRExpandRequest;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.RetentionConfigChangeRequest;
import kafka.durability.audit.StartOffsetChangeRequest;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.DurabilityDB$;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.CurrentVersion$;
import kafka.durability.events.DeletePartitionEvent$;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.HealthCheckEvent$;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.OffsetChangeEvent$;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.topic.DurabilityTopicConfig;
import kafka.durability.topic.DurabilityTopicManager;
import kafka.durability.topic.DurabilityTopicManager$;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t]h\u0001B%K\u0001EC\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t!\u0017\u0005\t=\u0002\u0011\t\u0011)A\u00055\"Aq\f\u0001BC\u0002\u0013\u0005\u0001\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003b\u0011!A\u0007A!A!\u0002\u0013I\u0007\u0002C<\u0001\u0005\u000b\u0007I\u0011\u0001=\t\u0013\u0005-\u0001A!A!\u0002\u0013I\bbBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"!\f\u0001A\u0003%\u0011q\u0004\u0005\f\u0003_\u0001\u0001\u0019!a\u0001\n\u0013\t\t\u0004C\u0006\u0002:\u0001\u0001\r\u00111A\u0005\n\u0005m\u0002bCA$\u0001\u0001\u0007\t\u0011)Q\u0005\u0003gA!\"!\u0013\u0001\u0001\u0004%\tASA&\u0011)\t\u0019\u0006\u0001a\u0001\n\u0003Q\u0015Q\u000b\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002N!Q\u00111\f\u0001A\u0002\u0013\u0005!*!\u0018\t\u0015\u0005=\u0004\u00011A\u0005\u0002)\u000b\t\b\u0003\u0005\u0002v\u0001\u0001\u000b\u0015BA0\u0011)\t9\b\u0001b\u0001\n\u0003Q\u0015\u0011\u0010\u0005\t\u0003\u001f\u0003\u0001\u0015!\u0003\u0002|!I\u0011\u0011\u0013\u0001C\u0002\u0013\u0005\u00111\u0013\u0005\t\u0003C\u0003\u0001\u0015!\u0003\u0002\u0016\"Q\u00111\u0015\u0001A\u0002\u0013\u0005!*!*\t\u0015\u00055\u0006\u00011A\u0005\u0002)\u000by\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0015BAT\u0011)\ti\f\u0001a\u0001\n\u0003Q\u0015Q\u0015\u0005\u000b\u0003\u007f\u0003\u0001\u0019!C\u0001\u0015\u0006\u0005\u0007\u0002CAc\u0001\u0001\u0006K!a*\t\u0015\u0005%\u0007A1A\u0005\u0002)\u000bY\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0011BAA\u0011\u001d\ty\r\u0001C\u0001\u0003#D\u0011\"!7\u0001\u0005\u0004%\t!!5\t\u0011\u0005}\u0007\u0001)A\u0005\u0003'D\u0011\"!9\u0001\u0005\u0004%\t!a9\t\u0011\u00055\b\u0001)A\u0005\u0003KD\u0011\"a<\u0001\u0005\u0004%\t!!=\t\u0011\u0005e\b\u0001)A\u0005\u0003gD\u0011\"a?\u0001\u0005\u0004%\t!!@\t\u0011\t-\u0001\u0001)A\u0005\u0003\u007fD!B!\u0004\u0001\u0005\u0004%\tA\u0013B\b\u0011!\u0011i\u0002\u0001Q\u0001\n\tE\u0001b\u0002B\u0010\u0001\u0011\u0005!\u0011\u0005\u0005\u000b\u0005S\u0001!\u0019!C\u0001\u0015\n\u0005\u0002\u0002\u0003B\u0016\u0001\u0001\u0006IAa\t\t\u000f\t5\u0002\u0001\"\u0011\u00030!9!q\b\u0001\u0005\u0002\t=\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0011!\u0011I\u0006\u0001C\u0001\u0015\nm\u0003b\u0002B/\u0001\u0011%!q\u0006\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u00057B\u0001B!\u001a\u0001\t\u0003Q%q\r\u0005\u000b\u0005k\u0002\u0011\u0013!C\u0001\u0015\n]\u0004B\u0003BG\u0001E\u0005I\u0011\u0001&\u0003x!Q!q\u0012\u0001\u0012\u0002\u0013\u0005!Ja\u001e\t\u000f\tE\u0005\u0001\"\u0003\u00030!A!1\u0013\u0001\u0005\u0002)\u0013)\nC\u0004\u0003\u001c\u0002!IA!(\t\u000f\t\u0015\u0006\u0001\"\u0003\u0003(\"A!1\u0017\u0001\u0005\u0002)\u0013)\f\u0003\u0006\u0003<\u0002\t\n\u0011\"\u0001K\u0005oBqA!0\u0001\t\u0013\u0011y\fC\u0004\u0003J\u0002!IAa3\t\u0013\t=\u0007!%A\u0005\n\t]\u0004\u0002\u0003Bi\u0001\u0011\u0005!Ja\f\t\u000f\tM\u0007\u0001\"\u0001\u0003V\u001e9!Q\u001c&\t\u0002\t}gAB%K\u0011\u0003\u0011\t\u000fC\u0004\u0002\u000e\u0019#\tAa<\t\u000f\tEh\t\"\u0003\u0003t\na\u0011)\u001e3ji6\u000bg.Y4fe*\u00111\nT\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\u001b:\u000b!\u0002Z;sC\nLG.\u001b;z\u0015\u0005y\u0015!B6bM.\f7\u0001A\n\u0003\u0001I\u0003\"a\u0015,\u000e\u0003QS!!\u0016(\u0002\u000bU$\u0018\u000e\\:\n\u0005]#&AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\faaY8oM&<W#\u0001.\u0011\u0005mcV\"\u0001&\n\u0005uS%!\u0006#ve\u0006\u0014\u0017\u000e\\5us\u0006+H-\u001b;D_:4\u0017nZ\u0001\bG>tg-[4!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I:\u000baa]3sm\u0016\u0014\u0018B\u00014d\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0013i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H\u000fE\u0002k[>l\u0011a\u001b\u0006\u0002Y\u0006)1oY1mC&\u0011an\u001b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018!B:u_J,'B\u0001;O\u0003\u0011!\u0018.\u001a:\n\u0005Y\f(a\u0004+jKJ|%M[3diN#xN]3\u0002\tQLW.Z\u000b\u0002sB\u0019!0a\u0002\u000e\u0003mT!!\u0016?\u000b\u0005ut\u0018AB2p[6|gN\u0003\u0002P\u007f*!\u0011\u0011AA\u0002\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QA\u0001\u0004_J<\u0017bAA\u0005w\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019a\u0014N\\5u}QQ\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0011\u0005m\u0003\u0001\"\u0002-\t\u0001\u0004Q\u0006\"B0\t\u0001\u0004\t\u0007\"\u00025\t\u0001\u0004I\u0007\"B<\t\u0001\u0004I\u0018\u0001D:uCJ$\u0018J\\:uC:$XCAA\u0010!\u0011\t\t#!\u000b\u000e\u0005\u0005\r\"bA<\u0002&)\u0011\u0011qE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005\r\"aB%ogR\fg\u000e^\u0001\u000egR\f'\u000f^%ogR\fg\u000e\u001e\u0011\u0002\u001d\u0005,H-\u001b;K_\n$\u0006N]3bIV\u0011\u00111\u0007\t\u0004u\u0006U\u0012bAA\u001cw\nY1*\u00194lCRC'/Z1e\u0003I\tW\u000fZ5u\u0015>\u0014G\u000b\u001b:fC\u0012|F%Z9\u0015\t\u0005u\u00121\t\t\u0004U\u0006}\u0012bAA!W\n!QK\\5u\u0011%\t)\u0005DA\u0001\u0002\u0004\t\u0019$A\u0002yIE\nq\"Y;eSRTuN\u0019+ie\u0016\fG\rI\u0001\rGV\u0014(/\u001a8u\u0015>\u0014\u0017\nZ\u000b\u0003\u0003\u001b\u00022A[A(\u0013\r\t\tf\u001b\u0002\u0004\u0013:$\u0018\u0001E2veJ,g\u000e\u001e&pE&#w\fJ3r)\u0011\ti$a\u0016\t\u0013\u0005\u0015s\"!AA\u0002\u00055\u0013!D2veJ,g\u000e\u001e&pE&#\u0007%\u0001\fbk\u0012LGOS8c\u0007>,h\u000e\u001e3po:d\u0015\r^2i+\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002j\u0005\u0015\u0012\u0001B;uS2LA!!\u001c\u0002d\tq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017AG1vI&$(j\u001c2D_VtG\u000fZ8x]2\u000bGo\u00195`I\u0015\fH\u0003BA\u001f\u0003gB\u0011\"!\u0012\u0013\u0003\u0003\u0005\r!a\u0018\u0002/\u0005,H-\u001b;K_\n\u001cu.\u001e8uI><h\u000eT1uG\"\u0004\u0013a\u00075jO\"<\u0016\r^3s[\u0006\u00148.\u00169eCR,'+Z9vKN$8/\u0006\u0002\u0002|AA\u0011\u0011MA?\u0003\u0003\u000bI)\u0003\u0003\u0002\u0000\u0005\r$!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u00111QAC\u001b\u0005a\u0018bAADy\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007cA.\u0002\f&\u0019\u0011Q\u0012&\u00035!Kw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3SKF,Xm\u001d;\u00029!Lw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3SKF,Xm\u001d;tA\u0005\u0011\u0012-\u001e3jiJ+\u0017/^3tiN\fV/Z;f+\t\t)\n\u0005\u0004\u0002b\u0005]\u00151T\u0005\u0005\u00033\u000b\u0019GA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4Rk\u0016,X\rE\u0002\\\u0003;K1!a(K\u0005M\tU\u000fZ5u\u001b\u0006t\u0017mZ3s%\u0016\fX/Z:u\u0003M\tW\u000fZ5u%\u0016\fX/Z:ugF+X-^3!\u0003Ia\u0017m\u001d;CCR\u001c\u0007.\u0012<f]R$\u0016.\\3\u0016\u0005\u0005\u001d\u0006c\u00016\u0002*&\u0019\u00111V6\u0003\t1{gnZ\u0001\u0017Y\u0006\u001cHOQ1uG\",e/\u001a8u)&lWm\u0018\u0013fcR!\u0011QHAY\u0011%\t)%GA\u0001\u0002\u0004\t9+A\nmCN$()\u0019;dQ\u00163XM\u001c;US6,\u0007\u0005K\u0002\u001b\u0003o\u00032A[A]\u0013\r\tYl\u001b\u0002\tm>d\u0017\r^5mK\u0006\u0019B.Y:u\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eV5nK\u00069B.Y:u\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eV5nK~#S-\u001d\u000b\u0005\u0003{\t\u0019\rC\u0005\u0002Fq\t\t\u00111\u0001\u0002(\u0006!B.Y:u\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eV5nK\u0002B3!HA\\\u0003QAW-\u00197uQ\u000eCWmY6QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011Q\u0001\u0016Q\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eU1si&$\u0018n\u001c8!\u0003\u00159W\r\u001e#C+\t\t\u0019\u000e\u0005\u0003\u0002V\u0006mWBAAl\u0015\r\tI\u000eT\u0001\u0003I\nLA!!8\u0002X\naA)\u001e:bE&d\u0017\u000e^=E\u0005\u0006\u0019AM\u0019\u0011\u0002\u001d5,GO]5dg6\u000bg.Y4feV\u0011\u0011Q\u001d\t\u0005\u0003O\fI/D\u0001M\u0013\r\tY\u000f\u0014\u0002\u0019\tV\u0014\u0018MY5mSRLX*\u001a;sS\u000e\u001cX*\u00198bO\u0016\u0014\u0018aD7fiJL7m]'b]\u0006<WM\u001d\u0011\u0002\u0011I,\u0007o\u001c:uKJ,\"!a=\u0011\u0007m\u000b)0C\u0002\u0002x*\u0013Q\"Q;eSR\u0014V\r]8si\u0016\u0014\u0018!\u0003:fa>\u0014H/\u001a:!\u0003-i\u0017\r^3sS\u0006d\u0017N_3\u0016\u0005\u0005}\b\u0003\u0002B\u0001\u0005\u000fi!Aa\u0001\u000b\u0007\t\u0015A*A\bnCR,'/[1mSj\fG/[8o\u0013\u0011\u0011IAa\u0001\u00037\u0011+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u00031i\u0017\r^3sS\u0006d\u0017N_3!\u0003-!x\u000e]5d\u0007>tg-[4\u0016\u0005\tE\u0001\u0003\u0002B\n\u00053i!A!\u0006\u000b\u0007\t]A*A\u0003u_BL7-\u0003\u0003\u0003\u001c\tU!!\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2D_:4\u0017nZ\u0001\ri>\u0004\u0018nY\"p]\u001aLw\rI\u0001\u0010O\u0016$Hk\u001c9jG6\u000bg.Y4feV\u0011!1\u0005\t\u0005\u0005'\u0011)#\u0003\u0003\u0003(\tU!A\u0006#ve\u0006\u0014\u0017\u000e\\5usR{\u0007/[2NC:\fw-\u001a:\u0002\u0019Q|\u0007/[2NC:\fw-\u001a:\u0002\u001bQ|\u0007/[2NC:\fw-\u001a:!\u0003\r\u0011XO\u001c\u000b\u0003\u0003{A3A\fB\u001a!\u0011\u0011)Da\u000f\u000e\u0005\t]\"\u0002\u0002B\u001d\u0003K\tA\u0001\\1oO&!!Q\bB\u001c\u0005!ye/\u001a:sS\u0012,\u0017A\u00023p/>\u00148\u000eK\u00020\u0005g\t1c]2iK\u0012,H.\u001a(fo\u0006+H-\u001b;K_\n$\"Aa\u0012\u0011\u0007m\u0013I%C\u0002\u0003L)\u0013\u0001\"Q;eSRTuNY\u0001\u0011S:LG/[1m\t\u0016d\u0017-\u001f#p]\u0016$BA!\u0015\u0003XA\u0019!Na\u0015\n\u0007\tU3NA\u0004C_>dW-\u00198\t\u000b]\f\u0004\u0019A=\u00023MDw.\u001e7e'\u000eDW\rZ;mK:+w/Q;eSRTuN\u0019\u000b\u0003\u0005#\nAc\u001d;pa\u0016C\u0018n\u001d;j]\u001e\fU\u000fZ5u\u0015>\u0014\u0017aF:f]\u0012,e/\u001a8u\u0005\u0006$8\r\u001b+j[\u0016\u001c\u0005.Z2l+\t\u0011\t&\u0001\u000btK:$WI^3oi\"+\u0017\r\u001c;i\u0007\",7m[\u0001\rI><vN]6BGR,\u0018\r\u001c\u000b\t\u0003{\u0011IG!\u001c\u0003r!I!1\u000e\u001c\u0011\u0002\u0003\u0007!\u0011K\u0001\u0011g\u000eDW\rZ;mK\u0006+H-\u001b;K_\nD\u0011Ba\u001c7!\u0003\u0005\rA!\u0015\u0002\u0015\u0019dWo\u001d5CCR\u001c\u0007\u000eC\u0005\u0003tY\u0002\n\u00111\u0001\u0003R\u0005YQo]3M_\u000e\fG\u000eT8h\u0003Y!wnV8sW\u0006\u001bG/^1mI\u0011,g-Y;mi\u0012\nTC\u0001B=U\u0011\u0011\tFa\u001f,\u0005\tu\u0004\u0003\u0002B@\u0005\u0013k!A!!\u000b\t\t\r%QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\"l\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0013\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fa\u0003Z8X_J\\\u0017i\u0019;vC2$C-\u001a4bk2$HEM\u0001\u0017I><vN]6BGR,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005\t\u0002O]8dKN\u001cXI^3oi\n\u000bGo\u00195\u0002+\u0019,Go\u00195Fa>\u001c\u0007.\u00134MK\u0006$WM\u001d'pOR!\u0011Q\nBL\u0011\u001d\u0011Ij\u000fa\u0001\u0003\u0003\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0007jgJ+w-[:uKJ,G\r\u0006\u0004\u0003R\t}%\u0011\u0015\u0005\b\u00053c\u0004\u0019AAA\u0011\u001d\u0011\u0019\u000b\u0010a\u0001\u0003\u001b\nQ!\u001a9pG\"\f!$[:Ti\u0006dW\rR3mKR,'+Z2pe\u0012\u0014V-];fgR$BA!\u0015\u0003*\"9!1V\u001fA\u0002\t5\u0016A\u0002:fG>\u0014H\rE\u0002\\\u0005_K1A!-K\u0005U!U\r\\3uK6+7o]1hKN\u0014V-];fgR\f\u0011b]3oI\u00163XM\u001c;\u0015\r\tE#q\u0017B]\u0011\u001d\u0011YK\u0010a\u0001\u00037C\u0011Ba\u001d?!\u0003\u0005\rA!\u0015\u0002'M,g\u000eZ#wK:$H\u0005Z3gCVdG\u000f\n\u001a\u0002#I,w-[:uKJ\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002>\t\u0005\u0007b\u0002BV\u0001\u0002\u0007!1\u0019\t\u00047\n\u0015\u0017b\u0001Bd\u0015\nA\"+Z4jgR,'\u000fU1si&$\u0018n\u001c8SKF,Xm\u001d;\u0002#\u0019dWo\u001d5SK\u000e|'\u000fZ:Rk\u0016,X\r\u0006\u0003\u0002>\t5\u0007\"\u0003B:\u0003B\u0005\t\u0019\u0001B)\u0003m1G.^:i%\u0016\u001cwN\u001d3t#V,W/\u001a\u0013eK\u001a\fW\u000f\u001c;%c\u000591\r\\3b]V\u0004\u0018aD4fiF+X-^3e\u000bZ,g\u000e^:\u0016\u0005\t]\u0007c\u00026\u0003Z\u00065\u0013qU\u0005\u0004\u00057\\'A\u0002+va2,''\u0001\u0007Bk\u0012LG/T1oC\u001e,'\u000f\u0005\u0002\\\rN)aIa9\u0003jB\u0019!N!:\n\u0007\t\u001d8N\u0001\u0004B]f\u0014VM\u001a\t\u00047\n-\u0018b\u0001Bw\u0015\n\t\u0012)\u001e3ji6\u000bg.Y4feR\u0013\u0018-\u001b;\u0015\u0005\t}\u0017\u0001D4fi\u0012\u000b\u0017p\u00144ZK\u0006\u0014H\u0003BA'\u0005kDQa\u001e%A\u0002e\u0004")
public class AuditManager
extends ShutdownableThread {
    private final DurabilityAuditConfig config;
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Time time;
    private final Instant startInstant;
    private KafkaThread auditJobThread;
    private int currentJobId;
    private CountDownLatch auditJobCountdownLatch;
    private final ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests;
    private final LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue;
    private volatile long lastBatchEventTime;
    private volatile long lastHealthCheckTime;
    private final TopicPartition healthCheckPartition;
    private final DurabilityDB db;
    private final DurabilityMetricsManager metricsManager;
    private final AuditReporter reporter;
    private final DurabilityEventsMaterialize materialize;
    private final DurabilityTopicConfig topicConfig;
    private final DurabilityTopicManager topicManager;

    public static void submitAuditRequest(AuditManagerRequest auditManagerRequest) {
        AuditManager$.MODULE$.submitAuditRequest(auditManagerRequest);
    }

    public static boolean stopAuditManager$default$1() {
        return AuditManager$.MODULE$.stopAuditManager$default$1();
    }

    public static void stopAuditManager(boolean bl) {
        AuditManager$.MODULE$.stopAuditManager(bl);
    }

    public static void startAuditManager() {
        AuditManager$.MODULE$.startAuditManager();
    }

    public static Option<AuditManager> initialize(DurabilityAuditConfig durabilityAuditConfig, ReplicaManager replicaManager, Option<TierObjectStore> option, Time time) {
        return AuditManager$.MODULE$.initialize(durabilityAuditConfig, replicaManager, option, time);
    }

    public static ConcurrentHashMap<TopicPartition, RegisterPartitionRequest> pendingRegistration() {
        return AuditManager$.MODULE$.pendingRegistration();
    }

    public static void instance_$eq(AuditManager auditManager) {
        AuditManager$.MODULE$.instance_$eq(auditManager);
    }

    public static AuditManager instance() {
        return AuditManager$.MODULE$.instance();
    }

    public DurabilityAuditConfig config() {
        return this.config;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Time time() {
        return this.time;
    }

    private Instant startInstant() {
        return this.startInstant;
    }

    private KafkaThread auditJobThread() {
        return this.auditJobThread;
    }

    private void auditJobThread_$eq(KafkaThread x$1) {
        this.auditJobThread = x$1;
    }

    public int currentJobId() {
        return this.currentJobId;
    }

    public void currentJobId_$eq(int x$1) {
        this.currentJobId = x$1;
    }

    public CountDownLatch auditJobCountdownLatch() {
        return this.auditJobCountdownLatch;
    }

    public void auditJobCountdownLatch_$eq(CountDownLatch x$1) {
        this.auditJobCountdownLatch = x$1;
    }

    public ConcurrentHashMap<TopicPartition, HighWatermarkUpdateRequest> highWatermarkUpdateRequests() {
        return this.highWatermarkUpdateRequests;
    }

    public LinkedBlockingQueue<AuditManagerRequest> auditRequestsQueue() {
        return this.auditRequestsQueue;
    }

    public long lastBatchEventTime() {
        return this.lastBatchEventTime;
    }

    public void lastBatchEventTime_$eq(long x$1) {
        this.lastBatchEventTime = x$1;
    }

    public long lastHealthCheckTime() {
        return this.lastHealthCheckTime;
    }

    public void lastHealthCheckTime_$eq(long x$1) {
        this.lastHealthCheckTime = x$1;
    }

    public TopicPartition healthCheckPartition() {
        return this.healthCheckPartition;
    }

    public DurabilityDB getDB() {
        return DurabilityDB$.MODULE$.apply(this.config().dbPath());
    }

    public DurabilityDB db() {
        return this.db;
    }

    public DurabilityMetricsManager metricsManager() {
        return this.metricsManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public DurabilityEventsMaterialize materialize() {
        return this.materialize;
    }

    public DurabilityTopicConfig topicConfig() {
        return this.topicConfig;
    }

    public DurabilityTopicManager getTopicManager() {
        return new DurabilityTopicManager(this.topicConfig(), this.db(), this.materialize(), this.config().zkSupplier(), DurabilityTopicManager$.MODULE$.$lessinit$greater$default$5());
    }

    public DurabilityTopicManager topicManager() {
        return this.topicManager;
    }

    @Override
    public void run() {
        this.topicManager().start();
        super.run();
    }

    @Override
    public void doWork() {
        this.doWorkActual(true, this.doWorkActual$default$2(), this.doWorkActual$default$3());
        this.pause(DurabilityAuditConstants$.MODULE$.DURABILITY_JOB_LOOP_WAIT_MS(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private AuditJob scheduleNewAuditJob() {
        void var3_3;
        this.stopExistingAuditJob();
        int newJobId = AuditManager$.MODULE$.kafka$durability$audit$AuditManager$$getDayOfYear(this.time());
        int oldJobId = this.reporter().resetJob(newJobId);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Going to schedule new AuditJob, (").append(oldJobId).append(" -> ").append(newJobId).append(")").toString());
        this.auditJobCountdownLatch_$eq(new CountDownLatch(1));
        this.currentJobId_$eq(newJobId);
        AuditJob auditJob = new AuditJob(this.db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), this.auditJobCountdownLatch(), this.reporter(), this.currentJobId(), this.tierObjectStoreOpt, this.time());
        this.auditJobThread_$eq(KafkaThread.nonDaemon((String)new StringBuilder(9).append("AuditJob-").append(this.currentJobId()).toString(), (Runnable)auditJob));
        this.auditJobThread().start();
        return var3_3;
    }

    private boolean initialDelayDone(Time time) {
        Instant now = Instant.ofEpochMilli(time.milliseconds());
        return Duration.between(this.startInstant(), now).toMillis() > this.config().initialAuditJobDelayMs() && this.db().getTopicPartitionsForAudit().nonEmpty();
    }

    public boolean shouldScheduleNewAuditJob() {
        boolean bl;
        KafkaThread existingThread;
        Option option = Option$.MODULE$.apply((Object)this.auditJobThread());
        if (option instanceof Some && (existingThread = (KafkaThread)((Some)option).value()).isAlive() && !existingThread.isInterrupted()) {
            bl = false;
        } else {
            int currDay = AuditManager$.MODULE$.kafka$durability$audit$AuditManager$$getDayOfYear(this.time());
            bl = this.auditJobCountdownLatch().getCount() == 0L && (currDay > this.currentJobId() || currDay == 1 && this.currentJobId() >= 365) && this.initialDelayDone(this.time());
        }
        return bl;
    }

    private void stopExistingAuditJob() {
        if (this.auditJobThread() != null && this.auditJobThread().isAlive()) {
            this.auditJobCountdownLatch().countDown();
            this.auditJobThread().interrupt();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("AuditManager cancelled AuditJob with jobId: ").append(this.currentJobId()).toString());
        }
    }

    private boolean sendEventBatchTimeCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastBatchEventTime() >= this.config().batchEventFlushFrequencyMs()) {
            this.lastBatchEventTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    private boolean sendEventHealthCheck() {
        long currentTimeMs = this.time().milliseconds();
        if (currentTimeMs - this.lastHealthCheckTime() >= DurabilityAuditConstants$.MODULE$.HEALTH_CHECK_UPDATE_TIME_MS()) {
            this.lastHealthCheckTime_$eq(currentTimeMs);
            return true;
        }
        return false;
    }

    public void doWorkActual(boolean scheduleAuditJob, boolean flushBatch, boolean useLocalLog) {
        if (scheduleAuditJob && this.shouldScheduleNewAuditJob()) {
            this.scheduleNewAuditJob();
        }
        if (this.sendEventHealthCheck()) {
            AuditManager$.MODULE$.submitAuditRequest(new HealthCheckRequest(this.healthCheckPartition(), -1, this.topicConfig().brokerId(), this.time().milliseconds()));
        }
        if (this.sendEventBatchTimeCheck() || flushBatch) {
            this.processEventBatch();
            return;
        }
        this.flushRecordsQueue(useLocalLog);
    }

    public boolean doWorkActual$default$1() {
        return false;
    }

    public boolean doWorkActual$default$2() {
        return false;
    }

    public boolean doWorkActual$default$3() {
        return true;
    }

    private void processEventBatch() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Process batchedRequest, auditRequest queue size is ").append(this.highWatermarkUpdateRequests().size()).toString());
        HashMap<TopicPartition, HighWatermarkUpdateRequest> snapshot = new HashMap<TopicPartition, HighWatermarkUpdateRequest>(this.highWatermarkUpdateRequests());
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int size = this.auditRequestsQueue().size(); size > 0 && record != null; --size) {
            if (this.sendEvent(record, this.sendEvent$default$2())) {
                snapshot.remove(record.topicPartition());
            }
            record = this.auditRequestsQueue().poll();
        }
        snapshot.forEach((x0$1, x1$1) -> {
            TopicPartition topicPartition = x0$1;
            HighWatermarkUpdateRequest record = x1$1;
            if (this.isRegistered(record.topicPartition(), record.epoch())) {
                this.topicManager().addDurabilityEvent(OffsetChangeEvent$.MODULE$.apply(topicPartition, record.epoch(), record.hwm(), record.startOffset(), record.isr()));
            }
            this.highWatermarkUpdateRequests().remove(topicPartition);
        });
        snapshot.clear();
        this.db().checkpoint();
    }

    public int fetchEpochIfLeaderLog(TopicPartition topicPartition) {
        return Utils$.MODULE$.getLocalReplicaEpochIfLeader(this.replicaManager(), topicPartition);
    }

    private boolean isRegistered(TopicPartition topicPartition, int epoch) {
        boolean bl;
        PartitionState state;
        Option<PartitionState> option = this.db().fetchPartitionState(topicPartition);
        if (option instanceof Some && (state = (PartitionState)((Some)option).value()).isLeader() && (state.latestLocalEpoch() == epoch || epoch == -1)) {
            bl = true;
        } else {
            boolean bl2;
            int localEpoch = this.fetchEpochIfLeaderLog(topicPartition);
            if (localEpoch == -1 || localEpoch > epoch) {
                bl2 = false;
            } else {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Durability registration for ").append(topicPartition).append(" was found missing, recovering for epoch ").append(epoch).append(" localEpoch ").append(localEpoch).toString());
                this.registerPartition(new RegisterPartitionRequest(topicPartition, localEpoch, true));
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    private boolean isStaleDeleteRecordRequest(DeleteMessagesRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicPartition());
        boolean bl = !(option instanceof Some) || ((PartitionState)((Some)option).value()).committedStartOffset() >= record.trimOffset();
        return bl;
    }

    public boolean sendEvent(AuditManagerRequest record, boolean useLocalLog) {
        boolean bl;
        DeletePartitionRequest deletePartitionRequest;
        DeleteMessagesRequest deleteMessagesRequest;
        ISRExpandRequest iSRExpandRequest;
        RetentionConfigChangeRequest retentionConfigChangeRequest;
        EpochChangeRequest epochChangeRequest;
        None$ none$;
        StartOffsetChangeRequest startOffsetChangeRequest;
        if (record instanceof StartOffsetChangeRequest && this.isRegistered((startOffsetChangeRequest = (StartOffsetChangeRequest)record).topicPartition(), startOffsetChangeRequest.epoch())) {
            Object object;
            Option<Set<Object>> option = Utils$.MODULE$.getIsrIfLeaderPartition(this.replicaManager(), startOffsetChangeRequest.topicPartition());
            if (option instanceof Some) {
                Set isr = (Set)((Some)option).value();
                object = new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)isr));
            } else {
                object = !useLocalLog ? new Some((Object)StartOffsetChangeEvent$.MODULE$.apply(startOffsetChangeRequest.topicPartition(), startOffsetChangeRequest.epoch(), startOffsetChangeRequest.highWatermark(), startOffsetChangeRequest.startOffset(), (byte)startOffsetChangeRequest.retentionType().id(), startOffsetChangeRequest.retentionValue(), (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))))) : None$.MODULE$;
            }
            none$ = object;
        } else if (record instanceof EpochChangeRequest && this.isRegistered((epochChangeRequest = (EpochChangeRequest)record).topicPartition(), -1)) {
            none$ = new Some((Object)EpochChangeEvent$.MODULE$.apply(epochChangeRequest.topicPartition(), epochChangeRequest.firstOffset(), epochChangeRequest.epoch(), epochChangeRequest.highWaterMark(), epochChangeRequest.startOffset(), epochChangeRequest.isr()));
        } else if (record instanceof RetentionConfigChangeRequest && this.isRegistered((retentionConfigChangeRequest = (RetentionConfigChangeRequest)record).topicPartition(), retentionConfigChangeRequest.epoch())) {
            none$ = new Some((Object)RetentionChangeEvent$.MODULE$.apply(retentionConfigChangeRequest.topicPartition(), retentionConfigChangeRequest.retentionMs(), retentionConfigChangeRequest.retentionSz(), retentionConfigChangeRequest.epoch(), -1L, -1L));
        } else if (record instanceof ISRExpandRequest && this.isRegistered((iSRExpandRequest = (ISRExpandRequest)record).topicPartition(), iSRExpandRequest.epoch())) {
            none$ = new Some((Object)IsrExpandEvent$.MODULE$.apply(iSRExpandRequest.topicPartition(), iSRExpandRequest.brokerId(), iSRExpandRequest.epoch(), -1L, -1L));
        } else if (record instanceof DeleteMessagesRequest && this.isRegistered((deleteMessagesRequest = (DeleteMessagesRequest)record).topicPartition(), deleteMessagesRequest.epoch()) && !this.isStaleDeleteRecordRequest(deleteMessagesRequest)) {
            none$ = new Some((Object)DeleteRecordsEvent$.MODULE$.apply(deleteMessagesRequest.topicPartition(), deleteMessagesRequest.trimOffset(), deleteMessagesRequest.epoch(), deleteMessagesRequest.highWatermark(), deleteMessagesRequest.startOffset(), deleteMessagesRequest.isr()));
        } else if (record instanceof DeletePartitionRequest && this.isRegistered((deletePartitionRequest = (DeletePartitionRequest)record).topicPartition(), deletePartitionRequest.epoch())) {
            none$ = new Some((Object)DeletePartitionEvent$.MODULE$.apply(deletePartitionRequest.topicPartition(), deletePartitionRequest.epoch()));
        } else if (record instanceof HealthCheckRequest) {
            HealthCheckRequest healthCheckRequest = (HealthCheckRequest)record;
            none$ = new Some((Object)HealthCheckEvent$.MODULE$.apply(healthCheckRequest.topicPartition(), CurrentVersion$.MODULE$.version(), healthCheckRequest.epoch(), -1L, -1L, healthCheckRequest.brokerId(), healthCheckRequest.timeStamp()));
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Rejected record for sending as event ").append(record).append(", ignoring").toString());
            none$ = None$.MODULE$;
        }
        if (none$ instanceof Some) {
            AbstractDurabilityEvent e = (AbstractDurabilityEvent)((Some)none$).value();
            this.topicManager().addDurabilityEvent(e);
            this.highWatermarkUpdateRequests().remove(record.topicPartition());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean sendEvent$default$2() {
        return true;
    }

    private void registerPartition(RegisterPartitionRequest record) {
        Option<PartitionState> option = this.db().fetchPartitionState(record.topicPartition());
        if (option instanceof Some) {
            PartitionState state = (PartitionState)((Some)option).value();
            if (state.latestLocalEpoch() >= record.epoch()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Durability Registration event from stale/registered replica for ").append(record.topicPartition()).append(" for ").append(record.epoch()).append(" with leader flag set to ").append(record.isLeader()).append(". The existing db state is ").append(state).toString());
                return;
            }
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        PartitionState state = (PartitionState)this.db().fetchPartitionState(record.topicPartition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> PartitionState$.MODULE$.apply(record.topicPartition().partition()));
        state.latestLocalEpoch_$eq(record.epoch());
        state.isLeader_$eq(record.isLeader());
        this.db().addPartition(record.topicPartition(), state);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Durability registration for ").append(record.topicPartition()).append(" ").append(record.epoch()).append(" ").append(record.isLeader()).append(" is done.").toString());
    }

    private void flushRecordsQueue(boolean useLocalLog) {
        AuditManagerRequest record = this.auditRequestsQueue().poll();
        for (int count = 0; record != null && count < DurabilityAuditConstants$.MODULE$.MAX_EVENT_PER_LOOP(); ++count) {
            if (record instanceof RegisterPartitionRequest) {
                RegisterPartitionRequest registerPartitionRequest = (RegisterPartitionRequest)record;
                this.registerPartition(registerPartitionRequest);
            } else if (record instanceof DeletePartitionRequest) {
                DeletePartitionRequest deletePartitionRequest = (DeletePartitionRequest)record;
                this.sendEvent(deletePartitionRequest, useLocalLog);
            } else {
                this.sendEvent(record, useLocalLog);
            }
            record = this.auditRequestsQueue().poll();
        }
    }

    private boolean flushRecordsQueue$default$1() {
        return true;
    }

    public void cleanup() {
        try {
            this.stopExistingAuditJob();
            this.processEventBatch();
            this.flushRecordsQueue(this.flushRecordsQueue$default$1());
            this.topicManager().shutdown();
            this.metricsManager().shutdown();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "AuditManager cleanup complete");
            return;
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received error while cleaning up AuditManager", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public Tuple2<Object, Object> getQueuedEvents() {
        return new Tuple2.mcIJ.sp(this.auditRequestsQueue().size(), (long)this.highWatermarkUpdateRequests().size());
    }

    public AuditManager(DurabilityAuditConfig config, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time) {
        this.config = config;
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.time = time;
        super("AuditManager", true);
        this.startInstant = Instant.ofEpochMilli(time.milliseconds());
        this.currentJobId = 0;
        this.auditJobCountdownLatch = new CountDownLatch(0);
        this.highWatermarkUpdateRequests = new ConcurrentHashMap();
        this.auditRequestsQueue = new LinkedBlockingQueue(DurabilityAuditConstants$.MODULE$.DURABILITY_RECORD_MAX_QUEUE_SIZE());
        this.lastBatchEventTime = time.milliseconds();
        this.lastHealthCheckTime = time.milliseconds();
        this.healthCheckPartition = new TopicPartition("durability-health-check", 0);
        this.db = this.getDB();
        this.metricsManager = DurabilityMetricsManager$.MODULE$.apply(Integer.toString(config.brokerId()), config.metrics(), time, config.reportingBatchMs());
        this.reporter = AuditReporter$.MODULE$.apply(this.metricsManager());
        this.materialize = new DurabilityEventsMaterialize(replicaManager, this.db(), this.reporter(), time);
        this.topicConfig = new DurabilityTopicConfig(config.interBrokerClientConfigs(), DurabilityAuditConstants$.MODULE$.TOPIC_NAME(), config.topicPartitionCount(), config.topicReplicationFactor(), config.brokerId(), config.clusterId(), DurabilityAuditConstants$.MODULE$.DURABILITY_CONSUMER_POLL_DURATION_MS(), Predef$.MODULE$.int2Integer(DurabilityAuditConstants$.MODULE$.DURABILITY_PRODUCER_REQUEST_TIMEOUT_MS()), DurabilityAuditConstants$.MODULE$.DURABILITY_TOPIC_RETENTION_MS());
        this.topicManager = this.getTopicManager();
    }
}

