/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.audit;

import java.io.Serializable;
import kafka.Kafka$;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.SegmentOffsetMap;
import kafka.durability.audit.SegmentRange;
import kafka.durability.audit.SegmentRange$;
import kafka.durability.materialization.DurabilityLapseType$;
import org.apache.kafka.common.TopicPartition;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\f\u0018\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!Ia\u000b\u0005\b_\u0001\u0001\r\u0011\"\u00031\u0011\u001d!\u0004\u00011A\u0005\nUBaa\u000f\u0001!B\u0013\t\u0004b\u0002\u001f\u0001\u0005\u0004%I!\u0010\u0005\u0007/\u0002\u0001\u000b\u0011\u0002 \t\u000fa\u0003!\u0019!C\u00053\"1Q\f\u0001Q\u0001\niCQA\u0018\u0001\u0005\u0002}Cq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u0011\u0010\u0003\u0004_\u0001\u0011\u0005\u0011\u0011\u0002\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011%\t9\u0005AI\u0001\n\u0003\tI\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011\u0011\r\u0001\u0005\u0002\u0005\rtaBA5/!\u0005\u00111\u000e\u0004\u0007-]A\t!!\u001c\t\r)\u001aB\u0011AA8\u0011\u001d\t\th\u0005C\u0001\u0003g\u0012Q\"Q;eSR\u0014V\r]8si\u0016\u0014(B\u0001\r\u001a\u0003\u0015\tW\u000fZ5u\u0015\tQ2$\u0001\u0006ekJ\f'-\u001b7jifT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u000e[\u0016$(/[2NC:\fw-\u001a:\u0011\u0005\u001dBS\"A\r\n\u0005%J\"\u0001\u0007#ve\u0006\u0014\u0017\u000e\\5us6+GO]5dg6\u000bg.Y4fe\u00061A(\u001b8jiz\"\"\u0001\f\u0018\u0011\u00055\u0002Q\"A\f\t\u000b\u0015\u0012\u0001\u0019\u0001\u0014\u0002\u000b)|'-\u00133\u0016\u0003E\u0002\"\u0001\t\u001a\n\u0005M\n#aA%oi\u0006I!n\u001c2JI~#S-\u001d\u000b\u0003me\u0002\"\u0001I\u001c\n\u0005a\n#\u0001B+oSRDqA\u000f\u0003\u0002\u0002\u0003\u0007\u0011'A\u0002yIE\naA[8c\u0013\u0012\u0004\u0013AC:d_JLgnZ'baV\ta\b\u0005\u0003@\t\u001a\u000bV\"\u0001!\u000b\u0005\u0005\u0013\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0007\u0006\n!bY8mY\u0016\u001cG/[8o\u0013\t)\u0005IA\u0004ICNDW*\u00199\u0011\u0005\u001d{U\"\u0001%\u000b\u0005%S\u0015AB2p[6|gN\u0003\u0002\u001d\u0017*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0013\t\u0001\u0006J\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0001\u0012F\u000bV\u0005\u0003'\u0006\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u0011V\u0013\t1\u0016E\u0001\u0003M_:<\u0017aC:d_JLgnZ'ba\u0002\n\u0001c]3h[\u0016tGo\u00144gg\u0016$X*\u00199\u0016\u0003i\u0003\"!L.\n\u0005q;\"\u0001E*fO6,g\u000e^(gMN,G/T1q\u0003E\u0019XmZ7f]R|eMZ:fi6\u000b\u0007\u000fI\u0001\u0016e\u0016\u0004xN\u001d;EkJ\f'-\u001b7jifd\u0015\r]:f)\u00191\u0004M\u00193gg\")\u0011M\u0003a\u0001\r\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\"B2\u000b\u0001\u0004!\u0016aC:uCJ$xJ\u001a4tKRDQ!\u001a\u0006A\u0002Q\u000b\u0011\u0002\\8tg\u000e{WO\u001c;\t\u000b\u001dT\u0001\u0019\u00015\u0002\u00075\u001cx\r\u0005\u0002ja:\u0011!N\u001c\t\u0003W\u0006j\u0011\u0001\u001c\u0006\u0003[v\ta\u0001\u0010:p_Rt\u0014BA8\"\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\f\u0003b\u0002;\u000b!\u0003\u0005\r!^\u0001\u0006g\u000e|'/\u001a\t\u0003AYL!a^\u0011\u0003\u000f\t{w\u000e\\3b]\u0006y\"/\u001a9peR$UO]1cS2LG/\u001f'baN,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0003iT#!^>,\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007\t\u0013AC1o]>$\u0018\r^5p]&\u0019\u0011q\u0001@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rF\u00077\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0012Q\u0007\u0005\u0006C2\u0001\rA\u0012\u0005\u0006G2\u0001\r\u0001\u0016\u0005\u0006K2\u0001\r\u0001\u0016\u0005\b\u0003'a\u0001\u0019AA\u000b\u0003%a\u0017\r]:f)f\u0004X\r\u0005\u0003\u0002\u0018\u00055b\u0002BA\r\u0003OqA!a\u0007\u0002$9!\u0011QDA\u0011\u001d\rY\u0017qD\u0005\u00029%\u0011!dG\u0005\u0004\u0003KI\u0012aD7bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\t\u0005%\u00121F\u0001\u0014\tV\u0014\u0018MY5mSRLH*\u00199tKRK\b/\u001a\u0006\u0004\u0003KI\u0012\u0002BA\u0018\u0003c\u00111\u0003R;sC\nLG.\u001b;z\u0019\u0006\u00048/\u001a+za\u0016TA!!\u000b\u0002,!)q\r\u0004a\u0001Q\")A\u000f\u0004a\u0001k\u0006)\"/\u001a9peR$UO]1cS2LG/_!vI&$H#\u0003\u001c\u0002<\u0005u\u0012qHA\"\u0011\u0015yS\u00021\u00012\u0011\u0015\tW\u00021\u0001G\u0011\u0019\t\t%\u0004a\u0001)\u0006AAo\u001c;bY6\u001bx\r\u0003\u0005\u0002F5\u0001\n\u00111\u0001U\u0003)!x\u000e^1m\u0019\u0006\u00048/Z\u0001 e\u0016\u0004xN\u001d;EkJ\f'-\u001b7jif\fU\u000fZ5uI\u0011,g-Y;mi\u0012\"TCAA&U\t!60A\tva\u0012\fG/\u001a%fC2$\bn\u00115fG.$RANA)\u0003+Ba!a\u0015\u0010\u0001\u0004A\u0017!\u00032s_.,'o\u0015:d\u0011\u0019\t9f\u0004a\u0001)\u0006IA/[7f'R\fW\u000e]\u0001\u0016O\u0016$H)\u001e:bE&d\u0017\u000e^=D_VtG/\u001a:t)\r\t\u0016Q\f\u0005\u0007\u0003?\u0002\u0002\u0019\u0001$\u0002\u0005%$\u0017\u0001\u0003:fg\u0016$(j\u001c2\u0015\u0007E\n)\u0007\u0003\u0004\u0002hE\u0001\r!M\u0001\t]\u0016<(j\u001c2JI\u0006i\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\u0004\"!L\n\u0014\u0005MyBCAA6\u0003\u0015\t\u0007\u000f\u001d7z)\ra\u0013Q\u000f\u0005\u0006KU\u0001\rA\n")
public class AuditReporter {
    private final DurabilityMetricsManager metricManager;
    private int jobId;
    private final HashMap<TopicPartition, Tuple2<Object, Object>> scoringMap;
    private final SegmentOffsetMap segmentOffsetMap;

    public static AuditReporter apply(DurabilityMetricsManager durabilityMetricsManager) {
        return AuditReporter$.MODULE$.apply(durabilityMetricsManager);
    }

    private int jobId() {
        return this.jobId;
    }

    private void jobId_$eq(int x$1) {
        this.jobId = x$1;
    }

    private HashMap<TopicPartition, Tuple2<Object, Object>> scoringMap() {
        return this.scoringMap;
    }

    private SegmentOffsetMap segmentOffsetMap() {
        return this.segmentOffsetMap;
    }

    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, String msg, boolean score) {
        this.reportDurabilityLapse(topicPartition, startOffset, lossCount, DurabilityLapseType$.MODULE$.OtherCustomerFacing(), msg, score);
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityLapse(TopicPartition topicPartition, long startOffset, long lossCount, Enumeration.Value lapseType, String msg, boolean score) {
        void var12_11;
        void var11_10;
        Enumeration.Value value = lapseType;
        Enumeration.Value value2 = DurabilityLapseType$.MODULE$.ChecksumValidation();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            Kafka$ kafka$ = Kafka$.MODULE$;
            if (kafka$ == null) {
                throw null;
            }
            Kafka$ error_this = kafka$;
            if (error_this.logger().underlying().isErrorEnabled()) {
                error_this.logger().underlying().error(error_this.msgWithLogIdent(msg));
            }
            this.metricManager.reportDurabilityLoss(lapseType, lossCount);
            return;
        }
        Tuple2<Object, Object> tuple2 = this.segmentOffsetMap().insert(topicPartition, new SegmentRange(startOffset, startOffset + lossCount - 1L, this.jobId(), SegmentRange$.MODULE$.apply$default$4()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean reportAlert = tuple2._1$mcZ$sp();
        boolean reportLapse = tuple2._2$mcZ$sp();
        if (var11_10 != false) {
            Kafka$ kafka$ = Kafka$.MODULE$;
            if (kafka$ == null) {
                throw null;
            }
            Kafka$ error_this = kafka$;
            if (error_this.logger().underlying().isErrorEnabled()) {
                error_this.logger().underlying().error(error_this.msgWithLogIdent(msg));
            }
            this.metricManager.reportDurabilityLoss(lapseType, lossCount);
        }
        if (var12_11 != false) {
            Kafka$ kafka$ = Kafka$.MODULE$;
            if (kafka$ == null) {
                throw null;
            }
            Kafka$ warn_this = kafka$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(AuditReporter.$anonfun$reportDurabilityLapse$3(msg)));
            }
            if (score) {
                if (this.scoringMap().contains((Object)topicPartition)) {
                    void var16_16;
                    void var14_15;
                    Tuple2 tuple22 = (Tuple2)this.scoringMap().apply((Object)topicPartition);
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    long total = tuple22._1$mcJ$sp();
                    long lapse = tuple22._2$mcJ$sp();
                    this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp((long)var14_15, (long)(var16_16 + lossCount)));
                    return;
                }
                this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp(0L, lossCount));
                return;
            }
        }
    }

    public boolean reportDurabilityLapse$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void reportDurabilityAudit(int jobId, TopicPartition topicPartition, long totalMsg, long totalLapse) {
        long l;
        if (this.scoringMap().contains((Object)topicPartition)) {
            void var8_6;
            Tuple2 tuple2 = (Tuple2)this.scoringMap().apply((Object)topicPartition);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long lapse = tuple2._2$mcJ$sp();
            this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp(totalMsg, (long)(var8_6 + totalLapse)));
            l = var8_6 + totalLapse;
        } else {
            this.scoringMap().put((Object)topicPartition, (Object)new Tuple2.mcJJ.sp(totalMsg, totalLapse));
            l = totalLapse;
        }
        long l2 = l;
        this.metricManager.updateStats(topicPartition, new DurabilityStats(totalMsg, l2));
    }

    public long reportDurabilityAudit$default$4() {
        return 0L;
    }

    public void updateHealthCheck(String brokerSrc, long timeStamp) {
        this.metricManager.updateHealthCheck(brokerSrc, timeStamp);
    }

    public Tuple2<Object, Object> getDurabilityCounters(TopicPartition id) {
        return (Tuple2)this.scoringMap().getOrElse((Object)id, (Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcJJ.sp(0L, 0L));
    }

    /*
     * WARNING - void declaration
     */
    public int resetJob(int newJobId) {
        void var2_2;
        int old = this.jobId();
        this.jobId_$eq(newJobId);
        this.metricManager.resetDurabilityRunSpan(newJobId);
        this.scoringMap().clear();
        return (int)var2_2;
    }

    public static final /* synthetic */ String $anonfun$reportDurabilityLapse$3(String msg$1) {
        return new StringBuilder(10).append("Potential ").append(msg$1).toString();
    }

    public AuditReporter(DurabilityMetricsManager metricManager) {
        this.metricManager = metricManager;
        this.jobId = -1;
        this.scoringMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.segmentOffsetMap = new SegmentOffsetMap();
    }
}

