/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.Deserializer$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.HealthCheckEvent;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.OffsetChangeEvent;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.Validator;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\f\u0019\u0001}A\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011)\u0019!C\u0001i!A!\b\u0001B\u0001B\u0003%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\"B(\u0001\t\u0003\u0001\u0006\u0002C,\u0001\u0005\u0004%\t\u0001\u0007-\t\rq\u0003\u0001\u0015!\u0003Z\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0019\u0011\b\u0001\"\u0001\u0019g\"A\u00111\u0001\u0001\u0005\u0002a\t)\u0001\u0003\u0005\u0002\u0014\u0001!\t\u0001GA\u000b\u0011)\ti\u0006AI\u0001\n\u0003A\u0012q\f\u0005\b\u0003k\u0002A\u0011BA<\u0011%\ti\tAI\u0001\n\u0013\ty\t\u0003\u0005\u0002\u0014\u0002!\t\u0001GAK\u0011)\ty\nAI\u0001\n\u0003A\u0012q\f\u0005\t\u0003C\u0003A\u0011\u0001\r\u0002$\"A\u0011\u0011\u0017\u0001\u0005\u0002a\t\u0019\f\u0003\u0005\u0002B\u0002!\t\u0001GAb\u0011!\t\t\u000e\u0001C\u00011\u0005M\u0007\u0002CAo\u0001\u0011\u0005\u0001$a8\u00037\u0011+(/\u00192jY&$\u00180\u0012<f]R\u001cX*\u0019;fe&\fG.\u001b>f\u0015\tI\"$A\bnCR,'/[1mSj\fG/[8o\u0015\tYB$\u0001\u0006ekJ\f'-\u001b7jifT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%b\u0012!B;uS2\u001c\u0018BA\u0016)\u0005\u001daunZ4j]\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002/c5\tqF\u0003\u000219\u000511/\u001a:wKJL!AM\u0018\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0011AMY\u000b\u0002kA\u0011a\u0007O\u0007\u0002o)\u00111GG\u0005\u0003s]\u0012A\u0002R;sC\nLG.\u001b;z\t\n\u000b1\u0001\u001a2!\u0003!\u0011X\r]8si\u0016\u0014\bCA\u001fA\u001b\u0005q$BA \u001b\u0003\u0015\tW\u000fZ5u\u0013\t\teHA\u0007Bk\u0012LGOU3q_J$XM]\u0001\u0005i&lW\r\u0005\u0002E\u001b6\tQI\u0003\u0002*\r*\u0011q\tS\u0001\u0007G>lWn\u001c8\u000b\u0005uI%B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!AT#\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bE\u001bF+\u0016,\u0011\u0005I\u0003Q\"\u0001\r\t\u000b12\u0001\u0019A\u0017\t\u000bM2\u0001\u0019A\u001b\t\u000bm2\u0001\u0019\u0001\u001f\t\u000b\t3\u0001\u0019A\"\u0002\u0013Y\fG.\u001b3bi>\u0014X#A-\u0011\u0005IS\u0016BA.\u0019\u0005%1\u0016\r\\5eCR|'/\u0001\u0006wC2LG-\u0019;pe\u0002\n1\"\\1uKJL\u0017\r\\5{KR\u0011qL\u0019\t\u0003C\u0001L!!\u0019\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006G&\u0001\r\u0001Z\u0001\u0007e\u0016\u001cwN\u001d3\u0011\t\u0015TG\u000e\\\u0007\u0002M*\u0011q\r[\u0001\tG>t7/^7fe*\u0011\u0011\u000eS\u0001\bG2LWM\u001c;t\u0013\tYgM\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u0007\u0005jw.\u0003\u0002oE\t)\u0011I\u001d:bsB\u0011\u0011\u0005]\u0005\u0003c\n\u0012AAQ=uK\u0006aR.\u0019;fe&\fG.\u001b>f\u001f\u001a47/\u001a;DQ\u0006tw-Z#wK:$HcA0uy\")QO\u0003a\u0001m\u0006)QM^3oiB\u0011qO_\u0007\u0002q*\u0011\u0011PG\u0001\u0007KZ,g\u000e^:\n\u0005mD(!E(gMN,Go\u00115b]\u001e,WI^3oi\")QP\u0003a\u0001}\u0006)1\u000f^1uKB\u0011ag`\u0005\u0004\u0003\u00039$A\u0004)beRLG/[8o'R\fG/Z\u0001\u001d[\u0006$XM]5bY&TX\rR3mKR,'+Z2pe\u0012,e/\u001a8u)\u0015y\u0016qAA\t\u0011\u001d\tIa\u0003a\u0001\u0003\u0017\t!\u0003Z3mKR,'+Z2pe\u0012\u001cXI^3oiB\u0019q/!\u0004\n\u0007\u0005=\u0001P\u0001\nEK2,G/\u001a*fG>\u0014Hm]#wK:$\b\"B?\f\u0001\u0004q\u0018aH7bi\u0016\u0014\u0018.\u00197ju\u0016D\u0015n\u001a5XCR,'/\\1sW\u000eC\u0017M\\4fgRiq,a\u0006\u0002$\u00055\u0012qGA)\u0003'Bq!!\u0007\r\u0001\u0004\tY\"\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005u\u0011qD\u0007\u0002\r&\u0019\u0011\u0011\u0005$\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011Q\u0005\u0007A\u0002\u0005\u001d\u0012!B3q_\u000eD\u0007cA\u0011\u0002*%\u0019\u00111\u0006\u0012\u0003\u0007%sG\u000fC\u0004\u000201\u0001\r!!\r\u0002\u0007!<X\u000eE\u0002\"\u0003gI1!!\u000e#\u0005\u0011auN\\4\t\u000f\u0005eB\u00021\u0001\u0002<\u0005\u0019\u0011n\u001d:\u0011\r\u0005u\u00121JA\u0014\u001d\u0011\ty$a\u0012\u0011\u0007\u0005\u0005#%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\tIEI\u0001\u0007!J,G-\u001a4\n\t\u00055\u0013q\n\u0002\u0004'\u0016$(bAA%E!)Q\u0010\u0004a\u0001}\"I\u0011Q\u000b\u0007\u0011\u0002\u0003\u0007\u0011qK\u0001\u0017iJLwmZ3sK\u0012\u0014\u00150\u00129pG\"\u001c\u0005.\u00198hKB\u0019\u0011%!\u0017\n\u0007\u0005m#EA\u0004C_>dW-\u00198\u0002S5\fG/\u001a:jC2L'0\u001a%jO\"<\u0016\r^3s[\u0006\u00148n\u00115b]\u001e,7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\t\tG\u000b\u0003\u0002X\u0005\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=$%\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002C5\f7.Z$f]\u0016\u0014\u0018nY*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;\u0015\u0019\u0005e\u0014qPAB\u0003\u000b\u000bI)a#\u0011\u0007]\fY(C\u0002\u0002~a\u0014ac\u0015;beR|eMZ:fi\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\b\u0003\u0003s\u0001\u0019AA\u000e\u0003\tIG\rC\u0004\u0002&9\u0001\r!a\n\t\u000f\u0005\u001de\u00021\u0001\u00022\u0005Y1\u000f^1si>3gm]3u\u0011\u001d\tyC\u0004a\u0001\u0003cA\u0011\"!\u000f\u000f!\u0003\u0005\r!a\u000f\u0002W5\f7.Z$f]\u0016\u0014\u0018nY*uCJ$xJ\u001a4tKR\u001c\u0005.\u00198hK\u00163XM\u001c;%I\u00164\u0017-\u001e7uIU*\"!!%+\t\u0005m\u00121M\u0001\u0017[\u0006$XM]5bY&TXm\u0015;beR|eMZ:fiR9q,a&\u0002\u001a\u0006m\u0005BB;\u0011\u0001\u0004\tI\bC\u0003~!\u0001\u0007a\u0010C\u0005\u0002\u001eB\u0001\n\u00111\u0001\u0002X\u0005Ya/\u00197jI\u0006$X\rS,N\u0003\u0001j\u0017\r^3sS\u0006d\u0017N_3Ti\u0006\u0014Ho\u00144gg\u0016$H\u0005Z3gCVdG\u000fJ\u001a\u000275\fG/\u001a:jC2L'0Z#q_\u000eD7\t[1oO\u0016,e/\u001a8u)\u0015y\u0016QUAX\u0011\u001d\t9K\u0005a\u0001\u0003S\u000b\u0001#\u001a9pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\u0011\u0007]\fY+C\u0002\u0002.b\u0014\u0001#\u00129pG\"\u001c\u0005.\u00198hK\u00163XM\u001c;\t\u000bu\u0014\u0002\u0019\u0001@\u000235\fG/\u001a:jC2L'0Z%T%\u0016C\b/\u00198e\u000bZ,g\u000e\u001e\u000b\u0006?\u0006U\u0016q\u0018\u0005\b\u0003o\u001b\u0002\u0019AA]\u00039I7O]#ya\u0006tG-\u0012<f]R\u00042a^A^\u0013\r\ti\f\u001f\u0002\u000f\u0013N\u0014X\t\u001f9b]\u0012,e/\u001a8u\u0011\u0015i8\u00031\u0001\u007f\u0003}i\u0017\r^3sS\u0006d\u0017N_3SKR,g\u000e^5p]\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u000b\u0006?\u0006\u0015\u0017q\u001a\u0005\b\u0003\u000f$\u0002\u0019AAe\u0003Q\u0011X\r^3oi&|gn\u00115b]\u001e,WI^3oiB\u0019q/a3\n\u0007\u00055\u0007P\u0001\u000bSKR,g\u000e^5p]\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\u0005\u0006{R\u0001\rA`\u0001\u001b[\u0006$XM]5bY&TX\rR3mKR,\u0007+\u0019:uSRLwN\u001c\u000b\u0004?\u0006U\u0007BB;\u0016\u0001\u0004\t9\u000eE\u0002x\u00033L1!a7y\u0005Q!U\r\\3uKB\u000b'\u000f^5uS>tWI^3oi\u00061R.\u0019;fe&\fG.\u001b>f\u0011\u0016\fG\u000e\u001e5DQ\u0016\u001c7\u000eF\u0002`\u0003CDq!a9\u0017\u0001\u0004\t)/\u0001\tiK\u0006dG\u000f[\"iK\u000e\\WI^3oiB\u0019q/a:\n\u0007\u0005%\bP\u0001\tIK\u0006dG\u000f[\"iK\u000e\\WI^3oi\u0002")
public class DurabilityEventsMaterialize
implements Logging {
    private final ReplicaManager replicaManager;
    private final DurabilityDB db;
    private final AuditReporter reporter;
    private final Validator validator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DurabilityDB db() {
        return this.db;
    }

    public Validator validator() {
        return this.validator;
    }

    public synchronized void materialize(ConsumerRecord<byte[], byte[]> record) {
        AbstractDurabilityEvent event = Deserializer$.MODULE$.deserialize((byte[])((byte[])record.key()).clone(), (byte[])((byte[])record.value()).clone());
        if (event instanceof HealthCheckEvent) {
            HealthCheckEvent healthCheckEvent = (HealthCheckEvent)event;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).toString());
            this.materializeHealthCheck(healthCheckEvent);
            return;
        }
        Option<PartitionState> stateOpt = this.db().fetchPartitionState(event.topicPartition());
        if (!stateOpt.isDefined()) {
            return;
        }
        PartitionState state = (PartitionState)stateOpt.get();
        if (event.epoch() < state.latestEpoch()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Ignoring event ").append(event).append(" as it's from a lower epoch. Current epoch is ").append(state).append(".epoch").toString());
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("DurabilityMaterialization: Materialization request for ").append(event.eventType()).append(" ").append(event).append(" for state: ").append(state).toString());
        if (event instanceof OffsetChangeEvent) {
            OffsetChangeEvent offsetChangeEvent = (OffsetChangeEvent)event;
            this.materializeOffsetChangeEvent(offsetChangeEvent, state);
        } else if (event instanceof DeleteRecordsEvent) {
            DeleteRecordsEvent deleteRecordsEvent = (DeleteRecordsEvent)event;
            this.materializeDeleteRecordEvent(deleteRecordsEvent, state);
        } else if (event instanceof EpochChangeEvent) {
            EpochChangeEvent epochChangeEvent = (EpochChangeEvent)event;
            this.materializeEpochChangeEvent(epochChangeEvent, state);
        } else if (event instanceof IsrExpandEvent) {
            IsrExpandEvent isrExpandEvent = (IsrExpandEvent)event;
            this.materializeISRExpandEvent(isrExpandEvent, state);
        } else if (event instanceof RetentionChangeEvent) {
            RetentionChangeEvent retentionChangeEvent = (RetentionChangeEvent)event;
            this.materializeRetentionChangeEvent(retentionChangeEvent, state);
        } else if (event instanceof StartOffsetChangeEvent) {
            StartOffsetChangeEvent startOffsetChangeEvent = (StartOffsetChangeEvent)event;
            this.materializeStartOffset(startOffsetChangeEvent, state, true);
        } else {
            if (event instanceof DeletePartitionEvent) {
                DeletePartitionEvent deletePartitionEvent = (DeletePartitionEvent)event;
                this.materializeDeletePartition(deletePartitionEvent);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
                return;
            }
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("DurabilityMaterialization: unexpected durability event type ").append(event).append(".eventType ").append(event).append(", ignoring").toString());
            return;
        }
        this.db().addPartition(event.topicPartition(), state);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("DurabilityMaterialization: Materialization done for ").append(event).append(" ").append(state).toString());
    }

    public void materializeOffsetChangeEvent(OffsetChangeEvent event, PartitionState state) {
        this.materializeHighWatermarkChanges(event.topicPartition(), event.epoch(), event.highWatermark(), event.isr(), state, this.materializeHighWatermarkChanges$default$6());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(event.topicPartition(), event.epoch(), event.logStartOffset(), event.highWatermark(), event.isr()), state, this.materializeStartOffset$default$3());
        state.latestEpoch_$eq(event.epoch());
    }

    public void materializeDeleteRecordEvent(DeleteRecordsEvent deleteRecordsEvent, PartitionState state) {
        state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), deleteRecordsEvent.trimOffset()));
        state.lapseWatchStartTime_$eq(0L);
        this.materializeHighWatermarkChanges(deleteRecordsEvent.topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.highWatermark(), deleteRecordsEvent.isr(), state, this.materializeHighWatermarkChanges$default$6());
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(deleteRecordsEvent.topicPartition(), deleteRecordsEvent.epoch(), deleteRecordsEvent.logStartOffset(), deleteRecordsEvent.highWatermark(), this.makeGenericStartOffsetChangeEvent$default$5()), state, this.materializeStartOffset$default$3());
    }

    public void materializeHighWatermarkChanges(TopicPartition topicPartition, int epoch, long hwm, Set<Object> isr, PartitionState state, boolean triggeredByEpochChange) {
        this.validator().validateDBHighWatermark(topicPartition, epoch, hwm, state, triggeredByEpochChange);
        if (this.validator().isInSync(isr)) {
            this.validator().validateLocalLogEndOffset(topicPartition, epoch, hwm, state);
        }
        state.highWatermark_$eq(hwm);
    }

    public boolean materializeHighWatermarkChanges$default$6() {
        return false;
    }

    private StartOffsetChangeEvent makeGenericStartOffsetChangeEvent(TopicPartition id, int epoch, long startOffset, long hwm, Set<Object> isr) {
        return StartOffsetChangeEvent$.MODULE$.apply(id, epoch, hwm, startOffset, (byte)RetentionType$.MODULE$.Other().id(), -1L, isr);
    }

    private Set<Object> makeGenericStartOffsetChangeEvent$default$5() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1}));
    }

    public void materializeStartOffset(StartOffsetChangeEvent event, PartitionState state, boolean validateHWM) {
        block12: {
            block11: {
                Enumeration.Value value;
                Enumeration.Value value2;
                block10: {
                    if (state.startOffset() <= 0L) {
                        state.committedStartOffset_$eq(event.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    } else if (this.validator().isInSync(event.isr()) && state.committedStartOffset() < event.logStartOffset() && this.validator().validateDBLogStartOffset(event, state)) {
                        this.validator().validateLocalLogStartOffset(event.topicPartition(), event.logStartOffset());
                        state.committedStartOffset_$eq(event.logStartOffset());
                        state.lapseWatchStartTime_$eq(0L);
                    }
                    if (validateHWM) {
                        this.materializeHighWatermarkChanges(event.topicPartition(), event.epoch(), event.highWatermark(), event.isr(), state, this.materializeHighWatermarkChanges$default$6());
                    }
                    state.startOffset_$eq(event.logStartOffset());
                    Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
                    Enumeration.Value value4 = RetentionType$.MODULE$.SizeBasedRetention();
                    if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                        state.retentionSz_$eq(event.retentionValue());
                        return;
                    }
                    value2 = RetentionType$.MODULE$.apply(event.retentionType());
                    value = RetentionType$.MODULE$.TimeBasedRetention();
                    if (value2 != null) break block10;
                    if (value != null) {
                        return;
                    }
                    break block11;
                }
                if (!value2.equals(value)) break block12;
            }
            state.retentionMs_$eq(event.retentionValue());
        }
    }

    public boolean materializeStartOffset$default$3() {
        return false;
    }

    public void materializeEpochChangeEvent(EpochChangeEvent epochChangeEvent, PartitionState state) {
        this.validator().validateDBEpochChange(epochChangeEvent, state);
        this.materializeHighWatermarkChanges(epochChangeEvent.topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.highWatermark(), epochChangeEvent.isr(), state, true);
        this.materializeStartOffset(this.makeGenericStartOffsetChangeEvent(epochChangeEvent.topicPartition(), epochChangeEvent.epoch(), epochChangeEvent.logStartOffset(), epochChangeEvent.highWatermark(), epochChangeEvent.isr()), state, this.materializeStartOffset$default$3());
        this.validator().validateEpochChangeWithLocal(epochChangeEvent);
        state.epochChain().put((Object)BoxesRunTime.boxToInteger((int)epochChangeEvent.epoch()), (Object)BoxesRunTime.boxToLong((long)epochChangeEvent.firstOffset()));
        state.latestEpoch_$eq(epochChangeEvent.epoch());
    }

    public void materializeISRExpandEvent(IsrExpandEvent isrExpandEvent, PartitionState state) {
        if (Utils$.MODULE$.getBrokerId(this.replicaManager) != isrExpandEvent.expandBrokerId()) {
            return;
        }
        this.validator().validateEpochChainWithLocal(isrExpandEvent.topicPartition(), state);
    }

    public void materializeRetentionChangeEvent(RetentionChangeEvent retentionChangeEvent, PartitionState state) {
        if (retentionChangeEvent.timeMs() != state.retentionMs() || retentionChangeEvent.size() != state.retentionSz()) {
            state.committedStartOffset_$eq(Math.max(state.committedStartOffset(), state.startOffset()));
            state.lapseWatchStartTime_$eq(0L);
            state.retentionSz_$eq(retentionChangeEvent.size());
            state.retentionMs_$eq(retentionChangeEvent.timeMs());
        }
    }

    public void materializeDeletePartition(DeletePartitionEvent event) {
        this.db().deletePartition(event.topicPartition());
    }

    public void materializeHealthCheck(HealthCheckEvent healthCheckEvent) {
        this.reporter.updateHealthCheck(Integer.toString(healthCheckEvent.brokerId()), healthCheckEvent.timeStamp());
    }

    public DurabilityEventsMaterialize(ReplicaManager replicaManager, DurabilityDB db, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.db = db;
        this.reporter = reporter;
        Logging.$init$(this);
        this.validator = new Validator(replicaManager, reporter, time);
    }
}

