/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.durability.Utils;
import kafka.durability.Utils$;
import kafka.durability.audit.AuditReporter;
import kafka.durability.db.PartitionState;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.Validator$;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u0010!\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005m!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003@\u0011!1\u0005A!A!\u0002\u00139\u0005\"B*\u0001\t\u0003!\u0006\u0002\u0003.\u0001\u0005\u0004%\tAI.\t\r}\u0003\u0001\u0015!\u0003]\u0011\u001d\u0001\u0007A1A\u0005\nmCa!\u0019\u0001!\u0002\u0013a\u0006\u0002\u00032\u0001\u0005\u0004%\tAI.\t\r\r\u0004\u0001\u0015!\u0003]\u0011\u0015!\u0007\u0001\"\u0001f\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0004\u0002 \u0001!\t!!\t\t\u0011\u0005-\u0002\u0001\"\u0001!\u0003[Aq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!-\u0001\t\u0013\t\u0019\fC\u0004\u0002>\u0002!I!a0\t\u0011\u0005%\u0007\u0001\"\u0001!\u0003\u0017<\u0011\"!9!\u0003\u0003E\t!a9\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003KDaa\u0015\u000f\u0005\u0002\u0005\u001d\b\"CAu9E\u0005I\u0011AAv\u0005%1\u0016\r\\5eCR|'O\u0003\u0002\"E\u0005yQ.\u0019;fe&\fG.\u001b>bi&|gN\u0003\u0002$I\u0005QA-\u001e:bE&d\u0017\u000e^=\u000b\u0003\u0015\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00183\u001b\u0005\u0001$BA\u0019%\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0004GA\u0004M_\u001e<\u0017N\\4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\ta\u0007\u0005\u00028u5\t\u0001H\u0003\u0002:I\u000511/\u001a:wKJL!a\u000f\u001d\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005sKB|'\u000f^3s+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"#\u0003\u0015\tW\u000fZ5u\u0013\t!\u0015IA\u0007Bk\u0012LGOU3q_J$XM]\u0001\ne\u0016\u0004xN\u001d;fe\u0002\nA\u0001^5nKB\u0011\u0001*U\u0007\u0002\u0013*\u0011\u0011G\u0013\u0006\u0003\u00172\u000baaY8n[>t'BA\u0013N\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\n\u0005IK%\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003B+X1f\u0003\"A\u0016\u0001\u000e\u0003\u0001BQ\u0001\u000e\u0004A\u0002YBQ!\u0010\u0004A\u0002}BqA\u0012\u0004\u0011\u0002\u0003\u0007q)\u0001\u000fSKR,g\u000e^5p]RKW.Z'be\u001eLgn\u00144FeJ|'/T:\u0016\u0003q\u0003\"!K/\n\u0005yS#aA%oi\u0006i\"+\u001a;f]RLwN\u001c+j[\u0016l\u0015M]4j]>3WI\u001d:pe6\u001b\b%\u0001\u000eSKR,g\u000e^5p]NK'0Z'be\u001eLgn\u00144FeJ|'/A\u000eSKR,g\u000e^5p]NK'0Z'be\u001eLgn\u00144FeJ|'\u000fI\u0001!\u001b\u0006Cvl\u0014$G'\u0016#vlR!Q?R{E*\u0012*B\u001d\u000e+u\fV%N\u000b~k5+A\u0011N\u0003b{vJ\u0012$T\u000bR{v)\u0011)`)>cUIU!O\u0007\u0016{F+S'F?6\u001b\u0006%A\fwC2LG-\u0019;f\t\nC\u0015n\u001a5XCR,'/\\1sWR1a-[8rmz\u0004\"!K4\n\u0005!T#\u0001B+oSRDQA[\u0007A\u0002-\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002m[6\t!*\u0003\u0002o\u0015\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"\u00029\u000e\u0001\u0004a\u0016!B3q_\u000eD\u0007\"\u0002:\u000e\u0001\u0004\u0019\u0018a\u00015x[B\u0011\u0011\u0006^\u0005\u0003k*\u0012A\u0001T8oO\")q/\u0004a\u0001q\u0006)1\u000f^1uKB\u0011\u0011\u0010`\u0007\u0002u*\u00111PI\u0001\u0003I\nL!! >\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\"Aq0\u0004I\u0001\u0002\u0004\t\t!A\u0007jg\u0016\u0003xn\u00195DQ\u0006tw-\u001a\t\u0004S\u0005\r\u0011bAA\u0003U\t9!i\\8mK\u0006t\u0017!\t<bY&$\u0017\r^3E\u0005\"Kw\r[,bi\u0016\u0014X.\u0019:lI\u0011,g-Y;mi\u0012*TCAA\u0006U\u0011\t\t!!\u0004,\u0005\u0005=\u0001\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0007+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\t\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011D^1mS\u0012\fG/\u001a'pG\u0006dGj\\4F]\u0012|eMZ:fiRIa-a\t\u0002&\u0005\u001d\u0012\u0011\u0006\u0005\u0006U>\u0001\ra\u001b\u0005\u0006a>\u0001\r\u0001\u0018\u0005\u0006e>\u0001\ra\u001d\u0005\u0006o>\u0001\r\u0001_\u0001\u0012O\u0016$(+\u001a;f]RLwN\u001c,bYV,G\u0003CA\u0018\u0003k\t9$!\u000f\u0011\t%\n\td]\u0005\u0004\u0003gQ#AB(qi&|g\u000eC\u0003k!\u0001\u00071\u000eC\u0003x!\u0001\u0007\u0001\u0010C\u0004\u0002<A\u0001\r!!\u0010\u0002\u001bI,G/\u001a8uS>tG+\u001f9f!\u0011\ty$a\u0017\u000f\t\u0005\u0005\u0013Q\u000b\b\u0005\u0003\u0007\n\tF\u0004\u0003\u0002F\u0005=c\u0002BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-c%\u0001\u0004=e>|GOP\u0005\u0002K%\u00111\u0005J\u0005\u0004\u0003'\u0012\u0013AB3wK:$8/\u0003\u0003\u0002X\u0005e\u0013!\u0004*fi\u0016tG/[8o)f\u0004XMC\u0002\u0002T\tJA!!\u0018\u0002`\ti!+\u001a;f]RLwN\u001c+za\u0016TA!a\u0016\u0002Z\u0005Ab/\u00197jI\u0006$X\r\u0012\"M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\r\u0005\u0005\u0011QMA9\u0011\u001d\t9'\u0005a\u0001\u0003S\nQ!\u001a<f]R\u0004B!a\u001b\u0002n5\u0011\u0011\u0011L\u0005\u0005\u0003_\nIF\u0001\fTi\u0006\u0014Ho\u00144gg\u0016$8\t[1oO\u0016,e/\u001a8u\u0011\u00159\u0018\u00031\u0001y\u0003Q\u0019\u0018N_3MCB\u001cXmQ1mGVd\u0017\r^5p]RA\u0011\u0011AA<\u0003s\nY\bC\u0004\u0002hI\u0001\r!!\u001b\t\u000b]\u0014\u0002\u0019\u0001=\t\r\u0005u$\u00031\u0001t\u00039\u0011X\r^3oi&|gNV1mk\u0016\fA\u0003^5nK2\u000b\u0007o]3DC2\u001cW\u000f\\1uS>tG\u0003CA\u0001\u0003\u0007\u000b))a\"\t\u000f\u0005\u001d4\u00031\u0001\u0002j!)qo\u0005a\u0001q\"1\u0011QP\nA\u0002M\f1D^1mS\u0012\fG/\u001a'pG\u0006dGj\\4Ti\u0006\u0014Ho\u00144gg\u0016$H#\u00024\u0002\u000e\u0006=\u0005\"\u00026\u0015\u0001\u0004Y\u0007BBAI)\u0001\u00071/\u0001\u0007mK\u0006$WM](gMN,G/A\u000bwC2LG-\u0019;f\t\n+\u0005o\\2i\u0007\"\fgnZ3\u0015\u000b\u0019\f9*!)\t\u000f\u0005eU\u00031\u0001\u0002\u001c\u0006\u0001R\r]8dQ\u000eC\u0017M\\4f\u000bZ,g\u000e\u001e\t\u0005\u0003W\ni*\u0003\u0003\u0002 \u0006e#\u0001E#q_\u000eD7\t[1oO\u0016,e/\u001a8u\u0011\u00159X\u00031\u0001y\u0003q1\u0018\r\\5eCR,W\t]8dQ\u000eC\u0017M\\4f/&$\b\u000eT8dC2$2AZAT\u0011\u001d\tIJ\u0006a\u0001\u00037\u000b1D^1mS\u0012\fG/Z#q_\u000eD7\t[1j]^KG\u000f\u001b'pG\u0006dG#\u00024\u0002.\u0006=\u0006\"\u00026\u0018\u0001\u0004Y\u0007\"B<\u0018\u0001\u0004A\u0018!J<ji\"Lg.T1sO&twJZ#se>\u0014hi\u001c:US6,Wj\u001d*fi\u0016tG/[8o)\u0019\t\t!!.\u0002:\"1\u0011q\u0017\rA\u0002M\fa\u0001^5nK6\u001b\bBBA^1\u0001\u00071/A\u0006sKR,g\u000e^5p]6\u001b\u0018aI<ji\"Lg.T1sO&twJZ#se>\u0014hi\u001c:TSj,'+\u001a;f]RLwN\u001c\u000b\u0007\u0003\u0003\t\t-!2\t\r\u0005\r\u0017\u00041\u0001t\u0003\u0011\u0019\u0018N_3\t\r\u0005\u001d\u0017\u00041\u0001t\u00035\u0011X\r^3oi&|gnU5{K\u0006A\u0011n]%o'ft7\r\u0006\u0003\u0002\u0002\u00055\u0007bBAh5\u0001\u0007\u0011\u0011[\u0001\u0004SN\u0014\b#BAj\u00037df\u0002BAk\u0003/\u00042!a\u0012+\u0013\r\tINK\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0017q\u001c\u0002\u0004'\u0016$(bAAmU\u0005Ia+\u00197jI\u0006$xN\u001d\t\u0003-r\u0019\"\u0001\b\u0015\u0015\u0005\u0005\r\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002n*\u001aq)!\u0004")
public class Validator
implements Logging {
    private final ReplicaManager replicaManager;
    private final AuditReporter reporter;
    private final Time time;
    private final int RetentionTimeMarginOfErrorMs;
    private final int RetentionSizeMarginOfError;
    private final int MAX_OFFSET_GAP_TOLERANCE_TIME_MS;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$3() {
        return Validator$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public AuditReporter reporter() {
        return this.reporter;
    }

    public int RetentionTimeMarginOfErrorMs() {
        return this.RetentionTimeMarginOfErrorMs;
    }

    private int RetentionSizeMarginOfError() {
        return this.RetentionSizeMarginOfError;
    }

    public int MAX_OFFSET_GAP_TOLERANCE_TIME_MS() {
        return this.MAX_OFFSET_GAP_TOLERANCE_TIME_MS;
    }

    public void validateDBHighWatermark(TopicPartition topicPartition, int epoch, long hwm, PartitionState state, boolean isEpochChange) {
        if (state.highWatermark() > hwm && !isEpochChange) {
            String msg = new StringBuilder(192).append("Durability lapse on validation with db hwm. For partition ").append(topicPartition).append(", high water mark").append(" decreased from previous committed value. The db state is ").append(state).append(" whereas the new high watermark state change").append(" is ").append(hwm).append(" at epoch ").append(epoch).append(".").toString();
            this.reporter().reportDurabilityLapse(topicPartition, hwm, state.highWatermark() - hwm, DurabilityLapseType$.MODULE$.HighWatermark(), msg, true);
        }
    }

    public boolean validateDBHighWatermark$default$5() {
        return false;
    }

    public void validateLocalLogEndOffset(TopicPartition topicPartition, int epoch, long hwm, PartitionState state) {
        long localEndOffset;
        Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), topicPartition);
        if (option instanceof Some && (localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) < hwm) {
            String msg = new StringBuilder(204).append("Durability lapse on validation with local log end offset. For partition ").append(topicPartition).append(",").append(" high water mark(").append(hwm).append(") is found to be more than local end offset(").append(localEndOffset).append("), where the local replica").append(" is at epoch ").append(state.latestLocalEpoch()).append(" compares to event's epoch of ").append(epoch).append(".").toString();
            this.reporter().reportDurabilityLapse(topicPartition, localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
            return;
        }
    }

    public Option<Object> getRetentionValue(TopicPartition topicPartition, PartitionState state, Enumeration.Value retentionType) {
        Object object;
        Enumeration.Value value = RetentionType$.MODULE$.TimeBasedRetention();
        if (!(value != null ? !value.equals(retentionType) : retentionType != null)) {
            object = state.retentionMs() != -1L ? new Some((Object)BoxesRunTime.boxToLong((long)state.retentionMs())) : Utils$.MODULE$.getLocalLogRetentionMs(this.replicaManager(), topicPartition);
        } else {
            Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
            object = !(value2 != null ? !value2.equals(retentionType) : retentionType != null) ? (state.retentionSz() != -1L ? new Some((Object)BoxesRunTime.boxToLong((long)state.retentionSz())) : Utils$.MODULE$.getLocalLogRetentionSize(this.replicaManager(), topicPartition)) : None$.MODULE$;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateDBLogStartOffset(StartOffsetChangeEvent event, PartitionState state) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Validating db log startOffset ").append(event).append(" ").append(state).toString());
        Enumeration.Value value = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value2 = RetentionType$.MODULE$.SizeBasedRetention();
        if (value == null) {
            if (value2 == null) return this.sizeLapseCalculation(event, state, event.retentionValue());
        } else if (value.equals(value2)) {
            return this.sizeLapseCalculation(event, state, event.retentionValue());
        }
        Enumeration.Value value3 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value4 = RetentionType$.MODULE$.TimeBasedRetention();
        if (value3 == null) {
            if (value4 == null) return this.timeLapseCalculation(event, state, event.retentionValue());
        } else if (value3.equals(value4)) {
            return this.timeLapseCalculation(event, state, event.retentionValue());
        }
        Enumeration.Value value5 = RetentionType$.MODULE$.apply(event.retentionType());
        Enumeration.Value value6 = RetentionType$.MODULE$.Other();
        if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
            Option<Object> option = this.getRetentionValue(event.topicPartition(), state, RetentionType$.MODULE$.TimeBasedRetention());
            Option<Object> option2 = this.getRetentionValue(event.topicPartition(), state, RetentionType$.MODULE$.SizeBasedRetention());
            Option<Object> option3 = option;
            if (!(option2 instanceof Some)) return true;
            long retentionSz = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
            if (!(option3 instanceof Some)) return true;
            long retentionMs = BoxesRunTime.unboxToLong((Object)((Some)option3).value());
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Validating for db log start offset lapse for ").append(event).append(" ").append(state).append(" with retentions (").append(retentionSz).append(", ").append(retentionMs).append(")").toString());
            Option<Object> estimatedSize = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicPartition(), event.logStartOffset());
            Option<Utils.MaxTimestampWithSize> prevSegInfo = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicPartition(), event.logStartOffset());
            Option<Object> option4 = estimatedSize;
            Option<Utils.MaxTimestampWithSize> option5 = prevSegInfo;
            if (!(option4 instanceof Some)) return true;
            long estimatedSize2 = BoxesRunTime.unboxToLong((Object)((Some)option4).value());
            if (!(option5 instanceof Some)) return true;
            Utils.MaxTimestampWithSize prevSegInfo2 = (Utils.MaxTimestampWithSize)((Some)option5).value();
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize2, retentionSz) && !this.withinMarginOfErrorForTimeMsRetention(prevSegInfo2.maxTimestamp(), retentionMs)) {
                String msg = new StringBuilder(377).append("Durability lapse on validation with db log start offset. For partition").append(" ").append(event.topicPartition()).append(" the startOffset from durability event ").append(event).append(", is more than expected retention").append(" window time with current db state as ").append(state).append(". The maxTimestamp in previous deleted segment is").append(" ").append(prevSegInfo2.maxTimestamp()).append(" with retention of ").append(retentionMs).append(" and margin of error as").append(" ").append(this.RetentionTimeMarginOfErrorMs()).append(". For size based lapse, size including previous segment is").append(" ").append(estimatedSize2).append(" with retention of ").append(retentionSz).append(" and margin of error as ").append(this.RetentionSizeMarginOfError()).append(".").toString();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Lapse with ").append(estimatedSize2).append(" ").append(prevSegInfo2).append(" ").append(msg).toString());
                if (state.retentionMs() == -1L && state.retentionSz() == -1L && (state.lapseWatchStartTime() == 0L || this.time.milliseconds() - state.lapseWatchStartTime() < (long)this.MAX_OFFSET_GAP_TOLERANCE_TIME_MS())) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Postponing start offset lapse with details: ").append(msg).toString());
                    if (state.lapseWatchStartTime() != 0L) return false;
                    state.lapseWatchStartTime_$eq(this.time.milliseconds());
                    return false;
                }
                this.reporter().reportDurabilityLapse(event.topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), DurabilityLapseType$.MODULE$.StartOffset(), msg, true);
                return true;
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Validation against db log start offset went fine  ").append(estimatedSize2).append(", ").append(prevSegInfo2).toString());
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("validateDBLogStartOffset exits as not able to fetch comparing value ").append(event).append(" ").append(state).toString());
        return true;
    }

    private boolean sizeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("sizeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Object> option = Utils$.MODULE$.getEstimatedLogRangeSize(this.replicaManager(), event.topicPartition(), event.logStartOffset());
        if (option instanceof Some) {
            boolean bl2;
            long estimatedSize = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            if (!this.withinMarginOfErrorForSizeRetention(estimatedSize, retentionValue)) {
                String msg = new StringBuilder(224).append("Durability lapse based on size lapse. For partition ").append(event.topicPartition()).append(" the startOffset").append(" from durability event ").append(event).append(", is more than expected retention window size with current db state as ").append(state).append(".").append(" The estimated size ").append(estimatedSize).append(" retentionValue ").append(retentionValue).append(" with margin of error as ").append(this.RetentionSizeMarginOfError()).toString();
                this.reporter().reportDurabilityLapse(event.topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), msg, this.reporter().reportDurabilityLapse$default$5());
                bl2 = true;
            } else {
                bl2 = true;
            }
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean timeLapseCalculation(StartOffsetChangeEvent event, PartitionState state, long retentionValue) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("timeLapseCalculation ").append(event).append(" ").append(state).append(" ").append(retentionValue).toString());
        Option<Utils.MaxTimestampWithSize> option = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), event.topicPartition(), event.logStartOffset());
        if (option instanceof Some) {
            boolean bl2;
            Utils.MaxTimestampWithSize prevMs = (Utils.MaxTimestampWithSize)((Some)option).value();
            if (!this.withinMarginOfErrorForTimeMsRetention(prevMs.maxTimestamp(), retentionValue)) {
                String msg = new StringBuilder(252).append("Durability lapse based on time lapse. For partition ").append(event.topicPartition()).append(" the startOffset").append(" from durability event ").append(event).append(", is more than expected retention window time with current db state as ").append(state).append(".").append(" The maxTimestamp in previous deleted segment is ").append(prevMs.maxTimestamp()).append(" retentionValue ").append(retentionValue).append(" and").append(" margin of error is ").append(this.RetentionTimeMarginOfErrorMs()).toString();
                this.reporter().reportDurabilityLapse(event.topicPartition(), state.startOffset(), Math.max(event.logStartOffset() - state.startOffset(), 1L), msg, this.reporter().reportDurabilityLapse$default$5());
                bl2 = true;
            } else {
                bl2 = true;
            }
            bl = bl2;
        } else {
            bl = true;
        }
        return bl;
    }

    public void validateLocalLogStartOffset(TopicPartition topicPartition, long leaderOffset) {
        Utils.MaxTimestampWithSize prevSegmentState;
        Option<Utils.MaxTimestampWithSize> option;
        AbstractLog log;
        Option<AbstractLog> option2 = this.replicaManager().logManager().getLog(topicPartition, this.replicaManager().logManager().getLog$default$2());
        if (option2 instanceof Some && (log = (AbstractLog)((Some)option2).value()) != null && log.logStartOffset() > leaderOffset && (option = Utils$.MODULE$.getPreviousTierSegmentInfo(this.replicaManager(), topicPartition, log.logStartOffset())) instanceof Some && !this.withinMarginOfErrorForTimeMsRetention((prevSegmentState = (Utils.MaxTimestampWithSize)((Some)option).value()).maxTimestamp(), Predef$.MODULE$.Long2long(log.config().retentionMs())) && !this.withinMarginOfErrorForSizeRetention(log.size() + prevSegmentState.size(), Predef$.MODULE$.Long2long(log.config().retentionSize()))) {
            String msg = new StringBuilder(187).append("Durability lapse on validation with local log start offset. For local start offset").append(" of ").append(topicPartition).append(" on ").append(Utils$.MODULE$.getBrokerId(this.replicaManager())).append(". The previous maxTimestamp is").append(" ").append(prevSegmentState.maxTimestamp()).append(" with retention ").append(log.config().retentionMs()).append(", the logSize is ").append(log.size()).append(" prevSegmentSize ").append(prevSegmentState.size()).append(" with retention ").append(log.config().retentionSize()).toString();
            this.reporter().reportDurabilityLapse(topicPartition, log.logStartOffset(), Math.max(log.logStartOffset() - leaderOffset, 1L), DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
            return;
        }
    }

    public void validateDBEpochChange(EpochChangeEvent epochChangeEvent, PartitionState state) {
        if (epochChangeEvent.firstOffset() < state.highWatermark() || epochChangeEvent.epoch() < state.latestEpoch()) {
            String msg = new StringBuilder(142).append("Durability lapse on epoch change event ").append(epochChangeEvent).append(" state ").append(state).append(". First offset").append(" ").append(epochChangeEvent.firstOffset()).append(" for new epoch ").append(epochChangeEvent.epoch()).append(" is less than previous recorded high watermark").append(" ").append(state.highWatermark()).append(". Event: ").append(epochChangeEvent).append(" DbState: ").append(state).toString();
            this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), epochChangeEvent.firstOffset(), Math.max(state.highWatermark() - epochChangeEvent.firstOffset(), 1L), DurabilityLapseType$.MODULE$.EpochChain(), msg, true);
        }
    }

    public void validateEpochChangeWithLocal(EpochChangeEvent epochChangeEvent) {
        if (this.isInSync(epochChangeEvent.isr())) {
            Option<Object> option = Utils$.MODULE$.getLogEndOffset(this.replicaManager(), epochChangeEvent.topicPartition());
            Option<Object> option2 = Utils$.MODULE$.getLatestEpoch(this.replicaManager(), epochChangeEvent.topicPartition());
            Option<Object> option3 = option;
            if (option2 instanceof Some) {
                int epoch = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                if (option3 instanceof Some) {
                    long localEndOffset = BoxesRunTime.unboxToLong((Object)((Some)option3).value());
                    if (epoch >= epochChangeEvent.epoch() && localEndOffset < epochChangeEvent.firstOffset()) {
                        String msg = new StringBuilder(188).append("Durability lapse on validation of epoch change with local. For in-sync partition").append(" ").append(epochChangeEvent.topicPartition()).append(", the local end offset ").append(localEndOffset).append(" at local epoch ").append(epoch).append(", is").append(" less than the first offset of the new epoch. The event detail: ").append(epochChangeEvent).toString();
                        this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                    } else if (localEndOffset < epochChangeEvent.highWatermark()) {
                        String msg = new StringBuilder(203).append("Durability lapse on validation of epoch change with local. For in-sync partition").append(" ").append(epochChangeEvent.topicPartition()).append(", the local end offset ").append(localEndOffset).append(" at local epoch ").append(epoch).append(", is").append(" less than the high watermark of the new epoch change event. The event detail: ").append(epochChangeEvent).toString();
                        this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), localEndOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                    }
                }
            }
            Option<Object> localOffset = Utils$.MODULE$.getLocalStartOffsetForEpoch(this.replicaManager(), epochChangeEvent.topicPartition(), epochChangeEvent.epoch());
            Option<AbstractLog> log = this.replicaManager().logManager().getLog(epochChangeEvent.topicPartition(), this.replicaManager().logManager().getLog$default$2());
            Option<Object> option4 = localOffset;
            Option<AbstractLog> option5 = log;
            if (option4 instanceof Some) {
                long firstOffset = BoxesRunTime.unboxToLong((Object)((Some)option4).value());
                if (option5 instanceof Some) {
                    AbstractLog localLog = (AbstractLog)((Some)option5).value();
                    if (firstOffset != -1L && firstOffset != epochChangeEvent.firstOffset() && (firstOffset < epochChangeEvent.firstOffset() || firstOffset > localLog.logStartOffset()) && Utils$.MODULE$.isNonCompacted(this.replicaManager(), epochChangeEvent.topicPartition())) {
                        String msg = new StringBuilder(172).append("Durability lapse on validation of epoch change with local. For in-sync partition").append(" ").append(epochChangeEvent.topicPartition()).append(", the local first offset ").append(localOffset).append(" is not equal to first offset").append(" of the new epoch. The event detail: ").append(epochChangeEvent).toString();
                        this.reporter().reportDurabilityLapse(epochChangeEvent.topicPartition(), firstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                        return;
                    }
                }
            }
        }
    }

    public void validateEpochChainWithLocal(TopicPartition topicPartition, PartitionState state) {
        Object object = new Object();
        try {
            if (!Utils$.MODULE$.isNonCompacted(this.replicaManager(), topicPartition)) {
                return;
            }
            LongRef prevLocalEpochFirstOffset = LongRef.create((long)-1L);
            IntRef prevEpoch = IntRef.create((int)-1);
            ((List)state.epochChain().toList().sortWith((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)Validator.$anonfun$validateEpochChainWithLocal$1(x, y)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Validator.$anonfun$validateEpochChainWithLocal$2(this, topicPartition, prevLocalEpochFirstOffset, state, prevEpoch, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
                return;
            }
            throw ex;
        }
    }

    private boolean withinMarginOfErrorForTimeMsRetention(long timeMs, long retentionMs) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("validating ").append(timeMs).append(" against ").append(retentionMs).toString());
        if (timeMs == -1L) {
            return true;
        }
        if (retentionMs == -1L) {
            return false;
        }
        long diff = this.time.milliseconds() - timeMs;
        return retentionMs - diff <= (long)this.RetentionTimeMarginOfErrorMs();
    }

    private boolean withinMarginOfErrorForSizeRetention(long size, long retentionSize) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Validating ").append(size).append(" against ").append(retentionSize).toString());
        if (size == -1L) {
            return true;
        }
        if (retentionSize == -1L) {
            return false;
        }
        return retentionSize - size <= (long)this.RetentionSizeMarginOfError();
    }

    public boolean isInSync(Set<Object> isr) {
        return isr.contains((Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.getBrokerId(this.replicaManager())));
    }

    public static final /* synthetic */ boolean $anonfun$validateEpochChainWithLocal$1(Tuple2 x, Tuple2 y) {
        return x._1$mcI$sp() < y._1$mcI$sp();
    }

    public static final /* synthetic */ void $anonfun$validateEpochChainWithLocal$2(Validator $this, TopicPartition topicPartition$1, LongRef prevLocalEpochFirstOffset$1, PartitionState state$4, IntRef prevEpoch$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            long localEpochFirstOffset;
            int dbEpoch = x0$1._1$mcI$sp();
            long dbEpochFirstOffset = x0$1._2$mcJ$sp();
            Option<Object> option = Utils$.MODULE$.getLocalStartOffsetForEpoch($this.replicaManager(), topicPartition$1, dbEpoch);
            if (option instanceof Some && (localEpochFirstOffset = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != -1L) {
                AbstractLog log;
                Option<AbstractLog> option2;
                if (dbEpochFirstOffset < prevLocalEpochFirstOffset$1.elem) {
                    String msg = new StringBuilder(176).append("Durability lapse on epoch chain validation for partition ").append(topicPartition$1).append(". The durability").append(" state ").append(state$4).append(" does not match at ").append(prevEpoch$1.elem).append(", the local first offset is ").append(prevLocalEpochFirstOffset$1.elem).append(" more than or equal to next epoch's first offset ").append(dbEpochFirstOffset).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (localEpochFirstOffset != dbEpochFirstOffset && (option2 = $this.replicaManager().logManager().getLog(topicPartition$1, $this.replicaManager().logManager().getLog$default$2())) instanceof Some && ((log = (AbstractLog)((Some)option2).value()).logStartOffset() < localEpochFirstOffset || dbEpochFirstOffset > localEpochFirstOffset)) {
                    String msg = new StringBuilder(189).append("Durability lapse on epoch chain validation for partition ").append(topicPartition$1).append(". The durability").append(" state ").append(state$4).append(" does not match at ").append(dbEpoch).append(", the local first offset is ").append(localEpochFirstOffset).append(" is more than db local first offset and also log start offset ").append(log.logStartOffset()).toString();
                    $this.reporter().reportDurabilityLapse(topicPartition$1, dbEpochFirstOffset, 1L, DurabilityLapseType$.MODULE$.NonCustomerFacing(), msg, false);
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                prevLocalEpochFirstOffset$1.elem = localEpochFirstOffset;
                prevEpoch$1.elem = dbEpoch;
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public Validator(ReplicaManager replicaManager, AuditReporter reporter, Time time) {
        this.replicaManager = replicaManager;
        this.reporter = reporter;
        this.time = time;
        Logging.$init$(this);
        this.RetentionTimeMarginOfErrorMs = 3600000;
        this.RetentionSizeMarginOfError = 0x100000;
        this.MAX_OFFSET_GAP_TOLERANCE_TIME_MS = 900000;
    }
}

