/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LastRecord;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tud!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005{!A!\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00038\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006_\u0002!\t\u0006\u001d\u0005\bs\u0002\u0001\r\u0011\"\u0003{\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\f\u0001\u0001\u000b\u0015B>\t\u0011\u00055\u0001\u00011A\u0005\niD\u0011\"a\u0004\u0001\u0001\u0004%I!!\u0005\t\u000f\u0005U\u0001\u0001)Q\u0005w\"I\u0011q\u0003\u0001C\u0002\u0013%\u0011\u0011\u0004\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001c!A\u00111\u0005\u0001\u0005\u0002\r\n)\u0003\u0003\u0005\u0002D\u0001!\taIA#\u0011!\ti\u0005\u0001C\u0001G\u0005=\u0003\u0002CAB\u0001\u0011\u00051%!\"\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA\u007f\u0001\u0011%\u0011q \u0005\b\u0005#\u0001A\u0011\u0001B\n\u0011\u001d\u00119\u0002\u0001C\u0001\u00053A\u0001Ba\u0007\u0001\t\u0003\u0019#Q\u0004\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011!\u0011\t\u0006\u0001C\u0001G\tM\u0003b\u0002B2\u0001\u0011%!Q\r\u0002\b\u00072,\u0017M\\3s\u0015\t!S%A\u0002m_\u001eT\u0011AJ\u0001\u0006W\u000647.Y\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020e5\t\u0001G\u0003\u00022K\u0005)Q\u000f^5mg&\u00111\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\tIGm\u0001\u0001\u0016\u0003]\u0002\"!\u000b\u001d\n\u0005eR#aA%oi\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u001f\u0011\u0005yzT\"A\u0012\n\u0005\u0001\u001b#!C(gMN,G/T1q\u0003)ygMZ:fi6\u000b\u0007\u000fI\u0001\rS>\u0014UO\u001a4feNK'0Z\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\u0006\u0019B-\u001e9Ck\u001a4WM\u001d'pC\u00124\u0015m\u0019;peB\u0011\u0011FR\u0005\u0003\u000f*\u0012a\u0001R8vE2,\u0017!\u0003;ie>$H\u000f\\3s!\ty#*\u0003\u0002La\tIA\u000b\u001b:piRdWM]\u0001\u0005i&lW\r\u0005\u0002O/6\tqJ\u0003\u00022!*\u0011\u0011KU\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019\u001a&B\u0001+V\u0003\u0019\t\u0007/Y2iK*\ta+A\u0002pe\u001eL!\u0001W(\u0003\tQKW.Z\u0001\nG\",7m\u001b#p]\u0016\u0004B!K.^C&\u0011AL\u000b\u0002\n\rVt7\r^5p]F\u0002\"AX0\u000e\u0003AK!\u0001\u0019)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0011FY\u0005\u0003G*\u0012A!\u00168ji\u00061A(\u001b8jiz\"\u0012BZ4iS*\\G.\u001c8\u0011\u0005y\u0002\u0001\"\u0002\u001b\f\u0001\u00049\u0004\"B\u001e\f\u0001\u0004i\u0004\"\u0002\"\f\u0001\u00049\u0004\"B\"\f\u0001\u00049\u0004\"\u0002#\f\u0001\u0004)\u0005\"\u0002%\f\u0001\u0004I\u0005\"\u0002'\f\u0001\u0004i\u0005\"B-\f\u0001\u0004Q\u0016A\u00037pO\u001e,'OT1nKV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006!A.\u00198h\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\rM#(/\u001b8h\u0003)\u0011X-\u00193Ck\u001a4WM]\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011a0^\u0001\u0004]&|\u0017bAA\u0001{\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001dI,\u0017\r\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0002\t\u0011\u0005%a\"!AA\u0002m\f1\u0001\u001f\u00132\u0003-\u0011X-\u00193Ck\u001a4WM\u001d\u0011\u0002\u0017]\u0014\u0018\u000e^3Ck\u001a4WM]\u0001\u0010oJLG/\u001a\"vM\u001a,'o\u0018\u0013fcR\u0019\u0011-a\u0005\t\u0011\u0005%\u0011#!AA\u0002m\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002\n1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u000e!\rq\u0015QD\u0005\u0004\u0003?y%A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u001dI\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Ck\u001a4WM]*vaBd\u0017.\u001a:!\u0003\u0015\u0019G.Z1o)\u0011\t9#!\u000f\u0011\u000f%\nI#!\f\u00024%\u0019\u00111\u0006\u0016\u0003\rQ+\b\u000f\\33!\rI\u0013qF\u0005\u0004\u0003cQ#\u0001\u0002'p]\u001e\u00042APA\u001b\u0013\r\t9d\t\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\b\u0003w)\u0002\u0019AA\u001f\u0003%\u0019G.Z1oC\ndW\rE\u0002?\u0003\u007fI1!!\u0011$\u0005)aun\u001a+p\u00072,\u0017M\\\u0001\bI>\u001cE.Z1o)\u0019\t9#a\u0012\u0002J!9\u00111\b\fA\u0002\u0005u\u0002bBA&-\u0001\u0007\u0011QF\u0001\u0010I\u0016dW\r^3I_JL'p\u001c8Ng\u0006i1\r\\3b]N+w-\\3oiN$R\"YA)\u00033\ny'a\u001d\u0002v\u0005e\u0004B\u0002\u0013\u0018\u0001\u0004\t\u0019\u0006E\u0002?\u0003+J1!a\u0016$\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005ms\u00031\u0001\u0002^\u0005A1/Z4nK:$8\u000f\u0005\u0004\u0002`\u0005\u0015\u0014\u0011N\u0007\u0003\u0003CR1!a\u0019+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\n\tGA\u0002TKF\u00042APA6\u0013\r\tig\t\u0002\u000b\u0019><7+Z4nK:$\bBBA9/\u0001\u0007Q(A\u0002nCBDq!a\u0013\u0018\u0001\u0004\ti\u0003C\u0004\u0002x]\u0001\r!a\r\u0002\u000bM$\u0018\r^:\t\u000f\u0005mt\u00031\u0001\u0002~\u0005\u0019BO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u0019a(a \n\u0007\u0005\u00055E\u0001\u000eDY\u0016\fg.\u001a3Ue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-A\u0005dY\u0016\fg.\u00138u_R\u0019\u0012-a\"\u0002\f\u0006m\u0015qTAQ\u0003W\u000by+!-\u0002R\"1\u0011\u0011\u0012\rA\u0002u\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u000eb\u0001\r!a$\u0002\u001bM|WO]2f%\u0016\u001cwN\u001d3t!\u0011\t\t*a&\u000e\u0005\u0005M%bAAK!\u00061!/Z2pe\u0012LA!!'\u0002\u0014\nYa)\u001b7f%\u0016\u001cwN\u001d3t\u0011\u001d\ti\n\u0007a\u0001\u0003S\nA\u0001Z3ti\"1\u0011\u0011\u000f\rA\u0002uBq!a)\u0019\u0001\u0004\t)+\u0001\u000esKR\f\u0017N\u001c#fY\u0016$Xm]!oIRCh.T1sW\u0016\u00148\u000fE\u0002*\u0003OK1!!++\u0005\u001d\u0011un\u001c7fC:Da!!,\u0019\u0001\u00049\u0014!E7bq2{w-T3tg\u0006<WmU5{K\"9\u00111\u0010\rA\u0002\u0005u\u0004bBAZ1\u0001\u0007\u0011QW\u0001\u001dY\u0006\u001cHOU3d_J$7o\u00144BGRLg/\u001a)s_\u0012,8-\u001a:t!!\t9,!2\u0002.\u0005-g\u0002BA]\u0003\u0003\u00042!a/+\u001b\t\tiLC\u0002\u0002@V\na\u0001\u0010:p_Rt\u0014bAAbU\u00051\u0001K]3eK\u001aLA!a2\u0002J\n\u0019Q*\u00199\u000b\u0007\u0005\r'\u0006E\u0002?\u0003\u001bL1!a4$\u0005)a\u0015m\u001d;SK\u000e|'\u000f\u001a\u0005\b\u0003oB\u0002\u0019AA\u001a\u0003E9'o\\<Ck\u001a4WM]:Pe\u001a\u000b\u0017\u000e\u001c\u000b\nC\u0006]\u0017\u0011\\Ao\u0003?Dq!!$\u001a\u0001\u0004\ty\t\u0003\u0004\u0002\\f\u0001\raN\u0001\ta>\u001c\u0018\u000e^5p]\"1\u0011QV\rA\u0002]Bq!!9\u001a\u0001\u0004\t\u0019/A\u0007nK6|'/\u001f*fG>\u0014Hm\u001d\t\u0005\u0003#\u000b)/\u0003\u0003\u0002h\u0006M%!D'f[>\u0014\u0018PU3d_J$7/\u0001\ntQ>,H\u000e\u001a#jg\u000e\f'\u000f\u001a\"bi\u000eDG\u0003CAS\u0003[\f90!?\t\u000f\u0005=(\u00041\u0001\u0002r\u0006)!-\u0019;dQB!\u0011\u0011SAz\u0013\u0011\t)0a%\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\b\u0003wR\u0002\u0019AA?\u0011\u001d\tYP\u0007a\u0001\u0003K\u000b\u0001C]3uC&tG\u000b\u001f8NCJ\\WM]:\u0002%MDw.\u001e7e%\u0016$\u0018-\u001b8SK\u000e|'\u000f\u001a\u000b\u000b\u0003K\u0013\tAa\u0001\u0003\b\t=\u0001BBA97\u0001\u0007Q\bC\u0004\u0003\u0006m\u0001\r!!*\u0002\u001bI,G/Y5o\t\u0016dW\r^3t\u0011\u001d\t)j\u0007a\u0001\u0005\u0013\u0001B!!%\u0003\f%!!QBAJ\u0005\u0019\u0011VmY8sI\"9\u0011qO\u000eA\u0002\u0005M\u0012aC4s_^\u0014UO\u001a4feN$2!\u0019B\u000b\u0011\u0019\ti\u000b\ba\u0001o\u0005q!/Z:u_J,')\u001e4gKJ\u001cH#A1\u0002'\u001d\u0014x.\u001e9TK\u001elWM\u001c;t\u0005f\u001c\u0016N_3\u0015\u0015\t}!\u0011\u0007B\u001d\u0005{\u0011\t\u0005\u0005\u0004\u0003\"\t-\u0012Q\f\b\u0005\u0005G\u00119C\u0004\u0003\u0002<\n\u0015\u0012\"A\u0016\n\u0007\t%\"&A\u0004qC\u000e\\\u0017mZ3\n\t\t5\"q\u0006\u0002\u0005\u0019&\u001cHOC\u0002\u0003*)Bq!a\u0017\u001f\u0001\u0004\u0011\u0019\u0004\u0005\u0004\u0002`\tU\u0012\u0011N\u0005\u0005\u0005o\t\tG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u0019\u0011YD\ba\u0001o\u00059Q.\u0019=TSj,\u0007B\u0002B =\u0001\u0007q'\u0001\u0007nCbLe\u000eZ3y'&TX\rC\u0004\u0003Dy\u0001\r!!\f\u0002-\u0019L'o\u001d;V]\u000edW-\u00198bE2,wJ\u001a4tKR\f\u0011\u0004\\1ti>3gm]3u\r>\u0014h)\u001b:tiN+w-\\3oiR1\u0011Q\u0006B%\u0005\u001fBqAa\u0013 \u0001\u0004\u0011i%\u0001\u0003tK\u001e\u001c\bC\u0002B\u0011\u0005W\tI\u0007C\u0004\u0003D}\u0001\r!!\f\u0002\u001d\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'baRY\u0011M!\u0016\u0003X\tm#q\fB1\u0011\u0019!\u0003\u00051\u0001\u0002T!9!\u0011\f\u0011A\u0002\u00055\u0012!B:uCJ$\bb\u0002B/A\u0001\u0007\u0011QF\u0001\u0004K:$\u0007BBA9A\u0001\u0007Q\bC\u0004\u0002x\u0001\u0002\r!a\r\u00021\t,\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\u001a{'oU3h[\u0016tG\u000f\u0006\n\u0002&\n\u001d$\u0011\u000eB7\u0005_\u0012\u0019Ha\u001e\u0003z\tm\u0004BBAEC\u0001\u0007Q\fC\u0004\u0003l\u0005\u0002\r!!\u001b\u0002\u000fM,w-\\3oi\"1\u0011\u0011O\u0011A\u0002uBqA!\u001d\"\u0001\u0004\ti#A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bb\u0002B;C\u0001\u0007\u0011QF\u0001\u0017]\u0016DHoU3h[\u0016tGo\u0015;beR|eMZ:fi\"1\u0011QV\u0011A\u0002]Bq!a\u001f\"\u0001\u0004\ti\bC\u0004\u0002x\u0005\u0002\r!a\r")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        void var8_6;
        void var10_7;
        long l;
        if (BoxesRunTime.equalsNumObject((Number)cleanable.log().config().deleteRetentionMs(), (Object)BoxesRunTime.boxToInteger((int)0))) {
            l = Long.MAX_VALUE;
        } else {
            long l2;
            Option option = cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset()).lastOption();
            if (None$.MODULE$.equals(option)) {
                l2 = 0L;
            } else if (option instanceof Some) {
                l2 = ((LogSegment)((Some)option).value()).lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
            } else {
                throw new MatchError((Object)option);
            }
            l = l2;
        }
        long deleteHorizonMs = l;
        Tuple2<Object, CleanerStats> tuple2 = this.doClean(cleanable, deleteHorizonMs);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        CleanerStats cleanerStats = (CleanerStats)tuple2._2();
        double bytesShrinkageRatio = 1.0 - (double)var10_7.bytesWritten() / (double)var10_7.bytesRead();
        cleanable.log().updateLastShrinkageRatio(bytesShrinkageRatio);
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)var8_6), (Object)var10_7);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.localLogSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.localLogSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs, stats, transactionMetadata);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats, CleanedTransactionMetadata transactionMetadata) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> map.latestOffset() + 1L));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainDeletesAndTxnMarkers = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with deletion horizon ").append(deleteHorizonMs).append(", ").append((Object)(retainDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletesAndTxnMarkers, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments, log.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletesAndTxnMarkers, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, transactionMetadata, retainDeletesAndTxnMarkers, lastRecordsOfActiveProducers, map, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final boolean retainDeletesAndTxnMarkers$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2, this.retainDeletesAndTxnMarkers$2));
                if (batch.hasProducerId() && this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).exists((Function1 & Serializable & scala.Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch, lastRecord)))) {
                    return MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY;
                }
                if (this.discardBatchRecords()) {
                    return MemoryRecords.RecordFilter.BatchRetention.DELETE;
                }
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$2, this.retainDeletesAndTxnMarkers$2, record, this.stats$3);
            }

            public void onBatchRetained(RecordBatch batch) {
                this.transactionMetadata$2.onBatchRetained(batch);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                boolean bl;
                Option<Object> option = lastRecord.lastDataOffset();
                if (option instanceof Some) {
                    long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    bl = batch$1.lastOffset() == offset;
                } else if (None$.MODULE$.equals(option)) {
                    bl = batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch();
                } else {
                    throw new MatchError(option);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.retainDeletesAndTxnMarkers$2 = retainDeletesAndTxnMarkers$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$2 = map$2;
                this.stats$3 = stats$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch kafka.log.LastRecord )}, serializedLambda);
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch) && !retainTxnMarkers;
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, Record record, CleanerStats stats) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean bl = isRetainedValue = record.hasValue() || retainDeletes;
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(AbstractLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.localLogSegments(start, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1 & Serializable & scala.Serializable)nextSegment -> {
                nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                return BoxedUnit.UNIT;
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).withFilter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$16))).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, full, map, start, transactionMetadata, stats, dirty, x$17);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(this, transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(nextSegmentStartOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$16) {
        if (x$16 == null) {
            throw new MatchError(null);
        }
        boolean bl = !full$1.elem;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, AbstractLog log$4, BooleanRef full$1, OffsetMap map$3, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Buffer dirty$1, Tuple2 x$17) {
        if (x$17 != null) {
            LogSegment segment = (LogSegment)x$17._1();
            long nextSegmentStartOffset = x$17._2$mcJ$sp();
            $this.checkDone.apply((Object)log$4.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$4.topicPartition(), segment, map$3, start$1, nextSegmentStartOffset, Predef$.MODULE$.Integer2int(log$4.config().maxMessageSize()), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$1, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey2$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$5, long startOffset$1, OffsetMap map$4, int maxDesiredMapSize$1, Object nonLocalReturnKey2$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
            stats$5.indexMessagesRead(1);
        } else if (transactionMetadata$4.onBatchRead((RecordBatch)batch)) {
            stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
        } else {
            try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
                ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$1, map$4, maxDesiredMapSize$1, nonLocalReturnKey2$1, stats$5, record);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (batch.lastOffset() >= startOffset$1) {
            map$4.updateLatestOffset(batch.lastOffset());
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

