/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r\u0015c\u0001B!C\u0001\u001dC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tK\u0002\u0011)\u0019!C\u0001M\"AQ\u000f\u0001B\u0001B\u0003%q\r\u0003\u0005w\u0001\t\u0015\r\u0011\"\u0001x\u0011%\t\u0019\u0002\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t\t\u0003\u0001B\u0001B\u0003%\u00111\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\ti\u0004\u0001a\u0001\n\u0013\ty\u0004C\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002D!9\u0011q\n\u0001!B\u0013\t\u0007BCA-\u0001\t\u0007I\u0011\u0001\"\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007\u0003\u0006\u0002r\u0001\u0011\r\u0011\"\u0001C\u0003gB\u0001Ba\u0012\u0001A\u0003%\u0011Q\u000f\u0005\b\u0005\u0013\u0002A\u0011\u0002B&\u0011!\u0011i\u0006\u0001C\u0001\u0005\n}\u0003b\u0002B1\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005G\u0002A\u0011AAu\u0011\u001d\u0011)\u0007\u0001C!\u0005OBqAa\u001c\u0001\t\u0003\u0012\t\bC\u0004\u0003~\u0001!\tEa \t\u000f\t\u001d\u0005\u0001\"\u0001\u0003\n\"9!Q\u0012\u0001\u0005\u0002\t=\u0005\"\u0003BP\u0001E\u0005I\u0011\u0001BQ\u0011\u001d\u00119\f\u0001C\u0001\u0005sCqA!2\u0001\t\u0003\u00119\rC\u0004\u0003N\u0002!\tAa4\t\u000f\te\u0007\u0001\"\u0001\u0003\\\"9!q\u001c\u0001\u0005\u0002\t\u0005\bb\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\n\u0005s\u0004\u0011\u0013!C\u0001\u0005wDqAa@\u0001\t\u0003\u0019\t\u0001\u0003\u0005\u0004\f\u0001!\t\u0001RA \u0011!\u0019i\u0001\u0001C\u0001\u0005\n}caBAC\u0001\u0001\u0011\u0015q\u0011\u0005\u000b\u0003\u001f;#\u0011!Q\u0001\n\u0005E\u0005bBA\u0017O\u0011\u0005\u0011q\u0013\u0005\b\u00037;C\u0011KAO\u0011%\tYk\nb\u0001\n\u0003\ti\u000b\u0003\u0005\u00026\u001e\u0002\u000b\u0011BAX\u0011%\t9l\na\u0001\n\u0003\tI\fC\u0005\u0002B\u001e\u0002\r\u0011\"\u0001\u0002D\"A\u0011qY\u0014!B\u0013\tY\fC\u0005\u0002L\u001e\u0002\r\u0011\"\u0001\u0002N\"I\u0011Q[\u0014A\u0002\u0013\u0005\u0011q\u001b\u0005\t\u00037<\u0003\u0015)\u0003\u0002P\"9\u0011q\\\u0014\u0005\n\u0005\u0005\bbBAtO\u0011\u0005\u0013\u0011\u001e\u0005\b\u0003W<C\u0011BAw\u0011\u001d\t)p\nC\u0005\u0003[DqAa\u0002(\t\u0013\u0011I\u0001C\u0004\u0003\u0016\u001d\"\tAa\u0006\b\u000f\r=!\t#\u0001\u0004\u0012\u00191\u0011I\u0011E\u0001\u0007'Aq!!\f;\t\u0003\u0019)\u0002C\u0005\u0004\u0018i\u0012\r\u0011\"\u0001\u0004\u001a!A1Q\u0004\u001e!\u0002\u0013\u0019Y\u0002C\u0004\u0004 i\"\ta!\t\t\u000f\r\u0015\"\b\"\u0001\u0004(!I1q\b\u001e\u0012\u0002\u0013\u00051\u0011\t\u0002\u000b\u0019><7\t\\3b]\u0016\u0014(BA\"E\u0003\rawn\u001a\u0006\u0002\u000b\u0006)1.\u00194lC\u000e\u00011#\u0002\u0001I\u001dRS\u0006CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g\r\u0005\u0002P%6\t\u0001K\u0003\u0002R\t\u0006)Q\u000f^5mg&\u00111\u000b\u0015\u0002\b\u0019><w-\u001b8h!\t)\u0006,D\u0001W\u0015\t9F)A\u0004nKR\u0014\u0018nY:\n\u0005e3&!E&bM.\fW*\u001a;sS\u000e\u001cxI]8vaB\u00111LX\u0007\u00029*\u0011Q\fR\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}c&\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW-A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003E\u000el\u0011AQ\u0005\u0003I\n\u0013Qb\u00117fC:,'oQ8oM&<\u0017a\u00027pO\u0012K'o]\u000b\u0002OB\u0019\u0001n[7\u000e\u0003%T!A\u001b&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mS\n\u00191+Z9\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018AA5p\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\t\u0019KG.Z\u0001\tY><G)\u001b:tA\u0005!An\\4t+\u0005A\b#B(zw\u00065\u0011B\u0001>Q\u0005\u0011\u0001vn\u001c7\u0011\u0007q\fI!D\u0001~\u0015\tqx0\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0006\u0005!\u0002BA\u0002\u0003\u000b\ta!\u00199bG\",'BAA\u0004\u0003\ry'oZ\u0005\u0004\u0003\u0017i(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004E\u0006=\u0011bAA\t\u0005\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0003\u0015awnZ:!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\u0011\u0011\u0011\u0004\t\u00047\u0006m\u0011bAA\u000f9\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0003uS6,\u0007\u0003BA\u0013\u0003Si!!a\n\u000b\u0005Ek\u0018\u0002BA\u0016\u0003O\u0011A\u0001V5nK\u00061A(\u001b8jiz\"B\"!\r\u00024\u0005U\u0012qGA\u001d\u0003w\u0001\"A\u0019\u0001\t\u000b\u0001L\u0001\u0019A1\t\u000b\u0015L\u0001\u0019A4\t\u000bYL\u0001\u0019\u0001=\t\u000f\u0005U\u0011\u00021\u0001\u0002\u001a!I\u0011\u0011E\u0005\u0011\u0002\u0003\u0007\u00111E\u0001\u0007G>tg-[4\u0016\u0003\u0005\f!bY8oM&<w\fJ3r)\u0011\t)%a\u0013\u0011\u0007%\u000b9%C\u0002\u0002J)\u0013A!\u00168ji\"A\u0011QJ\u0006\u0002\u0002\u0003\u0007\u0011-A\u0002yIE\nqaY8oM&<\u0007\u0005K\u0002\r\u0003'\u00022!SA+\u0013\r\t9F\u0013\u0002\tm>d\u0017\r^5mK\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014XCAA/!\r\u0011\u0017qL\u0005\u0004\u0003C\u0012%!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe\u0006y1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b%A\u0005uQJ|G\u000f\u001e7feV\u0011\u0011\u0011\u000e\t\u0004\u001f\u0006-\u0014bAA7!\nIA\u000b\u001b:piRdWM]\u0001\u000bi\"\u0014x\u000e\u001e;mKJ\u0004\u0013\u0001C2mK\u0006tWM]:\u0016\u0005\u0005U\u0004CBA<\u0003{\n\t)\u0004\u0002\u0002z)\u0019\u00111P5\u0002\u000f5,H/\u00192mK&!\u0011qPA=\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u0005\ru%D\u0001\u0001\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0019q%!#\u0011\u0007=\u000bY)C\u0002\u0002\u000eB\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006AA\u000f\u001b:fC\u0012LE\rE\u0002J\u0003'K1!!&K\u0005\rIe\u000e\u001e\u000b\u0005\u0003\u0003\u000bI\nC\u0004\u0002\u0010&\u0002\r!!%\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0002 B!\u0011\u0011UAT\u001b\t\t\u0019KC\u0002\u0002&F\fA\u0001\\1oO&!\u0011\u0011VAR\u0005\u0019\u0019FO]5oO\u000691\r\\3b]\u0016\u0014XCAAX!\r\u0011\u0017\u0011W\u0005\u0004\u0003g\u0013%aB\"mK\u0006tWM]\u0001\tG2,\u0017M\\3sA\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003w\u00032AYA_\u0013\r\tyL\u0011\u0002\r\u00072,\u0017M\\3s'R\fGo]\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\t\u0005\u0015\u0013Q\u0019\u0005\n\u0003\u001br\u0013\u0011!a\u0001\u0003w\u000b!\u0002\\1tiN#\u0018\r^:!Q\ry\u00131K\u0001\u0012Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cXCAAh!\r\u0011\u0017\u0011[\u0005\u0004\u0003'\u0014%!\u0004)sK\u000ecW-\u00198Ti\u0006$8/A\u000bmCN$\bK]3DY\u0016\fgn\u0015;biN|F%Z9\u0015\t\u0005\u0015\u0013\u0011\u001c\u0005\n\u0003\u001b\n\u0014\u0011!a\u0001\u0003\u001f\f!\u0003\\1tiB\u0013Xm\u00117fC:\u001cF/\u0019;tA!\u001a!'a\u0015\u0002\u0013\rDWmY6E_:,G\u0003BA#\u0003GDa!!:4\u0001\u0004Y\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007I><vN]6\u0015\u0005\u0005\u0015\u0013\u0001\u0006;ss\u000ecW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u0002pB\u0019\u0011*!=\n\u0007\u0005M(JA\u0004C_>dW-\u00198\u0002#\rdW-\u00198GS2$\b.[3ti2{w\rK\u00037\u0003s\u0014)\u0001E\u0003J\u0003w\fy0C\u0002\u0002~*\u0013a\u0001\u001e5s_^\u001c\bc\u00012\u0003\u0002%\u0019!1\u0001\"\u0003)1{wm\u00117fC:LgnZ#yG\u0016\u0004H/[8oG\t\ty0\u0001\u0005dY\u0016\fg\u000eT8h)\u0011\t)Ea\u0003\t\u000f\t5q\u00071\u0001\u0003\u0010\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0004E\nE\u0011b\u0001B\n\u0005\nQAj\\4U_\u000ecW-\u00198\u0002\u0017I,7m\u001c:e'R\fGo\u001d\u000b\r\u0003\u000b\u0012IB!\b\u00036\t}\"1\t\u0005\b\u00057A\u0004\u0019AAI\u0003\tIG\rC\u0004\u0003 a\u0002\rA!\t\u0002\t9\fW.\u001a\t\u0005\u0005G\u0011\tD\u0004\u0003\u0003&\t5\u0002c\u0001B\u0014\u00156\u0011!\u0011\u0006\u0006\u0004\u0005W1\u0015A\u0002\u001fs_>$h(C\u0002\u00030)\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAU\u0005gQ1Aa\fK\u0011\u001d\u00119\u0004\u000fa\u0001\u0005s\tAA\u001a:p[B\u0019\u0011Ja\u000f\n\u0007\tu\"J\u0001\u0003M_:<\u0007b\u0002B!q\u0001\u0007!\u0011H\u0001\u0003i>DqA!\u00129\u0001\u0004\tY,A\u0003ti\u0006$8/A\u0005dY\u0016\fg.\u001a:tA\u0005)R.\u0019=Pm\u0016\u00148\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cH\u0003BAI\u0005\u001bBqAa\u0014\u0014\u0001\u0004\u0011\t&A\u0001g!\u001dI%1KAA\u0005/J1A!\u0016K\u0005%1UO\\2uS>t\u0017\u0007E\u0002J\u00053J1Aa\u0017K\u0005\u0019!u.\u001e2mK\u0006yA-Z1e)\"\u0014X-\u00193D_VtG/\u0006\u0002\u0002\u0012\u000691\u000f^1siV\u0004\u0018\u0001C:ikR$wn\u001e8\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!\u0011\u000e\t\u0006Q\n-$\u0011E\u0005\u0004\u0005[J'aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003\u000b\u0012\u0019\bC\u0004\u0003va\u0001\rAa\u001e\u0002\u00139,woQ8oM&<\u0007cA.\u0003z%\u0019!1\u0010/\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002F\t\u0005%Q\u0011\u0005\b\u0005\u0007K\u0002\u0019\u0001B<\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0003ve\u0001\rAa\u001e\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\t)Ea#\t\r\u0005\u0015(\u00041\u0001|\u0003E)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u000b\u0007\u0003\u000b\u0012\tJ!&\t\r\tM5\u00041\u0001n\u0003\u001d!\u0017\r^1ESJD\u0011Ba&\u001c!\u0003\u0005\rA!'\u0002#A\f'\u000f^5uS>tGk\u001c*f[>4X\r\u0005\u0003J\u00057[\u0018b\u0001BO\u0015\n1q\n\u001d;j_:\f1$\u001e9eCR,7\t[3dWB|\u0017N\u001c;tI\u0011,g-Y;mi\u0012\u0012TC\u0001BRU\u0011\u0011IJ!*,\u0005\t\u001d\u0006\u0003\u0002BU\u0005gk!Aa+\u000b\t\t5&qV\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!-K\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005k\u0013YKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeRA\u0011Q\tB^\u0005{\u0013\t\r\u0003\u0004\u0002fv\u0001\ra\u001f\u0005\u0007\u0005\u007fk\u0002\u0019A7\u0002\u0019M|WO]2f\u0019><G)\u001b:\t\r\t\rW\u00041\u0001n\u0003)!Wm\u001d;M_\u001e$\u0015N]\u0001\u0014Q\u0006tG\r\\3M_\u001e$\u0015N\u001d$bS2,(/\u001a\u000b\u0005\u0003\u000b\u0012I\rC\u0004\u0003Lz\u0001\rA!\t\u0002\u0007\u0011L'/A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u0011Q\tBi\u0005'\u0014)\u000e\u0003\u0004\u0003\u0014~\u0001\r!\u001c\u0005\u0007\u0003K|\u0002\u0019A>\t\u000f\t]w\u00041\u0001\u0003:\u00051qN\u001a4tKR\fQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\r\u0006\u0003\u0002F\tu\u0007BBAsA\u0001\u000710\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\t\u0005\u0015#1\u001d\u0005\b\u0005K\f\u0003\u0019\u0001Bt\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u00025\u0003jnL1Aa;j\u0005!IE/\u001a:bE2,\u0017\u0001D1xC&$8\t\\3b]\u0016$G\u0003CAx\u0005c\u0014\u0019P!>\t\r\u0005\u0015(\u00051\u0001|\u0011\u001d\u00119N\ta\u0001\u0005sA\u0011Ba>#!\u0003\u0005\rA!\u000f\u0002\u00135\f\u0007pV1ji6\u001b\u0018AF1xC&$8\t\\3b]\u0016$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu(\u0006\u0002B\u001d\u0005K\u000ba\u0005]1vg\u0016\u001cE.Z1oS:<gi\u001c:O_:\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8t)\t\u0019\u0019\u0001E\u0003i\u0005S\u001c)\u0001\u0005\u0004J\u0007\u000fY\u0018QB\u0005\u0004\u0007\u0013Q%A\u0002+va2,''A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\rG2,\u0017M\\3s\u0007>,h\u000e^\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bC\u00012;'\tQ\u0004\n\u0006\u0002\u0004\u0012\u0005)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cXCAB\u000e!\u0015A'1NAP\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!D2mK\u0006tWM]\"p]\u001aLw\rF\u0002b\u0007GAq!!\u0010?\u0001\u0004\u00119(A\fde\u0016\fG/\u001a(fo\u000ecW-\u00198fIN+w-\\3oiRA1\u0011FB\u0018\u0007c\u0019Y\u0004E\u0002c\u0007WI1a!\fC\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0007\u0005\u0017|\u0004\u0019A7\t\u000f\rMr\b1\u0001\u00046\u0005IAn\\4D_:4\u0017n\u001a\t\u0004E\u000e]\u0012bAB\u001d\u0005\nIAj\\4D_:4\u0017n\u001a\u0005\b\u0007{y\u0004\u0019\u0001B\u001d\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\r#\u0006BA\u0012\u0005K\u0003")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static LogSegment createNewCleanedSegment(File file, LogConfig logConfig, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(file, logConfig, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else if (option instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)option).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(option);
            }
            Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                this.maybeDeleteOldSegments$1(deletable);
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ void $anonfun$cleanFilthiestLog$1(CleanerThread $this, IntRef total$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                AbstractLog log = (AbstractLog)x0$1._2();
                if (total$1.elem >= $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Log cleanup reached the limit of maximum segments that can be deleted limit ").append($this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()).append(", ").append(total$1.elem).append(" files deleted").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                if (log.isFrozenLogStartOffsetState()) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Log cleanup blocked for ").append(log).append(" as it is in frozen start offset state").toString());
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
                }
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Garbage collecting '").append(log.name()).append("'").toString());
                try {
                    int limit = $this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun() - total$1.elem;
                    total$1.elem += log.deleteOldSegments(limit);
                    return;
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs) {
            Object object = new Object();
            try {
                IntRef total = IntRef.create((int)0);
                deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    CleanerThread.$anonfun$cleanFilthiestLog$1(this, total, object, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object) {
                    ex.value$mcV$sp();
                    return;
                }
                throw ex;
            }
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

