/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbstractLog;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMc!B\u001f?\u0001y\u0012\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011A,\t\u0011\u0019\u0004!\u0011!Q\u0001\naC\u0001b\u001a\u0001\u0003\u0006\u0004%\t\u0001\u001b\u0005\tw\u0002\u0011\t\u0011)A\u0005S\"AA\u0010\u0001BC\u0002\u0013\u0005Q\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005}\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\f\u0001\u0011E\u0013\u0011\u0004\u0005\u000b\u0003O\u0001!\u0019!C\u0001}\u0005e\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\u0007\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0002\"CA#\u0001\u0001\u0007I\u0011BA$\u0011!\t\u0019\u0006\u0001Q!\n\u0005=\u0002\"CA/\u0001\t\u0007I\u0011BA0\u0011!\t\u0019\b\u0001Q\u0001\n\u0005\u0005\u0004\"CA;\u0001\t\u0007I\u0011BA<\u0011!\t)\n\u0001Q\u0001\n\u0005e\u0004\"CAL\u0001\t\u0007I\u0011BAM\u0011!\ty\u000b\u0001Q\u0001\n\u0005m\u0005\"CAY\u0001\t\u0007I\u0011BAZ\u0011!\tY\f\u0001Q\u0001\n\u0005U\u0006\"CA_\u0001\u0001\u0007I\u0011BA`\u0011%\t9\r\u0001a\u0001\n\u0013\tI\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0015BAa\u0011%\t\t\u000e\u0001a\u0001\n\u0013\t\u0019\u000eC\u0005\u0002\\\u0002\u0001\r\u0011\"\u0003\u0002^\"A\u0011\u0011\u001d\u0001!B\u0013\t)\u000eC\u0005\u0002f\u0002\u0011\r\u0011\"\u0003\u0002h\"A\u0011q \u0001!\u0002\u0013\tI\u000fC\u0004\u0003\u0002\u0001!\tAa\u0001\t\u0011\t%\u0001\u0001\"\u0001?\u0005\u0017A\u0001Ba\u0006\u0001\t\u0003q$\u0011\u0004\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011%\u0011)\u0005AI\u0001\n\u0003\u00119\u0005C\u0004\u0003^\u0001!\tAa\u0018\t\u000f\t5\u0004\u0001\"\u0001\u0003`!9!q\u000e\u0001\u0005\u0002\tE\u0004b\u0002B<\u0001\u0011\u0005!\u0011\u0010\u0005\b\u0005{\u0002A\u0011\u0001B@\u0011\u001d\u00119\t\u0001C\u0005\u0005\u0013CqAa&\u0001\t\u0013\u0011I\nC\u0004\u0003\u001e\u0002!\tAa(\t\u000f\t\r\u0006\u0001\"\u0001\u0003&\"I!\u0011\u0018\u0001\u0012\u0002\u0013\u0005!1\u0018\u0005\n\u0005\u007f\u0003\u0011\u0013!C\u0001\u0005\u0003DqA!2\u0001\t\u0003\u00119\rC\u0004\u0003T\u0002!\tA!6\t\u000f\tm\u0007\u0001\"\u0001\u0003^\"9!q\u001d\u0001\u0005\u0002\t%\bb\u0002Bz\u0001\u0011\u0005!Q\u001f\u0005\t\u0003k\u0002A\u0011\u0001 \u0003z\"911\u0001\u0001\u0005\u0002\r\u0015\u0001bBB\u0007\u0001\u0011%1qB\u0004\t\u0007+q\u0004\u0012\u0001 \u0004\u0018\u00199QH\u0010E\u0001}\re\u0001bBA\u0006o\u0011\u000511\u0004\u0005\b\u0007;9D\u0011AB\u0010\u0011\u001d\u0019\u0019c\u000eC\u0001\u0007KAqa!\r8\t\u0003\u0019\u0019\u0004C\u0004\u0004F]\"\taa\u0012\u0003#1{wm\u00117fC:,'/T1oC\u001e,'O\u0003\u0002@\u0001\u0006\u0019An\\4\u000b\u0003\u0005\u000bQa[1gW\u0006\u001cB\u0001A\"J\u001fB\u0011AiR\u0007\u0002\u000b*\ta)A\u0003tG\u0006d\u0017-\u0003\u0002I\u000b\n1\u0011I\\=SK\u001a\u0004\"AS'\u000e\u0003-S!\u0001\u0014!\u0002\u000bU$\u0018\u000e\\:\n\u00059[%a\u0002'pO\u001eLgn\u001a\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0002\u000bq!\\3ue&\u001c7/\u0003\u0002U#\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u000f1|w\rR5sg\u000e\u0001Q#\u0001-\u0011\u0007ecf,D\u0001[\u0015\tYV)\u0001\u0006d_2dWm\u0019;j_:L!!\u0018.\u0003\u0007M+\u0017\u000f\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006\u0011\u0011n\u001c\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0002SB!!J\u001b7x\u0013\tY7J\u0001\u0003Q_>d\u0007CA7v\u001b\u0005q'BA8q\u0003\u0019\u0019w.\\7p]*\u0011\u0011)\u001d\u0006\u0003eN\fa!\u00199bG\",'\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002w]\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001=z\u001b\u0005q\u0014B\u0001>?\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002\u000b1|wm\u001d\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007\u0001\u0015AB:feZ,'/\u0003\u0003\u0002\b\u0005\u0005!\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\rqJg.\u001b;?)!\ty!!\u0005\u0002\u0014\u0005U\u0001C\u0001=\u0001\u0011\u0015)v\u00011\u0001Y\u0011\u00159w\u00011\u0001j\u0011\u0015ax\u00011\u0001\u007f\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0011\u0017\u0001\u00027b]\u001eLA!!\n\u0002 \t11\u000b\u001e:j]\u001e\fAc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rI\u0001\fG\",7m\u001b9pS:$8/\u0006\u0002\u00020A9\u0011\u0011GA\u001c=\u0006mRBAA\u001a\u0015\r\t)DW\u0001\nS6lW\u000f^1cY\u0016LA!!\u000f\u00024\t\u0019Q*\u00199\u0011\t\u0005u\u0012\u0011I\u0007\u0003\u0003\u007fQA!a\u000b\u0002\u0002%!\u00111IA \u0005QyeMZ:fi\u000eCWmY6q_&tGOR5mK\u0006y1\r[3dWB|\u0017N\u001c;t?\u0012*\u0017\u000f\u0006\u0003\u0002J\u0005=\u0003c\u0001#\u0002L%\u0019\u0011QJ#\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#b\u0011\u0011!a\u0001\u0003_\t1\u0001\u001f\u00132\u00031\u0019\u0007.Z2la>Lg\u000e^:!Q\ri\u0011q\u000b\t\u0004\t\u0006e\u0013bAA.\u000b\nAao\u001c7bi&dW-\u0001\u0006j]B\u0013xn\u001a:fgN,\"!!\u0019\u0011\u000f\u0005\r\u0014\u0011\u000e7\u0002n5\u0011\u0011Q\r\u0006\u0004\u0003OR\u0016aB7vi\u0006\u0014G.Z\u0005\u0005\u0003W\n)GA\u0004ICNDW*\u00199\u0011\u0007a\fy'C\u0002\u0002ry\u0012\u0001\u0003T8h\u00072,\u0017M\\5oON#\u0018\r^3\u0002\u0017%t\u0007K]8he\u0016\u001c8\u000fI\u0001\u0016k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8t+\t\tI\b\u0005\u0005\u0002d\u0005%\u00141PAH!\u0011\ti(a#\u000f\t\u0005}\u0014q\u0011\t\u0004\u0003\u0003+UBAAB\u0015\r\t)IV\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%U)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\tiIC\u0002\u0002\n\u0016\u0003R!a\u0019\u0002\u00122LA!a%\u0002f\t\u00191+\u001a;\u0002-Ut7\r\\3b]\u0006\u0014G.\u001a)beRLG/[8og\u0002\nA\u0001\\8dWV\u0011\u00111\u0014\t\u0005\u0003;\u000bY+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003\u0015awnY6t\u0015\u0011\t)+a*\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002*\n\fA!\u001e;jY&!\u0011QVAP\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\u0006)An\\2lA\u0005\u0011\u0002/Y;tK\u0012\u001cE.Z1oS:<7i\u001c8e+\t\t)\f\u0005\u0003\u0002\u001e\u0006]\u0016\u0002BA]\u0003?\u0013\u0011bQ8oI&$\u0018n\u001c8\u0002'A\fWo]3e\u00072,\u0017M\\5oO\u000e{g\u000e\u001a\u0011\u00023\u0011L'\u000f^5fgRdunZ\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\\\u000b\u0003\u0003\u0003\u00042\u0001RAb\u0013\r\t)-\u0012\u0002\u0007\t>,(\r\\3\u0002;\u0011L'\u000f^5fgRdunZ\"mK\u0006t\u0017M\u00197f%\u0006$\u0018n\\0%KF$B!!\u0013\u0002L\"I\u0011\u0011K\f\u0002\u0002\u0003\u0007\u0011\u0011Y\u0001\u001bI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw\u000e\t\u0015\u00041\u0005]\u0013!\u0004;j[\u0016|e\rT1tiJ+h.\u0006\u0002\u0002VB\u0019A)a6\n\u0007\u0005eWI\u0001\u0003M_:<\u0017!\u0005;j[\u0016|e\rT1tiJ+hn\u0018\u0013fcR!\u0011\u0011JAp\u0011%\t\tFGA\u0001\u0002\u0004\t).\u0001\buS6,wJ\u001a'bgR\u0014VO\u001c\u0011)\u0007m\t9&A\u000bbG\"LWM^3e\u00072,\u0017M\\5oOJ\u000bG/[8\u0016\u0005\u0005%\b\u0003BAv\u0003wl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\u0005G>\u0014XMC\u0002S\u0003gTA!!>\u0002x\u00061\u00110Y7nKJT!!!?\u0002\u0007\r|W.\u0003\u0003\u0002~\u00065(!\u0003%jgR|wM]1n\u0003Y\t7\r[5fm\u0016$7\t\\3b]&twMU1uS>\u0004\u0013!F1mY\u000ecW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u0003\u0005\u000b\u0001r!! \u0003\b1\f).\u0003\u0003\u0002:\u00055\u0015!D2mK\u0006t\u0017N\\4Ti\u0006$X\r\u0006\u0003\u0003\u000e\tM\u0001#\u0002#\u0003\u0010\u00055\u0014b\u0001B\t\u000b\n1q\n\u001d;j_:DaA!\u0006 \u0001\u0004a\u0017A\u0001;q\u0003A\u0019X\r^\"mK\u0006t\u0017N\\4Ti\u0006$X\r\u0006\u0004\u0002J\tm!Q\u0004\u0005\u0007\u0005+\u0001\u0003\u0019\u00017\t\u000f\t}\u0001\u00051\u0001\u0002n\u0005)1\u000f^1uK\u0006IrM]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\u0019\u0011)C!\f\u0003<A)AIa\u0004\u0003(A\u0019\u0001P!\u000b\n\u0007\t-bH\u0001\u0006M_\u001e$vn\u00117fC:DqAa\f\"\u0001\u0004\u0011\t$\u0001\u0003uS6,\u0007\u0003\u0002B\u001a\u0005oi!A!\u000e\u000b\u00051s\u0017\u0002\u0002B\u001d\u0005k\u0011A\u0001V5nK\"I!QH\u0011\u0011\u0002\u0003\u0007!qH\u0001\u000eaJ,7\t\\3b]N#\u0018\r^:\u0011\u0007a\u0014\t%C\u0002\u0003Dy\u0012Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018aI4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0013RCAa\u0010\u0003L-\u0012!Q\n\t\u0005\u0005\u001f\u0012I&\u0004\u0002\u0003R)!!1\u000bB+\u0003%)hn\u00195fG.,GMC\u0002\u0003X\u0015\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YF!\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"A!\u0019\u0011\u000be\u0013\u0019Ga\u001a\n\u0007\t\u0015$L\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0015!%\u0011\u000e7x\u0013\r\u0011Y'\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\u0011,G.\u001a;bE2,Gj\\4t\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011\u0011\nB:\u0011\u0019\u0011)(\na\u0001Y\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0013\u0012Y\b\u0003\u0004\u0003v\u0019\u0002\r\u0001\\\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\tIE!!\t\u000f\t\ru\u00051\u0001\u0003\u0006\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0003Z\u0005Gb\u0017!E5t\u00072,\u0017M\\5oO&s7\u000b^1uKR1!1\u0012BI\u0005'\u00032\u0001\u0012BG\u0013\r\u0011y)\u0012\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011)\b\u000ba\u0001Y\"9!Q\u0013\u0015A\u0002\u00055\u0014!D3ya\u0016\u001cG/\u001a3Ti\u0006$X-A\fjg\u000ecW-\u00198j]\u001eLen\u0015;bi\u0016\u0004\u0016-^:fIR!!1\u0012BN\u0011\u0019\u0011)(\u000ba\u0001Y\u0006!2\r[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012$B!!\u0013\u0003\"\"1!Q\u000f\u0016A\u00021\f\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)!\tIEa*\u0003,\nM\u0006B\u0002BUW\u0001\u0007a,A\u0004eCR\fG)\u001b:\t\u0013\t56\u0006%AA\u0002\t=\u0016A\u00069beRLG/[8o)>,\u0006\u000fZ1uK>\u0013\u0018\t\u001a3\u0011\u000b\u0011\u0013yA!-\u0011\r\u0011\u0013I\u0007\\Ak\u0011%\u0011)l\u000bI\u0001\u0002\u0004\u00119,A\tqCJ$\u0018\u000e^5p]R{'+Z7pm\u0016\u0004B\u0001\u0012B\bY\u0006YR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:%I\u00164\u0017-\u001e7uII*\"A!0+\t\t=&1J\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\r'\u0006\u0002B\\\u0005\u0017\n!#\u00197uKJ\u001c\u0005.Z2la>Lg\u000e\u001e#jeRA\u0011\u0011\nBe\u0005\u0017\u0014y\r\u0003\u0004\u0003v9\u0002\r\u0001\u001c\u0005\u0007\u0005\u001bt\u0003\u0019\u00010\u0002\u0019M|WO]2f\u0019><G)\u001b:\t\r\tEg\u00061\u0001_\u0003)!Wm\u001d;M_\u001e$\u0015N]\u0001\u0014Q\u0006tG\r\\3M_\u001e$\u0015N\u001d$bS2,(/\u001a\u000b\u0005\u0003\u0013\u00129\u000eC\u0004\u0003Z>\u0002\r!a\u001f\u0002\u0007\u0011L'/A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u0011\u0011\nBp\u0005C\u0014\u0019\u000f\u0003\u0004\u0003*B\u0002\rA\u0018\u0005\u0007\u0005k\u0002\u0004\u0019\u00017\t\u000f\t\u0015\b\u00071\u0001\u0002V\u00061qN\u001a4tKR\fA\u0002Z8oK\u000ecW-\u00198j]\u001e$\u0002\"!\u0013\u0003l\n5(q\u001e\u0005\u0007\u0005k\n\u0004\u0019\u00017\t\r\t%\u0016\u00071\u0001_\u0011\u001d\u0011\t0\ra\u0001\u0003+\f\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0002\u0019\u0011|g.\u001a#fY\u0016$\u0018N\\4\u0015\t\u0005%#q\u001f\u0005\b\u0005\u0007\u0013\u0004\u0019\u0001BC)\u0011\u0011YPa@\u0011\u000b\u0005u$Q 7\n\t\u0005M\u0015Q\u0012\u0005\b\u0007\u0003\u0019\u0004\u0019AA>\u0003\u0019awn\u001a#je\u0006AR.\u0019:l!\u0006\u0014H/\u001b;j_:,fn\u00197fC:\f'\r\\3\u0015\r\u0005%3qAB\u0005\u0011\u001d\u0019\t\u0001\u000ea\u0001\u0003wBaaa\u00035\u0001\u0004a\u0017!\u00039beRLG/[8o\u0003YI7/\u00168dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>tGC\u0002BF\u0007#\u0019\u0019\u0002C\u0003@k\u0001\u0007q\u000f\u0003\u0004\u0003vU\u0002\r\u0001\\\u0001\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\bC\u0001=8'\r94)\u0013\u000b\u0003\u0007/\t!#[:D_6\u0004\u0018m\u0019;B]\u0012$U\r\\3uKR!!1RB\u0011\u0011\u0015y\u0014\b1\u0001x\u0003Ii\u0017\r_\"p[B\f7\r^5p]\u0012+G.Y=\u0015\u0011\u0005U7qEB\u0015\u0007[AQa\u0010\u001eA\u0002]Dqaa\u000b;\u0001\u0004\t).\u0001\tgSJ\u001cH\u000fR5sif|eMZ:fi\"91q\u0006\u001eA\u0002\u0005U\u0017a\u00018po\u0006\u00012\r\\3b]\u0006\u0014G.Z(gMN,Go\u001d\u000b\t\u0007k\u0019Yd!\u0010\u0004DA\u0019\u0001pa\u000e\n\u0007\rebH\u0001\bPM\u001a\u001cX\r^:U_\u000ecW-\u00198\t\u000b}Z\u0004\u0019A<\t\u000f\r}2\b1\u0001\u0004B\u0005yA.Y:u\u00072,\u0017M\\(gMN,G\u000fE\u0003E\u0005\u001f\t)\u000eC\u0004\u00040m\u0002\r!!6\u0002/\r\fGnY;mCR,7\t\\3b]\u0006\u0014G.\u001a\"zi\u0016\u001cH\u0003CB%\u0007\u0017\u001aiea\u0014\u0011\u000f\u0011\u0013I'!6\u0002V\")q\b\u0010a\u0001o\"911\u0006\u001fA\u0002\u0005U\u0007bBB)y\u0001\u0007\u0011Q[\u0001\u0012k:\u001cG.Z1oC\ndWm\u00144gg\u0016$\b")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private final Histogram achievedCleaningRatio;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> calculateCleanableBytes(AbstractLog abstractLog, long l, long l2) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(abstractLog, l, l2);
    }

    public static OffsetsToClean cleanableOffsets(AbstractLog abstractLog, Option<Object> option, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(abstractLog, option, l);
    }

    public static long maxCompactionDelay(AbstractLog abstractLog, long l, long l2) {
        return LogCleanerManager$.MODULE$.maxCompactionDelay(abstractLog, l, l2);
    }

    public static boolean isCompactAndDelete(AbstractLog abstractLog) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(abstractLog);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    private double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    private void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    private Histogram achievedCleaningRatio() {
        return this.achievedCleaningRatio;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, AbstractLog>> deletableLogs() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public void abortCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (!bl) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                int count = logCleaningPaused.pausedCount();
                if (count <= 1) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            bl = !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            boolean bl2 = (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void checkCleaningAborted(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, partitionToRemove, partitionToUpdateOrAdd);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleLogDirFailure(String dir) {
        void inLock_lock;
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$4, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        void inLock_lock;
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((GenTraversableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    /*
     * WARNING - void declaration
     */
    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUncleanablePartition(AbstractLog log, TopicPartition topicPartition) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt((Object)$this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$2(File dir$1) {
        int n;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            n = LogCleanerManager.$anonfun$new$3(this, dir$1);
        }
        finally {
            inLock_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        void var9_8;
        Option lastCleanOffset;
        OffsetsToClean offsetsToClean;
        AbstractLog log = $this.logs().get(tp);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, (offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)(lastCleanOffset = lastClean$1.get((Object)tp)), now$1)).firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var9_8;
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        long l;
        Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
        if (option instanceof Some) {
            Set partitions = (Set)((Some)option).value();
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
            long now = Time.SYSTEM.milliseconds();
            l = BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$9($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else {
            throw new MatchError((Object)option);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$7(File dir$2) {
        long l;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            l = LogCleanerManager.$anonfun$new$8(this, dir$2);
        }
        finally {
            inLock_lock.unlock();
        }
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$new$12(File dir$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)x0$1._2();
        boolean bl = log.config().compact() && log.parentDir().equals(dir$3.getAbsolutePath());
        return bl;
    }

    public static final /* synthetic */ long $anonfun$new$13(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        long l = ((AbstractLog)x0$2._2()).size();
        return l;
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$11(File dir$3) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$new$12(dir$3, x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$13(x0$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$14() {
        return (int)((double)100 * this.dirtiestLogCleanableRatio());
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$15() {
        return Time.SYSTEM.milliseconds() - this.timeOfLastRun();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((TraversableOnce)$this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$1) {
        return $this.inProgress().get((Object)tp$1);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$2, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$2, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractLog)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        AbstractLog log = (AbstractLog)x0$2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition) || log.isFrozenLogStartOffsetState();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogToClean logToClean;
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                AbstractLog log = (AbstractLog)x0$3._2();
                try {
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (offsetsToClean.forceUpdateCheckpoint()) {
                        $this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), $this.updateCheckpoints$default$3());
                    }
                    long compactionDelayMs = LogCleanerManager$.MODULE$.maxCompactionDelay(log, offsetsToClean.firstDirtyOffset(), now);
                    preCleanStats$1.updateMaxCompactionDelay(compactionDelayMs);
                    logToClean = new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                }
            } else {
                throw new MatchError(null);
            }
            LogToClean logToClean2 = logToClean;
            return logToClean2;
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
        $this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        $this.achievedCleaningRatio().update((int)(filthiest.cleanableRatio() * (double)100));
        double expectedShrinkageRatio = filthiest.log().lastShrinkageRatio() * filthiest.cleanableRatio();
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Filthiest log %s has last.shrinkage.ratio=%.3f, dirty.ratio=%.3f, expected.shrinkage.ratio=%.3f %n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filthiest.log().name(), BoxesRunTime.boxToDouble((double)filthiest.log().lastShrinkageRatio()), BoxesRunTime.boxToDouble((double)filthiest.cleanableRatio()), BoxesRunTime.boxToDouble((double)expectedShrinkageRatio)})));
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = !((AbstractLog)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        void var1_1;
        Iterable deletableLogs = (Iterable)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            Option option = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        AbstractLog log = (AbstractLog)x0$1._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        void var1_1;
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Option option = $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition$1, (List)Nil$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
        if ($this.logs().get(topicPartition$3).isFrozenLogStartOffsetState()) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.logs().keys().contains((Object)tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option partitionToRemove$1, Option partitionToUpdateOrAdd$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2;
                scala.collection.immutable.Map currentCheckpoint = ((TraversableOnce)checkpoint.read().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
                if (partitionToRemove$1 instanceof Some) {
                    TopicPartition topicPartion = (TopicPartition)((Some)partitionToRemove$1).value();
                    map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartion);
                } else if (None$.MODULE$.equals(partitionToRemove$1)) {
                    map2 = currentCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToRemove$1);
                }
                if (partitionToUpdateOrAdd$1 instanceof Some) {
                    Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd$1).value();
                    map = map2.$plus(updatedOffset);
                } else if (None$.MODULE$.equals(partitionToUpdateOrAdd$1)) {
                    map = map2;
                } else {
                    throw new MatchError((Object)partitionToUpdateOrAdd$1);
                }
                checkpoint.write((Map<TopicPartition, Object>)map);
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            Option option = $this.checkpoints().get((Object)sourceLogDir$1).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.read().get((Object)topicPartition$4));
            if (option instanceof Some) {
                long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("from ").append(sourceLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                Option x$22 = Option$.MODULE$.apply((Object)topicPartition$4);
                Option<Tuple2<TopicPartition, Object>> x$3 = $this.updateCheckpoints$default$2();
                $this.updateCheckpoints(sourceLogDir$1, x$3, (Option<TopicPartition>)x$22);
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("to ").append(destLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)BoxesRunTime.boxToLong((long)offset))), $this.updateCheckpoints$default$3());
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir$1.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$4, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((File)x0$1._1()).getAbsolutePath();
        boolean bl = string == null ? dir$4 != null : !string.equals(dir$4);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, long offset$1) {
        Map<TopicPartition, Object> existing;
        OffsetCheckpointFile checkpoint;
        if ($this.logs().get(topicPartition$5).config().compact() && (checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2)) != null && BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition$5, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > offset$1) {
            checkpoint.write((Map<TopicPartition, Object>)((Map)((MapLike)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(existing)).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$5), (Object)BoxesRunTime.boxToLong((long)offset$1)))));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)BoxesRunTime.boxToLong((long)endOffset$1))), $this.updateCheckpoints$default$3());
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition$6).append(" cannot be in ").append(option).append(" state.").toString());
        throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition$6).append(" should exist.").toString());
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Boolean bl;
        Option option = $this.uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            bl = BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        } else if (None$.MODULE$.equals(option)) {
            bl = $this.uncleanablePartitions().put((Object)logDir$2, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, AbstractLog log$1, TopicPartition topicPartition$7) {
        return $this.uncleanablePartitions().get((Object)log$1.parentDir()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7)));
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$2(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$7(this.dir$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("compacted-partition-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$3;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$11(this.dir$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$3 = dir$3;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        this.dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$14();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$15();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.achievedCleaningRatio = this.newHistogram("AchievedCleaningRatio", this.newHistogram$default$2(), this.newHistogram$default$3());
    }
}

