/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.FetchedTimestampAndOffset$;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.LazyIndex;
import kafka.log.LogConfig;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.log.SegmentStats$;
import kafka.log.TimeIndex;
import kafka.log.TimestampOffset;
import kafka.log.TimestampOffset$;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011Eb\u0001B.]\u0001\u0005D\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u001c\u0005\ty\u0002\u0011\t\u0011)A\u0005_\"AQ\u0010\u0001BC\u0002\u0013\u0005a\u0010C\u0005\u0002\u000e\u0001\u0011\t\u0011)A\u0005\u007f\"Q\u0011q\u0002\u0001\u0003\u0006\u0004%\t!!\u0005\t\u0015\u0005m\u0001A!A!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002\u001e\u0001\u0011)\u0019!C\u0001\u0003?A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011)\tI\u0003\u0001BC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003g\u0001!\u0011!Q\u0001\n\u00055\u0002BCA\u001b\u0001\t\u0015\r\u0011\"\u0001\u00028!Q\u0011q\b\u0001\u0003\u0002\u0003\u0006I!!\u000f\t\u0015\u0005\u0005\u0003A!b\u0001\n\u0003\tY\u0003\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003[A!\"!\u0012\u0001\u0005\u000b\u0007I\u0011AA$\u0011)\t\u0019\u0006\u0001B\u0001B\u0003%\u0011\u0011\n\u0005\t\u0003+\u0002A\u0011\u0001/\u0002X!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!&\u0001\t\u0003\t9\nC\u0005\u0002\"\u0002\u0001\r\u0011\"\u0003\u0002,!I\u00111\u0015\u0001A\u0002\u0013%\u0011Q\u0015\u0005\t\u0003W\u0003\u0001\u0015)\u0003\u0002.!I\u0011Q\u0016\u0001A\u0002\u0013%\u0011q\u0007\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003cC\u0001\"!.\u0001A\u0003&\u0011\u0011\b\u0005\n\u0003o\u0003\u0001\u0019!C\u0005\u0003sC\u0011\"!1\u0001\u0001\u0004%I!a1\t\u0011\u0005\u001d\u0007\u0001)Q\u0005\u0003wC\u0011\"!5\u0001\u0001\u0004%I!a5\t\u0013\u0005m\u0007\u00011A\u0005\n\u0005u\u0007\u0002CAq\u0001\u0001\u0006K!!6\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"9\u0011Q\u001e\u0001\u0005\u0002\u0005M\u0007bBAx\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003c\u0004A\u0011AA\u0016\u0011\u001d\t\u0019\n\u0001C\u0001\u0003oAq!a=\u0001\t\u0003\t)\u0010C\u0004\u0002|\u0002!\t!!@\t\u000f\tu\u0001\u0001\"\u0003\u0003 !9!1\u0005\u0001\u0005\n\t\u0015\u0002b\u0002B\u001c\u0001\u0011\u0005!\u0011\b\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/B\u0001B!\u001c\u0001\t\u0003a&q\u000e\u0005\u000b\u0005O\u0003\u0011\u0013!C\u00019\n%\u0006b\u0002B`\u0001\u0011\u0005!\u0011\u0019\u0005\n\u0005C\u0004\u0011\u0013!C\u0001\u0005GD\u0011Ba:\u0001#\u0003%\tA!;\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!q \u0001\u0005\u0002\r\u0005\u0001\"CB\r\u0001E\u0005I\u0011AB\u000e\u0011\u001d\u0019y\u0002\u0001C\u0005\u0007CAqaa\t\u0001\t\u0003\u0019)\u0003C\u0004\u0004(\u0001!\ta!\u000b\t\u000f\re\u0002\u0001\"\u0011\u0004<!91Q\n\u0001\u0005\u0002\r=\u0003bBB+\u0001\u0011%1q\u000b\u0005\t\u00073\u0002\u0001\u0015!\u0003\u0004\\!911\u000f\u0001\u0005\u0002\u0005-\u0002bBB<\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007w\u0002A\u0011AB?\u0011\u001d\u0019y\t\u0001C\u0001\u0007#Cqaa'\u0001\t\u0003\u0019\t\u0003C\u0004\u0004\u001e\u0002!Ia!\t\t\u000f\r}\u0005\u0001\"\u0001\u0004\"\"911\u0016\u0001\u0005\u0002\r]\u0003bBBW\u0001\u0011\u00051q\u0016\u0005\n\u0007\u000b\u0004\u0011\u0013!C\u0001\u0005GDqaa2\u0001\t\u0003\u0019\t\u0003C\u0004\u0004J\u0002!\ta!\t\t\u000f\r-\u0007\u0001\"\u0001\u0004\"!91Q\u001a\u0001\u0005\u0002\u0005-\u0002bBBh\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0005\u000b\u0001A\u0011AA\u0016\u0011\u001d\u0019\t\u000e\u0001C\u0001\u0007'<qaa;]\u0011\u0003\u0019iO\u0002\u0004\\9\"\u00051q\u001e\u0005\b\u0003+\u0002F\u0011ABy\u0011%\u0019\u0019\u0010\u0015b\u0001\n\u0013\tY\u0003\u0003\u0005\u0004vB\u0003\u000b\u0011BA\u0017\u0011\u001d\u00199\u0010\u0015C\u0001\u0007sD\u0011\u0002b\u0007Q#\u0003%\tA!;\t\u0013\u0011u\u0001+%A\u0005\u0002\t%\u0006\"\u0003C\u0010!F\u0005I\u0011\u0001Bu\u0011%!\t\u0003UI\u0001\n\u0003!\u0019\u0003C\u0004\u0004LB#\t\u0001b\n\t\u0013\u0011=\u0002+%A\u0005\u0002\u0011\r\"A\u0003'pON+w-\\3oi*\u0011QLX\u0001\u0004Y><'\"A0\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\u00195\u0011\u0005\r4W\"\u00013\u000b\u0003\u0015\fQa]2bY\u0006L!a\u001a3\u0003\r\u0005s\u0017PU3g!\tIG.D\u0001k\u0015\tYg,A\u0003vi&d7/\u0003\u0002nU\n9Aj\\4hS:<W#A8\u0011\u0005ATX\"A9\u000b\u0005I\u001c\u0018A\u0002:fG>\u0014HM\u0003\u0002uk\u000611m\\7n_:T!a\u0018<\u000b\u0005]D\u0018AB1qC\u000eDWMC\u0001z\u0003\ry'oZ\u0005\u0003wF\u00141BR5mKJ+7m\u001c:eg\u0006!An\\4!\u0003=a\u0017M_=PM\u001a\u001cX\r^%oI\u0016DX#A@\u0011\r\u0005\u0005\u00111AA\u0004\u001b\u0005a\u0016bAA\u00039\nIA*\u0019>z\u0013:$W\r\u001f\t\u0005\u0003\u0003\tI!C\u0002\u0002\fq\u00131b\u00144gg\u0016$\u0018J\u001c3fq\u0006\u0001B.\u0019>z\u001f\u001a47/\u001a;J]\u0012,\u0007\u0010I\u0001\u000eY\u0006T\u0018\u0010V5nK&sG-\u001a=\u0016\u0005\u0005M\u0001CBA\u0001\u0003\u0007\t)\u0002\u0005\u0003\u0002\u0002\u0005]\u0011bAA\r9\nIA+[7f\u0013:$W\r_\u0001\u000fY\u0006T\u0018\u0010V5nK&sG-\u001a=!\u0003!!\bP\\%oI\u0016DXCAA\u0011!\u0011\t\t!a\t\n\u0007\u0005\u0015BL\u0001\tUe\u0006t7/Y2uS>t\u0017J\u001c3fq\u0006IA\u000f\u001f8J]\u0012,\u0007\u0010I\u0001\u000bE\u0006\u001cXm\u00144gg\u0016$XCAA\u0017!\r\u0019\u0017qF\u0005\u0004\u0003c!'\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005\u0011\u0012N\u001c3fq&sG/\u001a:wC2\u0014\u0015\u0010^3t+\t\tI\u0004E\u0002d\u0003wI1!!\u0010e\u0005\rIe\u000e^\u0001\u0014S:$W\r_%oi\u0016\u0014h/\u00197CsR,7\u000fI\u0001\re>dGNS5ui\u0016\u0014Xj]\u0001\u000ee>dGNS5ui\u0016\u0014Xj\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002P5\u0011\u0011Q\n\u0006\u0003WNLA!!\u0015\u0002N\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012\u0011LA.\u0003;\ny&!\u0019\u0002d\u0005\u0015\u0014qMA5!\r\t\t\u0001\u0001\u0005\u0006;F\u0001\ra\u001c\u0005\u0006{F\u0001\ra \u0005\b\u0003\u001f\t\u0002\u0019AA\n\u0011\u001d\ti\"\u0005a\u0001\u0003CAq!!\u000b\u0012\u0001\u0004\ti\u0003C\u0004\u00026E\u0001\r!!\u000f\t\u000f\u0005\u0005\u0013\u00031\u0001\u0002.!9\u0011QI\tA\u0002\u0005%\u0013aC8gMN,G/\u00138eKb,\"!a\u0002\u0002\u0013QLW.Z%oI\u0016DXCAA\u000b\u0003)\u0019\bn\\;mIJ{G\u000e\u001c\u000b\u0005\u0003o\ni\bE\u0002d\u0003sJ1!a\u001fe\u0005\u001d\u0011un\u001c7fC:Dq!a \u0015\u0001\u0004\t\t)\u0001\u0006s_2d\u0007+\u0019:b[N\u0004B!!\u0001\u0002\u0004&\u0019\u0011Q\u0011/\u0003\u0015I{G\u000e\u001c)be\u0006l7/A\u0007sKNL'0Z%oI\u0016DXm\u001d\u000b\u0005\u0003\u0017\u000b\t\nE\u0002d\u0003\u001bK1!a$e\u0005\u0011)f.\u001b;\t\u000f\u0005MU\u00031\u0001\u0002:\u0005!1/\u001b>f\u0003-\u0019\u0018M\\5us\u000eCWmY6\u0015\r\u0005-\u0015\u0011TAO\u0011\u001d\tYJ\u0006a\u0001\u0003o\n\u0011\u0004^5nK&sG-\u001a=GS2,g*Z<ms\u000e\u0013X-\u0019;fI\"9\u0011q\u0014\fA\u0002\u0005]\u0014aD5t\u0003\u000e$\u0018N^3TK\u001elWM\u001c;\u0002\u000f\r\u0014X-\u0019;fI\u0006Y1M]3bi\u0016$w\fJ3r)\u0011\tY)a*\t\u0013\u0005%\u0006$!AA\u0002\u00055\u0012a\u0001=%c\u0005A1M]3bi\u0016$\u0007%\u0001\rcsR,7oU5oG\u0016d\u0015m\u001d;J]\u0012,\u00070\u00128uef\fADY=uKN\u001c\u0016N\\2f\u0019\u0006\u001cH/\u00138eKb,e\u000e\u001e:z?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0006M\u0006\"CAU7\u0005\u0005\t\u0019AA\u001d\u0003e\u0011\u0017\u0010^3t'&t7-\u001a'bgRLe\u000eZ3y\u000b:$(/\u001f\u0011\u0002+I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1naV\u0011\u00111\u0018\t\u0006G\u0006u\u0016QF\u0005\u0004\u0003\u007f#'AB(qi&|g.A\rs_2d\u0017N\\4CCN,G\rV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BAF\u0003\u000bD\u0011\"!+\u001f\u0003\u0003\u0005\r!a/\u0002-I|G\u000e\\5oO\n\u000b7/\u001a3US6,7\u000f^1na\u0002B3aHAf!\r\u0019\u0017QZ\u0005\u0004\u0003\u001f$'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u00027}k\u0017\r\u001f+j[\u0016\u001cH/Y7q\u0003:$wJ\u001a4tKR\u001cvNR1s+\t\t)\u000e\u0005\u0003\u0002\u0002\u0005]\u0017bAAm9\nyA+[7fgR\fW\u000e](gMN,G/A\u0010`[\u0006DH+[7fgR\fW\u000e]!oI>3gm]3u'>4\u0015M]0%KF$B!a#\u0002`\"I\u0011\u0011V\u0011\u0002\u0002\u0003\u0007\u0011Q[\u0001\u001d?6\f\u0007\u0010V5nKN$\u0018-\u001c9B]\u0012|eMZ:fiN{g)\u0019:!Q\r\u0011\u00131Z\u0001\u001f[\u0006DH+[7fgR\fW\u000e]!oI>3gm]3u'>4\u0015M]0%KF$B!a#\u0002j\"9\u00111^\u0012A\u0002\u0005U\u0017a\u0004;j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;\u000255\f\u0007\u0010V5nKN$\u0018-\u001c9B]\u0012|eMZ:fiN{g)\u0019:\u0002#5\f\u0007\u0010V5nKN$\u0018-\u001c9T_\u001a\u000b'/A\rpM\u001a\u001cX\r^(g\u001b\u0006DH+[7fgR\fW\u000e]*p\r\u0006\u0014\u0018AG2b]\u000e{gN^3siR{'+\u001a7bi&4Xm\u00144gg\u0016$H\u0003BA<\u0003oDq!!?)\u0001\u0004\ti#\u0001\u0004pM\u001a\u001cX\r^\u0001\u0007CB\u0004XM\u001c3\u0015\u0015\u0005-\u0015q B\u0002\u0005\u000f\u0011Y\u0001C\u0004\u0003\u0002%\u0002\r!!\f\u0002\u001b1\f'oZ3ti>3gm]3u\u0011\u001d\u0011)!\u000ba\u0001\u0003[\t\u0001\u0003\\1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\t\u000f\t%\u0011\u00061\u0001\u0002.\u0005Y2\u000f[1mY><xJ\u001a4tKR|e-T1y)&lWm\u001d;b[BDqA!\u0004*\u0001\u0004\u0011y!A\u0004sK\u000e|'\u000fZ:\u0011\u0007A\u0014\t\"C\u0002\u0003\u0014E\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\bfA\u0015\u0003\u0018A\u0019\u0011N!\u0007\n\u0007\tm!NA\u0007o_:$\bN]3bIN\fg-Z\u0001\u0014K:\u001cXO]3PM\u001a\u001cX\r^%o%\u0006tw-\u001a\u000b\u0005\u0003\u0017\u0013\t\u0003C\u0004\u0002z*\u0002\r!!\f\u0002'\u0005\u0004\b/\u001a8e\u0007\",hn\u001b$s_64\u0015\u000e\\3\u0015\u0011\u0005e\"q\u0005B\u0015\u0005[AaA!\u0004,\u0001\u0004y\u0007b\u0002B\u0016W\u0001\u0007\u0011\u0011H\u0001\ta>\u001c\u0018\u000e^5p]\"9!qF\u0016A\u0002\tE\u0012A\u00042vM\u001a,'oU;qa2LWM\u001d\t\u0005\u0003\u0017\u0012\u0019$\u0003\u0003\u00036\u00055#A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u000fCB\u0004XM\u001c3Ge>lg)\u001b7f)\u0019\tIDa\u000f\u0003>!1!Q\u0002\u0017A\u0002=DqAa\u0010-\u0001\u0004\tI$A\u0003ti\u0006\u0014H/\u0001\bva\u0012\fG/\u001a+y]&sG-\u001a=\u0015\r\u0005-%Q\tB(\u0011\u001d\u00119%\fa\u0001\u0005\u0013\nAbY8na2,G/\u001a3Uq:\u0004B!!\u0001\u0003L%\u0019!Q\n/\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\tES\u00061\u0001\u0002.\u0005\u0001B.Y:u'R\f'\r\\3PM\u001a\u001cX\r\u001e\u0015\u0004[\t]\u0011aE;qI\u0006$X\r\u0015:pIV\u001cWM]*uCR,GCBAF\u00053\u0012\u0019\u0007C\u0004\u0003\\9\u0002\rA!\u0018\u0002)A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s!\u0011\t\tAa\u0018\n\u0007\t\u0005DL\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\u0005\b\u0005Kr\u0003\u0019\u0001B4\u0003\u0015\u0011\u0017\r^2i!\r\u0001(\u0011N\u0005\u0004\u0005W\n(a\u0003*fG>\u0014HMQ1uG\"\fq\u0002\u001e:b]Nd\u0017\r^3PM\u001a\u001cX\r\u001e\u000b\u0007\u0005c\u0012IJa'\u0011\t\tM$1\u0013\b\u0005\u0005k\u0012yI\u0004\u0003\u0003x\t5e\u0002\u0002B=\u0005\u0017sAAa\u001f\u0003\n:!!Q\u0010BD\u001d\u0011\u0011yH!\"\u000e\u0005\t\u0005%b\u0001BBA\u00061AH]8pizJ\u0011!_\u0005\u0003obL!a\u0018<\n\u0005Q,\u0018B\u0001:t\u0013\r\u0011\t*]\u0001\f\r&dWMU3d_J$7/\u0003\u0003\u0003\u0016\n]%!\u0005'pO>3gm]3u!>\u001c\u0018\u000e^5p]*\u0019!\u0011S9\t\u000f\u0005ex\u00061\u0001\u0002.!I!QT\u0018\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u0015gR\f'\u000f^5oO\u001aKG.\u001a)pg&$\u0018n\u001c8)\u0007=\u0012\t\u000bE\u0002j\u0005GK1A!*k\u0005)!\bN]3bIN\fg-Z\u0001\u001aiJ\fgn\u001d7bi\u0016|eMZ:fi\u0012\"WMZ1vYR$#'\u0006\u0002\u0003,*\"\u0011\u0011\bBWW\t\u0011y\u000b\u0005\u0003\u00032\nmVB\u0001BZ\u0015\u0011\u0011)La.\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B]I\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu&1\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0002:fC\u0012$\"Ba1\u0003P\nM'q\u001bBn!\u0011\u0011)Ma3\u000e\u0005\t\u001d'b\u0001Be=\u000611/\u001a:wKJLAA!4\u0003H\nia)\u001a;dQ\u0012\u000bG/Y%oM>DqA!52\u0001\u0004\ti#A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bb\u0002Bkc\u0001\u0007\u0011\u0011H\u0001\b[\u0006D8+\u001b>f\u0011%\u0011I.\rI\u0001\u0002\u0004\ti#A\u0006nCb\u0004vn]5uS>t\u0007\"\u0003BocA\u0005\t\u0019AA<\u00035i\u0017N\\(oK6+7o]1hK\"\u001a\u0011G!)\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u001d\u0016\u0005\u0003[\u0011i+\u0001\bsK\u0006$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t-(\u0006BA<\u0005[\u000bQCZ3uG\",\u0006\u000f]3s\u0005>,h\u000eZ(gMN,G\u000f\u0006\u0004\u0002<\nE(1 \u0005\b\u0005g$\u0004\u0019\u0001B{\u0003M\u0019H/\u0019:u\u001f\u001a47/\u001a;Q_NLG/[8o!\u0011\t\tAa>\n\u0007\teHL\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000f\tuH\u00071\u0001\u0002:\u0005Ia-\u001a;dQNK'0Z\u0001\be\u0016\u001cwN^3s)\u0019\tIda\u0001\u0004\u0006!9!1L\u001bA\u0002\tu\u0003\"CB\u0004kA\u0005\t\u0019AB\u0005\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003d\u0003{\u001bY\u0001\u0005\u0003\u0004\u000e\rMQBAB\b\u0015\u0011\u0019\tBa2\u0002\u000b\u0015\u0004xn\u00195\n\t\rU1q\u0002\u0002\u0015\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3)\u0007U\u00129\"A\tsK\u000e|g/\u001a:%I\u00164\u0017-\u001e7uII*\"a!\b+\t\r%!QV\u0001\u0015Y>\fG\rT1sO\u0016\u001cH\u000fV5nKN$\u0018-\u001c9\u0015\u0005\u0005-\u0015a\u00035bg>3XM\u001d4m_^,\"!a\u001e\u0002%\r|G\u000e\\3di\u0006\u0013wN\u001d;fIRChn\u001d\u000b\u0007\u0007W\u0019\td!\u000e\u0011\t\u0005\u00051QF\u0005\u0004\u0007_a&\u0001\u0006+y]&sG-\u001a=TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u00044e\u0002\r!!\f\u0002\u0017\u0019,Go\u00195PM\u001a\u001cX\r\u001e\u0005\b\u0007oI\u0004\u0019AA\u0017\u0003A)\b\u000f]3s\u0005>,h\u000eZ(gMN,G/\u0001\u0005u_N#(/\u001b8h)\t\u0019i\u0004\u0005\u0003\u0004@\r\u001dc\u0002BB!\u0007\u0007\u00022Aa e\u0013\r\u0019)\u0005Z\u0001\u0007!J,G-\u001a4\n\t\r%31\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\r\u0015C-\u0001\u0006ueVt7-\u0019;f)>$B!!\u000f\u0004R!9\u0011\u0011`\u001eA\u0002\u00055\u0002fA\u001e\u0003\u0018\u0005q1oY1o\u001d\u0016DHo\u00144gg\u0016$HCAA\u0017\u0003Ea\u0017m\u001d;TK\u001elWM\u001c;PM\u001a\u001cX\r\u001e\t\u0005\u0007;\u001ay'\u0004\u0002\u0004`)!1\u0011MB2\u0003\u0019\tGo\\7jG*!1QMB4\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0007S\u001aY'\u0001\u0003vi&d'BAB7\u0003\u0011Q\u0017M^1\n\t\rE4q\f\u0002\u000b\u0003R|W.[2M_:<\u0017A\u0004:fC\u0012tU\r\u001f;PM\u001a\u001cX\r\u001e\u0015\u0004}\t\u0005\u0016!\u00024mkND\u0007fA \u0003\"\u0006yQ\u000f\u001d3bi\u0016\u0004\u0016M]3oi\u0012K'\u000f\u0006\u0003\u0002\f\u000e}\u0004bBBA\u0001\u0002\u000711Q\u0001\u0004I&\u0014\b\u0003BBC\u0007\u0017k!aa\"\u000b\t\r%51N\u0001\u0003S>LAa!$\u0004\b\n!a)\u001b7f\u0003I\u0019\u0007.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:\u0015\r\u0005-51SBL\u0011\u001d\u0019)*\u0011a\u0001\u0007{\t\u0011b\u001c7e'V4g-\u001b=\t\u000f\re\u0015\t1\u0001\u0004>\u0005Ia.Z<Tk\u001a4\u0017\u000e_\u0001\u0018_:\u0014UmY8nK&s\u0017m\u0019;jm\u0016\u001cVmZ7f]R\fq\u0003\\8bI\u001aK'o\u001d;CCR\u001c\u0007\u000eV5nKN$\u0018-\u001c9\u0002#QLW.Z,bSR,GMR8s%>dG\u000e\u0006\u0004\u0002.\r\r6q\u0015\u0005\b\u0007K#\u0005\u0019AA\u0017\u0003\rqwn\u001e\u0005\b\u0007S#\u0005\u0019AA\u0017\u0003AiWm]:bO\u0016$\u0016.\\3ti\u0006l\u0007/\u0001\fhKR4\u0015N]:u\u0005\u0006$8\r\u001b+j[\u0016\u001cH/Y7q\u0003U1\u0017N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[B$ba!-\u0004>\u000e\u0005\u0007#B2\u0002>\u000eM\u0006\u0003BB[\u0007sk!aa.\u000b\u0005Qt\u0016\u0002BB^\u0007o\u0013\u0011DR3uG\",G\rV5nKN$\u0018-\u001c9B]\u0012|eMZ:fi\"91q\u0018$A\u0002\u00055\u0012!\u0003;j[\u0016\u001cH/Y7q\u0011%\u0019\u0019M\u0012I\u0001\u0002\u0004\ti#\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\u0002?\u0019Lg\u000eZ(gMN,GOQ=US6,7\u000f^1na\u0012\"WMZ1vYR$#'A\u0003dY>\u001cX-A\u0007dY>\u001cX\rS1oI2,'o]\u0001\u000fI\u0016dW\r^3JM\u0016C\u0018n\u001d;t\u00031a\u0017m\u001d;N_\u0012Lg-[3e\u0003Ya\u0017M]4fgR\u0014VmY8sIRKW.Z:uC6\u0004\u0018\u0001\u00057bgRlu\u000eZ5gS\u0016$w\fJ3r)\u0011\u0019)n!:\u0011\t\r]7\u0011]\u0007\u0003\u00073TAaa7\u0004^\u0006!a-\u001b7f\u0015\u0011\u0019yna\u001b\u0002\u00079Lw.\u0003\u0003\u0004d\u000ee'\u0001\u0002)bi\"Dqaa:O\u0001\u0004\ti#\u0001\u0002ng\"\u001a\u0001Aa\u0006\u0002\u00151{wmU3h[\u0016tG\u000fE\u0002\u0002\u0002A\u001b\"\u0001\u00152\u0015\u0005\r5\u0018!E+oW:|wO\u001c'bgR|eMZ:fi\u0006\u0011RK\\6o_^tG*Y:u\u001f\u001a47/\u001a;!\u0003\u0011y\u0007/\u001a8\u0015%\u0005e31`B\u007f\u0007\u007f$I\u0001b\u0003\u0005\u0010\u0011MAq\u0003\u0005\b\u0007\u0003#\u0006\u0019ABB\u0011\u001d\tI\u0003\u0016a\u0001\u0003[Aq\u0001\"\u0001U\u0001\u0004!\u0019!\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u0003!)!C\u0002\u0005\bq\u0013\u0011\u0002T8h\u0007>tg-[4\t\u000f\u0005\u0015C\u000b1\u0001\u0002J!IAQ\u0002+\u0011\u0002\u0003\u0007\u0011qO\u0001\u0012M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\b\"\u0003C\t)B\u0005\t\u0019AA\u001d\u00031Ig.\u001b;GS2,7+\u001b>f\u0011%!)\u0002\u0016I\u0001\u0002\u0004\t9(A\u0006qe\u0016\fG\u000e\\8dCR,\u0007\"\u0003C\r)B\u0005\t\u0019AB\u001f\u0003)1\u0017\u000e\\3Tk\u001a4\u0017\u000e_\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00136\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uIY\nab\u001c9f]\u0012\"WMZ1vYR$s'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0011\u0015\"\u0006BB\u001f\u0005[#\u0002\"a#\u0005*\u0011-BQ\u0006\u0005\b\u0007\u0003K\u0006\u0019ABB\u0011\u001d\tI#\u0017a\u0001\u0003[A\u0011\u0002\"\u0007Z!\u0003\u0005\ra!\u0010\u00021\u0011,G.\u001a;f\u0013\u001a,\u00050[:ug\u0012\"WMZ1vYR$3\u0007")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile TimestampOffset _maxTimestampAndOffsetSoFar;
    private final AtomicLong lastSegmentOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now(), rollParams.maxTimestampInMessages()) > rollParams.maxSegmentMs() - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes() - rollParams.messagesSize() || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages());
    }

    public void resizeIndexes(int size) {
        this.offsetIndex().resize(size);
        this.timeIndex().resize(size);
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated, boolean isActiveSegment) {
        if (isActiveSegment && this.size() == 0 || this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated) {
                this.timeIndex().resize(0);
            }
            this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append(this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    private TimestampOffset _maxTimestampAndOffsetSoFar() {
        return this._maxTimestampAndOffsetSoFar;
    }

    private void _maxTimestampAndOffsetSoFar_$eq(TimestampOffset x$1) {
        this._maxTimestampAndOffsetSoFar = x$1;
    }

    public void maxTimestampAndOffsetSoFar_$eq(TimestampOffset timestampOffset) {
        this._maxTimestampAndOffsetSoFar_$eq(timestampOffset);
    }

    public TimestampOffset maxTimestampAndOffsetSoFar() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (!(timestampOffset != null ? !((Object)timestampOffset).equals(timestampOffset2) : timestampOffset2 != null)) {
            this._maxTimestampAndOffsetSoFar_$eq(this.timeIndex().lastEntry());
        }
        return this._maxTimestampAndOffsetSoFar();
    }

    public long maxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().timestamp();
    }

    public long offsetOfMaxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().offset();
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long largestOffset, long largestTimestamp, long shallowOffsetOfMaxTimestamp, MemoryRecords records) {
        if (records.sizeInBytes() > 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Inserting ").append(records.sizeInBytes()).append(" bytes at end offset ").append(largestOffset).append(" at position ").append(this.log().sizeInBytes()).append(" ").append("with largest timestamp ").append(largestTimestamp).append(" at shallow offset ").append(shallowOffsetOfMaxTimestamp).toString());
            int physicalPosition = this.log().sizeInBytes();
            if (physicalPosition == 0) {
                this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)largestTimestamp)));
            }
            this.ensureOffsetInRange(largestOffset);
            int appendedBytes = BoxesRunTime.unboxToInt(SegmentStats$.MODULE$.segmentAppendTimeMs().time((JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.log().append(records)));
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append(this.log().file()).append(" at end offset ").append(largestOffset).toString());
            this.lastSegmentOffset.set(largestOffset);
            if (largestTimestamp > this.maxTimestampSoFar()) {
                this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(largestTimestamp, shallowOffsetOfMaxTimestamp));
            }
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                SegmentStats$.MODULE$.offsetIndexAppendTimeMs().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().append(largestOffset, physicalPosition));
                SegmentStats$.MODULE$.timestampIndexAppendTimeMs().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    TimeIndex qual$1 = this.timeIndex();
                    long x$1 = this.maxTimestampSoFar();
                    long x$2 = this.offsetOfMaxTimestampSoFar();
                    boolean x$3 = qual$1.maybeAppend$default$3();
                    qual$1.maybeAppend(x$1, x$2, x$3);
                });
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + records.sizeInBytes());
        }
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, maxTimestamp.elem, offsetOfMaxTimestamp.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start; position < start + records.sizeInBytes(); position += bytesAppended) {
            bytesAppended = this.appendChunkFromFile(records, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            return position - start;
        }
        return position - start;
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        if (completedTxn.isAborted()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn).append(" to transaction index, last stable offset is ").append(lastStableOffset).toString());
            this.txnIndex().append(new AbortedTxn(completedTxn, lastStableOffset));
        }
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin$Replication$.MODULE$);
            Option<CompletedTxn> maybeCompletedTxn = appendInfo.append(batch, (Option<LogOffsetMetadata>)None$.MODULE$);
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
                LogSegment.$anonfun$updateProducerState$1(this, producerStateManager, completedTxn);
                return BoxedUnit.UNIT;
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        int adjustedMaxSize;
        if (maxSize < 0) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
        }
        FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
        if (startOffsetAndSize == null) {
            return null;
        }
        int startPosition = startOffsetAndSize.position;
        LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
        int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
        if (adjustedMaxSize == 0) {
            return new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4());
        }
        int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
        return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, FetchDataInfo$.MODULE$.apply$default$4());
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Option<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.offset()));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        this.offsetIndex().reset();
        this.timeIndex().reset();
        this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        IntRef lastIndexEntry = IntRef.create((int)0);
        this.maxTimestampAndOffsetSoFar_$eq(TimestampOffset$.MODULE$.Unknown());
        try {
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$1(this, validBytes, lastIndexEntry, leaderEpochCache, producerStateManager, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append(this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        this.log().truncateTo(validBytes.elem);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.timeIndex().trimToValidSize();
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
        return truncated;
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampAndOffsetSoFar_$eq(lastTimeIndexEntry);
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset());
        FileRecords.FileTimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position());
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp()) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(maxTimestampOffsetAfterLastEntry.timestamp, maxTimestampOffsetAfterLastEntry.offset));
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset);
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        this.offsetIndex().truncateTo(offset);
        this.timeIndex().truncateTo(offset);
        this.txnIndex().truncateTo(offset);
        this.offsetIndex().resize(this.offsetIndex().maxIndexSize());
        this.timeIndex().resize(this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : this.log().truncateTo(mapping.position);
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time().milliseconds());
            this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        if (this.maxTimestampSoFar() >= 0L) {
            this.loadLargestTimestamp();
        }
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
        return bytesTruncated;
    }

    private long scanNextOffset() {
        FetchDataInfo fetchData = this.read(this.offsetIndex().lastOffset(), this.log().sizeInBytes(), this.read$default$3(), this.read$default$4());
        if (fetchData == null) {
            return this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.baseOffset()));
    }

    /*
     * WARNING - void declaration
     */
    public long readNextOffset() {
        void var3_2;
        long scannedNextOffset;
        this.lastSegmentOffset.get();
        do {
            long cachedLastSegmentOffset;
            if ((cachedLastSegmentOffset = this.lastSegmentOffset.get()) != LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset()) {
                return cachedLastSegmentOffset + 1L;
            }
            scannedNextOffset = this.scanNextOffset();
        } while (!this.lastSegmentOffset.compareAndSet(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset(), scannedNextOffset - 1L));
        return (long)var3_2;
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().flush();
            this.offsetIndex().flush();
            this.timeIndex().flush();
            this.txnIndex().flush();
        });
    }

    public void updateParentDir(File dir) {
        this.log().updateParentDir(dir);
        this.lazyOffsetIndex().updateParentDir(dir);
        this.lazyTimeIndex().updateParentDir(dir);
        this.txnIndex().updateParentDir(dir);
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        this.log().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        this.lazyOffsetIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyOffsetIndex().file().getPath(), oldSuffix, newSuffix)));
        this.lazyTimeIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.lazyTimeIndex().file().getPath(), oldSuffix, newSuffix)));
        this.txnIndex().renameTo(new File(CoreUtils$.MODULE$.replaceSuffix(this.txnIndex().file().getPath(), oldSuffix, newSuffix)));
    }

    public void onBecomeInactiveSegment() {
        this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true);
        this.offsetIndex().trimToValidSize();
        this.timeIndex().trimToValidSize();
        this.log().trim();
    }

    private void loadFirstBatchTimestamp() {
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? messageTimestamp - t : now - this.created();
        return l;
    }

    public long getFirstBatchTimestamp() {
        long t;
        this.loadFirstBatchTimestamp();
        Option<Object> option = this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public Option<FetchedTimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
        int position = this.offsetIndex().lookup(package$.MODULE$.max(timestampOffset.offset(), startingOffset)).position();
        return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1 & Serializable & scala.Serializable)found -> {
            if (found.exception == null) {
                return FetchedTimestampAndOffset$.MODULE$.apply(found.timestamp, found.offset, (Option<Object>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(found.leaderEpoch)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4))));
            }
            return FetchedTimestampAndOffset$.MODULE$.apply(found.exception);
        });
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset$.MODULE$.Unknown();
        if (timestampOffset == null ? timestampOffset2 != null : !((Object)timestampOffset).equals(timestampOffset2)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().maybeAppend(this.maxTimestampSoFar(), this.offsetOfMaxTimestampSoFar(), true), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyOffsetIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyTimeIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public void closeHandlers() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyOffsetIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.lazyTimeIndex().closeHandler(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.log().closeHandlers(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().close(), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public void deleteIfExists() {
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.log().file();
            String delete$1_fileType = "log";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$4(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyOffsetIndex().file();
            String delete$1_fileType = "offset index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$6(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = true;
            File delete$1_file = this.lazyTimeIndex().file();
            String delete$1_fileType = "time index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$8(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            File delete$1_file = this.txnIndex().file();
            String delete$1_fileType = "transaction index";
            try {
                void delete$1_logIfMissing;
                if (LogSegment.$anonfun$deleteIfExists$10(this)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                } else if (delete$1_logIfMissing != false) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                }
            }
            catch (IOException delete$1_e) {
                throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
            }
        }, (List)Nil$.MODULE$)))));
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        Files.setLastModifiedTime(this.log().file().toPath(), fileTime);
        Files.setLastModifiedTime(this.lazyOffsetIndex().file().toPath(), fileTime);
        return Files.setLastModifiedTime(this.lazyTimeIndex().file().toPath(), fileTime);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ void $anonfun$updateProducerState$1(LogSegment $this, ProducerStateManager producerStateManager$1, CompletedTxn completedTxn) {
        long lastStableOffset = producerStateManager$1.lastStableOffset(completedTxn);
        $this.updateTxnIndex(completedTxn, lastStableOffset);
        producerStateManager$1.completeTxn(completedTxn);
    }

    public static final /* synthetic */ void $anonfun$recover$2(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && cache.latestEpoch().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$1(LogSegment $this, IntRef validBytes$1, IntRef lastIndexEntry$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.ensureOffsetInRange(batch.lastOffset());
        if (batch.maxTimestamp() > $this.maxTimestampSoFar()) {
            $this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(batch.maxTimestamp(), batch.lastOffset()));
        }
        if (validBytes$1.elem - lastIndexEntry$1.elem > $this.indexIntervalBytes()) {
            $this.offsetIndex().append(batch.lastOffset(), validBytes$1.elem);
            TimeIndex qual$1 = $this.timeIndex();
            long x$1 = $this.maxTimestampSoFar();
            long x$2 = $this.offsetOfMaxTimestampSoFar();
            boolean x$3 = qual$1.maybeAppend$default$3();
            qual$1.maybeAppend(x$1, x$2, x$3);
            lastIndexEntry$1.elem = validBytes$1.elem;
        }
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$2(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch);
        }
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$4(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$6(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$8(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$10(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this._maxTimestampAndOffsetSoFar = TimestampOffset$.MODULE$.Unknown();
        this.lastSegmentOffset = new AtomicLong(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }
}

