/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u001dx!B4i\u0011\u0003ig!B8i\u0011\u0003\u0001\b\"B<\u0002\t\u0003A\bbB=\u0002\u0005\u0004%IA\u001f\u0005\u0007}\u0006\u0001\u000b\u0011B>\t\u0011}\f!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0005\u0002A\u0003%\u00111\u0001\u0005\n\u0003+\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0006\u0002A\u0003%\u00111\u0001\u0005\n\u00033\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0007\u0002A\u0003%\u00111\u0001\u0005\n\u0003;\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\b\u0002A\u0003%\u00111\u0001\u0005\n\u0003C\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\t\u0002A\u0003%\u00111\u0001\u0005\n\u0003K\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\n\u0002A\u0003%\u00111\u0001\u0005\n\u0003S\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\u000b\u0002A\u0003%\u00111\u0001\u0005\n\u0003[\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\f\u0002A\u0003%\u00111\u0001\u0005\n\u0003c\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\r\u0002A\u0003%\u00111\u0001\u0005\n\u0003k\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\u000e\u0002A\u0003%\u00111\u0001\u0005\n\u0003s\t!\u0019!C\u0005\u0003\u0003A\u0001\"a\u000f\u0002A\u0003%\u00111\u0001\u0005\n\u0003{\t!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0002A\u0003%\u0011\u0011\t\u0005\n\u0003\u0013\n!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0013\u0002A\u0003%\u0011\u0011\t\u0005\n\u0003\u001b\n!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0014\u0002A\u0003%\u0011\u0011\t\u0005\n\u0003#\n!\u0019!C\u0001\u0003'B\u0001\"a\u001d\u0002A\u0003%\u0011Q\u000b\u0005\n\u0003k\n!\u0019!C\u0001\u0003'B\u0001\"a\u001e\u0002A\u0003%\u0011Q\u000b\u0005\b\u0003s\nA\u0011AA>\u0011\u001d\tI(\u0001C\u0001\u0003WCq!!0\u0002\t\u0013\ty\fC\u0004\u0002d\u0006!I!!:\t\u000f\u0005=\u0018\u0001\"\u0001\u0002r\"I!1A\u0001\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u00057\t\u0011\u0013!C\u0001\u0005;1Qa\u001c5\u0001\u0005[A!B!\u000f-\u0005\u000b\u0007I\u0011\u0001B\u001e\u0011)\u0011)\u0005\fB\u0001B\u0003%!Q\b\u0005\u000b\u0005\u000fb#\u00111A\u0005\u0002\t%\u0003B\u0003B&Y\t\u0005\r\u0011\"\u0001\u0003N!Q!1\u000b\u0017\u0003\u0002\u0003\u0006K!a(\t\u0015\tuCF!b\u0001\n\u0003\ty\u0004\u0003\u0006\u0003`1\u0012\t\u0011)A\u0005\u0003\u0003B!B!\u0019-\u0005\u000b\u0007I\u0011\u0001B2\u0011)\u0011)\u0007\fB\u0001B\u0003%!\u0011\u0005\u0005\u0007o2\"\tAa\u001a\t\u0013\tMD\u00061A\u0005\n\tU\u0004\"\u0003BFY\u0001\u0007I\u0011\u0002BG\u0011!\u0011\t\n\fQ!\n\t]\u0004\"\u0003BJY\t\u0007I\u0011\u0002BK\u0011!\u00119\n\fQ\u0001\n\u00055\u0007\"\u0003BMY\u0001\u0007I\u0011\u0002BN\u0011%\u0011i\n\fa\u0001\n\u0013\u0011y\n\u0003\u0005\u0003$2\u0002\u000b\u0015BAo\u0011%\u0011)\u000b\fa\u0001\n\u0013\u0011Y\nC\u0005\u0003(2\u0002\r\u0011\"\u0003\u0003*\"A!Q\u0016\u0017!B\u0013\ti\u000eC\u0005\u000302\u0012\r\u0011\"\u0003\u00032\"A!\u0011\u0019\u0017!\u0002\u0013\u0011\u0019\fC\u0005\u0003D2\u0012\r\u0011\"\u0003\u00032\"A!Q\u0019\u0017!\u0002\u0013\u0011\u0019\fC\u0004\u0003H2\"IA!3\t\u0011\t-G\u0006\"\u0001i\u0005\u001bDqA!6-\t\u0003\u00119\u000eC\u0004\u0003l2\"\tA!<\t\u0011\tMH\u0006\"\u0001i\u0005kDqA!?-\t\u0003\u0011Y\nC\u0004\u0003|2\"\tA!@\t\u000f\r%A\u0006\"\u0001\u0004\f!91Q\u0002\u0017\u0005\n\r=\u0001\u0002CB\rY\u0011\u0005\u0001na\u0007\t\u000f\r\u0005B\u0006\"\u0003\u0004$!91Q\u0006\u0017\u0005\u0002\r=\u0002bBB\u001aY\u0011\u00051Q\u0007\u0005\b\u0007\u007faC\u0011AB!\u0011\u001d\u0019y\u0005\fC\u0001\u0007#Bqaa\u001a-\t\u0003\u0019I\u0007C\u0004\u0004p1\"\ta!\u001d\t\u000f\r]D\u0006\"\u0001\u0004z!91q\u0010\u0017\u0005\u0002\r\u0005\u0005bBBBY\u0011\u00051Q\u0011\u0005\b\u0007\u0017cC\u0011\u0001B{\u0011\u001d\u0019i\t\fC\u0001\u0005kDqaa$-\t\u0003\u0019\t\nC\u0004\u0004\u00162\"Iaa&\t\u000f\ruE\u0006\"\u0001\u0004 \"911\u0015\u0017\u0005\u0002\r\u0015\u0006bBBYY\u0011\u000511\u0017\u0005\b\u0007ocC\u0011AB]\u0011\u001d\u0019)\r\fC\u0005\u0007\u000fDqaa3-\t\u0013\u00199\rC\u0004\u0004N2\"\taa4\t\u000f\rMG\u0006\"\u0003\u0004V\"A1\u0011\u001c\u0017\u0005\u0002!\u001cY.\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\u0006\u0003S*\f1\u0001\\8h\u0015\u0005Y\u0017!B6bM.\f7\u0001\u0001\t\u0003]\u0006i\u0011\u0001\u001b\u0002\u0015!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0014\u0005\u0005\t\bC\u0001:v\u001b\u0005\u0019(\"\u0001;\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001c(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002[\u00069\u0002K]8ek\u000e,'o\u00158baNDw\u000e\u001e,feNLwN\\\u000b\u0002wB\u0011!\u000f`\u0005\u0003{N\u0014Qa\u00155peR\f\u0001\u0004\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8!\u000311VM]:j_:4\u0015.\u001a7e+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&!\u0011\u0011CA\u0004\u0005\u0019\u0019FO]5oO\u0006ia+\u001a:tS>tg)[3mI\u0002\n\u0001b\u0011:d\r&,G\u000eZ\u0001\n\u0007J\u001cg)[3mI\u0002\nq\u0002\u0015:pIV\u001cWM]%e\r&,G\u000eZ\u0001\u0011!J|G-^2fe&#g)[3mI\u0002\n\u0011\u0003T1tiN+\u0017/^3oG\u00164\u0015.\u001a7e\u0003Ia\u0015m\u001d;TKF,XM\\2f\r&,G\u000e\u001a\u0011\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000eZ\u0001\u0014!J|G-^2fe\u0016\u0003xn\u00195GS\u0016dG\rI\u0001\u0010\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0006\u0001B*Y:u\u001f\u001a47/\u001a;GS\u0016dG\rI\u0001\u0011\u001f\u001a47/\u001a;EK2$\u0018MR5fY\u0012\f\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u00039!\u0016.\\3ti\u0006l\u0007OR5fY\u0012\fq\u0002V5nKN$\u0018-\u001c9GS\u0016dG\rI\u0001\u0015!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN4\u0015.\u001a7eA\u0005)2i\\8sI&t\u0017\r^8s\u000bB|7\r\u001b$jK2$\u0017AF\"p_J$\u0017N\\1u_J,\u0005o\\2i\r&,G\u000e\u001a\u0011\u00025\r+(O]3oiRChNR5sgR|eMZ:fi\u001aKW\r\u001c3\u00027\r+(O]3oiRChNR5sgR|eMZ:fi\u001aKW\r\u001c3!\u000351VM]:j_:|eMZ:fiV\u0011\u0011\u0011\t\t\u0004e\u0006\r\u0013bAA#g\n\u0019\u0011J\u001c;\u0002\u001dY+'o]5p]>3gm]3uA\u0005I1I]2PM\u001a\u001cX\r^\u0001\u000b\u0007J\u001cwJ\u001a4tKR\u0004\u0013!\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:PM\u001a\u001cX\r^\u0001\u0017!J|G-^2fe\u0016sGO]5fg>3gm]3uA\u0005Y\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006,\"!!\u0016\u0011\t\u0005]\u0013qN\u0007\u0003\u00033RA!a\u0017\u0002^\u0005)A/\u001f9fg*!\u0011qLA1\u0003!\u0001(o\u001c;pG>d'\u0002BA2\u0003K\naaY8n[>t'bA6\u0002h)!\u0011\u0011NA6\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QN\u0001\u0004_J<\u0017\u0002BA9\u00033\u0012aaU2iK6\f\u0017\u0001\b)s_\u0012,8-\u001a:T]\u0006\u00048\u000f[8u\u000b:$(/_*dQ\u0016l\u0017\rI\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\u0002+AKGm\u00158baNDw\u000e^'baN\u001b\u0007.Z7bA\u0005a!/Z1e':\f\u0007o\u001d5piR!\u0011QPAN!\u0019\ty(a$\u0002\u0016:!\u0011\u0011QAF\u001d\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAADY\u00061AH]8pizJ\u0011\u0001^\u0005\u0004\u0003\u001b\u001b\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003#\u000b\u0019J\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tii\u001d\t\u0004]\u0006]\u0015bAAMQ\n\u0011\u0002K]8ek\u000e,'o\u0015;bi\u0016,e\u000e\u001e:z\u0011\u001d\ti*\na\u0001\u0003?\u000bAAZ5mKB!\u0011\u0011UAT\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006-\u0011AA5p\u0013\u0011\tI+a)\u0003\t\u0019KG.\u001a\u000b\u0005\u0003{\ni\u000bC\u0004\u00020\u001a\u0002\r!!-\u0002\r\t,hMZ3s!\u0011\t\u0019,!/\u000e\u0005\u0005U&\u0002BA\\\u0003\u0017\t1A\\5p\u0013\u0011\tY,!.\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0007xe&$Xm\u00158baNDw\u000e\u001e\u000b\u0007\u0003\u0003\f9-!3\u0011\u0007I\f\u0019-C\u0002\u0002FN\u0014A!\u00168ji\"9\u0011QT\u0014A\u0002\u0005}\u0005bBAfO\u0001\u0007\u0011QZ\u0001\bK:$(/[3t!!\ty-!7\u0002^\u0006UUBAAi\u0015\u0011\t\u0019.!6\u0002\u000f5,H/\u00192mK*\u0019\u0011q[:\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\\\u0006E'aA'baB\u0019!/a8\n\u0007\u0005\u00058O\u0001\u0003M_:<\u0017AD5t':\f\u0007o\u001d5pi\u001aKG.\u001a\u000b\u0005\u0003O\fi\u000fE\u0002s\u0003SL1!a;t\u0005\u001d\u0011un\u001c7fC:Dq!!()\u0001\u0004\ty*A\tmSN$8K\\1qg\"|GOR5mKN$B!a=\u0002\u0000B1\u0011qPA{\u0003sLA!a>\u0002\u0014\n\u00191+Z9\u0011\u00079\fY0C\u0002\u0002~\"\u0014Ab\u00158baNDw\u000e\u001e$jY\u0016DqA!\u0001*\u0001\u0004\ty*A\u0002eSJ\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0004U\u0011\t\tE!\u0003,\u0005\t-\u0001\u0003\u0002B\u0007\u0005/i!Aa\u0004\u000b\t\tE!1C\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0006t\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0011yAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TC\u0001B\u0010U\u0011\u0011\tC!\u0003\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQAAa\n\u0002b\u0005)Q\u000f^5mg&!!1\u0006B\u0013\u0005\u0011!\u0016.\\3\u0014\t1\n(q\u0006\t\u0005\u0005c\u0011)$\u0004\u0002\u00034)\u0019!q\u00056\n\t\t]\"1\u0007\u0002\b\u0019><w-\u001b8h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\"A!\u0010\u0011\t\t}\"\u0011I\u0007\u0003\u0003CJAAa\u0011\u0002b\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u000f}cwn\u001a#jeV\u0011\u0011qT\u0001\f?2|w\rR5s?\u0012*\u0017\u000f\u0006\u0003\u0002B\n=\u0003\"\u0003B)a\u0005\u0005\t\u0019AAP\u0003\rAH%M\u0001\t?2|w\rR5sA!\u001a\u0011Ga\u0016\u0011\u0007I\u0014I&C\u0002\u0003\\M\u0014\u0001B^8mCRLG.Z\u0001\u001a[\u0006D\bK]8ek\u000e,'/\u00133FqBL'/\u0019;j_:l5/\u0001\u000enCb\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0003uS6,WC\u0001B\u0011\u0003\u0015!\u0018.\\3!))\u0011IGa\u001b\u0003n\t=$\u0011\u000f\t\u0003]2BqA!\u000f7\u0001\u0004\u0011i\u0004C\u0004\u0003HY\u0002\r!a(\t\u0013\tuc\u0007%AA\u0002\u0005\u0005\u0003\"\u0003B1mA\u0005\t\u0019\u0001B\u0011\u0003%\u0019h.\u00199tQ>$8/\u0006\u0002\u0003xAA!\u0011\u0010BB\u0005\u000f\u000bI0\u0004\u0002\u0003|)!!Q\u0010B@\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005\u0003\u000bY!\u0001\u0003vi&d\u0017\u0002\u0002BC\u0005w\u0012QcQ8oGV\u0014(/\u001a8u'.L\u0007\u000fT5ti6\u000b\u0007\u000f\u0005\u0003\u0002\u0006\t%\u0015\u0002BAq\u0003\u000f\tQb\u001d8baNDw\u000e^:`I\u0015\fH\u0003BAa\u0005\u001fC\u0011B!\u00159\u0003\u0003\u0005\rAa\u001e\u0002\u0015Mt\u0017\r]:i_R\u001c\b%A\u0005qe>$WoY3sgV\u0011\u0011QZ\u0001\u000baJ|G-^2feN\u0004\u0013!\u00047bgRl\u0015\r](gMN,G/\u0006\u0002\u0002^\u0006\tB.Y:u\u001b\u0006\u0004xJ\u001a4tKR|F%Z9\u0015\t\u0005\u0005'\u0011\u0015\u0005\n\u0005#j\u0014\u0011!a\u0001\u0003;\fa\u0002\\1ti6\u000b\u0007o\u00144gg\u0016$\b%\u0001\bmCN$8K\\1q\u001f\u001a47/\u001a;\u0002%1\f7\u000f^*oCB|eMZ:fi~#S-\u001d\u000b\u0005\u0003\u0003\u0014Y\u000bC\u0005\u0003R\u0001\u000b\t\u00111\u0001\u0002^\u0006yA.Y:u':\f\u0007o\u00144gg\u0016$\b%A\u0006p]\u001e|\u0017N\\4Uq:\u001cXC\u0001BZ!!\u0011)La.\u0002^\nmVB\u0001B@\u0013\u0011\u0011ILa \u0003\u000fQ\u0013X-Z'baB\u0019aN!0\n\u0007\t}\u0006NA\u0006Uq:lU\r^1eCR\f\u0017\u0001D8oO>Lgn\u001a+y]N\u0004\u0013\u0001E;oe\u0016\u0004H.[2bi\u0016$G\u000b\u001f8t\u0003E)hN]3qY&\u001c\u0017\r^3e)bt7\u000fI\u0001\u000eY>\fGm\u00158baNDw\u000e^:\u0015\u0005\t]\u0014\u0001\u0006:f[>4Xm\u0015;sCf\u001cf.\u00199tQ>$8\u000f\u0006\u0003\u0002B\n=\u0007b\u0002Bi\u000f\u0002\u0007!1[\u0001\u0013g\u0016<W.\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$8\u000f\u0005\u0004\u0002\u0000\u0005U\u0018Q\\\u0001\u0014M&\u00148\u000f^+ogR\f'\r\\3PM\u001a\u001cX\r^\u000b\u0003\u00053\u0004RA\u001dBn\u0005?L1A!8t\u0005\u0019y\u0005\u000f^5p]B!!\u0011\u001dBt\u001b\t\u0011\u0019OC\u0002\u0003f*\faa]3sm\u0016\u0014\u0018\u0002\u0002Bu\u0005G\u0014\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0003Yyg\u000eS5hQ^\u000bG/\u001a:nCJ\\W\u000b\u001d3bi\u0016$G\u0003BAa\u0005_DqA!=J\u0001\u0004\ti.A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0015M&\u00148\u000f^+oI\u0016\u001c\u0017\u000eZ3e\u001f\u001a47/\u001a;\u0016\u0005\t]\b#\u0002:\u0003\\\u0006u\u0017\u0001D7ba\u0016sGm\u00144gg\u0016$\u0018aD1di&4X\r\u0015:pIV\u001cWM]:\u0016\u0005\t}\b\u0003CB\u0001\u0007\u000f\ti.!&\u000e\u0005\r\r!\u0002BB\u0003\u0003+\f\u0011\"[7nkR\f'\r\\3\n\t\u0005m71A\u0001\bSN,U\u000e\u001d;z+\t\t9/\u0001\tm_\u0006$gI]8n':\f\u0007o\u001d5piR1\u0011\u0011YB\t\u0007+Aqaa\u0005O\u0001\u0004\ti.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u000f\r]a\n1\u0001\u0002^\u0006Y1-\u001e:sK:$H+[7f\u0003Eaw.\u00193Qe>$WoY3s\u000b:$(/\u001f\u000b\u0005\u0003\u0003\u001ci\u0002C\u0004\u0004 =\u0003\r!!&\u0002\u000b\u0015tGO]=\u0002#%\u001c\bK]8ek\u000e,'/\u0012=qSJ,G\r\u0006\u0004\u0002h\u000e\u00152\u0011\u0006\u0005\b\u0007O\u0001\u0006\u0019AAo\u00035\u0019WO\u001d:f]R$\u0016.\\3Ng\"911\u0006)A\u0002\u0005U\u0015!\u00049s_\u0012,8-\u001a:Ti\u0006$X-\u0001\fsK6|g/Z#ya&\u0014X\r\u001a)s_\u0012,8-\u001a:t)\u0011\t\tm!\r\t\u000f\r\u001d\u0012\u000b1\u0001\u0002^\u0006\tBO];oG\u0006$X-\u00118e%\u0016dw.\u00193\u0015\u0011\u0005\u00057qGB\u001d\u0007{Aqaa\u0005S\u0001\u0004\ti\u000eC\u0004\u0004<I\u0003\r!!8\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\t\u000f\r\u001d\"\u000b1\u0001\u0002^\u0006A\"/\u001a7pC\u00124%o\\7US\u0016\u0014X\rZ*oCB\u001c\bn\u001c;\u0015\u0015\u0005\u000571IB#\u0007\u000f\u001aY\u0005C\u0004\u0004\u0014M\u0003\r!!8\t\u000f\r]1\u000b1\u0001\u0002^\"91\u0011J*A\u0002\u0005E\u0016AD:oCB\u001c\bn\u001c;Ck\u001a4WM\u001d\u0005\b\u0007\u001b\u001a\u0006\u0019AAo\u00039\u0019h.\u00199tQ>$xJ\u001a4tKR\fQ\u0002\u001d:fa\u0006\u0014X-\u00169eCR,GCBB*\u00073\u001ai\u0006E\u0002o\u0007+J1aa\u0016i\u0005I\u0001&o\u001c3vG\u0016\u0014\u0018\t\u001d9f]\u0012LeNZ8\t\u000f\rmC\u000b1\u0001\u0002^\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u000f\r}C\u000b1\u0001\u0004b\u00051qN]5hS:\u00042A\\B2\u0013\r\u0019)\u0007\u001b\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\\\u0001\u0007kB$\u0017\r^3\u0015\t\u0005\u000571\u000e\u0005\b\u0007[*\u0006\u0019AB*\u0003)\t\u0007\u000f]3oI&sgm\\\u0001\u0013kB$\u0017\r^3NCB,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002B\u000eM\u0004bBB;-\u0002\u0007\u0011Q\\\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\u0018!\u00037bgR,e\u000e\u001e:z)\u0011\u0019Yh! \u0011\u000bI\u0014Y.!&\t\u000f\rms\u000b1\u0001\u0002^\u0006aA/Y6f':\f\u0007o\u001d5piR\u0011\u0011\u0011Y\u0001\u0010kB$\u0017\r^3QCJ,g\u000e\u001e#jeR!\u0011\u0011YBD\u0011\u001d\u0019I)\u0017a\u0001\u0003?\u000b\u0011\u0002]1sK:$H)\u001b:\u0002)1\fG/Z:u':\f\u0007o\u001d5pi>3gm]3u\u0003QyG\u000eZ3tiNs\u0017\r]:i_R|eMZ:fi\u0006YrN\u001c'pON#\u0018M\u001d;PM\u001a\u001cX\r^%oGJ,W.\u001a8uK\u0012$B!!1\u0004\u0014\"911\u0003/A\u0002\u0005u\u0017A\b:f[>4X-\u00168sKBd\u0017nY1uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\t\tm!'\t\u000f\rmU\f1\u0001\u0002^\u00061qN\u001a4tKR\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\t\u0005\u00057\u0011\u0015\u0005\b\u00077s\u0006\u0019AAo\u0003Aa\u0017m\u001d;Ti\u0006\u0014G.Z(gMN,G\u000f\u0006\u0003\u0002^\u000e\u001d\u0006bBBU?\u0002\u000711V\u0001\rG>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\t\u0004]\u000e5\u0016bABXQ\na1i\\7qY\u0016$X\r\u001a+y]\u0006Y1m\\7qY\u0016$X\r\u0016=o)\u0011\t\tm!.\t\u000f\r%\u0006\r1\u0001\u0004,\u0006)B-\u001a7fi\u0016\u001cf.\u00199tQ>$8OQ3g_J,G\u0003BAa\u0007wCqaa'b\u0001\u0004\ti\u000eK\u0002b\u0007\u007f\u0003BA!\r\u0004B&!11\u0019B\u001a\u0005)!\bN]3bIN\fg-Z\u0001\u0013_2$Wm\u001d;T]\u0006\u00048\u000f[8u\r&dW-\u0006\u0002\u0004JB)!Oa7\u0002z\u0006\u0011B.\u0019;fgR\u001cf.\u00199tQ>$h)\u001b7f\u0003U\u0019h.\u00199tQ>$h)\u001b7f\r>\u0014xJ\u001a4tKR$Ba!3\u0004R\"911\u00143A\u0002\u0005u\u0017a\u0006:f[>4X-\u00118e\t\u0016dW\r^3T]\u0006\u00048\u000f[8u)\u0011\t\tma6\t\u000f\r5S\r1\u0001\u0002^\u0006\u0001#/Z7pm\u0016\fe\u000eZ'be.\u001cf.\u00199tQ>$hi\u001c:EK2,G/[8o)\u0011\u0019Im!8\t\u000f\r5c\r1\u0001\u0002^\"\u001aAf!9\u0011\t\tE21]\u0005\u0005\u0007K\u0014\u0019DA\u0007o_:$\bN]3bIN\fg-\u001a")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File _logDir;
    private final int maxProducerIdExpirationMs;
    private final Time time;
    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Seq<SnapshotFile> listSnapshotFiles(File file) {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(file);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(ByteBuffer byteBuffer) {
        return ProducerStateManager$.MODULE$.readSnapshot(byteBuffer);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File _logDir() {
        return this._logDir;
    }

    public void _logDir_$eq(File x$1) {
        this._logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    public Time time() {
        return this.time;
    }

    private ConcurrentSkipListMap<Long, SnapshotFile> snapshots() {
        return this.snapshots;
    }

    private void snapshots_$eq(ConcurrentSkipListMap<Long, SnapshotFile> x$1) {
        this.snapshots = x$1;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    private ConcurrentSkipListMap<Long, SnapshotFile> loadSnapshots() {
        void var1_1;
        ConcurrentSkipListMap tm = new ConcurrentSkipListMap();
        ProducerStateManager$.MODULE$.listSnapshotFiles(this._logDir()).foreach((Function1 & Serializable & scala.Serializable)f -> tm.put(Predef$.MODULE$.long2Long(f.offset()), f));
        return var1_1;
    }

    public void removeStraySnapshots(Seq<Object> segmentBaseOffsets) {
        None$ maxSegmentBaseOffset = segmentBaseOffsets.isEmpty() ? None$.MODULE$ : new Some(segmentBaseOffsets.max((Ordering)Ordering.Long$.MODULE$));
        Set baseOffsets = segmentBaseOffsets.toSet();
        ObjectRef latestStraySnapshot = ObjectRef.create((Object)None$.MODULE$);
        ConcurrentSkipListMap<Long, SnapshotFile> ss = this.loadSnapshots();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(ss.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$removeStraySnapshots$1(latestStraySnapshot, baseOffsets, ss, snapshot);
            return BoxedUnit.UNIT;
        });
        ((Option)latestStraySnapshot.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset())).foreach((Function1)((JFunction1.mcVJ.sp & Serializable & scala.Serializable)arg_0 -> ProducerStateManager.$anonfun$removeStraySnapshots$3((Option)maxSegmentBaseOffset, ss, arg_0)));
        this.snapshots_$eq(ss);
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        if (unreplicatedFirstOffset.isEmpty()) {
            return undecidedFirstOffset;
        }
        if (undecidedFirstOffset.isEmpty()) {
            return unreplicatedFirstOffset;
        }
        if (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset()) {
            return undecidedFirstOffset;
        }
        return var1_1;
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        Option<SnapshotFile> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            SnapshotFile snapshot = (SnapshotFile)((Some)option).value();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading producer state from snapshot file '").append(snapshot).append("'").toString());
                ((Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshot.file()).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, currentTime, producerEntry)))).foreach((Function1 & Serializable & scala.Serializable)entry -> {
                    this.loadProducerEntry(entry);
                    return BoxedUnit.UNIT;
                });
                this.lastSnapOffset_$eq(snapshot.offset());
                this.lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to load producer snapshot from '").append(snapshot.file()).append("': ").append(e.getMessage()).toString());
                this.removeAndDeleteSnapshot(snapshot.offset());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset);
            this.lastMapOffset_$eq(logStartOffset);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().$minus$minus$eq((TraversableOnce)((MapLike)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, x0$1)))).keySet());
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            ProducerStateManager.$anonfun$truncateAndReload$1(this, logEndOffset, logStartOffset, snapshot);
            return BoxedUnit.UNIT;
        });
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
            return;
        }
        this.onLogStartOffsetIncremented(logStartOffset);
    }

    public void reloadFromTieredSnapshot(long logStartOffset, long currentTime, ByteBuffer snapshotBuffer, long snapshotOffset) {
        if (this.activeProducers().nonEmpty()) {
            throw new IllegalStateException("expected producer state to be fully truncated before reloading tiered snapshot");
        }
        try {
            Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshotBuffer).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$reloadFromTieredSnapshot$1(this, currentTime, producerEntry)));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("restored state for ").append(loadedProducers.size()).append(" producers from tiered storage").toString());
            loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                this.loadProducerEntry(entry);
                return BoxedUnit.UNIT;
            });
            this.lastMapOffset_$eq(snapshotOffset);
            return;
        }
        catch (CorruptSnapshotException e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to load producer snapshot from buffer: ").append(e.getMessage()).toString());
            throw e;
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Invalid producer id ").append(appendInfo.producerId()).append(" passed to update ").append("for partition ").append(this.topicPartition()).toString());
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Updated producer ").append(appendInfo.producerId()).append(" state to ").append(appendInfo).toString());
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            ((ProducerStateEntry)((Some)option).value()).update(updatedEntry);
        } else if (None$.MODULE$.equals(option)) {
            this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.lastMapOffset() > this.lastSnapOffset()) {
            SnapshotFile snapshotFile = SnapshotFile$.MODULE$.apply(Log$.MODULE$.producerSnapshotFile(this._logDir(), this.lastMapOffset()));
            long start = this.time().hiResClockMs();
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile.file(), this.producers());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Wrote producer snapshot at offset ").append(this.lastMapOffset()).append(" with ").append(this.producers().size()).append(" producer ids in ").append(this.time().hiResClockMs() - start).append(" ms.").toString());
            this.snapshots().put(Predef$.MODULE$.long2Long(snapshotFile.offset()), snapshotFile);
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public void updateParentDir(File parentDir) {
        this._logDir_$eq(parentDir);
        this.snapshots().forEach((x$7, s) -> s.updateParentDir(parentDir));
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.offset()));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset()));
    }

    public void onLogStartOffsetIncremented(long logStartOffset) {
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getValue().lastOffset().exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$10 -> x$10 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncateFullyAndStartAt(long offset) {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(offset);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        return BoxesRunTime.unboxToLong((Object)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.ongoingTxns().values()).asScala()).find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$lastStableOffset$1(completedTxn, x$11))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$lastStableOffset$2(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Attempted to complete transaction ").append(completedTxn).append(" on partition ").append(this.topicPartition()).append(" ").append("which was not started").toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset) {
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.snapshots().subMap((Object)Predef$.MODULE$.long2Long(0L), (Object)Predef$.MODULE$.long2Long(offset)).values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)snapshot -> {
            this.removeAndDeleteSnapshot(snapshot.offset());
            return BoxedUnit.UNIT;
        });
    }

    private Option<SnapshotFile> oldestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$13 -> (SnapshotFile)x$13.getValue());
    }

    private Option<SnapshotFile> latestSnapshotFile() {
        return Option$.MODULE$.apply(this.snapshots().lastEntry()).map((Function1 & Serializable & scala.Serializable)x$14 -> (SnapshotFile)x$14.getValue());
    }

    public Option<SnapshotFile> snapshotFileForOffset(long offset) {
        return Option$.MODULE$.apply((Object)this.snapshots().get(BoxesRunTime.boxToLong((long)offset)));
    }

    private void removeAndDeleteSnapshot(long snapshotOffset) {
        Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).foreach((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.deleteIfExists()));
    }

    public Option<SnapshotFile> removeAndMarkSnapshotForDeletion(long snapshotOffset) {
        return Option$.MODULE$.apply((Object)this.snapshots().remove(BoxesRunTime.boxToLong((long)snapshotOffset))).flatMap((Function1 & Serializable & scala.Serializable)snapshot -> {
            try {
                snapshot.renameTo(Log$.MODULE$.DeletedFileSuffix());
                return new Some(snapshot);
            }
            catch (NoSuchFileException noSuchFileException) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Failed to rename producer state snapshot ").append(snapshot.file().getAbsoluteFile()).append(" with deletion suffix because it was already deleted").toString());
                return None$.MODULE$;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$1(ObjectRef latestStraySnapshot$1, Set baseOffsets$1, ConcurrentSkipListMap ss$1, SnapshotFile snapshot) {
        long key = snapshot.offset();
        Option option = (Option)latestStraySnapshot$1.elem;
        if (option instanceof Some) {
            SnapshotFile prev = (SnapshotFile)((Some)option).value();
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                prev.deleteIfExists();
                ss$1.remove(BoxesRunTime.boxToLong((long)prev.offset()));
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else if (None$.MODULE$.equals(option)) {
            if (!baseOffsets$1.contains((Object)BoxesRunTime.boxToLong((long)key))) {
                latestStraySnapshot$1.elem = new Some((Object)snapshot);
                return;
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$removeStraySnapshots$3(Option maxSegmentBaseOffset$1, ConcurrentSkipListMap ss$1, long strayOffset) {
        maxSegmentBaseOffset$1.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxOffset -> {
            if (strayOffset < maxOffset) {
                Option$.MODULE$.apply(ss$1.remove(BoxesRunTime.boxToLong((long)strayOffset))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.deleteIfExists()));
            }
        });
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long currentTime$1, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$1, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$1, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)x0$1._2();
        boolean bl = $this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateAndReload$1(ProducerStateManager $this, long logEndOffset$1, long logStartOffset$1, SnapshotFile snapshot) {
        if (snapshot.offset() > logEndOffset$1 || snapshot.offset() <= logStartOffset$1) {
            $this.removeAndDeleteSnapshot(snapshot.offset());
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadFromTieredSnapshot$1(ProducerStateManager $this, long currentTime$2, ProducerStateEntry producerEntry) {
        return !$this.isProducerExpired(currentTime$2, producerEntry);
    }

    public static final /* synthetic */ boolean $anonfun$lastStableOffset$1(CompletedTxn completedTxn$1, TxnMetadata x$11) {
        return x$11.producerId() != completedTxn$1.producerId();
    }

    public static final /* synthetic */ long $anonfun$lastStableOffset$2(TxnMetadata x$12) {
        return x$12.firstOffset().messageOffset();
    }

    public ProducerStateManager(TopicPartition topicPartition, File _logDir, int maxProducerIdExpirationMs, Time time) {
        this.topicPartition = topicPartition;
        this._logDir = _logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[ProducerStateManager partition=").append(topicPartition).append("] ").toString());
        this.snapshots = (ConcurrentSkipListMap)Predef$.MODULE$.locally(this.loadSnapshots());
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

