/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0012%\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ty\u0001\u0011)\u0019!C\u0001{!A1\n\u0001B\u0001B\u0003%a\b\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0011!!\u0006A!A!\u0002\u0013q\u0005\"B+\u0001\t\u00031\u0006b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007Q\u0002\u0001\u000b\u0011\u00020\t\u000f%\u0004!\u0019!C\u0001;\"1!\u000e\u0001Q\u0001\nyCqa\u001b\u0001A\u0002\u0013\u0005A\u000eC\u0004q\u0001\u0001\u0007I\u0011A9\t\r]\u0004\u0001\u0015)\u0003n\u0011\u001dA\b\u00011A\u0005\u0002eDq! \u0001A\u0002\u0013\u0005a\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0015\u0002>\t\u0011\u0005\r\u0001\u00011A\u0005\u0002eD\u0011\"!\u0002\u0001\u0001\u0004%\t!a\u0002\t\u000f\u0005-\u0001\u0001)Q\u0005u\"A\u0011Q\u0002\u0001A\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0002\u0012!9\u0011Q\u0003\u0001!B\u0013Q\b\u0002CA\f\u0001\u0001\u0007I\u0011\u00017\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0001bBA\u0010\u0001\u0001\u0006K!\u001c\u0005\t\u0003C\u0001\u0001\u0019!C\u0001Y\"I\u00111\u0005\u0001A\u0002\u0013\u0005\u0011Q\u0005\u0005\b\u0003S\u0001\u0001\u0015)\u0003n\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!a\f\u0001\t\u0003\ti\u0003C\u0004\u00022\u0001!\t!!\f\t\u000f\u0005M\u0002\u0001\"\u0001\u0002.!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0002\u0019\u0019&tW\u000f_\"qk6+GO]5dg\u000e{G\u000e\\3di>\u0014(BA\u0013'\u0003\u001diW\r\u001e:jGNT\u0011aJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VMZ\u0001\taJ|7MU8piB\u0011!'\u000f\b\u0003g]\u0002\"\u0001\u000e\u0017\u000e\u0003UR!A\u000e\u0015\u0002\rq\u0012xn\u001c;?\u0013\tAD&\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d-\u0003\u0011!\u0018.\\3\u0016\u0003y\u0002\"aP%\u000e\u0003\u0001S!!\u0011\"\u0002\u000bU$\u0018\u000e\\:\u000b\u0005\r#\u0015AB2p[6|gN\u0003\u0002(\u000b*\u0011aiR\u0001\u0007CB\f7\r[3\u000b\u0003!\u000b1a\u001c:h\u0013\tQ\u0005I\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u00027pO\u001e,'/F\u0001O!\ty%+D\u0001Q\u0015\t\tv)A\u0003tY\u001a$$.\u0003\u0002T!\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005/fS6\f\u0005\u0002Y\u00015\tA\u0005C\u00031\r\u0001\u0007\u0011\u0007C\u0003=\r\u0001\u0007a\bC\u0003M\r\u0001\u0007a*A\u0006m_\u0006$\u0017I^4QCRDW#\u00010\u0011\u0005}3W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001\u00024jY\u0016T!a\u00193\u0002\u00079LwNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0004'\u0001\u0002)bi\"\fA\u0002\\8bI\u00063x\rU1uQ\u0002\n\u0001b\u001d;biB\u000bG\u000f[\u0001\ngR\fG\u000fU1uQ\u0002\n1\u0003\\1ti2{\u0017\rZ!wOV\u0003H-\u0019;f\u001bN,\u0012!\u001c\t\u0003W9L!a\u001c\u0017\u0003\t1{gnZ\u0001\u0018Y\u0006\u001cH\u000fT8bI\u00063x-\u00169eCR,Wj]0%KF$\"A];\u0011\u0005-\u001a\u0018B\u0001;-\u0005\u0011)f.\u001b;\t\u000fYd\u0011\u0011!a\u0001[\u0006\u0019\u0001\u0010J\u0019\u0002)1\f7\u000f\u001e'pC\u0012\feoZ+qI\u0006$X-T:!\u00035aw.\u00193Bm\u001e|e.Z'j]V\t!\u0010\u0005\u0002,w&\u0011A\u0010\f\u0002\u0007\t>,(\r\\3\u0002#1|\u0017\rZ!wO>sW-T5o?\u0012*\u0017\u000f\u0006\u0002s\u007f\"9aoDA\u0001\u0002\u0004Q\u0018A\u00047pC\u0012\feoZ(oK6Kg\u000eI\u0001\u000fY>\fG-\u0011<h\r&4X-T5o\u0003Iaw.\u00193Bm\u001e4\u0015N^3NS:|F%Z9\u0015\u0007I\fI\u0001C\u0004w%\u0005\u0005\t\u0019\u0001>\u0002\u001f1|\u0017\rZ!wO\u001aKg/Z'j]\u0002\n\u0011\u0003\\8bI\u00063xMR5gi\u0016,g.T5o\u0003Uaw.\u00193Bm\u001e4\u0015N\u001a;fK:l\u0015N\\0%KF$2A]A\n\u0011\u001d1X#!AA\u0002i\f!\u0003\\8bI\u00063xMR5gi\u0016,g.T5oA\u0005aAo\u001c;bY\u000e\u0003X\u000fV5nK\u0006\u0001Bo\u001c;bY\u000e\u0003X\u000fV5nK~#S-\u001d\u000b\u0004e\u0006u\u0001b\u0002<\u0019\u0003\u0003\u0005\r!\\\u0001\u000ei>$\u0018\r\\\"qkRKW.\u001a\u0011\u0002\u001bQ|G/\u00197JI2,G+[7f\u0003E!x\u000e^1m\u0013\u0012dW\rV5nK~#S-\u001d\u000b\u0004e\u0006\u001d\u0002b\u0002<\u001c\u0003\u0003\u0005\r!\\\u0001\u000fi>$\u0018\r\\%eY\u0016$\u0016.\\3!\u0003Q\u0019\u0018p\u001d;f[\u000e\u0003X/\u0016;jY&T\u0018\r^5p]R\t!0A\u0007p]\u0016l\u0015N\u001c'pC\u0012\feoZ\u0001\u000fM&4X-T5o\u0019>\fG-\u0011<h\u0003E1\u0017N\u001a;fK:l\u0015N\u001c'pC\u0012\feoZ\u0001\u000ekB$\u0017\r^3M_\u0006$\u0017I^4\u0015\t\u0005e\u0012q\b\t\u0004W\u0005m\u0012bAA\u001fY\t9!i\\8mK\u0006t\u0007BBA!C\u0001\u0007Q.A\u0002o_^\fa!^:bE2,GCAA\u001d\u0001")
public class LinuxCpuMetricsCollector {
    private final Time time;
    private final Logger logger;
    private final Path loadAvgPath;
    private final Path statPath;
    private long lastLoadAvgUpdateMs;
    private double loadAvgOneMin;
    private double loadAvgFiveMin;
    private double loadAvgFifteenMin;
    private long totalCpuTime;
    private long totalIdleTime;

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    public Path loadAvgPath() {
        return this.loadAvgPath;
    }

    public Path statPath() {
        return this.statPath;
    }

    public long lastLoadAvgUpdateMs() {
        return this.lastLoadAvgUpdateMs;
    }

    public void lastLoadAvgUpdateMs_$eq(long x$1) {
        this.lastLoadAvgUpdateMs = x$1;
    }

    public double loadAvgOneMin() {
        return this.loadAvgOneMin;
    }

    public void loadAvgOneMin_$eq(double x$1) {
        this.loadAvgOneMin = x$1;
    }

    public double loadAvgFiveMin() {
        return this.loadAvgFiveMin;
    }

    public void loadAvgFiveMin_$eq(double x$1) {
        this.loadAvgFiveMin = x$1;
    }

    public double loadAvgFifteenMin() {
        return this.loadAvgFifteenMin;
    }

    public void loadAvgFifteenMin_$eq(double x$1) {
        this.loadAvgFifteenMin = x$1;
    }

    public long totalCpuTime() {
        return this.totalCpuTime;
    }

    public void totalCpuTime_$eq(long x$1) {
        this.totalCpuTime = x$1;
    }

    public long totalIdleTime() {
        return this.totalIdleTime;
    }

    public void totalIdleTime_$eq(long x$1) {
        this.totalIdleTime = x$1;
    }

    public synchronized double systemCpuUtilization() {
        try {
            String[] cpu = ((String)((BufferLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).apply(0)).split("\\s+");
            LongRef total = LongRef.create((long)0L);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), cpu.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> total$1.elem += new StringOps(Predef$.MODULE$.augmentString(cpu[i])).toLong());
            long idleTime = new StringOps(Predef$.MODULE$.augmentString(cpu[4])).toLong();
            if (this.totalCpuTime() == 0L) {
                this.totalCpuTime_$eq(total.elem);
                this.totalIdleTime_$eq(idleTime);
                return 0.0;
            }
            long currWindowCpuTime = total.elem - this.totalCpuTime();
            long currWindowIdleTime = idleTime - this.totalIdleTime();
            this.totalCpuTime_$eq(total.elem);
            this.totalIdleTime_$eq(idleTime);
            double idlePercentage = (double)currWindowIdleTime * 100.0 / (double)currWindowCpuTime;
            return 100.0 - idlePercentage;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            Predef$.MODULE$.println((Object)t);
            return -1.0;
        }
    }

    public synchronized double oneMinLoadAvg() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastLoadAvgUpdateMs()) {
            this.updateLoadAvg(curMs);
        }
        return this.loadAvgOneMin();
    }

    public synchronized double fiveMinLoadAvg() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastLoadAvgUpdateMs()) {
            this.updateLoadAvg(curMs);
        }
        return this.loadAvgFiveMin();
    }

    public synchronized double fifteenMinLoadAvg() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastLoadAvgUpdateMs()) {
            this.updateLoadAvg(curMs);
        }
        return this.loadAvgFifteenMin();
    }

    public synchronized boolean updateLoadAvg(long now) {
        try {
            this.loadAvgOneMin_$eq(-1.0);
            this.loadAvgFiveMin_$eq(-1.0);
            this.loadAvgFifteenMin_$eq(-1.0);
            String[] loadAvgArr = ((String)((BufferLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.loadAvgPath())).asScala()).apply(0)).split("\\s+");
            this.loadAvgOneMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[0])).toDouble());
            this.loadAvgFiveMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[1])).toDouble());
            this.loadAvgFifteenMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[2])).toDouble());
            this.lastLoadAvgUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            return false;
        }
    }

    public boolean usable() {
        return this.loadAvgPath().toFile().exists() && this.statPath().toFile().exists();
    }

    public LinuxCpuMetricsCollector(String procRoot, Time time, Logger logger) {
        this.time = time;
        this.logger = logger;
        this.loadAvgPath = Paths.get(procRoot, "loadavg");
        this.statPath = Paths.get(procRoot, "stat");
        this.lastLoadAvgUpdateMs = -1L;
        this.loadAvgOneMin = -1.0;
        this.loadAvgFiveMin = -1.0;
        this.loadAvgFifteenMin = -1.0;
        this.totalCpuTime = 0L;
        this.totalIdleTime = 0L;
    }
}

