/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.Acceptor$;
import kafka.network.Acceptor$DelayedCloseSocket$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotas$;
import kafka.network.ConnectionThrottledException;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.server.ProcessorQueueSizePercentiles$;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.PriorityQueue;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r-f!B+W\u0001aS\u0006\u0002C3\u0001\u0005\u000b\u0007I\u0011A4\t\u00119\u0004!\u0011!Q\u0001\n!D\u0001b\u001c\u0001\u0003\u0002\u0004%\t\u0001\u001d\u0005\to\u0002\u0011\t\u0019!C\u0001q\"Aa\u0010\u0001B\u0001B\u0003&\u0011\u000fC\u0005\u0002\b\u0001\u0011)\u0019!C\u0001a\"I\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\n\u0003\u0017\u0001!\u0011!Q\u0001\nED!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\b\u0011%\u0011\u0007A!A!\u0002\u0013\t)\u0002\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003_A!\"!\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA$\u0011)\t\u0019\u0006\u0001B\u0001B\u0003%\u0011q\u0006\u0005\b\u0003+\u0002A\u0011AA,\u0011%\ti\u0007\u0001b\u0001\n\u0013\ty\u0007\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA9\u0011%\t9\t\u0001b\u0001\n\u0003\tI\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAF\u0011%\t\u0019\n\u0001b\u0001\n\u0013\t)\n\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAL\u0011%\ty\u000b\u0001b\u0001\n\u0013\t\t\f\u0003\u0005\u0002H\u0002\u0001\u000b\u0011BAZ\u0011%\tI\r\u0001b\u0001\n\u0013\tY\r\u0003\u0005\u0002d\u0002\u0001\u000b\u0011BAg\u0011%\t)\u000f\u0001b\u0001\n\u0013\tY\r\u0003\u0005\u0002h\u0002\u0001\u000b\u0011BAg\u0011%\tI\u000f\u0001b\u0001\n\u0013\tY\u000f\u0003\u0005\u0002t\u0002\u0001\u000b\u0011BAw\u0011)\t)\u0010\u0001b\u0001\n\u00031\u00161\u001e\u0005\t\u0003o\u0004\u0001\u0015!\u0003\u0002n\"A\u0011\u0011 \u0001A\u0002\u0013%\u0001\u000fC\u0005\u0002|\u0002\u0001\r\u0011\"\u0003\u0002~\"9!\u0011\u0001\u0001!B\u0013\t\bB\u0003B\u0002\u0001\t\u0007I\u0011\u0001,\u0003\u0006!A!q\u0019\u0001!\u0002\u0013\u00119\u0001C\u0005\u0003J\u0002\u0001\r\u0011\"\u0003\u0003H!I!1\u001a\u0001A\u0002\u0013%!Q\u001a\u0005\t\u0005#\u0004\u0001\u0015)\u0003\u0003J\u00199!\u0011\u0003\u0001A-\nM\u0001B\u0003B\u001dO\tU\r\u0011\"\u0001\u0003<!Q!1I\u0014\u0003\u0012\u0003\u0006IA!\u0010\t\u0015\t\u0015sE!f\u0001\n\u0003\u00119\u0005\u0003\u0006\u0003P\u001d\u0012\t\u0012)A\u0005\u0005\u0013Bq!!\u0016(\t\u0003\u0011\t\u0006C\u0004\u0003X\u001d\"\tE!\u0017\t\u0013\t}s%!A\u0005\u0002\t\u0005\u0004\"\u0003B4OE\u0005I\u0011\u0001B5\u0011%\u0011yhJI\u0001\n\u0003\u0011\t\tC\u0005\u0003\u0006\u001e\n\t\u0011\"\u0011\u0003\b\"A!1S\u0014\u0002\u0002\u0013\u0005\u0001\u000fC\u0005\u0003\u0016\u001e\n\t\u0011\"\u0001\u0003\u0018\"I!\u0011U\u0014\u0002\u0002\u0013\u0005#1\u0015\u0005\n\u0005[;\u0013\u0011!C\u0001\u0005_C\u0011B!/(\u0003\u0003%\tEa/\t\u0013\tuv%!A\u0005B\t}\u0006\"\u0003BaO\u0005\u0005I\u0011\tBb\u000f)\u0011\u0019\u000eAA\u0001\u0012\u00031&Q\u001b\u0004\u000b\u0005#\u0001\u0011\u0011!E\u0001-\n]\u0007bBA+u\u0011\u0005!Q\u001d\u0005\n\u0005{S\u0014\u0011!C#\u0005\u007fC\u0011Ba:;\u0003\u0003%\tI!;\t\u0013\t=((!A\u0005\u0002\nE\b\u0002CB\u0002\u0001\u0011\u0005ak!\u0002\t\u0011\rU\u0001\u0001\"\u0001W\u0007/Aqa!\u0006\u0001\t\u0013\u0019Y\u0002\u0003\u0005\u0004(\u0001!\tAVB\u0015\u0011\u001d\u0019I\u0004\u0001C!\u0007wAqa!\u0010\u0001\t\u0003\u001aY\u0004C\u0004\u0004@\u0001!\taa\u000f\t\u000f\r\u0005\u0003\u0001\"\u0003\u0004D!A1Q\t\u0001\u0005\u0002Y\u001b9\u0005C\u0004\u0004X\u0001!Ia!\u0017\t\u000f\r\r\u0004\u0001\"\u0003\u0004<!91Q\r\u0001\u0005\n\r\u001d\u0004bBB;\u0001\u0011%11\b\u0005\b\u0007o\u0002A\u0011BB\u001e\u0011\u001d\u0019I\b\u0001C\u0005\u0007wBqa!$\u0001\t\u0013\u0019y\tC\u0004\u0004\u0012\u0002!Iaa$\t\u000f\rM\u0005\u0001\"\u0001\u0004<\u001dQ1Q\u0014,\u0002\u0002#\u0005\u0001la(\u0007\u0013U3\u0016\u0011!E\u00011\u000e\u0005\u0006bBA+%\u0012\u000511\u0015\u0005\n\u0007K\u0013\u0016\u0013!C\u0001\u0007O\u0013\u0001\"Q2dKB$xN\u001d\u0006\u0003/b\u000bqA\\3uo>\u00148NC\u0001Z\u0003\u0015Y\u0017MZ6b'\r\u00011l\u0018\t\u00039vk\u0011AV\u0005\u0003=Z\u0013A#\u00112tiJ\f7\r^*feZ,'\u000f\u00165sK\u0006$\u0007C\u00011d\u001b\u0005\t'B\u00012Y\u0003\u001diW\r\u001e:jGNL!\u0001Z1\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0005f]\u0012\u0004v.\u001b8u\u0007\u0001)\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003Wb\u000bqa\u00197vgR,'/\u0003\u0002nU\nAQI\u001c3Q_&tG/A\u0005f]\u0012\u0004v.\u001b8uA\u0005q1/\u001a8e\u0005V4g-\u001a:TSj,W#A9\u0011\u0005I,X\"A:\u000b\u0003Q\fQa]2bY\u0006L!A^:\u0003\u0007%sG/\u0001\ntK:$')\u001e4gKJ\u001c\u0016N_3`I\u0015\fHCA=}!\t\u0011(0\u0003\u0002|g\n!QK\\5u\u0011\u001diH!!AA\u0002E\f1\u0001\u001f\u00132\u0003=\u0019XM\u001c3Ck\u001a4WM]*ju\u0016\u0004\u0003fA\u0003\u0002\u0002A\u0019!/a\u0001\n\u0007\u0005\u00151O\u0001\u0005w_2\fG/\u001b7f\u00039\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\fqB]3dm\n+hMZ3s'&TX\rI\u0001\u0007]>$W-\u00133\u0002!\r|gN\\3di&|g.U;pi\u0006\u001c\bc\u0001/\u0002\u0012%\u0019\u00111\u0003,\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0003BA\f\u0003Si!!!\u0007\u000b\u0007\t\fYB\u0003\u0003\u0002\u001e\u0005}\u0011AB2p[6|gNC\u0002Z\u0003CQA!a\t\u0002&\u00051\u0011\r]1dQ\u0016T!!a\n\u0002\u0007=\u0014x-\u0003\u0003\u0002,\u0005e!aB'fiJL7m]\u0001\r[\u0016$(/[2Qe\u00164\u0017\u000e\u001f\t\u0005\u0003c\tyD\u0004\u0003\u00024\u0005m\u0002cAA\u001bg6\u0011\u0011q\u0007\u0006\u0004\u0003s1\u0017A\u0002\u001fs_>$h(C\u0002\u0002>M\fa\u0001\u0015:fI\u00164\u0017\u0002BA!\u0003\u0007\u0012aa\u0015;sS:<'bAA\u001fg\u0006!A/[7f!\u0011\tI%a\u0014\u000e\u0005\u0005-#\u0002BA'\u00037\tQ!\u001e;jYNLA!!\u0015\u0002L\t!A+[7f\u0003%awn\u001a)sK\u001aL\u00070\u0001\u0004=S:LGO\u0010\u000b\u0015\u00033\nY&!\u0018\u0002`\u0005\u0005\u00141MA3\u0003O\nI'a\u001b\u0011\u0005q\u0003\u0001\"B3\u000f\u0001\u0004A\u0007\"B8\u000f\u0001\u0004\t\bBBA\u0004\u001d\u0001\u0007\u0011\u000f\u0003\u0004\u0002\f9\u0001\r!\u001d\u0005\b\u0003\u001bq\u0001\u0019AA\b\u0011\u0019\u0011g\u00021\u0001\u0002\u0016!9\u0011Q\u0006\bA\u0002\u0005=\u0002bBA#\u001d\u0001\u0007\u0011q\t\u0005\n\u0003'r\u0001\u0013!a\u0001\u0003_\t1B\\5p'\u0016dWm\u0019;peV\u0011\u0011\u0011\u000f\t\u0005\u0003g\n\t)\u0004\u0002\u0002v)!\u0011qOA=\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BA>\u0003{\n1A\\5p\u0015\t\ty(\u0001\u0003kCZ\f\u0017\u0002BAB\u0003k\u0012\u0001bU3mK\u000e$xN]\u0001\r]&|7+\u001a7fGR|'\u000fI\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0005\u0005-\u0005\u0003BA:\u0003\u001bKA!a$\u0002v\t\u00192+\u001a:wKJ\u001cvnY6fi\u000eC\u0017M\u001c8fY\u0006q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0013A\u00039s_\u000e,7o]8sgV\u0011\u0011q\u0013\t\u0007\u00033\u000b\u0019+a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bq!\\;uC\ndWMC\u0002\u0002\"N\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)+a'\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u00049\u0006%\u0016bAAV-\nI\u0001K]8dKN\u001cxN]\u0001\faJ|7-Z:t_J\u001c\b%A\tqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012,\"!a-\u0011\t\u0005U\u00161Y\u0007\u0003\u0003oSA!!/\u0002<\u00061\u0011\r^8nS\u000eTA!!0\u0002@\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0005\u0017QP\u0001\u0005kRLG.\u0003\u0003\u0002F\u0006]&!D!u_6L7MQ8pY\u0016\fg.\u0001\nqe>\u001cWm]:peN\u001cF/\u0019:uK\u0012\u0004\u0013a\u00052m_\u000e\\W\r\u001a)fe\u000e,g\u000e^'fi\u0016\u0014XCAAg!\u0011\ty-a8\u000e\u0005\u0005E'\u0002BAj\u0003+\fAaY8sK*\u0019!-a6\u000b\t\u0005e\u00171\\\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005u\u0017aA2p[&!\u0011\u0011]Ai\u0005\u0015iU\r^3s\u0003Q\u0011Gn\\2lK\u0012\u0004VM]2f]RlU\r^3sA\u0005!\u0012mY2faR\u0014\u0015\r^2i)&lW-T3uKJ\fQ#Y2dKB$()\u0019;dQRKW.Z'fi\u0016\u0014\b%\u0001\u000foKR<xN]6UQJ,\u0017\rZ:DCB\f7-\u001b;z'\u0016t7o\u001c:\u0016\u0005\u00055\b\u0003BA\f\u0003_LA!!=\u0002\u001a\t11+\u001a8t_J\fQD\\3uo>\u00148\u000e\u00165sK\u0006$7oQ1qC\u000eLG/_*f]N|'\u000fI\u0001\u0019aJ|7-Z:t_J\fV/Z;f'&TXmU3og>\u0014\u0018!\u00079s_\u000e,7o]8s#V,W/Z*ju\u0016\u001cVM\\:pe\u0002\nQcY;se\u0016tG\u000f\u0015:pG\u0016\u001c8o\u001c:J]\u0012,\u00070A\rdkJ\u0014XM\u001c;Qe>\u001cWm]:pe&sG-\u001a=`I\u0015\fHcA=\u0002\u0000\"9Q\u0010IA\u0001\u0002\u0004\t\u0018AF2veJ,g\u000e\u001e)s_\u000e,7o]8s\u0013:$W\r\u001f\u0011\u0002!QD'o\u001c;uY\u0016$7k\\2lKR\u001cXC\u0001B\u0004!\u0019\tIJ!\u0003\u0003\u000e%!!1BAN\u00055\u0001&/[8sSRL\u0018+^3vKB\u0019!qB\u0014\u000e\u0003\u0001\u0011!\u0003R3mCf,Gm\u00117pg\u0016\u001cvnY6fiNIqE!\u0006\u0003\u001c\t5\"1\u0007\t\u0004e\n]\u0011b\u0001B\rg\n1\u0011I\\=SK\u001a\u0004bA!\b\u0003(\t5a\u0002\u0002B\u0010\u0005GqA!!\u000e\u0003\"%\tA/C\u0002\u0003&M\fq\u0001]1dW\u0006<W-\u0003\u0003\u0003*\t-\"aB(sI\u0016\u0014X\r\u001a\u0006\u0004\u0005K\u0019\bc\u0001:\u00030%\u0019!\u0011G:\u0003\u000fA\u0013x\u000eZ;diB\u0019!O!\u000e\n\u0007\t]2O\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004t_\u000e\\W\r^\u000b\u0003\u0005{\u0001B!a\u001d\u0003@%!!\u0011IA;\u00055\u0019vnY6fi\u000eC\u0017M\u001c8fY\u000691o\\2lKR\u0004\u0013!E3oIRC'o\u001c;uY\u0016$\u0016.\\3NgV\u0011!\u0011\n\t\u0004e\n-\u0013b\u0001B'g\n!Aj\u001c8h\u0003I)g\u000e\u001a+ie>$H\u000f\\3US6,Wj\u001d\u0011\u0015\r\t5!1\u000bB+\u0011\u001d\u0011I\u0004\fa\u0001\u0005{AqA!\u0012-\u0001\u0004\u0011I%A\u0004d_6\u0004\u0018M]3\u0015\u0007E\u0014Y\u0006C\u0004\u0003^5\u0002\rA!\u0004\u0002\tQD\u0017\r^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0003\u000e\t\r$Q\r\u0005\n\u0005sq\u0003\u0013!a\u0001\u0005{A\u0011B!\u0012/!\u0003\u0005\rA!\u0013\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u000e\u0016\u0005\u0005{\u0011ig\u000b\u0002\u0003pA!!\u0011\u000fB>\u001b\t\u0011\u0019H\u0003\u0003\u0003v\t]\u0014!C;oG\",7m[3e\u0015\r\u0011Ih]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B?\u0005g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa!+\t\t%#QN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t%\u0005\u0003\u0002BF\u0005#k!A!$\u000b\t\t=\u0015QP\u0001\u0005Y\u0006tw-\u0003\u0003\u0002B\t5\u0015\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00053\u0013y\nE\u0002s\u00057K1A!(t\u0005\r\te.\u001f\u0005\b{N\n\t\u00111\u0001r\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001BS!\u0019\u00119K!+\u0003\u001a6\u0011\u0011qT\u0005\u0005\u0005W\u000byJ\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BY\u0005o\u00032A\u001dBZ\u0013\r\u0011)l\u001d\u0002\b\u0005>|G.Z1o\u0011!iX'!AA\u0002\te\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003E\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013\u000ba!Z9vC2\u001cH\u0003\u0002BY\u0005\u000bD\u0001\" \u001d\u0002\u0002\u0003\u0007!\u0011T\u0001\u0012i\"\u0014x\u000e\u001e;mK\u0012\u001cvnY6fiN\u0004\u0013a\u00077bgR\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007\",7m\u001b+j[\u0016l5/A\u0010mCN$()Y2laJ,7o];sK\u000eCWmY6US6,Wj]0%KF$2!\u001fBh\u0011!iX%!AA\u0002\t%\u0013\u0001\b7bgR\u0014\u0015mY6qe\u0016\u001c8/\u001e:f\u0007\",7m\u001b+j[\u0016l5\u000fI\u0001\u0013\t\u0016d\u0017-_3e\u00072|7/Z*pG.,G\u000fE\u0002\u0003\u0010i\u001aRA\u000fBm\u0005g\u0001\"Ba7\u0003b\nu\"\u0011\nB\u0007\u001b\t\u0011iNC\u0002\u0003`N\fqA];oi&lW-\u0003\u0003\u0003d\nu'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!Q[\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005\u001b\u0011YO!<\t\u000f\teR\b1\u0001\u0003>!9!QI\u001fA\u0002\t%\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005g\u0014y\u0010E\u0003s\u0005k\u0014I0C\u0002\u0003xN\u0014aa\u00149uS>t\u0007c\u0002:\u0003|\nu\"\u0011J\u0005\u0004\u0005{\u001c(A\u0002+va2,'\u0007C\u0005\u0004\u0002y\n\t\u00111\u0001\u0003\u000e\u0005\u0019\u0001\u0010\n\u0019\u0002\u001b\u0005$G\r\u0015:pG\u0016\u001c8o\u001c:t)\u0015I8qAB\t\u0011\u001d\u0019Ia\u0010a\u0001\u0007\u0017\tQB\\3x!J|7-Z:t_J\u001c\bCBAM\u0007\u001b\t9+\u0003\u0003\u0004\u0010\u0005m%A\u0002\"vM\u001a,'\u000fC\u0004\u0004\u0014}\u0002\r!a\f\u0002+A\u0014xnY3tg>\u0014H\u000b\u001b:fC\u0012\u0004&/\u001a4jq\u0006y1\u000f^1siB\u0013xnY3tg>\u00148\u000fF\u0002z\u00073Aqaa\u0005A\u0001\u0004\ty\u0003F\u0003z\u0007;\u0019)\u0003C\u0004\u0002\u0014\u0006\u0003\raa\b\u0011\r\t\u001d6\u0011EAT\u0013\u0011\u0019\u0019#a(\u0003\u0007M+\u0017\u000fC\u0004\u0004\u0014\u0005\u0003\r!a\f\u0002!I,Wn\u001c<f!J|7-Z:t_J\u001cH#B=\u0004,\r=\u0002BBB\u0017\u0005\u0002\u0007\u0011/A\u0006sK6|g/Z\"pk:$\bbBB\u0019\u0005\u0002\u000711G\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\ra6QG\u0005\u0004\u0007o1&A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\u0012!_\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u0007I,h.A\u0007oKb$\bK]8dKN\u001cxN]\u000b\u0003\u0003O\u000bQB]3wKJ\u001cX-\u00118e\u0003\u0012$GcA=\u0004J!911J$A\u0002\r5\u0013A\u0004:fm\u0016\u00148/Z\"iC:tW\r\u001c\t\u0005\u0007\u001f\u001a\u0019&\u0004\u0002\u0004R)\u0019q+a\u0007\n\t\rU3\u0011\u000b\u0002\u000f%\u00164XM]:f\u0007\"\fgN\\3m\u0003Ay\u0007/\u001a8TKJ4XM]*pG.,G\u000f\u0006\u0004\u0002\f\u000em3q\f\u0005\b\u0007;B\u0005\u0019AA\u0018\u0003\u0011Awn\u001d;\t\r\r\u0005\u0004\n1\u0001r\u0003\u0011\u0001xN\u001d;\u0002)\u0005\u001c7-\u001a9u\u001d\u0016<8i\u001c8oK\u000e$\u0018n\u001c8t\u0003\u0019\t7mY3qiR!1\u0011NB6!\u0015\u0011(Q\u001fB\u001f\u0011\u001d\u0019iG\u0013a\u0001\u0007_\n1a[3z!\u0011\t\u0019h!\u001d\n\t\rM\u0014Q\u000f\u0002\r'\u0016dWm\u0019;j_:\\U-_\u0001\u001aG2|7/\u001a+ie>$H\u000f\\3e\u0007>tg.Z2uS>t7/\u0001\rnCf\u0014W-\u00113kkN$H*[:uK:,'/U;pi\u0006\f1#Y:tS\u001etg*Z<D_:tWm\u0019;j_:$\"B!-\u0004~\r\u00055QQBE\u0011\u001d\u0019y(\u0014a\u0001\u0005{\tQb]8dW\u0016$8\t[1o]\u0016d\u0007bBBB\u001b\u0002\u0007\u0011qU\u0001\naJ|7-Z:t_JDqaa\"N\u0001\u0004\u0011\t,\u0001\u0005nCf\u0014En\\2l\u0011\u001d\u0019Y)\u0014a\u0001\u0005\u0013\nab\u001d;beR$\u0016.\\3OC:|7/\u0001\u0012de\u0016\fG/\u001a(fi^|'o\u001b+ie\u0016\fGm]\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN\u001d\u000b\u0003\u0003[\fad\u0019:fCR,\u0007K]8dKN\u001cxN])vKV,7+\u001b>f'\u0016t7o\u001c:\u0002\r]\f7.Z;qQ\r\u00016q\u0013\t\u0005\u0005\u0017\u001bI*\u0003\u0003\u0004\u001c\n5%\u0001C(wKJ\u0014\u0018\u000eZ3\u0002\u0011\u0005\u001b7-\u001a9u_J\u0004\"\u0001\u0018*\u0014\u0007I\u0013)\u0002\u0006\u0002\u0004 \u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIe*\"a!++\t\u0005=\"Q\u000e")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Acceptor$DelayedCloseSocket$ DelayedCloseSocket$module;
    private final EndPoint endPoint;
    private volatile int sendBufferSize;
    private final int recvBufferSize;
    private final int nodeId;
    private final ConnectionQuotas connectionQuotas;
    private final Metrics metrics;
    private final String metricPrefix;
    private final Time time;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;
    private final Meter acceptBatchTimeMeter;
    private final Sensor networkThreadsCapacitySensor;
    private final Sensor processorQueueSizeSensor;
    private int currentProcessorIndex;
    private final PriorityQueue<DelayedCloseSocket> throttledSockets;
    private long lastBackpressureCheckTimeMs;

    public static String $lessinit$greater$default$9() {
        return Acceptor$.MODULE$.$lessinit$greater$default$9();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public Acceptor$DelayedCloseSocket$ DelayedCloseSocket() {
        if (this.DelayedCloseSocket$module == null) {
            this.DelayedCloseSocket$lzycompute$1();
        }
        return this.DelayedCloseSocket$module;
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public void sendBufferSize_$eq(int x$1) {
        this.sendBufferSize = x$1;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    private Meter acceptBatchTimeMeter() {
        return this.acceptBatchTimeMeter;
    }

    private Sensor networkThreadsCapacitySensor() {
        return this.networkThreadsCapacitySensor;
    }

    public Sensor processorQueueSizeSensor() {
        return this.processorQueueSizeSensor;
    }

    private int currentProcessorIndex() {
        return this.currentProcessorIndex;
    }

    private void currentProcessorIndex_$eq(int x$1) {
        this.currentProcessorIndex = x$1;
    }

    public PriorityQueue<DelayedCloseSocket> throttledSockets() {
        return this.throttledSockets;
    }

    private long lastBackpressureCheckTimeMs() {
        return this.lastBackpressureCheckTimeMs;
    }

    private void lastBackpressureCheckTimeMs_$eq(long x$1) {
        this.lastBackpressureCheckTimeMs = x$1;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
            x$21.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$22 -> {
            x$22.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
        this.networkThreadsCapacitySensor().record(100.0 * (double)this.processors().size());
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$23 -> {
                x$23.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$24 -> {
                x$24.awaitShutdown();
                return BoxedUnit.UNIT;
            });
        }
        this.removeMetric(new StringBuilder(22).append(this.metricPrefix).append("AcceptorBlockedPercent").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.removeMetric(new StringBuilder(20).append(this.metricPrefix).append("AcceptBatchTimeNanos").toString(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)this.endPoint().listenerName().value())}))));
        this.metrics.removeSensor(this.networkThreadsCapacitySensor().name());
        this.metrics.removeSensor(this.processorQueueSizeSensor().name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.acceptNewConnections();
                    this.closeThrottledConnections();
                    this.maybeAdjustListenerQuota();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket, selector, and any throttled sockets.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.throttledSockets().foreach((Function1 & Serializable & scala.Serializable)throttledSocket -> {
                this.closeSocket(throttledSocket.socket());
                return BoxedUnit.UNIT;
            });
            this.throttledSockets().clear();
            this.shutdownComplete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Processor nextProcessor() {
        void var1_1;
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() % this.processors().length());
        Processor processor = (Processor)this.processors().apply(this.currentProcessorIndex());
        this.currentProcessorIndex_$eq(this.currentProcessorIndex() + 1);
        return var1_1;
    }

    public void reverseAndAdd(ReverseChannel reverseChannel) {
        this.connectionQuotas.inc(this.endPoint().listenerName(), reverseChannel.channel().socketAddress(), this.blockedPercentMeter());
        this.nextProcessor().reverseAndAdd(reverseChannel);
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = Utils.isBlank((String)host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private void acceptNewConnections() {
        if (this.nioSelector().select(500L) > 0) {
            long startNanos = this.time.nanoseconds();
            java.util.Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
            while (iter.hasNext() && this.isRunning()) {
                try {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (key.isAcceptable()) {
                        this.accept(key).foreach((Function1 & Serializable & scala.Serializable)socketChannel -> {
                            Acceptor.$anonfun$acceptNewConnections$1(this, socketChannel);
                            return BoxedUnit.UNIT;
                        });
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            this.acceptBatchTimeMeter().mark(this.time.nanoseconds() - startNanos);
        }
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
        catch (ConnectionThrottledException e) {
            InetAddress ip = socketChannel.socket().getInetAddress();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Delaying closing of connection from ").append(ip).append(" for ").append(e.throttleTimeMs()).append(" ms").toString());
            long endThrottleTimeMs = e.startThrottleTimeMs() + e.throttleTimeMs();
            this.throttledSockets().$plus$eq((Object)new DelayedCloseSocket(this, socketChannel, endThrottleTimeMs));
            return None$.MODULE$;
        }
    }

    private void closeThrottledConnections() {
        long timeMs = this.time.milliseconds();
        while (this.throttledSockets().headOption().exists((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)Acceptor.$anonfun$closeThrottledConnections$1(timeMs, x$25)))) {
            DelayedCloseSocket closingSocket = (DelayedCloseSocket)this.throttledSockets().dequeue();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Closing socket from ip ").append(closingSocket.socket().getRemoteAddress()).toString());
            this.closeSocket(closingSocket.socket());
        }
    }

    private void maybeAdjustListenerQuota() {
        long timeMs = this.time.milliseconds();
        if (this.lastBackpressureCheckTimeMs() + ConnectionQuotas$.MODULE$.ConnectionBackpressureCheckIntervalMs() < timeMs) {
            this.connectionQuotas.maybeAdjustListenerQuota(this.endPoint().listenerName());
            this.lastBackpressureCheckTimeMs_$eq(timeMs);
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock, long startTimeNanos) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter(), startTimeNanos, this.processorQueueSizeSensor())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createNetworkThreadsCapacitySensor() {
        void var2_2;
        String listenerName = this.endPoint().listenerName().value();
        Sensor networkThreadsCapacitySensor = this.metrics.sensor(new StringBuilder(30).append("TotalNetworkThreadsPercentage-").append(listenerName).toString());
        networkThreadsCapacitySensor.add(ThreadUsageMetrics$.MODULE$.networkThreadPoolCapacityMetricName(this.metrics, listenerName), (MeasurableStat)new Value());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Sensor createProcessorQueueSizeSensor() {
        void var2_2;
        String listenerName = this.endPoint().listenerName().value();
        Sensor processorQueueSizeSensor = this.metrics.sensor(new StringBuilder(19).append("ProcessorQueueSize-").append(listenerName).toString());
        processorQueueSizeSensor.add((CompoundStat)ProcessorQueueSizePercentiles$.MODULE$.createPercentiles(this.metrics, Processor$.MODULE$.ConnectionQueueSize(), this.metricPrefix, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName)})))));
        return var2_2;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    private final void DelayedCloseSocket$lzycompute$1() {
        synchronized (this) {
            if (this.DelayedCloseSocket$module == null) {
                this.DelayedCloseSocket$module = new Acceptor$DelayedCloseSocket$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.nodeId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$acceptNewConnections$1(Acceptor $this, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        long connectionAcceptTimeNanos = $this.time.nanoseconds();
        while (!$this.assignNewConnection(socketChannel, processor = $this.nextProcessor(), --retriesLeft == 0, connectionAcceptTimeNanos)) {
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeThrottledConnections$1(long timeMs$1, DelayedCloseSocket x$25) {
        return x$25.endThrottleTimeMs() < timeMs$1;
    }

    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int nodeId, ConnectionQuotas connectionQuotas, Metrics metrics, String metricPrefix, Time time, String logPrefix) {
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.nodeId = nodeId;
        this.connectionQuotas = connectionQuotas;
        this.metrics = metrics;
        this.metricPrefix = metricPrefix;
        this.time = time;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.acceptBatchTimeMeter = this.newMeter(new StringBuilder(20).append(metricPrefix).append("AcceptBatchTimeNanos").toString(), "processing and blocked time for a batch of new connections", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)endPoint.listenerName().value())}))));
        this.networkThreadsCapacitySensor = this.createNetworkThreadsCapacitySensor();
        this.processorQueueSizeSensor = this.createProcessorQueueSizeSensor();
        this.currentProcessorIndex = 0;
        this.throttledSockets = new PriorityQueue(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        this.lastBackpressureCheckTimeMs = time.milliseconds();
    }

    public class DelayedCloseSocket
    implements Ordered<DelayedCloseSocket>,
    Product,
    scala.Serializable {
        private final SocketChannel socket;
        private final long endThrottleTimeMs;
        public final /* synthetic */ Acceptor $outer;

        public boolean $less(Object that) {
            return Ordered.$less$((Ordered)this, (Object)that);
        }

        public boolean $greater(Object that) {
            return Ordered.$greater$((Ordered)this, (Object)that);
        }

        public boolean $less$eq(Object that) {
            return Ordered.$less$eq$((Ordered)this, (Object)that);
        }

        public boolean $greater$eq(Object that) {
            return Ordered.$greater$eq$((Ordered)this, (Object)that);
        }

        public int compareTo(Object that) {
            return Ordered.compareTo$((Ordered)this, (Object)that);
        }

        public SocketChannel socket() {
            return this.socket;
        }

        public long endThrottleTimeMs() {
            return this.endThrottleTimeMs;
        }

        public int compare(DelayedCloseSocket that) {
            return new RichLong(Predef$.MODULE$.longWrapper(this.endThrottleTimeMs())).compare((Object)BoxesRunTime.boxToLong((long)that.endThrottleTimeMs()));
        }

        public DelayedCloseSocket copy(SocketChannel socket, long endThrottleTimeMs) {
            return new DelayedCloseSocket(this.kafka$network$Acceptor$DelayedCloseSocket$$$outer(), socket, endThrottleTimeMs);
        }

        public SocketChannel copy$default$1() {
            return this.socket();
        }

        public long copy$default$2() {
            return this.endThrottleTimeMs();
        }

        public String productPrefix() {
            return "DelayedCloseSocket";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.socket();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.endThrottleTimeMs());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof DelayedCloseSocket;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.socket())), (int)Statics.longHash((long)this.endThrottleTimeMs())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof DelayedCloseSocket)) return false;
            if (((DelayedCloseSocket)x$1).kafka$network$Acceptor$DelayedCloseSocket$$$outer() != this.kafka$network$Acceptor$DelayedCloseSocket$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            DelayedCloseSocket delayedCloseSocket = (DelayedCloseSocket)x$1;
            SocketChannel socketChannel = this.socket();
            SocketChannel socketChannel2 = delayedCloseSocket.socket();
            if (socketChannel == null) {
                if (socketChannel2 != null) {
                    return false;
                }
            } else if (!socketChannel.equals(socketChannel2)) return false;
            if (this.endThrottleTimeMs() != delayedCloseSocket.endThrottleTimeMs()) return false;
            if (!delayedCloseSocket.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Acceptor kafka$network$Acceptor$DelayedCloseSocket$$$outer() {
            return this.$outer;
        }

        public DelayedCloseSocket(Acceptor $outer, SocketChannel socket, long endThrottleTimeMs) {
            this.socket = socket;
            this.endThrottleTimeMs = endThrottleTimeMs;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Ordered.$init$((Ordered)this);
            Product.$init$((Product)this);
        }
    }
}

