/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A\u0001C\u0005\u0001\u001d!Aq\u0004\u0001BC\u0002\u0013%\u0001\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\"\u0011!)\u0003A!b\u0001\n#1\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000bY\u0002A\u0011A\u001c\t\u000bm\u0002A\u0011\u0001\u001f\t\u000bQ\u0003A\u0011B+\u0003'\t\u0013xn[3s\u0007>tg-[4IC:$G.\u001a:\u000b\u0005)Y\u0011AB:feZ,'OC\u0001\r\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\b\u00163A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003%I!\u0001G\u0005\u0003\u001b\r{gNZ5h\u0011\u0006tG\r\\3s!\tQR$D\u0001\u001c\u0015\ta2\"A\u0003vi&d7/\u0003\u0002\u001f7\t9Aj\\4hS:<\u0017\u0001\u00042s_.,'oQ8oM&<W#A\u0011\u0011\u0005Y\u0011\u0013BA\u0012\n\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001b\t\u0014xn[3s\u0007>tg-[4!\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\tq\u0005\u0005\u0002)e9\u0011\u0011\u0006\r\b\u0003U=r!a\u000b\u0018\u000e\u00031R!!L\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011B\u0001\u0006\f\u0013\t\t\u0014\"\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u00024i\ti\u0011+^8uC6\u000bg.Y4feNT!!M\u0005\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA\u00051A(\u001b8jiz\"2\u0001O\u001d;!\t1\u0002\u0001C\u0003 \u000b\u0001\u0007\u0011\u0005C\u0003&\u000b\u0001\u0007q%\u0001\u000bqe>\u001cWm]:D_:4\u0017nZ\"iC:<Wm\u001d\u000b\u0004{\u0001S\u0005C\u0001\t?\u0013\ty\u0014C\u0001\u0003V]&$\b\"B!\u0007\u0001\u0004\u0011\u0015\u0001\u00032s_.,'/\u00133\u0011\u0005\r;eB\u0001#F!\tY\u0013#\u0003\u0002G#\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1\u0015\u0003C\u0003L\r\u0001\u0007A*\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\tU$\u0018\u000e\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0006Qe>\u0004XM\u001d;jKN\fq#\u001e9eCR,'+\u001a9mS\u000e\fG/[8o\u0007>tg-[4\u0015\u0003u\u0002")
public class BrokerConfigHandler
implements ConfigHandler,
Logging {
    private final KafkaConfig brokerConfig;
    private final QuotaFactory.QuotaManagers quotaManagers;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    @Override
    public void processConfigChanges(String brokerId, Properties properties) {
        String string = brokerId;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.brokerConfig().dynamicConfig().updateDefaultConfig(properties);
            this.updateReplicationConfig();
            return;
        }
        if (this.brokerConfig().brokerId() == new StringOps(Predef$.MODULE$.augmentString(brokerId.trim())).toInt()) {
            this.brokerConfig().dynamicConfig().updateBrokerConfig(this.brokerConfig().brokerId(), properties);
            this.updateReplicationConfig();
        }
    }

    private void updateReplicationConfig() {
        if (DiskUsageBasedThrottler$.MODULE$.diskThrottlingActive(this.quotaManagers().follower())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Broker is currently running low on disk and ").append(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp()).append(" ").append("is set to ").append(this.quotaManagers().follower().lastSignalledQuotaOptRef().get().get()).append(" Bytes/s. Can't override follower replication throttle!").toString());
        } else {
            this.quotaManagers().follower().updateQuota(Quota.upperBound((double)this.getOrDefaultRate$1(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), this.quotaManagers().follower().config())));
            this.setBrokerReplicationThrottledReplicas$1(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotaManagers().follower());
        }
        this.quotaManagers().leader().updateQuota(Quota.upperBound((double)this.getOrDefaultRate$1(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), this.quotaManagers().leader().config())));
        this.quotaManagers().alterLogDirs().updateQuota(Quota.upperBound((double)this.getOrDefaultRate$1(DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), this.quotaManagers().alterLogDirs().config())));
        this.setBrokerReplicationThrottledReplicas$1(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotaManagers().leader());
    }

    private final Option getProp$1(String prop) {
        Some some;
        Option option = this.brokerConfig().dynamicConfig().currentDynamicBrokerConfigs().get((Object)prop);
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            some = new Some((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            some = this.brokerConfig().dynamicConfig().currentDynamicDefaultConfigs().get((Object)prop);
        } else {
            throw new MatchError((Object)option);
        }
        return some;
    }

    private final long getOrDefaultRate$1(String prop, ReplicationQuotaManagerConfig config) {
        long l;
        Option option = this.getProp$1(prop);
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            l = new StringOps(Predef$.MODULE$.augmentString(value)).toLong();
        } else if (None$.MODULE$.equals(option)) {
            l = config.quotaBytesPerSecond();
        } else {
            throw new MatchError((Object)option);
        }
        return l;
    }

    private final void setBrokerReplicationThrottledReplicas$1(String config, ReplicationQuotaManager quotaManager) {
        Option throttledReplicasOpt = this.getProp$1(config);
        if (throttledReplicasOpt instanceof Some) {
            String throttledReplicas = (String)((Some)throttledReplicasOpt).value();
            ReplicationQuotaManagerConfig$.MODULE$.throttledReplicasValidator().ensureValid(config, (Object)throttledReplicas);
            if (ReplicationQuotaManagerConfig$.MODULE$.allReplicasThrottled(throttledReplicas)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Setting ").append(config).append("=").append(throttledReplicas).append(" for all replicas on broker ").append(this.brokerConfig().brokerId()).toString());
                quotaManager.markBrokerThrottled();
                return;
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Setting ").append(config).append("=").append(throttledReplicas).append(" from broker ").append(this.brokerConfig().brokerId()).toString());
            quotaManager.removeBrokerThrottle(false);
            return;
        }
        if (None$.MODULE$.equals(throttledReplicasOpt)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Removing ").append(config).append(" from broker ").append(this.brokerConfig().brokerId()).toString());
            quotaManager.removeBrokerThrottle(true);
            return;
        }
        throw new MatchError((Object)throttledReplicasOpt);
    }

    public BrokerConfigHandler(KafkaConfig brokerConfig, QuotaFactory.QuotaManagers quotaManagers) {
        this.brokerConfig = brokerConfig;
        this.quotaManagers = quotaManagers;
        Logging.$init$(this);
    }
}

