/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.AlterIsrResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0002\r\u001a\u0001yA\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003>\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\fC\u0003`\u0001\u0011\u0005\u0001\r\u0003\u0005h\u0001\t\u0007I\u0011A\ri\u0011\u0019A\b\u0001)A\u0005S\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0004\u0001\u0001\u0006Ia\u001f\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t\u0019\u0002\u0001C!\u0003\u0017Aq!!\u0006\u0001\t\u0003\n9\u0002\u0003\u0005\u0002$\u0001!\t!GA\u0006\u0011!\t)\u0003\u0001C\u00013\u0005-\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\tI\u0006\u0001C\u0001\u00037\u0012a\u0003R3gCVdG/\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u00035m\taa]3sm\u0016\u0014(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001M)\u0001aH\u0013*_A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0014\u000e\u0003eI!\u0001K\r\u0003\u001f\u0005cG/\u001a:JgJl\u0015M\\1hKJ\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#a\u0002'pO\u001eLgn\u001a\t\u0003aMj\u0011!\r\u0006\u0003em\tq!\\3ue&\u001c7/\u0003\u00025c\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u00021\r|g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/F\u00018!\t1\u0003(\u0003\u0002:3\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003e\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#A\u001f\u0011\u0005)r\u0014BA ,\u0005%\u00196\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nA\u0001^5nKV\t1\t\u0005\u0002E\u001b6\tQI\u0003\u0002-\r*\u0011q\tS\u0001\u0007G>lWn\u001c8\u000b\u0005qI%B\u0001&L\u0003\u0019\t\u0007/Y2iK*\tA*A\u0002pe\u001eL!AT#\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\tEJ|7.\u001a:JIV\t!\u000b\u0005\u0002!'&\u0011A+\t\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s+\u0005A\u0006c\u0001\u0011Z7&\u0011!,\t\u0002\n\rVt7\r^5p]B\u0002\"\u0001\t/\n\u0005u\u000b#\u0001\u0002'p]\u001e\fAC\u0019:pW\u0016\u0014X\t]8dQN+\b\u000f\u001d7jKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004bE\u000e$WM\u001a\t\u0003M\u0001AQ!N\u0006A\u0002]BQaO\u0006A\u0002uBQ!Q\u0006A\u0002\rCQ\u0001U\u0006A\u0002ICQAV\u0006A\u0002a\u000b\u0001#\u001e8tK:$\u0018j\u001d:Va\u0012\fG/Z:\u0016\u0003%\u0004BA[8rk6\t1N\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]6\u0003\u00075\u000b\u0007\u000f\u0005\u0002sg6\ta)\u0003\u0002u\r\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001\u0014w\u0013\t9\u0018D\u0001\u0007BYR,'/S:s\u0013R,W.A\tv]N,g\u000e^%teV\u0003H-\u0019;fg\u0002\nq\"\u001b8gY&<\u0007\u000e\u001e*fcV,7\u000f^\u000b\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\r\u0005$x.\\5d\u0015\r\t\ta[\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0003{\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0001#\u001b8gY&<\u0007\u000e\u001e*fcV,7\u000f\u001e\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u00055\u0001c\u0001\u0011\u0002\u0010%\u0019\u0011\u0011C\u0011\u0003\tUs\u0017\u000e^\u0001\tg\",H\u000fZ8x]\u000611/\u001e2nSR$B!!\u0007\u0002 A\u0019\u0001%a\u0007\n\u0007\u0005u\u0011EA\u0004C_>dW-\u00198\t\r\u0005\u0005\"\u00031\u0001v\u00031\tG\u000e^3s\u0013N\u0014\u0018\n^3n\u0003ai\u0017-\u001f2f!J|\u0007/Y4bi\u0016L5O]\"iC:<Wm]\u0001\u0015G2,\u0017M]%o\r2Lw\r\u001b;SKF,Xm\u001d;\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005\u0003\u001b\tY\u0003C\u0004\u0002.U\u0001\r!a\f\u0002+%tg\r\\5hQR\fE\u000e^3s\u0013N\u0014\u0018\n^3ngB)\u0011\u0011GA!k:!\u00111GA\u001f\u001d\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d;\u00051AH]8pizJ\u0011AI\u0005\u0004\u0003\u007f\t\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\n)EA\u0002TKFT1!a\u0010\"\u00031\u0011W/\u001b7e%\u0016\fX/Z:u)\u0011\tY%a\u0016\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015G\u0003\u001diWm]:bO\u0016LA!!\u0016\u0002P\t\u0019\u0012\t\u001c;fe&\u001b(OU3rk\u0016\u001cH\u000fR1uC\"9\u0011Q\u0006\fA\u0002\u0005=\u0012A\u00065b]\u0012dW-\u00117uKJL5O\u001d*fgB|gn]3\u0015\u0011\u0005u\u0013\u0011NA=\u0003{\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003G2\u0015\u0001\u00039s_R|7m\u001c7\n\t\u0005\u001d\u0014\u0011\r\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005-t\u00031\u0001\u0002n\u0005\u0001\u0012\r\u001c;fe&\u001b(OU3ta>t7/\u001a\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111\u000f$\u0002\u0011I,\u0017/^3tiNLA!a\u001e\u0002r\t\u0001\u0012\t\u001c;fe&\u001b(OU3ta>t7/\u001a\u0005\u0007\u0003w:\u0002\u0019A.\u0002\u001fM,g\u000e\u001e\"s_.,'/\u00129pG\"Dq!!\f\u0018\u0001\u0004\ty\u0003")
public class DefaultAlterIsrManager
implements AlterIsrManager,
KafkaMetricsGroup {
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public java.util.Map<TopicPartition, AlterIsrItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean submit(AlterIsrItem alterIsrItem) {
        void var2_2;
        boolean enqueued = this.unsentIsrUpdates().putIfAbsent(alterIsrItem.topicPartition(), alterIsrItem) == null;
        this.maybePropagateIsrChanges();
        return (boolean)var2_2;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterIsrItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterIsrItems.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterIsrItem[]{item})));
            this.sendRequest((Seq<AlterIsrItem>)inflightAlterIsrItems.toSeq());
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to clear AlterIsr in-flight flag when no apparent request is in-flight");
        }
    }

    private void sendRequest(Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterIsrRequestData message = this.buildRequest(inflightAlterIsrItems);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending AlterIsr to controller ").append(message).toString());
        this.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)new AlterIsrRequest.Builder(message), new ControllerRequestCompletionHandler(this, message, inflightAlterIsrItems){
            private final /* synthetic */ DefaultAlterIsrManager $outer;
            private final AlterIsrRequestData message$1;
            private final Seq inflightAlterIsrItems$2;

            public void onComplete(ClientResponse response) {
                Errors errors;
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Received AlterIsr response ").append(response).toString());
                try {
                    if (response.authenticationException() != null) {
                        errors = Errors.NETWORK_EXCEPTION;
                    } else if (response.versionMismatch() != null) {
                        errors = Errors.UNSUPPORTED_VERSION;
                    } else {
                        AlterIsrResponse body = (AlterIsrResponse)response.responseBody();
                        errors = this.$outer.handleAlterIsrResponse(body, this.message$1.brokerEpoch(), (Seq<AlterIsrItem>)this.inflightAlterIsrItems$2);
                    }
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors error = errors;
                if (Errors.NONE.equals(error)) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().schedule("send-alter-isr", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.maybePropagateIsrChanges(), 50L, -1L, TimeUnit.MILLISECONDS);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterIsr to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$1 = message$1;
                this.inflightAlterIsrItems$2 = inflightAlterIsrItems$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse ), $anonfun$onComplete$2(kafka.server.DefaultAlterIsrManager$$anon$1 )}, serializedLambda);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private AlterIsrRequestData buildRequest(Seq<AlterIsrItem> inflightAlterIsrItems) {
        void var2_2;
        AlterIsrRequestData message = new AlterIsrRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(this.brokerEpochSupplier().apply$mcJ$sp()).setTopics(new ArrayList());
        inflightAlterIsrItems.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicPartition().topic()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            DefaultAlterIsrManager.$anonfun$buildRequest$2(message, entry);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Errors handleAlterIsrResponse(AlterIsrResponse alterIsrResponse, long sentBrokerEpoch, Seq<AlterIsrItem> inflightAlterIsrItems) {
        AlterIsrResponseData data = alterIsrResponse.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broker had a stale broker epoch (").append(sentBrokerEpoch).append("), retrying.").toString());
        } else if (Errors.CLUSTER_AUTHORIZATION_FAILED.equals(errors)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker is not authorized to send AlterIsr to controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterIsr to controller"));
        } else if (Errors.NONE.equals(errors)) {
            HashMap partitionResponses = HashMap$.MODULE$.empty();
            data.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                partitionResponses.update((Object)tp, partition);
            }));
            inflightAlterIsrItems.foreach((Function1 & Serializable & scala.Serializable)inflightAlterIsr -> {
                DefaultAlterIsrManager.$anonfun$handleAlterIsrResponse$6(this, partitionResponses, inflightAlterIsr);
                return BoxedUnit.UNIT;
            });
        } else if (errors != null) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Controller returned an unexpected top-level error when handling AlterIsr request: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        return Errors.forCode((short)data.errorCode());
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(AlterIsrRequestData.TopicData topicPart$1, AlterIsrItem item) {
        AlterIsrRequestData.PartitionData alterIsrPartitionData = new AlterIsrRequestData.PartitionData().setPartitionIndex(item.topicPartition().partition()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)item.leaderAndIsr().isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setCurrentIsrVersion(item.leaderAndIsr().zkVersion()).setIsUnclean(item.leaderAndIsr().isUnclean());
        item.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable & scala.Serializable)linkState -> alterIsrPartitionData.setClusterLinkState(new AlterIsrRequestData.ClusterLinkState().setLinkedLeaderEpoch(linkState.linkedLeaderEpoch()).setLinkFailed(linkState.linkFailed())));
        return topicPart$1.partitions().add(alterIsrPartitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(AlterIsrRequestData message$2, Tuple2 entry) {
        AlterIsrRequestData.TopicData topicPart = new AlterIsrRequestData.TopicData().setName((String)entry._1()).setPartitions(new ArrayList());
        message$2.topics().add(topicPart);
        ((IterableLike)entry._2()).foreach((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)DefaultAlterIsrManager.$anonfun$buildRequest$3(topicPart, item)));
    }

    public static final /* synthetic */ void $anonfun$handleAlterIsrResponse$6(DefaultAlterIsrManager $this, HashMap partitionResponses$1, AlterIsrItem inflightAlterIsr) {
        Option option = partitionResponses$1.get((Object)inflightAlterIsr.topicPartition());
        if (option instanceof Some) {
            AlterIsrResponseData.PartitionData response = (AlterIsrResponseData.PartitionData)((Some)option).value();
            $this.unsentIsrUpdates().remove(inflightAlterIsr.topicPartition());
            Errors error = Errors.forCode((short)response.errorCode());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Controller response returned for AlterIsr request for ").append(inflightAlterIsr.topicPartition()).append(": ").append(response).toString());
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            Left callbackResponse = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? package$.MODULE$.Right().apply((Object)new LeaderAndIsr(response.leaderId(), response.leaderEpoch(), (List<Object>)((List)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.isr()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$2)), List$.MODULE$.canBuildFrom())), response.currentIsrVersion(), inflightAlterIsr.leaderAndIsr().isUnclean(), inflightAlterIsr.leaderAndIsr().clusterLinkState())) : package$.MODULE$.Left().apply((Object)error);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)inflightAlterIsr.callback().apply((Object)callbackResponse);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Partition ").append(inflightAlterIsr.topicPartition()).append(" was sent but not included in the response").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public DefaultAlterIsrManager(BrokerToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        AlterIsrManager.$init$(this);
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.unsentIsrUpdates = new ConcurrentHashMap<TopicPartition, AlterIsrItem>();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

