/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractLogReadResult;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLag$;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchTxnCommitted$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.replica.ClientMetadata;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\b\u0011\u0001UA\u0011B\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0011\t\u0011\t\u0002!\u0011!Q\u0001\n\rB\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!Aa\u0006\u0001B\u0001B\u0003%q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000b\u0011\u0004A\u0011A3\t\u000b=\u0004A\u0011\u00029\t\u000by\u0004A\u0011I@\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\r\u0001\u0011\u0005\u0013\u0011\u0002\u0002\r\t\u0016d\u0017-_3e\r\u0016$8\r\u001b\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0003/ai\u0011\u0001E\u0005\u00033A\u0011\u0001\u0003R3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u000f\u0011,G.Y=NgB\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t!Aj\u001c8h\u0013\tQ\u0002$A\u0007gKR\u001c\u0007.T3uC\u0012\fG/\u0019\t\u0003/\u0011J!!\n\t\u0003\u001b\u0019+Go\u00195NKR\fG-\u0019;b\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"a\u0006\u0015\n\u0005%\u0002\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0006cV|G/\u0019\t\u0003/1J!!\f\t\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u0002\u0019QLWM\u001d$fi\u000eDw\n\u001d;\u0011\u0007q\u0001$'\u0003\u00022;\t1q\n\u001d;j_:\u0004\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u000f\u0019,Go\u00195fe*\u0011qGE\u0001\u0005i&,'/\u0003\u0002:i\ta\u0001+\u001a8eS:<g)\u001a;dQ\u0006q1\r\\5f]RlU\r^1eCR\f\u0007c\u0001\u000f1yA\u0011QhR\u0007\u0002})\u0011q\bQ\u0001\be\u0016\u0004H.[2b\u0015\t\t%)\u0001\u0004d_6lwN\u001c\u0006\u0003'\rS!\u0001R#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0015aA8sO&\u0011\u0001J\u0010\u0002\u000f\u00072LWM\u001c;NKR\fG-\u0019;b\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0005\u0002\u0018\u0017&\u0011A\n\u0005\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biN\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\tqy\u0015+Y\u0005\u0003!v\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007I+v+D\u0001T\u0015\t!V$\u0001\u0006d_2dWm\u0019;j_:L!AV*\u0003\u0007M+\u0017\u000f\u0005\u0003\u001d1js\u0016BA-\u001e\u0005\u0019!V\u000f\u001d7feA\u00111\fX\u0007\u0002\u0001&\u0011Q\f\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t9r,\u0003\u0002a!\t\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\ta\"-\u0003\u0002d;\t!QK\\5u\u0003\u0019a\u0014N\\5u}QIam\u001a5jU.dWN\u001c\t\u0003/\u0001AQAG\u0005A\u0002mAQAI\u0005A\u0002\rBQAJ\u0005A\u0002\u001dBQAK\u0005A\u0002-BQAL\u0005A\u0002=BQAO\u0005A\u0002mBQ!S\u0005A\u0002)CQ!T\u0005A\u00029\u000b1CZ3uG\"|eMZ:fi6+G/\u00193bi\u0006$2!\u001d;}!\t9\"/\u0003\u0002t!\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u000bUT\u0001\u0019\u0001<\u0002\u0013A\f'\u000f^5uS>t\u0007CA<{\u001b\u0005A(BA=\u0013\u0003\u001d\u0019G.^:uKJL!a\u001f=\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B?\u000b\u0001\u0004Y\u0012a\u00034fi\u000eDwJ\u001a4tKR\f1\u0002\u001e:z\u0007>l\u0007\u000f\\3uKR\u0011\u0011\u0011\u0001\t\u00049\u0005\r\u0011bAA\u0003;\t9!i\\8mK\u0006t\u0017\u0001D8o\u000bb\u0004\u0018N]1uS>tG#A1\u0002+\r|G\u000e\\3di2{wMU3bIJ+7/\u001e7ugR\u0011\u0011q\u0002\t\u0005%V\u000b\t\u0002E\u0003\u001d1j\u000b\u0019\u0002E\u0002\u0018\u0003+I1!a\u0006\u0011\u0005U\t%m\u001d;sC\u000e$Hj\\4SK\u0006$'+Z:vYR\f!b\u001c8D_6\u0004H.\u001a;f\u0001")
public class DelayedFetch
extends DelayedOperation {
    private final FetchMetadata fetchMetadata;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Option<PendingFetch> tierFetchOpt;
    private final Option<ClientMetadata> clientMetadata;
    private final BrokerTopicStats brokerTopicStats;
    private final Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    private LogOffsetMetadata fetchOffsetMetadata(Partition partition, long fetchOffset) {
        return (LogOffsetMetadata)this.fetchMetadata.fetchOffsetMetadataMap().getOrElseUpdate((Object)partition.topicPartition(), (Function0 & Serializable & scala.Serializable)() -> (LogOffsetMetadata)partition.convertToLocalOffsetMetadata(fetchOffset).getOrElse((Function0 & Serializable & scala.Serializable)() -> LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata()));
    }

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            boolean fetchPartitionPruningEnabled = this.fetchMetadata.fetchPartitionPruningEnabled();
            IntRef accumulatedSize = IntRef.create((int)0);
            boolean ongoingTierFetch = this.tierFetchOpt.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedFetch.$anonfun$tryComplete$1(x$1)));
            this.fetchMetadata.fetchInfos().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$2(this, fetchPartitionPruningEnabled, ongoingTierFetch, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (this.tierFetchOpt.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isComplete()))) {
                return this.forceComplete();
            }
            if (accumulatedSize.elem < this.fetchMetadata.fetchMinBytes() || !this.tierFetchOpt.isEmpty()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        this.tierFetchOpt.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.markFetchExpired();
            return BoxedUnit.UNIT;
        });
        if (this.fetchMetadata.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    private Seq<Tuple2<TopicPartition, AbstractLogReadResult>> collectLogReadResults() {
        int x$1 = this.fetchMetadata.replicaId();
        boolean x$2 = this.fetchMetadata.fetchOnlyLeader();
        FetchIsolation x$3 = this.fetchMetadata.fetchIsolation();
        int x$4 = this.fetchMetadata.fetchMaxBytes();
        boolean x$5 = this.fetchMetadata.hardMaxBytesLimit();
        Seq<Tuple2<TopicPartition, PartitionFetchMetadata>> x$6 = this.fetchMetadata.fetchInfos();
        Option<ClientMetadata> x$7 = this.clientMetadata;
        ReplicaQuota x$8 = this.quota;
        return this.replicaManager.readFromLocalLog(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
    }

    @Override
    public void onComplete() {
        Option tierFetcherReadResults = this.tierFetchOpt.map((Function1 & Serializable & scala.Serializable)x$4 -> (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$4.finish()).asScala());
        Seq fetchPartitionData = (Seq)this.collectLogReadResults().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogReadResult logReadResult;
            if (x0$1 == null) throw new MatchError(null);
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLogReadResult logReadResult2 = (AbstractLogReadResult)x0$1._2();
            if (logReadResult2 instanceof TierLogReadResult) {
                TierFetchResult tierFetchResult;
                TierLogReadResult tierLogReadResult = (TierLogReadResult)logReadResult2;
                logReadResult = tierLogReadResult.intoLogReadResult(tierFetchResult, !(tierFetchResult = (TierFetchResult)tierFetcherReadResults.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get((Object)tp)).getOrElse((Function0 & Serializable & scala.Serializable)() -> TierFetchResult.emptyFetchResult())).isEmpty());
            } else {
                if (!(logReadResult2 instanceof LogReadResult)) throw new MatchError((Object)logReadResult2);
                logReadResult = (LogReadResult)logReadResult2;
            }
            FetchLag$.MODULE$.maybeRecordConsumerFetchTimeLag(!$this.fetchMetadata.isFromFollower(), logReadResult, $this.brokerTopicStats);
            boolean isReassignmentFetch = $this.fetchMetadata.isFromFollower() && $this.replicaManager.isAddingReplica(tp, $this.fetchMetadata.replicaId());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)logReadResult.toFetchPartitionData(isReassignmentFetch));
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$1(PendingFetch x$1) {
        return !x$1.isComplete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$tryComplete$2(DelayedFetch $this, boolean fetchPartitionPruningEnabled$1, boolean ongoingTierFetch$1, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchMetadata fetchInfo = (PartitionFetchMetadata)x0$1._2();
            if (!fetchPartitionPruningEnabled$1 || !fetchInfo.isCaughtUp()) {
                Optional<Integer> fetchLeaderEpoch = fetchInfo.currentLeaderEpoch();
                try {
                    LogOffsetMetadata logOffsetMetadata;
                    LogOffsetMetadata fetchOffset;
                    Partition partition = $this.replicaManager.getPartitionOrException(topicPartition);
                    LogOffsetMetadata logOffsetMetadata2 = fetchOffset = $this.fetchOffsetMetadata(partition, fetchInfo.fetchOffset());
                    LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                    if (logOffsetMetadata2 == null) {
                        if (logOffsetMetadata3 == null) return;
                    } else if (((Object)logOffsetMetadata2).equals(logOffsetMetadata3)) return;
                    if (ongoingTierFetch$1) return;
                    LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.fetchMetadata.fetchOnlyLeader());
                    FetchIsolation fetchIsolation = $this.fetchMetadata.fetchIsolation();
                    if (FetchLogEnd$.MODULE$.equals(fetchIsolation)) {
                        logOffsetMetadata = offsetSnapshot.logEndOffset();
                    } else if (FetchHighWatermark$.MODULE$.equals(fetchIsolation)) {
                        logOffsetMetadata = offsetSnapshot.highWatermark();
                    } else {
                        if (!FetchTxnCommitted$.MODULE$.equals(fetchIsolation)) throw new MatchError((Object)fetchIsolation);
                        logOffsetMetadata = offsetSnapshot.lastStableOffset();
                    }
                    if (logOffsetMetadata.messageOffset() != fetchOffset.messageOffset()) {
                        if (logOffsetMetadata.onOlderSegment(fetchOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this.fetchMetadata).append(" since it is fetching later segments of partition ").append(topicPartition).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                        if (fetchOffset.onOlderSegment(logOffsetMetadata)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Satisfying fetch ").append($this.fetchMetadata).append(" immediately since it is fetching older segments.").toString());
                            if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.fetchMetadata.replicaId())) {
                                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                            }
                        } else if (fetchOffset.messageOffset() < logOffsetMetadata.messageOffset()) {
                            int bytesAvailable = package$.MODULE$.min(logOffsetMetadata.positionDiff(fetchOffset), fetchInfo.maxBytes());
                            if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.fetchMetadata.replicaId())) {
                                accumulatedSize$1.elem += bytesAvailable;
                            }
                        }
                    }
                    fetchInfo.lastFetchedEpoch().ifPresent(fetchEpoch -> {
                        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                        if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Could not obtain last offset for leader epoch for partition ").append(topicPartition).append(", epochEndOffset=").append(epochEndOffset).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                        if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchInfo.fetchOffset()) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Satisfying fetch ").append($this.fetchMetadata).append(" since it has diverging epoch requiring truncation for partition ").append(topicPartition).append(" epochEndOffset=").append(epochEndOffset).append(" fetchEpoch=").append(fetchEpoch).append(" fetchOffset=").append(fetchInfo.fetchOffset()).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                        }
                    });
                    return;
                }
                catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Broker is no longer the leader or follower of ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicPartition).append(", satisfy ").append($this.fetchMetadata).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                catch (KafkaStorageException kafkaStorageException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicPartition).append(" is in an offline log directory, satisfy ").append($this.fetchMetadata).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                catch (FencedLeaderEpochException fencedLeaderEpochException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this.fetchMetadata).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
            }
        }
        if (x0$1 == null) return;
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        PartitionFetchMetadata fetchInfo = (PartitionFetchMetadata)x0$1._2();
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Ignored caught-up partition ").append(topicPartition).append(" with ").append(fetchInfo).append(" for replica ").append($this.fetchMetadata.replicaId()).append(".").toString());
    }

    public DelayedFetch(long delayMs, FetchMetadata fetchMetadata, ReplicaManager replicaManager, ReplicaQuota quota, Option<PendingFetch> tierFetchOpt, Option<ClientMetadata> clientMetadata, BrokerTopicStats brokerTopicStats, Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.fetchMetadata = fetchMetadata;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.tierFetchOpt = tierFetchOpt;
        this.clientMetadata = clientMetadata;
        this.brokerTopicStats = brokerTopicStats;
        this.responseCallback = responseCallback;
        super(delayMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

