/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.QuotaType;
import kafka.server.QuotaType$ClusterLinkReplication$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$Produce$;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mea\u0002\u0014(!\u0003\r\t\u0001\f\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\t\u00021\t\"\u0012\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003F\u0011\u001dy\u0005\u00011A\u0005\nACQa\u0015\u0001\u0007\u0012QCq!\u0019\u0001C\u0002\u0013%!\rC\u0003p\u0001\u0011E\u0001\u000fC\u0004\u0000\u0001\u0001\u0007I\u0011\u00029\t\u0013\u0005\r\u0001\u00011A\u0005\n\u0005\u0015\u0001BCA\u0005\u0001\u0001\u0007I\u0011A\u0014\u0002\f!Q\u0011Q\u0003\u0001A\u0002\u0013\u0005q%a\u0006\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005-\u0001\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0011)\t)\u0003\u0001a\u0001\n\u00039\u00131\u0002\u0005\u000b\u0003S\u0001\u0001\u0019!C\u0001O\u0005-\u0002\"CA\u0018\u0001\t\u0007I\u0011AA\u0019\u0011\u0019\tI\u0004\u0001C\u0001\u0001\"1\u00111\b\u0001\u0005\u0002\u0001Cq!!\u0010\u0001\t\u0003\ty\u0004\u0003\u0005\u0002F\u0001!\tbJA$\u0011!\t\u0019\u0006\u0001C\tO\u0005-\u0001\u0002CA+\u0001\u0011Eq%a\u0003\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!1\u0011q\f\u0001\u0005\n\u0001Cq!!\u0019\u0001\t\u0013\t\u0019\u0007C\u0004\u0002f\u0001!\tb\n!\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011Q\u000f\u0001\u0005\u0012\u001d*uaBA<O!\u0005\u0011\u0011\u0010\u0004\u0007M\u001dB\t!a\u001f\t\u000f\u0005ud\u0004\"\u0001\u0002\u0000!I\u0011\u0011\u0011\u0010C\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003#s\u0002\u0015!\u0003\u0002\u0006\"I\u00111\u0013\u0010C\u0002\u0013\u0005\u00111\u0011\u0005\t\u0003+s\u0002\u0015!\u0003\u0002\u0006\"I\u0011q\u0013\u0010C\u0002\u0013\u0005\u00111\u0011\u0005\t\u00033s\u0002\u0015!\u0003\u0002\u0006\n9B)[:l+N\fw-\u001a\"bg\u0016$G\u000b\u001b:piRdWM\u001d\u0006\u0003Q%\naa]3sm\u0016\u0014(\"\u0001\u0016\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!L\u001a:!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011AgN\u0007\u0002k)\u0011a'K\u0001\b[\u0016$(/[2t\u0013\tATGA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u0015\u0002\u000bU$\u0018\u000e\\:\n\u0005yZ$a\u0002'pO\u001eLgnZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u0005\u0003\"A\f\"\n\u0005\r{#\u0001B+oSR\fA\u0003Z5tWRC'o\u001c;uY&twmQ8oM&<W#\u0001$\u0011\u0005\u001dCU\"A\u0014\n\u0005%;#A\b#jg.,6/Y4f\u0005\u0006\u001cX\r\u001a+ie>$H\u000f\\5oO\u000e{gNZ5h\u0003m!\u0017P\\1nS\u000e$\u0015n]6UQJ|G\u000f\u001e7j]\u001e\u001cuN\u001c4jO\"\u00121\u0001\u0014\t\u0003]5K!AT\u0018\u0003\u0011Y|G.\u0019;jY\u0016\fq\u0004Z=oC6L7\rR5tWRC'o\u001c;uY&twmQ8oM&<w\fJ3r)\t\t\u0015\u000bC\u0004S\t\u0005\u0005\t\u0019\u0001$\u0002\u0007a$\u0013'\u0001\u0003uS6,W#A+\u0011\u0005Y{V\"A,\u000b\u0005qB&BA-[\u0003\u0019\u0019w.\\7p]*\u0011!f\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a/\n!A+[7f\u0003=a\u0017m\u001d;DQ\u0016\u001c7.\u001a3US6,W#A2\u0011\u0005\u0011lW\"A3\u000b\u0005\u0019<\u0017AB1u_6L7M\u0003\u0002iS\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005)\\\u0017\u0001B;uS2T\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oK\nQ\u0011\t^8nS\u000eduN\\4\u0002\u001b\u001d,GOR5mKN#xN]3t+\u0005\t\bc\u0001:vo6\t1O\u0003\u0002u_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u001c(aA*fcB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0005M&dWM\u0003\u0002}W\u0006\u0019a.[8\n\u0005yL(!\u0003$jY\u0016\u001cFo\u001c:f\u0003)1\u0017\u000e\\3Ti>\u0014Xm\u001d\u0015\u0003\u00111\u000baBZ5mKN#xN]3t?\u0012*\u0017\u000fF\u0002B\u0003\u000fAqAU\u0005\u0002\u0002\u0003\u0007\u0011/\u0001\u000bqe>$WoY3s)\"\u0014x\u000e\u001e;mKJ\u000bG/Z\u000b\u0003\u0003\u001b\u00012ALA\b\u0013\r\t\tb\f\u0002\u0005\u0019>tw\r\u000b\u0002\u000b\u0019\u0006A\u0002O]8ek\u000e,'\u000f\u00165s_R$H.\u001a*bi\u0016|F%Z9\u0015\u0007\u0005\u000bI\u0002\u0003\u0005S\u0017\u0005\u0005\t\u0019AA\u0007\u0003]\u0019G.^:uKJd\u0015N\\6UQJ|G\u000f\u001e7f%\u0006$X\r\u000b\u0002\r\u0019\u0006Y2\r\\;ti\u0016\u0014H*\u001b8l)\"\u0014x\u000e\u001e;mKJ\u000bG/Z0%KF$2!QA\u0012\u0011!\u0011V\"!AA\u0002\u00055\u0011\u0001\u00064pY2|w/\u001a:UQJ|G\u000f\u001e7f%\u0006$X\r\u000b\u0002\u000f\u0019\u0006Abm\u001c7m_^,'\u000f\u00165s_R$H.\u001a*bi\u0016|F%Z9\u0015\u0007\u0005\u000bi\u0003\u0003\u0005S\u001f\u0005\u0005\t\u0019AA\u0007\u0003=a\u0017n\u001d;f]\u0016\u0014X*\u00198bO\u0016\u0014XCAA\u001a!\r9\u0015QG\u0005\u0004\u0003o9#a\u0007#jg.$\u0006N]8ui2,G*[:uK:,'/T1oC\u001e,'/\u0001\u000ede\u0016\fG/\u001a#jg.$\u0006N]8ui2,'/T3ue&\u001c7/\u0001\u000esK6|g/\u001a#jg.$\u0006N]8ui2,'/T3ue&\u001c7/\u0001\u000eva\u0012\fG/\u001a#jg.$\u0006N]8ui2LgnZ\"p]\u001aLw\rF\u0002B\u0003\u0003Ba!a\u0011\u0014\u0001\u00041\u0015!\u00038fo\u000e{gNZ5h\u0003u!\u0017n]6UQJ|G\u000f\u001e7j]\u001e,e.\u00192mK\u0012LenQ8oM&<G\u0003BA%\u0003\u001f\u00022ALA&\u0013\r\tie\f\u0002\b\u0005>|G.Z1o\u0011\u0019\t\t\u0006\u0006a\u0001\r\u000611m\u001c8gS\u001e\f\u0011#\\5o\t&\u001c8\u000eV8uC2\u0014\u0015\u0010^3t\u0003Ii\u0017N\u001c#jg.,6/\u00192mK\nKH/Z:\u0002=\rDWmY6B]\u0012,\u0006\u000fZ1uKF+x\u000e^1P]\u0012K7o[+tC\u001e,GcA!\u0002\\!9\u0011QL\fA\u0002\u00055\u0011A\u0002;j[\u0016l5/A\re_\u000eCWmY6B]\u0012,\u0006\u000fZ1uKRC'o\u001c;uY\u0016\u001c\u0018AE7bs\n,7+\u001a;GS2,7\u000b^8sKN$\"!!\u0013\u0002\u001b%t\u0017\u000e\u001e+ie>$H\u000f\\3s\u0003=)\b\u000fZ1uK2K7\u000f^3oKJ\u001cHcA!\u0002l!9\u0011QN\u000eA\u0002\u0005=\u0014!D9v_R\fG*[7ji>\u0003H\u000fE\u0003/\u0003c\ni!C\u0002\u0002t=\u0012aa\u00149uS>t\u0017AH4fi\u000e+(O]3oi\u0012K7o\u001b+ie>$H\u000f\\5oO\u000e{gNZ5h\u0003]!\u0015n]6Vg\u0006<WMQ1tK\u0012$\u0006N]8ui2,'\u000f\u0005\u0002H=M!a$LA\u001a\u0003\u0019a\u0014N\\5u}Q\u0011\u0011\u0011P\u0001\u001f!J|G-^2fe\u0012K7o\u001b+ie>$H\u000f\\3NKR\u0014\u0018n\u0019(b[\u0016,\"!!\"\u0011\t\u0005\u001d\u0015QR\u0007\u0003\u0003\u0013S1!a#l\u0003\u0011a\u0017M\\4\n\t\u0005=\u0015\u0011\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002?A\u0013x\u000eZ;dKJ$\u0015n]6UQJ|G\u000f\u001e7f\u001b\u0016$(/[2OC6,\u0007%A\u0013SKBd\u0017nY1uS>tgi\u001c7m_^,'\u000f\u00165s_R$H.Z'fiJL7MT1nK\u00061#+\u001a9mS\u000e\fG/[8o\r>dGn\\<feRC'o\u001c;uY\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002C\rcWo\u001d;fe2Kgn\u001b#jg.$\u0006N]8ui2,W*\u001a;sS\u000et\u0015-\\3\u0002E\rcWo\u001d;fe2Kgn\u001b#jg.$\u0006N]8ui2,W*\u001a;sS\u000et\u0015-\\3!\u0001")
public interface DiskUsageBasedThrottler
extends KafkaMetricsGroup {
    public static String ClusterLinkDiskThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName();
    }

    public static String ReplicationFollowerThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName();
    }

    public static String ProducerDiskThrottleMetricName() {
        return DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName();
    }

    public void kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(AtomicLong var1);

    public void kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskThrottleListenerManager var1);

    public DiskUsageBasedThrottlingConfig diskThrottlingConfig();

    public DiskUsageBasedThrottlingConfig kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig();

    public void kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(DiskUsageBasedThrottlingConfig var1);

    public Time time();

    public AtomicLong kafka$server$DiskUsageBasedThrottler$$lastCheckedTime();

    public static /* synthetic */ Seq getFileStores$(DiskUsageBasedThrottler $this) {
        return $this.getFileStores();
    }

    default public Seq<FileStore> getFileStores() {
        try {
            return (Seq)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs().map((Function1 & Serializable & scala.Serializable)logDir -> Files.getFileStore(Paths.get(logDir, new String[0])), Seq$.MODULE$.canBuildFrom());
        }
        catch (Exception e) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Couldn't create file-stores for logDirs: ").append(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs()).append(", ").append("however, this is normal at startup with non-existent log directories").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return Nil$.MODULE$;
        }
    }

    public Seq<FileStore> kafka$server$DiskUsageBasedThrottler$$fileStores();

    public void kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(Seq<FileStore> var1);

    public long producerThrottleRate();

    public void producerThrottleRate_$eq(long var1);

    public long kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate();

    public void kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(long var1);

    public long followerThrottleRate();

    public void followerThrottleRate_$eq(long var1);

    public DiskThrottleListenerManager listenerManager();

    public static /* synthetic */ void createDiskThrottlerMetrics$(DiskUsageBasedThrottler $this) {
        $this.createDiskThrottlerMetrics();
    }

    default public void createDiskThrottlerMetrics() {
        this.newGauge(DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ DiskUsageBasedThrottler $outer;

            public final long value() {
                return this.$outer.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ DiskUsageBasedThrottler $outer;

            public final long value() {
                return this.$outer.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge(DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ DiskUsageBasedThrottler $outer;

            public final long value() {
                return this.$outer.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public static /* synthetic */ void removeDiskThrottlerMetrics$(DiskUsageBasedThrottler $this) {
        $this.removeDiskThrottlerMetrics();
    }

    default public void removeDiskThrottlerMetrics() {
        this.removeMetric(DiskUsageBasedThrottler$.MODULE$.ProducerDiskThrottleMetricName(), this.removeMetric$default$2());
        this.removeMetric(DiskUsageBasedThrottler$.MODULE$.ReplicationFollowerThrottleMetricName(), this.removeMetric$default$2());
        this.removeMetric(DiskUsageBasedThrottler$.MODULE$.ClusterLinkDiskThrottleMetricName(), this.removeMetric$default$2());
    }

    public static /* synthetic */ void updateDiskThrottlingConfig$(DiskUsageBasedThrottler $this, DiskUsageBasedThrottlingConfig newConfig) {
        $this.updateDiskThrottlingConfig(newConfig);
    }

    default public void updateDiskThrottlingConfig(DiskUsageBasedThrottlingConfig newConfig) {
        if (this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig()) && !this.diskThrottlingEnabledInConfig(newConfig)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Disabling disk based throttling based on new config: {}", new Object[]{newConfig});
            }
            this.updateListeners((Option<Object>)None$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Updating disk throttling config from: {} to {}", new Object[]{this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig(), newConfig});
        }
        this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq(newConfig);
        this.checkAndUpdateQuotaOnDiskUsage(this.time().milliseconds());
    }

    public static /* synthetic */ boolean diskThrottlingEnabledInConfig$(DiskUsageBasedThrottler $this, DiskUsageBasedThrottlingConfig config) {
        return $this.diskThrottlingEnabledInConfig(config);
    }

    default public boolean diskThrottlingEnabledInConfig(DiskUsageBasedThrottlingConfig config) {
        return config.enableDiskBasedThrottling() && config.logDirs().nonEmpty();
    }

    public static /* synthetic */ long minDiskTotalBytes$(DiskUsageBasedThrottler $this) {
        return $this.minDiskTotalBytes();
    }

    default public long minDiskTotalBytes() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottler$$fileStores().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getTotalSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
    }

    public static /* synthetic */ long minDiskUsableBytes$(DiskUsageBasedThrottler $this) {
        return $this.minDiskUsableBytes();
    }

    default public long minDiskUsableBytes() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottler$$fileStores().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$));
    }

    public static /* synthetic */ void checkAndUpdateQuotaOnDiskUsage$(DiskUsageBasedThrottler $this, long timeMs) {
        $this.checkAndUpdateQuotaOnDiskUsage(timeMs);
    }

    default public void checkAndUpdateQuotaOnDiskUsage(long timeMs) {
        if (!this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig())) {
            return;
        }
        long lastCheck = this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().get();
        if (lastCheck + this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().diskCheckFrequencyMs() > timeMs) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Current time: {} still early for next check at: {}", new Object[]{BoxesRunTime.boxToLong((long)timeMs), BoxesRunTime.boxToLong((long)(lastCheck + this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().diskCheckFrequencyMs()))});
            }
            return;
        }
        if (this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().compareAndSet(lastCheck, timeMs)) {
            this.doCheckAndUpdateThrottles();
        }
    }

    private void doCheckAndUpdateThrottles() {
        if (this.kafka$server$DiskUsageBasedThrottler$$fileStores().nonEmpty() || this.maybeSetFileStores()) {
            if (this.minDiskUsableBytes() < this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Disk with the lowest free space: {}B available < threshold: {}B, will apply throttle!", new Object[]{BoxesRunTime.boxToLong((long)this.minDiskUsableBytes()), BoxesRunTime.boxToLong((long)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes())});
                }
                this.updateListeners((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().throttledProduceThroughput())));
                return;
            }
            if (this.listenerManager().anyListenerIsThrottled() && (double)this.minDiskUsableBytes() >= this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytesRecoveryFactor() * (double)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Disk with the lowest free space: {}B available >= {} x threshold: {}B, will remove low disk space throttle", new Object[]{BoxesRunTime.boxToLong((long)this.minDiskUsableBytes()), BoxesRunTime.boxToDouble((double)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytesRecoveryFactor()), BoxesRunTime.boxToLong((long)this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().freeDiskThresholdBytes())});
                }
                this.updateListeners((Option<Object>)None$.MODULE$);
                return;
            }
        }
    }

    private boolean maybeSetFileStores() {
        boolean bl;
        Seq<FileStore> seq = this.getFileStores();
        if (seq.nonEmpty()) {
            this.kafka$server$DiskUsageBasedThrottler$$fileStores_$eq(seq);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Created file-stores for logDirs: ").append(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig().logDirs()).toString());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ void initThrottler$(DiskUsageBasedThrottler $this) {
        $this.initThrottler();
    }

    default public void initThrottler() {
        this.createDiskThrottlerMetrics();
        if (this.diskThrottlingEnabledInConfig(this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig())) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Initializing low disk space throttle with config: {}", new Object[]{this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig()});
            }
            this.kafka$server$DiskUsageBasedThrottler$$lastCheckedTime().set(this.time().milliseconds());
            this.doCheckAndUpdateThrottles();
        }
    }

    private void updateListeners(Option<Object> quotaLimitOpt) {
        this.listenerManager().getListeners().foreach((Function1 & Serializable & scala.Serializable)listener -> {
            DiskUsageBasedThrottler.$anonfun$updateListeners$1(this, quotaLimitOpt, listener);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig$(DiskUsageBasedThrottler $this) {
        return $this.getCurrentDiskThrottlingConfig();
    }

    default public DiskUsageBasedThrottlingConfig getCurrentDiskThrottlingConfig() {
        return this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig();
    }

    public static /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1$(DiskUsageBasedThrottler $this) {
        return $this.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1();
    }

    default public /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$1() {
        return this.producerThrottleRate();
    }

    public static /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3$(DiskUsageBasedThrottler $this) {
        return $this.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3();
    }

    default public /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$3() {
        return this.followerThrottleRate();
    }

    public static /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5$(DiskUsageBasedThrottler $this) {
        return $this.kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5();
    }

    default public /* synthetic */ long kafka$server$DiskUsageBasedThrottler$$$anonfun$createDiskThrottlerMetrics$5() {
        return this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate();
    }

    public static /* synthetic */ void $anonfun$updateListeners$1(DiskUsageBasedThrottler $this, Option quotaLimitOpt$1, DiskUsageBasedThrottleListener listener) {
        Option<Object> option = listener.lastSignalledQuotaOptRef().getAndSet((Option<Object>)quotaLimitOpt$1);
        if (option == null ? quotaLimitOpt$1 != null : !option.equals((Object)quotaLimitOpt$1)) {
            if (quotaLimitOpt$1 instanceof Some) {
                long quotaLimit = BoxesRunTime.unboxToLong((Object)((Some)quotaLimitOpt$1).value());
                QuotaType quotaType = listener.quotaType();
                if (QuotaType$Produce$.MODULE$.equals(quotaType)) {
                    listener.handleDiskSpaceLow(quotaLimit);
                    $this.producerThrottleRate_$eq(quotaLimit);
                    return;
                }
                if (QuotaType$ClusterLinkReplication$.MODULE$.equals(quotaType)) {
                    listener.handleDiskSpaceLow(quotaLimit);
                    $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(quotaLimit);
                    return;
                }
                if (QuotaType$FollowerReplication$.MODULE$.equals(quotaType)) {
                    int multiplier = $this.diskThrottlingConfig().clusterLinkEnabled() ? 4 : 2;
                    listener.handleDiskSpaceLow((long)multiplier * quotaLimit);
                    $this.followerThrottleRate_$eq((long)multiplier * quotaLimit);
                    return;
                }
            } else if (None$.MODULE$.equals(quotaLimitOpt$1)) {
                listener.handleDiskSpaceRecovered();
                QuotaType quotaType = listener.quotaType();
                if (QuotaType$Produce$.MODULE$.equals(quotaType)) {
                    $this.producerThrottleRate_$eq(0L);
                    return;
                }
                if (QuotaType$FollowerReplication$.MODULE$.equals(quotaType)) {
                    $this.followerThrottleRate_$eq(0L);
                    return;
                }
                if (QuotaType$ClusterLinkReplication$.MODULE$.equals(quotaType)) {
                    $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(0L);
                    return;
                }
            } else {
                throw new MatchError((Object)quotaLimitOpt$1);
            }
        }
    }

    public static void $init$(DiskUsageBasedThrottler $this) {
        $this.kafka$server$DiskUsageBasedThrottler$$dynamicDiskThrottlingConfig_$eq($this.diskThrottlingConfig());
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$kafka$server$DiskUsageBasedThrottler$$lastCheckedTime_$eq(new AtomicLong($this.time().milliseconds()));
        $this.kafka$server$DiskUsageBasedThrottler$$fileStores_$eq($this.getFileStores());
        $this.producerThrottleRate_$eq(0L);
        $this.kafka$server$DiskUsageBasedThrottler$$clusterLinkThrottleRate_$eq(0L);
        $this.followerThrottleRate_$eq(0L);
        $this.kafka$server$DiskUsageBasedThrottler$_setter_$listenerManager_$eq(DiskUsageBasedThrottler$.MODULE$);
    }
}

