/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerReconfigurable;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicBackpressure;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerLoadConfig;
import kafka.server.DynamicBrokerTagsConfig;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicClusterLinkConfig;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicLoginManager;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicReplicaManagerConfig;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.link.CreateClusterLinkPolicy;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.DelegatingReconfigurable;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0011]q!B,Y\u0011\u0003if!B0Y\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007\u0002C5\u0002\u0005\u0004%\t\u0001\u00176\t\rm\f\u0001\u0015!\u0003l\u0011\u001da\u0018A1A\u0005\u0002)Da!`\u0001!\u0002\u0013Y\u0007b\u0002@\u0002\u0005\u0004%Ia \u0005\t\u0003\u000f\t\u0001\u0015!\u0003\u0002\u0002!A\u0011\u0011B\u0001C\u0002\u0013%!\u000eC\u0004\u0002\f\u0005\u0001\u000b\u0011B6\t\u0011\u00055\u0011A1A\u0005\n}D\u0001\"a\u0004\u0002A\u0003%\u0011\u0011\u0001\u0005\t\u0003#\t!\u0019!C\u0005\u007f\"A\u00111C\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002\u0016\u0005\u0011\r\u0011\"\u0001\u0002\u0018!A\u0011\u0011F\u0001!\u0002\u0013\tI\u0002\u0003\u0005\u0002,\u0005\u0011\r\u0011\"\u0003k\u0011\u001d\ti#\u0001Q\u0001\n-D\u0011\"a\f\u0002\u0005\u0004%\t!!\r\t\u0011\u00055\u0013\u0001)A\u0005\u0003gAq!a\u0014\u0002\t\u0003\t\t\u0006C\u0004\u0002r\u0005!\t!a\u001d\t\u000f\u00055\u0015\u0001\"\u0001\u0002\u0010\"9\u0011\u0011V\u0001\u0005\n\u0005-\u0006bBAY\u0003\u0011%\u00111\u0017\u0005\b\u0003o\u000bA\u0011BA]\u0011\u001d\ti,\u0001C\u0005\u0003\u007fC\u0001\"a1\u0002\t\u0003A\u0016Q\u0019\u0005\t\u0003\u0017\fA\u0011\u0001-\u0002N\"A\u0011Q[\u0001\u0005\u0002a\u000b9NB\u0003`1\u0002\ti\u000e\u0003\u0006\u0002l~\u0011)\u0019!C\u0005\u0003[D!\"!> \u0005\u0003\u0005\u000b\u0011BAx\u0011\u00199w\u0004\"\u0001\u0002x\"Q\u0011Q`\u0010C\u0002\u0013\u0005\u0001,a@\t\u0011\t\u0015q\u0004)A\u0005\u0005\u0003A!Ba\u0002 \u0005\u0004%\t\u0001WA\u0000\u0011!\u0011Ia\bQ\u0001\n\t\u0005\u0001\"\u0003B\u0006?\t\u0007I\u0011\u0002B\u0007\u0011!\u0011\tb\bQ\u0001\n\t=\u0001\"\u0003B\n?\t\u0007I\u0011\u0002B\u0007\u0011!\u0011)b\bQ\u0001\n\t=\u0001\"\u0003B\f?\t\u0007I\u0011\u0002B\r\u0011!\u0011Ic\bQ\u0001\n\tm\u0001\"\u0003B\u0016?\t\u0007I\u0011\u0002B\u0017\u0011!\u00119d\bQ\u0001\n\t=\u0002\u0002\u0004B\u001d?\u0001\u0007\t\u0019!C\u00011\nm\u0002\u0002\u0004B\"?\u0001\u0007\t\u0019!C\u00011\n\u0015\u0003b\u0003B&?\u0001\u0007\t\u0011)Q\u0005\u0005{A\u0011B!\u0014 \u0005\u0004%IAa\u0014\t\u0011\t\u0005t\u0004)A\u0005\u0005#B\u0011Ba\u0019 \u0001\u0004%I!!<\t\u0013\t\u0015t\u00041A\u0005\n\t\u001d\u0004\u0002\u0003B6?\u0001\u0006K!a<\t\u0013\t5tD1A\u0005\n\t=\u0004\u0002\u0003B??\u0001\u0006IA!\u001d\t\u0011\t}t\u0004\"\u0001Y\u0005\u0003C\u0001Ba% \t\u0003A&Q\u0013\u0005\b\u0005/{B\u0011\u0001BM\u0011\u001d\u0011)k\bC\u0001\u0005OCqA!, \t\u0003\u0011y\u000bC\u0004\u00034~!\tA!.\t\u000f\tev\u0004\"\u0003\u0003<\"A!\u0011Y\u0010\u0005\u0002a\u000bi\u000f\u0003\u0005\u0003D~!\t\u0001\u0017Bc\u0011!\u0011Ym\bC\u00011\n\u0015\u0007\u0002\u0003Bg?\u0011\u0005\u0001La4\t\u0011\t}w\u0004\"\u0001Y\u0005CD\u0001B!: \t\u0003A&q\u001d\u0005\b\u0005[|B\u0011\u0002Bx\u0011\u001d\u0019\u0019a\bC\u0005\u0007\u000bA\u0001ba\u0002 \t\u0003A6\u0011\u0002\u0005\t\u0007#yB\u0011\u0001-\u0004\u0014!91\u0011D\u0010\u0005\n\rm\u0001bBB\u0015?\u0011%11\u0006\u0005\t\u0007gyB\u0011\u0001-\u00046!911H\u0010\u0005\n\ru\u0002\u0002CB\"?\u0011\u0005\u0001l!\u0012\t\u000f\r-t\u0004\"\u0003\u0004n!91\u0011T\u0010\u0005\n\rm\u0005bBBQ?\u0011%!Q\u0013\u0005\b\u0007G{B\u0011BBS\u0011\u001d\u0019\tl\bC\u0005\u0007gCqa!1 \t\u0013\u0019\u0019\rC\u0004\u0004R~!Iaa5\t\u000f\rex\u0004\"\u0003\u0004|\u0006\u0019B)\u001f8b[&\u001c'I]8lKJ\u001cuN\u001c4jO*\u0011\u0011LW\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003m\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002_\u00035\t\u0001LA\nEs:\fW.[2Ce>\\WM]\"p]\u001aLwm\u0005\u0002\u0002CB\u0011!-Z\u0007\u0002G*\tA-A\u0003tG\u0006d\u0017-\u0003\u0002gG\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A/\u0002-\u0011Kh.Y7jGN+7-\u001e:jif\u001cuN\u001c4jON,\u0012a\u001b\t\u0004YF\u001cX\"A7\u000b\u00059|\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003a\u000e\f!bY8mY\u0016\u001cG/[8o\u0013\t\u0011XNA\u0002TKR\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\tQXO\u0001\u0004TiJLgnZ\u0001\u0018\tft\u0017-\\5d'\u0016\u001cWO]5us\u000e{gNZ5hg\u0002\n\u0011#\u00117m\tft\u0017-\\5d\u0007>tg-[4t\u0003I\tE\u000e\u001c#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u0011\u00027\rcWo\u001d;fe2+g/\u001a7MSN$XM\\3s\u0007>tg-[4t+\t\t\t\u0001E\u0003\u0002\u0004\u0005\u00151/D\u0001p\u0013\t\u0011x.\u0001\u000fDYV\u001cH/\u001a:MKZ,G\u000eT5ti\u0016tWM]\"p]\u001aLwm\u001d\u0011\u0002!A+'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\u0018!\u0005)fe\n\u0013xn[3s\u0007>tg-[4tA\u0005AB*[:uK:,'/T3dQ\u0006t\u0017n]7D_:4\u0017nZ:\u000231K7\u000f^3oKJlUm\u00195b]&\u001cXnQ8oM&<7\u000fI\u0001\u0016%\u0016dw.\u00193bE2,g)\u001b7f\u0007>tg-[4t\u0003Y\u0011V\r\\8bI\u0006\u0014G.\u001a$jY\u0016\u001cuN\u001c4jON\u0004\u0013a\u0005'jgR,g.\u001a:D_:4\u0017n\u001a*fO\u0016DXCAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003G\u0019\u0017\u0001B;uS2LA!a\n\u0002\u001e\t)!+Z4fq\u0006!B*[:uK:,'oQ8oM&<'+Z4fq\u0002\na\u0003R=oC6L7\rU1tg^|'\u000fZ\"p]\u001aLwm]\u0001\u0018\tft\u0017-\\5d!\u0006\u001c8o^8sI\u000e{gNZ5hg\u0002\n\u0011cU3dkJLG/_\"p]\u001aLw\rR3g+\t\t\u0019\u0004\u0005\u0003\u00026\u0005%SBAA\u001c\u0015\u0011\tI$a\u000f\u0002\r\r|gNZ5h\u0015\u0011\ti$a\u0010\u0002\r\r|W.\\8o\u0015\rY\u0016\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\n1a\u001c:h\u0013\u0011\tY%a\u000e\u0003\u0013\r{gNZ5h\t\u00164\u0017AE*fGV\u0014\u0018\u000e^=D_:4\u0017n\u001a#fM\u0002\n\u0001#[:QCN\u001cxo\u001c:e\u0007>tg-[4\u0015\t\u0005M\u0013\u0011\f\t\u0004E\u0006U\u0013bAA,G\n9!i\\8mK\u0006t\u0007bBA.+\u0001\u0007\u0011QL\u0001\u0005]\u0006lW\r\u0005\u0003\u0002`\u00055d\u0002BA1\u0003S\u00022!a\u0019d\u001b\t\t)GC\u0002\u0002hq\u000ba\u0001\u0010:p_Rt\u0014bAA6G\u00061\u0001K]3eK\u001aL1A_A8\u0015\r\tYgY\u0001\u0015EJ|7.\u001a:D_:4\u0017nZ*z]>t\u00170\\:\u0015\r\u0005U\u0014qQAE!\u0019\t9(!!\u0002^9!\u0011\u0011PA?\u001d\u0011\t\u0019'a\u001f\n\u0003\u0011L1!a d\u0003\u001d\u0001\u0018mY6bO\u0016LA!a!\u0002\u0006\n!A*[:u\u0015\r\tyh\u0019\u0005\b\u000372\u0002\u0019AA/\u0011\u001d\tYI\u0006a\u0001\u0003'\nQ#\\1uG\"d\u0015n\u001d;f]\u0016\u0014xJ^3se&$W-A\bwC2LG-\u0019;f\u0007>tg-[4t)\u0019\t\t*a&\u0002&B\u0019!-a%\n\u0007\u0005U5M\u0001\u0003V]&$\bbBAM/\u0001\u0007\u00111T\u0001\u0006aJ|\u0007o\u001d\t\u0005\u0003;\u000b\t+\u0004\u0002\u0002 *\u0019\u00111E<\n\t\u0005\r\u0016q\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAT/\u0001\u0007\u00111K\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\u0006\u0001\u0002/\u001a:Ce>\\WM]\"p]\u001aLwm\u001d\u000b\u0005\u0003[\u000by\u000b\u0005\u0004\u0002\u0004\u0005\u0015\u0011Q\f\u0005\b\u00033C\u0002\u0019AAN\u0003EqwN\u001c#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u000b\u0005\u0003[\u000b)\fC\u0004\u0002\u001af\u0001\r!a'\u0002IM,7-\u001e:jif\u001cuN\u001c4jON<\u0016\u000e\u001e5pkRd\u0015n\u001d;f]\u0016\u0014\bK]3gSb$B!!,\u0002<\"9\u0011\u0011\u0014\u000eA\u0002\u0005m\u0015a\u0005<bY&$\u0017\r^3D_:4\u0017n\u001a+za\u0016\u001cH\u0003BAI\u0003\u0003Dq!!'\u001c\u0001\u0004\tY*A\tbI\u0012$\u0015P\\1nS\u000e\u001cuN\u001c4jON$B!!%\u0002H\"9\u0011\u0011\u001a\u000fA\u0002\u0005M\u0012!C2p]\u001aLw\rR3g\u0003a!\u0017P\\1nS\u000e\u001cuN\u001c4jOV\u0003H-\u0019;f\u001b>$Wm]\u000b\u0003\u0003\u001f\u0004\u0002\"!(\u0002R\u0006u\u0013QL\u0005\u0005\u0003'\fyJA\u0002NCB\faC]3t_24XMV1sS\u0006\u0014G.Z\"p]\u001aLwm\u001d\u000b\u0005\u00037\u000bI\u000eC\u0004\u0002\\z\u0001\r!a'\u0002\u001bA\u0014x\u000e]:Pe&<\u0017N\\1m'\u0011y\u0012-a8\u0011\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:[\u0003\u0015)H/\u001b7t\u0013\u0011\tI/a9\u0003\u000f1{wmZ5oO\u0006Y1.\u00194lC\u000e{gNZ5h+\t\ty\u000fE\u0002_\u0003cL1!a=Y\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0019-\fgm[1D_:4\u0017n\u001a\u0011\u0015\t\u0005e\u00181 \t\u0003=~Aq!a;#\u0001\u0004\ty/A\nti\u0006$\u0018n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0003\u0002A)ANa\u0001tg&\u0019\u00111[7\u0002)M$\u0018\r^5d\u0005J|7.\u001a:D_:4\u0017nZ:!\u0003Q\u0019H/\u0019;jG\u0012+g-Y;mi\u000e{gNZ5hg\u0006)2\u000f^1uS\u000e$UMZ1vYR\u001cuN\u001c4jON\u0004\u0013\u0001\u00063z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0003\u0010A9ANa\u0001\u0002^\u0005u\u0013!\u00063z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7\u000fI\u0001\u0016Ift\u0017-\\5d\t\u00164\u0017-\u001e7u\u0007>tg-[4t\u0003Y!\u0017P\\1nS\u000e$UMZ1vYR\u001cuN\u001c4jON\u0004\u0013a\u0004:fG>tg-[4ve\u0006\u0014G.Z:\u0016\u0005\tm\u0001#\u00027\u0003\u001e\t\u0005\u0012b\u0001B\u0010[\n1!)\u001e4gKJ\u0004BAa\t\u0003&5\u0011\u00111H\u0005\u0005\u0005O\tYD\u0001\bSK\u000e|gNZ5hkJ\f'\r\\3\u0002!I,7m\u001c8gS\u001e,(/\u00192mKN\u0004\u0013!\u00062s_.,'OU3d_:4\u0017nZ;sC\ndWm]\u000b\u0003\u0005_\u0001R\u0001\u001cB\u000f\u0005c\u00012A\u0018B\u001a\u0013\r\u0011)\u0004\u0017\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002-\t\u0014xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fg\u0002\n1\u0003Z=oC6L7\rT8hS:l\u0015M\\1hKJ,\"A!\u0010\u0011\u0007y\u0013y$C\u0002\u0003Ba\u00131\u0003R=oC6L7\rT8hS:l\u0015M\\1hKJ\fq\u0003Z=oC6L7\rT8hS:l\u0015M\\1hKJ|F%Z9\u0015\t\u0005E%q\t\u0005\n\u0005\u0013\u0002\u0014\u0011!a\u0001\u0005{\t1\u0001\u001f\u00132\u0003Q!\u0017P\\1nS\u000edunZ5o\u001b\u0006t\u0017mZ3sA\u0005!An\\2l+\t\u0011\t\u0006\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\u000b1|7m[:\u000b\t\tm\u0013qT\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B0\u0005+\u0012aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\u0006Y>\u001c7\u000eI\u0001\u000eGV\u0014(/\u001a8u\u0007>tg-[4\u0002#\r,(O]3oi\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\n%\u0004\"\u0003B%k\u0005\u0005\t\u0019AAx\u00039\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0002\nA\u0004Z=oC6L7mQ8oM&<\u0007+Y:to>\u0014H-\u00128d_\u0012,'/\u0006\u0002\u0003rA)!Ma\u001d\u0003x%\u0019!QO2\u0003\r=\u0003H/[8o!\u0011\t\tO!\u001f\n\t\tm\u00141\u001d\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0006iB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014\b%\u0001\u0006j]&$\u0018.\u00197ju\u0016$B!!%\u0003\u0004\"9!QQ\u001dA\u0002\t\u001d\u0015\u0001\u0003>l\u00072LWM\u001c;\u0011\t\t%%qR\u0007\u0003\u0005\u0017S1A!$[\u0003\tQ8.\u0003\u0003\u0003\u0012\n-%!D&bM.\f'l[\"mS\u0016tG/A\u0003dY\u0016\f'\u000f\u0006\u0002\u0002\u0012\u0006\u0011\u0012\r\u001a3SK\u000e|gNZ5hkJ\f'\r\\3t)\u0011\t\tJa'\t\u000f\tu5\b1\u0001\u0003 \u0006Y1.\u00194lCN+'O^3s!\rq&\u0011U\u0005\u0004\u0005GC&aC&bM.\f'I]8lKJ\f\u0011#\u00193e%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\t\tJ!+\t\u000f\t-F\b1\u0001\u0003\"\u0005q!/Z2p]\u001aLw-\u001e:bE2,\u0017aF1eI\n\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)\u0011\t\tJ!-\t\u000f\t-V\b1\u0001\u00032\u0005!\"/Z7pm\u0016\u0014VmY8oM&<WO]1cY\u0016$B!!%\u00038\"9!1\u0016 A\u0002\t\u0005\u0012a\u0007<fe&4\u0017PU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\u0006\u0003\u0002\u0012\nu\u0006b\u0002B`\u007f\u0001\u0007\u0011QV\u0001\fG>tg-[4OC6,7/\u0001\ndkJ\u0014XM\u001c;LC\u001a\\\u0017mQ8oM&<\u0017aG2veJ,g\u000e\u001e#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7/\u0006\u0002\u0003HBA\u00111\u0001Be\u0003;\ni&C\u0002\u0002T>\fAdY;se\u0016tG\u000fR=oC6L7\rR3gCVdGoQ8oM&<7/\u0001\nva\u0012\fG/\u001a\"s_.,'oQ8oM&<GCBAI\u0005#\u0014Y\u000eC\u0004\u0003T\u000e\u0003\rA!6\u0002\u0011\t\u0014xn[3s\u0013\u0012\u00042A\u0019Bl\u0013\r\u0011In\u0019\u0002\u0004\u0013:$\bb\u0002Bo\u0007\u0002\u0007\u00111T\u0001\u0010a\u0016\u00148/[:uK:$\bK]8qg\u0006\u0019R\u000f\u001d3bi\u0016$UMZ1vYR\u001cuN\u001c4jOR!\u0011\u0011\u0013Br\u0011\u001d\u0011i\u000e\u0012a\u0001\u00037\u000bQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\t\u0005E%\u0011\u001e\u0005\b\u0005W,\u0005\u0019AAN\u0003!qWm\u001e)s_B\u001c\u0018AG7bs\n,7I]3bi\u0016\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014H\u0003\u0002B9\u0005cDqAa=G\u0001\u0004\u0011)0\u0001\u0004tK\u000e\u0014X\r\u001e\t\u0006E\nM$q\u001f\t\u0005\u0005s\u0014y0\u0004\u0002\u0003|*!!Q`A\u001c\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0019\tAa?\u0003\u0011A\u000b7o]<pe\u0012\fq\u0002]1tg^|'\u000fZ#oG>$WM]\u000b\u0003\u0005o\n\u0011\u0003^8QKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t)\u0019\tYja\u0003\u0004\u0010!91Q\u0002%A\u0002\u0005m\u0015aC2p]\u001aLw\r\u0015:paNDq!a*I\u0001\u0004\t\u0019&A\nge>l\u0007+\u001a:tSN$XM\u001c;Qe>\u00048\u000f\u0006\u0004\u0002\u001c\u000eU1q\u0003\u0005\b\u0005;L\u0005\u0019AAN\u0011\u001d\t9+\u0013a\u0001\u0003'\na#\\1zE\u0016\u0014V-\u00128d_\u0012,\u0007+Y:to>\u0014Hm\u001d\u000b\u0007\u00037\u001biba\b\t\u000f\tu'\n1\u0001\u0002\u001c\"91\u0011\u0005&A\u0002\r\r\u0012!D1e[&t'l[\"mS\u0016tG\u000f\u0005\u0003\u0003\n\u000e\u0015\u0012\u0002BB\u0014\u0005\u0017\u0013Q\"\u00113nS:T6n\u00117jK:$\u0018a\u0005<bY&$\u0017\r^3e\u0017\u000647.\u0019)s_B\u001cHC\u0002Bd\u0007[\u0019\t\u0004C\u0004\u00040-\u0003\r!a'\u0002\u001bA\u0014x\u000e]:Pm\u0016\u0014(/\u001b3f\u0011\u001d\t9k\u0013a\u0001\u0003'\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0007\u0003#\u001b9d!\u000f\t\u000f\u0005eE\n1\u0001\u0002\u001c\"9\u0011q\u0015'A\u0002\u0005M\u0013\u0001\u0006:f[>4X-\u00138wC2LGmQ8oM&<7\u000f\u0006\u0004\u0002\u0012\u000e}2\u0011\t\u0005\b\u00033k\u0005\u0019AAN\u0011\u001d\t9+\u0014a\u0001\u0003'\n\u0001#\\1zE\u0016\u0014VmY8oM&<WO]3\u0015\u0011\u0005E5qIB%\u0007\u001bBqAa+O\u0001\u0004\u0011\t\u0003C\u0004\u0004L9\u0003\r!a<\u0002\u0013=dGmQ8oM&<\u0007bBB(\u001d\u0002\u00071\u0011K\u0001\n]\u0016<8i\u001c8gS\u001e\u0004Daa\u0015\u0004ZAA\u0011QTAi\u0003;\u001a)\u0006\u0005\u0003\u0004X\reC\u0002\u0001\u0003\r\u00077\u001ai%!A\u0001\u0002\u000b\u00051Q\f\u0002\u0004?\u0012\n\u0014\u0003BB0\u0007K\u00022AYB1\u0013\r\u0019\u0019g\u0019\u0002\b\u001d>$\b.\u001b8h!\r\u00117qM\u0005\u0004\u0007S\u001a'aA!os\u0006qQ\u000f\u001d3bi\u0016$7i\u001c8gS\u001e\u001cHCBB8\u0007\u007f\u001aY\tE\u0004c\u0007c\u001a)(!,\n\u0007\rM4M\u0001\u0004UkBdWM\r\u0019\u0005\u0007o\u001aY\bE\u0004m\u0005\u0007\tif!\u001f\u0011\t\r]31\u0010\u0003\f\u0007{z\u0015\u0011!A\u0001\u0006\u0003\u0019iFA\u0002`IQBqAa;P\u0001\u0004\u0019\t\t\r\u0003\u0004\u0004\u000e\u001d\u0005\u0003CAO\u0003#\fif!\"\u0011\t\r]3q\u0011\u0003\r\u0007\u0013\u001by(!A\u0001\u0002\u000b\u00051Q\f\u0002\u0004?\u0012\u0012\u0004bBBG\u001f\u0002\u00071qR\u0001\rGV\u0014(/\u001a8u!J|\u0007o\u001d\u0019\u0005\u0007#\u001b)\n\u0005\u0005\u0002\u001e\u0006E\u0017QLBJ!\u0011\u00199f!&\u0005\u0019\r]51RA\u0001\u0002\u0003\u0015\ta!\u0018\u0003\u0007}#3'A\u0007pm\u0016\u0014(/\u001b3f!J|\u0007o\u001d\u000b\u0007\u0003#\u001bija(\t\u000f\u0005e\u0005\u000b1\u0001\u0003\u0010!91q\u0006)A\u0002\t=\u0011aE;qI\u0006$XmQ;se\u0016tGoQ8oM&<\u0017A\u00069s_\u000e,7o\u001d*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\r\r\u001d61VBW!\u001d\u00117\u0011OAx\u0007S\u0003b!a\u001e\u0002\u0002\nE\u0002b\u0002Bv%\u0002\u0007!q\u0019\u0005\b\u0007_\u0013\u0006\u0019AA*\u000311\u0018\r\\5eCR,wJ\u001c7z\u0003i\u0011'o\\6fe:+W\rZ:SK\u000e|gNZ5hkJ\fG/[8o)!\t\u0019f!.\u0004:\u000eu\u0006bBB\\'\u0002\u0007!\u0011G\u0001\u0015EJ|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\t\u000f\rm6\u000b1\u0001\u0002.\u0006YQ\u000f\u001d3bi\u0016$7*Z=t\u0011\u001d\u0019yl\u0015a\u0001\u0003[\u000b1\u0002Z3mKR,GmS3zg\u0006!b.Z3egJ+7m\u001c8gS\u001e,(/\u0019;j_:$\u0002\"a\u0015\u0004F\u000e57q\u001a\u0005\b\u0007\u000f$\u0006\u0019ABe\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004b!!(\u0004L\u0006u\u0013b\u0001:\u0002 \"911\u0018+A\u0002\u00055\u0006bBB`)\u0002\u0007\u0011QV\u0001\u001eaJ|7-Z:t\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mKRa\u0011\u0011SBk\u0007K\u001c9oa=\u0004v\"91q[+A\u0002\re\u0017A\u00067jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0011\t\rm7\u0011]\u0007\u0003\u0007;TAaa8\u0002<\u00059a.\u001a;x_J\\\u0017\u0002BBr\u0007;\u0014a\u0003T5ti\u0016tWM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\u0005\b\u0007\u001f*\u0006\u0019AAx\u0011\u001d\u0019I/\u0016a\u0001\u0007W\fQbY;ti>l7i\u001c8gS\u001e\u001c\b\u0003CAO\u0003#\fif!<\u0011\u0007Q\u001cy/C\u0002\u0004rV\u0014aa\u00142kK\u000e$\bbBBX+\u0002\u0007\u00111\u000b\u0005\b\u0007o,\u0006\u0019AA*\u0003)\u0011X\r\\8bI>sG._\u0001\u0016aJ|7-Z:t%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f)1\t\tj!@\u0004\u0000\u0012\rA\u0011\u0003C\u000b\u0011\u001d\u0011YK\u0016a\u0001\u0005CAq\u0001\"\u0001W\u0001\u0004\ti+\u0001\nva\u0012\fG/\u001a3D_:4\u0017n\u001a(b[\u0016\u001c\bb\u0002C\u0003-\u0002\u0007AqA\u0001\u000eC2dg*Z<D_:4\u0017nZ:1\t\u0011%AQ\u0002\t\t\u0003;\u000b\t.!\u0018\u0005\fA!1q\u000bC\u0007\t1!y\u0001b\u0001\u0002\u0002\u0003\u0005)\u0011AB/\u0005\ryF%\u000e\u0005\b\t'1\u0006\u0019ABv\u0003AqWm^\"vgR|WnQ8oM&<7\u000fC\u0004\u00040Z\u0003\r!a\u0015")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final Buffer<Reconfigurable> reconfigurables;
    private final Buffer<BrokerReconfigurable> brokerReconfigurables;
    private DynamicLoginManager dynamicLoginManager;
    private final ReentrantReadWriteLock lock;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static ConfigDef SecurityConfigDef() {
        return DynamicBrokerConfig$.MODULE$.SecurityConfigDef();
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    private Buffer<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private Buffer<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    public DynamicLoginManager dynamicLoginManager() {
        return this.dynamicLoginManager;
    }

    public void dynamicLoginManager_$eq(DynamicLoginManager x$1) {
        this.dynamicLoginManager = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(KafkaZkClient zkClient) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        this.updateDefaultConfig(adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default()));
        Properties props = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(this.kafkaConfig().brokerId()));
        Properties brokerConfig = this.maybeReEncodePasswords(props, adminZkClient);
        this.updateBrokerConfig(this.kafkaConfig().brokerId(), brokerConfig);
        this.dynamicLoginManager_$eq(new DynamicLoginManager(this.kafkaConfig()));
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
        this.dynamicLoginManager_$eq(null);
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)new DelegatingReconfigurable(() -> kafkaServer.httpServer().orNull(Predef$.MODULE$.$conforms())));
        if (kafkaServer.auditLogProvider() != null) {
            this.addReconfigurable((Reconfigurable)kafkaServer.auditLogProvider());
        }
        this.addReconfigurable(kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer));
        this.addReconfigurable(new DynamicClientQuotaCallback(this.kafkaConfig().brokerId(), kafkaServer));
        if (kafkaServer instanceof KafkaServer) {
            KafkaServer kafkaServer2 = (KafkaServer)kafkaServer;
            kafkaServer2.adminManager().createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DynamicBrokerConfig.$anonfun$addReconfigurables$2(this, x0$1);
                return BoxedUnit.UNIT;
            });
            if (kafkaServer2.clusterLinkManager() != null) {
                kafkaServer2.clusterLinkManager().createClusterLinkPolicy().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    DynamicBrokerConfig.$anonfun$addReconfigurables$3(this, x0$2);
                    return BoxedUnit.UNIT;
                });
            }
        }
        this.addBrokerReconfigurable(new DynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.logManager());
        if (kafkaServer.logManager().cleaner() != null) {
            this.addBrokerReconfigurable(kafkaServer.logManager().cleaner());
        }
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicBackpressure(kafkaServer));
        this.addBrokerReconfigurable(new DynamicBalancerConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicClusterLinkConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicBrokerTagsConfig(kafkaServer));
        kafkaServer.tierDeletedPartitionsCoordinatorOpt().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        kafkaServer.tierFetcherOpt().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
            this.addBrokerReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        this.addBrokerReconfigurable(new DynamicBrokerLoadConfig(kafkaServer));
        this.addBrokerReconfigurable(new DynamicReplicaManagerConfig(kafkaServer));
    }

    /*
     * WARNING - void declaration
     */
    public void addReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReconfigurableConfigs(Set<String> configNames) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBrokerConfig(int brokerId, Properties persistentProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateDefaultConfig(Properties persistentProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> new PasswordEncoder((Password)secret, this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), this.kafkaConfig().passwordEncoderCipherAlgorithm(), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)configProps.clone();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        void var3_3;
        Properties props = (Properties)persistentProps.clone();
        if (((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Properties props, boolean perBrokerConfig) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(currentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(propsOverride);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig() {
        void var5_5;
        void var4_4;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.BrokerSessionUuidProp()), (Object)this.kafkaConfig().brokerSessionUuid())}))));
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        void newConfig2 = var4_4;
        void brokerReconfigurablesToUpdate2 = var5_5;
        if (newConfig2 != this.currentConfig()) {
            this.currentConfig_$eq((KafkaConfig)newConfig2);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)newConfig2);
            brokerReconfigurablesToUpdate2.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)newConfig2, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly) {
        void var6_6;
        void var5_5;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), !validateOnly, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        void changeMap2 = var5_5;
        void deletedKeySet2 = var6_6;
        if (changeMap2.nonEmpty() || deletedKeySet2.nonEmpty()) {
            try {
                Option$.MODULE$.apply((Object)this.dynamicLoginManager()).foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$1$adapted(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, arg_0));
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(x$6 -> customConfigs.remove(x$6));
                this.reconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3$adapted(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().foreach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$4(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
    }

    private boolean brokerNeedsReconfiguration(BrokerReconfigurable brokerReconfigurable, Set<String> updatedKeys, Set<String> deletedKeys) {
        boolean bl = brokerReconfigurable instanceof DynamicBrokerTagsConfig ? updatedKeys.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(KafkaConfig$.MODULE$.BrokerTagsProp()))) || deletedKeys.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith(KafkaConfig$.MODULE$.BrokerTagsProp()))) : (brokerReconfigurable instanceof DynamicLoginManager ? true : this.needsReconfiguration((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(brokerReconfigurable.reconfigurableConfigs()).asJava(), updatedKeys, deletedKeys));
        return bl;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty() || ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(deletedKeys)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        void changeMap2 = var10_10;
        void deletedKeys2 = var11_11;
        Set updatedKeys = changeMap2.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)deletedKeys2);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
        }
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$2(DynamicBrokerConfig $this, CreateTopicPolicy x0$1) {
        if (x0$1 instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)x0$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addReconfigurables$3(DynamicBrokerConfig $this, CreateClusterLinkPolicy x0$2) {
        if (x0$2 instanceof Reconfigurable) {
            $this.addReconfigurable((Reconfigurable)x0$2);
            return;
        }
    }

    public static final /* synthetic */ Buffer $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable$1.reconfigurableConfigs()).asScala()));
        return $this.reconfigurables().$plus$eq((Object)reconfigurable$1);
    }

    public static final /* synthetic */ Buffer $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().$plus$eq((Object)reconfigurable$2);
    }

    public static final /* synthetic */ Buffer $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().$minus$eq((Object)reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig();
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableLike)$this.reconfigurables().filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable & scala.Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true);
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                bl = false;
            }
            catch (Exception exception) {
                bl = true;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$1._1();
        boolean bl = !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String k = (String)x0$2._1();
        boolean bl = !newProps$2.containsKey(k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$1(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, DynamicLoginManager loginManager) {
        if ($this.brokerNeedsReconfiguration(loginManager, (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            loginManager.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                loginManager.reconfigure($this.currentConfig(), newConfig$3);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$4(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.brokerNeedsReconfiguration(reconfigurable, (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                return brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerReconfigurables = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantReadWriteLock();
        this.currentConfig = kafkaConfig;
        this.dynamicConfigPasswordEncoder = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$4) {
        x$4.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$1$adapted(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, DynamicLoginManager loginManager) {
        DynamicBrokerConfig.$anonfun$processReconfiguration$1($this, changeMap$1, deletedKeySet$1, newConfig$3, validateOnly$1, loginManager);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$processReconfiguration$3$adapted(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        DynamicBrokerConfig.$anonfun$processReconfiguration$3($this, newConfig$3, customConfigs$1, validateOnly$1, changeMap$1, deletedKeySet$1, x0$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

