/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.BrokerLoad;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0012$\u0001!B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\n\u0001B\u0001B\u0003%1\b\u0003\u0005O\u0001\t\u0015\r\u0011\"\u0001P\u0011!a\u0006A!A!\u0002\u0013\u0001\u0006\u0002C/\u0001\u0005\u000b\u0007I\u0011\u00010\t\u0011%\u0004!\u0011!Q\u0001\n}C\u0001B\u001b\u0001\u0003\u0006\u0004%\ta\u001b\u0005\te\u0002\u0011\t\u0011)A\u0005Y\"A1\u000f\u0001BC\u0002\u0013\u0005A\u000fC\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005k\"Q\u0011q\u0001\u0001\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005E\u0001A!A!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002\u001e\u0001\u0011)\u0019!C\u0001\u0003?A!\"!\r\u0001\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kA\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005e\u0003\u0001)A\u0005\u0003#B\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003?B\u0011\"a\u001a\u0001\u0001\u0004%I!!\u001b\t\u0013\u0005E\u0004\u00011A\u0005\n\u0005M\u0004\u0002CA@\u0001\u0001\u0006K!a\u001b\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"A\u0011Q\u0012\u0001\u0005\u0002\r\ny\tC\u0004\u0002\u0016\u0002!I!a#\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\f\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005-\u0005bBAN\u0001\u0011\u0005\u00111R\u0004\n\u0003;\u001b\u0013\u0011!E\u0001\u0003?3\u0001BI\u0012\u0002\u0002#\u0005\u0011\u0011\u0015\u0005\b\u0003gyB\u0011AAU\u0011%\tYkHI\u0001\n\u0003\tiKA\nLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'O\u0003\u0002%K\u000511/\u001a:wKJT\u0011AJ\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0011&\r\u001b\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t1qJ\u00196fGR\u0004\"A\u000b\u001a\n\u0005MZ#\u0001\u0003*v]:\f'\r\\3\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]*\u0013!B;uS2\u001c\u0018BA\u001d7\u0005\u001daunZ4j]\u001e\f!!\u001b3\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u0007%sG/A\u0005dYV\u001cH/\u001a:JIB\u00111I\u0013\b\u0003\t\"\u0003\"!R\u001f\u000e\u0003\u0019S!aR\u0014\u0002\rq\u0012xn\u001c;?\u0013\tIU(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%>\u0003!\u0011'o\\6fe&#\u0017AE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ,\u0012\u0001\u0015\t\u0003#jk\u0011A\u0015\u0006\u0003'R\u000bAaY8sK*\u0011QKV\u0001\b[\u0016$(/[2t\u0015\t9\u0006,\u0001\u0004zC6lWM\u001d\u0006\u00023\u0006\u00191m\\7\n\u0005m\u0013&!B'fi\u0016\u0014\u0018aE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ\u0004\u0013a\u0005;pi\u0006d\u0007*\u00198eY\u0016\u0014H\u000b\u001b:fC\u0012\u001cX#A0\u0011\u0005\u0001<W\"A1\u000b\u0005\t\u001c\u0017AB1u_6L7M\u0003\u0002eK\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0019l\u0013\u0001B;uS2L!\u0001[1\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003Q!x\u000e^1m\u0011\u0006tG\r\\3s)\"\u0014X-\u00193tA\u0005q!/Z9vKN$8\t[1o]\u0016dW#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=,\u0013a\u00028fi^|'o[\u0005\u0003c:\u0014aBU3rk\u0016\u001cHo\u00115b]:,G.A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003A\u0011X-];fgRdun\u001a$jYR,'/F\u0001v!\r1\u0018\u0011A\u0007\u0002o*\u0011\u00010_\u0001\te\u0016\fX/Z:ug*\u0011!p_\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019b(BA?\u007f\u0003\u0019\t\u0007/Y2iK*\tq0A\u0002pe\u001eL1!a\u0001x\u0005A\u0011V-];fgRdun\u001a$jYR,'/A\tsKF,Xm\u001d;M_\u001e4\u0015\u000e\u001c;fe\u0002\nA!\u00199jgB!\u00111BA\u0007\u001b\u0005\u0019\u0013bAA\bG\t\t\u0012\t]5SKF,Xm\u001d;IC:$G.\u001a:\u0002\tQLW.\u001a\t\u0005\u0003+\tI\"\u0004\u0002\u0002\u0018)\u0011q'_\u0005\u0005\u00037\t9B\u0001\u0003US6,\u0017A\u00032s_.,'\u000fT8bIV\u0011\u0011\u0011\u0005\t\u0006y\u0005\r\u0012qE\u0005\u0004\u0003Ki$AB(qi&|g\u000e\u0005\u0003\u0002*\u00055RBAA\u0016\u0015\t)V%\u0003\u0003\u00020\u0005-\"A\u0003\"s_.,'\u000fT8bI\u0006Y!M]8lKJdu.\u00193!\u0003\u0019a\u0014N\\5u}Q1\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0013QIA$\u0003\u0013\nY\u0005E\u0002\u0002\f\u0001AQA\u000f\tA\u0002mBQ!\u0011\tA\u0002\tCQ!\u0014\tA\u0002mBQA\u0014\tA\u0002ACQ!\u0018\tA\u0002}CQA\u001b\tA\u00021DQa\u001d\tA\u0002UDq!a\u0002\u0011\u0001\u0004\tI\u0001C\u0004\u0002\u0012A\u0001\r!a\u0005\t\u0013\u0005u\u0001\u0003%AA\u0002\u0005\u0005\u0012\u0001E:ikR$wn\u001e8D_6\u0004H.\u001a;f+\t\t\t\u0006\u0005\u0003\u0002T\u0005US\"A2\n\u0007\u0005]3M\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\u0002#MDW\u000f\u001e3po:\u001cu.\u001c9mKR,\u0007%\u0001\u0007sKF,Xm\u001d;M_\u000e\fG.\u0006\u0002\u0002`A!\u00111BA1\u0013\r\t\u0019g\t\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u000ee\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\u0011\u0002\u000fM$x\u000e\u001d9fIV\u0011\u00111\u000e\t\u0004y\u00055\u0014bAA8{\t9!i\\8mK\u0006t\u0017aC:u_B\u0004X\rZ0%KF$B!!\u001e\u0002|A\u0019A(a\u001e\n\u0007\u0005eTH\u0001\u0003V]&$\b\"CA?-\u0005\u0005\t\u0019AA6\u0003\rAH%M\u0001\tgR|\u0007\u000f]3eA!\u001aq#a!\u0011\u0007q\n))C\u0002\u0002\bv\u0012\u0001B^8mCRLG.Z\u0001\u0004eVtGCAA;\u0003\u0011\u0001x\u000e\u001c7\u0015\t\u0005U\u0014\u0011\u0013\u0005\u0007\u0003'K\u0002\u0019A\u001e\u0002\u0013QLW.Z8vi6\u001b\u0018\u0001E2p[BdW\r^3TQV$Hm\\<o\u0003\u0011\u0019Ho\u001c9\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^t\u0017!D1xC&$8\u000b[;uI><h.A\nLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000fE\u0002\u0002\f}\u00192aHAR!\ra\u0014QU\u0005\u0004\u0003Ok$AB!osJ+g\r\u0006\u0002\u0002 \u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TCAAXU\u0011\t\t#!-,\u0005\u0005M\u0006\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!0>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\f9LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final String clusterId;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final RequestLogFilter requestLogFilter;
    private final ApiRequestHandler apis;
    private final Time time;
    private final Option<BrokerLoad> brokerLoad;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<BrokerLoad> $lessinit$greater$default$10() {
        return KafkaRequestHandler$.MODULE$.$lessinit$greater$default$10();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public RequestLogFilter requestLogFilter() {
        return this.requestLogFilter;
    }

    public Option<BrokerLoad> brokerLoad() {
        return this.brokerLoad;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        this.brokerLoad().foreach((Function1 & Serializable & scala.Serializable)loadMetric -> {
            loadMetric.notifyOnThreadUsage("REQUEST", Predef$.MODULE$.double2Double(this.aggregateIdleMeter().oneMinuteRate()));
            return BoxedUnit.UNIT;
        });
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
            this.stop();
            return;
        }
        if (req instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)req;
            try {
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                    request.maybeSetRequestLog(this.requestLogFilter().processRequest(request.context(), request.startTimeNanos()), this.clusterId, this.brokerId);
                    this.apis.handle(request, this.requestLocal());
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                request.releaseBuffer();
            }
            return;
        }
        if (req == null) {
            return;
        }
        throw new MatchError((Object)req);
    }

    private void completeShutdown() {
        this.requestLocal().close();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, String clusterId, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, RequestLogFilter requestLogFilter, ApiRequestHandler apis, Time time, Option<BrokerLoad> brokerLoad) {
        this.id = id;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.requestLogFilter = requestLogFilter;
        this.apis = apis;
        this.time = time;
        this.brokerLoad = brokerLoad;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.stopped = false;
    }
}

