/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.BrokerLoad;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.DefaultRequestLogFilter;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandlerPool$;
import kafka.server.ThreadUsageMetrics$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0012$\u0001!B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"AQ\n\u0001B\u0001B\u0003%!\t\u0003\u0005O\u0001\t\u0015\r\u0011\"\u0001P\u0011!\u0019\u0006A!A!\u0002\u0013\u0001\u0006\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011A+\t\u0011q\u0003!\u0011!Q\u0001\nYC\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005?\"A1\r\u0001B\u0001B\u0003%A\r\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003Q\u0011!\t\bA!A!\u0002\u0013\u0011\u0005\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011a\u0002!Q1A\u0005\nMD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tu\u0002\u0011)\u0019!C\u0001w\"I\u0011Q\u0001\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011%\t\u0019\u0003\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0014\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA#\u0011%\ti\u0006\u0001b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA1\u0011%\tY\u0007\u0001b\u0001\n\u0003\ti\u0007\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA8\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!!&\u0001\t\u0003\t9\nC\u0004\u0002\u001e\u0002!\t!a(\b\u0013\u0005\u00056%!A\t\u0002\u0005\rf\u0001\u0003\u0012$\u0003\u0003E\t!!*\t\u000f\u0005\u001dq\u0004\"\u0001\u0002(\"I\u0011\u0011V\u0010\u0012\u0002\u0013\u0005\u00111\u0016\u0002\u0018\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d)p_2T!\u0001J\u0013\u0002\rM,'O^3s\u0015\u00051\u0013!B6bM.\f7\u0001A\n\u0005\u0001%zS\u0007\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aMj\u0011!\r\u0006\u0003e\u0015\nQ!\u001e;jYNL!\u0001N\u0019\u0003\u000f1{wmZ5oOB\u0011a'O\u0007\u0002o)\u0011\u0001(J\u0001\b[\u0016$(/[2t\u0013\tQtGA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\faaY8oM&<\u0007CA\u001f?\u001b\u0005\u0019\u0013BA $\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0013\rdWo\u001d;fe&#W#\u0001\"\u0011\u0005\rSeB\u0001#I!\t)5&D\u0001G\u0015\t9u%\u0001\u0004=e>|GOP\u0005\u0003\u0013.\na\u0001\u0015:fI\u00164\u0017BA&M\u0005\u0019\u0019FO]5oO*\u0011\u0011jK\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0013\u0001\u00032s_.,'/\u00133\u0016\u0003A\u0003\"AK)\n\u0005I[#aA%oi\u0006I!M]8lKJLE\rI\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m+\u00051\u0006CA,[\u001b\u0005A&BA-&\u0003\u001dqW\r^<pe.L!a\u0017-\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0006y!/Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u0003ba&\u001cX#A0\u0011\u0005u\u0002\u0017BA1$\u0005E\t\u0005/\u001b*fcV,7\u000f\u001e%b]\u0012dWM]\u0001\u0006CBL7\u000fI\u0001\u0005i&lW\r\u0005\u0002f]6\taM\u0003\u00023O*\u0011\u0001.[\u0001\u0007G>lWn\u001c8\u000b\u0005\u0019R'BA6m\u0003\u0019\t\u0007/Y2iK*\tQ.A\u0002pe\u001eL!a\u001c4\u0003\tQKW.Z\u0001\u000b]VlG\u000b\u001b:fC\u0012\u001c\u0018a\b:fcV,7\u000f\u001e%b]\u0012dWM]!wO&#G.Z'fiJL7MT1nK\u00061Bn\\4B]\u0012$\u0006N]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001u!\t)x/D\u0001w\u0015\tAt-\u0003\u0002ym\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0015\t\u0014xn[3s\u0019>\fG-F\u0001}!\rQSp`\u0005\u0003}.\u0012aa\u00149uS>t\u0007c\u0001\u001c\u0002\u0002%\u0019\u00111A\u001c\u0003\u0015\t\u0013xn[3s\u0019>\fG-A\u0006ce>\\WM\u001d'pC\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\r\u0002\f\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\u0001\"!\u0010\u0001\t\u000bm\u0012\u0002\u0019\u0001\u001f\t\u000b\u0001\u0013\u0002\u0019\u0001\"\t\u000b9\u0013\u0002\u0019\u0001)\t\u000bQ\u0013\u0002\u0019\u0001,\t\u000bu\u0013\u0002\u0019A0\t\u000b\r\u0014\u0002\u0019\u00013\t\u000bA\u0014\u0002\u0019\u0001)\t\u000bE\u0014\u0002\u0019\u0001\"\t\u000bI\u0014\u0002\u0019\u0001\"\t\u000ba\u0012\u0002\u0019\u0001;\t\u000fi\u0014\u0002\u0013!a\u0001y\u0006qA\u000f\u001b:fC\u0012\u0004vn\u001c7TSj,WCAA\u0014!\u0011\tI#a\u000f\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\ta!\u0019;p[&\u001c'\u0002BA\u0019\u0003g\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\t)$a\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u0016\u00055\tEo\\7jG&sG/Z4fe\u0006yA\u000f\u001b:fC\u0012\u0004vn\u001c7TSj,\u0007%\u0001\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014XCAA#!\u0011\t9%a\u0016\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nAaY8sK*\u0019\u0001(a\u0014\u000b\t\u0005E\u00131K\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005U\u0013aA2p[&!\u0011\u0011LA%\u0005\u0015iU\r^3s\u0003M\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:!\u0003m!\bN]3bIB|w\u000e\\\"ba\u0006\u001c\u0017\u000e^=TK:\u001cxN](qiV\u0011\u0011\u0011\r\t\u0005Uu\f\u0019\u0007E\u0002v\u0003KJ1!a\u001aw\u0005\u0019\u0019VM\\:pe\u0006aB\u000f\u001b:fC\u0012\u0004xn\u001c7DCB\f7-\u001b;z'\u0016t7o\u001c:PaR\u0004\u0013!\u0003:v]:\f'\r\\3t+\t\ty\u0007\u0005\u0004\u0002r\u0005m\u0014qP\u0007\u0003\u0003gRA!!\u001e\u0002x\u00059Q.\u001e;bE2,'bAA=W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002>\u0003\u0003K1!a!$\u0005MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003)\u0011XO\u001c8bE2,7\u000fI\u0001\u000eGJ,\u0017\r^3IC:$G.\u001a:\u0015\t\u0005-\u0015\u0011\u0013\t\u0004U\u00055\u0015bAAHW\t!QK\\5u\u0011\u0019\t\u0019j\u0007a\u0001!\u0006\u0011\u0011\u000eZ\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$B!a#\u0002\u001a\"1\u00111\u0014\u000fA\u0002A\u000bqA\\3x'&TX-\u0001\u0005tQV$Hm\\<o)\t\tY)A\fLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000fU8pYB\u0011QhH\n\u0003?%\"\"!a)\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132cU\u0011\u0011Q\u0016\u0016\u0004y\u0006=6FAAY!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m6&\u0001\u0006b]:|G/\u0019;j_:LA!a0\u00026\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final String clusterId;
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final Metrics metrics;
    private final Option<BrokerLoad> brokerLoad;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final Option<Sensor> threadpoolCapacitySensorOpt;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<BrokerLoad> $lessinit$greater$default$11() {
        return KafkaRequestHandlerPool$.MODULE$.$lessinit$greater$default$11();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ApiRequestHandler apis() {
        return this.apis;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Option<BrokerLoad> brokerLoad() {
        return this.brokerLoad;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    private Option<Sensor> threadpoolCapacitySensorOpt() {
        return this.threadpoolCapacitySensorOpt;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        DefaultRequestLogFilter requestLogFilter = new DefaultRequestLogFilter(this.config.newRequestLogFilter());
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.clusterId(), this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), requestLogFilter, this.apis(), this.time, this.brokerLoad()));
        KafkaThread.daemon((String)new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
        this.threadpoolCapacitySensorOpt().foreach((Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.record(100.0 * (double)newSize);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(KafkaConfig config, String clusterId, int brokerId, RequestChannel requestChannel, ApiRequestHandler apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix, Metrics metrics, Option<BrokerLoad> brokerLoad) {
        None$ none$;
        this.config = config;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        this.metrics = metrics;
        this.brokerLoad = brokerLoad;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        String string = requestHandlerAvgIdleMetricName;
        String string2 = "RequestHandlerAvgIdlePercent";
        if (string != null && string.equals(string2)) {
            Sensor sensor = metrics.sensor("TotalIoThreadsPercentage");
            sensor.add(ThreadUsageMetrics$.MODULE$.ioThreadPoolCapacityMetricName(metrics), (MeasurableStat)new Value());
            sensor.record(100.0 * (double)numThreads);
            none$ = new Some((Object)sensor);
        } else {
            none$ = None$.MODULE$;
        }
        this.threadpoolCapacitySensorOpt = none$;
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.createHandler(i));
    }
}

