/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.EndPoint;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.Defaults$;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$ClusterLinkReplication$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.QuotaType$Request$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class QuotaFactory$
implements Logging {
    public static QuotaFactory$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new QuotaFactory$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix) {
        Option clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class));
        None$ activeTenantsManager = this.isMultiTenant(cfg) ? Option$.MODULE$.apply((Object)new ActiveTenantsManager(metrics, time, BrokerBackpressureConfig$.MODULE$.DefaultActiveWindowMs())) : None$.MODULE$;
        ClientQuotaManager produceQuotaManager = new ClientQuotaManager(this.clientConfig(cfg, QuotaType$Produce$.MODULE$), metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager);
        ReplicationQuotaManager followerQuotaManager = new ReplicationQuotaManager(this.replicationConfig(cfg, QuotaType$FollowerReplication$.MODULE$), metrics, QuotaType$FollowerReplication$.MODULE$, time);
        ReplicationQuotaManager clusterLinkQuotaManager = new ReplicationQuotaManager(this.clusterLinkReplicationConfig(cfg), metrics, QuotaType$ClusterLinkReplication$.MODULE$, time);
        produceQuotaManager.addQuotaRecordListener((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)value -> {
            block5: {
                block7: {
                    ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode;
                    ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode2;
                    block6: {
                        if (!Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable())) break block5;
                        clusterLinkQuotaMode2 = cfg.clusterLinkQuotaMode();
                        clusterLinkQuotaMode = ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND;
                        if (clusterLinkQuotaMode2 != null) break block6;
                        if (clusterLinkQuotaMode != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!clusterLinkQuotaMode2.equals(clusterLinkQuotaMode)) break block5;
                }
                clusterLinkQuotaManager.record((long)value);
            }
        });
        DiskUsageBasedThrottler$.MODULE$.registerListener(produceQuotaManager);
        DiskUsageBasedThrottler$.MODULE$.registerListener(followerQuotaManager);
        if (Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable())) {
            DiskUsageBasedThrottler$.MODULE$.registerListener(clusterLinkQuotaManager);
        }
        produceQuotaManager.initThrottler();
        return new QuotaFactory.QuotaManagers(new ClientQuotaManager(this.clientConfig(cfg, QuotaType$Fetch$.MODULE$), metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), produceQuotaManager, new ClientRequestQuotaManager(this.clientConfig(cfg, QuotaType$Request$.MODULE$), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ControllerMutationQuotaManager(this.clientControllerMutationConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback), new ReplicationQuotaManager(this.replicationConfig(cfg, QuotaType$LeaderReplication$.MODULE$), metrics, QuotaType$LeaderReplication$.MODULE$, time), followerQuotaManager, new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), clusterLinkQuotaManager, (Option<ClientQuotaCallback>)clientQuotaCallback);
    }

    public DiskUsageBasedThrottlingConfig diskThrottleConfig(KafkaConfig cfg) {
        Long freeDiskThresholdBytes = cfg.getLong("confluent.backpressure.disk.free.threshold.bytes");
        Long throttledProduceThroughput = cfg.getLong("confluent.backpressure.disk.produce.bytes.per.second");
        Boolean enableDiskThrottling = cfg.getBoolean("confluent.backpressure.disk.enable");
        Double recoveryFactor = cfg.getDouble("confluent.backpressure.disk.threshold.recovery.factor");
        long x$1 = Predef$.MODULE$.Long2long(freeDiskThresholdBytes);
        long x$2 = Predef$.MODULE$.Long2long(throttledProduceThroughput);
        Seq<String> x$3 = cfg.logDirs();
        boolean x$4 = Predef$.MODULE$.Boolean2boolean(enableDiskThrottling);
        double x$5 = Predef$.MODULE$.Double2double(recoveryFactor);
        boolean x$6 = Predef$.MODULE$.Boolean2boolean(cfg.clusterLinkEnable());
        long x$7 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5();
        return DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$1, x$2, x$3, x$4, x$7, x$5, x$6);
    }

    public ClientQuotaManagerConfig clientConfig(KafkaConfig cfg, QuotaType quotaType) {
        DiskUsageBasedThrottlingConfig diskThrottlingConfig;
        if (!new .colon.colon((Object)QuotaType$Produce$.MODULE$, (List)new .colon.colon((Object)QuotaType$Fetch$.MODULE$, (List)new .colon.colon((Object)QuotaType$Request$.MODULE$, (List)Nil$.MODULE$))).contains((Object)quotaType)) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected quota type: ").append(quotaType).toString());
        }
        QuotaType quotaType2 = quotaType;
        QuotaType$Produce$ quotaType$Produce$ = QuotaType$Produce$.MODULE$;
        DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig = !(quotaType2 != null ? !quotaType2.equals(quotaType$Produce$) : quotaType$Produce$ != null) ? this.diskThrottleConfig(cfg) : (diskThrottlingConfig = DiskUsageBasedThrottlingConfig$.MODULE$.apply(DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$2(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7()));
        double d = QuotaType$Produce$.MODULE$.equals(quotaType) ? (double)Predef$.MODULE$.Long2long(cfg.getLong("confluent.broker.limit.producer.bytes.per.second")) : (QuotaType$Fetch$.MODULE$.equals(quotaType) ? (double)Predef$.MODULE$.Long2long(cfg.getLong("confluent.broker.limit.consumer.bytes.per.second")) : 9.223372036854776E18);
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()), this.brokerBackpressureConfig(cfg, quotaType), diskThrottlingConfig, d);
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg, QuotaType quotaType) {
        long l = QuotaType$LeaderReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationLeaderThrottleRate() : (QuotaType$FollowerReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationFollowerThrottleRate() : Defaults$.MODULE$.QuotaBytesPerSecond());
        boolean bl = QuotaType$LeaderReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationLeaderReplicasAreThrottled() : (QuotaType$FollowerReplication$.MODULE$.equals(quotaType) ? cfg.ReplicationFollowerReplicasAreThrottled() : false);
        return new ReplicationQuotaManagerConfig(l, Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds()), bl);
    }

    public ClientQuotaManagerConfig clientControllerMutationConfig(KafkaConfig cfg) {
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Integer2int(cfg.numControllerQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.controllerQuotaWindowSizeSeconds()), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5());
    }

    public ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        int x$1 = Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples());
        int x$2 = Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds());
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        boolean x$4 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$4();
        return new ReplicationQuotaManagerConfig(x$3, x$1, x$2, x$4);
    }

    public ReplicationQuotaManagerConfig clusterLinkReplicationConfig(KafkaConfig cfg) {
        Long bytesPerSecond = cfg.getLong(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp());
        return new ReplicationQuotaManagerConfig(Predef$.MODULE$.Long2long(bytesPerSecond), Predef$.MODULE$.Integer2int(cfg.numClusterLinkReplicationQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.clusterLinkReplicationQuotaWindowSizeSeconds()), !BoxesRunTime.equalsNumObject((Number)bytesPerSecond, (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)));
    }

    public boolean isMultiTenant(KafkaConfig cfg) {
        return ((String)Option$.MODULE$.apply((Object)cfg.originalsStrings().get(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).contains("io.confluent.kafka.multitenant.quota.TenantQuotaCallback");
    }

    public boolean backpressureEnabledInConfig(KafkaConfig cfg, QuotaType quotaType) {
        return this.isMultiTenant(cfg) && Option$.MODULE$.apply((Object)cfg.getString("confluent.backpressure.types")).exists((Function1 & Serializable & scala.Serializable)backpressureTypeProp -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$backpressureEnabledInConfig$1(quotaType, backpressureTypeProp)));
    }

    public BrokerBackpressureConfig brokerBackpressureConfig(KafkaConfig cfg, QuotaType quotaType) {
        String string;
        Nil$ nil$;
        boolean backpressureEnabled = this.backpressureEnabledInConfig(cfg, quotaType);
        if (QuotaType$Request$.MODULE$.equals(quotaType)) {
            Seq listeners = ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ConfluentConfigs.multitenantListenerNames((AbstractConfig)cfg, (ListenerName)cfg.interBrokerListenerName())).asScala()).filter((Function1 & Serializable & scala.Serializable)listenerName -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$brokerBackpressureConfig$1(cfg, listenerName)))).toSeq();
            if (listeners.isEmpty() && backpressureEnabled && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(QuotaFactory$.$anonfun$brokerBackpressureConfig$3()));
            }
            nil$ = listeners;
        } else {
            nil$ = Nil$.MODULE$;
        }
        double x$3 = Predef$.MODULE$.Integer2int(cfg.queuedMaxRequests());
        double minRequestQuota = Predef$.MODULE$.Long2long(cfg.getLong("confluent.backpressure.request.min.broker.limit"));
        double x$4 = package$.MODULE$.max(minRequestQuota, BrokerBackpressureConfig$.MODULE$.MinBrokerRequestQuota());
        String percentileStr = cfg.getString("confluent.backpressure.request.queue.size.percentile");
        if (RequestQueueSizePercentiles$.MODULE$.valid(percentileStr)) {
            string = percentileStr;
        } else {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(QuotaFactory$.$anonfun$brokerBackpressureConfig$4(percentileStr)));
            }
            string = "p95";
        }
        String x$5 = string;
        long x$6 = BrokerBackpressureConfig$.MODULE$.apply$default$2();
        return new BrokerBackpressureConfig(backpressureEnabled, x$6, (Seq<String>)nil$, x$3, x$4, x$5);
    }

    public static final /* synthetic */ boolean $anonfun$backpressureEnabledInConfig$2(QuotaType quotaType$1, String backpressureType) {
        String string = backpressureType;
        String string2 = quotaType$1.toString().toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$backpressureEnabledInConfig$1(QuotaType quotaType$1, String backpressureTypeProp) {
        return CoreUtils$.MODULE$.parseCsvList(backpressureTypeProp).exists((Function1 & Serializable & scala.Serializable)backpressureType -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$backpressureEnabledInConfig$2(quotaType$1, backpressureType)));
    }

    public static final /* synthetic */ boolean $anonfun$brokerBackpressureConfig$2(String listenerName$1, EndPoint endpoint) {
        String string = endpoint.listenerName().value();
        return !(string != null ? !string.equals(listenerName$1) : listenerName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$brokerBackpressureConfig$1(KafkaConfig cfg$2, String listenerName) {
        return cfg$2.advertisedListeners().exists((Function1 & Serializable & scala.Serializable)endpoint -> BoxesRunTime.boxToBoolean((boolean)QuotaFactory$.$anonfun$brokerBackpressureConfig$2(listenerName, endpoint)));
    }

    public static final /* synthetic */ String $anonfun$brokerBackpressureConfig$3() {
        return "Invalid multitenant listener names provided in config. Request backpressure will be disabled";
    }

    public static final /* synthetic */ String $anonfun$brokerBackpressureConfig$4(String percentileStr$1) {
        return new StringBuilder(85).append("Invalid ").append("confluent.backpressure.request.queue.size.percentile").append("=`").append(percentileStr$1).append("`. Using default `").append("p95").append("`.").toString();
    }

    private QuotaFactory$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

