/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.Defaults$;
import kafka.server.ReplicationQuotaManagerConfig;
import org.apache.kafka.common.config.ConfigDef;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.runtime.BoxesRunTime;

public final class ReplicationQuotaManagerConfig$
implements Serializable {
    public static ReplicationQuotaManagerConfig$ MODULE$;
    private final String NoThrottledReplicasValue;
    private final String AllThrottledReplicasValue;
    private final int InactiveSensorExpirationTimeSeconds;
    private final String LeaderReplicationThrottledRateProp;
    private final String FollowerReplicationThrottledRateProp;
    private final String LeaderReplicationThrottledReplicasProp;
    private final String FollowerReplicationThrottledReplicasProp;
    private final Set<String> ReconfigurableConfigs;

    static {
        new ReplicationQuotaManagerConfig$();
    }

    public long $lessinit$greater$default$1() {
        return Defaults$.MODULE$.QuotaBytesPerSecond();
    }

    public int $lessinit$greater$default$2() {
        return Defaults$.MODULE$.DefaultNumQuotaSamples();
    }

    public int $lessinit$greater$default$3() {
        return Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public String NoThrottledReplicasValue() {
        return this.NoThrottledReplicasValue;
    }

    public String AllThrottledReplicasValue() {
        return this.AllThrottledReplicasValue;
    }

    public int InactiveSensorExpirationTimeSeconds() {
        return this.InactiveSensorExpirationTimeSeconds;
    }

    public String LeaderReplicationThrottledRateProp() {
        return this.LeaderReplicationThrottledRateProp;
    }

    public String FollowerReplicationThrottledRateProp() {
        return this.FollowerReplicationThrottledRateProp;
    }

    public String LeaderReplicationThrottledReplicasProp() {
        return this.LeaderReplicationThrottledReplicasProp;
    }

    public String FollowerReplicationThrottledReplicasProp() {
        return this.FollowerReplicationThrottledReplicasProp;
    }

    public Set<String> ReconfigurableConfigs() {
        return this.ReconfigurableConfigs;
    }

    public boolean allReplicasThrottled(String throttledReplicas) {
        return this.AllThrottledReplicasValue().equals(throttledReplicas);
    }

    public ConfigDef.Validator throttledReplicasValidator() {
        return ConfigDef.ValidString.in((String[])new String[]{this.NoThrottledReplicasValue(), this.AllThrottledReplicasValue()});
    }

    public ReplicationQuotaManagerConfig apply(long quotaBytesPerSecond, int numQuotaSamples, int quotaWindowSizeSeconds, boolean allReplicasThrottled) {
        return new ReplicationQuotaManagerConfig(quotaBytesPerSecond, numQuotaSamples, quotaWindowSizeSeconds, allReplicasThrottled);
    }

    public long apply$default$1() {
        return Defaults$.MODULE$.QuotaBytesPerSecond();
    }

    public int apply$default$2() {
        return Defaults$.MODULE$.DefaultNumQuotaSamples();
    }

    public int apply$default$3() {
        return Defaults$.MODULE$.DefaultQuotaWindowSizeSeconds();
    }

    public boolean apply$default$4() {
        return false;
    }

    public Option<Tuple4<Object, Object, Object, Object>> unapply(ReplicationQuotaManagerConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToLong((long)x$0.quotaBytesPerSecond()), (Object)BoxesRunTime.boxToInteger((int)x$0.numQuotaSamples()), (Object)BoxesRunTime.boxToInteger((int)x$0.quotaWindowSizeSeconds()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.allReplicasThrottled())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReplicationQuotaManagerConfig$() {
        MODULE$ = this;
        this.NoThrottledReplicasValue = "none";
        this.AllThrottledReplicasValue = "*";
        this.InactiveSensorExpirationTimeSeconds = 3600;
        this.LeaderReplicationThrottledRateProp = "leader.replication.throttled.rate";
        this.FollowerReplicationThrottledRateProp = "follower.replication.throttled.rate";
        this.LeaderReplicationThrottledReplicasProp = "leader.replication.throttled.replicas";
        this.FollowerReplicationThrottledReplicasProp = "follower.replication.throttled.replicas";
        this.ReconfigurableConfigs = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.LeaderReplicationThrottledReplicasProp(), this.LeaderReplicationThrottledRateProp(), this.FollowerReplicationThrottledReplicasProp(), this.FollowerReplicationThrottledRateProp()}));
    }
}

